package ibase.dashboard.common.webService;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;

import ibase.dashboard.common.hibernate.dao.AccountActivityDao;
import ibase.utility.BaseException;
import ibase.utility.UserInfoBean;

@Path("/accountActivity")
public class AccountActivityService {
	   @Context
	   HttpServletRequest request; // The proxy of Request will be injected into this singleton

	
	   private AccountActivityDao accountActivityDao = new AccountActivityDao();

	   @GET 
	   @Path("/") 
	   @Produces(MediaType.APPLICATION_JSON) 
	   public String getLog() throws Exception {
		   HttpSession session = request.getSession();	
		   Object userObj = session.getAttribute( "USER_INFO" ); 
		   String userId = "" ;
		   String profileId="";
		   System.out.println(" userObj >>[" + userObj + "]" );
			if(userObj != null)
			{
				UserInfoBean userInfo;
				try {
					userInfo = new UserInfoBean( userObj.toString() );
					userId = userInfo.getLoginCode();
					profileId = userInfo.getProfileId();
					System.out.println(" userInfo >>[" + userId + "] profile Id ["+profileId+"]" );
				} catch (BaseException e) {
					e.printStackTrace();
				}
			}
		   
		   String logDetails = accountActivityDao. getUserActivityData(userId,profileId); 
  		   return logDetails;
	   }  
}