/*
 * Added by Abhishek T. on 06-OCT-2016
 * For calling AttachmentsPlugin.
 */

/**
 * Initialize the AttachmentsPlugin for given data and return the
 * plugin ui element.
 * 
 * @param data The required data for creating attachments plugin.
 * 
 * @returns The generated plugin ui element. 
 */
function getAttachmentsPluginUI(data)
{
	var viewUIElement = null;
	try
	{
		var pWindow = window;
		if (! window.e12plugin)
		{
			pWindow = window.parent;
			// Changed by Abhishek T on 23-Feb-17 [For checking plugin defination is present or not in current browser document] START
			if (! pWindow.e12plugin) return null;
			// Changed by Abhishek T on 23-Feb-17 [For checking plugin defination is present or not in current browser document] END
		}
		
		if (! data) throw "Given data is null.";
		
		var MetadataKey        = pWindow.e12plugin.enums.MetadataKey,
			MetadataValue      = pWindow.e12plugin.metadata.MetadataValue,
			PluginMetadata     = pWindow.e12plugin.metadata.PluginMetadata,
			AttachmentsPlugin  = pWindow.e12plugin.plugins.AttachmentsPlugin,
			Layout             = pWindow.e12plugin.enums.Layout,
			Widget             = pWindow.e12plugin.gwtwidgets.Widget,
			HandlerType        = pWindow.e12plugin.enums.HandlerType,
			metadata           = new PluginMetadata(),
			ContentType        = pWindow.e12plugin.enums.ContentType;
		
		metadata.put(MetadataKey.OBJ_NAME, new MetadataValue(data.OBJ_NAME));
		metadata.put(MetadataKey.REF_SERIES, new MetadataValue(data.REF_SER));
		metadata.put(MetadataKey.REF_ID, new MetadataValue(data.REF_ID));
		metadata.put(MetadataKey.DOC_TYPE, new MetadataValue(data.DOC_TYPE));
		metadata.put(MetadataKey.HOST_URL, new MetadataValue(data.HOST_URL));
		metadata.put(MetadataKey.ENABLE_SIGNLE_IMAGE, new MetadataValue(data.ENABLE_SINGLE_IMAGE));
		
		if (data.MIN_REQUIRED)
			metadata.put(MetadataKey.MIN_REQUIRED, new MetadataValue(data.MIN_REQUIRED));
		if (data.MAX_ALLOWED)
			metadata.put(MetadataKey.MAX_ALLOWED, new MetadataValue(data.MAX_ALLOWED));
		
		var layout = data.LAYOUT === 'F' ? Layout.FULLVIEW : Layout.THUMBNAIL;
		
		metadata.put(MetadataKey.LAYOUT, new MetadataValue(layout));
		metadata.put(MetadataKey.THUMBNAIL_WIDTH, new MetadataValue(data.THUMBNAIL_WIDTH));
		metadata.put(MetadataKey.THUMBNAIL_HEIGHT, new MetadataValue(data.THUMBNAIL_HEIGHT));
		metadata.put(MetadataKey.IS_HOSTED_MODE, new MetadataValue(!! data.IS_HOSTED_MODE));
		
		if (data.CONTENT_TYPE && data.CONTENT_TYPE instanceof Array)
			metadata.put(MetadataKey.CONTENT_TYPE, new MetadataValue(data.CONTENT_TYPE));
		
		attchPlugin = new AttachmentsPlugin();
		attchPlugin.init(metadata);
		
		var viewUI = null;
		if (data.UI)
			if (data.UI === 'A')
				viewUI = attchPlugin.getAddUI();
			else if (data.UI === 'E')
				viewUI = attchPlugin.getEditUI();
			else // if data.UI === 'V' No need to check here
				viewUI = attchPlugin.getViewUI();
		else // else default UI
			viewUI = attchPlugin.getViewUI();
		
		var widget = new Widget(viewUI);
		var width = data.MAX_WIDTH ? data.MAX_WIDTH : "95%";
		widget.setWidth(width);
		
		viewUIElement = widget.getElement();
	}
	catch (ex)
	{
		window.alert("Exception in getAttachmentsPluginUI() : " + ex);
	}
	
	return viewUIElement;
}

/**
 * Show attachments plugin for given object name, ref series and ref id.
 * 
 * @param elemId The id of element in which attachments should shown.
 * @param objName The object name.
 * @param refSer The reference series.
 * @param refId The reference id.
 */
function showAttachmentsPlugin(elemId, objName, refSer, refId)
{
	try
	{
		// Added by Abhishek T on 23-Feb-17 [For checking plugin defination is present or not in current browser document] START
		var pWindow = window.parent;
		if (! pWindow.e12plugin)
			return;
		// Added by Abhishek T on 23-Feb-17 [For checking plugin defination is present or not in current browser document] END
		
		// for getting host url
		// required in mobile devices.
		var isHostedMode = false;
		if (! window._getHostURL)
		{
			isHostedMode = true;
			window._getHostURL = function() { return ""; };
		}
		var hostUrl = window._getHostURL()
		hostUrl = hostUrl ? hostUrl : "";
		
		var data =
		{
			OBJ_NAME : objName,
			REF_SER : refSer,
			REF_ID : refId,
			HOST_URL : hostUrl,
			DOC_TYPE : "",
			UI : "V",
			THUMBNAIL_WIDTH : "40px",
			THUMBNAIL_HEIGHT : "40px",
			MAX_WIDTH : "90%",
			IS_HOSTED_MODE : isHostedMode
		}
		
		var attView = window.getAttachmentsPluginUI(data);
		var elem = document.getElementById(elemId);
		
		if (elem)
		{
			elem.innerHTML = "";
			elem.appendChild(attView);
		}
	}
	catch (ex)
	{
		window.alert("Exception in showAttachmentsPlugin [" + ex + "]");
	}
}


/**
 * Initialize the ContentPlugin for given data and return the
 * plugin ui element.
 * 
 * @param data The required data for creating contents plugin.
 * 
 * @returns The generated plugin ui element. 
 */

function getContentPluginUI(data, caller, callback)
{
	var viewUIElement = null;
	try
	{
		var pWindow = window;
		if (! window.e12plugin)
		{
			pWindow = window.parent;
			if (! pWindow.e12plugin) return null;
		}
		
		if (! data) throw "Given data is null.";
		
		var MetadataKey        = pWindow.e12plugin.enums.MetadataKey,
			MetadataValue      = pWindow.e12plugin.metadata.MetadataValue,
			PluginMetadata     = pWindow.e12plugin.metadata.PluginMetadata,
			ContentPlugin      = pWindow.e12plugin.plugins.ContentPlugin,
			Layout             = pWindow.e12plugin.enums.Layout,
			Widget             = pWindow.e12plugin.gwtwidgets.Widget,
			HandlerType        = pWindow.e12plugin.enums.HandlerType,
			metadata           = new PluginMetadata(),
			ContentType        = pWindow.e12plugin.enums.ContentType;
		
		metadata.put(MetadataKey.USER_ID, new MetadataValue(data.USER_ID));
		metadata.put(MetadataKey.IS_PROFILE_IMAGE, new MetadataValue(data.IS_PROFILE_IMAGE));
		metadata.put(MetadataKey.IS_HOSTED_MODE, new MetadataValue(!! data.IS_HOSTED_MODE));
		metadata.put(MetadataKey.HOST_URL, new MetadataValue(data.HOST_URL));

		console.log( HandlerType.DONE_HANDLER );
		contentPlugin = new ContentPlugin();
		contentPlugin.init(metadata);
		contentPlugin.addHandler(function(contentData) {
			console.log("On DONE_HANDLER : caller >> [" + Object.keys(caller) + "] ");
			console.log("callback >> [" + callback + " = " +  caller[callback] + "] ");
			try
			{
				caller[callback]();
			}
			catch(e)
			{  
				console.log(' caller[callback]()' + e); 
			}
		}, HandlerType.DONE_HANDLER);

		var viewUI = contentPlugin.getAddUI();
		var widget = new Widget(viewUI);
		var width = data.MAX_WIDTH ? data.MAX_WIDTH : "95%";
		widget.setWidth(width);
		
		viewUIElement = widget.getElement();
	}
	catch (ex)
	{
		window.alert("Exception *********** in getContentPluginUI() : " + ex);
	}
	
	return viewUIElement;
}


function getImagePluginUI(data, caller, callback)
{
	try
	{
		var pWindow = window;
		if (! window.e12plugin)
		{
			console.log(' window.e12plugin not loaded'); 
			pWindow = window.parent;
			// Changed by Abhishek T on 23-Feb-17 [For checking plugin defination is present or not in current browser document] START
			if (! pWindow.e12plugin)
			{
				console.log('parent Window.e12plugin not loaded'); 
				return null;
			} 
			// Changed by Abhishek T on 23-Feb-17 [For checking plugin defination is present or not in current browser document] END
		}
		
		if (! data) throw "Given data is null.";
		
		var MetadataKey        = pWindow.e12plugin.enums.MetadataKey,
			MetadataValue      = pWindow.e12plugin.metadata.MetadataValue,
			PluginMetadata     = pWindow.e12plugin.metadata.PluginMetadata,
			AttachmentsPlugin  = pWindow.e12plugin.plugins.AttachmentsPlugin,
			metadata           = new PluginMetadata();
		
		metadata.put(MetadataKey.OBJ_NAME, new MetadataValue(data.OBJ_NAME));
		metadata.put(MetadataKey.REF_SERIES, new MetadataValue(data.REF_SER));
		metadata.put(MetadataKey.REF_ID, new MetadataValue(data.REF_ID));
		metadata.put(MetadataKey.DOC_TYPE_ATTACH_FILTER, new MetadataValue(data.DOC_TYPE));
		metadata.put(MetadataKey.HOST_URL, new MetadataValue(data.HOST_URL));
		metadata.put(MetadataKey.ENABLE_SINGLE_IMAGE, new MetadataValue(data.ENABLE_SINGLE_IMAGE));
		metadata.put(MetadataKey.IS_HOSTED_MODE, new MetadataValue(!! data.IS_HOSTED_MODE));
		//
		metadata.put(MetadataKey.VIEW_ONLY, new MetadataValue(true));
		
		attchPlugin = new AttachmentsPlugin();
		attchPlugin.init(metadata);

		attchPlugin.requestImageArray(function(imgArr) {
			
			console.log("On requestImageArray : imgArr["+imgArr+"]");
			//console.log("callback >> [" + callback + " = " +  caller[callback] + "] ");
			try
			{
				caller[callback](imgArr);
			}
			catch(e)
			{  
				console.log(' caller[callback]()' + e); 
			}
        });
		
	}
	catch (ex)
	{
		console.log("Exception in getImagePluginUI() : " , ex);
	}
}


// left: 37, up: 38, right: 39, down: 40,
// spacebar: 32, pageup: 33, pagedown: 34, end: 35, home: 36
var keys = {37: 1, 38: 1, 39: 1, 40: 1};

function preventDefault(e) {
  e = e || window.event;
  if (e.preventDefault)
      e.preventDefault();
  e.returnValue = false;  
}

function preventDefaultForScrollKeys(e) {
    if (keys[e.keyCode]) {
        preventDefault(e);
        return false;
    }
}

function disableScroll() {
  /*
  if (window.addEventListener) // older FF
      window.addEventListener('DOMMouseScroll', preventDefault, false);
  window.onwheel = preventDefault; // modern standard
  window.onmousewheel = document.onmousewheel = preventDefault; // older browsers, IE
  window.ontouchmove  = preventDefault; // mobile
  document.onkeydown  = preventDefaultForScrollKeys;
  */
  document.body.style.overflow = 'hidden';
}

function enableScroll() {
  /*
    if (window.removeEventListener)
        window.removeEventListener('DOMMouseScroll', preventDefault, false);
    window.onmousewheel = document.onmousewheel = null; 
    window.onwheel = null; 
    window.ontouchmove = null;  
    document.onkeydown = null;  
    */
  document.body.style.overflow = 'visible';
}
