import { Injectable } from '@angular/core';
import { Effect, Actions } from '@ngrx/effects';

import { AppState } from '../reducers';
import { MenuActions } from '../actions';
import { EcmCategoryService } from '../../ecm-view/ecm-category/ecm-category.service';

@Injectable()
export class MenuEffects {
    constructor (
        private update$: Actions,
        private menuActions: MenuActions,
        private svc: EcmCategoryService,
    ) {}

    @Effect() loadCategories$ = this.update$
        .ofType(MenuActions.LOAD_MENU)
        .switchMap(() => this.svc.getSideOptions())
        .map(categories => this.menuActions.loadMenuSuccess(categories));
    
}
