package proteus.ecm.hibernate.bean;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlRootElement;

import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.json.JSONObject;

@Indexed
@Entity
@Table(name = "ECMPARM")
@XmlRootElement(name = "ecmparm")
public class ECMParm  implements java.io.Serializable  {

	@Id
	@Field(store = Store.YES, analyze = Analyze.NO)
	@Column(name="VAR_NAME")
	private String varName;
	
	@Column(name="VAR_TYPE")
	private String varType;
    
	@Column(name="VAR_VALUE")
	private String varValue;
   
	@Column(name="DESCR")
	private String varDescr;

	public ECMParm() {
		
	}

	public ECMParm(String varName, String varType, String varValue, String varDescr) {
		super();
		this.varName = varName;
		this.varType = varType;
		this.varValue = varValue;
		this.varDescr = varDescr;
	}

	public String getVarName() {
		return varName;
	}

	public String getVarType() {
		return varType;
	}

	public String getVarValue() {
		return varValue;
	}

	public String getVarDescr() {
		return varDescr;
	}

	public void setVarName(String varName) {
		this.varName = varName;
	}

	public void setVarType(String varType) {
		this.varType = varType;
	}

	public void setVarValue(String varValue) {
		this.varValue = varValue;
	}

	public void setVarDescr(String varDescr) {
		this.varDescr = varDescr;
	}
	
	@Override
	public String toString(){
		return "\n ECMParm.toString >> [" + new JSONObject(this).toString() + "]";
	}
}
