import { Component, ViewEncapsulation, Input, Output, EventEmitter, forwardRef } from '@angular/core';
import { FormControl } from '@angular/forms';
import 'rxjs/add/observable/interval';
import 'rxjs/add/operator/startWith';
import 'rxjs/add/operator/map';
import "rxjs/Rx";
import { BBAutosuggestService } from './bb-autosuggest.service';
import { ValueAccessorBase } from '../form';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
export class BBAutosuggestComponent extends ValueAccessorBase {
    constructor(autoSuggestService) {
        super();
        this.autoSuggestService = autoSuggestService;
        this.uxDesign = 'UX3'; //UX1 - Simple, UX2 - Flat, UX3 - Material
        this.bbPlaceholder = ''; // Placeholder to Input Field
        this.bbchipEnable = false; //Whether to show Chiplist or not default : false
        this.duplicateAllow = false; // Whether to Add duplicate data in Chiplist default : false
        this.minlength = 3; // Min. characters to enter for Data filter and Make request to dataSourceURL default : 3
        this.refId = 'autosuggest-1'; //Set Hidden element id 
        this.onSelectionChange = new EventEmitter(); //after
        this.onClear = new EventEmitter();
        this.chipData = []; // {'displayText' : '' , 'value' : '', 'image' : ''}
        this.suggestData = []; // {'displayText' : '' , 'value' : '', 'image' : ''}
        this.isPaste = false;
        console.log("In constructor  --> --> ", this.bbchipEnable);
        this.suggestCtrl = new FormControl();
    }
    // data = {'displayText' : '' , 'value' : '', 'image' : ''}
    add(value) {
        this.chipToDelete = '';
        console.log('add(value)', value, this.chipValue, value.trim());
        console.log("In Add method and onSelectionChange --> --> ", this.bbchipEnable);
        if (this.bbchipEnable && value && value.trim()) {
            console.log("this.suggestData in add method", this.suggestData);
            let data = this.suggestData.find(suggestDataObj => suggestDataObj.value.toLowerCase() === value.toLowerCase());
            console.log('add(value).find', data, this.duplicateAllow);
            console.log('chipData.find', data, this.chipData);
            if (!data) {
                this.chipValue = "";
                return;
            }
            if (this.duplicateAllow) {
                this.chipValue = "";
                this.chipData.push(data);
            }
            else if (this.chipData.find(chipDataObj => chipDataObj.value.toLowerCase() === value.toLowerCase())) {
                console.log("chip already exist");
                this.chipValue = "";
            }
            else {
                console.log("this.duplicateAllow in else ", this.chipValue);
                this.chipValue = "";
                this.chipData.push(data);
            }
            this.chipValue = "";
        }
        else if (value && value.trim()) {
            console.log("this.suggestData in 2nd add method", this.suggestData);
            /*   let sugData = this.suggestData.find( selectedObj => selectedObj.value.toLowerCase() === value.toLowerCase() );
               let selectData = sugData.Details.find( address => address.custCode.toLowerCase() === value.toLowerCase());
               console.log("selectData ------->",selectData);
           /*  let selectedData = this.suggestData.find( selectedObj => selectedObj.value.toLowerCase() === value.toLowerCase() ).Details.find( address => address.custCode.toLowerCase() === value.toLowerCase());  */
            let selectedData = this.suggestData.find(suggestDataObj => suggestDataObj.value.toLowerCase() === value.toLowerCase());
            if (selectedData) {
                this.onSelectionChange.emit(selectedData.detail); //onSelectionChange
            }
        }
    }
    removeByKey(value) {
        console.log(value);
        if (!value) {
            console.log('this.chipData.length', this.chipData.length);
            if (this.chipData.length > 0) {
                let len = this.chipData.length;
                console.log('this.chipToDelete', len, this.chipToDelete);
                if (this.chipToDelete) {
                    this.chipData.pop();
                    this.chipToDelete = '';
                }
                else {
                    this.chipToDelete = this.chipData[len - 1].value;
                    console.log('this.chipToDelete', len, this.chipToDelete);
                }
            }
        }
    }
    remove(chipDataObj) {
        this.chipToDelete = '';
        let idx = this.chipData.indexOf(chipDataObj);
        let delObj = this.chipData.splice(idx, 1);
        console.log('chipDataObj', idx, delObj);
    }
    ngOnInit() {
        console.log('typeof ', typeof this.dataSource, this.dataSource);
        console.log('Array.isArraye ', Array.isArray(this.dataSource), this.dataSource);
        if (typeof this.dataSource == 'string') {
            this.suggestCtrl.valueChanges.debounceTime(100).subscribe(data => {
                console.log('data > [' + data + ']');
                if (data == '') {
                    console.log('data77777988 > [' + data + ']');
                    this.onClear.emit();
                }
                if (data && !this.isPaste) {
                    //console.log( 'data > ', data.trim().length );
                    if (data.trim().length < this.minlength)
                        return;
                    //  let dataSourceURL = this.dataSource + '/'+data.trim();;  //saitej
                    let dataSourceURL = this.dataSource;
                    //    let dataSourceURL = this.dataSource + "&refid=" + this.refId + "&" + this.refId + "=" + data;
                    console.log('dataSourceURL After append ', dataSourceURL);
                    this.autoSuggestService.getChipListData(dataSourceURL).subscribe(serviceData => {
                        console.log('serviceData > ', serviceData);
                        this.suggestData = serviceData;
                        console.log('final data of url > ', this.suggestData);
                    });
                }
                else {
                    this.suggestData = [];
                }
            });
        }
        else if (typeof this.dataSource == 'object') {
            this.suggestData = this.dataSource;
            console.log("suggestData", this.suggestData);
            this.suggestFormattedData = this.autoSuggestService.transformData(this.suggestData);
            this.suggestData = this.suggestFormattedData;
            console.log("suggestFormattedData", this.suggestFormattedData);
            if (this.suggestFormattedData)
                this.filteredSuggestions = this.suggestCtrl.valueChanges.startWith(null).map(data => {
                    //console.log('suggestCtrl.valueChanges.startWith', data);
                    return data ? this.filterData(data) : this.suggestFormattedData.slice();
                });
        }
    }
    filterData(value) {
        //console.log('final data of static data', value);
        return this.suggestFormattedData.filter(data => {
            return data.displayChipText.toLowerCase().indexOf(value.toLowerCase()) === 0;
        });
    }
    log(d) {
        console.log(d);
    }
    validateData(evt) {
        this.isPaste = true;
        let clipBoardData = evt.clipboardData.getData('Text');
        console.log('clipBoardData', clipBoardData);
        let dataSourceURL = this.dataSource + "&refid=list&list=" + clipBoardData;
        this.autoSuggestService.getChipListData(dataSourceURL).subscribe(serviceData => {
            console.log('serviceData > ', serviceData);
            //Create Valid and Invalid Chips
            //
            for (let suggestObj of serviceData) {
                if (this.duplicateAllow) {
                    this.chipValue = "";
                    this.chipData.push(suggestObj);
                    this.chipValue = "";
                }
                else if (this.chipData.find(chipDataObj => chipDataObj.value.toLowerCase() === suggestObj.value.toLowerCase())) {
                    console.log("chip already exist");
                }
                else {
                    this.chipValue = "";
                    this.chipData.push(suggestObj);
                    this.chipValue = "";
                }
            }
            this.isPaste = false;
        });
    }
}
BBAutosuggestComponent.decorators = [
    { type: Component, args: [{
                selector: 'bb-autosuggest',
                template: `
    <!-- <div *ngIf="suggestFormattedData" > -->
    <ng-container *ngTemplateOutlet=" filteredSuggestions ? filterTemplt : suggestTemplt" ></ng-container>

    <ng-template #filterTemplt>
      <md-input-container floatPlaceholder="never" class = "mat-form-field">
        <div mdPrefix *ngIf="bbchipEnable" >
            <ng-container *ngTemplateOutlet=" ChipListTemplt"></ng-container>
        </div>
        <input mdInput 
               [mdAutocomplete]="filterAuto" 
               [formControl]="suggestCtrl"
               [placeholder]="bbPlaceholder"
               [(ngModel)]="chipValue"
               #chip 
           
               (paste) = "validateData($event);"
               >
               <!--[placeholder]="placeholder"-->
      </md-input-container>

      <md-autocomplete #filterAuto style="width: 222em !important;">
         <md-option *ngFor="let suggestObj of filteredSuggestions | async " [value]="bbchipEnable == true ? '' : suggestObj.value"  (onSelectionChange)="add(suggestObj.value)">
            <ng-container *ngTemplateOutlet=" suggestOptTemplt; context:{ $implicit: suggestObj }" ></ng-container>
         </md-option>
      </md-autocomplete>
    </ng-template>

    <ng-template #suggestTemplt>
    	  <md-input-container floatPlaceholder="never" class = "mat-form-field">
    	    <div mdPrefix *ngIf="bbchipEnable" >
    	        <ng-container *ngTemplateOutlet=" ChipListTemplt"></ng-container>
    	    </div>
    	    <input mdInput 
    	           [mdAutocomplete]="suggestAuto" 
    	           [formControl]="suggestCtrl"
    	           [placeholder]="bbPlaceholder"
    	           [(ngModel)]="chipValue"
    	           #chip
	          
    	           (paste) = "validateData($event);"
    	           >
    	  </md-input-container>
    	  <md-autocomplete #suggestAuto style="width: 343em !important;">
    	          <md-option *ngFor="let suggestObj of suggestData " [value]="bbchipEnable == true ? '' : suggestObj.value"    (onSelectionChange)="add(suggestObj.value)">
    			        <ng-container *ngTemplateOutlet=" suggestOptTemplt; context:{ $implicit: suggestObj }" ></ng-container>
    			  </md-option>
    	  </md-autocomplete>  
    </ng-template>

    <ng-template #ChipListTemplt>
      <div *ngIf="uxDesign == 'UX1'">
        <ng-container *ngTemplateOutlet=" ChipListTemplt_UX1"></ng-container>
      </div>
      <div *ngIf="uxDesign == 'UX2'">
        <ng-container *ngTemplateOutlet=" ChipListTemplt_UX2"></ng-container>
      </div>
      <div *ngIf="uxDesign == 'UX3'">
        <ng-container *ngTemplateOutlet=" ChipListTemplt_UX3"></ng-container>
      </div>
    </ng-template>

    <!-- uxDesign : UX1 - Simple -->
    <ng-template #ChipListTemplt_UX1>
        <md-chip-list  >
            <md-chip *ngFor="let chipObj of chipData;" color="accent" class="custom-chip" [ngClass]="{'selected': chipToDelete == chipObj.value }">

      <div class="contentChip">
      <!--
        <img class="imageChip" src="{{chipObj.image}}"/>
        <span class="iconChip">{{ chipObj.displayChipText.charAt(0) }}</span>
      -->
      <ng-container *ngTemplateOutlet=" imageTemplt; context:{$implicit: chipObj, classSuffix: ''}"></ng-container>
        <span class="textChip">{{ chipObj.displayChipText }}</span>
        <i class="material-icons closeChip" (click)="remove(chipObj)">cancel</i>
      </div>
            <input type = "hidden" name ="refId" [value] = 'chipObj.value'/>
            </md-chip>
        </md-chip-list>
    </ng-template>

    <!-- uxDesign : UX2 - Flat -->
    <ng-template #ChipListTemplt_UX2>
        <md-chip-list mdPrefix *ngIf="bbchipEnable" >
            <md-chip *ngFor="let chipObj of chipData;" color="accent" class="capsule-flat-chip" [ngClass]="{'selected': chipToDelete == chipObj.value, 'errChip': chipObj.errData }">

      <div class="capsuleFlatChip">
        <span class="capsuleTextFlatChip">{{ chipObj.displayChipText }}</span>
        <i class="material-icons closeCapsuleFlatChip" (click)="remove(chipObj)">close</i>
      </div>
	
            <input *ngIf = "!chipObj.errData" type = "hidden" name ="refId" [value] = 'chipObj.value'/>
            </md-chip>
        </md-chip-list>
    </ng-template>

    <!-- uxDesign : UX3 - Material -->
    <ng-template #ChipListTemplt_UX3>
        <md-chip-list mdPrefix *ngIf="bbchipEnable" >
            <md-chip *ngFor="let chipObj of chipData;" color="accent" class="capsule-chip" [ngClass]="{'selected': chipToDelete == chipObj.value }">

      <div class="capsuleChip">
      <!--
        <img class="capsuleImageChip" src="{{chipdata.image}}"/>
        <span class="capsuleIconChip">{{ chipdata.displayChipText.charAt(0) }}</span>
      -->
      <ng-container *ngTemplateOutlet=" imageTemplt; context:{$implicit: chipObj, classSuffix: 'Capsule'}"></ng-container>
        <span class="capsuleTextChip">{{ chipObj.displayChipText }}</span>
        <i class="material-icons closeCapsuleChip" (click)="remove(chipObj)">cancel</i>
      </div>
            <input  type = "hidden" name ="refId" [value] = 'chipObj.value'/>
            </md-chip>
        </md-chip-list>
    </ng-template>


    <ng-template #suggestOptTemplt let-suggestData >
      <div class="suggestOption">
        <span class="capsuleTextChip">{{ suggestData.displaySuggestText }}</span>
        <ng-container *ngTemplateOutlet=" imageTemplt; context:{$implicit: suggestData, classSuffix: 'Capsule'}"></ng-container>
         <!--<span class="capsuleTextChip">{{ suggestData.displaySuggestText }}</span>-->
      </div>
    </ng-template>

    <ng-template #imageTemplt let-imageData let-classSuffix='classSuffix' >
        <img *ngIf = "imageData.image" class="imageChip{{classSuffix}}" src="{{imageData.image}}" 
          (error) = "imageData.image = 'ERROR'; iconImg.style = 'display:none';" #iconImg />

        <span *ngIf = "imageData.image == 'ERROR'" class="iconChip{{classSuffix}}">
            {{ imageData.displaySuggestText.charAt(0) }}
        </span>
    </ng-template>
    <!-- </div> -->
  `,
                styles: [`
    .mat-input-flex {
        display: inline-block !important;
    }

    .mat-input-prefix {
    white-space: normal !important;
    }

    .custom-chip{
        border-radius: 5px !important;
        cursor: pointer;
        border: 1px solid mediumvioletred;
        background-color: #fff !important;
        padding: 0 !important;
        margin: 3px 6px !important;
    }

    .custom-chip:focus{
      background-color: mediumvioletred !important;
      color: #fff !important;
    }

    .imageChip {
        border-radius: 4px;
        height: 48px;
        width: 48px;
        float: left;
    }
    .textChip {
        width: auto;
        position: relative;
        display: inline-block;
        padding-left: 10px;
    
    
    }

    .contentChip {
        height: 48px;
        font-size: 16px;
        line-height: 48px;
    }
    .custom-chip:focus .iconChip {
    	 background-color: #fff;
    	 color: mediumvioletred;
    }
    .iconChip {
        float: left;
        top: 8px;
        background-color: mediumvioletred;
        border-radius: 100%;
        padding: 0;
        height: 32px;
        width: 32px;
        text-align: center;
        position: relative;
        line-height: 32px;
        margin-left: 5px;
        color:#fff;
    }
    .closeChip {
        float: right;
        top: 12px;
        position: relative;
        padding-left: 15px;
        padding-right: 5px;
        visibility: hidden;
    }

    .custom-chip:hover .closeChip {
    visibility: visible;
    }




    .mat-form-field{
    width : inherit;	
    }
    .capsule-chip{
        cursor: pointer;
        border: 1px solid mediumvioletred;
        background-color: #fff !important;
        padding: 0 !important;
        margin: 3px 6px !important;
    }


    .capsule-chip:focus{
      background-color: mediumvioletred !important;
      color: #fff !important;
    }
    .capsuleChip
    {
       display: inline-block;
        padding: 0 25px;
        height: 32px;
        font-size: 18px;
        line-height: 35px;
        border-radius: 47px;
    
    }
    .imageChipCapsule{
        border-radius: 50px;
        height: 32px;
        width: 32px;
        padding: 8px;   
        float: left;
        top: 0px;
        padding: 0;
        text-align: center;
        line-height: 32px;
        color: #fff;
        border-radius: 50px;
        height: 32px;
        width: 32px;
        position: relative;
        display: inline-block;
        float: left;
        margin: 0px 0px 0px -25px !important;
    }
    .capsule-chip:focus .iconChipCapsule {
    	 background-color: #fff;
    	 color: mediumvioletred;
    }
    .iconChipCapsule{
    	top: 0px;
        /*background-color: darkgray;*/
        background-color: mediumvioletred;
        padding: 0;
        margin: 8px;
        text-align: center;
        line-height: 32px;
        color: #fff;
        border-radius: 50px;
        height: 32px;
        width: 32px;
        position: relative;
        display: inline-block;
        float: left;
        margin: 0px 0px 0px -25px !important;
    }

    .capsuleTextChip{
        width: 90%;
        height: inherit;
        line-height: 30px;
        position: relative;
        /*display: inline-block;*/
        padding: 0;
        text-overflow: ellipsis;
        overflow: hidden;
        white-space: nowrap;    
        padding-left: 10px;
    }
    /*
    .closeCapsuleChip{
    	float: right;
        top: -4px;
        position: relative;
        padding-left: 15px;
        padding-right: 5px;
        margin: 0px -34px 0px -11px;
        size: 41px !important;
        font-size: 40px;
    }
    */
    .closeCapsuleChip {
    float: right;
    top: 4px;
    position: relative;
    padding: 0;
    margin: 0;
    margin-left: 25px;
    margin-right: -25px;
    visibility: hidden;
    }


    .capsule-chip:hover .closeCapsuleChip {
    visibility: visible;
    }

    /*.highlight{
    background: mediumvioletred;
    color : #fff;
    }
    */
    h2 {
        margin-left: 20px;
    }
    input{
	
    }

    .container {
        margin-left: 20px;
    }

    .capsule-flat-chip{
    	cursor: pointer;
     /*  border: 1px solid mediumvioletred;*/
        background-color: #fff !important;
        padding: 0 !important;
        margin: 3px 6px !important;
    }


    .capsuleFlatChip
    {
       display: inline-block;
        padding: 0 25px;
        height: 32px;
        font-size: 18px;
        line-height: 35px;
        border-radius: 47px;
        background-color: rgba(241, 241, 241, 0.54);
    }

    md-chip.selected:last-child .capsuleFlatChip {
        box-shadow: inset 0 0 2px 0px #f9a803;
    }
    .closeCapsuleFlatChip{
    float: right;
    top: 6px;
    position: relative;
    padding: 0;
    margin: 0;
    margin-left: 10px;
    margin-right: -18px;
    /*background-color: rgba(241, 241, 241, 0.54);*/
    /* color: orange;
     */font-size: 20px;

    }

    .capsuleTextFlatChip{
    	width: auto;
        position: relative;
        display: inline-block;
        padding-left: 10px;
        margin-left: -20px;
    
    }
    .mat-input-placeholder {
    	/* color: orange;  */
    }

    .mat-focused .mat-input-placeholder
    {
    	 /* color: orange !important; */
    }

    .mat-form-field-underline{
    	/* background-color: orange !important; */
    }
    .mat-input-ripple {
    /* 	background-color: orange !important;
     */}

    md-placeholder{
        color:pink !important;
    }


    .suggestOption {
        display: block;
        position: relative;
        height: 48px;
        /*width: 100%; */
    /*     margin: 0 -25px;
     */    margin: 0 -8px;
        width: 122%;
    }

    .mat-option:hover:not(.mat-option-disabled) {
        background: #f9a803 !important;
    }

    .mat-option:hover:not(.mat-option-disabled) .capsuleTextChip {
        color: #fff;
    }



    .errChip {
        box-shadow: inset 0 0 0px 2px #fd3c31;
    }
    /* div#cdk-overlay-0 {
        width: 222px !important;
    }
    div#cdk-overlay-3 {
        width: 375px !important;
    } */

    .cdk-overlay-pane {
      /*   width: 375px !important; */
        width: auto !important;
    } 


    mat-autocomplete-panel.mat-autocomplete-visible {
        visibility: visible;
        width: 375px !important ;
        max-width:390px !important
    }


    .columns .mat-form-field {
         width: auto !important; 
    }
  `],
                encapsulation: ViewEncapsulation.None,
                providers: [
                    {
                        provide: NG_VALUE_ACCESSOR,
                        useExisting: forwardRef(() => BBAutosuggestComponent),
                        multi: true
                    }
                ]
            },] },
];
/** @nocollapse */
BBAutosuggestComponent.ctorParameters = () => [
    { type: BBAutosuggestService, },
];
BBAutosuggestComponent.propDecorators = {
    'uxDesign': [{ type: Input },],
    'dataSource': [{ type: Input },],
    'bbPlaceholder': [{ type: Input, args: ['placeholder',] },],
    'bbchipEnable': [{ type: Input, args: ['chipEnable',] },],
    'duplicateAllow': [{ type: Input },],
    'minlength': [{ type: Input },],
    'refId': [{ type: Input },],
    'onSelectionChange': [{ type: Output },],
    'onClear': [{ type: Output },],
};
//# sourceMappingURL=bb-autosuggest.component.js.map