var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import { Component, Input, Output, forwardRef, EventEmitter } from '@angular/core';
import { ValueAccessorBase } from '../../key-input/form/value-accessor';
import { NG_VALUE_ACCESSOR } from '@angular/forms';
var nextUniqueId = 0;
export var BB_CHECKBOX_CONTROL_VALUE_ACCESSOR = {
    provide: NG_VALUE_ACCESSOR,
    useExisting: forwardRef(function () { return BBCheckboxComponent; }),
    multi: true
};
var BBCheckboxComponent = (function (_super) {
    __extends(BBCheckboxComponent, _super);
    function BBCheckboxComponent() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._uniqueId = "bb-checkbox-" + ++nextUniqueId;
        _this.uxDesign = 'UX3';
        _this.bbId = _this._uniqueId;
        _this.bbLabelPosition = 'after';
        _this.bbChecked = false;
        _this.bbIndeterminate = false;
        _this.bbDisabled = false;
        _this.bbChange = new EventEmitter();
        _this.bbIndeterminateChange = new EventEmitter();
        return _this;
    }
    BBCheckboxComponent.prototype.ngOnInit = function () {
    };
    BBCheckboxComponent.decorators = [
        { type: Component, args: [{
                    selector: 'bb-checkbox',
                    template: "\n\n      <span [ngSwitch]=\"uxDesign\">\n\t\n      \t<span *ngSwitchCase=\"'UX3'\" [ngSwitch]=\"appearance\">\n      \t\t<md-checkbox [(ngModel)]=\"value\" (bbChange)=\"bbChange.emit();\" [name]=\"bbName\" [required]=\"bbRequired\" [checked]=\"bbChecked\" [value]=\"bbValue\" [labelPosition]=\"bbLabelPosition\" [(indeterminate)]=\"bbIndeterminate\" [id]=\"bbId\" [align]=\"bbAlign\" [disabled]=\"bbDisabled\">\n      \t\t        <ng-container *ngTemplateOutlet=\"content\"></ng-container>\n      \t\t</md-checkbox>\n      \t</span>\n\n      \t<ng-template #content><ng-content></ng-content></ng-template>\n      </span>\n    ",
                    styles: ["\n\n    "],
                    providers: [BB_CHECKBOX_CONTROL_VALUE_ACCESSOR]
                },] },
    ];
    /** @nocollapse */
    BBCheckboxComponent.ctorParameters = function () { return []; };
    BBCheckboxComponent.propDecorators = {
        'uxDesign': [{ type: Input, args: ['uxDesign',] },],
        'bbId': [{ type: Input, args: ['id',] },],
        'bbRequired': [{ type: Input, args: ['required',] },],
        'bbAlign': [{ type: Input, args: ['align',] },],
        'bbLabelPosition': [{ type: Input, args: ['labelPosition',] },],
        'bbName': [{ type: Input, args: ['name',] },],
        'bbValue': [{ type: Input, args: ['value',] },],
        'bbChecked': [{ type: Input, args: ['checked',] },],
        'bbIndeterminate': [{ type: Input, args: ['indeterminate',] },],
        'bbDisabled': [{ type: Input, args: ['disabled',] },],
        'bbChange': [{ type: Output },],
        'bbIndeterminateChange': [{ type: Output },],
    };
    return BBCheckboxComponent;
}(ValueAccessorBase));
export { BBCheckboxComponent };
//# sourceMappingURL=bb-checkbox.component.js.map