package ibase.dashboard.sfa.servlet;

import ibase.dashboard.sfa.ejb.DoctorsVisitRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.simple.JSONObject;

public class DoctorsVisitServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;
	JSONObject jsonObjMetaData = null;
	JSONObject jsonMetaData = null;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	@SuppressWarnings("unchecked")
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		DoctorsVisitRemote doctorsVisitRemote = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		String salesPerson = "";
		String month = "";
		String year = "";
		String loginId = "";
		String reportName = "";
		try
		{
			response.setContentType("application/xml");

			HttpSession session = request.getSession(true);
			ibase.utility.UserInfoBean userInfo = (ibase.utility.UserInfoBean) session.getAttribute("USER_INFO");
			loginId = userInfo.getLoginCode();
			
			dataSourceName = request.getParameter("dataSourceName");
			salesPerson = (request.getParameter("salesperson"));
			month = (request.getParameter("month"));
			year = (request.getParameter("year"));
			reportName = request.getParameter("reportName");
			reportName = reportName + "-" + month + "-" + year;
			session.setAttribute("reportName", reportName);
			// This block for open or hide code
			/*salesPerson = "62851"; 
			month = "MAY"; 
			year = "2009";
			loginId = "62851";*/

			System.out.println("loginId =" + loginId);
			System.out.println("salesPerson is =" + salesPerson);
			System.out.println("month is =" + month);
			System.out.println("year is =" + year);
			System.out.println("reportName is =" + reportName);
			context = new InitialContext(appConnectParm.getProperty());
			System.out.println("inside docotor 1 =");
			doctorsVisitRemote = (DoctorsVisitRemote) context.lookup("ibase/DoctorsVisit/remote");
			JSONObject jsonObjData = (JSONObject) doctorsVisitRemote.getDoctorsVisitDetails(loginId, salesPerson, month, year, dataSourceName);
			System.out.println("inside docotor2 =");
			OutputStream outputStream = response.getOutputStream();
			outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" Final data set for DoctorsVisitsServlet build the Graph is===" + jsonObjData);

		} catch (Exception e)
		{
			System.out.println("Exception : DoctorsVisitsServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}

	}

}