package ibase.client;

import java.util.ArrayList;
import java.util.HashMap;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import ibase.e12ria.e12table.client.E12CustomTextCell;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.Widget;

public class CustomFlxTable
{
	private static final int HeaderRowIndex = 0;
	int rowIndex = 1;
	String tltStr = "Total";
	final String LEFT = "left";
	final String RIGHT = "right";

	private void addColumn(Object columnHeading, FlexTable flexTable)
	{
		Widget widget = createCellWidget(columnHeading);
		int cell = flexTable.getCellCount(HeaderRowIndex);
		widget.setWidth("100%");
		widget.addStyleName("FlexTable-ColumnLabel");
		flexTable.setWidget(HeaderRowIndex, cell, widget);
		flexTable.getCellFormatter().addStyleName(HeaderRowIndex, cell, "FlexTable-ColumnLabelCell");
	}

	private Widget createCellWidget(Object cellObject)
	{
		Widget widget = null;
		if (cellObject instanceof Widget)
			widget = (Widget) cellObject;
		else
			widget = new Label(cellObject.toString());
		return widget;
	}

	private void addRowToTbl(ArrayList<String> cellDataList, final FlexTable flexTable, ArrayList<String> cellAlignList)
	{
		boolean isTotalRow = false;
		Widget cellWidget = null;
		String data = "";
		for (int cell = 0; cell < cellDataList.size(); cell++)
		{
			cellWidget = createCellWidget(cellDataList.get(cell));
			flexTable.setWidget(rowIndex, cell, cellWidget);
			data = cellDataList.get(cell);
			if (data.indexOf(tltStr) != -1)
			{
				isTotalRow = true;
			}
			if (isTotalRow)
			{
				if (LEFT.equalsIgnoreCase(cellAlignList.get(cell)))
				{
					flexTable.getCellFormatter().addStyleName(rowIndex, cell, "FlexTable-LblCell-Left");

				} else if (RIGHT.equalsIgnoreCase(cellAlignList.get(cell)))
				{
					flexTable.getCellFormatter().addStyleName(rowIndex, cell, "FlexTable-LblCell-Right");
				}
			} else
			{
				if (LEFT.equalsIgnoreCase(cellAlignList.get(cell)))
				{
					flexTable.getCellFormatter().addStyleName(rowIndex, cell, "FlexTable-Even-Cell-Left");
				} else if (RIGHT.equalsIgnoreCase(cellAlignList.get(cell)))
				{
					flexTable.getCellFormatter().addStyleName(rowIndex, cell, "FlexTable-Even-Cell-Right");
				}
			}
		}
		rowIndex++;
	}

	@SuppressWarnings("unchecked")
	public FlexTable createFlxTbl(FlexTable flexTable, HashMap<String, HashMap> gridNGraphMeataDataMap, JSONObject jsonObjGridData,String componentId)
	{
		flexTable.insertRow(HeaderRowIndex);
		flexTable.setCellSpacing(0);
		flexTable.addStyleName("FlexTable");

		gridNGraphMeataDataMap.toString().replace('=', ':');
		HashMap<String, ArrayList<String>> graphDataMap = null;
		ArrayList<String> graphDtlList = null;
		try
		{
			graphDataMap = gridNGraphMeataDataMap.get("columnName"+componentId);
			for (String graphKey : graphDataMap.keySet())
			{
				graphDtlList = graphDataMap.get(graphKey);
				for (int jDataCtr = 0; jDataCtr < graphDtlList.size(); jDataCtr++)
				{
					addColumn(graphDtlList.get(jDataCtr), flexTable);
				}
			}
			buildEachRowData(gridNGraphMeataDataMap, jsonObjGridData, flexTable,componentId);

		} catch (Exception e)
		{
			Window.alert(" Exception : CustomFlxTable : creatFlxTbl(): [" + e.getMessage() + "]");
		}
		return flexTable;
	}

	@SuppressWarnings("unchecked")
	public void buildEachRowData(HashMap<String, HashMap> gridNGraphMetaDataMap, JSONObject jsonObjGridData, FlexTable flexTable,String componentId)
	{
		gridNGraphMetaDataMap.toString().replace('=', ':');
		ArrayList<String> graphDtlList = null;
		JSONObject jsonEachRow = null;
		String cellText = "";
		String align = "";
		HashMap<String, String> coloumAlignMap = null;
		HashMap<String, ArrayList<String>> graphDataMap = null;
		HashMap<Integer, E12CustomTextCell.CellData> rowData = null;
		ArrayList<String> cellDataList = new ArrayList<String>();
		graphDataMap = gridNGraphMetaDataMap.get(componentId);
		coloumAlignMap = gridNGraphMetaDataMap.get("columnAlign"+componentId);
		JSONObject jsonObjData = (JSONObject) jsonObjGridData.get(componentId);

		ArrayList<String> cellAlignList = new ArrayList<String>();
		for (String graphKey : coloumAlignMap.keySet())
		{
			align = coloumAlignMap.get(graphKey);
			cellAlignList.add(align);
		}
		for (int jRowCtr = 0; jRowCtr < jsonObjData.size(); jRowCtr++)
		{
			rowData = new HashMap<Integer, E12CustomTextCell.CellData>();
			cellDataList = new ArrayList<String>();
			for (String graphKey : graphDataMap.keySet())
			{
				graphDtlList = graphDataMap.get(graphKey);
				jsonEachRow = new JSONObject();
				jsonEachRow = (JSONObject) jsonObjData.get("" + jRowCtr);
				for (int jDataCtr = 0; jDataCtr < graphDtlList.size(); jDataCtr++)
				{
					cellText = "" + jsonEachRow.get("" + graphDtlList.get(jDataCtr));
					cellText = cellText.replace('"', ' ').trim();
					cellDataList.add(cellText);
				}
			}
			addRowToTbl(cellDataList, flexTable, cellAlignList);
		}
		this.expandCollapseTbl(flexTable);
	}

	private void expandCollapseTbl(final FlexTable flexTable)
	{
		int rows = flexTable.getRowCount();
		int lastTotalRow = 0;
		int firstRow = 1;
		Widget widget = null;
		String total = "";

		for (int i = 1; i < rows; i++)
		{
			widget = flexTable.getWidget(i, 0);
			{
				total = ((Label) widget).getText();
				final Label testLbl = (Label) widget;
				if (total.indexOf(tltStr) != -1)
				{
					lastTotalRow = i;
					final int firstRow1 = firstRow;
					final int lastTotalRow1 = lastTotalRow;

					testLbl.addClickHandler(new ClickHandler()
					{
						boolean visibleFlag = false;

						@Override
						public void onClick(ClickEvent event)
						{
							for (int i = firstRow1; i < lastTotalRow1; i++)
							{
								flexTable.getRowFormatter().setVisible(i, visibleFlag);
							}
							if (visibleFlag)
							{
								visibleFlag = false;

							} else
							{
								visibleFlag = true;
							}
						}
					});
					firstRow = lastTotalRow + 1;
				}
			}
		}

	}
//add method  for flex table heading fixed
	
	/*Method for flextable heading fix Dhanendra 09-10-2014*/
	/*public FlexTable addColumnGrid(HashMap<String, HashMap> gridNGraphMeataDataMap, FlexTable flexTable)
	{
		
		flexTable.setCellSpacing(0);
		flexTable.setCellPadding(0);
		flexTable.addStyleName("FlexTable-ColumnLabel");
		flexTable.setWidth("100%");
		

		gridNGraphMeataDataMap.toString().replace('=', ':');
		HashMap<String, ArrayList<String>> graphDataMap = null;
		ArrayList<String> graphDtlList = null;
		HashMap<String, String> coloumSizeMap = null;
		coloumSizeMap = gridNGraphMeataDataMap.get("columnSize");
		ArrayList<String> cellSizeList = new ArrayList<String>();
		String size = "";
		for (String graphKey : coloumSizeMap.keySet())
		{
			size = coloumSizeMap.get(graphKey);
			cellSizeList.add(size);
		}
		graphDataMap = gridNGraphMeataDataMap.get("columnName");
		int coloumCount=0;
		for (String graphKey : graphDataMap.keySet())
		{
			graphDtlList = graphDataMap.get(graphKey);
			for (int jDataCtr = 0; jDataCtr < graphDtlList.size(); jDataCtr++)
			{
				flexTable.setText(0, coloumCount, graphDtlList.get(jDataCtr));
				flexTable.getCellFormatter().addStyleName(HeaderRowIndex, coloumCount, "FlexTable-ColumnLabelCell");
				flexTable.getCellFormatter().setWidth(HeaderRowIndex, coloumCount, ""+cellSizeList.get(coloumCount));
			}
			coloumCount++;
		}
		
		
		return flexTable;
	
	}*/
	
	
	
	
	
	
	
	
	
}
