package ibase.webitm.util.gst;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;

import ibase.webitm.bean.gst.DocDetails;
import ibase.webitm.bean.gst.DocIssued;

public class DocSerializer extends BaseSerializer<DocIssued>
{
	@Override
	public void serialize(DocIssued docIssued, JsonGenerator json, SerializerProvider serializeProvider) throws IOException, JsonProcessingException
	{
		json.writeStartObject();
		
		if(docIssued.taxPayerAction != null)
		{
			json.writeStringField("flag", docIssued.taxPayerAction);
		}
		
		json.writeNumberField("doc_num", docIssued.serialNumber);
		json.writeStringField("doc_typ", docIssued.docDescr);
		
		json.writeFieldName("docs");
		
		json.writeStartArray();
		
		for(DocDetails docDetail : docIssued.docDetails)
		{
			json.writeStartObject();
			
			json.writeNumberField("num", docDetail.docNum);
			json.writeStringField("from", docDetail.fromSerialNo);
			json.writeStringField("to", docDetail.toSerialNo);
			json.writeNumberField("totnum", docDetail.totalNo);
			json.writeNumberField("cancel", docDetail.cancelNo);
			json.writeNumberField("net_issue", docDetail.toatlNetIssued);
			
			json.writeEndObject();
		}
		
		json.writeEndArray();
		
		json.writeEndObject();
	}
}
