package ibase.webitm.ejb.gst;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.rmi.RemoteException;
import java.security.PrivateKey;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Objects;
import java.util.UUID;

import javax.annotation.PostConstruct;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.XML;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.JsonNode;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.request.HttpRequest;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.bean.gst.APICallData;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.util.gst.AESEncryption;
import ibase.webitm.util.gst.GSPSignature;
import ibase.webitm.util.gst.GSTCommonUtil;
import ibase.webitm.util.gst.PubKeyEncryption;
import ibase.webitm.utility.ITMException;

@javax.ejb.Stateless
public class GSTDataSubmitWizEJB extends ValidatorEJB implements GSTDataSubmitWizEJBLocal, GSTDataSubmitWizEJBRemote  
{
	private String BASE_API_URL = "";
	private String AUTH_TOKEN_URL = "";
	private String GSTR_RETSTAT_URL = "";
	private String GSTR1_URL = "";
	private String GSTR2_URL = "";
	private String GSTR3B_URL = "";
	private String FILEDET_URL = "";
	private final String APPLICATION_JSON = "application/json";
	private String appKey = "";
	String ipAddress = "";
	private byte[] appKeyInBytes = null;
	private String appKeyEncryptedAndCoded = "";
	private String clientId = "";
	private String clientSecret = "";
	private String fileDownloadDir = "";
	private String saveFilePath = "";
	private String gspTokenTimeStampFormat = "";
	AESEncryption aesEncryption = null;
	PubKeyEncryption pubKeyEncryption = null;
	GSPSignature gspSignature;
	PrivateKey aspPrivateKey = null;
	SimpleDateFormat gspTokenTimeFormatter = null;
	
	GSTCommonUtil gstCommonUtil = new GSTCommonUtil();
	E12GenericUtility e12GenericUtility = new E12GenericUtility();
	
	@PostConstruct
	public void postConstruct()
	{
		String gstnPublicKeyName = "", gspPrivateKeyName = "";
		Connection conn = null;
		try(java.util.Scanner sc = new java.util.Scanner(new java.net.URL("https://api.ipify.org").openStream(), "UTF-8").useDelimiter("\\A"))
		{
			System.out.println("GSTDataSubmitWizEJB PostConstruct called!");
			conn = getConnection();
			FinCommon finCommon = new FinCommon();
			gstnPublicKeyName = finCommon.getFinparams("999999", "GSTN_PUB_KEY_NAME", conn);
			gspPrivateKeyName = finCommon.getFinparams("999999", "GSP_PRI_KEY_NAME", conn);
			if("NULLFOUND".equalsIgnoreCase(gstnPublicKeyName))
			{
				gstnPublicKeyName = "GSTN_G2B_Prod_Public";
			}
			if("NULLFOUND".equalsIgnoreCase(gspPrivateKeyName))
			{
				gspPrivateKeyName = "GSP_Private_Prod_Key";
			}
			System.out.println("gstnPublicKeyName["+gstnPublicKeyName+"]");
			System.out.println("gspPrivateKeyName["+gspPrivateKeyName+"]");
			InputStream pubKeyInpStream = Thread.currentThread().getContextClassLoader().getResourceAsStream("ibase/webitm/resources/gst/"+gstnPublicKeyName.trim()+".cer");
			clientId = finCommon.getFinparams("999999", "GST_CLIENT_ID", conn);
			clientSecret = finCommon.getFinparams("999999", "GST_CLIENT_SECRET", conn);
			fileDownloadDir = finCommon.getFinparams("999999", "GST_DOWNLOAD_DIR", conn);
			gspTokenTimeStampFormat = finCommon.getFinparams("999999", "GSP_TKN_TIMSTMP_FRMT", conn);
			gspTokenTimeFormatter = new SimpleDateFormat(gspTokenTimeStampFormat);
			aesEncryption = new AESEncryption();
			pubKeyEncryption = new PubKeyEncryption(pubKeyInpStream);
			ipAddress = sc.next();
			if(ipAddress== null || ipAddress.trim().length() == 0)
			{
				String tomcatHome = CommonConstants.TOMCAT_HOME;
				ipAddress = tomcatHome.substring(tomcatHome.lastIndexOf("/")+1, tomcatHome.lastIndexOf(":"));
			}
			System.out.println("host ipAddress["+ipAddress+"]");
			gspSignature = new GSPSignature();
			String privateKeyPath = "/ibase/webitm/resources/gst/"+gspPrivateKeyName.trim()+".pem";
			aspPrivateKey = gspSignature.loadPrivateKey(Thread.currentThread().getContextClassLoader().getResourceAsStream(privateKeyPath));
			
			File folder = new File(fileDownloadDir);
			
			if(!folder.exists())
			{
				folder.mkdirs();
				System.out.println("GSTN Folder created");
			}
			saveFilePath = folder.getAbsolutePath();
			System.out.println("saveFilePath["+saveFilePath+"]");
		}
		catch (Exception e) 
		{
			System.out.println("GSTDataSubmitWizEJB.postConstruct()["+e.getMessage()+"]");
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(conn!= null && !conn.isClosed())
				{
					conn.close();
					conn = null;
				}
			}
			catch(SQLException se)
			{
				System.out.println("GSTDataSubmitWizEJB.postConstruct()["+se.getMessage()+"]");
				se.printStackTrace();
			}
		}
		
	}
	@Override
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		String retString = null;
		
		E12GenericUtility genericUtility = new E12GenericUtility();
		try
		{
			if (xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if (xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if (xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			retString = itemChanged( dom, dom1, dom2, objContext, currentColumn, editFlag, xtraParams );
		}
		catch (Exception e)
		{
			System.out.println ( "Exception :GSTDataSubmitWizEJB :itemChanged(String,String):" + e.getMessage() + ":" );
			e.printStackTrace();
		}
		System.out.println ( "Return String from GSTDataSubmitWizEJB ["+retString+"]" );
		
		return retString;
	}
	
	@Override
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		StringBuffer valueXmlString = new StringBuffer();
		int currentFormNo = 0;
		String sql = "", siteCode = "", siteDescr = "", gstinNo = "", userName = "", stateCode = "", stateDescr = "", grossTurnover = "", periodCode = "", currentYearGrossTurnover = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			System.out.println("Inside GSTDataSubmitWizEJB itemchanged");
			conn = getConnection();
			siteCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			
			System.out.println("currentColumn["+currentColumn+"] currentFormNo["+currentFormNo+"]" );
			
			sql = "SELECT SERVICE_CODE, SERVICE_URI FROM SYSTEM_EVENT_SERVICES WHERE METHOD_NAME = 'GST_API_URL'";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				switch(rs.getString("SERVICE_CODE"))
				{
					case "base_url" :
					{
						BASE_API_URL = rs.getString("SERVICE_URI");
					}
					break;
					case "gstr_auth_url" :
					{
						AUTH_TOKEN_URL = rs.getString("SERVICE_URI");
					}
					break;
					case "gstr_retstatus_url" :
					{
						GSTR_RETSTAT_URL = rs.getString("SERVICE_URI");
					}
					break;
					case "gstr1_url" :
					{
						GSTR1_URL = rs.getString("SERVICE_URI");
					}
					break;
					case "gstr2_url" :
					{
						GSTR2_URL = rs.getString("SERVICE_URI");
					}
					break;
					case "gstr3b_url" :
					{
						GSTR3B_URL = rs.getString("SERVICE_URI");
					}
					break;
					case "gstr_filedet_url" :
					{
						FILEDET_URL = rs.getString("SERVICE_URI");
					}
					break;
				}
			}
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			
			System.out.println("BASE_API_URL["+BASE_API_URL+"]");
			System.out.println("AUTH_TOKEN_URL["+AUTH_TOKEN_URL+"]");
			System.out.println("GSTR_URL["+GSTR_RETSTAT_URL+"]");
			System.out.println("GSTR1_URL["+GSTR1_URL+"]");
			System.out.println("GSTR2_URL["+GSTR2_URL+"]");
			System.out.println("GSTR3B_URL["+GSTR3B_URL+"]");
			System.out.println("FILEDET_URL["+FILEDET_URL+"]");
			
			valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?><Root><Header><editFlag>" );
			valueXmlString.append( editFlag ).append( "</editFlag></Header>" );
			
			switch(currentFormNo)
			{
				case 1:
				{
					System.out.println(" -------- Inside itemchange case 1111111 ------------ ");
					
					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ))
					{
						appKey = aesEncryption.generateSecureKey();
						appKeyInBytes = aesEncryption.decodeBase64StringTOByte(appKey);
						appKeyEncryptedAndCoded = pubKeyEncryption.encrypt(appKeyInBytes);
						
						sql = " SELECT S.SITE_CODE, S.SH_DESCR, SUBSTR(REG_NO,0,2) AS GST_CODE, ST.DESCR, SR.REF_CODE, SR.REG_NO FROM SITE S, SITEREGNO SR, STATE ST"
							+ "	WHERE S.SITE_CODE = SR.SITE_CODE AND S.FIN_ENTITY = SR.FIN_ENTITY AND SUBSTR(REG_NO,0,2) = ST.GST_CODE (+) AND SR.REF_CODE IN ('GSTIN_NO','GST_UNAME','GST_GT','GST_CUR_GT')"
							+ " AND SR.SITE_CODE =  ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, siteCode);
						rs = pstmt.executeQuery();
						
						while(rs.next())
						{
							siteDescr = checkNull(rs.getString("SH_DESCR"));
							if("GSTIN_NO".equalsIgnoreCase(checkNull(rs.getString("REF_CODE"))))
							{
								gstinNo = checkNull(rs.getString("REG_NO"));
								stateCode = checkNull(rs.getString("GST_CODE"));
								stateDescr = checkNull(rs.getString("DESCR"));
							}
							if("GST_UNAME".equalsIgnoreCase(checkNull(rs.getString("REF_CODE"))))
							{
								userName = checkNull(rs.getString("REG_NO"));
							}
							if("GST_GT".equalsIgnoreCase(checkNull(rs.getString("REF_CODE"))))
							{
								grossTurnover =  checkNull(rs.getString("REG_NO"));
							}
							if("GST_CUR_GT".equalsIgnoreCase(checkNull(rs.getString("REF_CODE"))))
							{
								currentYearGrossTurnover =  checkNull(rs.getString("REG_NO"));
							}
						}
						if(rs != null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();
							pstmt = null;
						}
						
						valueXmlString.append("<Detail1 domID='1'>");
						valueXmlString.append("<period_code><![CDATA[]]></period_code>");
						valueXmlString.append("<site_code><![CDATA[").append(siteCode).append( "]]></site_code>");
						valueXmlString.append("<site_descr><![CDATA[").append(siteDescr).append( "]]></site_descr>");
						valueXmlString.append("<gstin><![CDATA[" ).append(gstinNo).append( "]]></gstin>");
						valueXmlString.append("<username><![CDATA[").append(userName).append( "]]></username>");
						valueXmlString.append("<state_code><![CDATA[").append(stateCode).append( "]]></state_code>");
						valueXmlString.append("<state_descr><![CDATA[").append(stateDescr).append( "]]></state_descr>");
						valueXmlString.append("<gross_turnover><![CDATA[").append(grossTurnover).append( "]]></gross_turnover>");
						valueXmlString.append("<cur_gross_turnover><![CDATA[").append(currentYearGrossTurnover).append( "]]></cur_gross_turnover>");
						valueXmlString.append("<otp><![CDATA[]]></otp>");
						valueXmlString.append("<app_key><![CDATA["+appKey+"]]></app_key>");
						valueXmlString.append("</Detail1>" );
					}
					break;
				}
				case 2:
				{
					String otp = "", transactionId = "", authToken = "", sek = "", retXML = "", errorXML = "", errMsg = "", returnType = "", action = "";
					String gspAuthString = "", gspAuthSignature = "";
					byte[] authSEK = null;
					String loginCode = "", chgTerm = "", callStatus = "", responseId = "", responseJsonStr= "", recType = "";
					String signDataXML = "", summaryDataJsonStr = "";
					ArrayList<HashMap<String,String>> getGstrDataList = new ArrayList<HashMap<String,String>>();
					ArrayList<String> byPassSectionList = new ArrayList<String>();
					
					System.out.println(" -------- Inside itemchange case 2222222 ------------ ");
					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ))
					{
						loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
						chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
						
						gstinNo = checkNull(e12GenericUtility.getColumnValue("gstin", dom1));
						periodCode = checkNull(e12GenericUtility.getColumnValue("period_code", dom1));
						stateCode = checkNull(e12GenericUtility.getColumnValue("state_code", dom1));
						userName = checkNull(e12GenericUtility.getColumnValue("username", dom1));
						returnType = checkNull(e12GenericUtility.getColumnValue("returns_type", dom1));
						action = checkNull(e12GenericUtility.getColumnValue("action", dom1));
						siteCode = checkNull(e12GenericUtility.getColumnValue("site_code", dom1));
						
						if("GSTR1".equalsIgnoreCase(returnType.trim()))
						{
							recType = "1";
							if("SUBMIT".equalsIgnoreCase(action.trim()))
							{
								retXML += getPendingData(recType, siteCode, periodCode, conn);
							}
							else if("FILE".equalsIgnoreCase(action.trim()))
							{
								signDataXML = getSignConfig(loginCode, returnType, conn);
							}
						}
						else if("GSTR2".equalsIgnoreCase(returnType))
						{
							recType = "2";
							if("SUBMIT".equalsIgnoreCase(action.trim()))
							{
								retXML += getPendingData(recType, siteCode, periodCode, conn);
							}
							else if("FILE".equalsIgnoreCase(action.trim()))
							{
								signDataXML = getSignConfig(loginCode, returnType, conn);
							}
						}
						else if("GSTR3".equalsIgnoreCase(returnType) || "GSTR3B".equalsIgnoreCase(returnType))
						{
							recType = "3";
							if("FILE".equalsIgnoreCase(action.trim()))
							{
								signDataXML = getSignConfig(loginCode, returnType, conn);
							}
						}
						
						if("GETINV".equalsIgnoreCase(action))
						{
							sql = " SELECT TRAN_ID, RESPONSE_ID, CALL_DATE,CALL_TYPE"
								+ " FROM API_CALL_LOG" 
								+ " WHERE SITE_CODE = ? AND REC_TYPE = ? AND PRD_CODE = ?" 
								+ " AND CALL_STATUS = ? AND CALL_TYPE LIKE '%GET%' AND RESPONSE_ID IS NOT NULL"
								+ " ORDER BY CALL_DATE DESC";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, siteCode);
							pstmt.setString(2, recType);
							pstmt.setString(3, periodCode);
							pstmt.setString(4, "0");
							rs = pstmt.executeQuery();
							
							while(rs.next())
							{
								HashMap<String,String> tempHMap = new HashMap<String,String>();
								tempHMap.put("api_tranid", rs.getString("TRAN_ID"));
								tempHMap.put("token", rs.getString("RESPONSE_ID"));
								String tempStr = rs.getString("CALL_TYPE");
								String section = tempStr.substring(tempStr.indexOf("_")+1);
								tempHMap.put("section", section);
								
								byPassSectionList.add(section);
								
								getGstrDataList.add(tempHMap);
							}
							if(rs!=null)
							{
								rs.close();
								rs = null;
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}
						}
						
						transactionId = UUID.randomUUID().toString().replaceAll("-", "");

						//Changed by Santosh on 03/10/2017 as per new GSP token format
						//gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstinNo;
				        String timeStamp = gspTokenTimeFormatter.format(new Date());
				        gspAuthString = "v2.0::"+clientId + ":" + transactionId + ":" + timeStamp + ":" + gstinNo + ":" + "AUTHTOKEN";
						gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
						
						otp = checkNull(e12GenericUtility.getColumnValue("otp", dom1));
						
						String encryptedOTP = aesEncryption.encryptEK(otp.getBytes(), appKeyInBytes);
						
						JSONObject authTokenReqObj = new JSONObject();
						authTokenReqObj.put("action", "AUTHTOKEN");
						authTokenReqObj.put("username", userName);
						authTokenReqObj.put("app_key", appKeyEncryptedAndCoded);
						authTokenReqObj.put("otp", encryptedOTP);

				        HttpRequest authTokenReq = Unirest.post(String.format("%s%s", BASE_API_URL, AUTH_TOKEN_URL))
												   .header("Content-Type",APPLICATION_JSON)
												   .header("clientid", clientId)
												   .header("client-secret", clientSecret)
												   .header("state-cd", stateCode)
												   .header("ip-usr", ipAddress)
												   .header("txn", transactionId)
												   .header("app_key", appKeyEncryptedAndCoded)
												   .header("X-Asp-Auth-Token", gspAuthString)
							    	               .header("X-Asp-Auth-Signature", gspAuthSignature)
												   .body(new JsonNode(authTokenReqObj.toString()))
												   .getHttpRequest();
				        
				        System.out.println("authtoken url["+authTokenReq.getUrl()+"]");
				        System.out.println("authtoken method["+authTokenReq.getHttpMethod()+"]");
						System.out.println("authtoken request header["+authTokenReq.getHeaders()+"]");
						System.out.println("authtoken request payload["+IOUtils.toString(authTokenReq.getBody().getEntity().getContent())+"]");
				        
				        HttpResponse<JsonNode> authTokenResp = authTokenReq.asJson();

				        System.out.println(String.format("authTokenResp Request : Status[%s] Response[%s]", authTokenResp.getStatus(), authTokenResp.getBody()));
				        
				        if(authTokenResp.getStatus() == 200) 
				        {
				            JSONObject object = authTokenResp.getBody().getObject();
				            if (object.has("auth_token") && object.has("sek") && object.has("status_cd") && Objects.equals(object.getString("status_cd"), "1")) 
				            {
				            	callStatus = "1";
				                authToken = object.getString("auth_token");
				                sek = object.getString("sek");
				                authSEK = aesEncryption.decrypt(sek, appKeyInBytes);
				                System.out.println("AuthSEK = "+ aesEncryption.encodeBase64String(authSEK));
				                
				            }
				            else
				            {
				            	callStatus = "2";
				            	JSONObject errorJSON = authTokenResp.getBody().getObject().getJSONObject("error");
				            	responseJsonStr = errorJSON.toString();
				            	
				            	if("AUTH4033".equalsIgnoreCase(errorJSON.getString("error_cd")))
				            	{
				            		errorXML = new ITMDBAccessEJB().getErrorString("","VTINVOTP","","",conn);
				            	}
				            	else
				            	{
				            		errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
				            		errorXML = getError(errMsg, "GSTAPIERR", conn);
				            	}
				            }
				        }
				        else if(authTokenResp.getStatus() == 500)
				        {
				        	callStatus = "2";
				        	errMsg = "Message : Error occurred at GSTN server \nResponse code : "+authTokenResp.getStatus();
				        	responseJsonStr = errMsg;
				        	errorXML = getError(errMsg, "GSTAPIERR", conn);
				        }
				        else
				        {
				        	callStatus = "2";
				        	JSONObject errorJSON = authTokenResp.getBody().getObject().getJSONObject("error");
				        	responseJsonStr = errorJSON.toString();
				        	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
				        	errorXML = getError(errMsg, "GSTAPIERR", conn);
				        }
				        
				        APICallData apiCallData = new APICallData();
				        apiCallData.setPeriodCode(periodCode);
				        apiCallData.setCallDate(new Date());
				        apiCallData.setSiteCode(siteCode);
				        apiCallData.setUserId(loginCode);
				        apiCallData.setCallType("AUTHTOKEN");
				        apiCallData.setRecType(recType);
				        apiCallData.setNoOfRecords(0);
				        apiCallData.setCallStatus(callStatus);
				        apiCallData.setResponseId(responseId);
				        apiCallData.setResponseJsonStr(responseJsonStr);
				        apiCallData.setChgUser(loginCode);
				        apiCallData.setChgDate(new Date());
				        apiCallData.setChgTerm(chgTerm);
				        
				        gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
				        
				        if( authToken != null && authToken.trim().length()>0 && authSEK != null)
				        {
				        	if("GSTR1".equalsIgnoreCase(returnType))
				        	{
				        		if("SUBMIT".equalsIgnoreCase(action))
				        		{
				        			summaryDataJsonStr += getGstr1Summary(authToken, stateCode, userName, gstinNo, periodCode, authSEK, appKeyEncryptedAndCoded, xtraParams, conn);
				        			if(summaryDataJsonStr!= null && summaryDataJsonStr.trim().length() > 0 && summaryDataJsonStr.indexOf("Message :") == -1)
				        			{
				        				retXML += "<summary_data>" + XML.toString(new JSONObject(summaryDataJsonStr)) + "</summary_data>";
				        			}
				        			else if(summaryDataJsonStr.indexOf("Message :") >= 0)
				        			{
				        				retXML += summaryDataJsonStr;
				        			}
				        			retXML += downloadGstr1Data(gstinNo, periodCode, authToken, userName, stateCode, appKeyEncryptedAndCoded, xtraParams, authSEK, byPassSectionList);
				        		}
				        		else if("FILE".equalsIgnoreCase(action))
				        		{
				        			summaryDataJsonStr += getGstr1Summary(authToken, stateCode, userName, gstinNo, periodCode, authSEK, appKeyEncryptedAndCoded, xtraParams, conn);
				        			if(summaryDataJsonStr!= null && summaryDataJsonStr.trim().length() > 0 && summaryDataJsonStr.indexOf("Message :") == -1)
				        			{
				        				retXML += "<summary_data>" + XML.toString(new JSONObject(summaryDataJsonStr)) + "</summary_data>";
				        			}
				        			else if(summaryDataJsonStr.indexOf("Message :") >= 0)
				        			{
				        				retXML += summaryDataJsonStr;
				        			}
				        		}
				        		else if("GETINV".equalsIgnoreCase(action))
				        		{
				        			if(getGstrDataList.size() > 0)
				        			{
				        				for(HashMap<String,String> eachDataHamp : getGstrDataList)
				        				{
				        					String sectionName = eachDataHamp.get("section");
				        					JSONObject dataJSONObject = new JSONObject();
				        					dataJSONObject.put("token", eachDataHamp.get("token"));
				        					dataJSONObject.put("est", "");
				        					dataJSONObject.put("api_tranid", eachDataHamp.get("api_tranid"));
				        					String retDataXML = getDataFromFileServer(gstinNo, recType, periodCode, authToken, userName, stateCode, authSEK, dataJSONObject, sectionName, xtraParams);
				        					
				        					if("B2B".equalsIgnoreCase(sectionName))
							                {
				        						retXML += "<b2b_invoices>" + retDataXML + "</b2b_invoices>";
							                }
							                else if("B2CL".equalsIgnoreCase(action))
							                {
							                	retXML += "<b2cl_invoices>" + retDataXML + "</b2cl_invoices>";
							                }
							                else if("B2CS".equalsIgnoreCase(action))
							                {
							                	retXML += "<b2cs_invoices>" + retDataXML + "</b2cs_invoices>";
							                }
							                else if("CDNR".equalsIgnoreCase(action))
							                {
							                	retXML += "<cdnr_data>" + retDataXML + "</cdnr_data>";
							                }
							                else if("CDNUR".equalsIgnoreCase(action))
							                {
							                	retXML += "<cdnur_data>" + retDataXML + "</cdnur_data>";
							                }
							                else if("AT".equalsIgnoreCase(action))
							                {
							                	retXML += "<at_data>" + retDataXML +"</at_data>";
							                }
							                else if("TXP".equalsIgnoreCase(action))
							                {
							                	retXML += "<txp_data>" + retDataXML + "</txp_data>";
							                }
							                else if("NIL".equalsIgnoreCase(action))
							                {
							                	retXML += "<nil_data>" + retDataXML + "</nil_data>";
							                }
							                else if("EXP".equalsIgnoreCase(action))
							                {
							                	retXML += "<exp_data>" + retDataXML + "</exp_data>";
							                }
							                else if("HSNSUM".equalsIgnoreCase(action))
							                {
							                	retXML += "<hsnsum_data>" + retDataXML + "</hsnsum_data>";
							                }
				        				}
				        			}
				        			
				        			retXML += downloadGstr1Data(gstinNo, periodCode, authToken, userName, stateCode, appKeyEncryptedAndCoded, xtraParams, authSEK, byPassSectionList);
				        		}
				        	}
				        	if("GSTR2".equalsIgnoreCase(returnType))
				        	{
				        		if("SUBMIT".equalsIgnoreCase(action))
				        		{
				        			summaryDataJsonStr += getGstr2Summary(authToken, stateCode, userName, gstinNo, periodCode, authSEK, appKeyEncryptedAndCoded, xtraParams, conn);
				        			if(summaryDataJsonStr!= null && summaryDataJsonStr.trim().length() > 0 && summaryDataJsonStr.indexOf("Message :") == -1)
				        			{
				        				retXML += "<summary_data>" + XML.toString(new JSONObject(summaryDataJsonStr)) + "</summary_data>";
				        			}
				        			else if(summaryDataJsonStr.indexOf("Message :") >= 0)
				        			{
				        				retXML += summaryDataJsonStr;
				        			}
				        			retXML += downloadGstr2Data(gstinNo, periodCode, authToken, userName, stateCode, appKeyEncryptedAndCoded, xtraParams, authSEK, byPassSectionList);
				        		}
				        		else if("FILE".equalsIgnoreCase(action))
				        		{
				        			summaryDataJsonStr += getGstr2Summary(authToken, stateCode, userName, gstinNo, periodCode, authSEK, appKeyEncryptedAndCoded, xtraParams, conn);
				        			if(summaryDataJsonStr!= null && summaryDataJsonStr.trim().length() > 0 && summaryDataJsonStr.indexOf("Message :") == -1)
				        			{
				        				retXML += "<summary_data>" + XML.toString(new JSONObject(summaryDataJsonStr)) + "</summary_data>";
				        			}
				        			else if(summaryDataJsonStr.indexOf("Message :") >= 0)
				        			{
				        				retXML += summaryDataJsonStr;
				        			}
				        		}
				        		else if("GETINV".equalsIgnoreCase(action))
				        		{
				        			if(getGstrDataList.size() > 0)
				        			{
				        				for(HashMap<String,String> eachDataHamp : getGstrDataList)
				        				{
				        					String sectionName = eachDataHamp.get("section");
				        					JSONObject dataJSONObject = new JSONObject();
				        					dataJSONObject.put("token", eachDataHamp.get("token"));
				        					dataJSONObject.put("est", "");
				        					dataJSONObject.put("api_tranid", eachDataHamp.get("api_tranid"));
				        					String retDataXML = getDataFromFileServer(gstinNo, recType, periodCode, authToken, userName, stateCode, authSEK, dataJSONObject, sectionName, xtraParams);
				        					
				        					if("B2B".equalsIgnoreCase(sectionName))
							                {
				        						retXML += "<b2b_invoices>" + retDataXML + "</b2b_invoices>";
							                }
							                else if("IMPG".equalsIgnoreCase(action))
							                {
							                	retXML += "<impg_data>" + retDataXML + "</impg_data>";
							                }
							                else if("IMPS".equalsIgnoreCase(action))
							                {
							                	retXML += "<imps_data>" + retDataXML + "</imps_data>";
							                }
							                else if("CDN".equalsIgnoreCase(action))
							                {
							                	retXML += "<cdnr_data>" + retDataXML + "</cdnr_data>";
							                }
							                else if("CDNUR".equalsIgnoreCase(action))
							                {
							                	retXML += "<cdnur_data>" + retDataXML + "</cdnur_data>";
							                }
							                else if("NIL".equalsIgnoreCase(action))
							                {
							                	retXML += "<nil_data>" + retDataXML + "</nil_data>";
							                }
							                else if("TXLI".equalsIgnoreCase(action))
							                {
							                	retXML += "<txli_data>" + retDataXML + "</txli_data>";
							                }
							                else if("TXP".equalsIgnoreCase(action))
							                {
							                	retXML += "<txp_data>" + retDataXML + "</txp_data>";
							                }
							                else if("HSNSUM".equalsIgnoreCase(action))
							                {
							                	retXML += "<hsnsum_data>" + retDataXML + "</hsnsum_data>";
							                }
							                else if("B2BUR".equalsIgnoreCase(action))
							                {
							                	retXML += "<b2bur_data>" + retDataXML + "</b2bur_data>";
							                }
							                else if("ITCRVSL".equalsIgnoreCase(action))
							                {
							                	retXML += "<itcrvsl_data>" + retDataXML + "</itcrvsl_data>";
							                }
				        				}
				        			}
				        			
				        			retXML += downloadGstr2Data(gstinNo, periodCode, authToken, userName, stateCode, appKeyEncryptedAndCoded, xtraParams, authSEK, byPassSectionList);
				        		}
				        	}
				        	if("GSTR3B".equalsIgnoreCase(returnType))
				        	{
				        		if("SUBMIT".equalsIgnoreCase(action))
				        		{
				        			summaryDataJsonStr += getGstr3bSummary(authToken, stateCode, userName, gstinNo, periodCode, authSEK, appKeyEncryptedAndCoded, xtraParams, conn);
				        			if(summaryDataJsonStr!= null && summaryDataJsonStr.trim().length() > 0 && summaryDataJsonStr.indexOf("Message :") == -1)
				        			{
				        				retXML += "<summary_data>" + XML.toString(new JSONObject(summaryDataJsonStr)) + "</summary_data>";
				        			}
				        			else if(summaryDataJsonStr.indexOf("Message :") >= 0)
				        			{
				        				retXML += summaryDataJsonStr;
				        			}
				        		}
				        		else if("FILE".equalsIgnoreCase(action))
				        		{
				        			summaryDataJsonStr += getGstr3bSummary(authToken, stateCode, userName, gstinNo, periodCode, authSEK, appKeyEncryptedAndCoded, xtraParams, conn);
				        			if(summaryDataJsonStr!= null && summaryDataJsonStr.trim().length() > 0 && summaryDataJsonStr.indexOf("Message :") == -1)
				        			{
				        				retXML += "<summary_data>" + XML.toString(new JSONObject(summaryDataJsonStr)) + "</summary_data>";
				        			}
				        			else if(summaryDataJsonStr.indexOf("Message :") >= 0)
				        			{
				        				retXML += summaryDataJsonStr;
				        			}
				        		}
				        	}
				        }
				        
				        valueXmlString.append("<Detail2 domID='1'>");
				        valueXmlString.append("<auth_token><![CDATA["+ authToken +"]]></auth_token>");
				        valueXmlString.append("<auth_sek><![CDATA["+ sek +"]]></auth_sek>");
				        valueXmlString.append("<summary_data><![CDATA["+ summaryDataJsonStr +"]]></summary_data>");
				        valueXmlString.append(signDataXML);
				        valueXmlString.append("</Detail2>" );
				        valueXmlString.append("<Detail2 domID='2'>");
				        valueXmlString.append("<period_code><![CDATA["+periodCode+"]]></period_code>");
				        valueXmlString.append(retXML);
				        valueXmlString.append("</Detail2>" );
				        if(errorXML.trim().length() > 0)
				        {
				        	valueXmlString.append(errorXML);
				        }
					}
					break;
				}
			}
			valueXmlString.append( "</Root>" );	
		}
		catch (Exception e) 
		{
			System.out.println("GSTDataSubmitWizEJB.itemChanged()["+e.getMessage()+"]");
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(!conn.isClosed() && conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(SQLException se)
			{
				System.out.println("GSTDataSubmitWizEJB.itemChanged():finally block["+se.getMessage()+"]");
				se.printStackTrace();
			}
		}
		System.out.println("final return xml string["+valueXmlString.toString()+"]");
		return valueXmlString.toString();
	}
	
	@Override
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext,String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		System.out.println("GSTDataSubmitWiz.wfValData()");
		System.out.println("xmlString :"+xmlString);
		System.out.println("xmlString1 :"+xmlString1);
		System.out.println("xmlString2 :"+xmlString2);
		System.out.println("objContext :"+objContext);
		System.out.println("editFlag :"+editFlag);
		System.out.println("xtraParams :"+xtraParams);
		try
		{
			if (xmlString != null && xmlString.trim().length() > 0)
			{
				dom = parseString(xmlString);
			}
			if (xmlString1 != null && xmlString1.trim().length() > 0)
			{
				dom1 = parseString(xmlString1);
			}
			if (xmlString2 != null && xmlString2.trim().length() > 0)
			{
				dom2 = parseString(xmlString2);
			}
			System.out.println("Before calling function wfvalData****");
			errString = wfValData(dom, dom1, dom2, objContext, editFlag, xtraParams);

			System.out.println("After calling method wfVAlData Error String===="+errString);
		} 
		catch (Exception e)
		{
			System.out.println("Exception : [GSTDataSubmitWiz][wfValData( String, String )] :==>\n" + e.getMessage());
			throw new ITMException(e);
		}
		return errString;
	}
	@Override
	public String wfValData(Document currFormDataDom, Document hdrDataDom, Document allFormDataDom, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		String errString = "", userId = "", loginSiteCode = "";
		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
		int currentFormNo = 0;
		String sql = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String errorType = "", errCode = "";
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		E12GenericUtility e12GenericUtility = new E12GenericUtility();
		try
		{
			userId = e12GenericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			loginSiteCode = e12GenericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" );
			if (objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
				System.out.println("currentFormNo ["+currentFormNo+"]");
			}
			conn = getConnection();
			
			switch (currentFormNo)
			{
				case 1:
				{
					String returnType = "", action = "", periodCode = "", recType = "";
					NodeList parentList = null, childList = null;
					Node childNode = null;
					String childNodeName = "", columnValue = "";
					int noOfChilds = 0;
					parentList = currFormDataDom.getElementsByTagName( "Detail" + currentFormNo );
					childList = parentList.item( 0 ).getChildNodes();
					noOfChilds = childList.getLength();
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{	
						childNode = childList.item( ctr );
						childNodeName = childNode.getNodeName();
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
						if("period_code".equalsIgnoreCase(childNodeName))
						{
							sql = "SELECT COUNT(*) AS CNT FROM PERIOD WHERE TO_CHAR(TO_DATE(CODE,'yyyymm'),'mmyyyy') = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, columnValue);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								if(rs.getInt("CNT") == 0)
								{
									errList.add( "VTMONATD10" );
									errFields.add( childNodeName.toLowerCase() );
								}
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}
							if(rs!=null)
							{
								rs.close();
								rs = null;
							}
						}
						if("site_code".equalsIgnoreCase(childNodeName))
						{
							sql = "SELECT COUNT(*) AS CNT FROM SITE WHERE SITE_CODE = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, columnValue);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								if(rs.getInt("CNT") == 0)
								{
									errList.add( "INVDSITECD" );
									errFields.add( childNodeName.toLowerCase() );
								}
							}
							if(pstmt!=null)
							{
								pstmt.close();
								pstmt = null;
							}
							if(rs!=null)
							{
								rs.close();
								rs = null;
							}
						}
					}
					
					returnType = e12GenericUtility.getColumnValue("returns_type", hdrDataDom);
					action = e12GenericUtility.getColumnValue("action", hdrDataDom);
					periodCode = e12GenericUtility.getColumnValue("period_code", hdrDataDom);
					
					System.out.println("returnType["+returnType+"] action["+action+"] periodCode["+periodCode+"]");
					
					if("GSTR1".equalsIgnoreCase(returnType))
					{
						recType = "1";
					}
					else if("GSTR2".equalsIgnoreCase(returnType))
					{
						recType = "2";
					}
					else if("GSTR3".equalsIgnoreCase(returnType) || "GSTR3B".equalsIgnoreCase(returnType))
					{
						recType = "3";
					}
					
					if("SAVE".equalsIgnoreCase(action) && !"GSTR3B".equalsIgnoreCase(returnType))
					{
						sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'P' AND PRD_CODE = ? AND SITE_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, recType);
						pstmt.setString(2, periodCode);
						pstmt.setString(3, loginSiteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(rs.getInt("CNT") == 0)
							{
								errList.add( "VTNOGSDATA" );
								errFields.add("returns_type");
							}
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
						if(rs!=null)
						{
							rs.close();
							rs = null;
						}
					}
					if("SUBMIT".equalsIgnoreCase(action) && !"GSTR3B".equalsIgnoreCase(returnType))
					{
						sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'S' AND PRD_CODE = ? AND SITE_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, recType);
						pstmt.setString(2, periodCode);
						pstmt.setString(3, loginSiteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(rs.getInt("CNT") > 0)
							{
								errList.add( "VTSUBALRDY" );
								errFields.add("returns_type");
							}
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
						if(rs!=null)
						{
							rs.close();
							rs = null;
						}
						sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'T' AND PRD_CODE = ? AND SITE_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, recType);
						pstmt.setString(2, periodCode);
						pstmt.setString(3, loginSiteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(rs.getInt("CNT") == 0)
							{
								errList.add( "VTNORECSAV" );
								errFields.add("returns_type");
							}
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
						if(rs!=null)
						{
							rs.close();
							rs = null;
						}
					}
					if("FILE".equalsIgnoreCase(action) && !"GSTR3B".equalsIgnoreCase(returnType))
					{
						sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'S' AND PRD_CODE = ? AND SITE_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, recType);
						pstmt.setString(2, periodCode);
						pstmt.setString(3, loginSiteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(rs.getInt("CNT") == 0)
							{
								errList.add( "VTNORECSAV" );
								errFields.add("returns_type");
							}
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
						if(rs!=null)
						{
							rs.close();
							rs = null;
						}
						sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'R' AND PRD_CODE = ? AND SITE_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, recType);
						pstmt.setString(2, periodCode);
						pstmt.setString(3, loginSiteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(rs.getInt("CNT") > 0)
							{
								errList.add( "VTGSTFILE" );
								errFields.add("returns_type");
							}
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
						if(rs!=null)
						{
							rs.close();
							rs = null;
						}
					}
					if("FILE".equalsIgnoreCase(action))
					{
						sql = "SELECT COUNT(1) AS CNT FROM USER_SIGN_ACC WHERE USER_ID = ? AND DOC_TYPE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, userId);
						pstmt.setString(2, returnType);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(rs.getInt("CNT") == 0)
							{
								errList.add( "VTNOSIGCON" );
								errFields.add("returns_type");
							}
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
						if(rs!=null)
						{
							rs.close();
							rs = null;
						}
					}
					break;
				}
				case 2:
				{
					
					break;
				}
			}
			int errListSize = errList.size();
			String errFldName = null;
			if ( errList != null && errListSize > 0 )
			{
				for (int i = 0; i < errListSize; i++ )
				{
					errCode = (String)errList.get(i);
					errFldName = (String)errFields.get(i);
					System.out.println("errCode .........."+errCode);
					errString = getErrorString( errFldName, errCode, userId );
					errorType =  errorType( conn , errCode );
					if ( errString.length() > 0)
					{
						String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8,errString.indexOf("<trace>"));
						bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8,errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						System.out.println("errStringXml .........."+errStringXml);
						errString = "";
					}
					if ( errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				
				errStringXml.append("</Errors></Root>\r\n");
			}
			else
			{
				errStringXml = new StringBuffer( "" );
			}
			
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizEJB.wfValData()["+e.getMessage()+"]");
			e.printStackTrace();
		}
	
		return errStringXml.toString();
	}
	
	@Override
	public String handleRequest(HashMap<String, String> reqParamMap, UserInfoBean userInfo) throws ITMException 
	{
		String retResponseXML = "", action = "", dataAction = "", errorCode = "", dataErrMsg = "";
		String sql = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		boolean isDataError = false;
		try
		{
			action = reqParamMap.get("action");
			conn = getConnection();
			
			if("GENERATE_OTP".equalsIgnoreCase(action))
			{
				String userName = "", stateCode = "", gspAuthString = "", gspAuthSignature = "", gstinNo = "", periodCode = "", siteCode = "", recType = "", recordType = "";
				String responseId = "", responseJsonStr = "", callStatus = "";
				String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
				
				if("NULLFOUND".equalsIgnoreCase(clientId) || "NULLFOUND".equalsIgnoreCase(clientSecret))
				{
					retResponseXML = "<root><message><![CDATA[Client ID/Client secret API configuration is missing.]]></message></root>";
					return retResponseXML;
				}
				
				userName = reqParamMap.get("user_name");
				stateCode = reqParamMap.get("state_code");
				gstinNo = reqParamMap.get("gstin_no");
				periodCode = reqParamMap.get("period_code");
				siteCode = reqParamMap.get("site_code");
				dataAction = reqParamMap.get("data_action");
				recordType = reqParamMap.get("rec_type");
				
				if("GSTR1".equalsIgnoreCase(recordType))
				{
					recType = "1";
				}
				else if("GSTR2".equalsIgnoreCase(recordType))
				{
					recType = "2";
				}
				else if("GSTR3".equalsIgnoreCase(recordType))
				{
					recType = "3";
				}
				else if("GSTR3B".equalsIgnoreCase(recordType))
				{
					recType = "6";
				}
				else if("GSTR2A".equalsIgnoreCase(recordType))
				{
					recType = "4";
				}
				
				if("SAVE".equalsIgnoreCase(dataAction))
				{
					if(!isDataError)
					{
						sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'P' AND PRD_CODE = ? AND SITE_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, recType);
						pstmt.setString(2, periodCode);
						pstmt.setString(3, siteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(rs.getInt("CNT") == 0)
							{
								isDataError = true;
								errorCode =  "VTNOGSDATA";
							}
						}
						closeResources(rs, pstmt);
					}
					
					if(!isDataError)
					{
						sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS IN ('U','N','D') AND PRD_CODE = ? AND SITE_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, recType);
						pstmt.setString(2, periodCode);
						pstmt.setString(3, siteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(rs.getInt("CNT") > 0)
							{
								isDataError = true;
								errorCode =  "VTCHKRETST";
							}
						}
						closeResources(rs, pstmt);
					}
					
					if(!isDataError)
					{
						sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'S' AND PRD_CODE = ? AND SITE_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, recType);
						pstmt.setString(2, periodCode);
						pstmt.setString(3, siteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(rs.getInt("CNT") > 0)
							{
								isDataError = true;
								errorCode =  "VTSUBALRDY";
							}
						}
						closeResources(rs, pstmt);
					}
					
					if(!isDataError)
					{
						sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'R' AND PRD_CODE = ? AND SITE_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, recType);
						pstmt.setString(2, periodCode);
						pstmt.setString(3, siteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(rs.getInt("CNT") > 0)
							{
								isDataError = true;
								errorCode = "VTFILALRDY";
							}
						}
						closeResources(rs, pstmt);
					}
				}
				else if("SUBMIT".equalsIgnoreCase(dataAction))
				{
					if(!isDataError)
					{
						sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'S' AND PRD_CODE = ? AND SITE_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, recType);
						pstmt.setString(2, periodCode);
						pstmt.setString(3, siteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(rs.getInt("CNT") > 0)
							{
								isDataError = true;
								errorCode =  "VTSUBALRDY";
							}
						}
						closeResources(rs, pstmt);
					}
					
					if(!isDataError)
					{
						sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS IN ('U','N','D') AND PRD_CODE = ? AND SITE_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, recType);
						pstmt.setString(2, periodCode);
						pstmt.setString(3, siteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(rs.getInt("CNT") > 0)
							{
								isDataError = true;
								errorCode =  "VTCHKRETST";
							}
						}
						closeResources(rs, pstmt);
					}
					
					if(!isDataError)
					{
						sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'T' AND PRD_CODE = ? AND SITE_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, recType);
						pstmt.setString(2, periodCode);
						pstmt.setString(3, siteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(rs.getInt("CNT") == 0)
							{
								isDataError = true;
								errorCode = "VTNORECSAV";
							}
						}
						closeResources(rs, pstmt);
					}
					if(!isDataError)
					{
						sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'R' AND PRD_CODE = ? AND SITE_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, recType);
						pstmt.setString(2, periodCode);
						pstmt.setString(3, siteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(rs.getInt("CNT") > 0)
							{
								isDataError = true;
								errorCode = "VTFILALRDY";
							}
						}
						closeResources(rs, pstmt);
					}
				}
				else if("FILE".equalsIgnoreCase(dataAction))
				{
					if(!isDataError)
					{
						sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'S' AND PRD_CODE = ? AND SITE_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, recType);
						pstmt.setString(2, periodCode);
						pstmt.setString(3, siteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(rs.getInt("CNT") == 0)
							{
								isDataError = true;
								errorCode = "VTGSTSUBPN";
							}
						}
						closeResources(rs, pstmt);
					}
					
					if(!isDataError)
					{
						sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS IN ('U','N','D') AND PRD_CODE = ? AND SITE_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, recType);
						pstmt.setString(2, periodCode);
						pstmt.setString(3, siteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(rs.getInt("CNT") > 0)
							{
								isDataError = true;
								errorCode =  "VTCHKRETST";
							}
						}
						closeResources(rs, pstmt);
					}
					
					if(!isDataError)
					{
						sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'R' AND PRD_CODE = ? AND SITE_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, recType);
						pstmt.setString(2, periodCode);
						pstmt.setString(3, siteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(rs.getInt("CNT") > 0)
							{
								isDataError = true;
								errorCode = "VTGSTFILE";
							}
						}
						closeResources(rs, pstmt);
					}
				}
				else if("GETINV".equalsIgnoreCase(dataAction))
				{
					if(!"GSTR2A".equalsIgnoreCase(recordType))
					{
						sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS IN ('T','S','R') AND PRD_CODE = ? AND SITE_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, recType);
						pstmt.setString(2, periodCode);
						pstmt.setString(3, siteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(rs.getInt("CNT") == 0)
							{
								isDataError = true;
								errorCode = "VTNORECSAV";
							}
						}
						closeResources(rs, pstmt);
					}
					/*if("GSTR2A".equalsIgnoreCase(recordType))
					{
						sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS IN ('A') AND PRD_CODE = ? AND SITE_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, recType);
						pstmt.setString(2, periodCode);
						pstmt.setString(3, siteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(rs.getInt("CNT") > 0)
							{
								isDataError = true;
								errorCode = "VTDWNALRDY";
							}
						}
						closeResources(rs, pstmt);
					}*/
					
				}
				else if("DELETE".equalsIgnoreCase(dataAction))
				{
					int saveRecCnt = 0;
					
					if(!isDataError)
					{
						sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS IN ('U','N','D') AND PRD_CODE = ? AND SITE_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, recType);
						pstmt.setString(2, periodCode);
						pstmt.setString(3, siteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(rs.getInt("CNT") > 0)
							{
								isDataError = true;
								errorCode =  "VTCHKRETST";
							}
						}
						closeResources(rs, pstmt);
					}
					
					if(!isDataError)
					{
						sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'T' AND PRD_CODE = ? AND SITE_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, recType);
						pstmt.setString(2, periodCode);
						pstmt.setString(3, siteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							saveRecCnt = rs.getInt("CNT");
							if(saveRecCnt == 0)
							{
								isDataError = true;
								errorCode =  "VTNORECDEL";
							}
						}
						closeResources(rs, pstmt);
						
						if(saveRecCnt == 0)
						{
							int pendRecDnt = 0;
							
							sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'P' AND PRD_CODE = ? AND SITE_CODE = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, recType);
							pstmt.setString(2, periodCode);
							pstmt.setString(3, siteCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								pendRecDnt = rs.getInt("CNT");
								if(pendRecDnt == 0)
								{
									isDataError = true;
									errorCode =  "VTNDGSDATA";
								}
								else
								{
									isDataError = true;
									errorCode =  "VTPENGSDAT";
								}
							}
							closeResources(rs, pstmt);
						}
					}
					
					if(!isDataError)
					{
						sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'S' AND PRD_CODE = ? AND SITE_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, recType);
						pstmt.setString(2, periodCode);
						pstmt.setString(3, siteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(rs.getInt("CNT") > 0)
							{
								isDataError = true;
								errorCode =  "VTSUBALRDY";
							}
						}
						closeResources(rs, pstmt);
					}
					
					if(!isDataError)
					{
						sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'R' AND PRD_CODE = ? AND SITE_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, recType);
						pstmt.setString(2, periodCode);
						pstmt.setString(3, siteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(rs.getInt("CNT") > 0)
							{
								isDataError = true;
								errorCode = "VTFILALRDY";
							}
						}
						closeResources(rs, pstmt);
					}
				}
				else if("RETSTATUS".equalsIgnoreCase(dataAction))
				{
					if(!isDataError)
					{
						sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS IN ('U','N','D') AND PRD_CODE = ? AND SITE_CODE = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, recType);
						pstmt.setString(2, periodCode);
						pstmt.setString(3, siteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							if(rs.getInt("CNT") == 0)
							{
								isDataError = true;
								errorCode =  "VTNOCHKDAT";
							}
						}
						closeResources(rs, pstmt);
					}
				}
				
				if(!isDataError)
				{
					//Changed by Santosh on 03/10/2017 as per new GSP token format
					//gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstinNo;
			        String timeStamp = gspTokenTimeFormatter.format(new Date());
			        gspAuthString = "v2.0::"+clientId + ":" + transactionId + ":" + timeStamp + ":" + gstinNo + ":" + "OTPREQUEST";
					gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
					
					JSONObject otpRequest = new JSONObject();
			        otpRequest.put("action", "OTPREQUEST");
			        otpRequest.put("app_key", appKeyEncryptedAndCoded);
			        otpRequest.put("username", userName);

			        HttpRequest otpReq = Unirest.post(String.format("%s%s", BASE_API_URL,AUTH_TOKEN_URL))
						        		.header("Content-Type", APPLICATION_JSON)
						                .header("clientid", clientId)
						                .header("client-secret", clientSecret)
						                .header("state-cd", stateCode)
						                .header("ip-usr", ipAddress)
						                .header("username", userName)
						                .header("txn", transactionId)
						                .header("app_key", appKeyEncryptedAndCoded)
						                .header("X-Asp-Auth-Token", gspAuthString)
				    	                .header("X-Asp-Auth-Signature", gspAuthSignature)
						                .body(new JsonNode(otpRequest.toString()))
						                .getHttpRequest();
			        
			        System.out.println("OTP url["+otpReq.getUrl()+"]");
			        System.out.println("OTP method["+otpReq.getHttpMethod()+"]");
					System.out.println("OTP request header["+otpReq.getHeaders()+"]");
					System.out.println("OTP request payload["+IOUtils.toString(otpReq.getBody().getEntity().getContent())+"]");
			        
			        HttpResponse<JsonNode> otpResp =  otpReq.asJson();

			        System.out.println(String.format("OTP Request : Status[%s] Response[%s]", otpResp.getStatus(), otpResp.getBody()));

			        if (otpResp.getStatus() == 200) 
			        {
			            JSONObject object = otpResp.getBody().getObject();
			            if( object.has("status_cd") && "1".equalsIgnoreCase(object.getString("status_cd")))
			            {
			            	callStatus = "1";
			            	retResponseXML = "<root><message><![CDATA["+object.getString("status_cd")+"]]></message></root>";
			            }
			            else
			            {
			            	callStatus = "2";
			            	JSONObject errorJSON = otpResp.getBody().getObject().getJSONObject("error");
			            	responseJsonStr = errorJSON.toString();
			            	retResponseXML = "<root><message><![CDATA[Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd")+"]]></message></root>";
			            }
			        }
			        else if(otpResp.getStatus() == 500)
			        {
			        	callStatus = "2";
			        	String errMsg = "Message : Error occurred at GSTN server \nResponse code : "+otpResp.getStatus();
			        	responseJsonStr = errMsg;
			        	retResponseXML = "<root><message><![CDATA[Message : "+errMsg+" \nError code : "+otpResp.getStatus()+"]]></message></root>";
			        }
			        else
			        {
			        	callStatus = "2";
			        	JSONObject errorJSON = otpResp.getBody().getObject().getJSONObject("error");
			        	responseJsonStr = errorJSON.toString();
			        	retResponseXML = "<root><message><![CDATA[Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd")+"]]></message></root>";
			        }
			        
			        APICallData apiCallData = new APICallData();
			        apiCallData.setPeriodCode(periodCode);
			        apiCallData.setCallDate(new Date());
			        apiCallData.setSiteCode(siteCode);
			        apiCallData.setUserId(userInfo.getLoginCode());
			        apiCallData.setCallType("OTPREQUEST");
			        apiCallData.setRecType(recType);
			        apiCallData.setNoOfRecords(0);
			        apiCallData.setCallStatus(callStatus);
			        apiCallData.setResponseId(responseId);
			        apiCallData.setResponseJsonStr(responseJsonStr);
			        apiCallData.setChgUser(userInfo.getLoginCode());
			        apiCallData.setChgDate(new Date());
			        apiCallData.setChgTerm(userInfo.getRemoteHost());
			        
			        gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
				}
				else
				{
					sql = "SELECT MSG_DESCR FROM MESSAGES WHERE MSG_NO = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, errorCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						dataErrMsg = rs.getString("MSG_DESCR");
					}
					closeResources(rs, pstmt);
					
					retResponseXML = "<root><message><![CDATA[Message : "+dataErrMsg+"]]></message></root>";
				}
			}
			else if ("ITEM_CHANGE".equalsIgnoreCase(action))
			{
				String currColumn = "", currFieldData = "", siteDescr = "", gstinNo = "", userName = "", stateCode = "", stateDescr = "", grossTurnover = "";
				
				currColumn = reqParamMap.get("focused_column");
				currFieldData = reqParamMap.get("data_value");
				
				System.out.println("custom itemchange logic for ["+currColumn+"] and data["+currFieldData+"]");
				if("SITE_CODE".equalsIgnoreCase(currColumn))
				{
					sql = " SELECT S.SITE_CODE, S.SH_DESCR, ST.GST_CODE, ST.DESCR, SR.REF_CODE, SR.REG_NO FROM SITE S, SITEREGNO SR, STATE ST"
						+ "	WHERE S.SITE_CODE = SR.SITE_CODE AND S.FIN_ENTITY = SR.FIN_ENTITY AND S.STATE_CODE = ST.STATE_CODE AND SR.REF_CODE IN ('GSTIN_NO','GST_UNAME','GST_GT')"
						+ " AND SR.SITE_CODE =  ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, currFieldData);
					rs = pstmt.executeQuery();
					
					while(rs.next())
					{
						siteDescr = checkNull(rs.getString("SH_DESCR"));
						if("GSTIN_NO".equalsIgnoreCase(checkNull(rs.getString("REF_CODE"))))
						{
							gstinNo = checkNull(rs.getString("REG_NO"));
						}
						if("GST_UNAME".equalsIgnoreCase(checkNull(rs.getString("REF_CODE"))))
						{
							userName = checkNull(rs.getString("REG_NO"));
						}
						if("GST_GT".equalsIgnoreCase(checkNull(rs.getString("REF_CODE"))))
						{
							grossTurnover = checkNull(rs.getString("REG_NO"));
						}
						stateCode = checkNull(rs.getString("GST_CODE"));
						stateDescr = checkNull(rs.getString("DESCR"));
					}
					closeResources(rs, pstmt);
					
					retResponseXML = "<root><Detail1>"
								   + "<site_descr><![CDATA["+siteDescr+"]]></site_descr>"
								   + "<gstin><![CDATA["+gstinNo+"]]></gstin>"
								   + "<username><![CDATA["+userName+"]]></username>"
								   + "<state_code><![CDATA["+stateCode+"]]></state_code>"
								   + "<state_descr><![CDATA["+stateDescr+"]]></state_descr>"
								   + "<gross_turnover><![CDATA["+grossTurnover+"]]></gross_turnover>"
								   + "</Detail1></root>";
					
				}
			}
			else if("GET_GSTR3B_DATA".equalsIgnoreCase(action))
			{
				String gstr3bXMLStr = "", siteCode = "", periodCode = "";
				siteCode = reqParamMap.get("site_code");
				periodCode = reqParamMap.get("period_code");
				
				sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND PRD_CODE = ? AND SITE_CODE = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, "6");
				pstmt.setString(2, periodCode);
				pstmt.setString(3, siteCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					if(rs.getInt("CNT") == 0)
					{
						isDataError = true;
						errorCode =  "VTNOGSDATA";
					}
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				
				if(!isDataError)
				{
					gstr3bXMLStr = getGSTR3BXMLData(siteCode, periodCode, conn);
					String xslFilePath = CommonConstants.APPLICATION_CONTEXT + "webitm" + File.separator + "xsl"+ File.separator + "Standard"+ File.separator + "WIZARD" + File.separator + "Galaxy"+ File.separator + "gstr3bdata_wiz_en_US_A.xsl";
					retResponseXML = e12GenericUtility.transformToString( xslFilePath, gstr3bXMLStr, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
				}
				else
				{
					sql = "SELECT MSG_DESCR FROM MESSAGES WHERE MSG_NO = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, errorCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						dataErrMsg = rs.getString("MSG_DESCR");
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					
					retResponseXML = "<root><error_message><![CDATA[Message : "+dataErrMsg+"]]></error_message></root>";
				}
			}
		}
		catch (Exception e) 
		{
			System.out.println("GSTDataSubmitWizEJB.handleRequest()["+e.getMessage()+"]");
			e.printStackTrace();
			retResponseXML = "<root><message><![CDATA[Message :"+e.getMessage()+"]]></message></root>";
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(!conn.isClosed() && conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(SQLException se)
			{
				System.out.println("GSTDataSubmitWizEJB.handleRequest():finally block["+se.getMessage()+"]");
				se.printStackTrace();
			}
		}
		System.out.println("final retResonseXML ["+retResponseXML+"]");
		return retResponseXML;
	}
	private String downloadGstr1Data (String gstinNo, String periodCode, String authToken, String userName, String stateCode, String appKeyEncryptedAndCoded, String xtraParams, byte[] authSek, ArrayList<String> byPassSectionList) throws ITMException
	{
		StringBuffer retStringBuff = new StringBuffer();
		String[] gstr1Section = {"B2B","B2CL","B2CS","CDNR","AT","TXP","NIL","EXP","HSNSUM","CDNUR"};
		String gspAuthString = "", gspAuthSignature = "";
		String siteCode = "", loginCode = "", chgTerm = "", callStatus = "", responseId = "", responseJsonStr= "", dataXML = "";
		
		try
		{
			siteCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			
			for(String action : gstr1Section)
			{
				if(byPassSectionList != null && !byPassSectionList.contains(action))
				{
					//long timeStamp = new Timestamp().getDateTime();
					System.out.println("calling for ["+action+"]");
					String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
					
					//Changed by Santosh on 03/10/2017 as per new GSP token format
					//gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstinNo;
			        String timeStamp = gspTokenTimeFormatter.format(new Date());
			        gspAuthString = "v2.0::"+clientId + ":" + transactionId + ":" + timeStamp + ":" + gstinNo + ":" + action;
					gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
					
					HttpRequest getDataReq = Unirest.get(String.format("%s%s", BASE_API_URL, GSTR1_URL))
					        				 .queryString("action", action)
					        				 .queryString("gstin", gstinNo)
					        				 .queryString("ret_period", periodCode)
					        				 .header("Content-Type", APPLICATION_JSON)
					        				 .header("state-cd", stateCode)
					        				 .header("clientid", clientId)
					        				 .header("client-secret", clientSecret)
					        				 .header("ip-usr", ipAddress)
					        				 .header("username", userName)
					        				 .header("auth-token", authToken)
					        				 .header("app_key", appKeyEncryptedAndCoded)
					        				 .header("txn", transactionId)
					        				 .header("ret_period", periodCode)
					        				 .header("gstin", gstinNo)
					        				 .header("X-Asp-Auth-Token", gspAuthString)
						    	             .header("X-Asp-Auth-Signature", gspAuthSignature)
					        				 .getHttpRequest();
					
					System.out.println("get GSTR1 ["+action+"] invoices url["+getDataReq.getUrl()+"]");
			        System.out.println("get GSTR1 ["+action+"] invoices method["+getDataReq.getHttpMethod()+"]");
					System.out.println("get GSTR1 ["+action+"] invoices request header["+getDataReq.getHeaders()+"]");
					
					HttpResponse<JsonNode> getDataResp = getDataReq.asJson();
					
					System.out.println("getDataResp.getStatus()["+getDataResp.getStatus()+"]");
					
					if(getDataResp.getStatus() == 200)
					{
						JSONObject getDataRespObj = getDataResp.getBody().getObject();
						if(getDataRespObj.has("data") && getDataRespObj.has("rek"))
						{
							String getdata = getDataRespObj.getString("data");
			                String getrek = getDataRespObj.getString("rek");

			                byte[] getapiEK = aesEncryption.decrypt(getrek, authSek);

			                String getrespJsoninBase64 = new String(aesEncryption.decrypt(getdata, getapiEK));

			                byte[] getrespJsonInBytes = aesEncryption.decodeBase64StringTOByte(getrespJsoninBase64);

			                String getjsonData = new String(getrespJsonInBytes);
			                System.out.println("json response["+getjsonData+"] for ["+action+"]");
			                
			                JSONObject getJsonDataJsonObj = new JSONObject(getjsonData);
			                
			                if(getJsonDataJsonObj.has("est") && getJsonDataJsonObj.has("token"))
			                {
			                	responseId = getJsonDataJsonObj.getString("token");
			                	callStatus = "0";
			                	dataXML = getDataFromFileServer(gstinNo, "1", periodCode, authToken, userName, stateCode, authSek, getJsonDataJsonObj, action, xtraParams);
			                }
			                else
			                {
			                	callStatus = "1";
			                	dataXML = XML.toString(getJsonDataJsonObj);
			                }
			                
			                if("B2B".equalsIgnoreCase(action))
			                {
			                	retStringBuff.append("<b2b_invoices>");
			                	retStringBuff.append(dataXML);
			                	retStringBuff.append("</b2b_invoices>");
			                }
			                else if("B2CL".equalsIgnoreCase(action))
			                {
			                	retStringBuff.append("<b2cl_invoices>");
			                	retStringBuff.append(dataXML);
			                	retStringBuff.append("</b2cl_invoices>");
			                }
			                else if("B2CS".equalsIgnoreCase(action))
			                {
			                	retStringBuff.append("<b2cs_invoices>");
			                	retStringBuff.append(dataXML);
			                	retStringBuff.append("</b2cs_invoices>");
			                }
			                else if("CDNR".equalsIgnoreCase(action))
			                {
			                	retStringBuff.append("<cdnr_data>");
			                	retStringBuff.append(dataXML);
			                	retStringBuff.append("</cdnr_data>");
			                }
			                else if("CDNUR".equalsIgnoreCase(action))
			                {
			                	retStringBuff.append("<cdnur_data>");
			                	retStringBuff.append(dataXML);
			                	retStringBuff.append("</cdnur_data>");
			                }
			                else if("AT".equalsIgnoreCase(action))
			                {
			                	retStringBuff.append("<at_data>");
			                	retStringBuff.append(dataXML);
			                	retStringBuff.append("</at_data>");
			                }
			                else if("TXP".equalsIgnoreCase(action))
			                {
			                	retStringBuff.append("<txp_data>");
			                	retStringBuff.append(dataXML);
			                	retStringBuff.append("</txp_data>");
			                }
			                else if("NIL".equalsIgnoreCase(action))
			                {
			                	retStringBuff.append("<nil_data>");
			                	retStringBuff.append(dataXML);
			                	retStringBuff.append("</nil_data>");
			                }
			                else if("EXP".equalsIgnoreCase(action))
			                {
			                	retStringBuff.append("<exp_data>");
			                	retStringBuff.append(dataXML);
			                	retStringBuff.append("</exp_data>");
			                }
			                else if("HSNSUM".equalsIgnoreCase(action))
			                {
			                	retStringBuff.append("<hsnsum_data>");
			                	retStringBuff.append(dataXML);
			                	retStringBuff.append("</hsnsum_data>");
			                }
						}
						else
						{
							callStatus = "2";
							JSONObject errorJSON = getDataResp.getBody().getObject().getJSONObject("error");
							responseJsonStr = errorJSON.toString();
				        	System.out.println("errorJSON["+errorJSON+"]");
						}
					}
					else if(getDataResp.getStatus() == 500)
			        {
			        	callStatus = "2";
			        	String errMsg = "Message : Error occurred at GSTN server \nResponse code : "+getDataResp.getStatus();
			        	responseJsonStr = errMsg;
			        	System.out.println("errMsg["+errMsg+"]");
			        }
					else
		            {
						callStatus = "2";
		            	JSONObject errorJSON = getDataResp.getBody().getObject().getJSONObject("error");
		            	responseJsonStr = errorJSON.toString();
		            	System.out.println("errorJSON["+errorJSON+"]");
		            }
					
					APICallData apiCallData = new APICallData();
			        apiCallData.setPeriodCode(periodCode);
			        apiCallData.setCallDate(new Date());
			        apiCallData.setSiteCode(siteCode);
			        apiCallData.setUserId(loginCode);
			        apiCallData.setCallType("GET_"+action);
			        apiCallData.setRecType("1");
			        apiCallData.setNoOfRecords(0);
			        apiCallData.setCallStatus(callStatus);
			        apiCallData.setResponseId(responseId);
			        apiCallData.setResponseJsonStr(responseJsonStr);
			        apiCallData.setChgUser(loginCode);
			        apiCallData.setChgDate(new Date());
			        apiCallData.setChgTerm(chgTerm);
			        
			        gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
				}
			}
		}
		catch (Exception e) 
		{
			System.out.println("GSTDataSubmitWizEJB.downloadGstr1Data()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("final retStringBuff.toSting["+retStringBuff.toString()+"]");
		return retStringBuff.toString();
	}
	private String downloadGstr2Data (String gstinNo, String periodCode, String authToken, String userName, String stateCode, String appKeyEncryptedAndCoded, String xtraParams, byte[] authSek, ArrayList<String> byPassSectionList) throws ITMException
	{
		StringBuffer retStringBuff = new StringBuffer();
		String[] gstr2Section = {"B2B","IMPG","IMPS","CDN","NIL","TXLI","TXP","HSNSUM","B2BUR","ITCRVSL","CDNUR"};
		String gspAuthString = "", gspAuthSignature = "";
		String siteCode = "", loginCode = "", chgTerm = "", callStatus = "", responseId = "", responseJsonStr= "";
		
		try
		{
			siteCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");

			for(String action : gstr2Section)
			{
				if(byPassSectionList != null && !byPassSectionList.contains(action))
				{
					//long timeStamp = new Timestamp().getDateTime();
					System.out.println("calling for ["+action+"]");
					String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
					
					//Changed by Santosh on 03/10/2017 as per new GSP token format
					//gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstinNo;
			        String timeStamp = gspTokenTimeFormatter.format(new Date());
			        gspAuthString = "v2.0::"+clientId + ":" + transactionId + ":" + timeStamp + ":" + gstinNo + ":" + action;
					gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
					
					HttpRequest getDataReq = Unirest.get(String.format("%s%s", BASE_API_URL,GSTR2_URL))
					        				 .queryString("action", action)
					        				 .queryString("gstin", gstinNo)
					        				 .queryString("ret_period", periodCode)
					        				 .header("Content-Type", APPLICATION_JSON)
					        				 .header("state-cd", stateCode)
					        				 .header("clientid", clientId)
					        				 .header("client-secret", clientSecret)
					        				 .header("ip-usr", ipAddress)
					        				 .header("username", userName)
					        				 .header("auth-token", authToken)
					        				 .header("app_key", appKeyEncryptedAndCoded)
					        				 .header("txn", transactionId)
					        				 .header("ret_period", periodCode)
					        				 .header("gstin", gstinNo)
					        				 .header("X-Asp-Auth-Token", gspAuthString)
						    	             .header("X-Asp-Auth-Signature", gspAuthSignature)
					        				 .getHttpRequest();
					
					System.out.println("get GSTR2 ["+action+"] invoices url["+getDataReq.getUrl()+"]");
			        System.out.println("get GSTR2 ["+action+"] invoices method["+getDataReq.getHttpMethod()+"]");
					System.out.println("get GSTR2 ["+action+"] invoices request header["+getDataReq.getHeaders()+"]");
					
					HttpResponse<JsonNode> getDataResp = getDataReq.asJson();
					
					System.out.println("getDataResp.getStatus()["+getDataResp.getStatus()+"]");
					
					if(getDataResp.getStatus() == 200)
					{
						JSONObject getDataRespObj = getDataResp.getBody().getObject();
						if(getDataRespObj.has("data") && getDataRespObj.has("rek"))
						{
							callStatus = "1";
							String getdata = getDataRespObj.getString("data");
			                String getrek = getDataRespObj.getString("rek");

			                byte[] getapiEK = aesEncryption.decrypt(getrek, authSek);

			                String getrespJsoninBase64 = new String(aesEncryption.decrypt(getdata, getapiEK));

			                byte[] getrespJsonInBytes = aesEncryption.decodeBase64StringTOByte(getrespJsoninBase64);

			                String getjsonData = new String(getrespJsonInBytes);
			                System.out.println("json response["+getjsonData+"] for ["+action+"]");
			                
			                if("B2B".equalsIgnoreCase(action))
			                {
			                	String b2bXML = XML.toString(new JSONObject(new String(getrespJsonInBytes)));
			                	retStringBuff.append("<b2b_invoices>");
			                	retStringBuff.append(b2bXML);
			                	retStringBuff.append("</b2b_invoices>");
			                }
			                else if("IMPG".equalsIgnoreCase(action))
			                {
			                	String impgXML = XML.toString(new JSONObject(new String(getrespJsonInBytes)));
			                	retStringBuff.append("<impg_data>");
			                	retStringBuff.append(impgXML);
			                	retStringBuff.append("</impg_data>");
			                }
			                else if("IMPS".equalsIgnoreCase(action))
			                {
			                	String impsXML = XML.toString(new JSONObject(new String(getrespJsonInBytes)));
			                	retStringBuff.append("<imps_data>");
			                	retStringBuff.append(impsXML);
			                	retStringBuff.append("</imps_data>");
			                }
			                else if("CDN".equalsIgnoreCase(action))
			                {
			                	String cdnrXML = XML.toString(new JSONObject(new String(getrespJsonInBytes)));
			                	retStringBuff.append("<cdnr_data>");
			                	retStringBuff.append(cdnrXML);
			                	retStringBuff.append("</cdnr_data>");
			                }
			                else if("CDNUR".equalsIgnoreCase(action))
			                {
			                	String cdnurXML = XML.toString(new JSONObject(new String(getrespJsonInBytes)));
			                	retStringBuff.append("<cdnur_data>");
			                	retStringBuff.append(cdnurXML);
			                	retStringBuff.append("</cdnur_data>");
			                }
			                else if("NIL".equalsIgnoreCase(action))
			                {
			                	String nilData = XML.toString(new JSONObject(new String(getrespJsonInBytes)));
			                	retStringBuff.append("<nil_data>");
			                	retStringBuff.append(nilData);
			                	retStringBuff.append("</nil_data>");
			                }
			                else if("TXLI".equalsIgnoreCase(action))
			                {
			                	String taxLiabXML = XML.toString(new JSONObject(new String(getrespJsonInBytes)));
			                	retStringBuff.append("<txli_data>");
			                	retStringBuff.append(taxLiabXML);
			                	retStringBuff.append("</txli_data>");
			                }
			                else if("TXP".equalsIgnoreCase(action))
			                {
			                	String taxPaidXML = XML.toString(new JSONObject(new String(getrespJsonInBytes)));
			                	retStringBuff.append("<txp_data>");
			                	retStringBuff.append(taxPaidXML);
			                	retStringBuff.append("</txp_data>");
			                }
			                else if("HSNSUM".equalsIgnoreCase(action))
			                {
			                	String hsnSumXML = XML.toString(new JSONObject(new String(getrespJsonInBytes)));
			                	retStringBuff.append("<hsnsum_data>");
			                	retStringBuff.append(hsnSumXML);
			                	retStringBuff.append("</hsnsum_data>");
			                }
			                else if("B2BUR".equalsIgnoreCase(action))
			                {
			                	String b2burXML = XML.toString(new JSONObject(new String(getrespJsonInBytes)));
			                	retStringBuff.append("<b2bur_data>");
			                	retStringBuff.append(b2burXML);
			                	retStringBuff.append("</b2bur_data>");
			                }
			                else if("ITCRVSL".equalsIgnoreCase(action))
			                {
			                	String itcRverslXML = XML.toString(new JSONObject(new String(getrespJsonInBytes)));
			                	retStringBuff.append("<itcrvsl_data>");
			                	retStringBuff.append(itcRverslXML);
			                	retStringBuff.append("</itcrvsl_data>");
			                }
						}
						else
						{
							callStatus = "2";
							JSONObject errorJSON = getDataResp.getBody().getObject().getJSONObject("error");
							responseJsonStr = errorJSON.toString();
				        	System.out.println("errorJSON["+errorJSON+"]");
						}
					}
					else if(getDataResp.getStatus() == 500)
			        {
			        	callStatus = "2";
			        	String errMsg = "Message : Error occurred at GSTN server \nResponse code : "+getDataResp.getStatus();
			        	responseJsonStr = errMsg;
			        	System.out.println("errMsg["+errMsg+"]");
			        }
					else
		            {
						callStatus = "2";
		            	JSONObject errorJSON = getDataResp.getBody().getObject().getJSONObject("error");
		            	responseJsonStr = errorJSON.toString();
		            	System.out.println("errorJSON["+errorJSON+"]");
		            }
					
					APICallData apiCallData = new APICallData();
			        apiCallData.setPeriodCode(periodCode);
			        apiCallData.setCallDate(new Date());
			        apiCallData.setSiteCode(siteCode);
			        apiCallData.setUserId(loginCode);
			        apiCallData.setCallType("GET_"+action);
			        apiCallData.setRecType("2");
			        apiCallData.setNoOfRecords(0);
			        apiCallData.setCallStatus(callStatus);
			        apiCallData.setResponseId(responseId);
			        apiCallData.setResponseJsonStr(responseJsonStr);
			        apiCallData.setChgUser(loginCode);
			        apiCallData.setChgDate(new Date());
			        apiCallData.setChgTerm(chgTerm);
			        
			        gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
				}
			}
		}
		catch (Exception e) 
		{
			System.out.println("GSTDataSubmitWizEJB.downloadGstr2Data()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("final retStringBuff.toSting["+retStringBuff.toString()+"]");
		return retStringBuff.toString();
	}
	private String getGstr1Summary(String authToken, String stateCode, String userName, String gstin, String periodCode, byte[] authSek, String appKeyEncryptedAndCoded, String xtraParams, Connection conn) throws ITMException
	{
		String retString = "";
		String errMsg = "", gspAuthString = "", gspAuthSignature = "";
		String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
		String siteCode = "", loginCode = "", chgTerm = "", callStatus = "", responseId = "", responseJsonStr= "";
		
		try
		{
			siteCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			
			//Changed by Santosh on 03/10/2017 as per new GSP token format
			//long timeStamp = new Timestamp().getDateTime();
			//gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin;
	        String timeStamp = gspTokenTimeFormatter.format(new Date());
	        gspAuthString = "v2.0::"+clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin + ":" + "RETSUM";
			gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
			
			HttpRequest getGstr1SumryReq = Unirest.get(String.format("%s%s", BASE_API_URL, GSTR1_URL))
										   .queryString("action","RETSUM")
										   .queryString("gstin", gstin)
										   .queryString("ret_period", periodCode)
										   .header("Content-Type", APPLICATION_JSON)
										   .header("state-cd", stateCode)
										   .header("clientid", clientId)
										   .header("client-secret", clientSecret)
										   .header("ip-usr", ipAddress)
										   .header("username", userName)
										   .header("auth-token", authToken)
										   .header("txn", transactionId)
										   .header("ret_period", periodCode)
										   .header("gstin", gstin)
										   .header("X-Asp-Auth-Token", gspAuthString)
					    	               .header("X-Asp-Auth-Signature", gspAuthSignature)
										   .getHttpRequest();
			
			System.out.println("get GSTR1 summary url["+getGstr1SumryReq.getUrl()+"]");
	        System.out.println("get GSTR1 summary method["+getGstr1SumryReq.getHttpMethod()+"]");
			System.out.println("get GSTR1 summary invoices request header["+getGstr1SumryReq.getHeaders()+"]");
			
			HttpResponse<JsonNode> getGstr1SumryResp = getGstr1SumryReq.asJson();
			
			System.out.println(String.format("getGstr1SumryResp Request : Status[%s] Response[%s]", getGstr1SumryResp.getStatus(), getGstr1SumryResp.getBody()));
			
			if (getGstr1SumryResp.getStatus() == 200) 
	        {
				JSONObject getGstr1SumryRespObj = getGstr1SumryResp.getBody().getObject();
				if(getGstr1SumryRespObj.has("data") && getGstr1SumryRespObj.has("rek"))
				{
					callStatus = "1";
					String gstr1Sumrydata = getGstr1SumryRespObj.getString("data");
					String gstr1Sumryrek = getGstr1SumryRespObj.getString("rek");
					
					byte[] apiEK = aesEncryption.decrypt(gstr1Sumryrek, authSek);
					
					String respJsoninBase64 = new String(aesEncryption.decrypt(gstr1Sumrydata, apiEK));
					
					byte[] respJsonInBytes = aesEncryption.decodeBase64StringTOByte(respJsoninBase64);
					
					
					JSONObject gstr1SumryJsonObj = new JSONObject(new String(respJsonInBytes));

					retString = gstr1SumryJsonObj.toString();
					
					System.out.println("retString in getGstr1Summary["+retString+"]");
				}
				else
	            {
					callStatus = "2";
					JSONObject errorJSON = getGstr1SumryResp.getBody().getObject().getJSONObject("error");
					responseJsonStr = errorJSON.toString();
		        	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
		        	//retString = getError(errMsg, "GSTAPIERR", conn);
		        	retString = errMsg;
	            }
	        }
			else if(getGstr1SumryResp.getStatus() == 500)
	        {
	        	callStatus = "2";
	        	errMsg = "Message : Error occurred at GSTN server \nResponse code : "+getGstr1SumryResp.getStatus();
	        	responseJsonStr = errMsg;
	        	//retString = getError(errMsg, "GSTAPIERR", conn);
	        	retString = errMsg;
	        }
			else
            {
				callStatus = "2";
            	JSONObject errorJSON = getGstr1SumryResp.getBody().getObject().getJSONObject("error");
            	responseJsonStr = errorJSON.toString();
            	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
            	//retString = getError(errMsg, "GSTAPIERR", conn);
	        	retString = errMsg;
            }
			
			APICallData apiCallData = new APICallData();
	        apiCallData.setPeriodCode(periodCode);
	        apiCallData.setCallDate(new Date());
	        apiCallData.setSiteCode(siteCode);
	        apiCallData.setUserId(loginCode);
	        apiCallData.setCallType("RETSUM");
	        apiCallData.setRecType("1");
	        apiCallData.setNoOfRecords(0);
	        apiCallData.setCallStatus(callStatus);
	        apiCallData.setResponseId(responseId);
	        apiCallData.setResponseJsonStr(responseJsonStr);
	        apiCallData.setChgUser(loginCode);
	        apiCallData.setChgDate(new Date());
	        apiCallData.setChgTerm(chgTerm);
	        
	        gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWiz.getGstr1Summary()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}
	private String getGstr2Summary(String authToken, String stateCode, String userName, String gstin, String periodCode, byte[] authSek, String appKeyEncryptedAndCoded, String xtraParams, Connection conn) throws ITMException
	{
		String retString = "";
		String errMsg = "", gspAuthString = "", gspAuthSignature = "";
		String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
		String siteCode = "", loginCode = "", chgTerm = "", callStatus = "", responseId = "", responseJsonStr= "";
		
		try
		{
			siteCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			
			//Changed by Santosh on 03/10/2017 as per new GSP token format
	        //long timeStamp = new Timestamp().getDateTime();
	        //gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin;
	        String timeStamp = gspTokenTimeFormatter.format(new Date());
	        gspAuthString = "v2.0::"+clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin + ":" + "RETSUM";
			gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
			
			HttpRequest getGstr2SumryReq = Unirest.get(String.format("%s%s", BASE_API_URL, GSTR2_URL))
										   .queryString("action","RETSUM")
										   .queryString("gstin", gstin)
										   .queryString("ret_period", periodCode)
										   .header("Content-Type", APPLICATION_JSON)
										   .header("state-cd", stateCode)
										   .header("clientid", clientId)
										   .header("client-secret", clientSecret)
										   .header("ip-usr", ipAddress)
										   .header("username", userName)
										   .header("auth-token", authToken)
										   .header("txn", transactionId)
										   .header("ret_period", periodCode)
										   .header("gstin", gstin)
										   .header("X-Asp-Auth-Token", gspAuthString)
					    	               .header("X-Asp-Auth-Signature", gspAuthSignature)
										   .getHttpRequest();
			
			System.out.println("get GSTR2 summary url["+getGstr2SumryReq.getUrl()+"]");
	        System.out.println("get GSTR2 summary method["+getGstr2SumryReq.getHttpMethod()+"]");
			System.out.println("get GSTR2 summary invoices request header["+getGstr2SumryReq.getHeaders()+"]");
			
			HttpResponse<JsonNode> getGstr2SumryResp = getGstr2SumryReq.asJson();
			
			System.out.println(String.format("getGstr2SumryResp Request : Status[%s] Response[%s]", getGstr2SumryResp.getStatus(), getGstr2SumryResp.getBody()));
			
			if (getGstr2SumryResp.getStatus() == 200) 
	        {
				JSONObject getGstr2SumryRespObj = getGstr2SumryResp.getBody().getObject();
				if(getGstr2SumryRespObj.has("data") && getGstr2SumryRespObj.has("rek"))
				{
					callStatus = "1";
					String gstr2Sumrydata = getGstr2SumryRespObj.getString("data");
					String gstr2Sumryrek = getGstr2SumryRespObj.getString("rek");
					
					byte[] apiEK = aesEncryption.decrypt(gstr2Sumryrek, authSek);
					
					String respJsoninBase64 = new String(aesEncryption.decrypt(gstr2Sumrydata, apiEK));
					
					byte[] respJsonInBytes = aesEncryption.decodeBase64StringTOByte(respJsoninBase64);
					
					
					JSONObject gstr2SumryJsonObj = new JSONObject(new String(respJsonInBytes));

					retString = gstr2SumryJsonObj.toString();
					
					System.out.println("retString in getGstr2Summary["+retString+"]");
				}
				else
	            {
					callStatus = "2";
					JSONObject errorJSON = getGstr2SumryResp.getBody().getObject().getJSONObject("error");
					responseJsonStr = errorJSON.toString();
		        	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
		        	//retString = getError(errMsg, "GSTAPIERR", conn);
		        	retString = errMsg;
	            }
	        }
			else if(getGstr2SumryResp.getStatus() == 500)
	        {
	        	callStatus = "2";
	        	errMsg = "Message : Error occurred at GSTN server \nResponse code : "+getGstr2SumryResp.getStatus();
	        	responseJsonStr = errMsg;
	        	//retString = getError(errMsg, "GSTAPIERR", conn);
	        	retString = errMsg;
	        }
			else
            {
				callStatus = "2";
            	JSONObject errorJSON = getGstr2SumryResp.getBody().getObject().getJSONObject("error");
            	responseJsonStr = errorJSON.toString();
            	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
            	//retString = getError(errMsg, "GSTAPIERR", conn);
	        	retString = errMsg;
            }
			
			APICallData apiCallData = new APICallData();
	        apiCallData.setPeriodCode(periodCode);
	        apiCallData.setCallDate(new Date());
	        apiCallData.setSiteCode(siteCode);
	        apiCallData.setUserId(loginCode);
	        apiCallData.setCallType("RETSUM");
	        apiCallData.setRecType("2");
	        apiCallData.setNoOfRecords(0);
	        apiCallData.setCallStatus(callStatus);
	        apiCallData.setResponseId(responseId);
	        apiCallData.setResponseJsonStr(responseJsonStr);
	        apiCallData.setChgUser(loginCode);
	        apiCallData.setChgDate(new Date());
	        apiCallData.setChgTerm(chgTerm);
	        
	        gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWiz.getGstr2Summary()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}
	private String getGstr3bSummary(String authToken, String stateCode, String userName, String gstin, String periodCode, byte[] authSek, String appKeyEncryptedAndCoded, String xtraParams, Connection conn) throws ITMException
	{
		String retString = "";
		String errMsg = "", gspAuthString = "", gspAuthSignature = "";
		String transactionId = UUID.randomUUID().toString().replaceAll("-", "");
		String siteCode = "", loginCode = "", chgTerm = "", callStatus = "", responseId = "", responseJsonStr= "";
		
		try
		{
			siteCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			
			//Changed by Santosh on 03/10/2017 as per new GSP token format
	        //long timeStamp = new Timestamp().getDateTime();
	        //gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin;
	        String timeStamp = gspTokenTimeFormatter.format(new Date());
	        gspAuthString = "v2.0::"+clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin + ":" + "RETSUM";
			gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);
			
			HttpRequest getGstr3bSumryReq = Unirest.get(String.format("%s%s", BASE_API_URL, GSTR3B_URL))
										   .queryString("action","RETSUM")
										   .queryString("gstin", gstin)
										   .queryString("ret_period", periodCode)
										   .header("Content-Type", APPLICATION_JSON)
										   .header("state-cd", stateCode)
										   .header("clientid", clientId)
										   .header("client-secret", clientSecret)
										   .header("ip-usr", ipAddress)
										   .header("username", userName)
										   .header("auth-token", authToken)
										   .header("txn", transactionId)
										   .header("ret_period", periodCode)
										   .header("gstin", gstin)
										   .header("X-Asp-Auth-Token", gspAuthString)
					    	               .header("X-Asp-Auth-Signature", gspAuthSignature)
										   .getHttpRequest();
			
			System.out.println("get GSTR3B summary url["+getGstr3bSumryReq.getUrl()+"]");
	        System.out.println("get GSTR3B summary method["+getGstr3bSumryReq.getHttpMethod()+"]");
			System.out.println("get GSTR3B summary invoices request header["+getGstr3bSumryReq.getHeaders()+"]");
			
			HttpResponse<JsonNode> getGstr3bSumryResp = getGstr3bSumryReq.asJson();
			
			System.out.println(String.format("getGstr3bSumryResp Request : Status[%s] Response[%s]", getGstr3bSumryResp.getStatus(), getGstr3bSumryResp.getBody()));
			
			if (getGstr3bSumryResp.getStatus() == 200) 
	        {
				JSONObject getGstr3bSumryRespObj = getGstr3bSumryResp.getBody().getObject();
				if(getGstr3bSumryRespObj.has("data") && getGstr3bSumryRespObj.has("rek"))
				{
					callStatus = "1";
					String gstr3bSumrydata = getGstr3bSumryRespObj.getString("data");
					String gstr3bSumryrek = getGstr3bSumryRespObj.getString("rek");
					
					byte[] apiEK = aesEncryption.decrypt(gstr3bSumryrek, authSek);
					
					String respJsoninBase64 = new String(aesEncryption.decrypt(gstr3bSumrydata, apiEK));
					
					byte[] respJsonInBytes = aesEncryption.decodeBase64StringTOByte(respJsoninBase64);
					
					
					JSONObject gstr3bSumryJsonObj = new JSONObject(new String(respJsonInBytes));

					retString = gstr3bSumryJsonObj.toString();
					
					System.out.println("retString in getGstr3bSummary["+retString+"]");
				}
				else
	            {
					callStatus = "2";
					JSONObject errorJSON = getGstr3bSumryResp.getBody().getObject().getJSONObject("error");
					responseJsonStr = errorJSON.toString();
		        	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
		        	//retString = getError(errMsg, "GSTAPIERR", conn);
		        	retString = errMsg;
	            }
	        }
			else if(getGstr3bSumryResp.getStatus() == 500)
	        {
	        	callStatus = "2";
	        	errMsg = "Message : Error occurred at GSTN server \nResponse code : "+getGstr3bSumryResp.getStatus();
	        	responseJsonStr = errMsg;
	        	//retString = getError(errMsg, "GSTAPIERR", conn);
	        	retString = errMsg;
	        }
			else
            {
				callStatus = "2";
            	JSONObject errorJSON = getGstr3bSumryResp.getBody().getObject().getJSONObject("error");
            	responseJsonStr = errorJSON.toString();
            	errMsg = "Message : "+errorJSON.getString("message")+" \nError code : "+errorJSON.getString("error_cd");
            	//retString = getError(errMsg, "GSTAPIERR", conn);
	        	retString = errMsg;
            }
			
			APICallData apiCallData = new APICallData();
	        apiCallData.setPeriodCode(periodCode);
	        apiCallData.setCallDate(new Date());
	        apiCallData.setSiteCode(siteCode);
	        apiCallData.setUserId(loginCode);
	        apiCallData.setCallType("RETSUM");
	        apiCallData.setRecType("3");
	        apiCallData.setNoOfRecords(0);
	        apiCallData.setCallStatus(callStatus);
	        apiCallData.setResponseId(responseId);
	        apiCallData.setResponseJsonStr(responseJsonStr);
	        apiCallData.setChgUser(loginCode);
	        apiCallData.setChgDate(new Date());
	        apiCallData.setChgTerm(chgTerm);
	        
	        gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWiz.getGstr3bSummary()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}
	private String getPendingData(String recType, String siteCode, String periodCode, Connection conn) throws ITMException
	{
		String retString = "";
		boolean isPendingDataFound = false;
		
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		try
		{
			retString = "<pending_data>";
			sql = "SELECT DOC_NO, DOC_DATE, AMOUNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'P' AND PRD_CODE = ? AND SITE_CODE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, recType);
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				isPendingDataFound = true;
				retString += "<data>";
				retString += "<doc_no><![CDATA["+checkNull(rs.getString("DOC_NO"))+"]]></doc_no>";
				retString += "<doc_date><![CDATA["+checkNull(rs.getString("DOC_DATE"))+"]]></doc_date>";
				retString += "<amount><![CDATA["+rs.getDouble("AMOUNT")+"]]></amount>";
				retString += "</data>";
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
			if(rs!=null)
			{
				rs.close();
				rs=null;
			}
			retString += "</pending_data>";
			
			if(!isPendingDataFound)
			{
				retString = "";
			}
			
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizEJB.getPendingData()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}
	private String getSignConfig(String loginCode, String returnType, Connection conn) throws ITMException
	{
		String retString = "";
		boolean isSignConfigFound = false;
		
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		try
		{
			retString = "<sign_data>";
			
			sql = "SELECT SIGN_METHOD,DOC_TYPE FROM USER_SIGN_ACC WHERE USER_ID = ? AND DOC_TYPE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, loginCode);
			pstmt.setString(2, returnType.trim());
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				isSignConfigFound = true;
				retString += "<data>";
				retString += "<sign_method><![CDATA["+checkNull(rs.getString("SIGN_METHOD"))+"]]></sign_method>";
				retString += "<doc_type><![CDATA["+checkNull(rs.getString("DOC_TYPE"))+"]]></doc_type>";
				retString += "</data>";
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
			if(rs!=null)
			{
				rs.close();
				rs=null;
			}
			retString += "</sign_data>";
			
			if(!isSignConfigFound)
			{
				retString = "";
			}
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizEJB.getSignConfig()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retString;
	}
	private String getGSTR3BXMLData(String siteCode, String periodCode, Connection conn) throws ITMException
	{
		String retString = "";
		
		StringBuffer xmlStringBuff = new StringBuffer(); 
		
		int domId = 0;
		
		double interAmount = 0.0, intraAmount = 0.0;
		
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		try
		{
			xmlStringBuff.append("<root>");
			xmlStringBuff.append("<section domID = '"+(++domId)+"'>");

			sql = " SELECT GDH.TRAN_TYPE,SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD" 
				+ " WHERE GDH.TRAN_ID=GDD.TRAN_ID" 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.TRAN_TYPE IN ('01','02','03','04','05') GROUP BY TRAN_TYPE";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				xmlStringBuff.append("<summary_data>");
				xmlStringBuff.append("<tran_type><![CDATA["+checkNull(rs.getString("TRAN_TYPE"))+"]]></tran_type>");
				xmlStringBuff.append("<taxable_amt><![CDATA["+rs.getDouble("TAXABLE_AMT")+"]]></taxable_amt>");
				xmlStringBuff.append("<igst_amt><![CDATA["+rs.getDouble("IGST_AMT")+"]]></igst_amt>");
				xmlStringBuff.append("<cgst_amt><![CDATA["+rs.getDouble("CGST_AMT")+"]]></cgst_amt>");
				xmlStringBuff.append("<sgst_amt><![CDATA["+rs.getDouble("SGST_AMT")+"]]></sgst_amt>");
				xmlStringBuff.append("<cess_amt><![CDATA["+rs.getDouble("CESS_AMT")+"]]></cess_amt>");
				xmlStringBuff.append("</summary_data>");
			}
			closeResources(rs,pstmt);
			
			xmlStringBuff.append("</section>");
			xmlStringBuff.append("<section domID = '"+(++domId)+"'>");
			
			sql = " SELECT GDH.TRAN_TYPE, GDH.GST_CODE, S.DESCR, SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD, STATE S" 
				+ " WHERE GDH.TRAN_ID=GDD.TRAN_ID AND GDH.GST_CODE = S.GST_CODE " 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.TRAN_TYPE IN ('06') GROUP BY TRAN_TYPE, GDH.GST_CODE, S.DESCR";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			
			rs = pstmt.executeQuery();
			xmlStringBuff.append("<unreg_data>");
			
			while(rs.next())
			{
				xmlStringBuff.append("<data>");
				xmlStringBuff.append("<tran_type><![CDATA["+checkNull(rs.getString("TRAN_TYPE"))+"]]></tran_type>");
				xmlStringBuff.append("<gst_code><![CDATA["+checkNull(rs.getString("GST_CODE"))+"]]></gst_code>");
				xmlStringBuff.append("<state_descr><![CDATA["+checkNull(rs.getString("DESCR"))+"]]></state_descr>");
				xmlStringBuff.append("<taxable_amt><![CDATA["+rs.getDouble("TAXABLE_AMT")+"]]></taxable_amt>");
				xmlStringBuff.append("<igst_amt><![CDATA["+rs.getDouble("IGST_AMT")+"]]></igst_amt>");
				xmlStringBuff.append("<cgst_amt><![CDATA["+rs.getDouble("CGST_AMT")+"]]></cgst_amt>");
				xmlStringBuff.append("<sgst_amt><![CDATA["+rs.getDouble("SGST_AMT")+"]]></sgst_amt>");
				xmlStringBuff.append("<cess_amt><![CDATA["+rs.getDouble("CESS_AMT")+"]]></cess_amt>");
				xmlStringBuff.append("</data>");
			}
			closeResources(rs,pstmt);
			xmlStringBuff.append("</unreg_data>");
			
			sql = " SELECT GDH.TRAN_TYPE, GDH.GST_CODE, S.DESCR, SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD, STATE S" 
				+ " WHERE GDH.TRAN_ID=GDD.TRAN_ID AND GDH.GST_CODE = S.GST_CODE " 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.TRAN_TYPE IN ('07') GROUP BY TRAN_TYPE, GDH.GST_CODE, S.DESCR";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			
			rs = pstmt.executeQuery();
			xmlStringBuff.append("<comp_data>");
			
			while(rs.next())
			{
				xmlStringBuff.append("<data>");
				xmlStringBuff.append("<tran_type><![CDATA["+checkNull(rs.getString("TRAN_TYPE"))+"]]></tran_type>");
				xmlStringBuff.append("<gst_code><![CDATA["+checkNull(rs.getString("GST_CODE"))+"]]></gst_code>");
				xmlStringBuff.append("<state_descr><![CDATA["+checkNull(rs.getString("DESCR"))+"]]></state_descr>");
				xmlStringBuff.append("<taxable_amt><![CDATA["+rs.getDouble("TAXABLE_AMT")+"]]></taxable_amt>");
				xmlStringBuff.append("<igst_amt><![CDATA["+rs.getDouble("IGST_AMT")+"]]></igst_amt>");
				xmlStringBuff.append("<cgst_amt><![CDATA["+rs.getDouble("CGST_AMT")+"]]></cgst_amt>");
				xmlStringBuff.append("<sgst_amt><![CDATA["+rs.getDouble("SGST_AMT")+"]]></sgst_amt>");
				xmlStringBuff.append("<cess_amt><![CDATA["+rs.getDouble("CESS_AMT")+"]]></cess_amt>");
				xmlStringBuff.append("</data>");
			}
			closeResources(rs,pstmt);
			xmlStringBuff.append("</comp_data>");
			
			sql = " SELECT GDH.TRAN_TYPE, GDH.GST_CODE, S.DESCR, SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD, STATE S" 
				+ " WHERE GDH.TRAN_ID=GDD.TRAN_ID AND GDH.GST_CODE = S.GST_CODE " 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.TRAN_TYPE IN ('08') GROUP BY TRAN_TYPE, GDH.GST_CODE, S.DESCR ORDER BY GDH.GST_CODE";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			
			rs = pstmt.executeQuery();
			xmlStringBuff.append("<uin_data>");
			
			while(rs.next())
			{
				xmlStringBuff.append("<data>");
				xmlStringBuff.append("<tran_type><![CDATA["+checkNull(rs.getString("TRAN_TYPE"))+"]]></tran_type>");
				xmlStringBuff.append("<gst_code><![CDATA["+checkNull(rs.getString("GST_CODE"))+"]]></gst_code>");
				xmlStringBuff.append("<state_descr><![CDATA["+checkNull(rs.getString("DESCR"))+"]]></state_descr>");
				xmlStringBuff.append("<taxable_amt><![CDATA["+rs.getDouble("TAXABLE_AMT")+"]]></taxable_amt>");
				xmlStringBuff.append("<igst_amt><![CDATA["+rs.getDouble("IGST_AMT")+"]]></igst_amt>");
				xmlStringBuff.append("<cgst_amt><![CDATA["+rs.getDouble("CGST_AMT")+"]]></cgst_amt>");
				xmlStringBuff.append("<sgst_amt><![CDATA["+rs.getDouble("SGST_AMT")+"]]></sgst_amt>");
				xmlStringBuff.append("<cess_amt><![CDATA["+rs.getDouble("CESS_AMT")+"]]></cess_amt>");
				xmlStringBuff.append("</data>");
			}
			closeResources(rs,pstmt);
			xmlStringBuff.append("</uin_data>");
			
			xmlStringBuff.append("</section>");
			xmlStringBuff.append("<section domID = '"+(++domId)+"'>");
			
			sql = " SELECT GDH.TRAN_TYPE,SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD" 
				+ " WHERE GDH.TRAN_ID=GDD.TRAN_ID" 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.TRAN_TYPE IN ('09','10','11','12','13','14') GROUP BY TRAN_TYPE";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				xmlStringBuff.append("<itc_available>");
				xmlStringBuff.append("<tran_type><![CDATA["+checkNull(rs.getString("TRAN_TYPE"))+"]]></tran_type>");
				xmlStringBuff.append("<taxable_amt><![CDATA["+rs.getDouble("TAXABLE_AMT")+"]]></taxable_amt>");
				xmlStringBuff.append("<igst_amt><![CDATA["+rs.getDouble("IGST_AMT")+"]]></igst_amt>");
				xmlStringBuff.append("<cgst_amt><![CDATA["+rs.getDouble("CGST_AMT")+"]]></cgst_amt>");
				xmlStringBuff.append("<sgst_amt><![CDATA["+rs.getDouble("SGST_AMT")+"]]></sgst_amt>");
				xmlStringBuff.append("<cess_amt><![CDATA["+rs.getDouble("CESS_AMT")+"]]></cess_amt>");
				xmlStringBuff.append("</itc_available>");
			}
			closeResources(rs,pstmt);
				
			sql = " SELECT GDH.TRAN_TYPE,SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD" 
				+ " WHERE GDH.TRAN_ID=GDD.TRAN_ID" 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.TRAN_TYPE IN ('15','16','17','18','19','20') GROUP BY TRAN_TYPE";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				xmlStringBuff.append("<itc_reversed>");
				xmlStringBuff.append("<tran_type><![CDATA["+checkNull(rs.getString("TRAN_TYPE"))+"]]></tran_type>");
				xmlStringBuff.append("<taxable_amt><![CDATA["+rs.getDouble("TAXABLE_AMT")+"]]></taxable_amt>");
				xmlStringBuff.append("<igst_amt><![CDATA["+rs.getDouble("IGST_AMT")+"]]></igst_amt>");
				xmlStringBuff.append("<cgst_amt><![CDATA["+rs.getDouble("CGST_AMT")+"]]></cgst_amt>");
				xmlStringBuff.append("<sgst_amt><![CDATA["+rs.getDouble("SGST_AMT")+"]]></sgst_amt>");
				xmlStringBuff.append("<cess_amt><![CDATA["+rs.getDouble("CESS_AMT")+"]]></cess_amt>");
				xmlStringBuff.append("</itc_reversed>");
			}
			closeResources(rs,pstmt);
			
			sql = " SELECT GDH.TRAN_TYPE,SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD" 
				+ " WHERE GDH.TRAN_ID=GDD.TRAN_ID" 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.TRAN_TYPE IN ('21') GROUP BY TRAN_TYPE";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				xmlStringBuff.append("<itc_net>");
				xmlStringBuff.append("<tran_type><![CDATA["+checkNull(rs.getString("TRAN_TYPE"))+"]]></tran_type>");
				xmlStringBuff.append("<taxable_amt><![CDATA["+rs.getDouble("TAXABLE_AMT")+"]]></taxable_amt>");
				xmlStringBuff.append("<igst_amt><![CDATA["+rs.getDouble("IGST_AMT")+"]]></igst_amt>");
				xmlStringBuff.append("<cgst_amt><![CDATA["+rs.getDouble("CGST_AMT")+"]]></cgst_amt>");
				xmlStringBuff.append("<sgst_amt><![CDATA["+rs.getDouble("SGST_AMT")+"]]></sgst_amt>");
				xmlStringBuff.append("<cess_amt><![CDATA["+rs.getDouble("CESS_AMT")+"]]></cess_amt>");
				xmlStringBuff.append("</itc_net>");
			}
			closeResources(rs,pstmt);
			
			sql = " SELECT GDH.TRAN_TYPE,SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD" 
				+ " WHERE GDH.TRAN_ID=GDD.TRAN_ID" 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.TRAN_TYPE IN ('22','23','24','25','26','27') GROUP BY TRAN_TYPE";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				xmlStringBuff.append("<itc_ineligible>");
				xmlStringBuff.append("<tran_type><![CDATA["+checkNull(rs.getString("TRAN_TYPE"))+"]]></tran_type>");
				xmlStringBuff.append("<taxable_amt><![CDATA["+rs.getDouble("TAXABLE_AMT")+"]]></taxable_amt>");
				xmlStringBuff.append("<igst_amt><![CDATA["+rs.getDouble("IGST_AMT")+"]]></igst_amt>");
				xmlStringBuff.append("<cgst_amt><![CDATA["+rs.getDouble("CGST_AMT")+"]]></cgst_amt>");
				xmlStringBuff.append("<sgst_amt><![CDATA["+rs.getDouble("SGST_AMT")+"]]></sgst_amt>");
				xmlStringBuff.append("<cess_amt><![CDATA["+rs.getDouble("CESS_AMT")+"]]></cess_amt>");
				xmlStringBuff.append("</itc_ineligible>");
			}
			closeResources(rs,pstmt);
			
			xmlStringBuff.append("</section>");
			xmlStringBuff.append("<section domID = '"+(++domId)+"'>");
			
			sql = " SELECT GDH.TRAN_TYPE,SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD" 
				+ " WHERE GDH.TRAN_ID=GDD.TRAN_ID" 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.TRAN_TYPE IN ('28') GROUP BY TRAN_TYPE";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				interAmount = rs.getDouble("TAXABLE_AMT");
			}
			closeResources(rs,pstmt);
			
			sql = " SELECT GDH.TRAN_TYPE,SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD" 
				+ " WHERE GDH.TRAN_ID=GDD.TRAN_ID" 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.TRAN_TYPE IN ('30') GROUP BY TRAN_TYPE";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				intraAmount = rs.getDouble("TAXABLE_AMT");
			}
			closeResources(rs,pstmt);
			
			xmlStringBuff.append("<gst_data>");
			xmlStringBuff.append("<tran_type><![CDATA[GST]]></tran_type>");
			xmlStringBuff.append("<inter><![CDATA["+interAmount+"]]></inter>");
			xmlStringBuff.append("<intra><![CDATA["+intraAmount+"]]></intra>");
			xmlStringBuff.append("</gst_data>");
			
			interAmount = 0.0; intraAmount = 0.0;
			
			sql = " SELECT GDH.TRAN_TYPE,SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD" 
				+ " WHERE GDH.TRAN_ID=GDD.TRAN_ID" 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.TRAN_TYPE IN ('29') GROUP BY TRAN_TYPE";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				interAmount = rs.getDouble("TAXABLE_AMT");
			}
			closeResources(rs,pstmt);
			
			sql = " SELECT GDH.TRAN_TYPE,SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD" 
				+ " WHERE GDH.TRAN_ID=GDD.TRAN_ID" 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.TRAN_TYPE IN ('31') GROUP BY TRAN_TYPE";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				intraAmount = rs.getDouble("TAXABLE_AMT");
			}
			closeResources(rs,pstmt);
			
			xmlStringBuff.append("<non_gst_data>");
			xmlStringBuff.append("<tran_type><![CDATA[NONGST]]></tran_type>");
			xmlStringBuff.append("<inter><![CDATA["+interAmount+"]]></inter>");
			xmlStringBuff.append("<intra><![CDATA["+intraAmount+"]]></intra>");
			xmlStringBuff.append("</non_gst_data>");
			
			xmlStringBuff.append("</section>");
			xmlStringBuff.append("<section domID = '"+(++domId)+"'>");
			
			sql = " SELECT GDH.TRAN_TYPE,SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM(GDD.IGST_AMT) AS IGST_AMT, SUM(GDD.CGST_AMT) AS CGST_AMT, SUM(GDD.SGST_AMT) AS SGST_AMT, SUM(GDD.CESS_AMT) AS CESS_AMT"
				+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD" 
				+ " WHERE GDH.TRAN_ID=GDD.TRAN_ID" 
				+ " AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.TRAN_TYPE IN ('32') GROUP BY TRAN_TYPE";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, "6");
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				xmlStringBuff.append("<interest_latefee>");
				xmlStringBuff.append("<tran_type><![CDATA["+checkNull(rs.getString("TRAN_TYPE"))+"]]></tran_type>");
				xmlStringBuff.append("<taxable_amt><![CDATA["+rs.getDouble("TAXABLE_AMT")+"]]></taxable_amt>");
				xmlStringBuff.append("<igst_amt><![CDATA["+rs.getDouble("IGST_AMT")+"]]></igst_amt>");
				xmlStringBuff.append("<cgst_amt><![CDATA["+rs.getDouble("CGST_AMT")+"]]></cgst_amt>");
				xmlStringBuff.append("<sgst_amt><![CDATA["+rs.getDouble("SGST_AMT")+"]]></sgst_amt>");
				xmlStringBuff.append("<cess_amt><![CDATA["+rs.getDouble("CESS_AMT")+"]]></cess_amt>");
				xmlStringBuff.append("</interest_latefee>");
			}
			closeResources(rs,pstmt);
			
			xmlStringBuff.append("</section>");
				
			xmlStringBuff.append("</root>");
			
			retString = xmlStringBuff.toString();
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizEJB.getGSTR3BXMLData()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		System.out.println("final retString ["+retString+"]");
		return retString;
	}
	private String getDataFromFileServer(String gstin, String recType, String periodCode, String authToken, String userName, String stateCode, byte[] authSek, JSONObject dataJSONObject, String sectionName, String xtraParams) throws ITMException
	{
		String retString = null;
		String transactionId = "", retFolderPath = "", gspAuthString = "", gspAuthSignature = "";
		String siteCode = "", loginCode = "", chgTerm = "", responseId = "", responseJsonStr = "", callStatus = "", callStatusFile = "", responseIdFile = "";
		String sep = File.separator;
		ArrayList<APICallData> apiCallLogDataList = new ArrayList<APICallData>();
		
		String sql = "", apiTranId = "";
		PreparedStatement pstmt = null;
		Connection conn = null;
		int updateCnt = 0;
		boolean isError = false;
		
		try
		{
			siteCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			loginCode = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			chgTerm = e12GenericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			
			retFolderPath = saveFilePath + sep + gstin + sep + periodCode + sep + "GSTR"+recType + sep + sectionName;
			File sectionFolder = new File(retFolderPath);
			
			if(!sectionFolder.exists())
			{
				sectionFolder.mkdirs();
				System.out.println("section folder created for ["+sectionName+"]");
			}
			
			transactionId = UUID.randomUUID().toString().replaceAll("-", "");
			//Changed by Santosh on 03/10/2017 as per new GSP token format
	        //long timeStamp = new Timestamp().getDateTime();
	        //gspAuthString = clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin;
	        String timeStamp = gspTokenTimeFormatter.format(new Date());
	        gspAuthString = "v2.0::"+clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin + ":" + "FILEDET";
			gspAuthSignature = gspSignature.sign(gspAuthString, aspPrivateKey);

			HttpRequest fileDetailsReq = Unirest.get(String.format("%s%s", BASE_API_URL, GSTR_RETSTAT_URL))
										.queryString("gstin", gstin)
										.queryString("ret_period",periodCode)
										.queryString("token",dataJSONObject.getString("token"))
										.queryString("action","FILEDET")
										.header("Content-Type", APPLICATION_JSON)
										.header("state-cd", stateCode)
										.header("clientid", clientId)
										.header("client-secret", clientSecret)
										.header("ip-usr", ipAddress)
										.header("username", userName)
										.header("auth-token", authToken)
										.header("txn", transactionId)
										.header("ret_period", periodCode)
										.header("gstin", gstin)
										.header("X-Asp-Auth-Token", gspAuthString)
										.header("X-Asp-Auth-Signature", gspAuthSignature)
										.getHttpRequest();
			
			System.out.println("download file url["+fileDetailsReq.getUrl()+"]");
	        System.out.println("download file method["+fileDetailsReq.getHttpMethod()+"]");
			System.out.println("download file request header["+fileDetailsReq.getHeaders()+"]");

			HttpResponse<JsonNode> fileDetailsResp = fileDetailsReq.asJson();
			
			System.out.println(String.format("fileDetailsResp Request : Status[%s] Response[%s]", fileDetailsResp.getStatus(), fileDetailsResp.getBody()));
			
			if (fileDetailsResp.getStatus() == 200) 
			{
				JSONObject fileGstr1RespObj = fileDetailsResp.getBody().getObject();
				if(fileGstr1RespObj.has("data") && fileGstr1RespObj.has("rek"))
				{	
					callStatus = "1";
					String fileGstr1Data = fileGstr1RespObj.getString("data");
					String fileGstr1Rek = fileGstr1RespObj.getString("rek");

					byte[] fileGstr1ApiEK = aesEncryption.decrypt(fileGstr1Rek, authSek);

					String fileGstr1JsoninBase64 = new String(aesEncryption.decrypt(fileGstr1Data, fileGstr1ApiEK));

					byte[] fileGstr1JsonInBytes = aesEncryption.decodeBase64StringTOByte(fileGstr1JsoninBase64);

					JSONObject filedetailsJsonObj = new JSONObject(new String(fileGstr1JsonInBytes));

					if(filedetailsJsonObj.has("urls")&&filedetailsJsonObj.has("ek"))
					{
						String sessionKey = filedetailsJsonObj.getString("ek");
						JSONArray fileDetailsArry = filedetailsJsonObj.getJSONArray("urls");

						System.out.println("sessionKey["+sessionKey+"]");
						String sessionKeyFilePath = sectionFolder.getAbsolutePath() + sep + "key.txt";
						FileOutputStream keyFileOutStream = new FileOutputStream(sessionKeyFilePath);
						keyFileOutStream.write(sessionKey.getBytes());
						keyFileOutStream.close();
						
						for(int i=0; i<fileDetailsArry.length(); i++)
						{
							String fileName = "", filePath = "";
							
							JSONObject tempJsonObj = fileDetailsArry.getJSONObject(i);

							if(tempJsonObj.has("ul"))
							{
								String fileUrl = tempJsonObj.getString("ul");
								//Changed by Santosh on 11-10-2017 to invoke GSP url
								//fileUrl = FILEDET_URL + fileUrl;
								fileUrl = BASE_API_URL + fileUrl;
								System.out.println("fileUrl["+fileUrl+"]");
								URL url = new URL(fileUrl);
								HttpURLConnection connection = (HttpURLConnection) url.openConnection();
								
								//Added by Santosh on 11-10-2017 to invoke GSP url Start
								timeStamp = gspTokenTimeFormatter.format(new Date());
								String gspAuthStringFile = "v2.0::"+clientId + ":" + transactionId + ":" + timeStamp + ":" + gstin + ":" + "FILEDET";
								String gspAuthSignatureFile = gspSignature.sign(gspAuthStringFile, aspPrivateKey);
								
								connection.setRequestMethod("GET");
								connection.setRequestProperty("X-Asp-Auth-Token", gspAuthStringFile);
								connection.setRequestProperty("X-Asp-Auth-Signature", gspAuthSignatureFile);
								//Added by Santosh on 11-10-2017 to invoke GSP url End
								
								int responseCode = connection.getResponseCode();
								responseIdFile = String.valueOf(responseCode);
								if (responseCode == HttpURLConnection.HTTP_OK) 
								{
									callStatusFile = "1";
									String disposition = connection.getHeaderField("Content-Disposition");

									if (disposition != null) 
									{
										int index = disposition.indexOf("filename=");
										if (index > 0)
										{
											fileName = disposition.substring(index + 10, disposition.length() - 1);
										}
									} 
									else 
									{
										fileName = fileUrl.substring(fileUrl.lastIndexOf("/") + 1,fileUrl.lastIndexOf("?"));
									}

									InputStream inputStream = connection.getInputStream();
									
									filePath = sectionFolder.getAbsolutePath() + sep + fileName;
									
									FileOutputStream outputStream = new FileOutputStream(filePath);

									int bytesRead = -1;
									byte[] buffer = new byte[1024];
									while ((bytesRead = inputStream.read(buffer)) != -1) 
									{
										outputStream.write(buffer, 0, bytesRead);
									}

									outputStream.close();
									inputStream.close();
								}
								else
								{
									callStatusFile = "2";
								}

								TarArchiveInputStream tarInput = new TarArchiveInputStream(new GzipCompressorInputStream(new FileInputStream(filePath)));
								TarArchiveEntry currentEntry = tarInput.getNextTarEntry();
								BufferedReader br = null;
								while (currentEntry != null) 
								{
									br = new BufferedReader(new InputStreamReader(tarInput));
									//System.out.println("For File = " + currentEntry.getName());
									String line;
									while ((line = br.readLine()) != null) 
									{
										//System.out.println("line="+line);

										byte[] decryptEK =  aesEncryption.decodeBase64StringTOByte(sessionKey);
										String decryptedData = new String(aesEncryption.decrypt(line, decryptEK));
										String decodedJson = new String(Base64.decodeBase64(decryptedData));

										retString += XML.toString(new JSONObject(decodedJson));
									}
									currentEntry = tarInput.getNextTarEntry();
								}
								tarInput.close();
							}
							
							APICallData apiCallDataFile = new APICallData();
							apiCallDataFile.setPeriodCode(periodCode);
							apiCallDataFile.setCallDate(new Date());
							apiCallDataFile.setSiteCode(siteCode);
							apiCallDataFile.setUserId(loginCode);
							apiCallDataFile.setCallType("LARGE_FILE");
							apiCallDataFile.setRecType(recType);
							apiCallDataFile.setNoOfRecords(0);
							apiCallDataFile.setCallStatus(callStatusFile);
							apiCallDataFile.setResponseId(responseIdFile);
							apiCallDataFile.setResponseJsonStr("");
							apiCallDataFile.setChgUser(loginCode);
							apiCallDataFile.setChgDate(new Date());
							apiCallDataFile.setChgTerm(chgTerm);
							
							apiCallLogDataList.add(apiCallDataFile);
						}
					}
					
					if(dataJSONObject.has("api_tranid"))
					{
						conn = getConnection();
						
						apiTranId = dataJSONObject.getString("api_tranid");
						
						sql = "UPDATE API_CALL_LOG SET CALL_STATUS = ? WHERE TRAN_ID = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, "1");
						pstmt.setString(2, apiTranId);
						
						updateCnt = pstmt.executeUpdate();
						
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
						
						System.out.println("api call log update["+updateCnt+"] apiTranId["+apiTranId+"]");
					}
				}
				else
				{
					String errMsg = "";
					callStatus = "2";
					JSONObject errorJSON = fileDetailsResp.getBody().getObject();
					if(errorJSON.has("error"))
					{
						JSONObject tempJsonObj = errorJSON.getJSONObject("error");
						
						if(tempJsonObj.has("message"))
						{
							errMsg = tempJsonObj.getString("message");
							retString = "<data_error><![CDATA["+errMsg+"]]></data_error>";
						}
					}
				}
			}
			else
			{
				String errMsg = "";
				callStatus = "2";
				JSONObject errorJSON = fileDetailsResp.getBody().getObject();
				if(errorJSON.has("error"))
				{
					JSONObject tempJsonObj = errorJSON.getJSONObject("error");
					
					if(tempJsonObj.has("message"))
					{
						errMsg = tempJsonObj.getString("message");
						retString = "<data_error><![CDATA["+errMsg+"]]></data_error>";
					}
				}
				
				if(dataJSONObject.has("api_tranid"))
				{
					conn = getConnection();
					
					apiTranId = dataJSONObject.getString("api_tranid");
					
					sql = "UPDATE API_CALL_LOG SET CALL_STATUS = ? WHERE TRAN_ID = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, "1");
					pstmt.setString(2, apiTranId);
					
					updateCnt = pstmt.executeUpdate();
					
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
					
					System.out.println("api call log update["+updateCnt+"] apiTranId["+apiTranId+"]");
				}
			}
			
		}
		catch(Exception e)
		{
			isError = true;
			System.out.println("GSTCommonUtil.getDataFromFileServer()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(isError)
				{
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(conn!=null)
					{
						conn.rollback();
					}
				}
				else
				{
					if(conn!=null)
					{
						conn.commit();
					}
				}
				
				if(conn!=null && !conn.isClosed())
				{
					conn.close();
					conn=null;
				}
				
				APICallData apiCallData = new APICallData();
		        apiCallData.setPeriodCode(periodCode);
		        apiCallData.setCallDate(new Date());
		        apiCallData.setSiteCode(siteCode);
		        apiCallData.setUserId(loginCode);
		        apiCallData.setCallType("FILEDET");
		        apiCallData.setRecType(recType);
		        apiCallData.setNoOfRecords(0);
		        apiCallData.setCallStatus(callStatus);
		        apiCallData.setResponseId(responseId);
		        apiCallData.setResponseJsonStr(responseJsonStr);
		        apiCallData.setChgUser(loginCode);
		        apiCallData.setChgDate(new Date());
		        apiCallData.setChgTerm(chgTerm);
		        
		        gstCommonUtil.updateAPICallLogHistory(apiCallData, null);
		        
		        if(apiCallLogDataList.size() > 0)
		        {
		        	for(APICallData eachAPICallData : apiCallLogDataList)
		        	{
		        		gstCommonUtil.updateAPICallLogHistory(eachAPICallData, null);
		        	}
		        }
			}
			catch(Exception se)
			{
				System.out.println("GSTDataSubmitWizEJB.getDataFromFileServer().finally["+se.getMessage()+"]");
				se.printStackTrace();
				throw new ITMException(se);
			}
		}
		System.out.println("final retString["+retString+"]");
		return retString;
	}
	
	public Object generateOfflineFile(String periodCode, String siteCode, String recType) throws ITMException
	{
		XSSFWorkbook retDataWorkbook = null;
		String gstr1WorkBookPath = "", gstr2WorkBookPath = "";
		String sep = File.separator;
		
		String tranType = "", tranId = "", udfStr1 = "", udfStr2 = "", udfStr3 = "", ctin = "", posStateCode = "", docNo = "", docDateStr = "",
			   reverseCharge = "", etin = "", invoiceType = "", errorCode = "", dataErrMsg = "", stateDscr = "", refInvId = "", refInvDtStr = "",
			   preGST = "", refTranType = "", customerType = "", portCode = "", shipBillNo = "", shipBillDateStr = "", gstDateFormat = "", supplyType = "",
			   itcType = "", itcTypeDescr = "", supplierName = "", placeOfBusiness = "", documentType = "", customerName = "";
		boolean noDataFound = false;
		double amount =0.0, gstRate = 0.0, taxableAmt = 0.0, cessAmt = 0.0, nilAmount = 0.0, exemtAmount = 0.0, nonGSTAmount = 0.0, compDlrAmount = 0.0;
		int b2bRowNum = 4, b2clRowNum = 4, b2csRowNum = 4, cdnrRowNum = 4, cdnurRowNum = 4, expRowNum = 4, atRowNum = 4, atAdjRowNum = 4, hsnRowNum = 4,
				b2burRowNum = 4, impsRowNum = 4, impgRowNum = 4;
		double igstAmt = 0.0, cgstAmt = 0.0, sgstAmt = 0.0, igstITCAmt = 0.0, cgstITCAmt = 0.0, sgstITCAmt = 0.0, cessITCAmt = 0.0; 
		
		HashMap<String,String> itcTypeHMap = new HashMap<String,String>();
		itcTypeHMap.put("CP", "Capital goods");
		itcTypeHMap.put("IS", "Input services");
		itcTypeHMap.put("IP", "Inputs");
		itcTypeHMap.put("NO", "Ineligible");
		
		String sql = "", hdrSql = "", detSql = "";
		Date docDate = null, refInvDate = null, shipBillDate = null;
		Connection conn = null;
		PreparedStatement pstmt = null, hdrPstmt = null, detPstmt = null;
		ResultSet rs = null, hdrRs = null, detRs = null;
		FinCommon finCommon = new FinCommon();
		try
		{
			conn = getConnection();
			
			sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE REC_TYPE = ? AND SUBMIT_STATUS = 'P' AND PRD_CODE = ? AND SITE_CODE = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, recType);
			pstmt.setString(2, periodCode);
			pstmt.setString(3, siteCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				if(rs.getInt("CNT") == 0)
				{
					noDataFound = true;
					errorCode =  "VTNOGSDATA";
				}
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
			if(rs!=null)
			{
				rs.close();
				rs=null;
			}
			
			if(noDataFound)
			{
				sql = "SELECT MSG_DESCR FROM MESSAGES WHERE MSG_NO = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, errorCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					dataErrMsg = rs.getString("MSG_DESCR");
				}
				closeResources(rs, pstmt);
				
				return "<root><message><![CDATA[Message : "+dataErrMsg+"]]></message></root>";
			}
			else
			{
				if("1".equalsIgnoreCase(recType))
				{
					gstr1WorkBookPath = CommonConstants.JBOSSHOME + sep + "DOWNLOAD" + sep + "template" + sep + "GSTR1_Offline_Template.xlsx";
					File gstr1ExcleFile = new File(gstr1WorkBookPath);

					if(gstr1ExcleFile.exists())
					{
						retDataWorkbook = new XSSFWorkbook(new FileInputStream(gstr1ExcleFile));
					}
				}
				else if("2".equalsIgnoreCase(recType))
				{
					gstr2WorkBookPath = CommonConstants.JBOSSHOME + sep + "DOWNLOAD" + sep + "template" + sep + "GSTR2_Offline_Template.xlsx";
					File gstr2ExcleFile = new File(gstr2WorkBookPath);

					if(gstr2ExcleFile.exists())
					{
						retDataWorkbook = new XSSFWorkbook(new FileInputStream(gstr2ExcleFile));
					}
				}
				
				gstDateFormat = finCommon.getFinparams("999999", "GST_EXCL_DATE_FORMAT", conn);
				
				CellStyle dateCellStyle = retDataWorkbook.createCellStyle();
				CreationHelper createHelper = retDataWorkbook.getCreationHelper();
				dateCellStyle.setDataFormat( createHelper.createDataFormat().getFormat(gstDateFormat));
				
				SimpleDateFormat gstDateFormatSdf = new SimpleDateFormat(gstDateFormat);

				if("1".equalsIgnoreCase(recType))
				{
					hdrSql = "SELECT * FROM GST_DATA_HDR WHERE REC_TYPE = ? AND PRD_CODE = ? AND SITE_CODE = ? AND SUBMIT_STATUS = ? ORDER BY DOC_DATE, DOC_NO";
					hdrPstmt = conn.prepareStatement(hdrSql);
					hdrPstmt.setString(1, recType);
					hdrPstmt.setString(2, periodCode);
					hdrPstmt.setString(3, siteCode);
					hdrPstmt.setString(4, "P");

					hdrRs = hdrPstmt.executeQuery();

					while(hdrRs.next())
					{
						stateDscr = "";
						
						tranId = hdrRs.getString("TRAN_ID");
						tranType = hdrRs.getString("TRAN_TYPE");
						ctin = checkNull(hdrRs.getString("TAX_REG_NO"));
						posStateCode = checkNull(hdrRs.getString("GST_CODE"));
						docNo = checkNull(hdrRs.getString("DOC_NO"));
						docDate = hdrRs.getDate("DOC_DATE");
						amount = Double.parseDouble(String.format("%.2f",hdrRs.getDouble("AMOUNT")));
						reverseCharge = checkNull(hdrRs.getString("REVERSE_CHRG"));
						etin = checkNull(hdrRs.getString("ECOM_REG_NO"));
						refInvId = checkNull(hdrRs.getString("REF_ID__INV"));
						refInvDate = hdrRs.getDate("REF_DATE__INV");
						portCode = checkNull(hdrRs.getString("ORDER_NO"));
						shipBillNo = checkNull(hdrRs.getString("LR_NO"));
						shipBillDate = hdrRs.getDate("LR_DATE");
						customerName = checkNull(hdrRs.getString("CUST_NAME"));
						
						sql = "SELECT DESCR FROM STATE WHERE GST_CODE = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, posStateCode);

						rs = pstmt.executeQuery();

						if(rs.next())
						{
							stateDscr = checkNull(rs.getString("DESCR"));
						}
						closeResources(rs, pstmt);

						if(docDate!=null)
						{
							docDateStr = gstDateFormatSdf.format(docDate);
						}
						if(refInvDate!=null)
						{
							refInvDtStr = gstDateFormatSdf.format(refInvDate);
						}
						if(shipBillDate!=null)
						{
							shipBillDateStr = gstDateFormatSdf.format(shipBillDate);
						}

						System.out.println("docDateStr["+docDateStr+"]");

						sql = "SELECT UDF_STR1, UDF_STR2, UDF_STR3 FROM GENCODES WHERE MOD_NAME='W_GSTR' AND FLD_NAME='TRAN_TYPE' AND FLD_VALUE = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, tranType);

						rs = pstmt.executeQuery();

						if(rs.next())
						{
							udfStr1 = checkNull(rs.getString("UDF_STR1"));
							udfStr2 = checkNull(rs.getString("UDF_STR2"));
							udfStr3 = checkNull(rs.getString("UDF_STR3"));
						}
						closeResources(rs, pstmt);
						
						System.out.println("udfStr1["+udfStr1+"] udfStr2["+udfStr2+"] udfStr3["+udfStr3+"]");
						
						if("B2B".equalsIgnoreCase(udfStr1))
						{
							XSSFSheet dataSheet = retDataWorkbook.getSheet("b2b");
							
							if("R".equalsIgnoreCase(udfStr2))
							{
								invoiceType = "Regular";
							}
							else if("SEWP".equalsIgnoreCase(udfStr2))
							{
								invoiceType = "SEZ supplies with payment";
							}
							else if("SEWOP".equalsIgnoreCase(udfStr2))
							{
								invoiceType = "SEZ supplies without payment";
							}
							else if("DE".equalsIgnoreCase(udfStr2))
							{
								invoiceType = "Deemed Exp";
							}

							//Changed by Santosh on 05/10/2017 to group ratewise summary
							//detSql = " SELECT GST_RATE, TAXABLE_AMT, CESS_AMT FROM GST_DATA_DET  WHERE TRAN_ID = ? ";
							detSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(CESS_AMT) AS CESS_AMT FROM GST_DATA_DET WHERE TRAN_ID = ? GROUP BY GST_RATE";

							detPstmt = conn.prepareStatement(detSql);
							detPstmt.setString(1, tranId);
							detRs = detPstmt.executeQuery();
							while(detRs.next())
							{
								gstRate = Double.parseDouble(String.format("%.2f",detRs.getDouble("GST_RATE")));
								taxableAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("TAXABLE_AMT")));
								cessAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("CESS_AMT")));
								
								XSSFRow dataRow = dataSheet.createRow(b2bRowNum++);

								dataRow.createCell(0).setCellValue(ctin);
								dataRow.createCell(1).setCellValue(customerName);
								dataRow.createCell(2).setCellValue(docNo);
								XSSFCell docDateCell = dataRow.createCell(3);
								if(docDateStr!=null && docDateStr.trim().length()>0)
								{
									docDateCell.setCellValue(gstDateFormatSdf.parse(docDateStr));
									docDateCell.setCellStyle(dateCellStyle);
								}
								dataRow.createCell(4).setCellValue(amount);
								dataRow.createCell(5).setCellValue(posStateCode+"-"+stateDscr);
								dataRow.createCell(6).setCellValue(reverseCharge);
								dataRow.createCell(7).setCellValue(invoiceType);
								dataRow.createCell(8).setCellValue(etin);
								dataRow.createCell(9).setCellValue(gstRate);
								dataRow.createCell(10).setCellValue(taxableAmt);
								dataRow.createCell(11).setCellValue(cessAmt);
							}
							closeResources(detRs, detPstmt);
						}
						if("B2CL".equalsIgnoreCase(udfStr1))
						{
							XSSFSheet dataSheet = retDataWorkbook.getSheet("b2cl");
							
							//Changed by Santosh on 05/10/2017 to group ratewise summary
							//detSql = " SELECT GST_RATE, TAXABLE_AMT, CESS_AMT FROM GST_DATA_DET  WHERE TRAN_ID = ? ";
							detSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(CESS_AMT) AS CESS_AMT FROM GST_DATA_DET WHERE TRAN_ID = ? GROUP BY GST_RATE";

							detPstmt = conn.prepareStatement(detSql);
							detPstmt.setString(1, tranId);
							detRs = detPstmt.executeQuery();
							while(detRs.next())
							{
								gstRate = Double.parseDouble(String.format("%.2f",detRs.getDouble("GST_RATE")));
								taxableAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("TAXABLE_AMT")));
								cessAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("CESS_AMT")));
								
								XSSFRow dataRow = dataSheet.createRow(b2clRowNum++);
								
								dataRow.createCell(0).setCellValue(docNo);
								XSSFCell docDateCell = dataRow.createCell(1);
								if(docDateStr!=null && docDateStr.trim().length()>0)
								{
									docDateCell.setCellValue(gstDateFormatSdf.parse(docDateStr));
									docDateCell.setCellStyle(dateCellStyle);
								}
								dataRow.createCell(2).setCellValue(amount);
								dataRow.createCell(3).setCellValue(posStateCode+"-"+stateDscr);
								dataRow.createCell(4).setCellValue(gstRate);
								dataRow.createCell(5).setCellValue(taxableAmt);
								dataRow.createCell(6).setCellValue(cessAmt);
								dataRow.createCell(7).setCellValue(etin);
							}
							closeResources(detRs, detPstmt);
						}
						/*if("B2CS".equalsIgnoreCase(udfStr1))
						{
							XSSFSheet dataSheet = retDataWorkbook.getSheet("b2cs");
							
							//Changed by Santosh on 05/10/2017 to group ratewise summary
							//detSql = " SELECT GST_RATE, TAXABLE_AMT, CESS_AMT FROM GST_DATA_DET  WHERE TRAN_ID = ? ";
							detSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(CESS_AMT) AS CESS_AMT FROM GST_DATA_DET WHERE TRAN_ID = ? GROUP BY GST_RATE";

							detPstmt = conn.prepareStatement(detSql);
							detPstmt.setString(1, tranId);
							detRs = detPstmt.executeQuery();
							while(detRs.next())
							{
								gstRate = Double.parseDouble(String.format("%.2f",detRs.getDouble("GST_RATE")));
								taxableAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("TAXABLE_AMT")));
								cessAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("CESS_AMT")));
								
								XSSFRow dataRow = dataSheet.createRow(b2csRowNum++);
								
								dataRow.createCell(0).setCellValue(udfStr3);
								dataRow.createCell(1).setCellValue(posStateCode+"-"+stateDscr);
								dataRow.createCell(2).setCellValue(gstRate);
								dataRow.createCell(3).setCellValue(taxableAmt);
								dataRow.createCell(4).setCellValue(cessAmt);
								dataRow.createCell(5).setCellValue(etin);
							}
							closeResources(detRs, detPstmt);
						}*/
						if("CDNR".equalsIgnoreCase(udfStr1))
						{
							Calendar calendar = Calendar.getInstance();
							calendar.set(2017, 06, 01);
							Date gstStartDate = calendar.getTime();
							
							if(refInvDate!=null)
							{
								preGST = refInvDate.before(gstStartDate) ? "Y" : "N";
							}
							else
							{
								preGST = "";
							}
							
							XSSFSheet dataSheet = retDataWorkbook.getSheet("cdnr");
							
							//Changed by Santosh on 05/10/2017 to group ratewise summary
							//detSql = " SELECT GST_RATE, TAXABLE_AMT, CESS_AMT FROM GST_DATA_DET  WHERE TRAN_ID = ? ";
							detSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(CESS_AMT) AS CESS_AMT FROM GST_DATA_DET WHERE TRAN_ID = ? GROUP BY GST_RATE";

							detPstmt = conn.prepareStatement(detSql);
							detPstmt.setString(1, tranId);
							detRs = detPstmt.executeQuery();
							while(detRs.next())
							{
								gstRate = Double.parseDouble(String.format("%.2f",detRs.getDouble("GST_RATE")));
								taxableAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("TAXABLE_AMT")));
								cessAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("CESS_AMT")));
								
								XSSFRow dataRow = dataSheet.createRow(cdnrRowNum++);
								
								dataRow.createCell(0).setCellValue(ctin);
								dataRow.createCell(1).setCellValue(customerName);
								dataRow.createCell(2).setCellValue(refInvId);
								XSSFCell refInvDateCell = dataRow.createCell(3);
								if(refInvDtStr!=null && refInvDtStr.trim().length()>0)
								{
									refInvDateCell.setCellValue(gstDateFormatSdf.parse(refInvDtStr));
									refInvDateCell.setCellStyle(dateCellStyle);
								}
								dataRow.createCell(4).setCellValue(docNo);
								XSSFCell docDateCell = dataRow.createCell(5);
								if(docDateStr!=null && docDateStr.trim().length()>0)
								{
									docDateCell.setCellValue(gstDateFormatSdf.parse(docDateStr));
									docDateCell.setCellStyle(dateCellStyle);
								}
								dataRow.createCell(6).setCellValue(udfStr2);
								dataRow.createCell(7).setCellValue("07-Others");
								dataRow.createCell(8).setCellValue(posStateCode+"-"+stateDscr);
								dataRow.createCell(9).setCellValue(amount);
								dataRow.createCell(10).setCellValue(gstRate);
								dataRow.createCell(11).setCellValue(taxableAmt);
								dataRow.createCell(12).setCellValue(cessAmt);
								dataRow.createCell(13).setCellValue(preGST);
							}
							closeResources(detRs, detPstmt);
						}
						if("CDNUR".equalsIgnoreCase(udfStr1))
						{
							Calendar calendar = Calendar.getInstance();
							calendar.set(2017, 06, 01);
							Date gstStartDate = calendar.getTime();
							
							if(refInvDate!=null)
							{
								preGST = refInvDate.before(gstStartDate) ? "Y" : "N";
							}
							else
							{
								preGST = "";
							}
							
							if(refInvDate!=null && refInvDate.after(gstStartDate))
							{
								sql = "SELECT TRAN_TYPE FROM GST_DATA_HDR WHERE DOC_NO = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, tranId);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									refTranType = checkNull(rs.getString("TRAN_TYPE"));
								}
								closeResources(rs, pstmt);
								
								if(refTranType != null && refTranType.trim().length() > 0)
								{
									if("04".equalsIgnoreCase(refTranType) || "05".equalsIgnoreCase(refTranType))
									{
										customerType = "B2CL";
									}
									else if("06".equalsIgnoreCase(refTranType))
									{
										customerType = "EXPWP";
									}
									else if("07".equalsIgnoreCase(refTranType))
									{
										customerType = "EXPWOP";
									}
								}
							}
							
							XSSFSheet dataSheet = retDataWorkbook.getSheet("cdnur");
							
							//Changed by Santosh on 05/10/2017 to group ratewise summary
							//detSql = " SELECT GST_RATE, TAXABLE_AMT, CESS_AMT FROM GST_DATA_DET  WHERE TRAN_ID = ? ";
							detSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(CESS_AMT) AS CESS_AMT FROM GST_DATA_DET WHERE TRAN_ID = ? GROUP BY GST_RATE";

							detPstmt = conn.prepareStatement(detSql);
							detPstmt.setString(1, tranId);
							detRs = detPstmt.executeQuery();
							while(detRs.next())
							{
								gstRate = Double.parseDouble(String.format("%.2f",detRs.getDouble("GST_RATE")));
								taxableAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("TAXABLE_AMT")));
								cessAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("CESS_AMT")));
								
								XSSFRow dataRow = dataSheet.createRow(cdnurRowNum++);
								
								dataRow.createCell(0).setCellValue(customerType);
								dataRow.createCell(1).setCellValue(docNo);
								XSSFCell docDateCell = dataRow.createCell(2);
								if(docDateStr!=null && docDateStr.trim().length()>0)
								{
									docDateCell.setCellValue(gstDateFormatSdf.parse(docDateStr));
									docDateCell.setCellStyle(dateCellStyle);
								}
								dataRow.createCell(3).setCellValue(udfStr2);
								dataRow.createCell(4).setCellValue(refInvId);
								XSSFCell refInvDateCell = dataRow.createCell(5);
								if(refInvDtStr!=null && refInvDtStr.trim().length()>0)
								{
									refInvDateCell.setCellValue(gstDateFormatSdf.parse(refInvDtStr));
									refInvDateCell.setCellStyle(dateCellStyle);
								}
								dataRow.createCell(6).setCellValue("07-Others");
								dataRow.createCell(7).setCellValue(posStateCode+"-"+stateDscr);
								dataRow.createCell(8).setCellValue(amount);
								dataRow.createCell(9).setCellValue(gstRate);
								dataRow.createCell(10).setCellValue(taxableAmt);
								dataRow.createCell(11).setCellValue(cessAmt);
								dataRow.createCell(12).setCellValue(preGST);
							}
							closeResources(detRs, detPstmt);
						}
						if("EXP".equalsIgnoreCase(udfStr1))
						{
							XSSFSheet dataSheet = retDataWorkbook.getSheet("exp");
							
							//Changed by Santosh on 05/10/2017 to group ratewise summary
							//detSql = " SELECT GST_RATE, TAXABLE_AMT, CESS_AMT FROM GST_DATA_DET  WHERE TRAN_ID = ? ";
							detSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(CESS_AMT) AS CESS_AMT FROM GST_DATA_DET WHERE TRAN_ID = ? GROUP BY GST_RATE";

							detPstmt = conn.prepareStatement(detSql);
							detPstmt.setString(1, tranId);
							detRs = detPstmt.executeQuery();
							while(detRs.next())
							{
								gstRate = Double.parseDouble(String.format("%.2f",detRs.getDouble("GST_RATE")));
								taxableAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("TAXABLE_AMT")));
								cessAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("CESS_AMT")));
								
								XSSFRow dataRow = dataSheet.createRow(expRowNum++);
								
								dataRow.createCell(0).setCellValue(udfStr2);
								dataRow.createCell(1).setCellValue(docNo);
								XSSFCell docDateCell = dataRow.createCell(2);
								if(docDateStr!=null && docDateStr.trim().length()>0)
								{
									docDateCell.setCellValue(gstDateFormatSdf.parse(docDateStr));
									docDateCell.setCellStyle(dateCellStyle);
								}
								dataRow.createCell(3).setCellValue(amount);
								dataRow.createCell(4).setCellValue(portCode);
								dataRow.createCell(5).setCellValue(shipBillNo);
								XSSFCell shipBillDateCell = dataRow.createCell(6);
								if(shipBillDateStr != null && shipBillDateStr.trim().length()>0)
								{
									shipBillDateCell.setCellValue(gstDateFormatSdf.parse(shipBillDateStr));
									shipBillDateCell.setCellStyle(dateCellStyle);
								}
								else
								{
									shipBillDateCell.setCellValue("");
								}
								dataRow.createCell(7).setCellValue(gstRate);
								dataRow.createCell(8).setCellValue(taxableAmt);
							}
							closeResources(detRs, detPstmt);
						}
						if("AT".equalsIgnoreCase(udfStr1))
						{
							XSSFSheet dataSheet = retDataWorkbook.getSheet("at");
							
							//Changed by Santosh on 05/10/2017 to group ratewise summary
							//detSql = " SELECT GST_RATE, TAXABLE_AMT, CESS_AMT FROM GST_DATA_DET  WHERE TRAN_ID = ? ";
							detSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(CESS_AMT) AS CESS_AMT FROM GST_DATA_DET WHERE TRAN_ID = ? GROUP BY GST_RATE";

							detPstmt = conn.prepareStatement(detSql);
							detPstmt.setString(1, tranId);
							detRs = detPstmt.executeQuery();
							while(detRs.next())
							{
								gstRate = Double.parseDouble(String.format("%.2f",detRs.getDouble("GST_RATE")));
								taxableAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("TAXABLE_AMT")));
								cessAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("CESS_AMT")));
								
								XSSFRow dataRow = dataSheet.createRow(atRowNum++);
								
								dataRow.createCell(0).setCellValue(posStateCode+"-"+stateDscr);
								dataRow.createCell(1).setCellValue(gstRate);
								dataRow.createCell(2).setCellValue(taxableAmt);
								dataRow.createCell(3).setCellValue(cessAmt);
							}
							closeResources(detRs, detPstmt);
						}
						if("TXP".equalsIgnoreCase(udfStr1))
						{
							XSSFSheet dataSheet = retDataWorkbook.getSheet("atadj");
							
							//Changed by Santosh on 05/10/2017 to group ratewise summary
							//detSql = " SELECT GST_RATE, TAXABLE_AMT, CESS_AMT FROM GST_DATA_DET  WHERE TRAN_ID = ? ";
							detSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(CESS_AMT) AS CESS_AMT FROM GST_DATA_DET WHERE TRAN_ID = ? GROUP BY GST_RATE";

							detPstmt = conn.prepareStatement(detSql);
							detPstmt.setString(1, tranId);
							detRs = detPstmt.executeQuery();
							while(detRs.next())
							{
								gstRate = Double.parseDouble(String.format("%.2f",detRs.getDouble("GST_RATE")));
								taxableAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("TAXABLE_AMT")));
								cessAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("CESS_AMT")));
								
								XSSFRow dataRow = dataSheet.createRow(atAdjRowNum++);
								
								dataRow.createCell(0).setCellValue(posStateCode+"-"+stateDscr);
								dataRow.createCell(1).setCellValue(gstRate);
								dataRow.createCell(2).setCellValue(taxableAmt);
								dataRow.createCell(3).setCellValue(cessAmt);
							}
							closeResources(detRs, detPstmt);
						}
					}
					closeResources(hdrRs, hdrPstmt);
					
					XSSFSheet b2csDataSheet = retDataWorkbook.getSheet("b2cs");
					
					sql = " SELECT GDH.GST_CODE AS GST_CODE, GDH.ECOM_REG_NO AS ECOM_REG_NO, GDD.SUPPLY_TYPE AS SUPPLY_TYPE, S.DESCR AS DESCR,"
						+ " GDD.GST_RATE AS GST_RATE, SUM(GDD.TAXABLE_AMT) AS TAXABLE_AMT, SUM (GDD.CESS_AMT) AS CESS_AMT"
						+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD, STATE S"
						+ " WHERE GDD.TRAN_ID = GDH.TRAN_ID AND GDH.GST_CODE=S.GST_CODE AND GDH.SITE_CODE = ? AND GDH.REC_TYPE = ? AND GDH.PRD_CODE = ?"
						+ " AND GDH.SUBMIT_STATUS = ? AND GDH.TRAN_TYPE IN ('11','12','13','14') GROUP BY GDH.GST_CODE, ECOM_REG_NO, SUPPLY_TYPE, DESCR, GST_RATE";

					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode);
					pstmt.setString(2, recType);
					pstmt.setString(3, periodCode);
					pstmt.setString(4, "P");
					rs = pstmt.executeQuery();
					while(rs.next())
					{
						supplyType = checkNull(rs.getString("SUPPLY_TYPE"));
						etin = checkNull(rs.getString("ECOM_REG_NO"));
						gstRate = Double.parseDouble(String.format("%.2f",rs.getDouble("GST_RATE")));
						taxableAmt = Double.parseDouble(String.format("%.2f",rs.getDouble("TAXABLE_AMT")));
						cessAmt = Double.parseDouble(String.format("%.2f",rs.getDouble("CESS_AMT")));
						
						XSSFRow dataRow = b2csDataSheet.createRow(b2csRowNum++);
						
						dataRow.createCell(0).setCellValue(supplyType);
						dataRow.createCell(1).setCellValue(rs.getString("GST_CODE")+"-"+rs.getString("DESCR"));
						dataRow.createCell(2).setCellValue(gstRate);
						dataRow.createCell(3).setCellValue(taxableAmt);
						dataRow.createCell(4).setCellValue(cessAmt);
						dataRow.createCell(5).setCellValue(etin);
					}
					closeResources(rs, pstmt);
					
					XSSFSheet nilDataSheet = retDataWorkbook.getSheet("exemp");
					
					sql = " SELECT TRAN_TYPE,SUM(AMOUNT) AS AMOUNT FROM GST_DATA_HDR "
						+ " WHERE REC_TYPE = '1' AND TRAN_TYPE  in (?,?,?) AND SITE_CODE = ? AND PRD_CODE = ?"
						+ " GROUP BY TRAN_TYPE";
						
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, "15");
					pstmt.setString(2, "16");
					pstmt.setString(3, "17");
					pstmt.setString(4, siteCode);
					pstmt.setString(5, periodCode);
					
					rs = pstmt.executeQuery();
					
					while(rs.next())
					{
						if("15".equalsIgnoreCase(rs.getString("TRAN_TYPE")))
						{
							nilAmount = Double.parseDouble(String.format("%.2f",rs.getDouble("AMOUNT")));
						}
						if("16".equalsIgnoreCase(rs.getString("TRAN_TYPE")))
						{
							exemtAmount = Double.parseDouble(String.format("%.2f",rs.getDouble("AMOUNT")));
						}
						if("17".equalsIgnoreCase(rs.getString("TRAN_TYPE")))
						{
							nonGSTAmount = Double.parseDouble(String.format("%.2f",rs.getDouble("AMOUNT")));
						}
					}
					closeResources(rs, pstmt);
					
					XSSFRow nilInterRegDataRow = nilDataSheet.getRow(4);
					
					nilInterRegDataRow.createCell(1).setCellValue(nilAmount);
					nilInterRegDataRow.createCell(2).setCellValue(exemtAmount);
					nilInterRegDataRow.createCell(3).setCellValue(nonGSTAmount);
					
					nilAmount = 0.0; exemtAmount = 0.0; nonGSTAmount = 0.0;
					
					sql = " SELECT TRAN_TYPE,SUM(AMOUNT) AS AMOUNT FROM GST_DATA_HDR "
						+ " WHERE REC_TYPE = '1' AND TRAN_TYPE  in (?,?,?) AND SITE_CODE = ? AND PRD_CODE = ?"
						+ " GROUP BY TRAN_TYPE";
						
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, "18");
					pstmt.setString(2, "19");
					pstmt.setString(3, "20");
					pstmt.setString(4, siteCode);
					pstmt.setString(5, periodCode);
					
					rs = pstmt.executeQuery();
					
					while(rs.next())
					{
						if("18".equalsIgnoreCase(rs.getString("TRAN_TYPE")))
						{
							nilAmount = Double.parseDouble(String.format("%.2f",rs.getDouble("AMOUNT")));
						}
						if("19".equalsIgnoreCase(rs.getString("TRAN_TYPE")))
						{
							exemtAmount = Double.parseDouble(String.format("%.2f",rs.getDouble("AMOUNT")));
						}
						if("20".equalsIgnoreCase(rs.getString("TRAN_TYPE")))
						{
							nonGSTAmount = Double.parseDouble(String.format("%.2f",rs.getDouble("AMOUNT")));
						}
					}
					closeResources(rs, pstmt);
					
					XSSFRow intraRegDataRow = nilDataSheet.getRow(5);
					
					intraRegDataRow.createCell(1).setCellValue(nilAmount);
					intraRegDataRow.createCell(2).setCellValue(exemtAmount);
					intraRegDataRow.createCell(3).setCellValue(nonGSTAmount);
					
					nilAmount = 0.0; exemtAmount = 0.0; nonGSTAmount = 0.0;
					
					sql = " SELECT TRAN_TYPE,SUM(AMOUNT) AS AMOUNT FROM GST_DATA_HDR "
						+ " WHERE REC_TYPE = '1' AND TRAN_TYPE  in (?,?,?) AND SITE_CODE = ? AND PRD_CODE = ?"
						+ " GROUP BY TRAN_TYPE";
						
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, "21");
					pstmt.setString(2, "22");
					pstmt.setString(3, "23");
					pstmt.setString(4, siteCode);
					pstmt.setString(5, periodCode);
					
					rs = pstmt.executeQuery();
					
					while(rs.next())
					{
						if("21".equalsIgnoreCase(rs.getString("TRAN_TYPE")))
						{
							nilAmount = Double.parseDouble(String.format("%.2f",rs.getDouble("AMOUNT")));
						}
						if("22".equalsIgnoreCase(rs.getString("TRAN_TYPE")))
						{
							exemtAmount = Double.parseDouble(String.format("%.2f",rs.getDouble("AMOUNT")));
						}
						if("23".equalsIgnoreCase(rs.getString("TRAN_TYPE")))
						{
							nonGSTAmount = Double.parseDouble(String.format("%.2f",rs.getDouble("AMOUNT")));
						}
					}
					closeResources(rs, pstmt);
					
					XSSFRow interUnregDataRow = nilDataSheet.getRow(6);
					
					interUnregDataRow.createCell(1).setCellValue(nilAmount);
					interUnregDataRow.createCell(2).setCellValue(exemtAmount);
					interUnregDataRow.createCell(3).setCellValue(nonGSTAmount);
					
					nilAmount = 0.0; exemtAmount = 0.0; nonGSTAmount = 0.0;
					
					sql = " SELECT TRAN_TYPE,SUM(AMOUNT) AS AMOUNT FROM GST_DATA_HDR "
						+ " WHERE REC_TYPE = '1' AND TRAN_TYPE  in (?,?,?) AND SITE_CODE = ? AND PRD_CODE = ?"
						+ " GROUP BY TRAN_TYPE";
						
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, "24");
					pstmt.setString(2, "25");
					pstmt.setString(3, "26");
					pstmt.setString(4, siteCode);
					pstmt.setString(5, periodCode);
					
					rs = pstmt.executeQuery();
					
					while(rs.next())
					{
						if("24".equalsIgnoreCase(rs.getString("TRAN_TYPE")))
						{
							nilAmount = Double.parseDouble(String.format("%.2f",rs.getDouble("AMOUNT")));
						}
						if("25".equalsIgnoreCase(rs.getString("TRAN_TYPE")))
						{
							exemtAmount = Double.parseDouble(String.format("%.2f",rs.getDouble("AMOUNT")));
						}
						if("26".equalsIgnoreCase(rs.getString("TRAN_TYPE")))
						{
							nonGSTAmount = Double.parseDouble(String.format("%.2f",rs.getDouble("AMOUNT")));
						}
					}
					closeResources(rs, pstmt);
					
					XSSFRow intraUnregDataRow = nilDataSheet.getRow(7);
					
					intraUnregDataRow.createCell(1).setCellValue(nilAmount);
					intraUnregDataRow.createCell(2).setCellValue(exemtAmount);
					intraUnregDataRow.createCell(3).setCellValue(nonGSTAmount);
						
					XSSFSheet hsnDataSheet = retDataWorkbook.getSheet("hsn");
					
					sql = " SELECT GS_CODE, UNIT, DESCR, SUM(TOT_QTY) AS TOT_QTY, SUM(TOT_TAXVAL) AS TOT_TAXVAL, SUM(TOT_IAMT) AS TOT_IAMT, SUM(TOT_CAMT) AS TOT_CAMT, SUM(TOT_SAMT) AS TOT_SAMT, SUM(TOT_CSAMT) AS TOT_CSAMT FROM"
						+ " (SELECT GDD.GS_CODE, GDD.UNIT, U.DESCR, SUM(GDD.QUANTITY) AS TOT_QTY, SUM(GDD.TAXABLE_AMT) AS TOT_TAXVAL,"
						+ " SUM(GDD.IGST_AMT) AS TOT_IAMT, SUM(CGST_AMT) AS TOT_CAMT, SUM(SGST_AMT) AS TOT_SAMT, SUM(CESS_AMT) AS TOT_CSAMT"
						+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD, UOM U"
						+ " WHERE GDH.TRAN_ID = GDD.TRAN_ID AND GDD.GS_CODE IS NOT NULL AND GDH.REC_TYPE='1' AND GDD.UNIT=U.UNIT"
						+ " AND GDH.SITE_CODE = ? AND GDH.PRD_CODE = ? AND GDH.TRAN_TYPE NOT IN ('29','31','15','16','17','18','19','20','21','22','23','24','25','26')"
						+ " GROUP BY GDD.GS_CODE, GDD.UNIT, U.DESCR"
						+ " UNION ALL"
						+ " SELECT GDD.GS_CODE, GDD.UNIT,  U.DESCR, -1*SUM(GDD.QUANTITY) AS TOT_QTY, -1*SUM(GDD.TAXABLE_AMT) AS TOT_TAXVAL,"
						+ " -1*SUM(GDD.IGST_AMT) AS TOT_IAMT, -1*SUM(CGST_AMT) AS TOT_CAMT, -1*SUM(SGST_AMT) AS TOT_SAMT, -1*SUM(CESS_AMT) AS TOT_CSAMT"
						+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD, UOM U"
						+ " WHERE GDH.TRAN_ID = GDD.TRAN_ID AND GDD.GS_CODE IS NOT NULL AND GDH.REC_TYPE='1'  AND GDD.UNIT=U.UNIT"
						+ " AND GDH.SITE_CODE = ? AND GDH.PRD_CODE = ? AND GDH.TRAN_TYPE  IN ('29','31')"
						+ " GROUP BY GDD.GS_CODE, GDD.UNIT, U.DESCR) GROUP BY GS_CODE, UNIT, DESCR";
					
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode);
					pstmt.setString(2, periodCode);
					pstmt.setString(3, siteCode);
					pstmt.setString(4, periodCode);
					rs = pstmt.executeQuery();
					
					while (rs.next()) 
					{
						XSSFRow dataRow = hsnDataSheet.createRow(hsnRowNum++);
						
						dataRow.createCell(0).setCellValue(checkNull(rs.getString("GS_CODE")));
						String unitDescr = checkNull(rs.getString("UNIT")) + "-" + checkNull(rs.getString("DESCR"));
						dataRow.createCell(2).setCellValue(unitDescr);
						dataRow.createCell(3).setCellValue(Double.parseDouble(String.format("%.2f",rs.getDouble("TOT_QTY"))));
						double totalValue = rs.getDouble("TOT_TAXVAL") + rs.getDouble("TOT_IAMT") + rs.getDouble("TOT_CAMT") + rs.getDouble("TOT_SAMT") + rs.getDouble("TOT_CSAMT");
						dataRow.createCell(4).setCellValue(Double.parseDouble(String.format("%.2f",totalValue)));
						dataRow.createCell(5).setCellValue(Double.parseDouble(String.format("%.2f",rs.getDouble("TOT_TAXVAL"))));
						dataRow.createCell(6).setCellValue(Double.parseDouble(String.format("%.2f",rs.getDouble("TOT_IAMT"))));
						dataRow.createCell(7).setCellValue(Double.parseDouble(String.format("%.2f",rs.getDouble("TOT_CAMT"))));
						dataRow.createCell(8).setCellValue(Double.parseDouble(String.format("%.2f",rs.getDouble("TOT_SAMT"))));
						dataRow.createCell(9).setCellValue(Double.parseDouble(String.format("%.2f",rs.getDouble("TOT_CSAMT"))));
					}
					closeResources(rs, pstmt);
					
					XSSFSheet docDataSheet = retDataWorkbook.getSheet("docs");
					
					sql = " SELECT MIN(DOC_NO) FROM_NO, MAX(DOC_NO) TO_NO, COUNT(1) TOT_CNT"
						+ " FROM GST_DATA_HDR WHERE SITE_CODE = ? AND PRD_CODE = ? AND REC_TYPE = ?"
						+ " AND TRAN_TYPE IN ('01','03','04','05','11','12','13','14', '06', '07')";//Added by Santosh on 02/01/2018 to add export invoice count
					
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode);
					pstmt.setString(2, periodCode);
					pstmt.setString(3, "1");
					
					rs = pstmt.executeQuery();
					
					if(rs.next())
					{
						if(rs.getInt("TOT_CNT") > 0)
						{
							XSSFRow dataRow = docDataSheet.getRow(4);
							dataRow.createCell(1).setCellValue(rs.getString("FROM_NO"));
							dataRow.createCell(2).setCellValue(rs.getString("TO_NO"));
							dataRow.createCell(3).setCellValue(rs.getInt("TOT_CNT"));
							dataRow.createCell(4).setCellValue(0);
						}
					}
					closeResources(rs, pstmt);
					
					sql = " SELECT MIN(DOC_NO) FROM_NO, MAX(DOC_NO) TO_NO, COUNT(1) TOT_CNT"
						+ " FROM GST_DATA_HDR WHERE SITE_CODE = ? AND PRD_CODE = ? AND REC_TYPE = ?"
						+ " AND TRAN_TYPE IN ('02')";
					
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode);
					pstmt.setString(2, periodCode);
					pstmt.setString(3, "1");
					
					rs = pstmt.executeQuery();
					
					if(rs.next())
					{
						if(rs.getInt("TOT_CNT") > 0)
						{
							XSSFRow dataRow = docDataSheet.getRow(5);
							dataRow.createCell(1).setCellValue(rs.getString("FROM_NO"));
							dataRow.createCell(2).setCellValue(rs.getString("TO_NO"));
							dataRow.createCell(3).setCellValue(rs.getInt("TOT_CNT"));
							dataRow.createCell(4).setCellValue(0);
						}
					}
					closeResources(rs, pstmt);
					
					sql = " SELECT MIN(DOC_NO) FROM_NO, MAX(DOC_NO) TO_NO, COUNT(1) TOT_CNT"
						+ " FROM GST_DATA_HDR WHERE SITE_CODE = ? AND PRD_CODE = ? AND REC_TYPE = ?"
						+ " AND TRAN_TYPE IN ('30','32')";
					
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode);
					pstmt.setString(2, periodCode);
					pstmt.setString(3, "1");
					
					rs = pstmt.executeQuery();
					
					if(rs.next())
					{
						if(rs.getInt("TOT_CNT") > 0)
						{
							XSSFRow dataRow = docDataSheet.getRow(7);
							dataRow.createCell(1).setCellValue(rs.getString("FROM_NO"));
							dataRow.createCell(2).setCellValue(rs.getString("TO_NO"));
							dataRow.createCell(3).setCellValue(rs.getInt("TOT_CNT"));
							dataRow.createCell(4).setCellValue(0);
						}
					}
					closeResources(rs, pstmt);
					
					sql = " SELECT MIN(DOC_NO) FROM_NO, MAX(DOC_NO) TO_NO, COUNT(1) TOT_CNT"
						+ " FROM GST_DATA_HDR WHERE SITE_CODE = ? AND PRD_CODE = ? AND REC_TYPE = ?"
						+ " AND TRAN_TYPE IN ('29','31')";
					
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode);
					pstmt.setString(2, periodCode);
					pstmt.setString(3, "1");
					
					rs = pstmt.executeQuery();
					
					if(rs.next())
					{
						if(rs.getInt("TOT_CNT") > 0)
						{
							XSSFRow dataRow = docDataSheet.getRow(8);
							dataRow.createCell(1).setCellValue(rs.getString("FROM_NO"));
							dataRow.createCell(2).setCellValue(rs.getString("TO_NO"));
							dataRow.createCell(3).setCellValue(rs.getInt("TOT_CNT"));
							dataRow.createCell(4).setCellValue(0);
						}
					}
					closeResources(rs, pstmt);
					
					boolean isGSNullSheetAdded = false, isUnitNullSheetAdded = false, isPortNullSheetAdded = false;
					XSSFSheet hsnBlnkDataSheet = null, unitBlnkDataSheet = null, portBlnkDataSheet = null;
					int rowNo = 1;
					
					sql = " SELECT H.REF_ID, H.REF_SER, D.TAXABLE_AMT FROM GST_DATA_HDR H, GST_DATA_DET D WHERE H.TRAN_ID = D.TRAN_ID AND H.SITE_CODE = ? AND H.PRD_CODE = ? AND H.REC_TYPE = ? "
						+ " AND D.GS_CODE IS NULL ";
					
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode);
					pstmt.setString(2, periodCode);
					pstmt.setString(3, "1");
					
					rs = pstmt.executeQuery();
					
					while(rs.next())
					{
						if(!isGSNullSheetAdded)
						{
							retDataWorkbook.createSheet("HSN BLANK");
							isGSNullSheetAdded = true;
							
							hsnBlnkDataSheet = retDataWorkbook.getSheet("HSN BLANK");
							XSSFRow hdrRow = hsnBlnkDataSheet.createRow(0);
							hdrRow.createCell(0).setCellValue("REF_ID");
							hdrRow.createCell(1).setCellValue("REF_SER");
							hdrRow.createCell(2).setCellValue("TAXABLE_AMT");
						}
						
						XSSFRow dataRow = hsnBlnkDataSheet.createRow(rowNo++);
						dataRow.createCell(0).setCellValue(rs.getString("REF_ID"));
						dataRow.createCell(1).setCellValue(rs.getString("REF_SER"));
						dataRow.createCell(2).setCellValue(rs.getString("TAXABLE_AMT"));
					}
					
					closeResources(rs, pstmt);
					
					rowNo = 1;
					
					sql = " SELECT H.REF_ID, H.REF_SER, D.GS_CODE, D.TAXABLE_AMT, D.UNIT FROM GST_DATA_HDR H, GST_DATA_DET D WHERE H.TRAN_ID = D.TRAN_ID AND H.SITE_CODE = ? AND H.PRD_CODE = ? AND H.REC_TYPE = ? "
						+ " AND D.UNIT NOT IN (SELECT DISTINCT UNIT FROM UOM) ";
					
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode);
					pstmt.setString(2, periodCode);
					pstmt.setString(3, "1");
					
					rs = pstmt.executeQuery();
					
					while(rs.next())
					{
						if(!isUnitNullSheetAdded)
						{
							retDataWorkbook.createSheet("UOM INVALID-BLANK");
							isUnitNullSheetAdded = true;
							
							unitBlnkDataSheet = retDataWorkbook.getSheet("UOM INVALID-BLANK");
							XSSFRow hdrRow = unitBlnkDataSheet.createRow(0);
							hdrRow.createCell(0).setCellValue("REF_ID");
							hdrRow.createCell(1).setCellValue("REF_SER");
							hdrRow.createCell(2).setCellValue("HSN/SAC");
							hdrRow.createCell(3).setCellValue("TAXABLE_AMT");
							hdrRow.createCell(4).setCellValue("UNIT");
						}
						
						XSSFRow dataRow = unitBlnkDataSheet.createRow(rowNo++);
						dataRow.createCell(0).setCellValue(rs.getString("REF_ID"));
						dataRow.createCell(1).setCellValue(rs.getString("REF_SER"));
						dataRow.createCell(2).setCellValue(rs.getString("GS_CODE"));
						dataRow.createCell(3).setCellValue(rs.getString("TAXABLE_AMT"));
						dataRow.createCell(4).setCellValue(rs.getString("UNIT"));
					}
					
					closeResources(rs, pstmt);
					
					rowNo = 1;  
					
					sql = " SELECT H.REF_ID, H.REF_SER, H.AMOUNT FROM GST_DATA_HDR H, GST_DATA_DET D WHERE H.TRAN_ID = D.TRAN_ID AND H.SITE_CODE = ? AND H.PRD_CODE = ? AND H.REC_TYPE = ? AND H.TRAN_TYPE IN ('06','07') "
						+ " AND H.ORDER_NO IS NULL ";
					
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode);
					pstmt.setString(2, periodCode);
					pstmt.setString(3, "1");
					
					rs = pstmt.executeQuery();
					
					while(rs.next())
					{
						if(!isPortNullSheetAdded)
						{
							retDataWorkbook.createSheet("PORT CODE BLANK");
							isPortNullSheetAdded = true;
							
							portBlnkDataSheet = retDataWorkbook.getSheet("PORT CODE BLANK");
							XSSFRow hdrRow = portBlnkDataSheet.createRow(0);
							hdrRow.createCell(0).setCellValue("REF_ID");
							hdrRow.createCell(1).setCellValue("REF_SER");
							hdrRow.createCell(2).setCellValue("AMOUNT");
						}
						
						XSSFRow dataRow = portBlnkDataSheet.createRow(rowNo++);
						dataRow.createCell(0).setCellValue(rs.getString("REF_ID"));
						dataRow.createCell(1).setCellValue(rs.getString("REF_SER"));
						dataRow.createCell(2).setCellValue(rs.getString("AMOUNT"));
					}
					
					closeResources(rs, pstmt);
				}
				else if("2".equalsIgnoreCase(recType))
				{
					hdrSql = "SELECT * FROM GST_DATA_HDR WHERE REC_TYPE = ? AND PRD_CODE = ? AND SITE_CODE = ? AND SUBMIT_STATUS = ? ORDER BY DOC_DATE, DOC_NO";
					hdrPstmt = conn.prepareStatement(hdrSql);
					hdrPstmt.setString(1, recType);
					hdrPstmt.setString(2, periodCode);
					hdrPstmt.setString(3, siteCode);
					hdrPstmt.setString(4, "P");

					hdrRs = hdrPstmt.executeQuery();
					
					while(hdrRs.next())
					{
						stateDscr = "";
						
						tranId = hdrRs.getString("TRAN_ID");
						tranType = hdrRs.getString("TRAN_TYPE");
						ctin = checkNull(hdrRs.getString("TAX_REG_NO"));
						posStateCode = checkNull(hdrRs.getString("GST_CODE"));
						docNo = checkNull(hdrRs.getString("DOC_NO"));
						docDate = hdrRs.getDate("DOC_DATE");
						amount = Double.parseDouble(String.format("%.2f",hdrRs.getDouble("AMOUNT")));
						reverseCharge = checkNull(hdrRs.getString("REVERSE_CHRG"));
						etin = checkNull(hdrRs.getString("ECOM_REG_NO"));
						refInvId = checkNull(hdrRs.getString("REF_ID__INV"));
						refInvDate = hdrRs.getDate("REF_DATE__INV");
						portCode = checkNull(hdrRs.getString("ORDER_NO"));
						shipBillNo = checkNull(hdrRs.getString("LR_NO"));
						shipBillDate = hdrRs.getDate("LR_DATE");
						supplierName = checkNull(hdrRs.getString("CUST_NAME"));
						
						sql = "SELECT DESCR FROM STATE WHERE GST_CODE = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, posStateCode);

						rs = pstmt.executeQuery();

						if(rs.next())
						{
							stateDscr = checkNull(rs.getString("DESCR"));
						}
						closeResources(rs, pstmt);

						if(docDate!=null)
						{
							docDateStr = gstDateFormatSdf.format(docDate);
						}
						if(refInvDate!=null)
						{
							refInvDtStr = gstDateFormatSdf.format(refInvDate);
						}
						if(shipBillDate!=null)
						{
							shipBillDateStr = gstDateFormatSdf.format(shipBillDate);
						}

						System.out.println("docDateStr["+docDateStr+"]");

						sql = "SELECT UDF_STR1, UDF_STR2, UDF_STR3 FROM GENCODES WHERE MOD_NAME='W_GSTR_PURC' AND FLD_NAME='TRAN_TYPE' AND FLD_VALUE = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, tranType);

						rs = pstmt.executeQuery();

						if(rs.next())
						{
							udfStr1 = checkNull(rs.getString("UDF_STR1"));
							udfStr2 = checkNull(rs.getString("UDF_STR2"));
							udfStr3 = checkNull(rs.getString("UDF_STR3"));
						}
						closeResources(rs, pstmt);
						
						sql = "SELECT SUBSTR(REG_NO,0,2) AS STATE_CD FROM SITEREGNO WHERE SITE_CODE = ? AND REF_CODE ='GSTIN_NO'";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, siteCode);

						rs = pstmt.executeQuery();

						if(rs.next())
						{
							placeOfBusiness = rs.getString("STATE_CD");
						}
						closeResources(rs, pstmt);
						
						
						System.out.println("udfStr1["+udfStr1+"] udfStr2["+udfStr2+"] udfStr3["+udfStr3+"]");
						
						if("B2B".equalsIgnoreCase(udfStr1))
						{
							XSSFSheet dataSheet = retDataWorkbook.getSheet("b2b");
							
							if("R".equalsIgnoreCase(udfStr2))
							{
								invoiceType = "Regular";
							}
							else if("SEWP".equalsIgnoreCase(udfStr2))
							{
								invoiceType = "SEZ supplies with payment";
							}
							else if("SEWOP".equalsIgnoreCase(udfStr2))
							{
								invoiceType = "SEZ supplies without payment";
							}
							else if("DE".equalsIgnoreCase(udfStr2))
							{
								invoiceType = "Deemed Exp";
							}

							detSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(IGST_AMT) AS IGST_AMT, SUM(CGST_AMT) AS CGST_AMT, SUM(SGST_AMT) AS SGST_AMT, SUM(CESS_AMT) AS CESS_AMT,"
								   + " ITC_TYPE,SUM(ITC_IGST) AS ITC_IGST, SUM(ITC_CGST) AS ITC_CGST, SUM(ITC_SGST) AS ITC_SGST, SUM(ITC_CESS) AS ITC_CESS"
								   + " FROM GST_DATA_DET WHERE TRAN_ID = ? GROUP BY GST_RATE, ITC_TYPE";

							detPstmt = conn.prepareStatement(detSql);
							detPstmt.setString(1, tranId);
							detRs = detPstmt.executeQuery();
							while(detRs.next())
							{
								gstRate = Double.parseDouble(String.format("%.2f",detRs.getDouble("GST_RATE")));
								taxableAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("TAXABLE_AMT")));
								igstAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("IGST_AMT")));
								cgstAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("CGST_AMT")));
								sgstAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("SGST_AMT")));
								cessAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("CESS_AMT")));
								itcType = checkNull(detRs.getString("ITC_TYPE"));
								igstITCAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("ITC_IGST")));
								cgstITCAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("ITC_CGST")));
								sgstITCAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("ITC_SGST")));
								cessITCAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("ITC_CESS")));
								
								if(itcTypeHMap.containsKey(itcType.toUpperCase()))
								{
									itcTypeDescr = itcTypeHMap.get(itcType.toUpperCase());
								}
								else
								{
									itcTypeDescr = "";
								}
								
								XSSFRow dataRow = dataSheet.createRow(b2bRowNum++);

								dataRow.createCell(0).setCellValue(ctin);
								dataRow.createCell(1).setCellValue(docNo);
								XSSFCell docDateCell = dataRow.createCell(2);
								if(docDateStr!=null && docDateStr.trim().length()>0)
								{
									docDateCell.setCellValue(gstDateFormatSdf.parse(docDateStr));
									docDateCell.setCellStyle(dateCellStyle);
								}
								dataRow.createCell(3).setCellValue(amount);
								dataRow.createCell(4).setCellValue(posStateCode+"-"+stateDscr);
								dataRow.createCell(5).setCellValue(reverseCharge);
								dataRow.createCell(6).setCellValue(invoiceType);
								dataRow.createCell(7).setCellValue(gstRate);
								dataRow.createCell(8).setCellValue(taxableAmt);
								dataRow.createCell(9).setCellValue(igstAmt);
								dataRow.createCell(10).setCellValue(cgstAmt);
								dataRow.createCell(11).setCellValue(sgstAmt);
								dataRow.createCell(12).setCellValue(cessAmt);
								dataRow.createCell(13).setCellValue(itcTypeDescr);
								dataRow.createCell(14).setCellValue(igstITCAmt);
								dataRow.createCell(15).setCellValue(cgstITCAmt);
								dataRow.createCell(16).setCellValue(sgstITCAmt);
								dataRow.createCell(17).setCellValue(cessITCAmt);
							}
							closeResources(detRs, detPstmt);
						}
						if("B2BUR".equalsIgnoreCase(udfStr1))
						{
							XSSFSheet dataSheet = retDataWorkbook.getSheet("b2bur");
							
							if(placeOfBusiness.trim().equalsIgnoreCase(posStateCode.trim()))
							{
								supplyType = "Intra State";
							}
							else
							{
								supplyType = "Inter State";
							}
							
							detSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(IGST_AMT) AS IGST_AMT, SUM(CGST_AMT) AS CGST_AMT, SUM(SGST_AMT) AS SGST_AMT, SUM(CESS_AMT) AS CESS_AMT,"
								   + " ITC_TYPE,SUM(ITC_IGST) AS ITC_IGST, SUM(ITC_CGST) AS ITC_CGST, SUM(ITC_SGST) AS ITC_SGST, SUM(ITC_CESS) AS ITC_CESS"
								   + " FROM GST_DATA_DET WHERE TRAN_ID = ? GROUP BY GST_RATE, ITC_TYPE";

							detPstmt = conn.prepareStatement(detSql);
							detPstmt.setString(1, tranId);
							detRs = detPstmt.executeQuery();
							while(detRs.next())
							{
								gstRate = Double.parseDouble(String.format("%.2f",detRs.getDouble("GST_RATE")));
								taxableAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("TAXABLE_AMT")));
								igstAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("IGST_AMT")));
								cgstAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("CGST_AMT")));
								sgstAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("SGST_AMT")));
								cessAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("CESS_AMT")));
								itcType = checkNull(detRs.getString("ITC_TYPE"));
								igstITCAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("ITC_IGST")));
								cgstITCAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("ITC_CGST")));
								sgstITCAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("ITC_SGST")));
								cessITCAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("ITC_CESS")));
								
								if(itcTypeHMap.containsKey(itcType.toUpperCase()))
								{
									itcTypeDescr = itcTypeHMap.get(itcType.toUpperCase());
								}
								else
								{
									itcTypeDescr = "";
								}
								
								XSSFRow dataRow = dataSheet.createRow(b2burRowNum++);

								dataRow.createCell(0).setCellValue(supplierName);
								dataRow.createCell(1).setCellValue(docNo);
								XSSFCell docDateCell = dataRow.createCell(2);
								if(docDateStr!=null && docDateStr.trim().length()>0)
								{
									docDateCell.setCellValue(gstDateFormatSdf.parse(docDateStr));
									docDateCell.setCellStyle(dateCellStyle);
								}
								dataRow.createCell(3).setCellValue(amount);
								dataRow.createCell(4).setCellValue(posStateCode+"-"+stateDscr);
								dataRow.createCell(5).setCellValue(supplyType);
								dataRow.createCell(6).setCellValue(gstRate);
								dataRow.createCell(7).setCellValue(taxableAmt);
								dataRow.createCell(8).setCellValue(igstAmt);
								dataRow.createCell(9).setCellValue(cgstAmt);
								dataRow.createCell(10).setCellValue(sgstAmt);
								dataRow.createCell(11).setCellValue(cessAmt);
								dataRow.createCell(12).setCellValue(itcTypeDescr);
								dataRow.createCell(13).setCellValue(igstITCAmt);
								dataRow.createCell(14).setCellValue(cgstITCAmt);
								dataRow.createCell(15).setCellValue(sgstITCAmt);
								dataRow.createCell(16).setCellValue(cessITCAmt);
							}
							closeResources(detRs, detPstmt);
						}
						if("IMP_S".equalsIgnoreCase(udfStr1))
						{
							XSSFSheet dataSheet = retDataWorkbook.getSheet("imps");
							
							detSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(IGST_AMT) AS IGST_AMT, SUM(CGST_AMT) AS CGST_AMT, SUM(SGST_AMT) AS SGST_AMT, SUM(CESS_AMT) AS CESS_AMT,"
								   + " ITC_TYPE,SUM(ITC_IGST) AS ITC_IGST, SUM(ITC_CGST) AS ITC_CGST, SUM(ITC_SGST) AS ITC_SGST, SUM(ITC_CESS) AS ITC_CESS"
								   + " FROM GST_DATA_DET WHERE TRAN_ID = ? GROUP BY GST_RATE, ITC_TYPE";

							detPstmt = conn.prepareStatement(detSql);
							detPstmt.setString(1, tranId);
							detRs = detPstmt.executeQuery();
							while(detRs.next())
							{
								gstRate = Double.parseDouble(String.format("%.2f",detRs.getDouble("GST_RATE")));
								taxableAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("TAXABLE_AMT")));
								igstAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("IGST_AMT")));
								cessAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("CESS_AMT")));
								itcType = checkNull(detRs.getString("ITC_TYPE"));
								igstITCAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("ITC_IGST")));
								cessITCAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("ITC_CESS")));
								
								if(itcTypeHMap.containsKey(itcType.toUpperCase()))
								{
									itcTypeDescr = itcTypeHMap.get(itcType.toUpperCase());
								}
								else
								{
									itcTypeDescr = "";
								}
								
								XSSFRow dataRow = dataSheet.createRow(impsRowNum++);

								dataRow.createCell(0).setCellValue(docNo);
								XSSFCell docDateCell = dataRow.createCell(1);
								if(docDateStr!=null && docDateStr.trim().length()>0)
								{
									docDateCell.setCellValue(gstDateFormatSdf.parse(docDateStr));
									docDateCell.setCellStyle(dateCellStyle);
								}
								dataRow.createCell(2).setCellValue(amount);
								dataRow.createCell(3).setCellValue(posStateCode+"-"+stateDscr);
								dataRow.createCell(4).setCellValue(gstRate);
								dataRow.createCell(5).setCellValue(taxableAmt);
								dataRow.createCell(6).setCellValue(igstAmt);
								dataRow.createCell(7).setCellValue(cessAmt);
								dataRow.createCell(8).setCellValue(itcTypeDescr);
								dataRow.createCell(9).setCellValue(igstITCAmt);
								dataRow.createCell(10).setCellValue(cessITCAmt);
							}
							closeResources(detRs, detPstmt);
						}
						if("IMP_G".equalsIgnoreCase(udfStr1))
						{
							XSSFSheet dataSheet = retDataWorkbook.getSheet("impg");
							
							detSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(IGST_AMT) AS IGST_AMT, SUM(CGST_AMT) AS CGST_AMT, SUM(SGST_AMT) AS SGST_AMT, SUM(CESS_AMT) AS CESS_AMT,"
								   + " ITC_TYPE,SUM(ITC_IGST) AS ITC_IGST, SUM(ITC_CGST) AS ITC_CGST, SUM(ITC_SGST) AS ITC_SGST, SUM(ITC_CESS) AS ITC_CESS"
								   + " FROM GST_DATA_DET WHERE TRAN_ID = ? GROUP BY GST_RATE, ITC_TYPE";

							detPstmt = conn.prepareStatement(detSql);
							detPstmt.setString(1, tranId);
							detRs = detPstmt.executeQuery();
							while(detRs.next())
							{
								gstRate = Double.parseDouble(String.format("%.2f",detRs.getDouble("GST_RATE")));
								taxableAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("TAXABLE_AMT")));
								igstAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("IGST_AMT")));
								cessAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("CESS_AMT")));
								itcType = checkNull(detRs.getString("ITC_TYPE"));
								igstITCAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("ITC_IGST")));
								cessITCAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("ITC_CESS")));
								
								if(itcTypeHMap.containsKey(itcType.toUpperCase()))
								{
									itcTypeDescr = itcTypeHMap.get(itcType.toUpperCase());
								}
								else
								{
									itcTypeDescr = "";
								}
								
								if(ctin.trim().length() > 0)
								{
									documentType = "Received from SEZ";
								}
								else
								{
									documentType = "Imports";
								}
								
								XSSFRow dataRow = dataSheet.createRow(impgRowNum++);

								dataRow.createCell(0).setCellValue(portCode);
								dataRow.createCell(1).setCellValue(shipBillNo);
								XSSFCell docDateCell = dataRow.createCell(2);
								if(shipBillDateStr!=null && shipBillDateStr.trim().length()>0)
								{
									docDateCell.setCellValue(gstDateFormatSdf.parse(shipBillDateStr));
									docDateCell.setCellStyle(dateCellStyle);
								}
								dataRow.createCell(3).setCellValue(amount);
								dataRow.createCell(4).setCellValue(documentType);
								dataRow.createCell(5).setCellValue(ctin);
								dataRow.createCell(6).setCellValue(gstRate);
								dataRow.createCell(7).setCellValue(taxableAmt);
								dataRow.createCell(8).setCellValue(igstAmt);
								dataRow.createCell(9).setCellValue(cessAmt);
								dataRow.createCell(10).setCellValue(itcTypeDescr);
								dataRow.createCell(11).setCellValue(igstITCAmt);
								dataRow.createCell(12).setCellValue(cessITCAmt);
							}
							closeResources(detRs, detPstmt);
						}
						if("CDN".equalsIgnoreCase(udfStr1))
						{
							Calendar calendar = Calendar.getInstance();
							calendar.set(2017, 06, 01);
							Date gstStartDate = calendar.getTime();
							
							if(refInvDate!=null)
							{
								preGST = refInvDate.before(gstStartDate) ? "Y" : "N";
							}
							else
							{
								preGST = "";
							}
							
							XSSFSheet dataSheet = retDataWorkbook.getSheet("cdnr");
							
							detSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(IGST_AMT) AS IGST_AMT, SUM(CGST_AMT) AS CGST_AMT, SUM(SGST_AMT) AS SGST_AMT, SUM(CESS_AMT) AS CESS_AMT,"
								   + " ITC_TYPE,SUM(ITC_IGST) AS ITC_IGST, SUM(ITC_CGST) AS ITC_CGST, SUM(ITC_SGST) AS ITC_SGST, SUM(ITC_CESS) AS ITC_CESS"
								   + " FROM GST_DATA_DET WHERE TRAN_ID = ? GROUP BY GST_RATE, ITC_TYPE";

							detPstmt = conn.prepareStatement(detSql);
							detPstmt.setString(1, tranId);
							detRs = detPstmt.executeQuery();
							while(detRs.next())
							{
								gstRate = Double.parseDouble(String.format("%.2f",detRs.getDouble("GST_RATE")));
								taxableAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("TAXABLE_AMT")));
								igstAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("IGST_AMT")));
								cgstAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("CGST_AMT")));
								sgstAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("SGST_AMT")));
								cessAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("CESS_AMT")));
								itcType = checkNull(detRs.getString("ITC_TYPE"));
								igstITCAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("ITC_IGST")));
								cgstITCAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("ITC_CGST")));
								sgstITCAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("ITC_SGST")));
								cessITCAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("ITC_CESS")));
								
								if(itcTypeHMap.containsKey(itcType.toUpperCase()))
								{
									itcTypeDescr = itcTypeHMap.get(itcType.toUpperCase());
								}
								else
								{
									itcTypeDescr = "";
								}
								
								if(placeOfBusiness.trim().equalsIgnoreCase(posStateCode.trim()))
								{
									supplyType = "Intra State";
								}
								else
								{
									supplyType = "Inter State";
								}
								
								XSSFRow dataRow = dataSheet.createRow(cdnrRowNum++);
								
								dataRow.createCell(0).setCellValue(ctin);
								dataRow.createCell(1).setCellValue(docNo);
								XSSFCell docDateCell = dataRow.createCell(2);
								if(docDateStr!=null && docDateStr.trim().length()>0)
								{
									docDateCell.setCellValue(gstDateFormatSdf.parse(docDateStr));
									docDateCell.setCellStyle(dateCellStyle);
								}
								dataRow.createCell(3).setCellValue(refInvId);
								XSSFCell refInvDateCell = dataRow.createCell(4);
								if(refInvDtStr!=null && refInvDtStr.trim().length()>0)
								{
									refInvDateCell.setCellValue(gstDateFormatSdf.parse(refInvDtStr));
									refInvDateCell.setCellStyle(dateCellStyle);
								}
								dataRow.createCell(5).setCellValue(preGST);
								dataRow.createCell(6).setCellValue(udfStr2);
								dataRow.createCell(7).setCellValue("07-Others");
								dataRow.createCell(8).setCellValue(supplyType);
								dataRow.createCell(9).setCellValue(amount);
								dataRow.createCell(10).setCellValue(gstRate);
								dataRow.createCell(11).setCellValue(taxableAmt);
								dataRow.createCell(12).setCellValue(igstAmt);
								dataRow.createCell(13).setCellValue(cgstAmt);
								dataRow.createCell(14).setCellValue(sgstAmt);
								dataRow.createCell(15).setCellValue(cessAmt);
								dataRow.createCell(16).setCellValue(itcTypeDescr);
								dataRow.createCell(17).setCellValue(igstITCAmt);
								dataRow.createCell(18).setCellValue(cgstITCAmt);
								dataRow.createCell(19).setCellValue(sgstITCAmt);
								dataRow.createCell(20).setCellValue(cessITCAmt);
							}
							closeResources(detRs, detPstmt);
						}
						if("CDNUR".equalsIgnoreCase(udfStr1))
						{
							Calendar calendar = Calendar.getInstance();
							calendar.set(2017, 06, 01);
							Date gstStartDate = calendar.getTime();
							
							if(refInvDate!=null)
							{
								preGST = refInvDate.before(gstStartDate) ? "Y" : "N";
							}
							else
							{
								preGST = "";
							}
							
							XSSFSheet dataSheet = retDataWorkbook.getSheet("cdnur");
							
							detSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(IGST_AMT) AS IGST_AMT, SUM(CGST_AMT) AS CGST_AMT, SUM(SGST_AMT) AS SGST_AMT, SUM(CESS_AMT) AS CESS_AMT,"
								   + " ITC_TYPE,SUM(ITC_IGST) AS ITC_IGST, SUM(ITC_CGST) AS ITC_CGST, SUM(ITC_SGST) AS ITC_SGST, SUM(ITC_CESS) AS ITC_CESS"
								   + " FROM GST_DATA_DET WHERE TRAN_ID = ? GROUP BY GST_RATE, ITC_TYPE";

							detPstmt = conn.prepareStatement(detSql);
							detPstmt.setString(1, tranId);
							detRs = detPstmt.executeQuery();
							while(detRs.next())
							{
								gstRate = Double.parseDouble(String.format("%.2f",detRs.getDouble("GST_RATE")));
								taxableAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("TAXABLE_AMT")));
								igstAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("IGST_AMT")));
								cgstAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("CGST_AMT")));
								sgstAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("SGST_AMT")));
								cessAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("CESS_AMT")));
								itcType = checkNull(detRs.getString("ITC_TYPE"));
								igstITCAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("ITC_IGST")));
								cgstITCAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("ITC_CGST")));
								sgstITCAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("ITC_SGST")));
								cessITCAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("ITC_CESS")));
								
								if(itcTypeHMap.containsKey(itcType.toUpperCase()))
								{
									itcTypeDescr = itcTypeHMap.get(itcType.toUpperCase());
								}
								else
								{
									itcTypeDescr = "";
								}
								
								if(placeOfBusiness.trim().equalsIgnoreCase(posStateCode.trim()))
								{
									supplyType = "Intra State";
								}
								else
								{
									supplyType = "Inter State";
								}
								
								XSSFRow dataRow = dataSheet.createRow(cdnrRowNum++);
								
								dataRow.createCell(0).setCellValue(docNo);
								XSSFCell docDateCell = dataRow.createCell(1);
								if(docDateStr!=null && docDateStr.trim().length()>0)
								{
									docDateCell.setCellValue(gstDateFormatSdf.parse(docDateStr));
									docDateCell.setCellStyle(dateCellStyle);
								}
								dataRow.createCell(2).setCellValue(refInvId);
								XSSFCell refInvDateCell = dataRow.createCell(3);
								if(refInvDtStr!=null && refInvDtStr.trim().length()>0)
								{
									refInvDateCell.setCellValue(gstDateFormatSdf.parse(refInvDtStr));
									refInvDateCell.setCellStyle(dateCellStyle);
								}
								dataRow.createCell(4).setCellValue(preGST);
								dataRow.createCell(5).setCellValue(udfStr2);
								dataRow.createCell(6).setCellValue("07-Others");
								dataRow.createCell(7).setCellValue(supplyType);
								dataRow.createCell(8).setCellValue(amount);
								dataRow.createCell(9).setCellValue(gstRate);
								dataRow.createCell(10).setCellValue(taxableAmt);
								dataRow.createCell(11).setCellValue(igstAmt);
								dataRow.createCell(12).setCellValue(cgstAmt);
								dataRow.createCell(13).setCellValue(sgstAmt);
								dataRow.createCell(14).setCellValue(cessAmt);
								dataRow.createCell(15).setCellValue(itcTypeDescr);
								dataRow.createCell(16).setCellValue(igstITCAmt);
								dataRow.createCell(17).setCellValue(cgstITCAmt);
								dataRow.createCell(18).setCellValue(sgstITCAmt);
								dataRow.createCell(19).setCellValue(cessITCAmt);
							}
							closeResources(detRs, detPstmt);
						}
						if("TXPI".equalsIgnoreCase(udfStr1))
						{
							XSSFSheet dataSheet = retDataWorkbook.getSheet("at");
							
							detSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(CESS_AMT) AS CESS_AMT FROM GST_DATA_DET WHERE TRAN_ID = ? GROUP BY GST_RATE";

							detPstmt = conn.prepareStatement(detSql);
							detPstmt.setString(1, tranId);
							detRs = detPstmt.executeQuery();
							while(detRs.next())
							{
								gstRate = Double.parseDouble(String.format("%.2f",detRs.getDouble("GST_RATE")));
								taxableAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("TAXABLE_AMT")));
								cessAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("CESS_AMT")));
								
								XSSFRow dataRow = dataSheet.createRow(atRowNum++);
								
								dataRow.createCell(0).setCellValue(posStateCode+"-"+stateDscr);
								dataRow.createCell(1).setCellValue(gstRate);
								dataRow.createCell(2).setCellValue(taxableAmt);
								dataRow.createCell(3).setCellValue(cessAmt);
							}
							closeResources(detRs, detPstmt);
						}
						if("TXPD".equalsIgnoreCase(udfStr1))
						{
							XSSFSheet dataSheet = retDataWorkbook.getSheet("atadj");
							
							detSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(CESS_AMT) AS CESS_AMT FROM GST_DATA_DET WHERE TRAN_ID = ? GROUP BY GST_RATE";

							detPstmt = conn.prepareStatement(detSql);
							detPstmt.setString(1, tranId);
							detRs = detPstmt.executeQuery();
							while(detRs.next())
							{
								gstRate = Double.parseDouble(String.format("%.2f",detRs.getDouble("GST_RATE")));
								taxableAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("TAXABLE_AMT")));
								cessAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("CESS_AMT")));
								
								XSSFRow dataRow = dataSheet.createRow(atAdjRowNum++);
								
								dataRow.createCell(0).setCellValue(posStateCode+"-"+stateDscr);
								dataRow.createCell(1).setCellValue(gstRate);
								dataRow.createCell(2).setCellValue(taxableAmt);
								dataRow.createCell(3).setCellValue(cessAmt);
							}
							closeResources(detRs, detPstmt);
						}
					}
					closeResources(hdrRs, hdrPstmt);
					
					XSSFSheet nilDataSheet = retDataWorkbook.getSheet("exemp");
					
					sql = " SELECT TRAN_TYPE,SUM(AMOUNT) AS AMOUNT FROM GST_DATA_HDR "
						+ " WHERE REC_TYPE = '2' AND TRAN_TYPE  in (?,?,?,?) AND SITE_CODE = ? AND PRD_CODE = ?"
						+ " GROUP BY TRAN_TYPE";
						
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, "18");
					pstmt.setString(2, "19");
					pstmt.setString(3, "20");
					pstmt.setString(4, "21");
					pstmt.setString(5, siteCode);
					pstmt.setString(6, periodCode);
					
					rs = pstmt.executeQuery();
					
					while(rs.next())
					{
						if("18".equalsIgnoreCase(rs.getString("TRAN_TYPE")))
						{
							compDlrAmount = Double.parseDouble(String.format("%.2f",rs.getDouble("AMOUNT")));
						}
						if("19".equalsIgnoreCase(rs.getString("TRAN_TYPE")))
						{
							exemtAmount = Double.parseDouble(String.format("%.2f",rs.getDouble("AMOUNT")));
						}
						if("20".equalsIgnoreCase(rs.getString("TRAN_TYPE")))
						{
							nonGSTAmount = Double.parseDouble(String.format("%.2f",rs.getDouble("AMOUNT")));
						}
						if("21".equalsIgnoreCase(rs.getString("TRAN_TYPE")))
						{
							nilAmount = Double.parseDouble(String.format("%.2f",rs.getDouble("AMOUNT")));
						}
					}
					closeResources(rs, pstmt);
					
					XSSFRow nilInterDataRow = nilDataSheet.getRow(4);
					
					nilInterDataRow.createCell(1).setCellValue(compDlrAmount);
					nilInterDataRow.createCell(2).setCellValue(nilAmount);
					nilInterDataRow.createCell(3).setCellValue(exemtAmount);
					nilInterDataRow.createCell(4).setCellValue(nonGSTAmount);
					
					compDlrAmount = 0.0; nilAmount = 0.0; exemtAmount = 0.0; nonGSTAmount = 0.0;
					
					sql = " SELECT TRAN_TYPE,SUM(AMOUNT) AS AMOUNT FROM GST_DATA_HDR "
						+ " WHERE REC_TYPE = '2' AND TRAN_TYPE  in (?,?,?,?) AND SITE_CODE = ? AND PRD_CODE = ?"
						+ " GROUP BY TRAN_TYPE";
						
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, "22");
					pstmt.setString(2, "23");
					pstmt.setString(3, "24");
					pstmt.setString(4, "25");
					pstmt.setString(5, siteCode);
					pstmt.setString(6, periodCode);
					
					rs = pstmt.executeQuery();
					
					while(rs.next())
					{
						if("22".equalsIgnoreCase(rs.getString("TRAN_TYPE")))
						{
							compDlrAmount = Double.parseDouble(String.format("%.2f",rs.getDouble("AMOUNT")));
						}
						if("23".equalsIgnoreCase(rs.getString("TRAN_TYPE")))
						{
							exemtAmount = Double.parseDouble(String.format("%.2f",rs.getDouble("AMOUNT")));
						}
						if("24".equalsIgnoreCase(rs.getString("TRAN_TYPE")))
						{
							nonGSTAmount = Double.parseDouble(String.format("%.2f",rs.getDouble("AMOUNT")));
						}
						if("25".equalsIgnoreCase(rs.getString("TRAN_TYPE")))
						{
							nilAmount = Double.parseDouble(String.format("%.2f",rs.getDouble("AMOUNT")));
						}
					}
					closeResources(rs, pstmt);
					
					XSSFRow nilIntraDataRow = nilDataSheet.getRow(5);
					
					nilIntraDataRow.createCell(1).setCellValue(compDlrAmount);
					nilIntraDataRow.createCell(2).setCellValue(nilAmount);
					nilIntraDataRow.createCell(3).setCellValue(exemtAmount);
					nilIntraDataRow.createCell(4).setCellValue(nonGSTAmount);
					
					XSSFSheet hsnDataSheet = retDataWorkbook.getSheet("hsnsum");
					
					sql = " SELECT GS_CODE, UNIT, DESCR, SUM(TOT_QTY) AS TOT_QTY, SUM(TOT_TAXVAL) AS TOT_TAXVAL, SUM(TOT_IAMT) AS TOT_IAMT, SUM(TOT_CAMT) AS TOT_CAMT, SUM(TOT_SAMT) AS TOT_SAMT, SUM(TOT_CSAMT) AS TOT_CSAMT FROM"
						+ " (SELECT GDD.GS_CODE, GDD.UNIT, U.DESCR, SUM(GDD.QUANTITY) AS TOT_QTY, SUM(GDD.TAXABLE_AMT) AS TOT_TAXVAL,"
						+ " SUM(GDD.IGST_AMT) AS TOT_IAMT, SUM(CGST_AMT) AS TOT_CAMT, SUM(SGST_AMT) AS TOT_SAMT, SUM(CESS_AMT) AS TOT_CSAMT"
						+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD, UOM U"
						+ " WHERE GDH.TRAN_ID = GDD.TRAN_ID AND GDD.GS_CODE IS NOT NULL AND GDH.REC_TYPE='2' AND GDD.UNIT=U.UNIT"
						+ " AND GDH.SITE_CODE = ? AND GDH.PRD_CODE = ? AND GDH.TRAN_TYPE NOT IN ('10','11','18','19','20','21','22','23','24','25')"
						+ " GROUP BY GDD.GS_CODE, GDD.UNIT, U.DESCR"
						+ " UNION ALL"
						+ " SELECT GDD.GS_CODE, GDD.UNIT,  U.DESCR, -1*SUM(GDD.QUANTITY) AS TOT_QTY, -1*SUM(GDD.TAXABLE_AMT) AS TOT_TAXVAL,"
						+ " -1*SUM(GDD.IGST_AMT) AS TOT_IAMT, -1*SUM(CGST_AMT) AS TOT_CAMT, -1*SUM(SGST_AMT) AS TOT_SAMT, -1*SUM(CESS_AMT) AS TOT_CSAMT"
						+ " FROM GST_DATA_HDR GDH, GST_DATA_DET GDD, UOM U"
						+ " WHERE GDH.TRAN_ID = GDD.TRAN_ID AND GDD.GS_CODE IS NOT NULL AND GDH.REC_TYPE='2'  AND GDD.UNIT=U.UNIT"
						+ " AND GDH.SITE_CODE = ? AND GDH.PRD_CODE = ? AND GDH.TRAN_TYPE  IN ('10','11')"
						+ " GROUP BY GDD.GS_CODE, GDD.UNIT, U.DESCR) GROUP BY GS_CODE, UNIT, DESCR";
					
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode);
					pstmt.setString(2, periodCode);
					pstmt.setString(3, siteCode);
					pstmt.setString(4, periodCode);
					rs = pstmt.executeQuery();
					
					while (rs.next()) 
					{
						XSSFRow dataRow = hsnDataSheet.createRow(hsnRowNum++);
						
						dataRow.createCell(0).setCellValue(checkNull(rs.getString("GS_CODE")));
						String unitDescr = checkNull(rs.getString("UNIT")) + "-" + checkNull(rs.getString("DESCR"));
						dataRow.createCell(2).setCellValue(unitDescr);
						dataRow.createCell(3).setCellValue(Double.parseDouble(String.format("%.2f",rs.getDouble("TOT_QTY"))));
						double totalValue = rs.getDouble("TOT_TAXVAL") + rs.getDouble("TOT_IAMT") + rs.getDouble("TOT_CAMT") + rs.getDouble("TOT_SAMT") + rs.getDouble("TOT_CSAMT");
						dataRow.createCell(4).setCellValue(Double.parseDouble(String.format("%.2f",totalValue)));
						dataRow.createCell(5).setCellValue(Double.parseDouble(String.format("%.2f",rs.getDouble("TOT_TAXVAL"))));
						dataRow.createCell(6).setCellValue(Double.parseDouble(String.format("%.2f",rs.getDouble("TOT_IAMT"))));
						dataRow.createCell(7).setCellValue(Double.parseDouble(String.format("%.2f",rs.getDouble("TOT_CAMT"))));
						dataRow.createCell(8).setCellValue(Double.parseDouble(String.format("%.2f",rs.getDouble("TOT_SAMT"))));
						dataRow.createCell(9).setCellValue(Double.parseDouble(String.format("%.2f",rs.getDouble("TOT_CSAMT"))));
					}
					closeResources(rs, pstmt);
					
                    //Added By PriyankaC to add GSTR-2 invalidData in shit.
					
					boolean isGSNullSheetAdded = false, isUnitNullSheetAdded = false, isPortNullSheetAdded = false;
					XSSFSheet hsnBlnkDataSheet = null, unitBlnkDataSheet = null, portBlnkDataSheet = null;
					int rowNo = 1;
					
					sql = " SELECT H.REF_ID, H.REF_SER, D.TAXABLE_AMT FROM GST_DATA_HDR H, GST_DATA_DET D WHERE H.TRAN_ID = D.TRAN_ID AND H.SITE_CODE = ? AND H.PRD_CODE = ? AND H.REC_TYPE = ? "
						+ " AND D.GS_CODE IS NULL ";
					
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode);
					pstmt.setString(2, periodCode);
					pstmt.setString(3, "2");
					
					rs = pstmt.executeQuery();
					
					while(rs.next())
					{
						if(!isGSNullSheetAdded)
						{
							retDataWorkbook.createSheet("HSN BLANK");
							isGSNullSheetAdded = true;
							
							hsnBlnkDataSheet = retDataWorkbook.getSheet("HSN BLANK");
							XSSFRow hdrRow = hsnBlnkDataSheet.createRow(0);
							hdrRow.createCell(0).setCellValue("REF_ID");
							hdrRow.createCell(1).setCellValue("REF_SER");
							hdrRow.createCell(2).setCellValue("TAXABLE_AMT");
						}
						
						XSSFRow dataRow = hsnBlnkDataSheet.createRow(rowNo++);
						dataRow.createCell(0).setCellValue(rs.getString("REF_ID"));
						dataRow.createCell(1).setCellValue(rs.getString("REF_SER"));
						dataRow.createCell(2).setCellValue(rs.getString("TAXABLE_AMT"));
					}
					
					closeResources(rs, pstmt);
					
					rowNo = 1;
					
					sql = " SELECT H.REF_ID, H.REF_SER, D.GS_CODE, D.TAXABLE_AMT, D.UNIT FROM GST_DATA_HDR H, GST_DATA_DET D WHERE H.TRAN_ID = D.TRAN_ID AND H.SITE_CODE = ? AND H.PRD_CODE = ? AND H.REC_TYPE = ? "
						+ " AND D.UNIT NOT IN (SELECT DISTINCT UNIT FROM UOM) ";
					
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode);
					pstmt.setString(2, periodCode);
					pstmt.setString(3, "2");
					
					rs = pstmt.executeQuery();
					
					while(rs.next())
					{
						if(!isUnitNullSheetAdded)
						{
							retDataWorkbook.createSheet("UOM INVALID-BLANK");
							isUnitNullSheetAdded = true;
							
							unitBlnkDataSheet = retDataWorkbook.getSheet("UOM INVALID-BLANK");
							XSSFRow hdrRow = unitBlnkDataSheet.createRow(0);
							hdrRow.createCell(0).setCellValue("REF_ID");
							hdrRow.createCell(1).setCellValue("REF_SER");
							hdrRow.createCell(2).setCellValue("HSN/SAC");
							hdrRow.createCell(3).setCellValue("TAXABLE_AMT");
							hdrRow.createCell(4).setCellValue("UNIT");
						}
						
						XSSFRow dataRow = unitBlnkDataSheet.createRow(rowNo++);
						dataRow.createCell(0).setCellValue(rs.getString("REF_ID"));
						dataRow.createCell(1).setCellValue(rs.getString("REF_SER"));
						dataRow.createCell(2).setCellValue(rs.getString("GS_CODE"));
						dataRow.createCell(3).setCellValue(rs.getString("TAXABLE_AMT"));
						dataRow.createCell(4).setCellValue(rs.getString("UNIT"));
					}
					
					closeResources(rs, pstmt);
					
					rowNo = 1;  
					
					sql = " SELECT H.REF_ID, H.REF_SER, H.AMOUNT FROM GST_DATA_HDR H, GST_DATA_DET D WHERE H.TRAN_ID = D.TRAN_ID AND H.SITE_CODE = ? AND H.PRD_CODE = ? AND H.REC_TYPE = ? AND H.TRAN_TYPE IN ('08') "
						+ " AND H.ORDER_NO IS NULL ";
					
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, siteCode);
					pstmt.setString(2, periodCode);
					pstmt.setString(3, "2");
					
					rs = pstmt.executeQuery();
					
					while(rs.next())
					{
						if(!isPortNullSheetAdded)
						{
							retDataWorkbook.createSheet("PORT CODE BLANK");
							isPortNullSheetAdded = true;
							
							portBlnkDataSheet = retDataWorkbook.getSheet("PORT CODE BLANK");
							XSSFRow hdrRow = portBlnkDataSheet.createRow(0);
							hdrRow.createCell(0).setCellValue("REF_ID");
							hdrRow.createCell(1).setCellValue("REF_SER");
							hdrRow.createCell(2).setCellValue("AMOUNT");
						}
						
						XSSFRow dataRow = portBlnkDataSheet.createRow(rowNo++);
						dataRow.createCell(0).setCellValue(rs.getString("REF_ID"));
						dataRow.createCell(1).setCellValue(rs.getString("REF_SER"));
						dataRow.createCell(2).setCellValue(rs.getString("AMOUNT"));
					}
					
					closeResources(rs, pstmt);
					
					//END PriyankaC on 24JAN18.
					
				}
				
				return retDataWorkbook;
			}
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizEJB.generateOfflineFile()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt=null;
				}
				if(rs!=null)
				{
					rs.close();
					rs=null;
				}
				if(hdrPstmt!=null)
				{
					hdrPstmt.close();
					hdrPstmt = null;
				}
				if(hdrRs!=null)
				{
					hdrRs.close();
					hdrRs=null;
				}
				if(detPstmt!=null)
				{
					detPstmt.close();
					detPstmt = null;
				}
				if(detRs!=null)
				{
					detRs.close();
					detRs=null;
				}
				if(conn!=null && !conn.isClosed())
				{
					conn.close();
					conn=null;
				}
			}
			catch(SQLException se)
			{
				System.out.println("GSTDataSubmitWizEJB.generateOfflineFile()["+se.getMessage()+"]");
				se.printStackTrace();
			}
			
		}
	}
	public Object generateCustomOfflineFile(String periodCode, String siteCode) throws ITMException
	{
		XSSFWorkbook retDataWorkbook = null;
		String gstrWorkBookPath = "";
		String sep = File.separator;
		
		String tranId = "", ctin = "", posStateCode = "", docNo = "", docDateStr = "",errorCode = "", dataErrMsg = "", refInvId = "", 
			   refInvDtStr = "", preGST = "", portCode = "", gstDateFormat = "", customerName = "", regUreg = "UNREGISTERED", 
			   siteGSTStCode = "", isRCM = "", tranTypeStr = "", interIntraExp = "", suppGSTStCode = "", crdrType = "";
		
		boolean noDataFound = false;
		double amount =0.0, gstRate = 0.0, taxableAmt = 0.0, cessAmt = 0.0;
		int outWrdSuppdataRow = 2, inWrdSuppdataRow = 2, crdrPaydataRow = 2, crdrRecdataRow = 2;
		double igstAmt = 0.0, cgstAmt = 0.0, sgstAmt = 0.0; 
		
		HashMap<String,String> stateCodeHMap = new HashMap<String, String>();
		
		
		String sql = "", hdrSql = "", detSql = "";
		Date refInvDate = null , docDate = null;
		Connection conn = null;
		PreparedStatement pstmt = null, hdrPstmt = null, detPstmt = null;
		ResultSet rs = null, hdrRs = null, detRs = null;
		FinCommon finCommon = new FinCommon();
		try
		{
			Calendar calendar = Calendar.getInstance();
			calendar.set(2017, 06, 01);
			Date gstStartDate = calendar.getTime();

			conn = getConnection();
			
			sql = "SELECT COUNT(1) AS CNT FROM GST_DATA_HDR WHERE SUBMIT_STATUS = 'P' AND PRD_CODE = ? AND SITE_CODE = ? AND REC_TYPE IN ('1','2')";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, periodCode);
			pstmt.setString(2, siteCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				if(rs.getInt("CNT") == 0)
				{
					noDataFound = true;
					errorCode =  "VTNOGSDATA";
				}
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt=null;
			}
			if(rs!=null)
			{
				rs.close();
				rs=null;
			}
			
			if(noDataFound)
			{
				sql = "SELECT MSG_DESCR FROM MESSAGES WHERE MSG_NO = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, errorCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					dataErrMsg = rs.getString("MSG_DESCR");
				}
				closeResources(rs, pstmt);
				
				return "<root><message><![CDATA[Message : "+dataErrMsg+"]]></message></root>";
			}
			else
			{
				
				gstrWorkBookPath = CommonConstants.JBOSSHOME + sep + "DOWNLOAD" + sep + "template" + sep + "GSTR_Custom_Format.xlsx";
				File gstrExcleFile = new File(gstrWorkBookPath);

				if(gstrExcleFile.exists())
				{
					retDataWorkbook = new XSSFWorkbook(new FileInputStream(gstrExcleFile));
				}
				
				gstDateFormat = finCommon.getFinparams("999999", "GST_EXCL_DATE_FORMAT", conn);
				
				CellStyle dateCellStyle = retDataWorkbook.createCellStyle();
				CreationHelper createHelper = retDataWorkbook.getCreationHelper();
				dateCellStyle.setDataFormat( createHelper.createDataFormat().getFormat(gstDateFormat));
				
				SimpleDateFormat gstDateFormatSdf = new SimpleDateFormat(gstDateFormat);
				
				sql = " SELECT GST_CODE, DESCR FROM STATE WHERE GST_CODE IS NOT NULL ";
				pstmt = conn.prepareStatement(sql);

				rs = pstmt.executeQuery();

				while(rs.next())
				{
					String gstStCode = checkNull(rs.getString("GST_CODE"));
					String stateDscr = checkNull(rs.getString("DESCR"));
					
					stateCodeHMap.put(gstStCode, stateDscr);
				}
				closeResources(rs, pstmt);
				
				sql = " SELECT SUBSTR(REG_NO,0,2) AS GST_CODE FROM SITEREGNO WHERE SITE_CODE = ? AND REF_CODE = 'GSTIN_NO' ";
				
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, siteCode);

				rs = pstmt.executeQuery();

				if(rs.next())
				{
					siteGSTStCode = checkNull(rs.getString("GST_CODE"));
				}
				closeResources(rs, pstmt);
				
				hdrSql = " SELECT GDH.TRAN_ID, GDH.DOC_NO, GDH.DOC_DATE, GDH.CUST_NAME, CASE WHEN GDH.TRAN_TYPE='02' THEN 'YES' ELSE 'NO' END AS RCM, " 
					   + " GEN.UDF_STR1, GDH.TAX_REG_NO, GDH.GST_CODE, GDH.AMOUNT, GDH.ORDER_NO  FROM GST_DATA_HDR GDH, GENCODES GEN " 
					   + " WHERE GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.SUBMIT_STATUS = ? " 
					   + " AND GDH.TRAN_TYPE NOT IN ('29','30','31','32','33','34','35','36') AND GEN.MOD_NAME='W_GSTR' AND GEN.FLD_NAME='TRAN_TYPE' "
					   + " AND GDH.TRAN_TYPE=GEN.FLD_VALUE ORDER BY GDH.TRAN_TYPE,GDH.DOC_DATE,GDH.DOC_NO ";
				
				hdrPstmt = conn.prepareStatement(hdrSql);
				hdrPstmt.setString(1, "1");
				hdrPstmt.setString(2, periodCode);
				hdrPstmt.setString(3, siteCode);
				hdrPstmt.setString(4, "P");

				hdrRs = hdrPstmt.executeQuery();
				
				XSSFSheet outWrdSuppdataSheet = retDataWorkbook.getSheet("Outward_Sale_N_Transfer");
				
				while(hdrRs.next())
				{
					tranId = hdrRs.getString("TRAN_ID");
					docNo = checkNull(hdrRs.getString("DOC_NO"));
					docDate = hdrRs.getDate("DOC_DATE");
					customerName = checkNull(hdrRs.getString("CUST_NAME"));
					isRCM = checkNull(hdrRs.getString("RCM"));
					tranTypeStr = checkNull(hdrRs.getString("UDF_STR1"));
					ctin = checkNull(hdrRs.getString("TAX_REG_NO"));
					posStateCode = checkNull(hdrRs.getString("GST_CODE"));
					amount = Double.parseDouble(String.format("%.2f",hdrRs.getDouble("AMOUNT")));
					portCode = checkNull(hdrRs.getString("ORDER_NO"));
					
					if(docDate!=null)
					{
						docDateStr = gstDateFormatSdf.format(docDate);
					}
							
					if("EXP".equalsIgnoreCase(tranTypeStr))
					{
						interIntraExp = "Export";
					}
					else
					{
						if(siteGSTStCode.equalsIgnoreCase(posStateCode))
						{
							interIntraExp = "IntraState";
						}
						else
						{
							interIntraExp = "InterState";
						}
					}
					
					detSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(IGST_AMT) AS IGST_AMT, SUM(CGST_AMT) AS CGST_AMT, SUM(SGST_AMT) AS SGST_AMT, SUM(CESS_AMT) AS CESS_AMT "
						   + " FROM GST_DATA_DET WHERE TRAN_ID = ? GROUP BY GST_RATE ";

					detPstmt = conn.prepareStatement(detSql);
					detPstmt.setString(1, tranId);
					detRs = detPstmt.executeQuery();
					while(detRs.next())
					{
						gstRate = Double.parseDouble(String.format("%.2f",detRs.getDouble("GST_RATE")));
						taxableAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("TAXABLE_AMT")));
						igstAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("IGST_AMT")));
						cgstAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("CGST_AMT")));
						sgstAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("SGST_AMT")));
						cessAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("CESS_AMT")));
						double totTaxAmt = igstAmt + cgstAmt + sgstAmt + cessAmt;
						totTaxAmt = Double.parseDouble(String.format("%.2f",totTaxAmt));
						
						XSSFRow dataRow = outWrdSuppdataSheet.createRow(outWrdSuppdataRow++);
						
						dataRow.createCell(0).setCellValue(docNo);
						XSSFCell docDateCell = dataRow.createCell(1);
						if(docDateStr!=null && docDateStr.trim().length()>0)
						{
							docDateCell.setCellValue(gstDateFormatSdf.parse(docDateStr));
							docDateCell.setCellStyle(dateCellStyle);
						}
						dataRow.createCell(2).setCellValue(customerName);
						dataRow.createCell(3).setCellValue(interIntraExp);
						dataRow.createCell(4).setCellValue(isRCM);
						dataRow.createCell(5).setCellValue(tranTypeStr);
						dataRow.createCell(6).setCellValue(ctin);
						dataRow.createCell(7).setCellValue(posStateCode+"-"+checkNull(stateCodeHMap.get(posStateCode)));
						dataRow.createCell(8).setCellValue(amount);
						dataRow.createCell(9).setCellValue(taxableAmt);
						dataRow.createCell(10).setCellValue(gstRate);
						dataRow.createCell(11).setCellValue(igstAmt);
						dataRow.createCell(12).setCellValue(cgstAmt);
						dataRow.createCell(13).setCellValue(sgstAmt);
						dataRow.createCell(14).setCellValue(cessAmt);
						dataRow.createCell(15).setCellValue(totTaxAmt);
						dataRow.createCell(16).setCellValue(portCode);
					}
					closeResources(detRs, detPstmt);
				}
				
				closeResources(hdrRs, hdrPstmt);
				
				hdrSql = " SELECT GDH.TRAN_ID, GDH.DOC_NO, GDH.DOC_DATE, GDH.CUST_NAME, CASE WHEN GDH.TRAN_TYPE='05' THEN 'YES' ELSE 'NO' END AS RCM, " 
					   + " GEN.UDF_STR1, GDH.TAX_REG_NO, GDH.GST_CODE, GDH.AMOUNT, GDH.ORDER_NO  FROM GST_DATA_HDR GDH, GENCODES GEN " 
					   + " WHERE GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.SUBMIT_STATUS = ? " 
					   + " AND GDH.TRAN_TYPE NOT IN ('10','11','12','13') AND GEN.MOD_NAME='W_GSTR_PURC' AND GEN.FLD_NAME='TRAN_TYPE' "
					   + " AND GDH.TRAN_TYPE=GEN.FLD_VALUE ORDER BY GDH.TRAN_TYPE,GDH.DOC_DATE,GDH.DOC_NO ";
				
				hdrPstmt = conn.prepareStatement(hdrSql);
				hdrPstmt.setString(1, "2");
				hdrPstmt.setString(2, periodCode);
				hdrPstmt.setString(3, siteCode);
				hdrPstmt.setString(4, "P");

				hdrRs = hdrPstmt.executeQuery();
				
				XSSFSheet inWrdSuppdataSheet = retDataWorkbook.getSheet("Inward_Purchase_N_Transfer");
				
				while(hdrRs.next())
				{
					tranId = hdrRs.getString("TRAN_ID");
					docNo = checkNull(hdrRs.getString("DOC_NO"));
					docDate = hdrRs.getDate("DOC_DATE");
					customerName = checkNull(hdrRs.getString("CUST_NAME"));
					isRCM = checkNull(hdrRs.getString("RCM"));
					tranTypeStr = checkNull(hdrRs.getString("UDF_STR1"));
					ctin = checkNull(hdrRs.getString("TAX_REG_NO"));
					posStateCode = checkNull(hdrRs.getString("GST_CODE"));
					amount = Double.parseDouble(String.format("%.2f",hdrRs.getDouble("AMOUNT")));
					portCode = checkNull(hdrRs.getString("ORDER_NO"));
					
					if(docDate!=null)
					{
						docDateStr = gstDateFormatSdf.format(docDate);
					}
					
					if(ctin.trim().length() > 2)
					{
						suppGSTStCode = ctin.substring(0, 2); 
					}
					
					if("IMP_G".equalsIgnoreCase(tranTypeStr))
					{
						interIntraExp = "Import";
					}
					else
					{
						if(suppGSTStCode.equalsIgnoreCase(posStateCode))
						{
							interIntraExp = "IntraState";
						}
						else
						{
							interIntraExp = "InterState";
						}
					}
					
					detSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(IGST_AMT) AS IGST_AMT, SUM(CGST_AMT) AS CGST_AMT, SUM(SGST_AMT) AS SGST_AMT, SUM(CESS_AMT) AS CESS_AMT "
						   + " FROM GST_DATA_DET WHERE TRAN_ID = ? GROUP BY GST_RATE ";

					detPstmt = conn.prepareStatement(detSql);
					detPstmt.setString(1, tranId);
					detRs = detPstmt.executeQuery();
					while(detRs.next())
					{
						gstRate = Double.parseDouble(String.format("%.2f",detRs.getDouble("GST_RATE")));
						taxableAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("TAXABLE_AMT")));
						igstAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("IGST_AMT")));
						cgstAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("CGST_AMT")));
						sgstAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("SGST_AMT")));
						cessAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("CESS_AMT")));
						double totTaxAmt = igstAmt + cgstAmt + sgstAmt + cessAmt;
						totTaxAmt = Double.parseDouble(String.format("%.2f",totTaxAmt));
						
						XSSFRow dataRow = inWrdSuppdataSheet.createRow(inWrdSuppdataRow++);
						
						dataRow.createCell(0).setCellValue(docNo);
						XSSFCell docDateCell = dataRow.createCell(1);
						if(docDateStr!=null && docDateStr.trim().length()>0)
						{
							docDateCell.setCellValue(gstDateFormatSdf.parse(docDateStr));
							docDateCell.setCellStyle(dateCellStyle);
						}
						dataRow.createCell(2).setCellValue(customerName);
						dataRow.createCell(3).setCellValue(interIntraExp);
						dataRow.createCell(4).setCellValue(isRCM);
						dataRow.createCell(5).setCellValue(tranTypeStr);
						dataRow.createCell(6).setCellValue(ctin);
						dataRow.createCell(7).setCellValue(posStateCode+"-"+checkNull(stateCodeHMap.get(posStateCode)));
						dataRow.createCell(8).setCellValue(""); //TODO need to check with devendra sir
						dataRow.createCell(9).setCellValue(""); //TODO need to check with devendra sir
						dataRow.createCell(10).setCellValue(amount);
						dataRow.createCell(11).setCellValue(taxableAmt);
						dataRow.createCell(12).setCellValue(gstRate);
						dataRow.createCell(13).setCellValue(igstAmt);
						dataRow.createCell(14).setCellValue(cgstAmt);
						dataRow.createCell(15).setCellValue(sgstAmt);
						dataRow.createCell(16).setCellValue(cessAmt);
						dataRow.createCell(17).setCellValue(totTaxAmt);
						dataRow.createCell(18).setCellValue(portCode);
					}
					closeResources(detRs, detPstmt);
				}
				
				closeResources(hdrRs, hdrPstmt);
				
				hdrSql = " SELECT GDH.TRAN_ID, GDH.DOC_NO, GDH.DOC_DATE, GDH.CUST_NAME, GEN.UDF_STR1, GEN.UDF_STR2, GDH.TAX_REG_NO, "
					   + " GDH.GST_CODE, GDH.REF_ID__INV, GDH.REF_DATE__INV, GDH.AMOUNT  FROM GST_DATA_HDR GDH, GENCODES GEN "
					   + " WHERE GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.SUBMIT_STATUS = ? "
					   + " AND GDH.TRAN_TYPE IN ('29','30','31','32','33','34','35','36') AND GEN.MOD_NAME='W_GSTR' AND GEN.FLD_NAME='TRAN_TYPE' "
					   + " AND GDH.TRAN_TYPE=GEN.FLD_VALUE ORDER BY GDH.TRAN_TYPE,GDH.DOC_DATE,GDH.DOC_NO";
				
				hdrPstmt = conn.prepareStatement(hdrSql);
				hdrPstmt.setString(1, "1");
				hdrPstmt.setString(2, periodCode);
				hdrPstmt.setString(3, siteCode);
				hdrPstmt.setString(4, "P");

				hdrRs = hdrPstmt.executeQuery();
				
				XSSFSheet crdrRecdataSheet = retDataWorkbook.getSheet("Credit_Debit_Note_Receivable");
				
				while(hdrRs.next())
				{
					tranId = hdrRs.getString("TRAN_ID");
					docNo = checkNull(hdrRs.getString("DOC_NO"));
					docDate = hdrRs.getDate("DOC_DATE");
					customerName = checkNull(hdrRs.getString("CUST_NAME"));
					tranTypeStr = checkNull(hdrRs.getString("UDF_STR1"));
					crdrType = checkNull(hdrRs.getString("UDF_STR2"));
					ctin = checkNull(hdrRs.getString("TAX_REG_NO"));
					posStateCode = checkNull(hdrRs.getString("GST_CODE"));
					refInvId = checkNull(hdrRs.getString("REF_ID__INV"));
					refInvDate = hdrRs.getDate("REF_DATE__INV");
					amount = Double.parseDouble(String.format("%.2f",hdrRs.getDouble("AMOUNT")));
					
					if(docDate!=null)
					{
						docDateStr = gstDateFormatSdf.format(docDate);
					}
					if(ctin.trim().length() > 0)
					{
						regUreg = "REGISTERED"; 
					}
					if(refInvDate!=null)
					{
						refInvDtStr = gstDateFormatSdf.format(refInvDate);
						preGST = refInvDate.before(gstStartDate) ? "Y" : "N";
					}
					else
					{
						refInvDtStr = "";
						preGST = "";
					}
					
					detSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(IGST_AMT) AS IGST_AMT, SUM(CGST_AMT) AS CGST_AMT, SUM(SGST_AMT) AS SGST_AMT, SUM(CESS_AMT) AS CESS_AMT "
						   + " FROM GST_DATA_DET WHERE TRAN_ID = ? GROUP BY GST_RATE ";

					detPstmt = conn.prepareStatement(detSql);
					detPstmt.setString(1, tranId);
					detRs = detPstmt.executeQuery();
					while(detRs.next())
					{
						taxableAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("TAXABLE_AMT")));
						gstRate = Double.parseDouble(String.format("%.2f",detRs.getDouble("GST_RATE")));
						igstAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("IGST_AMT")));
						cgstAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("CGST_AMT")));
						sgstAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("SGST_AMT")));
						cessAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("CESS_AMT")));
						double totTaxAmt = igstAmt + cgstAmt + sgstAmt + cessAmt;
						totTaxAmt = Double.parseDouble(String.format("%.2f",totTaxAmt));
						
						XSSFRow dataRow = crdrRecdataSheet.createRow(crdrRecdataRow++);
						
						dataRow.createCell(0).setCellValue(docNo);
						XSSFCell docDateCell = dataRow.createCell(1);
						if(docDateStr!=null && docDateStr.trim().length()>0)
						{
							docDateCell.setCellValue(gstDateFormatSdf.parse(docDateStr));
							docDateCell.setCellStyle(dateCellStyle);
						}
						dataRow.createCell(2).setCellValue(customerName);
						dataRow.createCell(3).setCellValue("");//TODO need to check with devendra sir
						dataRow.createCell(4).setCellValue(crdrType);
						dataRow.createCell(5).setCellValue(regUreg);
						dataRow.createCell(6).setCellValue(ctin);
						dataRow.createCell(7).setCellValue(posStateCode+"-"+checkNull(stateCodeHMap.get(posStateCode)));
						dataRow.createCell(8).setCellValue(refInvId);
						XSSFCell refInvDateCell = dataRow.createCell(9);
						if(refInvDtStr!=null && refInvDtStr.trim().length()>0)
						{
							refInvDateCell.setCellValue(gstDateFormatSdf.parse(refInvDtStr));
							refInvDateCell.setCellStyle(dateCellStyle);
						}
						dataRow.createCell(10).setCellValue("Others");
						dataRow.createCell(11).setCellValue(amount);
						dataRow.createCell(12).setCellValue(gstRate);
						dataRow.createCell(13).setCellValue(taxableAmt);
						dataRow.createCell(14).setCellValue(igstAmt);
						dataRow.createCell(15).setCellValue(cgstAmt);
						dataRow.createCell(16).setCellValue(sgstAmt);
						dataRow.createCell(17).setCellValue(cessAmt);
						dataRow.createCell(18).setCellValue(totTaxAmt);
						dataRow.createCell(19).setCellValue(preGST);
					}
					closeResources(detRs, detPstmt);
				}
				
				closeResources(hdrRs, hdrPstmt);
				
				hdrSql = " SELECT GDH.TRAN_ID, GDH.DOC_NO, GDH.DOC_DATE, GDH.CUST_NAME, GEN.UDF_STR1, GEN.UDF_STR2, GDH.TAX_REG_NO, "
					   + " GDH.GST_CODE, GDH.REF_ID__INV, GDH.REF_DATE__INV, GDH.AMOUNT  FROM GST_DATA_HDR GDH, GENCODES GEN "
					   + " WHERE GDH.REC_TYPE = ? AND GDH.PRD_CODE = ? AND GDH.SITE_CODE = ? AND GDH.SUBMIT_STATUS = ? "
					   + " AND GDH.TRAN_TYPE IN ('10','11','12','13') AND GEN.MOD_NAME='W_GSTR_PURC' AND GEN.FLD_NAME='TRAN_TYPE' "
					   + " AND GDH.TRAN_TYPE=GEN.FLD_VALUE ORDER BY GDH.TRAN_TYPE,GDH.DOC_DATE,GDH.DOC_NO";
				
				hdrPstmt = conn.prepareStatement(hdrSql);
				hdrPstmt.setString(1, "2");
				hdrPstmt.setString(2, periodCode);
				hdrPstmt.setString(3, siteCode);
				hdrPstmt.setString(4, "P");

				hdrRs = hdrPstmt.executeQuery();
				
				XSSFSheet crdrPaydataSheet = retDataWorkbook.getSheet("Credit_Debit_Note_Payable");
				
				while(hdrRs.next())
				{
					tranId = hdrRs.getString("TRAN_ID");
					docNo = checkNull(hdrRs.getString("DOC_NO"));
					docDate = hdrRs.getDate("DOC_DATE");
					customerName = checkNull(hdrRs.getString("CUST_NAME"));
					tranTypeStr = checkNull(hdrRs.getString("UDF_STR1"));
					crdrType = checkNull(hdrRs.getString("UDF_STR2"));
					ctin = checkNull(hdrRs.getString("TAX_REG_NO"));
					posStateCode = checkNull(hdrRs.getString("GST_CODE"));
					refInvId = checkNull(hdrRs.getString("REF_ID__INV"));
					refInvDate = hdrRs.getDate("REF_DATE__INV");
					amount = Double.parseDouble(String.format("%.2f",hdrRs.getDouble("AMOUNT")));
					
					if(docDate!=null)
					{
						docDateStr = gstDateFormatSdf.format(docDate);
					}
					if(ctin.trim().length() > 0)
					{
						regUreg = "REGISTERED"; 
					}
					
					if(refInvDate!=null)
					{
						refInvDtStr = gstDateFormatSdf.format(refInvDate);
						preGST = refInvDate.before(gstStartDate) ? "Y" : "N";
					}
					else
					{
						refInvDtStr = "";
						preGST = "";
					}
					
					detSql = " SELECT GST_RATE, SUM(TAXABLE_AMT) AS TAXABLE_AMT, SUM(IGST_AMT) AS IGST_AMT, SUM(CGST_AMT) AS CGST_AMT, SUM(SGST_AMT) AS SGST_AMT, SUM(CESS_AMT) AS CESS_AMT "
						   + " FROM GST_DATA_DET WHERE TRAN_ID = ? GROUP BY GST_RATE ";

					detPstmt = conn.prepareStatement(detSql);
					detPstmt.setString(1, tranId);
					detRs = detPstmt.executeQuery();
					while(detRs.next())
					{
						taxableAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("TAXABLE_AMT")));
						gstRate = Double.parseDouble(String.format("%.2f",detRs.getDouble("GST_RATE")));
						igstAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("IGST_AMT")));
						cgstAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("CGST_AMT")));
						sgstAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("SGST_AMT")));
						cessAmt = Double.parseDouble(String.format("%.2f",detRs.getDouble("CESS_AMT")));
						double totTaxAmt = igstAmt + cgstAmt + sgstAmt + cessAmt;
						totTaxAmt = Double.parseDouble(String.format("%.2f",totTaxAmt));
						
						XSSFRow dataRow = crdrPaydataSheet.createRow(crdrPaydataRow++);
						
						dataRow.createCell(0).setCellValue(docNo);
						XSSFCell docDateCell = dataRow.createCell(1);
						if(docDateStr!=null && docDateStr.trim().length()>0)
						{
							docDateCell.setCellValue(gstDateFormatSdf.parse(docDateStr));
							docDateCell.setCellStyle(dateCellStyle);
						}
						dataRow.createCell(2).setCellValue(customerName);
						dataRow.createCell(3).setCellValue("");//TODO need to check with devendra sir
						dataRow.createCell(4).setCellValue(crdrType);
						dataRow.createCell(5).setCellValue(regUreg);
						dataRow.createCell(6).setCellValue(ctin);
						dataRow.createCell(7).setCellValue(posStateCode+"-"+checkNull(stateCodeHMap.get(posStateCode)));
						dataRow.createCell(8).setCellValue(refInvId);
						XSSFCell refInvDateCell = dataRow.createCell(9);
						if(refInvDtStr!=null && refInvDtStr.trim().length()>0)
						{
							refInvDateCell.setCellValue(gstDateFormatSdf.parse(refInvDtStr));
							refInvDateCell.setCellStyle(dateCellStyle);
						}
						dataRow.createCell(10).setCellValue("Others");
						dataRow.createCell(11).setCellValue(amount);
						dataRow.createCell(12).setCellValue(gstRate);
						dataRow.createCell(13).setCellValue(taxableAmt);
						dataRow.createCell(14).setCellValue(igstAmt);
						dataRow.createCell(15).setCellValue(cgstAmt);
						dataRow.createCell(16).setCellValue(sgstAmt);
						dataRow.createCell(17).setCellValue(cessAmt);
						dataRow.createCell(18).setCellValue(totTaxAmt);
						dataRow.createCell(19).setCellValue(preGST);
					}
					closeResources(detRs, detPstmt);
				}
				
				closeResources(hdrRs, hdrPstmt);
				
				return retDataWorkbook;
			}
		}
		catch(Exception e)
		{
			System.out.println("GSTDataSubmitWizEJB.generateCustomOfflineFile()["+e.getMessage()+"]");
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(pstmt!=null)
				{
					pstmt.close();
					pstmt=null;
				}
				if(rs!=null)
				{
					rs.close();
					rs=null;
				}
				if(hdrPstmt!=null)
				{
					hdrPstmt.close();
					hdrPstmt = null;
				}
				if(hdrRs!=null)
				{
					hdrRs.close();
					hdrRs=null;
				}
				if(detPstmt!=null)
				{
					detPstmt.close();
					detPstmt = null;
				}
				if(detRs!=null)
				{
					detRs.close();
					detRs=null;
				}
				if(conn!=null && !conn.isClosed())
				{
					conn.close();
					conn=null;
				}
			}
			catch(SQLException se)
			{
				System.out.println("GSTDataSubmitWizEJB.generateOfflineFile()["+se.getMessage()+"]");
				se.printStackTrace();
			}
			
		}
	}
	private String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
	private String errorType( Connection conn , String errorCode )
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ? ";
			
			pstmt = conn.prepareStatement( sql );			
			pstmt.setString(1, errorCode);			
			rs = pstmt.executeQuery();
			if( rs.next() )
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch (Exception ex)
		{
			System.out.println("GSTDataSubmitWizEJB.errorType()["+ex.getMessage()+"]");
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}
	private String getError(String errMsg, String Code, Connection conn)  throws ITMException, Exception
	{
		String mainStr ="";

		try
		{
			String errString = "";
			errString =  new ITMDBAccessEJB().getErrorString("",Code,"","",conn);
			
			String begPart = errString.substring(0,errString.indexOf("</description>"));
			String endDesc = errString.substring(errString.indexOf("</description>"),errString.length());
			mainStr = checkNull(begPart) + "<![CDATA[" +errMsg+ " ]]>" + checkNull(endDesc);
			System.out.println("mainStr:::::::::::::::::: "+mainStr);
			begPart = null;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return mainStr;
	}
	private void closeResources(ResultSet rs, PreparedStatement pstmt) throws SQLException
	{
		boolean isError = false;
		try
		{
			if(rs!=null)
			{
				rs.close();
				rs=null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		catch(SQLException se)
		{
			isError = true;
			System.out.println("GSTDataSubmitWizPos.closeResources()["+se.getMessage()+"]");
			se.printStackTrace();
			throw new SQLException(se);
		}
		finally
		{
			try
			{
				if(isError)
				{
					if(rs!=null)
					{
						rs.close();
						rs=null;
					}
					if(pstmt!=null)
					{
						pstmt.close();
						pstmt = null;
					}
				}
			}
			catch(SQLException se)
			{
				isError = true;
				System.out.println("GSTDataSubmitWizPos.closeResources()inside finally["+se.getMessage()+"]");
				se.printStackTrace();
				throw new SQLException(se);
			}
		}
	}
}
