/**
	* @author : Chandni Shah 
	* @Version : 1.0
	* Date : 08/08/11
*/

package ibase.webitm.ejb.fin.adv;

import java.rmi.RemoteException;
import java.sql.*;

import javax.ejb.*;

import ibase.webitm.utility.*;
import ibase.webitm.ejb.*;
import ibase.system.config.*;

import javax.ejb.Stateless;

import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.ejb.fin.adv.JvConfirm;
import ibase.webitm.ejb.fin.adv.PayIbcaConf;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.utility.TransIDGenerator;
//import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.text.SimpleDateFormat;
import java.util.*;

@Stateless

public class MiscValConf extends ActionHandlerEJB implements MiscValConfLocal,MiscValConfRemote //SessionBean
{
	E12GenericUtility genericUtility = new E12GenericUtility();
public String confirm(String tranId,String xtraParams,String forcedFlag) throws RemoteException,ITMException{
		
		String errString ="";
		Connection conn = null;
		try{
				errString =  confirm(tranId, xtraParams, forcedFlag, conn); 
				
		}catch (Exception e) {
			// TODO: handle exception
			System.out.println("Exception in confirm() ==>"+e.getMessage());
			errString = genericUtility.createErrorString(e);
			System.out.println("errString in cofirm() ==>"+errString);
			e.printStackTrace();
			throw new ITMException(e);
		}
		return errString;
	}
	public String confirm(String tranId,String xtraParams,String forcedFlag,Connection conn) throws RemoteException,ITMException
	{
		//Connection conn = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        String sql = "";
        ConnDriver connDriver = null;
		
		String confirm = "" ,siteCode = "";
		String errString = "" ; 
		
		FinCommon finCommon = null;
//        GenericUtility genericUtility = null;
		ITMDBAccessEJB itmDBAccessEJB = null;
		boolean isLocalConn = false;	
		
		try
		{			
            finCommon = new FinCommon();
//			genericUtility = new GenericUtility();
			itmDBAccessEJB = new ITMDBAccessEJB();
			if(conn == null){
			connDriver = new ConnDriver();
            //Changes and Commented By Bhushan on 06-06-2016 :START
            //conn = connDriver.getConnectDB("DriverITM");
conn = getConnection();
//Changes and Commented By Bhushan on 06-06-2016 :END
			connDriver = null;
            conn.setAutoCommit(false);
            isLocalConn = true;
			}
			
			sql =" select confirmed,site_code from MISC_VOUCHER  where tran_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
            rs = pstmt.executeQuery();
            if(rs.next())
			{
                confirm = rs.getString("confirmed");
                siteCode = rs.getString("site_code");
            }
            rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			if(confirm != null  && "Y".equalsIgnoreCase(confirm))
			{
                System.out.println("The Selected transaction is already confirmed");
                errString = itmDBAccessEJB.getErrorString("","VTMCONF1","","",conn);
                return errString;
            }
			else
			{
				errString = this.gbfRetriveMiscVouch(tranId,xtraParams,conn);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
			}
		} //end of try
		catch(Exception e)
		{
			System.out.println("Exception ::"+e.getMessage());
			errString = genericUtility.createErrorString(e);
			e.printStackTrace();
			try{
				conn.rollback();
			}
			catch(Exception e1){ 
				System.out.println("Exception while rollbacking222.......");
			}
			throw new ITMException(e);
		}
		finally
		{
			System.out.println("IN fINALLY MiscValConf confirm MATHOD333@#......>>["+isLocalConn+"]");
			System.out.println("IN fINALLY MiscValConf confirm errString@#......>>["+errString+"]");
			try
			{
				if(errString != null && errString.trim().length() > 0)
				{
					if(errString.indexOf("CONFSUCCES") > -1)
					{
						if(isLocalConn){
							System.out.println("Transaction commited111.............from MiscValConf");
							conn.commit();
						}
					}
					else
					{	
						System.out.println("CONNECTION Rollbacking......................................");
							conn.rollback();
						System.out.println("CONNECTION Rollback......................................");
					}
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(isLocalConn)
					conn.close();
			}
			catch(Exception e)
			{
				System.out.println("Exception : "+e);e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;
	} //end of confirm method
	
	private	String gbfRetriveMiscVouch(String tranId,String xtraParams,Connection conn)throws RemoteException,ITMException
	{
		PreparedStatement pstmt = null;
		PreparedStatement pstmtInsert = null;
		PreparedStatement pstmtInner = null;
		ResultSet rs = null;
		ResultSet rsInner = null;
		String sql = "",sqlInsert = "",sqlInner="";
		ConnDriver connDriver = null;
		String loginEmpCode = "" ; 
//		GenericUtility genericUtility = null;
		ITMDBAccessEJB itmDBAccessEJB = null;
		FinCommon Fcommon = new FinCommon();
		DistCommon Dcommon = new DistCommon();
//		genericUtility = new GenericUtility();
		
		String vouchType ="",tranType= "",sundryType = "",sundryCode="",acctCodeAp="",cctrCodeAp="",billNo="",orderRef="";
		String siteCode="",finEntity="",currCode="",projCode = "",crTerm="",acctCodeAdv="",cctrCodeAdv="",autoPay="";
		String payMode="",bankCode="",entryBatchNo="",analCode="",empCode="",acctCodeCf="",cctrCodeCf="",confirmed="";
		String remarks="",rndOff="",sundryTypePay="",sundryCodePay="",acctCodePay="",cctrCodePay="",chqName="";
		String mvouchGenTranId="",tourId="",tranIdGen="",acctRnd="",cctrRnd="",taxAcct="",taxCctr="";
		
		java.sql.Timestamp tranDate = null;
		java.sql.Timestamp effDate = null;
		java.sql.Timestamp billDate = null;
		java.sql.Timestamp dueDate = null;
		java.sql.Timestamp resiDate = null;
		java.sql.Timestamp relieveDate = null;
		HashMap mischdrMap=null,miscdetMap=null,miscAdvMap=null,miscAcctMap	=null,miscdetListMap=null;
		
		ArrayList miscdetList = new ArrayList();	
		ArrayList miscAcctList = new ArrayList();	
		ArrayList miscAdvList = new ArrayList();	
		double taxAmt=0,rndTo=0,totAmt=0,netAmt=0,advAmt=0,netAmtBc=0,diffAmtExch=0,suppBillAmt=0,exchRate=0,rndAmt=0,billAmt=0;
		
		String lineNo="",acctCode="",cctrCode="",analCodeDet="",empCodeDet="",applyTax="",sundryTypeFor="",sundryCodeFor="";
		String acctCodeDr="",cctrCodeDr="",acctCodeCr="",prcpId="",lineNoRcp="",itemCode="",deptCode="",billNoDet="";
		String taxClass="",taxChap="",taxEnv="",contractId="",lineNoCon="",projCodeDet="",analCode1="",analCode2="";
		double amount=0,taxAmtDet=0,quantity=0,rate=0,rateClg=0,billAmtDet=0,taxedAdjAmt=0;
		java.sql.Timestamp billDateDet = null;
		
		String refSer="",refNo="",currCodeAdv="",acctCodeAd="",cctrCodeAd="";
		double adjAmt=0,totAmtAdv=0,diffAmtExchAdv=0,taxedAdjAmtAdv=0,amtTax=0,exchRateVouch=0;
		
		String lineNoAcct="",acctCodeAcct="",cctrCodeAcct="",analCodeAcct="",empCodeAcct="",remarksAcct="",sundryTypeAcct="";
		String sundryCodeAcct="",currCodeAcct="",deptCodeAcct="";
		double amountAcct=0,exchRateAcct=0;
		String winName="",cctrcodeRnd="";
		
		String ledgPostConf="",errString="",lineNoTax="",acctCodeTax="",cctrCodeTax="",taxRecoCctr="";
		String lineNoReco="",acctCodeReco="",cctrCodeReco="",siteCodeFor ="";
		double totTaxAmt=0,totRecoAmt=0,amt=0,recoAmt=0,netWr=0,rndAmtTot=0;
		double totAmtPayables=0,adjAmtPayables=0,holdAmtPayables=0;
		int lineInt =0,cnt = 0,lineNoDet = 0;
		SimpleDateFormat sdf = null;
		try
		{
			sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			itmDBAccessEJB = new ITMDBAccessEJB();
			loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			System.out.println("loginEmpCode :: ::: "+loginEmpCode);
			
			if(loginEmpCode == null || loginEmpCode.trim().length() == 0)
			{
				System.out.println("loginEmpCode is null");		
				errString = itmDBAccessEJB.getErrorString("","EMPAPRV","","",conn);
				return errString;
			}
			
			if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
			{
				sql =" select tran_id  from misc_voucher where tran_id = ? for update ";
			}
			
			else if ( "mssql".equalsIgnoreCase(CommonConstants.DB_NAME ))
			{
				sql =" select tran_id from misc_voucher (updlock) where tran_id = ? " ;
			}
			else
			{
				sql =" select tran_id from misc_voucher where tran_id = ? for update nowait " ;
			}
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			//lds_hdr ---> d_misc_vouch_rnd_edit
			sql = " SELECT vouch_type,tran_date,tran_type,eff_date,sundry_type,sundry_code,acct_code__ap,cctr_code__ap, "
				+" bill_no,bill_date,order_ref,site_code,fin_entity,curr_code,proj_code,cr_term,due_date,bill_amt, "
				+" tax_amt,tot_amt,adv_amt,acct_code__adv,cctr_code__adv,net_amt,net_amt__bc,auto_pay, "
				+" pay_mode,bank_code,entry_batch_no,anal_code,emp_code,diff_amt__exch,acct_code__cf,cctr_code__cf,confirmed, "
				+" remarks,supp_bill_amt,exch_rate,rnd_off,rnd_to,rnd_amt,sundry_type__pay,sundry_code__pay, "
				+" acct_code__pay,cctr_code__pay,chq_name,mvouch_gen_tran_id,tour_id,tran_id__gen "
				+"	FROM misc_voucher "
				+" WHERE  TRAN_ID = ? " ;
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				vouchType = rs.getString("vouch_type");
				tranDate = rs.getTimestamp("tran_date");
				tranType = rs.getString("tran_type");
				effDate = rs.getTimestamp("eff_date");
				sundryType = rs.getString("sundry_type");
				sundryCode = rs.getString("sundry_code");
				acctCodeAp = rs.getString("acct_code__ap");
				cctrCodeAp = rs.getString("cctr_code__ap");
				billNo = rs.getString("bill_no");
				billDate = rs.getTimestamp("bill_date");
				orderRef = rs.getString("order_ref");
				siteCode = rs.getString("site_code");
				finEntity = rs.getString("fin_entity");
				currCode = rs.getString("curr_code");
				projCode = rs.getString("proj_code");
				crTerm = rs.getString("cr_term");
				dueDate = rs.getTimestamp("due_date");
				billAmt = rs.getDouble("bill_amt");
				taxAmt = rs.getDouble("tax_amt");
				totAmt = rs.getDouble("tot_amt");
				advAmt = rs.getDouble("adv_amt");
				acctCodeAdv = rs.getString("acct_code__adv");
				cctrCodeAdv = rs.getString("cctr_code__adv");
				netAmt = rs.getDouble("net_amt");
				netAmtBc = rs.getDouble("net_amt__bc");
				autoPay = rs.getString("auto_pay");
				payMode = rs.getString("pay_mode");
				bankCode = rs.getString("bank_code");
				entryBatchNo = rs.getString("entry_batch_no");
				analCode = rs.getString("anal_code");
				empCode = rs.getString("emp_code");
				diffAmtExch = rs.getDouble("diff_amt__exch");
				acctCodeCf = rs.getString("acct_code__cf");
				cctrCodeCf = rs.getString("cctr_code__cf");
				confirmed = rs.getString("confirmed");
				remarks = rs.getString("remarks");
				suppBillAmt = rs.getDouble("supp_bill_amt");
				exchRate = rs.getDouble("exch_rate");
				rndOff = rs.getString("rnd_off");
				rndTo = rs.getDouble("rnd_to");
				rndAmt = rs.getDouble("rnd_amt");
				sundryTypePay = rs.getString("sundry_type__pay");
				sundryCodePay = rs.getString("sundry_code__pay");
				acctCodePay = rs.getString("acct_code__pay");
				cctrCodePay = rs.getString("cctr_code__pay");
				chqName = rs.getString("chq_name");
				mvouchGenTranId = rs.getString("mvouch_gen_tran_id");
				tourId = rs.getString("tour_id");
				tranIdGen = rs.getString("tran_id__gen");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			System.out.println("rndOff string---->>["+rndOff+"]");
			mischdrMap = new HashMap();
			mischdrMap.put("vouch_type",vouchType);
			mischdrMap.put("tran_date",tranDate);
			mischdrMap.put("tran_type",tranType);
			mischdrMap.put("eff_date",effDate);
			mischdrMap.put("sundry_type",sundryType);
			mischdrMap.put("sundry_code",sundryCode);
			mischdrMap.put("acct_code__ap",acctCodeAp);
			mischdrMap.put("cctr_code__ap",cctrCodeAp);
			mischdrMap.put("bill_no",billNo);// added by akhilesh on 04/09/12 (b'coz bill no is not updated into MISC_PAYABLES)
			mischdrMap.put("bill_date",billDate);
			mischdrMap.put("site_code",siteCode);
			mischdrMap.put("fin_entity",finEntity);
			mischdrMap.put("curr_code",currCode);
			mischdrMap.put("proj_code",projCode);
			mischdrMap.put("cr_term",crTerm);
			mischdrMap.put("due_date",dueDate);
			mischdrMap.put("bill_amt",billAmt);
			mischdrMap.put("tax_amt",taxAmt);
			mischdrMap.put("tot_amt",totAmt);
			mischdrMap.put("adv_amt",advAmt);
			mischdrMap.put("acct_code__adv",acctCodeAdv);
			mischdrMap.put("cctr_code__adv",cctrCodeAdv);
			mischdrMap.put("net_amt",netAmt);
			mischdrMap.put("net_amt__bc",netAmtBc);
			mischdrMap.put("auto_pay",autoPay);
			mischdrMap.put("pay_mode",payMode);
			mischdrMap.put("bank_code",bankCode);
			mischdrMap.put("entry_batch_no",entryBatchNo);
			mischdrMap.put("anal_code",analCode);
			mischdrMap.put("emp_code",empCode);
			mischdrMap.put("diff_amt__exch",diffAmtExch);
			mischdrMap.put("acct_code__cf",acctCodeCf);
			mischdrMap.put("cctr_code__cf",cctrCodeCf);
			mischdrMap.put("confirmed",confirmed);
			mischdrMap.put("remarks",remarks);
			mischdrMap.put("supp_bill_amt",suppBillAmt);
			mischdrMap.put("exch_rate",exchRate);
			mischdrMap.put("rnd_off",rndOff);
			mischdrMap.put("rnd_to",rndTo);
			mischdrMap.put("rnd_amt",rndAmt);
			mischdrMap.put("sundry_type__pay",sundryTypePay);
			mischdrMap.put("sundry_code__pay",sundryCodePay);
			mischdrMap.put("acct_code__pay",acctCodePay);
			mischdrMap.put("cctr_code__pay",cctrCodePay);
			mischdrMap.put("chq_name",chqName);
			mischdrMap.put("mvouch_gen_tran_id",mvouchGenTranId);
			mischdrMap.put("tour_id",tourId);
			mischdrMap.put("tran_id__gen",tranIdGen);
			//changes by Dadaso on 22-AUG-2014 [START]
			mischdrMap.put("hold_amt","0");
			//changes by Dadaso on 22-AUG-2014 [END]		
										
			//lds_det ---> d_misc_vouchdet_brow	
			System.out.println("added data map miscdetList.........111");
			sql = " SELECT line_no,acct_code,cctr_code,amount,anal_code,emp_code,apply_tax,tax_amt, "
				+" sundry_type__for,sundry_code__for,acct_code__dr, cctr_code__dr,acct_code__cr,cctr_code__cr, "
				+" prcp_id, line_no__rcp,item_code, "
				+" dept_code,quantity,rate, rate__clg, bill_no, bill_date,bill_amt, tax_class,  tax_chap,tax_env, taxed_adj_amt, "   
				+" contract_id,line_no__con,proj_code,anal_code__1,anal_code__2 "
				+" FROM misc_vouchdet  "
				+" WHERE  TRAN_ID = ? " ;
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			while (rs.next())
			{    
				lineNo = rs.getString("line_no");
				acctCode = rs.getString("acct_code");
				cctrCode = rs.getString("cctr_code");
				amount = rs.getDouble("amount");
				analCodeDet = rs.getString("anal_code");
				empCodeDet = rs.getString("emp_code");
				applyTax = rs.getString("apply_tax");
				taxAmtDet = rs.getDouble("tax_amt");
				sundryTypeFor = rs.getString("sundry_type__for");
				sundryCodeFor = rs.getString("sundry_code__for");
				acctCodeDr = rs.getString("acct_code__dr");
				cctrCodeDr = rs.getString("cctr_code__dr");
				acctCodeCr = rs.getString("acct_code__cr");
				prcpId = rs.getString("prcp_id");
				lineNoRcp = rs.getString("line_no__rcp");
				itemCode = rs.getString("item_code");
				deptCode = rs.getString("dept_code");
				quantity = rs.getDouble("quantity");
				rate = rs.getDouble("rate");
				rateClg = rs.getDouble("rate__clg");
				billNoDet = rs.getString("bill_no");
				billDateDet = rs.getTimestamp("bill_date");
				billAmtDet = rs.getDouble("bill_amt");
				taxClass = rs.getString("tax_class");
				taxChap = rs.getString("tax_chap");
				taxEnv = rs.getString("tax_env");
				taxedAdjAmt = rs.getDouble("taxed_adj_amt");
				contractId = rs.getString("contract_id");
				lineNoCon = rs.getString("line_no__con");
				projCodeDet = rs.getString("proj_code");
				analCode1 = rs.getString("anal_code__1");
				analCode2 = rs.getString("anal_code__2");
			    System.out.println("Line no is:-"+lineNo);
				miscdetMap = new HashMap(); 
				miscdetMap.put("line_no",lineNo);
				miscdetMap.put("acct_code",acctCode);
				miscdetMap.put("cctr_code",cctrCode);
				miscdetMap.put("amount",amount);
				miscdetMap.put("anal_code",analCodeDet);
				miscdetMap.put("emp_code",empCodeDet);
				miscdetMap.put("apply_tax",applyTax);
				miscdetMap.put("tax_amt",taxAmtDet);
				miscdetMap.put("sundry_type__for",sundryTypeFor);
				miscdetMap.put("sundry_code__for",sundryCodeFor);
				miscdetMap.put("acct_code__dr",acctCodeDr);
				miscdetMap.put("cctr_code__dr",cctrCodeDr);
				miscdetMap.put("acct_code__cr",acctCodeCr);
				miscdetMap.put("prcp_id",prcpId);
				miscdetMap.put("line_no__rcp",lineNoRcp);
				miscdetMap.put("item_code",itemCode);
				miscdetMap.put("dept_code",deptCode);
				miscdetMap.put("quantity",quantity);
				miscdetMap.put("rate",rate);
				miscdetMap.put("rate__clg",rateClg);
				miscdetMap.put("bill_no",billNoDet);
				miscdetMap.put("bill_date",billDateDet);
				miscdetMap.put("bill_amt",billAmtDet);
				miscdetMap.put("tax_class",taxClass);
				miscdetMap.put("tax_chap",taxChap);
				miscdetMap.put("tax_env",taxEnv);
				miscdetMap.put("taxed_adj_amt",taxedAdjAmt);
				miscdetMap.put("contract_id",contractId);
				miscdetMap.put("line_no__con",lineNoCon);
				miscdetMap.put("proj_code",projCodeDet);
				miscdetMap.put("rate__clg",rateClg);
				miscdetMap.put("anal_code__1",analCode1);
				miscdetMap.put("anal_code__2",analCode2);
				miscdetList.add(miscdetMap);
			}				
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			//lds_deta ---> d_misc_vouchadv_brow	
			sql = " SELECT ref_ser,ref_no, adj_amt,tot_amt, curr_code, diff_amt__exch, acct_code, "
				+" cctr_code, exch_rate__vouch,taxed_adj_amt  "
				+" FROM misc_vouchadv  "
				+" WHERE tran_id = ? " ;
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
            //Changes and Commented by Ajay on 06/02/18:START
			//if(rs.next())
			while(rs.next())
			{     
				refSer = rs.getString("ref_ser");
				refNo = rs.getString("ref_no");
				adjAmt = rs.getDouble("adj_amt");
				totAmtAdv = rs.getDouble("tot_amt");
				currCodeAdv = rs.getString("curr_code");
				diffAmtExchAdv = rs.getDouble("diff_amt__exch");
				acctCodeAd = rs.getString("acct_code");
				cctrCodeAd = rs.getString("cctr_code");
				exchRateVouch = rs.getDouble("exch_rate__vouch");
				taxedAdjAmtAdv = rs.getDouble("taxed_adj_amt");
			
			/*rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			*/
			miscAdvMap = new HashMap();
			miscAdvMap.put("ref_ser",refSer);
			miscAdvMap.put("ref_no",refNo);
			miscAdvMap.put("adj_amt",adjAmt);
			miscAdvMap.put("tot_amt",totAmtAdv);
			miscAdvMap.put("curr_code",currCodeAdv);
			miscAdvMap.put("diff_amt__exch",diffAmtExchAdv);
			miscAdvMap.put("acct_code",acctCodeAd);
			miscAdvMap.put("cctr_code",cctrCodeAd);
			miscAdvMap.put("exch_rate__vouch",exchRateVouch);
			miscAdvMap.put("taxed_adj_amt",taxedAdjAmtAdv);
			miscAdvList.add(miscAdvMap);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			//Changes and Commented By Ajay on 06/02/18:END
			//lds_detac ---> d_misc_vouchacct_brow
			sql = "  SELECT line_no,acct_code, cctr_code, amount, anal_code, emp_code,remarks, "
				+ " sundry_type, sundry_code,curr_code,exch_rate,dept_code  "
				+" FROM misc_vouchacct  "
				+" WHERE tran_id = ? " ;    
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			while(rs.next())
			{     
				lineNoAcct = rs.getString("line_no");
				acctCodeAcct = rs.getString("acct_code");
				cctrCodeAcct = rs.getString("cctr_code");
				amountAcct = rs.getDouble("amount");
				analCodeAcct = rs.getString("anal_code");
				empCodeAcct = rs.getString("emp_code");
				remarksAcct = rs.getString("remarks");
				sundryTypeAcct = rs.getString("sundry_type");
				sundryCodeAcct = rs.getString("sundry_code");
				currCodeAcct = rs.getString("curr_code");
				exchRateAcct = rs.getDouble("exch_rate");
				deptCodeAcct = rs.getString("dept_code");
			
				miscAcctMap = new HashMap();
				miscAcctMap.put("line_no",lineNoAcct);
				miscAcctMap.put("acct_code",acctCodeAcct);
				miscAcctMap.put("cctr_code",cctrCodeAcct);
				miscAcctMap.put("amount",amountAcct);
				miscAcctMap.put("anal_code",analCodeAcct);
				miscAcctMap.put("emp_code",empCodeAcct);
				miscAcctMap.put("remarks",remarksAcct);
				miscAcctMap.put("sundry_type",sundryTypeAcct);
				miscAcctMap.put("sundry_code",sundryCodeAcct);
				miscAcctMap.put("curr_code",currCodeAcct);
				miscAcctMap.put("exch_rate",exchRateAcct);
				miscAcctMap.put("dept_code",deptCodeAcct);
				miscAcctList.add(miscAcctMap);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			winName = "W_MISC_VOUCHER";
			java.util.Date toDay = new java.util.Date();
			tranDate =new java.sql.Timestamp(toDay.getTime());
			
			sql = "select ledg_post_conf from transetup where upper(tran_window) = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,winName);
			rs = pstmt.executeQuery();
			if(rs.next())
			{     
				ledgPostConf = rs.getString("ledg_post_conf");
			}
			else
			{
				errString = itmDBAccessEJB.getErrorString("","VTSEQ","","",conn);
				return errString;
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			if(ledgPostConf != null  && "Y".equalsIgnoreCase(ledgPostConf))
			{
				if(tranDate.compareTo(toDay) > 0)
				{
					sql =" update misc_voucher set tran_date = ? "
						+" where tran_id = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setTimestamp(1,tranDate);
					pstmt.setString(2,tranId);
					int upd = pstmt.executeUpdate();
					pstmt.close();
					pstmt = null;
				}
			}
			/*if(((billAmt +taxAmt) != totAmt) || ((totAmt+advAmt) != netAmt))
			{
				errString = itmDBAccessEJB.getErrorString("","VTAMTMIS","","",conn); // amount mismatch
				return errString;
			}*/
			if((roundVal((billAmt+taxAmt), 3) != roundVal((totAmt), 3)) || ((roundVal((totAmt+advAmt), 3) != roundVal((netAmt), 3))))
			{
				errString = itmDBAccessEJB.getErrorString("","VTAMTMIS","","",conn); // amount mismatch
				return errString;
			}
			
			/* 
			// in std mv the tax data is added in detail table
			// but for oth site ,because of jv generated with reference to detail table so that tax data is not added in the detail table 
			*/
			sql =" select site_code__for from misc_voucher where tran_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{     
				siteCodeFor = rs.getString("site_code__for");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			if (siteCodeFor == null)
			{
				sqlInsert =" insert into misc_vouchdet "
						+" (tran_id,line_no,acct_code,cctr_code,amount,emp_code,anal_code)"
						+" values (?,?,?,?,?,?,?)";
				System.out.println(" SQL for misc_vouchdet insert  :: "+sqlInsert);
				pstmtInsert = conn.prepareStatement(sqlInsert);
				lineInt = miscdetList.size();
				sql =" select line_no, acct_code, cctr_code, sum(tax_amt) as totTaxAmt, "
					+" case when sum(reco_amount) is null then 0 else sum(reco_amount) end as totRecoAmt "
					+" from taxtran "
					+" where tran_code = 'M-VOUC' "
					+" and tran_id = ?   and tax_amt <> 0 "
					+" and effect <> 'N' "
					+" group by line_no,acct_code,cctr_code " ;
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranId);
				rs = pstmt.executeQuery();
				while(rs.next())
				{     
					lineNoTax = rs.getString("line_no");
					acctCodeTax = rs.getString("acct_code");
					cctrCodeTax = rs.getString("cctr_code");
					totTaxAmt = rs.getDouble("totTaxAmt");
					totRecoAmt = rs.getDouble("totRecoAmt");
					amt = totTaxAmt - totRecoAmt;
								
					if(acctCodeTax == null)
					{
						sqlInner = "select acct_code from misc_vouchdet where tran_id = ? and line_no = ? ";
						pstmtInner = conn.prepareStatement(sqlInner);
						pstmtInner.setString(1,tranId);
						pstmtInner.setString(2,lineNoTax);
						rsInner = pstmtInner.executeQuery();
						if(rsInner.next())
						{
							acctCodeTax = rsInner.getString("acct_code");
						}
						rsInner.close();
						rsInner = null;
						pstmtInner.close();
						pstmtInner = null;
					}
					if(cctrCodeTax == null)
					{
						sqlInner = "select cctr_code from misc_vouchdet where tran_id = ? and line_no = ? ";
						pstmtInner = conn.prepareStatement(sqlInner);
						pstmtInner.setString(1,tranId);
						pstmtInner.setString(2,lineNoTax);
						rsInner = pstmtInner.executeQuery();
						if(rsInner.next())
						{
							cctrCodeTax = rsInner.getString("cctr_code");
						}
						rsInner.close();
						rsInner = null;
						pstmtInner.close();
						pstmtInner = null;
					}
					if (cctrCodeTax == null) cctrCodeTax = " ";
					
					//for (int ctr =0; ctr < miscdetList.size(); ctr++)
		//			{
	//					miscdetListMap = new HashMap();
	//					miscdetListMap = (HashMap) miscdetList.get(ctr);
					
//						lineNo = (String) miscdetListMap.get("line_no");
						System.out.println("line no ::"+lineNo);
						System.out.println("lineNoTax ::"+lineNoTax);
						  
						sqlInner = "select count(1) from misc_vouchdet where tran_id = ? and acct_code = ? and cctr_code = ? ";
						pstmtInner = conn.prepareStatement(sqlInner);
						pstmtInner.setString(1,tranId);
						pstmtInner.setString(2,acctCodeTax);
						pstmtInner.setString(3,cctrCodeTax);
						rsInner = pstmtInner.executeQuery();
						if(rsInner.next())
						{
							cnt = rsInner.getInt(1);
						}
						rsInner.close();
						rsInner = null;
						pstmtInner.close();
						pstmtInner = null;
						
						
//						acctCode = (String) miscdetListMap.get("acct_code");
//						cctrCode =(String) miscdetListMap.get("cctr_code");
//						amount = Double.parseDouble(miscdetListMap.get("amount").toString());
						//amtTax = amount+amt;
						if(cnt > 0 )
						{
							sqlInner = "select line_no from misc_vouchdet where tran_id = ? and acct_code = ? and cctr_code = ? ";
							pstmtInner = conn.prepareStatement(sqlInner);
							pstmtInner.setString(1,tranId);
							pstmtInner.setString(2,acctCodeTax);
							pstmtInner.setString(3,cctrCodeTax);
							rsInner = pstmtInner.executeQuery();
							if(rsInner.next())
							{
								lineNoDet = rsInner.getInt(1);
							}
							rsInner.close();
							rsInner = null;
							pstmtInner.close();
							pstmtInner = null;
						}
						
						System.out.println("acctCodeTax is equals to ::"+acctCodeTax);
						System.out.println("acctCode is equals to ::"+acctCode);
						System.out.println("cctrCodeTax is equals to ::"+cctrCodeTax);
						System.out.println("cctrCodeTax is equals to ::"+cctrCode);
						System.out.println("lineInt is equals to ::"+lineInt);
						
						if(cnt == 0 )
						{
							lineInt = lineInt +1;
							System.out.println(" SQL for insert :: "+sql);
							
							pstmtInsert.setString(1,tranId);
							//pstmtInsert.setString(2,lineNo);
							pstmtInsert.setInt(2,lineInt);
							pstmtInsert.setString(3,acctCodeTax);
							pstmtInsert.setString(4,cctrCodeTax);
							pstmtInsert.setDouble(5,amt);
							pstmtInsert.setString(6,"");
							pstmtInsert.setString(7,"");
							pstmtInsert.addBatch();
							pstmtInsert.executeBatch();
					
						}
						else
						{
							sqlInner =" update misc_vouchdet set amount = amount + ? where tran_id = ? and acct_code = ? and cctr_code = ? and line_no = ? ";
							pstmtInner = conn.prepareStatement(sqlInner);
							//pstmtInner.setDouble(1,amtTax);
							pstmtInner.setDouble(1,amt);
							pstmtInner.setString(2,tranId);
							pstmtInner.setString(3,acctCodeTax);
							pstmtInner.setString(4,cctrCodeTax);
							pstmtInner.setInt(5,lineNoDet);
							int updCnt = pstmtInner.executeUpdate();
							pstmtInner.close();
							pstmtInner = null;
						}
						amtTax = 0;
						
	//				} // for
				} // while
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				
				taxRecoCctr = Fcommon.getAcctDetrTtype(" "," ","TAXRECO",tranType,conn);
				
				if(taxRecoCctr.trim().length() > 1)
				{
					String[] ary =this.string2StringArray(taxRecoCctr , ",");
					taxAcct =  ary[0].toString();
					taxCctr = ary[1].toString();
				}
				
				sql =" select line_no, acct_code__reco,cctr_code__reco, "
					+" case when sum(reco_amount) is null then 0 else sum(reco_amount) end as recoAmount "
					+" from taxtran "
					+" where tran_code= 'M-VOUC' and "
					+" tran_id	= ? and "
					+" reco_amount <> 0 and effect <> 'N' "
					+" group by line_no,acct_code__reco,cctr_code__reco" ;
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranId);
				rs = pstmt.executeQuery();
				while(rs.next())
				{     
					lineNoReco = rs.getString("line_no");
					acctCodeReco = rs.getString("acct_code__reco");
					cctrCodeReco = rs.getString("cctr_code__reco");
					recoAmt = rs.getDouble("recoAmount");
				
					if(acctCodeReco == null || acctCodeReco.trim().length() == 0 )
					{
						cctrCodeReco = taxCctr;
						acctCodeReco = taxAcct;
					}
					if(acctCodeReco == null || acctCodeReco.trim().length() == 0 )
					{
						errString = itmDBAccessEJB.getErrorString("","VTACCTRECO","","",conn);
						return errString;
					}
					if (cctrCodeReco == null || cctrCodeReco.trim().length() == 0 )
					{
						cctrCodeReco = "";
					}
					//for (int ctr =0; ctr< miscdetList.size(); ctr++)
					//{
//						miscdetListMap = new HashMap();
//						miscdetListMap = (HashMap) miscdetList.get(ctr);
					
			//			lineNo = (String) miscdetListMap.get("line_no");
			//			acctCode = (String) miscdetListMap.get("acct_code");
			//			cctrCode =(String) miscdetListMap.get("cctr_code");
			//			amount = Double.parseDouble(miscdetListMap.get("amount").toString());
			//			amt = amount+recoAmt;
						sqlInner = "select count(1) from misc_vouchdet where tran_id = ? and acct_code = ? and cctr_code = ? ";
						pstmtInner = conn.prepareStatement(sqlInner);
						pstmtInner.setString(1,tranId);
						pstmtInner.setString(2,acctCodeReco);
						pstmtInner.setString(3,cctrCodeReco);
						rsInner = pstmtInner.executeQuery();
						if(rsInner.next())
						{
							cnt = rsInner.getInt(1);
						}
						rsInner.close();
						rsInner = null;
						pstmtInner.close();
						pstmtInner = null;
						
						
//						acctCode = (String) miscdetListMap.get("acct_code");
//						cctrCode =(String) miscdetListMap.get("cctr_code");
//						amount = Double.parseDouble(miscdetListMap.get("amount").toString());
						//amtTax = amount+amt;
						if(cnt > 0 )
						{
							sqlInner = "select line_no from misc_vouchdet where tran_id = ? and acct_code = ? and cctr_code = ? ";
							pstmtInner = conn.prepareStatement(sqlInner);
							pstmtInner.setString(1,tranId);
							pstmtInner.setString(2,acctCodeReco);
							pstmtInner.setString(3,cctrCodeReco);
							rsInner = pstmtInner.executeQuery();
							if(rsInner.next())
							{
								lineNoDet = rsInner.getInt(1);
							}
							rsInner.close();
							rsInner = null;
							pstmtInner.close();
							pstmtInner = null;
						}
						
						if(cnt > 0)
						{
							lineNo = lineNo +1;
							
							pstmtInsert.setString(1,tranId);
							pstmtInsert.setString(2,lineNo);
							pstmtInsert.setString(3,acctCodeReco);
							pstmtInsert.setString(4,cctrCodeReco);
							pstmtInsert.setDouble(5,recoAmt);
							pstmtInsert.setString(6,"");
							pstmtInsert.setString(7,"");
							pstmtInsert.addBatch();
						
						}
						else
						{
							sqlInner = "update misc_vouchdet set amount = amount + ? where tran_id = ? and acct_code = ? and cctr_code = ? and line_no = ? ";
							pstmtInner = conn.prepareStatement(sqlInner);
							pstmtInner.setDouble(1,recoAmt);
							pstmtInner.setString(2,tranId);
							pstmtInner.setString(3,acctCodeReco);
							pstmtInner.setString(4,cctrCodeReco);
							pstmtInner.setInt(3,lineNoDet);
							int updCnt = pstmtInner.executeUpdate();
							pstmtInner.close();
							pstmtInner = null;
				
						}
						amt = 0;
					//}
				}//while
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
			}
			// */
			System.out.println("rndOff111-------->>["+rndOff+"]");
			if(!("N").equalsIgnoreCase(rndOff))
			{
				//rndTo from header;
				netWr = netAmt;
				netAmt = Dcommon.getRndamt(netAmt,rndOff,rndTo);
				rndAmtTot = netAmt - netWr;
				System.out.println("netWr--->>["+netWr+"]");
				System.out.println("netAmt--->>["+netAmt+"]");
				System.out.println("rndAmtTot--->>["+rndAmtTot+"]");
				
				if(rndAmtTot != 0)
				{
					cctrcodeRnd = Fcommon.getFinparams("999999","RND_ACCT",conn);
/*					if(cctrcodeRnd != null)
					{
						String[] arry =this.string2StringArray(cctrcodeRnd , ";");
						acctRnd =  arry[0].toString();
						cctrRnd = arry[1].toString();
					}*/
					if(cctrcodeRnd != "NULLFOUND")
					{
						String[] arry =cctrcodeRnd.split((";"));
						System.out.println("@@@@@ arry["+arry.length+"]");
						if( arry.length > 0)
						{
							acctRnd =  arry[0];
							System.out.println("acctRnd["+acctRnd+"]");
						}
						else
						{
							acctRnd = "";
						}
						if( arry.length > 1)
						{
						cctrRnd = arry[1];
						System.out.println("cctrRnd["+cctrRnd+"]");
						}
						else
						{
							cctrRnd="";
						}
					}
					else
					{
						errString = itmDBAccessEJB.getErrorString("","VTFINPARM","","",conn);
						return errString;
					}
					lineNo =lineNo +1;
					pstmtInsert.setString(1,tranId);
					pstmtInsert.setString(2,lineNo);
					pstmtInsert.setString(3,acctRnd);
					pstmtInsert.setString(4,cctrRnd);
					pstmtInsert.setDouble(5,rndAmtTot);
					pstmtInsert.setString(6,"");
					pstmtInsert.setString(7,"");
					pstmtInsert.addBatch();
					
				}	
				pstmtInsert.executeBatch();
				pstmtInsert.close();
				
				//added by Dadaso pawar [if round off value R then first miscdetList clear and create again ]
				if(miscdetList !=null){
					System.out.println("miscdetList Cleared................");
				miscdetList.clear();
				}
				// misc_vouchdet inserted and updated many time...so create new list for passing it into next method, below code is done
				
				System.out.println("added data in map miscdetList------------------222");
				sql =" SELECT line_no,acct_code,cctr_code,amount,anal_code,emp_code,apply_tax,tax_amt, "
					+" sundry_type__for,sundry_code__for,acct_code__dr, cctr_code__dr,acct_code__cr,cctr_code__cr, "
					+" prcp_id, line_no__rcp,item_code, "
					+" dept_code,quantity,rate, rate__clg, bill_no, bill_date,bill_amt, tax_class,  tax_chap,tax_env, taxed_adj_amt, "   
					+" contract_id,line_no__con,proj_code,anal_code__1,anal_code__2 "
					+" FROM misc_vouchdet  "
					+" WHERE  TRAN_ID = ? " ;
						
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranId);
				rs = pstmt.executeQuery();
				while(rs.next())
				{    
					lineNo = rs.getString("line_no");
					acctCode = rs.getString("acct_code");
					cctrCode = rs.getString("cctr_code");
					amount = rs.getDouble("amount");
					analCodeDet = rs.getString("anal_code");
					empCodeDet = rs.getString("emp_code");
					applyTax = rs.getString("apply_tax");
					taxAmtDet = rs.getDouble("tax_amt");
					sundryTypeFor = rs.getString("sundry_type__for");
					sundryCodeFor = rs.getString("sundry_code__for");
					acctCodeDr = rs.getString("acct_code__dr");
					cctrCodeDr = rs.getString("cctr_code__dr");
					acctCodeCr = rs.getString("acct_code__cr");
					prcpId = rs.getString("prcp_id");
					lineNoRcp = rs.getString("line_no__rcp");
					itemCode = rs.getString("item_code");
					deptCode = rs.getString("dept_code");
					quantity = rs.getDouble("quantity");
					rate = rs.getDouble("rate");
					rateClg = rs.getDouble("rate__clg");
					billNoDet = rs.getString("bill_no");
					billDateDet = rs.getTimestamp("bill_date");
					billAmtDet = rs.getDouble("bill_amt");
					taxClass = rs.getString("tax_class");
					taxChap = rs.getString("tax_chap");
					taxEnv = rs.getString("tax_env");
					taxedAdjAmt = rs.getDouble("taxed_adj_amt");
					contractId = rs.getString("contract_id");
					lineNoCon = rs.getString("line_no__con");
					projCodeDet = rs.getString("proj_code");
					analCode1 = rs.getString("anal_code__1");
					analCode2 = rs.getString("anal_code__2");
					
					miscdetMap = new HashMap();
					miscdetMap.put("line_no",lineNo);
					miscdetMap.put("acct_code",acctCode);
					miscdetMap.put("cctr_code",cctrCode);
					miscdetMap.put("amount",amount);
					miscdetMap.put("anal_code",analCodeDet);
					miscdetMap.put("emp_code",empCodeDet);
					miscdetMap.put("apply_tax",applyTax);
					miscdetMap.put("tax_amt",taxAmtDet);
					miscdetMap.put("sundry_type__for",sundryTypeFor);
					miscdetMap.put("sundry_code__for",sundryCodeFor);
					miscdetMap.put("acct_code__dr",acctCodeDr);
					miscdetMap.put("cctr_code__dr",cctrCodeDr);
					miscdetMap.put("acct_code__cr",acctCodeCr);
					miscdetMap.put("prcp_id",prcpId);
					miscdetMap.put("line_no__rcp",lineNoRcp);
					miscdetMap.put("item_code",itemCode);
					miscdetMap.put("dept_code",deptCode);
					miscdetMap.put("quantity",quantity);
					miscdetMap.put("rate",rate);
					miscdetMap.put("rate__clg",rateClg);
					miscdetMap.put("bill_no",billNoDet);
					miscdetMap.put("bill_date",billDateDet);
					miscdetMap.put("bill_amt",billAmtDet);
					miscdetMap.put("tax_class",taxClass);
					miscdetMap.put("tax_chap",taxChap);
					miscdetMap.put("tax_env",taxEnv);
					miscdetMap.put("taxed_adj_amt",taxedAdjAmt);
					miscdetMap.put("contract_id",contractId);
					miscdetMap.put("line_no__con",lineNoCon);
					miscdetMap.put("proj_code",projCodeDet);
					miscdetMap.put("rate__clg",rateClg);
					miscdetMap.put("anal_code__1",analCode1);
					miscdetMap.put("anal_code__2",analCode2);
					miscdetList.add(miscdetMap);
				}				
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				mischdrMap.put("rnd_amt",rndAmtTot);
				System.out.println("mischdrMap["+mischdrMap+"]");
				sql =" update misc_payables set adj_amt = adj_amt + "+adjAmt+", status = ?,status_date =? "
					+" where tran_ser =? and ref_no =? ";
				
				//amt = Double.parseDouble((String)journalMap.get("dr_amt")); 
				netAmtBc =(Double.parseDouble(mischdrMap.get("net_amt").toString())) * exchRate;
				sql ="update misc_voucher set net_amt =net_amt + "+rndAmtTot+", "
					+" net_amt__bc = ?, rnd_amt = ? where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setDouble(1,netAmtBc);
				pstmt.setDouble(2,rndAmtTot);
				pstmt.setString(3,tranId);
				int upd = pstmt.executeUpdate();
				pstmt.close();
				pstmt = null;
				
			} //end rndOff != N
			
			if(errString != null && errString.trim().length() > 0)
			{
				System.out.println("Returning Result "+errString);
				conn.rollback();
				return errString;
			}
			else
			{
				errString = this.gbfPostMiscVouch(tranId,mischdrMap,miscdetList,miscAdvList,xtraParams,conn);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
			}
			if(("E").equalsIgnoreCase(sundryType.trim()))
			{
				sql =" select resi_date,relieve_date from employee "
					+" where emp_code = ?"; 
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,sundryCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					resiDate = rs.getTimestamp("resi_date");
					relieveDate = rs.getTimestamp("relieve_date");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;					
			
				if(resiDate != null && relieveDate != null)
				{
					sql =" select tot_amt, adj_amt,(case when hold_amt is null then 0 else hold_amt end) as holdamt "
						+" from misc_payables where tran_ser = 'M-VOUC' "
						+" and ref_no = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,tranId);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						totAmtPayables = rs.getDouble("tot_amt");
						adjAmtPayables = rs.getDouble("adj_amt");
						holdAmtPayables = rs.getDouble("holdamt");
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;		
				}
				
				if((totAmtPayables - adjAmtPayables) == 0)
				{
					errString = itmDBAccessEJB.getErrorString("","VTBAL2","","",conn); // already paid off
					return errString;
				}
				else if((adjAmtPayables != 0) && (adjAmtPayables != totAmtPayables))
				{
					errString = itmDBAccessEJB.getErrorString("","VTBAL2","","",conn);  // partly paid off
					return errString;
				}
				else if(holdAmtPayables > 0)
				{
					sql =" update misc_payables set hold_amt = 0 "
						+" where tran_ser = 'M-VOUC' and ref_no = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,tranId);
					int upd1 = pstmt.executeUpdate();
					pstmt.close();
					pstmt = null;
				}
				else if (holdAmtPayables == 0)
				{
					sql =" update misc_payables set hold_amt = ? "
						+" where tran_ser = 'M-VOUC' and ref_no =? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setDouble(1,totAmtPayables);
					pstmt.setString(2,tranId);
					int upd2 = pstmt.executeUpdate();
					pstmt.close();
					pstmt = null;
				}
			} // E if end
		} //try
		catch(SQLException e)
		{
			System.out.println("Exception :MiscValConf :gbfRetriveMiscVouch :SQLException :==>\n"+e.getMessage());
			errString = genericUtility.createErrorString(e);
			throw new ITMException(e);
		}		
		catch (Exception e)
		{
			System.out.println("Exception :MiscValConf :gbfRetriveMiscVouch :==>"+e.getMessage());
			errString = genericUtility.createErrorString(e);
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(rsInner != null)
				{
					rsInner.close();
					rsInner = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(pstmtInner != null)
				{
					pstmtInner.close();
					pstmtInner = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception : "+e);e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;	
	} // end of gbfRetriveMiscVouch method
	private	String gbfPostMiscVouch(String tranId,HashMap mischdrMap,ArrayList miscdetList,ArrayList miscAdvList,String xtraParams,Connection conn)throws RemoteException,ITMException
	{
		System.out.println(".............in gbfPostMiscVouch method......");
		System.out.println("mischdrMap------>["+mischdrMap+"]");
		System.out.println("miscdetList------>["+miscdetList+"]");
		System.out.println("miscAdvList------>["+miscAdvList+"]");
		
		PreparedStatement pstmt = null;
		PreparedStatement pstmtInner = null;
		ResultSet rs = null;
		ResultSet rsInner = null;
		String sql = "",sqlInner="";
		ConnDriver connDriver = null;
		String errString = "" ; 
//		GenericUtility genericUtility = null;
		ITMDBAccessEJB itmDBAccessEJB = null;
		FinCommon Fcommon = new FinCommon();
//		genericUtility = new GenericUtility();
		E12GenericUtility genericUtility = new E12GenericUtility();
		String  runMode="I",chgUser="",chgTerm="",tranType="",refType="",siteCodeFor="";
		String sundryType="",supp="",siteCode="",sitePayment="",winName="",finEntFr="",keyString="";
		String finEntTo="",ibcaId="",link="",acctFr="",cctrFr="",acctTo="",cctrTo="",remarks="";
		String curr="",bank="",acct="",cctr="",bill="",purcOrder="",autoPay="",payMode="",batch="",crTerm="";
		double amount=0,exch=0,suppAmt=0,adv=0,amountBc=0;
		
		java.sql.Timestamp billDt = null;
		java.sql.Timestamp dueDate = null;
		java.sql.Timestamp tranDate = null;
		java.sql.Timestamp refDate = null;
		java.util.Date toDay = new java.util.Date();
		java.sql.Timestamp tDay = null;
		SimpleDateFormat sdf = null;
		//autoConf Added by Pavan R on 18/OCT/17  		
		String autoConf = "";  
		
		try
		{
			sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			itmDBAccessEJB = new ITMDBAccessEJB();
			
			errString = this.gbfPostMiscVouhdr(tranId,mischdrMap,miscAdvList,xtraParams,conn);
			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}
			else
			{
				errString = this.gbfPostMiscVoudet(tranId,mischdrMap,miscdetList,xtraParams,conn);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
			}
			
			errString = Fcommon.checkGlTranDrCr("M-VOUC",tranId,conn);
			System.out.println("errString in checkGlTranDrCr ::"+errString);
			
			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}
			 
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
			
			sundryType = (String)mischdrMap.get("sundry_type");
			if("S".equalsIgnoreCase(sundryType))
			{
				supp  =(String)mischdrMap.get("sundry_code");
				siteCode =(String)mischdrMap.get("site_code");
				// 13/10/16 manoharan site_code__pay to be taken from misc_voucher
				//sql =" select site_code__pay from site_supplier where supp_code = ? and site_code = ? ";
				sql =" select site_code__pay from misc_voucher where tran_id = ?";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,tranId);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					sitePayment = rs.getString("site_code__pay");
					System.out.println( "Site Payment"+sitePayment);
				}
				/*
				else
				{
					System.out.println("Else Condition");
					sqlInner ="select site_code__pay from supplier where supp_code = ? " ;		
					pstmtInner = conn.prepareStatement(sqlInner);
					pstmtInner.setString(1,supp);
					rsInner = pstmtInner.executeQuery();
					if(rsInner.next())
					{
						sitePayment = rsInner.getString("site_code__pay");
					}
					rsInner.close();
					rsInner = null;
					pstmtInner.close();
					pstmtInner = null;
					System.out.println("Else sitePayment"+sitePayment);
				}
				*/
				rs.close();
				rs = null;
				pstmt.close();
				pstmt =null;
				//19-10-2016 Added by Abhijit Gaikwad
				if(sitePayment == null)
				{
					sql =" select site_code__pay from site_supplier where supp_code = ? and site_code = ? ";
					pstmt =  conn.prepareStatement(sql);
					pstmt.setString(1,supp);
					pstmt.setString(2,siteCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						sitePayment = rs.getString("site_code__pay");
						System.out.println( "Site Payment site_transporter "+sitePayment);
					}
					
					else
					{
						System.out.println("Else Condition transporter");
						sqlInner ="select site_code__pay from supplier where supp_code = ? " ;		
						pstmtInner = conn.prepareStatement(sqlInner);
						pstmtInner.setString(1,supp);
						rsInner = pstmtInner.executeQuery();
						if(rsInner.next())
						{
							sitePayment = rsInner.getString("site_code__pay");
						}
						rsInner.close();
						rsInner = null;
						pstmtInner.close();
						pstmtInner = null;
						System.out.println("Else sitePayment"+sitePayment);
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt =null;
				
				}
				
			}// S-sundry Type
			else if("T".equalsIgnoreCase(sundryType))
			{
				supp  =(String)mischdrMap.get("sundry_code");
				siteCode =(String)mischdrMap.get("site_code");
				sql =" select site_code__pay from misc_voucher where tran_id = ?";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,tranId);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					sitePayment = rs.getString("site_code__pay");
					System.out.println( "Site Payment"+sitePayment);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt =null;
				if(sitePayment == null)
				{
				sql =" select site_code__pay from site_transporter where tran_code = ? and site_code = ? ";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,supp);
				pstmt.setString(2,siteCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					sitePayment = rs.getString("site_code__pay");
					System.out.println( "Site Payment site_transporter "+sitePayment);
				}
				
				else
				{
					System.out.println("Else Condition transporter");
					sqlInner ="select site_code__pay from transporter where tran_code = ? " ;		
					pstmtInner = conn.prepareStatement(sqlInner);
					pstmtInner.setString(1,supp);
					rsInner = pstmtInner.executeQuery();
					if(rsInner.next())
					{
						sitePayment = rsInner.getString("site_code__pay");
					}
					rsInner.close();
					rsInner = null;
					pstmtInner.close();
					pstmtInner = null;
					System.out.println("Else sitePayment"+sitePayment);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt =null;
				}
			}
			else if("X".equalsIgnoreCase(sundryType))
			{
				supp  =(String)mischdrMap.get("sundry_code");
				siteCode =(String)mischdrMap.get("site_code");
				sql =" select site_code__pay from misc_voucher where tran_id = ?";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,tranId);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					sitePayment = rs.getString("site_code__pay");
					System.out.println( "Site Payment"+sitePayment);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt =null;
				if(sitePayment == null)
				{
				sql =" select site_code__pay from site_tax_authority where tauth_code = ? and site_code = ? ";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,supp);
				pstmt.setString(2,siteCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					sitePayment = rs.getString("site_code__pay");
					System.out.println( "Site Payment site_tax_authority"+sitePayment);
				}
				
				else
				{
					System.out.println("Else Condition TAX_AUTHORITY");
					sqlInner ="select site_code__pay from tax_authority where tauth_code = ? " ;		
					pstmtInner = conn.prepareStatement(sqlInner);
					pstmtInner.setString(1,supp);
					rsInner = pstmtInner.executeQuery();
					if(rsInner.next())
					{
						sitePayment = rsInner.getString("site_code__pay");
					}
					rsInner.close();
					rsInner = null;
					pstmtInner.close();
					pstmtInner = null;
					System.out.println("Else sitePayment tax_authority"+sitePayment);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt =null;
			}
			}
			else if("R".equalsIgnoreCase(sundryType))
			{
				supp  =(String)mischdrMap.get("sundry_code");
				siteCode =(String)mischdrMap.get("site_code");
				sql =" select site_code__pay from misc_voucher where tran_id = ?";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,tranId);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					sitePayment = rs.getString("site_code__pay");
					System.out.println( "Site Payment"+sitePayment);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt =null;
				if(sitePayment == null)
				{
				sql =" select site_code__pay from site_strg_customer where sc_code = ? and site_code = ? ";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,supp);
				pstmt.setString(2,siteCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					sitePayment = rs.getString("site_code__pay");
					System.out.println( "Site Payment site_strg_customer"+sitePayment);
				}
				
				else
				{
					System.out.println("Else Condition strg_customer");
					sqlInner ="select site_code__pay from strg_customer where sc_code = ? " ;		
					pstmtInner = conn.prepareStatement(sqlInner);
					pstmtInner.setString(1,supp);
					rsInner = pstmtInner.executeQuery();
					if(rsInner.next())
					{
						sitePayment = rsInner.getString("site_code__pay");
					}
					rsInner.close();
					rsInner = null;
					pstmtInner.close();
					pstmtInner = null;
					System.out.println("Else sitePayment strg_customer"+sitePayment);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt =null;
			}
			}
			else if("P".equalsIgnoreCase(sundryType))
			{
				supp  =(String)mischdrMap.get("sundry_code");
				siteCode =(String)mischdrMap.get("site_code");
				sql =" select site_code__pay from misc_voucher where tran_id = ?";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,tranId);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					sitePayment = rs.getString("site_code__pay");
					System.out.println( "Site Payment"+sitePayment);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt =null;
				if(sitePayment == null)
				{
				sql =" select site_code__pay from site_sales_pers where sales_pers = ? and site_code = ? ";//SITE_SALES_PERS
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,supp);
				pstmt.setString(2,siteCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					sitePayment = rs.getString("site_code__pay");
					System.out.println( "Site Payment site_sales_per"+sitePayment);
				}
				
				else
				{
					System.out.println("Else Condition sales_per");
					sqlInner ="select site_code__pay from sales_pers where sales_pers = ? " ;		
					pstmtInner = conn.prepareStatement(sqlInner);
					pstmtInner.setString(1,supp);
					rsInner = pstmtInner.executeQuery();
					if(rsInner.next())
					{
						sitePayment = rsInner.getString("site_code__pay");
					}
					rsInner.close();
					rsInner = null;
					pstmtInner.close();
					pstmtInner = null;
					System.out.println("Else sitePayment sales_per"+sitePayment);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt =null;
			}
			}
			else if("C".equalsIgnoreCase(sundryType))
			{
				supp  =(String)mischdrMap.get("sundry_code");
				siteCode =(String)mischdrMap.get("site_code");
				sql =" select site_code__pay from misc_voucher where tran_id = ?";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,tranId);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					sitePayment = rs.getString("site_code__pay");
					System.out.println( "Site Payment"+sitePayment);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt =null;
				if(sitePayment == null)
				{
				sql =" select site_code__pay from site_customer where cust_code = ? and site_code = ? ";//SITE_SALES_PERS
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,supp);
				pstmt.setString(2,siteCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					sitePayment = rs.getString("site_code__pay");
					System.out.println( "Site Payment site_customer"+sitePayment);
				}
				
				else
				{
					System.out.println("Else Condition customer");
					sqlInner ="select site_code__pay from customer where cust_code = ? " ;		
					pstmtInner = conn.prepareStatement(sqlInner);
					pstmtInner.setString(1,supp);
					rsInner = pstmtInner.executeQuery();
					if(rsInner.next())
					{
						sitePayment = rsInner.getString("site_code__pay");
					}
					rsInner.close();
					rsInner = null;
					pstmtInner.close();
					pstmtInner = null;
					System.out.println("Else sitePayment customer"+sitePayment);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt =null;
			}
			}
			else if("L".equalsIgnoreCase(sundryType))
			{
				supp  =(String)mischdrMap.get("sundry_code");
				siteCode =(String)mischdrMap.get("site_code");
				sql =" select site_code__pay from misc_voucher where tran_id = ?";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,tranId);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					sitePayment = rs.getString("site_code__pay");
					System.out.println( "Site Payment"+sitePayment);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt =null;
				if(sitePayment == null)
				{
				sql =" select site_code__pay from site_loanparty  where party_code = ? and site_code = ? ";//SITE_SALES_PERS
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,tranId);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					sitePayment = rs.getString("site_code__pay");
					System.out.println( "Site Payment site_loanparty"+sitePayment);
				}
				
				else
				{
					System.out.println("Else Condition customer");
					sqlInner ="select site_code__pay from loanparty where party_code = ? " ;		
					pstmtInner = conn.prepareStatement(sqlInner);
					pstmtInner.setString(1,supp);
					rsInner = pstmtInner.executeQuery();
					if(rsInner.next())
					{
						sitePayment = rsInner.getString("site_code__pay");
					}
					rsInner.close();
					rsInner = null;
					pstmtInner.close();
					pstmtInner = null;
					System.out.println("Else sitePayment loanparty"+sitePayment);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt =null;
			}
			}
			else if("E".equalsIgnoreCase(sundryType))
			{
				supp  =(String)mischdrMap.get("sundry_code");
				siteCode =(String)mischdrMap.get("site_code");
				sql =" select site_code__pay from misc_voucher where tran_id = ?";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,tranId);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					sitePayment = rs.getString("site_code__pay");
					System.out.println( "Site Payment"+sitePayment);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt =null;
				if(sitePayment == null)
				{
				sql =" select pay_site from employee  where emp_code=? ";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,supp);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					sitePayment = rs.getString("site_code__pay");
					System.out.println( "Site Payment emp"+sitePayment);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt =null;
			}
			}//End by Abhijit Gaikwad
			System.out.println("sitePayment"+sitePayment+" !=siteCode"+siteCode);
			
			if((!sitePayment.trim().equals(siteCode.trim())) && (("I").equalsIgnoreCase(runMode)))
			{
				winName = "W_PAY_IBCA";
				sql ="select key_string from transetup where upper(tran_window) = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,winName);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					keyString = rs.getString("key_string");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				
				sql ="select fin_entity  from site where site_code = ? ";
				pstmt =conn.prepareStatement(sql);
				pstmt.setString(1,siteCode);
				rs =  pstmt.executeQuery();
				if(rs.next())
				{
					finEntFr = rs.getString("fin_entity");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt= null;
				
				sql =" select fin_entity from site where site_code = ? ";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,sitePayment);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					finEntTo = rs.getString("fin_entity");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt= null;
				
				sql =" select link_type, acct_code__pay, cctr_code__pay, acct_code__rcp, cctr_code__rcp, auto_confirm"
					+" from ibca_pay_ctrl where site_code__from = ? and site_code__to = ? ";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,siteCode);
				pstmt.setString(2,sitePayment);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					link = rs.getString("link_type");
					acctFr = rs.getString("acct_code__pay");
					cctrFr = rs.getString("cctr_code__pay");
					acctTo = rs.getString("acct_code__rcp");
					cctrTo = rs.getString("cctr_code__rcp");
					//added by Pavan R on 18/OCT/17 to generate auto-generated ibca on confim of misc voucher
					autoConf = rs.getString("auto_confirm"); 
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt= null;
				
				tDay = new java.sql.Timestamp(toDay.getTime());
				
				String xmlStringIbca = "<?xml version=\"1.0\"?>\r\n<Root>\r\n<header>"+
                "\r\n</header><Detail1><item_ser></item_ser>"+
                "\r\n<tran_date>"+sdf.format(new java.util.Date(tDay.getTime()))+"</tran_date>"+
				"\r\n<site_code__from>"+siteCode+"</site_code__from>"+
				"\r\n<link_type>"+link+"</link_type></Detail1></Root>";
				CommonConstants.setIBASEHOME();
				TransIDGenerator tg = new TransIDGenerator(xmlStringIbca,"SYSTEM",CommonConstants.DB_NAME);
				ibcaId = tg.generateTranSeqID("P-IBCA","tran_id", keyString, conn);
				System.out.println("Generated Key :: "+ibcaId);
				if (ibcaId.indexOf("ERROR") > -1 )
				{
					errString = itmDBAccessEJB.getErrorString("","VTTRANID","","",conn);
				}
				remarks = "Auto IBCA of voucher of " +supp;
				
				sql =" select tot_amt,exch_rate,curr_code,bank_code,acct_code,cctr_code,bill_no, "
					+" bill_date,supp_bill_amt,purc_order,auto_pay,due_date,adv_amt,tran_date, "
					+" sundry_code,pay_mode,entry_batch_no, ref_date "
					+" from misc_payables where tran_ser = 'M-VOUC' "
					+" and ref_no = ?";
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1,tranId);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					amount = rs.getDouble("tot_amt");
					exch = rs.getDouble("exch_rate");
					curr = rs.getString("curr_code");
					bank = rs.getString("bank_code");
					acct = rs.getString("acct_code");
					cctr = rs.getString("cctr_code");
					bill = rs.getString("bill_no");
					billDt = rs.getTimestamp("bill_date");
					suppAmt = rs.getDouble("supp_bill_amt");
					purcOrder = rs.getString("purc_order");
					autoPay = rs.getString("auto_pay");
					dueDate = rs.getTimestamp("due_date");
					adv = rs.getDouble("adv_amt");
					tranDate = rs.getTimestamp("tran_date");
					supp = rs.getString("sundry_code");
					payMode = rs.getString("pay_mode");
					batch = rs.getString("entry_batch_no");
					refDate = rs.getTimestamp("ref_date");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt= null;
		
				amountBc = amount * exch;
				crTerm 	 = (String)mischdrMap.get("cr_term");
				
				/*java.sql.Timestamp tDay = null;
				tDay = new java.sql.Timestamp(toDay.getTime());*/
				// create the ibca
				sql =" insert into pay_ibca (tran_id,tran_date,eff_date,site_code__from,fin_entity__from, "
					+" site_code__to,fin_entity__to,amount,curr_code,exch_rate,confirmed,acct_code__ifr, "
					+" cctr_code__ifr,acct_code__ito,cctr_code__ito,chg_date,chg_user,chg_term,amount__bc, "
					+" tran_type,tran_ser,link_type,remarks)"
					+" values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)" ;
				
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,ibcaId);
				pstmt.setTimestamp(2,tranDate);
				pstmt.setTimestamp(3,tranDate);
				pstmt.setString(4,siteCode);
				pstmt.setString(5,finEntFr);
				pstmt.setString(6,sitePayment);
				pstmt.setString(7,finEntTo);
				pstmt.setDouble(8,amount);
				pstmt.setString(9,curr);
				pstmt.setDouble(10,exch);
				pstmt.setString(11,"N");
				
				if(acctFr == null || acctFr.trim().length() == 0)
				{
					pstmt.setNull(12,Types.VARCHAR);
				}
				else
				{
					pstmt.setString(12,acctFr);
				}
				if(cctrFr == null || cctrFr.trim().length() == 0)
				{
					pstmt.setNull(13,Types.VARCHAR);
				}
				else
				{
					pstmt.setString(13,cctrFr);
				}
				if(acctTo == null || acctTo.trim().length() == 0)
				{
					pstmt.setNull(14,Types.VARCHAR);
				}
				else
				{
					pstmt.setString(14,acctTo);
				}
				if(cctrTo == null || cctrTo.trim().length() == 0)
				{
					pstmt.setNull(15,Types.VARCHAR);
				}
				else
				{
					pstmt.setString(15,cctrTo);
				}
								
				pstmt.setTimestamp(16,tDay);
				pstmt.setString(17,chgUser); 
				pstmt.setString(18,chgTerm); 
				pstmt.setDouble(19,amountBc);
				pstmt.setString(20,tranType); 
				pstmt.setString(21,"I");
				if(link == null || link.trim().length() == 0)
				{
					pstmt.setNull(22,Types.VARCHAR);
				}
				else
				{
					pstmt.setString(22,link);
				}
				pstmt.setString(23,remarks);
				pstmt.executeUpdate();
				pstmt.close();
				System.out.println(">>>>>>>>@1888::tran_id["+ibcaId+"]");
				sql =" insert into pay_ibca_det (tran_id,ref_ser,ref_no,ref_date,curr_code,exch_rate, "
					+" sundry_type,sundry_code,acct_code,cctr_code,due_date,tot_amt,discount,tax_amt, "
					+" auto_pay,bank_code,ref_type,bill_no,bill_date,pay_mode,entry_batch_no,purc_order, "
					+" supp_bill_amt,adv_amt,tds_amt,cr_term ) "
					+" values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,ibcaId);
				pstmt.setString(2,"M-VOUC");
				pstmt.setString(3,tranId);
				pstmt.setTimestamp(4,refDate);
				pstmt.setString(5,curr);
				pstmt.setDouble(6,exch);
				pstmt.setString(7,sundryType);
				pstmt.setString(8,supp);
				pstmt.setString(9,acct);
				pstmt.setString(10,cctr);
				pstmt.setTimestamp(11,dueDate);
				pstmt.setDouble(12,amount);
				pstmt.setString(13,"0");
				pstmt.setString(14,"0");
				pstmt.setString(15,autoPay);
				pstmt.setString(16,bank); 
				pstmt.setString(17,refType); 
			//	pstmt.setString(17,refType); //
				pstmt.setString(18,bill);
				pstmt.setTimestamp(19,billDt);
				pstmt.setString(20,payMode);
				pstmt.setString(21,batch);
				pstmt.setString(22,purcOrder);
				pstmt.setDouble(23,suppAmt);
				pstmt.setDouble(24,adv);
				pstmt.setString(25,"0");
				pstmt.setString(26,crTerm);
				
				pstmt.executeUpdate();
				pstmt.close();
				
			//	Added by Pavan R on 18/OCT/17 Start
				System.out.println("###auto_Confirm::["+autoConf+"]");
				if (autoConf != null && "Y".equalsIgnoreCase(autoConf)) 
				{									
					PayIbcaConf payIbcaConf = new PayIbcaConf();
					errString = payIbcaConf.confirm(ibcaId, xtraParams, "", conn);						
					 if(errString != null && errString.indexOf("VTCICONF3") != -1)
					  {
						   System.out.println("errString.indexOf::["+errString.indexOf("VTCICONF3")+"]");
						   errString = "";
					  }//else condition added BY Pavan R on 06/NOV/17
					 else
					 {
						 return errString;
					}
					
				}
				//Pavan R on 18/OCT/17 End
			} //gs_run_mode 
			sql =" select site_code__for from misc_voucher where tran_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
            rs = pstmt.executeQuery();
            if(rs.next())
			{
                siteCodeFor = rs.getString("site_code__for");
            }
            rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			//added by chandni 
			if(siteCodeFor != null)
			{
				errString = this.otherSitePostMiscVal(tranId,mischdrMap,miscdetList,xtraParams,conn);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
			}
			else
			{
				errString = itmDBAccessEJB.getErrorString("","CONFSUCCES","");
				System.out.println("MiscVal Confirmed .."+errString);
			}
		} //try end
		catch(SQLException e)
		{
				System.out.println("Exception :MiscValConf :gbfPostMiscVouch :SQLException :==>\n"+e.getMessage());
				errString = genericUtility.createErrorString(e);
				throw new ITMException(e);
		}		
		catch (Exception e)
		{
			System.out.println("Exception :MiscValConf :gbfPostMiscVouch :==>"+e.getMessage());
			errString = genericUtility.createErrorString(e);
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(rsInner != null)
				{
					rsInner.close();
					rsInner = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(pstmtInner != null)
				{
					pstmtInner.close();
					pstmtInner = null;
				}
				
			}
			catch(Exception e)
			{
				System.out.println("Exception : "+e);e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;
	}// gbfPostMiscVouch method end
	
	private	String gbfPostMiscVouhdr(String tranId,HashMap mischdrMap,ArrayList miscAdvList,String xtraParams,Connection conn)throws RemoteException,ITMException
	{
		System.out.println("-------in method gbfPostMiscVouhdr-----------");
		System.out.println("insert into MISC_PAYABLES valuessssss  ["+miscAdvList+"]");
		System.out.println("mischdrMap---->>["+mischdrMap+"]");
		System.out.println("miscAdvList---->>["+miscAdvList+"]");
		System.out.println("xtraParams---->>["+xtraParams+"]");
		PreparedStatement pstmt = null;
		PreparedStatement pstmtInner = null;
		ResultSet rs = null;
		ResultSet rsInner = null;
		String sql = "",sqlInner="";
		ConnDriver connDriver = null;
		String errString = "" ; 
//		GenericUtility genericUtility = null;
		ITMDBAccessEJB itmDBAccessEJB = null;
		FinCommon Fcommon = new FinCommon();
//		genericUtility = new GenericUtility();
		E12GenericUtility genericUtility = new E12GenericUtility();
		
		HashMap glTraceMap = null,acctMap = null,sundryBalMap = null,miscPayMap = null,detListMap = null;

		String empCodeAprv="",sundryCodePay="",sundryType="",sundryTypePay="",withHeld="",confirm="";
		String acctAp="",cctrAp="",vouchType="",refSer="",refNo="",status="",sundryCode="",detSundryType="";
		String acctCode="",cctrCode="",currCode="",sCode="",sType = "",rem="",hold="",rSer="",rId="";
		double advAdd=0,holdTax=0,exchH=0,andAmt=0,amtUpd=0,billAmt=0,taxAmt=0,exchD=0,acctAmt=0;
		double adjAmt=0,drAmt=0,glDrAmt=0,crAmt=0,glCrAmt=0,acctDrAmt=0,acctCrAmt=0,amount=0,adj=0,rndAmt=0;
		double glTCrAmt=0,gCrAmt=0,gDrAmt=0,glTDrAmt=0,acAmt=0,acDrAmt=0,acCrAmt=0,roundAmt=0,holdAmt=0;
		double netAmt=0,totAmt=0,diffAmt=0,diffDrAmt=0,diffCrAmt=0,advAmt=0,diffAmtExch=0;
		java.util.Date toDay = new java.util.Date();
		int count=0;
		double arAmt=0;
		//Added By Pavan R on 13/NOV/17 Start
		double lcTds = 0, lcSuppBillAmt = 0;
		//Added By Pavan R on 13/NOV/17 End
		
		try
		{
			empCodeAprv  = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			itmDBAccessEJB = new ITMDBAccessEJB();
			acctAp =(String)mischdrMap.get("acct_code__ap");
			cctrAp =(String)mischdrMap.get("cctr_code__ap");
			exchH =Double.parseDouble(mischdrMap.get("exch_rate").toString());
			rndAmt =Double.parseDouble(mischdrMap.get("rnd_amt").toString());
			advAmt =Double.parseDouble(mischdrMap.get("adv_amt").toString());
			diffAmtExch =Double.parseDouble(mischdrMap.get("diff_amt__exch").toString());
			vouchType = (String)mischdrMap.get("vouch_type");
			billAmt = Double.parseDouble(mischdrMap.get("bill_amt").toString());
			taxAmt = Double.parseDouble(mischdrMap.get("tax_amt").toString());
			
			if("A".equalsIgnoreCase(vouchType))
			{
				amtUpd = Double.parseDouble(mischdrMap.get("net_amt").toString());
			}
			else
			{
				sql =" select sum(tax_amt) as holdtax from taxtran "
					+" where tran_code = 'M-VOUC' and tran_id = ? and pay_tax = 'Y' "
					+"	and effect <> 'N' ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranId);
				rs = pstmt.executeQuery();
				if(rs.next())
				{     
					holdTax = rs.getDouble("holdtax");
				}
				rs.close();
				rs= null;
				pstmt.close();
				pstmt=null;
				
				amtUpd = billAmt + taxAmt - holdTax;
				//amtUpd = billAmt + holdTax;
				
			}
			//amtUpd
			glTraceMap = new HashMap();
			acctMap = new HashMap();
			sundryBalMap = new HashMap();
			miscPayMap = new HashMap();
			// added new 13-sep
			sql =" select count(1) from misc_vouchadv where tran_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{     
				count = rs.getInt(1);
			}
			rs.close();
			rs= null;
			pstmt.close();
			pstmt=null;
			
			for (int ctr =0; ctr < miscAdvList.size(); ctr++)
			{
				//added new @ 13-09-11
				if(count > 0)
				{
					detListMap = new HashMap();
					detListMap = (HashMap) miscAdvList.get(ctr);
					
					detSundryType = (String)detListMap.get("sundry_type");
					exchD =Double.parseDouble(detListMap.get("exch_rate__vouch").toString());
					acctCode =(String)detListMap.get("acct_code");
					cctrCode =(String)detListMap.get("cctr_code");
					adjAmt = Double.parseDouble(detListMap.get("adj_amt").toString());
					currCode = (String)detListMap.get("curr_code");
					refSer =(String)detListMap.get("ref_ser");
					refNo  =(String)detListMap.get("ref_no");
					
					if (!(((acctAp).equalsIgnoreCase(acctCode)) && ((cctrAp).equalsIgnoreCase(cctrCode)) && ((exchH == exchD))))
					{
						advAdd = advAdd + adjAmt;
						
						glTraceMap.put("tran_date",(mischdrMap.get("tran_date") == null ? "":mischdrMap.get("tran_date")));
						glTraceMap.put("eff_date",(mischdrMap.get("eff_date") == null ? "":mischdrMap.get("eff_date")));
						glTraceMap.put("fin_entity",(mischdrMap.get("fin_entity") == null ? "":mischdrMap.get("fin_entity")));
						glTraceMap.put("site_code",(mischdrMap.get("site_code") == null ? "":mischdrMap.get("site_code")));
						/*glTraceMap.put("sundry_type",(mischdrMap.get("sundry_type") == null ? "":mischdrMap.get("sundry_type")));
						glTraceMap.put("sundry_code",(mischdrMap.get("sundry_code") == null ? "":mischdrMap.get("sundry_code")));*/
						glTraceMap.put("sundry_type","");
						glTraceMap.put("sundry_code","");
						glTraceMap.put("acct_code",acctCode);
						glTraceMap.put("cctr_code",cctrCode);
						glTraceMap.put("emp_code",(mischdrMap.get("emp_code") == null ? "":mischdrMap.get("emp_code")));
						glTraceMap.put("anal_code","");
						glTraceMap.put("curr_code",currCode);
						glTraceMap.put("exch_rate",exchD);
						
						if(adjAmt > 0)
						{
							glTraceMap.put("dr_amt",Double.toString(adjAmt));
							glTraceMap.put("cr_amt","0");
							glDrAmt =Double.parseDouble(glTraceMap.get("dr_amt").toString());
							drAmt = drAmt + glDrAmt;
						}
						else
						{
							glTraceMap.put("dr_amt","0");
							glTraceMap.put("cr_amt",Double.toString(0 - adjAmt));
							glCrAmt =Double.parseDouble(glTraceMap.get("cr_amt").toString());
							crAmt = crAmt + glCrAmt;
						}
						glTraceMap.put("ref_type","F");
						glTraceMap.put("ref_ser","M-VOUC");
						glTraceMap.put("ref_id",tranId);
						glTraceMap.put("remarks",(mischdrMap.get("remarks") == null ? "":mischdrMap.get("remarks")));
						glTraceMap.put("proj_code",(mischdrMap.get("proj_code") == null ? "":mischdrMap.get("proj_code")));
						rSer = (String)glTraceMap.get("ref_ser");
						rId = (String)glTraceMap.get("ref_id");
						glTraceMap.put("party_doc_ref",Fcommon.gfGetPartyDocRef(rSer,rId,conn));
						
						errString = Fcommon.glTraceUpdate(glTraceMap,conn);
						if(errString != null && errString.trim().length() > 0)
						{
							return errString;
						}
						
						acctDrAmt = Double.parseDouble(glTraceMap.get("dr_amt").toString()); 
						acctCrAmt = Double.parseDouble(glTraceMap.get("cr_amt").toString());
						acctAmt = acctDrAmt - acctCrAmt;
						
						acctMap.put("tran_id",(glTraceMap.get("ref_id") == null ? "":glTraceMap.get("ref_id")));
						acctMap.put("acct_code",(glTraceMap.get("acct_code") == null ? "":glTraceMap.get("acct_code")));
						acctMap.put("cctr_code",(glTraceMap.get("cctr_code") == null ? "":glTraceMap.get("cctr_code")));
						acctMap.put("emp_code",(glTraceMap.get("emp_code") == null ? "":glTraceMap.get("emp_code")));
						acctMap.put("anal_code",(glTraceMap.get("anal_code") == null ? "":glTraceMap.get("anal_code")));
						acctMap.put("sundry_type",(glTraceMap.get("sundry_type") == null ? "":glTraceMap.get("sundry_type")));
						acctMap.put("sundry_code",(glTraceMap.get("sundry_code") == null ? "":glTraceMap.get("sundry_code")));
						acctMap.put("remarks",(glTraceMap.get("remarks") == null ? "":glTraceMap.get("remarks")));
						acctMap.put("curr_code",(glTraceMap.get("curr_code") == null ? "":glTraceMap.get("curr_code")));
						acctMap.put("exch_rate",(glTraceMap.get("exch_rate") == null ? "":glTraceMap.get("exch_rate")));
						acctMap.put("amount",acctAmt);
						
						errString = this.gbfAcctInsert(acctMap,conn);
						
						if(errString != null && errString.trim().length() > 0)
						{
							return errString;
						}
						/*
						if(!("O".equalsIgnoreCase((String)glTraceMap.get("sundry_type"))))
						{
							sundryBalMap.put("tran_date",mischdrMap.get("tran_date"));
							sundryBalMap.put("eff_date ",mischdrMap.get("eff_date"));
							sundryBalMap.put("fin_entity",mischdrMap.get("fin_entity"));
							sundryBalMap.put("site_code",mischdrMap.get("site_code"));
							sundryBalMap.put("sundry_type",mischdrMap.get("sundry_type"));
							sundryBalMap.put("sundry_code",mischdrMap.get("sundry_code"));
							sundryBalMap.put("acct_code",acctCode);
							sundryBalMap.put("cctr_code",cctrCode);
							sundryBalMap.put("curr_code ",mischdrMap.get("curr_code"));
							sundryBalMap.put("exch_rate",exchD);
							if(adjAmt > 0)
							{
								sundryBalMap.put("dr_amt",Double.toString(adjAmt));
								sundryBalMap.put("cr_amt","0");
							}
							else
							{
								sundryBalMap.put("dr_amt","0");
								sundryBalMap.put("cr_amt",Double.toString(0 - adjAmt));
							}
							sundryBalMap.put("adv_amt",adjAmt);
							sType = (String)sundryBalMap.get("sundry_type");
							sCode = (String)sundryBalMap.get("sundry_code");
							if(sType != null)
							{
								sundryBalMap.put("contact_code",Fcommon.getContactCode(sType,sCode,conn));
							}
							else
							{
								sundryBalMap.put("contact_code","");
							}
							errString = Fcommon.gbf_sundrybal_upd(sundryBalMap,conn);	
							if(errString != null && errString.trim().length() > 0)
							{
								return errString;
							}
						}*/
					} //end if
				}
				sql =" select tot_amt,adj_amt from misc_payables where tran_ser =? and ref_no = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,refSer);
				pstmt.setString(2,refNo);
				rs = pstmt.executeQuery();
				if(rs.next())
				{     
					amount = rs.getDouble("tot_amt");
					adj = rs.getDouble("adj_amt");
				}
				rs.close();
				rs= null;
				pstmt.close();
				pstmt=null;
				
				if(Math.abs(amount-adj) < Math.abs(adjAmt))
				{
					errString = itmDBAccessEJB.getErrorString("","VTIBAL1","","",conn);
					return errString;
				}
				
				adj = adj + adjAmt;
				if (amount == adj)
				{
					status = "A";
				}
				else
				{
					status = "P";
				}
				
				sql =" update misc_payables set adj_amt = adj_amt + "+adjAmt+", status = ?,status_date =? "
					+" where tran_ser =? and ref_no =? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,status);
				pstmt.setTimestamp(2,new Timestamp(System.currentTimeMillis()));
				pstmt.setString(3,refSer);
				pstmt.setString(4,refNo);
				int upd = pstmt.executeUpdate();
				pstmt.close();
				pstmt = null;
				System.out.println(">>>>>::Ref_Ser["+refSer+"]Ref_No["+refNo+"]");
			}//for end
			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}
			amtUpd = amtUpd + advAdd;
					
			glTraceMap.put("tran_date",(mischdrMap.get("tran_date") == null ? "":mischdrMap.get("tran_date")));
			glTraceMap.put("eff_date",(mischdrMap.get("eff_date") == null ? "":mischdrMap.get("eff_date")));
			glTraceMap.put("fin_entity",(mischdrMap.get("fin_entity") == null ? "":mischdrMap.get("fin_entity")));
			glTraceMap.put("site_code",(mischdrMap.get("site_code") == null ? "":mischdrMap.get("site_code")));
			glTraceMap.put("sundry_type",(mischdrMap.get("sundry_type") == null ? "":mischdrMap.get("sundry_type")));
			glTraceMap.put("sundry_code",(mischdrMap.get("sundry_code") == null ? "":mischdrMap.get("sundry_code")));
			glTraceMap.put("acct_code",(mischdrMap.get("acct_code__ap") == null ? "":mischdrMap.get("acct_code__ap")));
			glTraceMap.put("cctr_code",(mischdrMap.get("cctr_code__ap") == null ? " ":mischdrMap.get("cctr_code__ap")));
			glTraceMap.put("emp_code",(mischdrMap.get("emp_code") == null ? "":mischdrMap.get("emp_code")));
			glTraceMap.put("anal_code",(mischdrMap.get("anal_code") == null ? "":mischdrMap.get("anal_code")));
			glTraceMap.put("curr_code",(mischdrMap.get("curr_code") == null ? "":mischdrMap.get("curr_code")));
			glTraceMap.put("exch_rate",(mischdrMap.get("exch_rate") == null ? "":mischdrMap.get("exch_rate")));
			if(amtUpd > 0)
			{
				glTraceMap.put("dr_amt","0");
				glTraceMap.put("cr_amt",Double.toString(amtUpd + rndAmt));
				glTCrAmt = Double.parseDouble(glTraceMap.get("cr_amt").toString());
				gCrAmt = gCrAmt +glTCrAmt;
			}
			else
			{
				glTraceMap.put("dr_amt",Double.toString(0 - (amtUpd + rndAmt)));
				glTraceMap.put("cr_amt","0");
				glTDrAmt = Double.parseDouble(glTraceMap.get("dr_amt").toString());
				gDrAmt = gDrAmt +glTDrAmt;
			}
			glTraceMap.put("ref_type","F");
			glTraceMap.put("ref_ser","M-VOUC");
			glTraceMap.put("ref_id",tranId);
			glTraceMap.put("remarks",(mischdrMap.get("remarks") == null ? "":mischdrMap.get("remarks")));
			glTraceMap.put("proj_code",(mischdrMap.get("proj_code") == null ? "":mischdrMap.get("proj_code")));
			rSer = (String)glTraceMap.get("ref_ser");
			rId = (String)glTraceMap.get("ref_id");
			glTraceMap.put("party_doc_ref",Fcommon.gfGetPartyDocRef(rSer,rId,conn));
			
			errString = Fcommon.glTraceUpdate(glTraceMap,conn);
			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}
			
			acctDrAmt = Double.parseDouble(glTraceMap.get("dr_amt").toString()); 
			acctCrAmt = Double.parseDouble(glTraceMap.get("cr_amt").toString());
			acAmt = acDrAmt - acCrAmt;
			
			acctMap.put("tran_id",(glTraceMap.get("ref_id") == null ? "":glTraceMap.get("ref_id")));
			acctMap.put("acct_code",(glTraceMap.get("acct_code") == null ? "":glTraceMap.get("acct_code")));
			acctMap.put("cctr_code",(glTraceMap.get("cctr_code") == null ? "":glTraceMap.get("cctr_code")));
			acctMap.put("emp_code",(glTraceMap.get("emp_code") == null ? "":glTraceMap.get("emp_code")));
			acctMap.put("anal_code",(glTraceMap.get("anal_code") == null ? "":glTraceMap.get("anal_code")));
			acctMap.put("sundry_type",(glTraceMap.get("sundry_type") == null ? "":glTraceMap.get("sundry_type")));
			acctMap.put("sundry_code",(glTraceMap.get("sundry_code") == null ? "":glTraceMap.get("sundry_code")));
			acctMap.put("remarks",(glTraceMap.get("remarks") == null ? "":glTraceMap.get("remarks")));
			acctMap.put("curr_code",(glTraceMap.get("curr_code") == null ? "":glTraceMap.get("curr_code")));
			acctMap.put("exch_rate",(glTraceMap.get("exch_rate") == null ? "":glTraceMap.get("exch_rate")));
			acctMap.put("amount",acAmt);
			
			errString = this.gbfAcctInsert(acctMap,conn);
			
			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}
			if(!("O".equalsIgnoreCase((String)glTraceMap.get("sundry_type"))))
			{
				sundryBalMap.put("tran_date",mischdrMap.get("tran_date"));
				sundryBalMap.put("eff_date ",mischdrMap.get("eff_date"));
				sundryBalMap.put("fin_entity",mischdrMap.get("fin_entity"));
				sundryBalMap.put("site_code",mischdrMap.get("site_code"));
				sundryBalMap.put("sundry_type",mischdrMap.get("sundry_type"));
				sundryBalMap.put("sundry_code",mischdrMap.get("sundry_code"));
				sundryBalMap.put("acct_code",mischdrMap.get("acct_code__ap"));
				sundryBalMap.put("cctr_code",mischdrMap.get("cctr_code__ap"));
				sundryBalMap.put("curr_code",mischdrMap.get("curr_code"));
				sundryBalMap.put("exch_rate",mischdrMap.get("exch_rate"));
				if(amtUpd > 0)
				{
					crAmt = amtUpd+rndAmt;
					drAmt = 0;
				}
				else
				{
					drAmt = (0- (amtUpd+rndAmt));
					crAmt = 0;
				}
				
				sundryBalMap.put("dr_amt",drAmt);
				sundryBalMap.put("cr_amt",crAmt);
				
				sundryBalMap.put("adv_amt",0.0);
				sType = (String)sundryBalMap.get("sundry_type");
				sCode = (String)sundryBalMap.get("sundry_code");
				if(sType != null)
				{
					sundryBalMap.put("contact_code",Fcommon.getContactCode(sType,sCode,conn));
				}
				else
				{
					sundryBalMap.put("contact_code","");
				}
				errString = Fcommon.gbf_sundrybal_upd(sundryBalMap,conn);	
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
			}
			
			sundryCode =(String)mischdrMap.get("sundry_code");
			sundryCodePay =(String)mischdrMap.get("sundry_code__pay");
			sundryType =(String)mischdrMap.get("sundry_type");
			sundryTypePay =(String)mischdrMap.get("sundry_type__pay");
			
			if(!((sundryCode.equalsIgnoreCase(sundryCodePay)) ||(sundryType.equalsIgnoreCase(sundryTypePay))))
			{
				rem = "liability transfered to " + sundryCodePay;
				glTraceMap.put("sundry_type",(mischdrMap.get("sundry_type") == null ? "":mischdrMap.get("sundry_type")));
				glTraceMap.put("sundry_code",(mischdrMap.get("sundry_code") == null ? "":mischdrMap.get("sundry_code")));
				glTraceMap.put("acct_code",(mischdrMap.get("acct_code__ap") == null ? "":mischdrMap.get("acct_code__ap")));
				glTraceMap.put("cctr_code",(mischdrMap.get("cctr_code__ap") == null ? " ":mischdrMap.get("cctr_code__ap")));
				glTraceMap.put("remarks",rem);
			
				if(amtUpd > 0)
				{
					glTraceMap.put("dr_amt",Math.abs(amtUpd));
					glTraceMap.put("cr_amt","0");
				}
				else
				{
					glTraceMap.put("dr_amt","0");
					glTraceMap.put("cr_amt",Math.abs(amtUpd));
				}
				
				errString = Fcommon.glTraceUpdate(glTraceMap,conn);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
				
				acctMap.put("sundry_code",(glTraceMap.get("sundry_code") == null ? "":glTraceMap.get("sundry_code")));
				acctMap.put("remarks",(glTraceMap.get("remarks") == null ? "":glTraceMap.get("remarks")));
				acctMap.put("acct_code",(glTraceMap.get("acct_code") == null ? "":glTraceMap.get("acct_code")));
				acctMap.put("cctr_code",(glTraceMap.get("cctr_code") == null ? "":glTraceMap.get("cctr_code")));
			
				errString = this.gbfAcctInsert(acctMap,conn);
				
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
			
				// .. gltrace effect for sundry_code__pay
				rem = "liability transfered to " + sundryCode;
				glTraceMap.put("sundry_type",(mischdrMap.get("sundry_type__pay") == null ? "":mischdrMap.get("sundry_type__pay")));
				glTraceMap.put("sundry_code",(mischdrMap.get("sundry_code__pay") == null ? "":mischdrMap.get("sundry_code__pay")));
				glTraceMap.put("acct_code",(mischdrMap.get("acct_code__pay") == null ? "":mischdrMap.get("acct_code__pay")));
				glTraceMap.put("cctr_code",(mischdrMap.get("cctr_code__pay") == null ? " ":mischdrMap.get("cctr_code__pay")));
				glTraceMap.put("remarks",rem);
			
				if(amtUpd > 0)
				{
					glTraceMap.put("cr_amt",Math.abs(amtUpd));
					glTraceMap.put("dr_amt","0");
				}
				else
				{
					glTraceMap.put("cr_amt","0");
					glTraceMap.put("dr_amt",Math.abs(amtUpd));
				}
				glTraceMap.put("proj_code",(mischdrMap.get("proj_code") == null ? "":mischdrMap.get("proj_code")));
				
				errString = Fcommon.glTraceUpdate(glTraceMap,conn);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
				acctMap.put("sundry_code",(glTraceMap.get("sundry_code") == null ? "":glTraceMap.get("sundry_code")));
				acctMap.put("remarks",(glTraceMap.get("remarks") == null ? "":glTraceMap.get("remarks")));
				acctMap.put("acct_code",(glTraceMap.get("acct_code") == null ? "":glTraceMap.get("acct_code")));
				acctMap.put("cctr_code",(glTraceMap.get("cctr_code") == null ? "":glTraceMap.get("cctr_code")));
			
				errString = this.gbfAcctInsert(acctMap,conn);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
				
				if(!("O".equalsIgnoreCase((String)glTraceMap.get("sundry_type"))))
				{
					if(amtUpd > 0)
					{
						drAmt = amtUpd;
						crAmt = 0;
					}
					else
					{
						drAmt = 0;
						crAmt = amtUpd;
					}
					
					sundryBalMap.put("dr_amt",drAmt);
					sundryBalMap.put("cr_amt",crAmt);
					sundryBalMap.put("sundry_type",mischdrMap.get("sundry_type"));
					sundryBalMap.put("sundry_code",mischdrMap.get("sundry_code"));
					sundryBalMap.put("acct_code",mischdrMap.get("acct_code__ap"));
					sundryBalMap.put("cctr_code",mischdrMap.get("cctr_code__ap"));
					sundryBalMap.put("curr_code",mischdrMap.get("curr_code"));
					sType = (String)sundryBalMap.get("sundry_type");
					sCode = (String)sundryBalMap.get("sundry_code");
					if(sType != null)
					{
						sundryBalMap.put("contact_code",Fcommon.getContactCode(sType,sCode,conn));
					}
					else
					{
						sundryBalMap.put("contact_code","");
					}
				
					errString = Fcommon.gbf_sundrybal_upd(sundryBalMap,conn);	
					
					if(errString != null && errString.trim().length() > 0)
					{
						return errString;
					}
					if(amtUpd > 0)
					{
						drAmt = 0;
						crAmt = amtUpd+roundAmt;
					}
					else
					{
						drAmt = amtUpd+roundAmt;
						crAmt = 0;
					}
					
					sundryBalMap.put("dr_amt",drAmt);
					sundryBalMap.put("cr_amt",crAmt);
					sundryBalMap.put("sundry_type",mischdrMap.get("sundry_type__pay"));
					sundryBalMap.put("sundry_code",mischdrMap.get("sundry_code__pay"));
					sundryBalMap.put("acct_code",mischdrMap.get("acct_code__pay"));
					sundryBalMap.put("cctr_code",mischdrMap.get("cctr_code__pay"));
					sundryBalMap.put("curr_code",mischdrMap.get("curr_code"));
					sType = (String)sundryBalMap.get("sundry_type");
					sCode = (String)sundryBalMap.get("sundry_code");
					if(sType != null)
					{
						sundryBalMap.put("contact_code",Fcommon.getContactCode(sType,sCode,conn));
					}
					else
					{
						sundryBalMap.put("contact_code","");
					}
	
					errString = Fcommon.gbf_sundrybal_upd(sundryBalMap,conn);	
					if(errString != null && errString.trim().length() > 0)
					{
						return errString;
					}
				}
			} //end if sundrycodepay
			
			//commented as not required
			if( holdTax != 0 )
			{
				glTraceMap.put("tran_date",(mischdrMap.get("tran_date") == null ? "":mischdrMap.get("tran_date")));
				glTraceMap.put("eff_date",(mischdrMap.get("eff_date") == null ? "":mischdrMap.get("eff_date")));
				glTraceMap.put("fin_entity",(mischdrMap.get("fin_entity") == null ? "":mischdrMap.get("fin_entity")));
				glTraceMap.put("site_code",(mischdrMap.get("site_code") == null ? "":mischdrMap.get("site_code")));
				glTraceMap.put("sundry_type",(mischdrMap.get("sundry_type__pay") == null ? "":mischdrMap.get("sundry_type__pay")));
				glTraceMap.put("sundry_code",(mischdrMap.get("sundry_code__pay") == null ? "":mischdrMap.get("sundry_code__pay")));
				glTraceMap.put("acct_code",(mischdrMap.get("acct_code__ap") == null ? "":mischdrMap.get("acct_code__ap")));
				glTraceMap.put("cctr_code",(mischdrMap.get("cctr_code__ap") == null ? " ":mischdrMap.get("cctr_code__ap")));
				glTraceMap.put("emp_code",(mischdrMap.get("emp_code") == null ? "":mischdrMap.get("emp_code")));
				glTraceMap.put("anal_code",(mischdrMap.get("anal_code") == null ? "":mischdrMap.get("anal_code")));
				glTraceMap.put("curr_code",(mischdrMap.get("curr_code") == null ? "":mischdrMap.get("curr_code")));
				glTraceMap.put("exch_rate",(mischdrMap.get("exch_rate") == null ? "":mischdrMap.get("exch_rate")));
				if(holdTax > 0)
				{
					glTraceMap.put("dr_amt","0");
					glTraceMap.put("cr_amt",Double.toString(holdTax + roundAmt));
					glTCrAmt = Double.parseDouble(glTraceMap.get("cr_amt").toString());
					gCrAmt = gCrAmt +glTCrAmt;
				}
				else
				{
					glTraceMap.put("dr_amt",Double.toString(0 - (holdTax + roundAmt)));
					glTraceMap.put("cr_amt","0");
					glTDrAmt = Double.parseDouble(glTraceMap.get("dr_amt").toString());
					gDrAmt = gDrAmt +glTDrAmt;
				}
				glTraceMap.put("ref_type","F");
				glTraceMap.put("ref_ser","M-VOUC");
				glTraceMap.put("ref_id",tranId);
				glTraceMap.put("remarks",(mischdrMap.get("remarks") == null ? "":mischdrMap.get("remarks")));
				glTraceMap.put("proj_code",(mischdrMap.get("proj_code") == null ? "":mischdrMap.get("proj_code")));
				rSer = (String)glTraceMap.get("ref_ser");
				rId = (String)glTraceMap.get("ref_id");
				glTraceMap.put("party_doc_ref",Fcommon.gfGetPartyDocRef(rSer,rId,conn));	
				errString = Fcommon.glTraceUpdate(glTraceMap,conn);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
				
				acctDrAmt = Double.parseDouble(glTraceMap.get("dr_amt").toString()); 
				acctCrAmt = Double.parseDouble(glTraceMap.get("cr_amt").toString());
				acAmt = acDrAmt - acCrAmt;
				
				acctMap.put("tran_id",(glTraceMap.get("ref_id") == null ? "":glTraceMap.get("ref_id")));
				acctMap.put("acct_code",(glTraceMap.get("acct_code") == null ? "":glTraceMap.get("acct_code")));
				acctMap.put("cctr_code",(glTraceMap.get("cctr_code") == null ? "":glTraceMap.get("cctr_code")));
				acctMap.put("emp_code",(glTraceMap.get("emp_code") == null ? "":glTraceMap.get("emp_code")));
				acctMap.put("anal_code",(glTraceMap.get("anal_code") == null ? "":glTraceMap.get("anal_code")));
				acctMap.put("sundry_type",(glTraceMap.get("sundry_type") == null ? "":glTraceMap.get("sundry_type")));
				acctMap.put("sundry_code",(glTraceMap.get("sundry_code") == null ? "":glTraceMap.get("sundry_code")));
				acctMap.put("remarks",(glTraceMap.get("remarks") == null ? "":glTraceMap.get("remarks")));
				acctMap.put("curr_code",(glTraceMap.get("curr_code") == null ? "":glTraceMap.get("curr_code")));
				acctMap.put("exch_rate",(glTraceMap.get("exch_rate") == null ? "":glTraceMap.get("exch_rate")));
				acctMap.put("amount",acAmt);
				
				errString = this.gbfAcctInsert(acctMap,conn);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
				
				if(!("O".equalsIgnoreCase((String)glTraceMap.get("sundry_type"))))
				{
					sundryBalMap.put("tran_date",mischdrMap.get("tran_date"));
					sundryBalMap.put("eff_date ",mischdrMap.get("eff_date"));
					sundryBalMap.put("fin_entity",mischdrMap.get("fin_entity"));
					sundryBalMap.put("site_code",mischdrMap.get("site_code"));
					sundryBalMap.put("sundry_type",mischdrMap.get("sundry_type__pay"));
					sundryBalMap.put("sundry_code",mischdrMap.get("sundry_code__pay"));
					sundryBalMap.put("acct_code",mischdrMap.get("acct_code__ap"));
					sundryBalMap.put("cctr_code",mischdrMap.get("cctr_code__ap"));
					sundryBalMap.put("curr_code",mischdrMap.get("curr_code"));
					sundryBalMap.put("exch_rate",mischdrMap.get("exch_rate"));
					
					if(holdTax > 0)
					{
						drAmt = 0;
						crAmt = holdTax;
					}
					else
					{
						drAmt = (0-holdTax);
						crAmt = 0;
					}
					
					sundryBalMap.put("dr_amt",drAmt);
					sundryBalMap.put("cr_amt",crAmt);
					sundryBalMap.put("adv_amt",0.0);
					sType = (String)sundryBalMap.get("sundry_type");
					sCode = (String)sundryBalMap.get("sundry_code");
					if(sType != null)
					{
						sundryBalMap.put("contact_code",Fcommon.getContactCode(sType,sCode,conn));
					}
					else
					{
						sundryBalMap.put("contact_code","");
					}
					
					errString = Fcommon.gbf_sundrybal_upd(sundryBalMap,conn);	
					if(errString != null && errString.trim().length() > 0)
					{
						return errString;
					}
				}
			}  //end if holdTax 
			//end of comment
			
			sql = "select hold from misc_voucher where tran_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{     
				hold = rs.getString("hold");
			}
			rs.close();
			rs= null;
			pstmt.close();
			pstmt=null;
			
			if(hold == null)
			{
				hold = "N";
			}
			if("Y".equalsIgnoreCase(hold))
			{
				holdAmt = Double.parseDouble(mischdrMap.get("net_amt").toString());
			}
			else
			{
				holdAmt = 0;
			}
			// insert into misc_payables
			netAmt = Double.parseDouble(mischdrMap.get("net_amt").toString());
			totAmt = netAmt + rndAmt ;
			
			miscPayMap.put("tran_ser","M-VOUC");
			miscPayMap.put("tran_date",mischdrMap.get("tran_date"));
			miscPayMap.put("ref_no",tranId);
			miscPayMap.put("ref_date",mischdrMap.get("tran_date"));
			miscPayMap.put("bill_no",mischdrMap.get("bill_no"));
			miscPayMap.put("bill_date",mischdrMap.get("bill_date"));
			miscPayMap.put("curr_code",mischdrMap.get("curr_code"));
			miscPayMap.put("exch_rate",mischdrMap.get("exch_rate"));
			miscPayMap.put("sundry_type",mischdrMap.get("sundry_type__pay"));
			miscPayMap.put("sundry_code",mischdrMap.get("sundry_code__pay"));
			miscPayMap.put("acct_code",mischdrMap.get("acct_code__pay"));
			miscPayMap.put("cctr_code",mischdrMap.get("cctr_code__ap"));
			miscPayMap.put("due_date",mischdrMap.get("due_date"));
			miscPayMap.put("site_code",mischdrMap.get("site_code"));
			miscPayMap.put("fin_entity",mischdrMap.get("fin_entity"));
			miscPayMap.put("tot_amt",totAmt);
			miscPayMap.put("bank_code",mischdrMap.get("bank_code"));
			miscPayMap.put("auto_pay",mischdrMap.get("auto_pay"));
			miscPayMap.put("pay_mode",mischdrMap.get("pay_mode"));
			miscPayMap.put("paid","N");
			miscPayMap.put("adv_amt",advAmt);
			miscPayMap.put("entry_batch_no",mischdrMap.get("entry_batch_no"));
			
			//miscSType = ()
			if("E".equalsIgnoreCase(miscPayMap.get("sundry_type").toString()))
			{
				sql =" select with_held from employee where emp_code = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,(miscPayMap.get("sundry_code").toString()));
				rs = pstmt.executeQuery();
				if(rs.next())
				{     
					withHeld = rs.getString("with_held");
				}
				rs.close();
				rs= null;
				pstmt.close();
				pstmt=null;
				
				if(withHeld == null || withHeld.trim().length() == 0)
				{
					withHeld = " ";
				}
				if("Y".equalsIgnoreCase(withHeld))
				{
					miscPayMap.put("hold_amt",mischdrMap.get("net_amt"));
				}
				else
				{
					miscPayMap.put("hold_amt",holdAmt);
				}
			}
			else
			{
				miscPayMap.put("hold_amt",holdAmt);
			}
			
			if((String)mischdrMap.get("order_ref") != null)
			{
				miscPayMap.put("purc_order",(mischdrMap.get("order_ref").toString()).substring(0,10));
			}
			//Added By Pavan R on 13/NOV/17 Start to set supp_bill_amt, tds_amt in pay_ibca
			
			sql = "select supp_bill_amt as lc_supp_bill_amt from misc_voucher where tran_id = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);			
			rs = pstmt.executeQuery();
			if(rs.next())
			{     
				lcSuppBillAmt = rs.getDouble("lc_supp_bill_amt");
				System.out.println("lcSuppBillAmt["+lcSuppBillAmt+"]");
			}
			rs.close();
			rs= null;
			pstmt.close();
			pstmt=null;
			
			
			sql = "select sum(tax_amt) as lc_tds from taxtran where tran_code = 'M-VOUC' and tran_id = ? and pay_tax = 'Y'";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);	
			rs = pstmt.executeQuery();
			System.out.println("SQL["+sql+"]");
			if(rs.next())
			{     
				lcTds = rs.getDouble("lc_tds");
				System.out.println("lcTds::["+lcTds+"]");
			}
			rs.close();
			rs= null;
			pstmt.close();
			pstmt=null;
								
			miscPayMap.put("supp_bill_amt",String.valueOf(lcSuppBillAmt));
			miscPayMap.put("tds_amt",String.valueOf(lcTds));
			//Code add End By Pavan R on 13/NOV/17
			
			errString = Fcommon.gbfMiscPayUpd(miscPayMap,conn);	
			
			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}
			
			if(("A".equalsIgnoreCase(vouchType))&&(advAmt !=0))
			{
				holdAmt = 0 - holdAmt;
				miscPayMap.put("tran_ser","M-ADV");
				miscPayMap.put("tran_date",mischdrMap.get("tran_date"));
				miscPayMap.put("ref_no",tranId);
				miscPayMap.put("ref_date",mischdrMap.get("tran_date"));
				miscPayMap.put("bill_no",mischdrMap.get("bill_no"));
				miscPayMap.put("bill_date",mischdrMap.get("bill_date"));
				miscPayMap.put("curr_code",mischdrMap.get("curr_code"));
				miscPayMap.put("exch_rate",mischdrMap.get("exch_rate"));
				miscPayMap.put("sundry_type",mischdrMap.get("sundry_type"));
				miscPayMap.put("sundry_code",mischdrMap.get("sundry_code"));
				miscPayMap.put("acct_code",mischdrMap.get("acct_code__adv"));
				miscPayMap.put("cctr_code",mischdrMap.get("cctr_code__adv"));
				miscPayMap.put("due_date",mischdrMap.get("due_date"));
				miscPayMap.put("site_code",mischdrMap.get("site_code"));
				miscPayMap.put("fin_entity",mischdrMap.get("fin_entity"));
				miscPayMap.put("tot_amt",(0-advAmt));
				miscPayMap.put("bank_code",mischdrMap.get("bank_code"));
				miscPayMap.put("auto_pay",mischdrMap.get("auto_pay"));
				miscPayMap.put("pay_mode",mischdrMap.get("pay_mode"));
				miscPayMap.put("paid","N");
				miscPayMap.put("adv_amt",0);
				miscPayMap.put("hold_amt",mischdrMap.get("hold_amt"));
				//Added By Pavan R on 13/NOV/17 Start to set supp_bill_amt, tds_amt in pay_ibca
				
				sql = "select supp_bill_amt as lc_supp_bill_amt from misc_voucher where tran_id = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranId);			
				rs = pstmt.executeQuery();
				if(rs.next())
				{     
					lcSuppBillAmt = rs.getDouble("lc_supp_bill_amt");
					System.out.println("lcSuppBillAmt["+lcSuppBillAmt+"]");
				}
				rs.close();
				rs= null;
				pstmt.close();
				pstmt=null;
				
				
				sql = "select sum(tax_amt) as lc_tds from taxtran where tran_code = 'M-VOUC' and tran_id = ? and pay_tax = 'Y'";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranId);	
				rs = pstmt.executeQuery();
				System.out.println("SQL["+sql+"]");
				if(rs.next())
				{     
					lcTds = rs.getDouble("lc_tds");
					System.out.println("lcTds::["+lcTds+"]");
				}
				rs.close();
				rs= null;
				pstmt.close();
				pstmt=null;
									
				miscPayMap.put("supp_bill_amt",String.valueOf(lcSuppBillAmt));
				miscPayMap.put("tds_amt",String.valueOf(lcTds));
				//Code add End By Pavan R on 13/NOV/17
				
				errString = Fcommon.gbfMiscPayUpd(miscPayMap,conn);				
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
			}
			if(diffAmtExch != 0 )
			{
				glTraceMap.put("tran_date",(mischdrMap.get("tran_date") == null ? "":mischdrMap.get("tran_date")));
				glTraceMap.put("eff_date",(mischdrMap.get("eff_date") == null ? "":mischdrMap.get("eff_date")));
				glTraceMap.put("fin_entity",(mischdrMap.get("fin_entity") == null ? "":mischdrMap.get("fin_entity")));
				glTraceMap.put("site_code",(mischdrMap.get("site_code") == null ? "":mischdrMap.get("site_code")));
				glTraceMap.put("sundry_type","O");
				glTraceMap.put("sundry_code"," ");
				glTraceMap.put("acct_code",(mischdrMap.get("acct_code__cf") == null ? "":mischdrMap.get("acct_code__cf")));
				glTraceMap.put("cctr_code",(mischdrMap.get("cctr_code__cf") == null ? " ":mischdrMap.get("cctr_code__cf")));
				glTraceMap.put("emp_code","");
				glTraceMap.put("anal_code","");
				glTraceMap.put("curr_code",(mischdrMap.get("curr_code") == null ? "":mischdrMap.get("curr_code")));
				glTraceMap.put("exch_rate",1);
				if(diffAmtExch > 0)
				{
					glTraceMap.put("dr_amt","0");
					glTraceMap.put("cr_amt",Double.toString(diffAmtExch));
				}
				else
				{
					glTraceMap.put("dr_amt",Double.toString(0 - diffAmtExch));
					glTraceMap.put("cr_amt","0");
				}
				glTraceMap.put("ref_type","F");
				glTraceMap.put("ref_ser","M-VOUC");
				glTraceMap.put("ref_id",tranId);
				glTraceMap.put("remarks",(mischdrMap.get("remarks") == null ? "":mischdrMap.get("remarks")));
				glTraceMap.put("proj_code",(mischdrMap.get("proj_code") == null ? "":mischdrMap.get("proj_code")));
				rSer = (String)glTraceMap.get("ref_ser");
				rId = (String)glTraceMap.get("ref_id");
				glTraceMap.put("party_doc_ref",Fcommon.gfGetPartyDocRef(rSer,rId,conn));
				System.out.println(">>>>@2821::glTraceMap["+glTraceMap+"]");
				errString = Fcommon.glTraceUpdate(glTraceMap,conn);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
				
				diffDrAmt = Double.parseDouble(glTraceMap.get("dr_amt").toString()); 
				diffCrAmt = Double.parseDouble(glTraceMap.get("cr_amt").toString());
				diffAmt = diffDrAmt - diffCrAmt;
				
				acctMap.put("tran_id",(glTraceMap.get("ref_id") == null ? "":glTraceMap.get("ref_id")));
				acctMap.put("acct_code",(glTraceMap.get("acct_code") == null ? "":glTraceMap.get("acct_code")));
				acctMap.put("cctr_code",(glTraceMap.get("cctr_code") == null ? "":glTraceMap.get("cctr_code")));
				acctMap.put("emp_code",(glTraceMap.get("emp_code") == null ? "":glTraceMap.get("emp_code")));
				acctMap.put("anal_code",(glTraceMap.get("anal_code") == null ? "":glTraceMap.get("anal_code")));
				acctMap.put("sundry_type",(glTraceMap.get("sundry_type") == null ? "":glTraceMap.get("sundry_type")));
				acctMap.put("sundry_code",(glTraceMap.get("sundry_code") == null ? "":glTraceMap.get("sundry_code")));
				acctMap.put("remarks",(glTraceMap.get("remarks") == null ? "":glTraceMap.get("remarks")));
				acctMap.put("curr_code",(glTraceMap.get("curr_code") == null ? "":glTraceMap.get("curr_code")));
				acctMap.put("exch_rate",(glTraceMap.get("exch_rate") == null ? "":glTraceMap.get("exch_rate")));
				acctMap.put("amount",diffAmt);
				
				errString = this.gbfAcctInsert(acctMap,conn);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
			}
			
			confirm = (String)mischdrMap.get("confirmed");
			if (!("Y".equalsIgnoreCase(confirm)))
			{
				sql =" update misc_voucher set confirmed = 'Y' , "
					+" conf_date = ?, "
					+" emp_code__aprv = ? "
					+" where tran_id = ? " ;
				System.out.println("SQL : "+sql);
				pstmt = conn.prepareStatement(sql);
				pstmt.setTimestamp(1,new Timestamp(System.currentTimeMillis()));
				pstmt.setString(2,empCodeAprv);
				pstmt.setString(3,glTraceMap.get("ref_id").toString());
				int upd = pstmt.executeUpdate();
				pstmt.close();
				pstmt = null;
			}
		}// end of try
		catch(SQLException e)
		{
			System.out.println("Exception :MiscValConf :gbfPostMiscVouhdr :SQLException :==>\n"+e.getMessage());
			errString =  genericUtility.createErrorString(e);
			throw new ITMException(e);
		}		
		catch (Exception e)
		{
			System.out.println("Exception :MiscValConf :gbfPostMiscVouhdr :==>"+e.getMessage());
			errString = genericUtility.createErrorString(e);
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(rsInner != null)
				{
					rsInner.close();
					rsInner = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(pstmtInner != null)
				{
					pstmtInner.close();
					pstmtInner = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception : "+e);e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;
	}//method end
	
	private	String gbfPostMiscVoudet(String tranId,HashMap mischdrMap,ArrayList miscdetList,String xtraParams,Connection conn)throws RemoteException,ITMException
	{
		System.out.println("----------in Method gbfPostMiscVoudet---------------");
		System.out.println("mischdrMap----->["+mischdrMap+"]");
		System.out.println("miscdetList----->["+miscdetList+"]");
		System.out.println("xtraParams----->["+xtraParams+"]");
		PreparedStatement pstmt = null;
		PreparedStatement pstmtInner = null;
		ResultSet rs = null;
		ResultSet rsInner = null;
		String sql = "",sqlInner="";
		ConnDriver connDriver = null;
		String errString = "" ; 
//		GenericUtility genericUtility = null;
		ITMDBAccessEJB itmDBAccessEJB = null;
		FinCommon Fcommon = new FinCommon();
//		genericUtility = new GenericUtility();
		E12GenericUtility genericUtility = new E12GenericUtility();
		HashMap glTraceMap = null,acctMap = null,sundryBalMap = null,detListMap = null;
		double advAmt=0,taxTranAmt=0,amount=0,drAmt=0,glDrAmt=0,crAmt=0,glCrAmt=0,acctAmt=0,acctDrAmt=0;
		double acctCrAmt=0,tCrAmt=0,taxCrAmt=0,tDrAmt=0,taxDrAmt=0,taxAmt=0,totAmount =0;
		String lineNo="",acctCode="",vouchType="",acctCodeAdv="",cctrCode="",deptCode="",empCode="";
		String analCode="",remarks="",projCode="",sType="",sCode="",rSer="",rId="";
		String siteCode="",siteCodeFor="",acctCodePay="",cctrCodePay="",taxAcctCode="",taxCctrCode="";
		
		try
		{
			itmDBAccessEJB = new ITMDBAccessEJB();
			vouchType = (String)mischdrMap.get("vouch_type");
			acctCodeAdv = (String)mischdrMap.get("acct_code__adv");
			advAmt =Double.parseDouble(mischdrMap.get("adv_amt").toString());
			siteCode =(String)mischdrMap.get("site_code");
			
			glTraceMap = new HashMap();
			acctMap = new HashMap();
			sundryBalMap = new HashMap();
			
			//added by chandni - 12-SEP-11
			
			sql =" select site_code__for from misc_voucher where tran_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				siteCodeFor = rs.getString("site_code__for");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			if(siteCodeFor != null)
			{
				//validation If IBCA Payable master not defied for combination of Login site and Site_code__for
				sql =" select count(1) from ibca_pay_ctrl where site_code__from = ? and site_code__to = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,siteCode);
				pstmt.setString(2,siteCodeFor);
				rs = pstmt.executeQuery();
				if (rs.next())
				{
					int cnt = rs.getInt(1);
					if(cnt == 0)
					{
						errString = itmDBAccessEJB.getErrorString("","VTIBCA5","","",conn);
						return errString;
					}
				}
				rs.close();	
				rs = null;
				pstmt.close();
				pstmt = null;
			}
			sql =" select acct_code__pay,cctr_code__pay from ibca_pay_ctrl where site_code__from = ? and site_code__to = ? " ;
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,siteCode);
			pstmt.setString(2,siteCodeFor);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				acctCodePay = rs.getString("acct_code__pay");
				cctrCodePay = rs.getString("cctr_code__pay");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
					
			//added by chandni -end
			for (int ctr =0; ctr < miscdetList.size(); ctr++)
			{
				detListMap = new HashMap();
				detListMap = (HashMap) miscdetList.get(ctr);
				
				lineNo =(String)detListMap.get("line_no");
				taxAmt =Double.parseDouble(detListMap.get("tax_amt").toString());
				acctCode =(String)detListMap.get("acct_code");
				System.out.println("acctCode["+acctCode+"]");
				if(acctCode == null || acctCode.trim().length() == 0 )
				{
					acctCode=" ";
				}
				cctrCode =(String)detListMap.get("cctr_code");
				System.out.println("cctrCode["+cctrCode+"]");
				if(cctrCode == null || cctrCode.trim().length() == 0 )
				{
					cctrCode=" ";
				}
				deptCode =(String)detListMap.get("dept_code");
				empCode =(String)detListMap.get("emp_code");
				analCode =(String)detListMap.get("anal_code");
				remarks =(String)detListMap.get("remarks");
				projCode =(String)detListMap.get("proj_code");
				amount =Double.parseDouble(detListMap.get("amount").toString());
				System.out.println("amount is equal :::::"+amount);
				/***
				ls_lineno = right(space(3) + trim(string(li_lineno)), 3)
				***/
				sql =" select sum(amount) totamt from misc_vouchdet where tran_id = ? " ;
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranId);
				
				rs = pstmt.executeQuery();
				if(rs.next())
				{     
					totAmount = rs.getDouble("totamt");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				
				glTraceMap.put("tran_date",(mischdrMap.get("tran_date") == null ? "":mischdrMap.get("tran_date")));
				glTraceMap.put("eff_date",(mischdrMap.get("eff_date") == null ? "":mischdrMap.get("eff_date")));
				glTraceMap.put("fin_entity",(mischdrMap.get("fin_entity") == null ? "":mischdrMap.get("fin_entity")));
				glTraceMap.put("site_code",(mischdrMap.get("site_code") == null ? "":mischdrMap.get("site_code")));
				
				//added by chandni -12-SEP-11(accounting effect will change from normal migration,if site_code__for exist)
				if(siteCodeFor != null)
				{
					glTraceMap.put("sundry_type","");
					glTraceMap.put("sundry_code","");
					boolean flag = true ;
					
					sql =" select sum(tax_amt) taxtranamt,acct_code from taxtran where tran_code = 'M-VOUC' and tran_id =  ? "
						+" and effect <> 'N' group by acct_code";
					
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,tranId);
					rs = pstmt.executeQuery();
					
					while (rs.next())
					{     
						flag = false ;
						taxTranAmt = rs.getDouble("taxtranamt");
						taxAcctCode = rs.getString("acct_code");
						if (taxAcctCode == null)
						{
							double taxTotAmt = totAmount + taxTranAmt ;
						
							if (amount > 0)
							{
								//glTraceMap.put("dr_amt",Double.toString(amount - Math.abs(taxTranAmt)));			
								glTraceMap.put("dr_amt",Math.abs(taxTotAmt));
								glTraceMap.put("cr_amt","0");
							}
							else
							{
								glTraceMap.put("dr_amt","0");
								glTraceMap.put("cr_amt",Math.abs(taxTotAmt));
								//glTraceMap.put("cr_amt",Double.toString(0 - (amount - Math.abs(taxTranAmt))));					
							}
								
						}
						else
						{   
							if (amount > 0)
							{
								//glTraceMap.put("dr_amt",Double.toString(amount - Math.abs(taxTranAmt)));			
								glTraceMap.put("dr_amt",Math.abs(totAmount));
								glTraceMap.put("cr_amt","0");
							}
							else
							{
								glTraceMap.put("dr_amt","0");
								glTraceMap.put("cr_amt",Math.abs(totAmount));
								//glTraceMap.put("cr_amt",Double.toString(0 - (amount - Math.abs(taxTranAmt))));					
							}
						}
							
					}
					if (flag == true )
					{
						if (amount > 0)
						{
							//glTraceMap.put("dr_amt",Double.toString(amount - Math.abs(taxTranAmt)));			
							glTraceMap.put("dr_amt",Math.abs(totAmount));
							glTraceMap.put("cr_amt","0");
						}
						else
						{
							glTraceMap.put("dr_amt","0");
							glTraceMap.put("cr_amt",Math.abs(totAmount));
							//glTraceMap.put("cr_amt",Double.toString(0 - (amount - Math.abs(taxTranAmt))));					
						}
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
					glTraceMap.put("acct_code",acctCodePay);
					glTraceMap.put("cctr_code",cctrCodePay == null ? " ":cctrCodePay);
				
				}
				else
				{
					if(("A".equalsIgnoreCase(vouchType)) &&(advAmt != 0) &&((acctCode.trim().equalsIgnoreCase(acctCodeAdv.trim()))))
					{
						//Commented by Dadaso pawar on 27/08/2014 [START]
						//If voucher type "A" then in gltrace (account effect) sundry type and code not set)
						//glTraceMap.put("sundry_type","");
						//glTraceMap.put("sundry_code","");
						glTraceMap.put("sundry_type",mischdrMap.get("sundry_type"));
						glTraceMap.put("sundry_code",mischdrMap.get("sundry_code"));
						//Commented by Dadaso pawar on 27/08/2014 [END]
						
						if (amount > 0)
						{
							glTraceMap.put("dr_amt",Double.toString(amount - Math.abs(taxTranAmt)));			
							glTraceMap.put("cr_amt","0");
						}
						else
						{
							glTraceMap.put("dr_amt","0");
							glTraceMap.put("cr_amt",Double.toString(Math.abs(0 - (amount - Math.abs(taxTranAmt)))));					
						}
						glTraceMap.put("acct_code",acctCode);
						glTraceMap.put("anal_code","");
					}
					else
					{
						glTraceMap.put("sundry_type","O");
						glTraceMap.put("sundry_code","");
						
						if (amount > 0)
						{
							glTraceMap.put("dr_amt",Double.toString(amount));
							glTraceMap.put("cr_amt","0");
							glDrAmt =Double.parseDouble(glTraceMap.get("dr_amt").toString());
							drAmt = drAmt + glDrAmt;
						}
						else
						{
							glTraceMap.put("dr_amt","0");
							glTraceMap.put("cr_amt",Double.toString(0 - amount));
							glCrAmt =Double.parseDouble(glTraceMap.get("cr_amt").toString());
							crAmt = crAmt + glCrAmt;
						}
						glTraceMap.put("acct_code",acctCode);
					}
					glTraceMap.put("cctr_code",cctrCode == null ? " ":cctrCode);
					glTraceMap.put("anal_code",analCode == null ?"": analCode);
				}
				
				glTraceMap.put("dept_code",deptCode);
				glTraceMap.put("emp_code",empCode);
				//glTraceMap.put("anal_code",analCode == null ?"": analCode);
				glTraceMap.put("curr_code",(mischdrMap.get("curr_code") == null ? "":mischdrMap.get("curr_code")));
				glTraceMap.put("exch_rate",(mischdrMap.get("exch_rate") == null ? "":mischdrMap.get("exch_rate")));
				glTraceMap.put("ref_type","F");
				glTraceMap.put("ref_ser","M-VOUC");
				glTraceMap.put("ref_id",tranId);
				if(remarks == null || remarks.trim().length() == 0)
				{
					glTraceMap.put("remarks",(mischdrMap.get("remarks") == null ? "":mischdrMap.get("remarks")));
				}
				else
				{
					glTraceMap.put("remarks",remarks);
				}
				glTraceMap.put("proj_code",projCode);
				rSer = (String)glTraceMap.get("ref_ser");
				rId = (String)glTraceMap.get("ref_id");
				glTraceMap.put("party_doc_ref",Fcommon.gfGetPartyDocRef(rSer,rId,conn));
				System.out.println("printing gltrace :::::"+glTraceMap);
				errString = Fcommon.glTraceUpdate(glTraceMap,conn);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
				
				acctDrAmt = Double.parseDouble(glTraceMap.get("dr_amt").toString()); 
				acctCrAmt = Double.parseDouble(glTraceMap.get("cr_amt").toString());
				acctAmt = acctDrAmt - acctCrAmt;
				
				acctMap.put("tran_id",(glTraceMap.get("ref_id") == null ? "":glTraceMap.get("ref_id")));
				acctMap.put("acct_code",(glTraceMap.get("acct_code") == null ? "":glTraceMap.get("acct_code")));
				acctMap.put("cctr_code",(glTraceMap.get("cctr_code") == null ? "":glTraceMap.get("cctr_code")));
				acctMap.put("dept_code",(glTraceMap.get("dept_code") == null ? "":glTraceMap.get("dept_code")));
				acctMap.put("emp_code",(glTraceMap.get("emp_code") == null ? "":glTraceMap.get("emp_code")));
				acctMap.put("anal_code",(glTraceMap.get("anal_code") == null ? "":glTraceMap.get("anal_code")));
				acctMap.put("sundry_type",(glTraceMap.get("sundry_type") == null ? "":glTraceMap.get("sundry_type")));
				acctMap.put("sundry_code",(glTraceMap.get("sundry_code") == null ? "":glTraceMap.get("sundry_code")));
				acctMap.put("remarks",(glTraceMap.get("remarks") == null ? "":glTraceMap.get("remarks")));
				acctMap.put("curr_code",(glTraceMap.get("curr_code") == null ? "":glTraceMap.get("curr_code")));
				acctMap.put("exch_rate",(glTraceMap.get("exch_rate") == null ? "":glTraceMap.get("exch_rate")));
				acctMap.put("amount",acctAmt);
				
				errString = this.gbfAcctInsert(acctMap,conn);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
				//sql =" select sum(tax_amt) taxtranamt,acct_code from taxtran where tran_code = 'M-VOUC' and tran_id =  ? "
					//+" and pay_tax = 'Y' and effect <> 'N' group by acct_code";
				if(siteCodeFor != null)
				{
					sql =" select sum(tax_amt) taxtranamt,acct_code,cctr_code from taxtran where tran_code = 'M-VOUC' and tran_id =  ? "
						+" and effect <> 'N' group by acct_code,cctr_code";
				
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,tranId);
					rs = pstmt.executeQuery();
					while (rs.next())
					{     
						taxTranAmt = rs.getDouble("taxtranamt");
						taxAcctCode = rs.getString("acct_code");
						taxCctrCode = rs.getString("cctr_code");
						
						if( (taxTranAmt != 0) && (taxAcctCode != null))
						{
							glTraceMap.put("tran_date",(mischdrMap.get("tran_date") == null ? "":mischdrMap.get("tran_date")));
							glTraceMap.put("eff_date",(mischdrMap.get("eff_date") == null ? "":mischdrMap.get("eff_date")));
							glTraceMap.put("fin_entity",(mischdrMap.get("fin_entity") == null ? "":mischdrMap.get("fin_entity")));
							glTraceMap.put("site_code",(mischdrMap.get("site_code") == null ? "":mischdrMap.get("site_code")));
							glTraceMap.put("sundry_type","");
							glTraceMap.put("sundry_code","");
							
							if( taxTranAmt < 0 )
							{
								glTraceMap.put("dr_amt","0");
								glTraceMap.put("cr_amt",Double.toString(Math.abs(taxTranAmt)));
								taxCrAmt =Double.parseDouble(glTraceMap.get("cr_amt").toString());
								tCrAmt = tCrAmt + taxCrAmt;
							}
							else
							{
								glTraceMap.put("dr_amt",Double.toString(Math.abs(0 -taxTranAmt)));
								glTraceMap.put("cr_amt","0");
								taxDrAmt =Double.parseDouble(glTraceMap.get("cr_amt").toString());
								tDrAmt = tDrAmt + taxDrAmt;
							}
							
							glTraceMap.put("acct_code",taxAcctCode);
							glTraceMap.put("cctr_code",taxCctrCode == null ? " " : taxCctrCode);
							glTraceMap.put("dept_code",deptCode);
							glTraceMap.put("emp_code",(mischdrMap.get("emp_code") == null ? "":mischdrMap.get("emp_code")));
							glTraceMap.put("anal_code","");
							glTraceMap.put("curr_code",(mischdrMap.get("curr_code") == null ? "":mischdrMap.get("curr_code")));
							glTraceMap.put("exch_rate",(mischdrMap.get("exch_rate") == null ? "":mischdrMap.get("exch_rate")));
							glTraceMap.put("ref_type","F");
							glTraceMap.put("ref_ser","M-VOUC");
							glTraceMap.put("ref_id",tranId);
							glTraceMap.put("remarks",remarks);
							rSer = (String)glTraceMap.get("ref_ser");
							rId = (String)glTraceMap.get("ref_id");
							glTraceMap.put("party_doc_ref",Fcommon.gfGetPartyDocRef(rSer,rId,conn));
							
							errString = Fcommon.glTraceUpdate(glTraceMap,conn);
							if(errString != null && errString.trim().length() > 0)
							{
								return errString;
							}
							
							acctDrAmt = Double.parseDouble(glTraceMap.get("dr_amt").toString()); 
							acctCrAmt = Double.parseDouble(glTraceMap.get("cr_amt").toString());
							acctAmt = acctDrAmt - acctCrAmt;
							
							acctMap.put("tran_id",(glTraceMap.get("ref_id") == null ? "":glTraceMap.get("ref_id")));
							acctMap.put("acct_code",(glTraceMap.get("acct_code") == null ? "":glTraceMap.get("acct_code")));
							acctMap.put("cctr_code",(glTraceMap.get("cctr_code") == null ? "":glTraceMap.get("cctr_code")));
							acctMap.put("dept_code",(glTraceMap.get("dept_code") == null ? "":glTraceMap.get("dept_code")));
							acctMap.put("emp_code",(glTraceMap.get("emp_code") == null ? "":glTraceMap.get("emp_code")));
							acctMap.put("anal_code",(glTraceMap.get("anal_code") == null ? "":glTraceMap.get("anal_code")));
							acctMap.put("sundry_type",(glTraceMap.get("sundry_type") == null ? "":glTraceMap.get("sundry_type")));
							acctMap.put("sundry_code",(glTraceMap.get("sundry_code") == null ? "":glTraceMap.get("sundry_code")));
							acctMap.put("remarks",(glTraceMap.get("remarks") == null ? "":glTraceMap.get("remarks")));
							acctMap.put("curr_code",(glTraceMap.get("curr_code") == null ? "":glTraceMap.get("curr_code")));
							acctMap.put("exch_rate",(glTraceMap.get("exch_rate") == null ? "":glTraceMap.get("exch_rate")));
							acctMap.put("amount",acctAmt);
							
							errString = this.gbfAcctInsert(acctMap,conn);
							if(errString != null && errString.trim().length() > 0)
							{
								return errString;
							}
						}
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
				}
				if(("A".equalsIgnoreCase(vouchType)) &&(advAmt != 0) && (!("O".equalsIgnoreCase(glTraceMap.get("sundry_type").toString()))))
				{
					sundryBalMap.put("tran_date",mischdrMap.get("tran_date"));
					sundryBalMap.put("eff_date ",mischdrMap.get("eff_date"));
					sundryBalMap.put("fin_entity",mischdrMap.get("fin_entity"));
					sundryBalMap.put("site_code",mischdrMap.get("site_code"));
					sundryBalMap.put("sundry_type",glTraceMap.get("sundry_type"));
					sundryBalMap.put("sundry_code",glTraceMap.get("sundry_code"));
					sundryBalMap.put("acct_code",acctCode);
					sundryBalMap.put("cctr_code",cctrCode);
					String curcCodeac=mischdrMap.get("curr_code").toString();
					System.out.println("curcCode["+curcCodeac+"]");
					sundryBalMap.put("curr_code",curcCodeac);
					sundryBalMap.put("exch_rate",mischdrMap.get("exch_rate"));
					
					if(amount > 0)
					{
						drAmt = amount;
						crAmt = 0;
					}
					else
					{
						drAmt = 0;
						crAmt = (0-amount);
					}
					
					sundryBalMap.put("dr_amt",drAmt);
					sundryBalMap.put("cr_amt",crAmt);
					sundryBalMap.put("adv_amt",advAmt);
					sType = (String)sundryBalMap.get("sundry_type");
					sCode = (String)sundryBalMap.get("sundry_code");
					if(sType != null)
					{
						sundryBalMap.put("contact_code",Fcommon.getContactCode(sType,sCode,conn));
					}
					else
					{
						sundryBalMap.put("contact_code","");
					}
					System.out.println("sundryBalMap-->["+sundryBalMap+"]");
					errString = Fcommon.gbf_sundrybal_upd(sundryBalMap,conn);	
					if(errString != null && errString.trim().length() > 0)
					{
						return errString;
					}
				}
			} //end of for
		}// end of try
		
		catch(SQLException e)
		{
			System.out.println("Exception :MiscValConf :gbfPostMiscVoudet :SQLException :==>\n"+e.getMessage());
			errString = genericUtility.createErrorString(e);
			throw new ITMException(e);
		}
		catch (Exception e)
		{
			System.out.println("Exception :MiscValConf :gbfPostMiscVoudet :==>"+e.getMessage());
			errString = genericUtility.createErrorString(e);
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(rsInner != null)
				{
					rsInner.close();
					rsInner = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(pstmtInner != null)
				{
					pstmtInner.close();
					pstmtInner = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception : "+e);e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;
	}//method end
	
	String otherSitePostMiscVal(String tranId,HashMap mischdrMap,ArrayList miscdetList,String xtraParams,Connection conn)throws RemoteException,ITMException
	{
		System.out.println("--------------in method otherSitePostMiscVal------------");
		System.out.println("mischdrMap---->>["+mischdrMap+"]");
		System.out.println("miscdetList---->>["+miscdetList+"]");
		System.out.println("xtraParams---->>["+xtraParams+"]");
		PreparedStatement pstmt = null;
		PreparedStatement pstmtInner = null;
		
		ResultSet rs = null;
		ResultSet rsInner = null;
		
		String sql ="",sqlInner="";
		ConnDriver connDriver = null;
//		GenericUtility genericUtility = null;
		ITMDBAccessEJB itmDBAccessEJB = null;
		FinCommon Fcommon = new FinCommon();
		JvConfirm JvConf = new JvConfirm();
		SimpleDateFormat sdf = null;
		HashMap jMap=null,jdetMap=null;
		HashMap glTraceMap = null,sundryBalMap = null;
		ArrayList jdList = new ArrayList();	
		
		String errString =""; 
		
		java.util.Date toDate = new java.util.Date();
		java.sql.Timestamp toDay = null;
		java.sql.Timestamp tranDate = null;
		
		String empCodeAprv="",siteCode="",siteCodeFor="",acctCodeRcp="",cctrCodeRcp="",thisWin="",keyStr="",xmlString="";
		String tranIDSer="",FinEntitySite="",detAcctCode="",amountStr="",detCctrCode="",detEmpCode="";
		String detAnalCode="",detRemarks="",detProjCode="",detSundryType="",detDrcrFlag="";
		double detAmount=0,amount=0,totAmount=0;
		int ctr=0,cnt1=0;
		double detTotAmount=0,detTaxAmt=0;
		
		try
		{
			E12GenericUtility genericUtility = new E12GenericUtility();
//			genericUtility = new GenericUtility();
			empCodeAprv  = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			itmDBAccessEJB = new ITMDBAccessEJB();
			toDay =new java.sql.Timestamp(toDate.getTime());
			
			sql =" select site_code,site_code__for from misc_voucher where tran_id = ? ";
			pstmt =conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				siteCode = rs.getString("site_code");
				siteCodeFor = rs.getString("site_code__for");					
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt =null;
			
			sql =" select acct_code__rcp,cctr_code__rcp from ibca_pay_ctrl where site_code__from = ? and site_code__to = ? " ;
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,siteCode);
			pstmt.setString(2,siteCodeFor);
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				acctCodeRcp = rs.getString("acct_code__rcp");
				cctrCodeRcp = rs.getString("cctr_code__rcp");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			thisWin ="W_MISC_VOUCHER" ;
			sql =" select key_string from transetup where upper(tran_window) = ? ";
			pstmt =conn.prepareStatement(sql);
			pstmt.setString(1,thisWin);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				keyStr = rs.getString("key_string");					
			}
			else
			{
				thisWin ="GENERAL" ;
				sqlInner =" select key_string from transetup where upper(tran_window) = ? ";
				pstmtInner =conn.prepareStatement(sqlInner);
				pstmtInner.setString(1,thisWin);
				rsInner = pstmtInner.executeQuery();
				if(rsInner.next())
				{
					keyStr = rsInner.getString("key_string");
				}
				rsInner.close();
				rsInner = null;
				pstmtInner.close();
				pstmtInner =null;
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt =null;

			tranDate = (Timestamp)mischdrMap.get("tran_date");
			
			xmlString ="<?xml version=\"1.0\"?>\r\n<Root>\r\n<header>"+
                "\r\n</header><Detail1><item_ser></item_ser>"+
                "\r\n<site_code>"+siteCodeFor+"</site_code>\r\n<tran_date>"+sdf.format(new java.util.Date(tranDate.getTime()))+"</tran_date></Detail1></Root>";
			System.out.println("xmlString : : : : :"+xmlString);
			CommonConstants.setIBASEHOME();
			TransIDGenerator tg = new TransIDGenerator(xmlString,"Base",CommonConstants.DB_NAME);
			tranIDSer = tg.generateTranSeqID("M-VOUC","tran_id",keyStr,conn);
			
			System.out.println("Generated Key :: "+tranIDSer);
			if (tranIDSer.indexOf("ERROR") > -1 )
			{
				errString = itmDBAccessEJB.getErrorString("","VTTRANID","","",conn);
			}

			sql =" select fin_entity from site where site_code = ? ";
			pstmt =conn.prepareStatement(sql);
			pstmt.setString(1,siteCodeFor);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				FinEntitySite = rs.getString("fin_entity");					
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt =null;
					
			sql =" select sum(amount) from misc_vouchdet where tran_id = ? ";
			//sql =" select sum(amount - tax_amt) from misc_vouchdet where tran_id = ? ";
			
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				detAmount = rs.getDouble(1);
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;
			System.out.println("detAmount is equal :::"+detAmount);
			
			sql =" insert into journal "
				+" (tran_id, tran_date, eff_date, fin_entity, site_code, dr_amt, cr_amt , "
				+" remarks, reversible, status, confirmed, ref_ser, ref_no, curr_code, "
				+" tran_type, exch_rate, chg_date, chg_user, proj_code ) "
				+" values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,? )";
			System.out.println("SQL for journal insert :: "+sql);
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranIDSer); //new generated tranId
			pstmt.setTimestamp(2,tranDate);
			pstmt.setTimestamp(3,tranDate);
			pstmt.setString(4,FinEntitySite);
			pstmt.setString(5,siteCodeFor);
			pstmt.setDouble(6,detAmount); // set total amount of detail.
			pstmt.setDouble(7,detAmount);
			pstmt.setString(8,(String)mischdrMap.get("remarks"));
			pstmt.setString(9,"N");
			pstmt.setString(10,"V");
			pstmt.setString(11,"N");
			pstmt.setString(12,"JOUR");
			pstmt.setString(13,tranId); // ref_no as a original tran_id 
			pstmt.setString(14,(String)mischdrMap.get("curr_code"));
			pstmt.setString(15,(String)mischdrMap.get("tran_type"));
			pstmt.setDouble(16,Double.parseDouble(mischdrMap.get("exch_rate").toString()));
			pstmt.setTimestamp(17,toDay);
			pstmt.setString(18,empCodeAprv);
			pstmt.setString(19,(String)mischdrMap.get("proj_code"));
			pstmt.executeUpdate();
			pstmt.close();
			
			jMap = new HashMap();
			jMap.put("tran_type",(mischdrMap.get("tran_type") == null ? "":mischdrMap.get("tran_type")));
			jMap.put("tran_date",tranDate);
			jMap.put("eff_date",tranDate);
			jMap.put("site_code",siteCodeFor);
			jMap.put("fin_entity",FinEntitySite);
			jMap.put("ref_ser","JOUR");
			jMap.put("ref_no",tranId);
			jMap.put("reversible","N");
			//jMap.put("dr_amt",detAmount);
			//jMap.put("cr_amt",detAmount);
			jMap.put("dr_amt",Math.abs(detAmount));
			jMap.put("cr_amt",Math.abs(detAmount));
			jMap.put("curr_code",(mischdrMap.get("curr_code") == null ? "":mischdrMap.get("curr_code")));
			jMap.put("status","V");
			jMap.put("remarks",(mischdrMap.get("remarks") == null ? "":mischdrMap.get("remarks")));
			jMap.put("confirmed","N");
			jMap.put("exch_rate",(mischdrMap.get("exch_rate") == null ? "":mischdrMap.get("exch_rate")));
			
			sql =" insert into jourdet "
				+" (tran_id, line_no, sundry_type,sundry_code, acct_code,cctr_code, "
				+" drcr_flag, amount, emp_code, anal_code,remarks,proj_code ) "
				+" values(?,?,?,?,?,?,?,?,?,?,?,?)";
			
			pstmt = conn.prepareStatement(sql);
			
			sqlInner =" select acct_code,amount,cctr_code,emp_code,anal_code,remarks,proj_code,sundry_type__for,tax_amt "
			+" from misc_vouchdet where tran_id = ?" ;
			pstmtInner = conn.prepareStatement(sqlInner);
			pstmtInner.setString(1,tranId);
			rsInner = pstmtInner.executeQuery();
			while (rsInner.next())
			{
				detAcctCode = rsInner.getString("acct_code");
				amountStr = rsInner.getString("amount");
				detCctrCode =rsInner.getString("cctr_code");
				detEmpCode =rsInner.getString("emp_code");
				detAnalCode =rsInner.getString("anal_code");
				detRemarks =rsInner.getString("remarks");
				detProjCode = rsInner.getString("proj_code");
				detSundryType = rsInner.getString("sundry_type__for");
				detTaxAmt = rsInner.getDouble("tax_amt");
				/* calculating total amount*/
				amount = Double.parseDouble (amountStr);
				if(amount > 0)
				{
					detDrcrFlag= "D";
				}
				else
				{
					detDrcrFlag="C";
				}
				ctr++;
				//detTotAmount = amount - detTaxAmt;
				detTotAmount = amount + detTaxAmt;
				//totAmount = totAmount + detTotAmount ; 
				totAmount = totAmount + amount ; 
								
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranIDSer); // new generated tran_id
				pstmt.setInt(2,ctr);
				pstmt.setString(3,detSundryType);
				pstmt.setString(4,"");
				pstmt.setString(5,detAcctCode == null ?"":detAcctCode);
				if(detCctrCode == null)
				{
					pstmt.setString(6," ");
				}
				else
				{
					pstmt.setString(6,detCctrCode);
				}
				pstmt.setString(7,detDrcrFlag);
				//pstmt.setDouble(8,detTotAmount);
				pstmt.setDouble(8,amount);
				pstmt.setString(9,detEmpCode);
				pstmt.setString(10,detAnalCode);
				pstmt.setString(11,detRemarks);
				pstmt.setString(12,detProjCode);
				pstmt.addBatch();
				
				pstmt.executeBatch();
				pstmt.close();
							
				jdetMap = new HashMap();
				jdetMap.put("line_no",ctr);
				jdetMap.put("acct_code",detAcctCode == null ? "":detAcctCode);
				jdetMap.put("cctr_code",detCctrCode == null ? "":detCctrCode);
				jdetMap.put("drcr_flag",detDrcrFlag == null ? "":detDrcrFlag);
				//jdetMap.put("amount",amountStr);
				//jdetMap.put("amount",Double.toString(detTotAmount));
				jdetMap.put("amount",Double.toString(Math.abs(amount)));
				jdetMap.put("emp_code",detEmpCode);
				jdetMap.put("anal_code",detAnalCode == null ? "":detAnalCode);
				jdetMap.put("sundry_type",detSundryType == null ? "":detSundryType);
				jdetMap.put("sundry_code","");
				jdetMap.put("remarks",detRemarks);
				jdetMap.put("proj_code",(mischdrMap.get("proj_code") == null ? "":mischdrMap.get("proj_code")));
				
				jdList.add(jdetMap);
				
			}//end of while
			
			rsInner.close();
			rsInner = null;
			pstmtInner.close();
			pstmtInner = null;
			
			/* A/C effect for ibca-rcp acctcode with total amount */
			sql =" select count(1) from misc_vouchdet where tran_id = ? " ;
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				cnt1 = rs.getInt(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			if(cnt1 > 0)
			{
				if("C".equalsIgnoreCase(detDrcrFlag))
				{
					detDrcrFlag = "D";
				}
				else
				{
					detDrcrFlag = "C";
				}
				System.out.println("detDrcrFlag AFTER SWAP insert:: "+detDrcrFlag);
				cnt1++;
				sql =" insert into jourdet "
					+" ( tran_id, line_no, sundry_type,sundry_code, acct_code,cctr_code, "
					+" drcr_flag, amount, emp_code, anal_code,remarks,proj_code ) "
					+" values (?,?,?,?,?,?,?,?,?,?,?,?)";
				System.out.println(" SQL for jourdet insert with total amount:: "+sql);
								
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranIDSer); // new generated tran_id
				pstmt.setInt(2,cnt1);
				pstmt.setString(3,detSundryType == null ? "":detSundryType);
				pstmt.setString(4,"");
				pstmt.setString(5,acctCodeRcp == null ? "":acctCodeRcp);// IBCA-RCP ACCTCODE
				//pstmt.setString(6,detCctrCode);
				pstmt.setString(6,cctrCodeRcp == null ? "":cctrCodeRcp);
				pstmt.setString(7,detDrcrFlag == null ? "":detDrcrFlag);
				pstmt.setDouble(8,totAmount);
				pstmt.setString(9,(String)mischdrMap.get("emp_code"));
				pstmt.setString(10,(String)mischdrMap.get("anal_code"));
				pstmt.setString(11,detRemarks);
				pstmt.setString(12,(String)mischdrMap.get("proj_code"));
				pstmt.executeUpdate();
				pstmt.close();
				
				glTraceMap = new HashMap();	
				glTraceMap.put("tran_date",tranDate);
				glTraceMap.put("eff_date",(mischdrMap.get("eff_date") == null ? "":mischdrMap.get("eff_date")));
				glTraceMap.put("fin_entity",FinEntitySite);
				glTraceMap.put("site_code",siteCodeFor); // from header : siteCode
				//glTraceMap.put("sundry_type",detSundryType);
				glTraceMap.put("sundry_type","");
				glTraceMap.put("sundry_code","");
				glTraceMap.put("acct_code",acctCodeRcp); //ibca-pay acctcode
				//glTraceMap.put("cctr_code",detCctrCode);
				glTraceMap.put("cctr_code",cctrCodeRcp);
				glTraceMap.put("emp_code",detEmpCode);
				//glTraceMap.put("anal_code",detAnalCode);
				glTraceMap.put("anal_code","");
				glTraceMap.put("curr_code",(mischdrMap.get("curr_code") == null ? "":mischdrMap.get("curr_code")));
				glTraceMap.put("exch_rate",(mischdrMap.get("exch_rate") == null ? "":mischdrMap.get("exch_rate")));
				if ("D".equalsIgnoreCase (detDrcrFlag))
				{
					glTraceMap.put("dr_amt",Math.abs(totAmount));
					glTraceMap.put("cr_amt","0");
				}
				else
				{
					glTraceMap.put("dr_amt","0");
					glTraceMap.put("cr_amt",Math.abs(totAmount));
				}
				glTraceMap.put("ref_type","F");
				glTraceMap.put("ref_ser","JOUR");
				glTraceMap.put("ref_id",tranIDSer);
				glTraceMap.put("remarks","");
				glTraceMap.put("proj_code",detProjCode);
				
				errString = Fcommon.glTraceUpdate(glTraceMap,conn);
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
                }
			}
			/* accounting effect for site code for - auto generation site - end */
			/* in original tran id misc voucher set tran_id__gen = new created tran_id  */
			sql =" update misc_voucher "
				+" set tran_id__gen = ? "
				+" where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranIDSer);
				pstmt.setString(2,tranId);
				int updCnt = pstmt.executeUpdate();
				pstmt.close();
				pstmt = null;
		
			/*calling gbfPostJournal of JvConfirm - (Normal Posting) by passing tranIDSer - (new generated tran_id)*/
			errString = JvConf.gbfPostJournal(tranIDSer,jMap,jdList,xtraParams,conn);
			if(errString != null && errString.trim().length() > 0)
			{
				return errString;
			}
		
		} // end of try
		catch(SQLException e)
		{
			System.out.println("Exception :MiscValConf :otherSitePostJournal :SQLException :==>\n"+e.getMessage());
			errString = genericUtility.createErrorString(e);
			throw new ITMException(e);
		}		
		catch (Exception e)
		{
			System.out.println("Exception :MiscValConf :otherSitePostJournal :==>"+e.getMessage());
			errString = genericUtility.createErrorString(e);
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(rsInner != null)
				{
					rsInner.close();
					rsInner = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(pstmtInner != null)
				{
					pstmtInner.close();
					pstmtInner = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception : "+e);e.printStackTrace();
				throw new ITMException(e);
			}
		}	
		return errString;
	}
	private	String gbfAcctInsert(HashMap acctMap,Connection conn)throws RemoteException,ITMException
	{
		System.out.println("-----in method gbfAcctInsert----------");
		System.out.println("acctMap---->["+acctMap+"]");
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		ConnDriver connDriver = null;
		String errString = "" ; 
//		GenericUtility genericUtility = null;
		ITMDBAccessEJB itmDBAccessEJB = null;
			
		String errCode="",tranId = "";
		double amount=0;
		int lineNo=0;
		try
		{
			tranId = (String)acctMap.get("tran_id");
			amount = Double.parseDouble(acctMap.get("amount").toString());
				
			sql =" select max(line_no) line from misc_vouchacct where tran_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
            rs = pstmt.executeQuery();
            if(rs.next())
			{
                lineNo = rs.getInt("line");
            }
            rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			lineNo = lineNo +1 ;
			
			sql =" insert into misc_vouchacct (tran_id, line_no, acct_code, cctr_code,sundry_type, "
				+" sundry_code, emp_code, anal_code, amount,remarks, curr_code, exch_rate, dept_code) "
				+" values (?,?,?,?,?,?,?,?,?,?,?,?,?) ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranId);
				pstmt.setInt(2,lineNo);
				pstmt.setString(3,(String)acctMap.get("acct_code"));
				pstmt.setString(4,(String)acctMap.get("cctr_code"));
				pstmt.setString(5,(String)acctMap.get("sundry_type"));
				pstmt.setString(6,(String)acctMap.get("sundry_code"));
				pstmt.setString(7,(String)acctMap.get("emp_code"));
				pstmt.setString(8,(String)acctMap.get("anal_code"));
				pstmt.setDouble(9,amount);
				pstmt.setString(10,(String)acctMap.get("remarks"));
				pstmt.setString(11,(String)acctMap.get("curr_code"));
				pstmt.setDouble(12,Double.parseDouble(acctMap.get("exch_rate").toString()));
				pstmt.setString(13,(String)acctMap.get("dept_code"));
				int count = pstmt.executeUpdate();
				if(count < 1)
				{
					errCode = "DS000 : Insert Into misc_vouchacct Failed";
					return(errCode);
				}
				pstmt.close();pstmt = null;
				
		}// end of try
		catch(SQLException e)
		{
			System.out.println("Exception in gbfAcctInsert[MiscValConf]"+e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception t)
			{}
		}
		return errCode;
	}//method end
	
	// to create token for processing as array 
	private String[] string2StringArray(String str1 , String delimeter)
	{
		StringTokenizer st = new StringTokenizer(str1,delimeter);
		int count = st.countTokens() ;
		String[] arry1 = new String[count];
		int i =  0;
		while(st.hasMoreTokens()) 
		{
			arry1[i] = st.nextToken();
			System.out.print("Token "+i+" :["+arry1[i]+"]");
			i++;
		}
		System.out.println("");
		return arry1 ;	
	}
	private static double roundVal(double round, int scale) 
    {
        return Math.round(round * Math.pow(10, scale)) / Math.pow(10, scale);
    }

} //class
