package ibase.dashboard.hibernate.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.json.JSONException;
import org.json.JSONObject;

public class ActivityTime {

	private static final long serialVersionUID = 1L;
	
	long seconds = 0;
    long minutes = 0;
    long hours = 0;
	
    public ActivityTime()
    {
    	
    }
    
	public ActivityTime(String startTime, String endTime) 
	{
		 SimpleDateFormat format = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss.");
		 Date d1 = null;
         Date d2 = null;
         
         try 
         {
             d1 = format.parse(startTime);
             d2 = format.parse(endTime);
             long diff = d2.getTime() - d1.getTime();

             this.seconds = diff / 1000 % 60;
             this.minutes = diff / (60 * 1000) % 60;
             this.hours = diff / (60 * 60 * 1000);
             //System.out.println("diff: " + diff );
         } 
         catch (ParseException e) 
         {
             e.printStackTrace();
         }
         
         //System.out.println("Time in : " + this.seconds + " seconds.");
         //System.out.println("Time in : " + this.minutes + " minutes.");
         //System.out.println("Time in : " + this.hours + " hours.");
         
	}
	
	public ActivityTime(Date startTime, Date endTime) 
	{
         try 
         {
             long diff = endTime.getTime() - startTime.getTime();

             this.seconds = diff / 1000 % 60;
             this.minutes = diff / (60 * 1000) % 60;
             this.hours = diff / (60 * 60 * 1000);
             //System.out.println("diff: " + diff );
         } 
         catch (Exception e) 
         {
             e.printStackTrace();
         }
         
         //System.out.println("Time in : " + this.seconds + " seconds.");
         //System.out.println("Time in : " + this.minutes + " minutes.");
         //System.out.println("Time in : " + this.hours + " hours.");
         
	}
	
	public void addTime(ActivityTime time)
	{
		System.out.println("addTime :1:time[" + time + "]this[" + this + "]" ); 
		this.seconds = this.seconds + time.seconds;
		if(this.seconds > 59)
		{
			this.seconds = this.seconds % 60;
			long mins = this.seconds / 60;
			this.minutes = this.minutes + mins;
			System.out.println("this.seconds > 59 ::" + this.seconds ); 
		}
		
		this.minutes = this.minutes + time.minutes;
		if(this.minutes > 59)
		{
			this.minutes = this.minutes % 60;
			long hrs = this.minutes / 60;
			this.hours = this.hours + hrs;
			System.out.println("this.minutes > 59 ::" + this.minutes ); 
		}
		
		this.hours = this.hours + time.hours;
		if(this.hours >= 23) //Should not come here
		{
			System.out.println("this.hours >= 23 ::" + this.hours ); 
		}
		
		System.out.println("addTime :2:time[" + time + "]this[" + this + "]" ); 
	}
	
	public JSONObject toJSON()
	{
		JSONObject jObj = new JSONObject();
		try 
		{
			jObj.put("hours", this.hours);
			jObj.put("minutes", this.minutes);
			jObj.put("seconds", this.seconds);
		}
		catch (JSONException e) 
		{
			e.printStackTrace();
		}
		return jObj;
	}
	
	public String toString()
	{
		return this.toJSON().toString();
	}

}
