package ibase.dashboard.common.hibernate.dao;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import org.apache.commons.io.FileUtils;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.dashboard.common.hibernate.bean.Employee;
import ibase.dashboard.common.hibernate.bean.LoginTrace;
import ibase.dashboard.common.hibernate.bean.UserProfile;
import ibase.dashboard.common.hibernate.utility.HibernateUtil;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.dashboard.common.hibernate.utility.*;
//import jersey.repackaged.com.google.common.collect.Lists;

//6DBC5A495F0F2C5371D59DC89EB06F41
public class AccountActivityDao 
{
	private static String siteTranDB = "DEFAULT";
	private GenericUtil genUtil = new GenericUtil();

	/**
	 * @param  loginCode - user logged in code.
	 * @param  profileId -fetch from UserInfoBean
	 * @param  fromDate - from date user data shown(which can not be greater than to date)
	 * @param  toDate -till date user Data shown (which can not greater than todays date)
	 * @param  startBattery-
	 * @return the method returns Final user Activity data Depends on profile_id.
	 */
	public JSONObject getUserActivityData(String loginCode, String profileId,String fromDate,String toDate, int startBattery)throws Exception
	{
		System.out.println("getUserActivityData>>>");
		System.out.println("fromDate ["+fromDate+"] toDate ["+toDate+"]");
		JSONObject activityDataFinal = new JSONObject();
		JSONArray activityDataFinalArray = new JSONArray();
		profileId=profileId.trim();
		DateTimeFormatter formatter = DateTimeFormatter.ofPattern("YYYYMMdd");
		String today = LocalDate.now().format(formatter);
		System.out.println("today date ["+today+"]");
		String format="dd-MM-yy";
		String format1="YYYYMMdd";
		List<String> dateListQuery= genUtil.getDateList(fromDate,toDate,format);
		System.out.println("dateListQuery::::"+dateListQuery);
		List<String> dateListFile= genUtil.getDateList(fromDate,toDate,format1);
		
		System.out.println("dateListFile::::"+dateListFile);

		/* For ADMIN and ADM user all users data read */
		if( "ADMIN".equalsIgnoreCase(profileId) || "ADM".equalsIgnoreCase(profileId) )
		{
			System.out.println("Account activity for Admin");
			activityDataFinal=prepareAdminUserData(activityDataFinal,activityDataFinalArray,fromDate,toDate);
		}
		/* For Profile Ids except ADMIN and ADM */
		else
		{
			System.out.println("Account activity for user");
			activityDataFinal=prepareUserData(activityDataFinal,activityDataFinalArray,fromDate,toDate,loginCode,profileId,dateListFile);
		}
		return activityDataFinal;
	}

	/**
	 * @param  minMaxTimeList - minimum login and maximum logout time on the basis of date and user
	 * @param  minMaxBatteryStatus -minimum login battery status and maximum logout battery status on the basis of date and user
	 * @param  usersId - userId with date.
	 * @return If user activity file not Present 
	 */
	private JSONObject fileNotFoundUsers(JSONObject selfActivityData,HashMap<String, JSONObject> minMaxTimeList,HashMap<String, JSONObject> minMaxBatteryStatus,String usersId) throws JSONException {
		selfActivityData = getUserDetail(new JSONObject(), usersId);
		selfActivityData = checkUserForMinMaxTime(selfActivityData, minMaxTimeList,usersId) ;
		selfActivityData = checkUserForBatteryStatus(selfActivityData, minMaxBatteryStatus,usersId) ;					
	    return selfActivityData;
	}
	
	/**
	 * @param  fromDate - from date user data shown(which can not be greater than to date)
	 * @param  toDate -till date user Data shown (which can not greater than todays date)
	 * @param  userDataList - user list in non admin case.(In admin user list will null)
	 * @return the method returns Client app list, devicetype lis and os name list. 
	 */
	private JSONObject prepareDataForGraph(JSONObject activityData,String fromDate,String toDate,List<String> userDataList) throws JSONException {
		JSONArray deviceTypeList= getDeviceType(fromDate,toDate,userDataList);
		JSONObject clientAppList= getClientApp(activityData, fromDate,toDate,userDataList);
		JSONObject osNameList= getOsName(activityData, fromDate,toDate,userDataList);
		
		return activityData;
	}
	
	/**
	 * @param  fromDate - from date user data shown(which can not be greater than to date)
	 * @param  toDate -till date user Data shown (which can not greater than todays date)
	 * @return the method return fromDate to toDate user data form logintrace user.
	 * 		   If logintrace user done some userActivity then session data read otherwise 
	 * 		   only user data will be read.
	 */
	private JSONObject prepareAdminUserData(JSONObject activityDataFinal,JSONArray activityDataFinalArray, String fromDate,String toDate) throws JSONException, IOException 
	{

		HashMap<String, JSONObject>	minMaxTimeList= getMinMaxTime(fromDate,toDate,null);
		HashMap<String, JSONObject>	minMaxBatteryStatus = getBatteryStatus(fromDate,toDate,null);

		System.out.println("minmax time battery  ["+minMaxTimeList+"] minMaxBatteryStatus ["+minMaxBatteryStatus+"]");
		
		List<JSONObject> loginUserList = getLoginUsers(fromDate,toDate);
		System.out.println("loginUserList in Admin case:::::"+loginUserList);
		List<String> loginlist=new ArrayList<String>(); 

		for(JSONObject list : loginUserList){
			SimpleDateFormat newFormat = new SimpleDateFormat("YYYYMMdd");
			Timestamp loginDate=(Timestamp) list.get("LOGINDATE");
			String loginDateFormat =newFormat.format(loginDate);
			String userid=list.getString("USERID");
			String fileName=userid+"_"+loginDateFormat;
			System.out.println("fileName in Admin case>>>>"+fileName);
			loginlist.add(fileName);
		}
		System.out.println("loginlist in Admin case>>>>"+loginlist);
		
		JSONObject activityData = new JSONObject();
		activityData=prepareDataForGraph(activityData,fromDate,toDate,null);
		System.out.println(" activityData Device data object::::"+activityData);
		activityDataFinal.put("ACTIVITY_GRAPH_DATA",activityData);
		
		List<JSONObject> fileDataList= getUserActivityFileData(loginlist);
		System.out.println("getUserActivityData>>>"+ fileDataList);
	
		if(fileDataList.isEmpty())  //No User perform userActivity.
		{
			if(loginlist != null){
				for(String loginId : loginlist){
					activityData=fileNotFoundUsers(activityData,minMaxTimeList,minMaxBatteryStatus,loginId);
					activityDataFinalArray.put(activityData);
				}
			}
			System.out.println("activityDataFinal for if"+activityDataFinal);
		}
		else  //User perform userActivity
		{
			List<String> fileUsersList = new ArrayList<String>();
			for(JSONObject fileDataObj : fileDataList ) 
			{
				String userId = fileDataObj.optString("userId");
				String activityDate = fileDataObj.optString("activityDate");
				String fileContents = fileDataObj.optString("fileContents");
				String loginIdFormated=userId+"_"+activityDate;
				fileUsersList.add(loginIdFormated);
				System.out.println("fileUsersList in Admin case::::::::: "+fileUsersList);
				System.out.println("fileName::::::::: ["+loginIdFormated+"]");
				activityData = createActivityData(loginIdFormated, fileContents);
				activityData = updateMinMaxTime(activityData, minMaxTimeList.get(loginIdFormated)) ;
				activityData = checkUserForBatteryStatus(activityData, minMaxBatteryStatus,loginIdFormated) ;					
				activityDataFinalArray.put(activityData);
			}
			loginlist.removeAll(fileUsersList); //For some user who didn't perform userActivity
			System.out.println("loginUserList after:::"+loginlist);
			if(loginlist != null){
				for(String loginId : loginlist)
				{
					activityData=fileNotFoundUsers(activityData,minMaxTimeList,minMaxBatteryStatus,loginId);
					activityDataFinalArray.put(activityData);
				}
			}
		}
		activityDataFinal.put("ACTIVITY_DATA", activityDataFinalArray);
		//TO GET All Login User Data 
		return activityDataFinal;
	}
	
	/**
	 * @param  fromDate - from date user data shown(which can not be greater than to date)
	 * @param  toDate -till date user Data shown (which can not greater than todays date)
	 * @param  dateListFile -till date user Data shown (which can not greater than todays date)
	 * @return the method return fromDate to toDate login user and reporting to login user.
	 * 		   If users done some userActivity then session data read Otherwise 
	 * 		   only user data will be read on the basis of date and user id.
	 */
	private JSONObject prepareUserData(JSONObject activityDataFinal,JSONArray activityDataFinalArray, String fromDate,String toDate,String loginCode,String profileId,List<String> dateListFile) throws JSONException, IOException 
	{
		List<String> userDataList = getUserDetails(loginCode,profileId); // For User who have team
		System.out.println("userDataList AFTER>>>"+userDataList);
		List<String> userList=new ArrayList<String>(); 
		for(String userId : userDataList){
			for(String date : dateListFile){
				String fileName = userId+"_"+date;
				userList.add(fileName);
			}
		}
		System.out.println("userList AFTER>>>"+userList);
		
		HashMap<String, JSONObject>	minMaxTimeList= getMinMaxTime(fromDate,toDate,userDataList);
		HashMap<String, JSONObject>	minMaxBatteryStatus = getBatteryStatus(fromDate,toDate,userDataList);

		JSONObject selfActivityData = new JSONObject();
		selfActivityData=prepareDataForGraph(selfActivityData,fromDate,toDate,userDataList);
		activityDataFinal.put("ACTIVITY_GRAPH_DATA",selfActivityData);

		List<JSONObject> fileDataList= getUserActivityFileData( userList);
		System.out.println("fileDataList AFTER>>>"+fileDataList);
		
		if(fileDataList.isEmpty()) // For users which is in userDataList didn't perform any userActivity .
		{
			for(String date : dateListFile)
			{
				JSONArray teamActivityData = new JSONArray();
				selfActivityData=fileNotFoundUsers(selfActivityData,minMaxTimeList,minMaxBatteryStatus,loginCode+"_"+date);
				userDataList.remove(loginCode);
				System.out.println("userDataList in After removing logincode:::"+userDataList);
				if(userDataList != null){
					for(String usersId : userDataList)
					{
						System.out.println("Inside userDataList in After removing logincode:::["+usersId+"] DATE ["+date+"]");
						JSONObject teamMemberActivityData = new JSONObject();
						teamMemberActivityData=fileNotFoundUsers(selfActivityData,minMaxTimeList,minMaxBatteryStatus,usersId+"_"+date);
						teamActivityData.put(teamMemberActivityData);
					}
					System.out.println("teamActivityData::::: ["+teamActivityData+"]");
					if(teamActivityData.length()>0)
					{
						selfActivityData.put("TEAM", teamActivityData);				
					}
				}
				activityDataFinalArray.put(selfActivityData);
			}
			activityDataFinal.put("ACTIVITY_DATA", activityDataFinalArray);
			System.out.println("activityDataFinal for if"+activityDataFinal);
			
		}
		else //For users which is in userDataList perform userActivity.
		{
			for(String date : dateListFile){
				List<String> userListNew=new ArrayList<String>(); 
				for(String userId : userDataList){
					String fileName = userId+"_"+date;
					userListNew.add(fileName);
				}
				System.out.println("userlist New"+userListNew);
				List<JSONObject> fileDataListNew= getUserActivityFileData( userListNew); //Fetch file data on the basis of Date.
				System.out.println("fileDataListNew ::::::"+fileDataListNew);
				if(fileDataListNew.isEmpty())
				{
					System.out.println("Inside file data list is null ::::");
					JSONArray teamActivityData = new JSONArray();
					for(String usersId  : userListNew) // For users which is in userDataList if some user didn't perform user Activity
					{
						String[] fileArr = usersId.split("_");
						String userCode = fileArr[0];
						if( userCode.equalsIgnoreCase(loginCode))
						{
							selfActivityData=fileNotFoundUsers(selfActivityData,minMaxTimeList,minMaxBatteryStatus,usersId);
							System.out.println("selfActivityData after:::"+selfActivityData);
						}
						else 
						{
							JSONObject teamMemberActivityData = new JSONObject();

							teamMemberActivityData=fileNotFoundUsers(selfActivityData,minMaxTimeList,minMaxBatteryStatus,usersId);
							teamActivityData.put(teamMemberActivityData);
							System.out.println("teamActivityData after:::"+teamActivityData);
						}
					}
					if(teamActivityData.length()>0)
					{
						selfActivityData.put("TEAM", teamActivityData);				
					}
						
					
				}
				if(fileDataListNew !=null)
				{
					JSONArray teamActivityData = new JSONArray();
					List<String> fileUsersListNew = new ArrayList<String>();
					for(JSONObject fileData:fileDataListNew){
	
						System.out.println("Inside file else:::"+userDataList);
						String userId = fileData.optString("userId");
						String activityDate = fileData.optString("activityDate");
						String fileContents = fileData.optString("fileContents");
						System.out.println("fileName::::::::: ["+userId+"]["+activityDate+"]");
						fileUsersListNew.add(userId+"_"+activityDate);
							if( userId.equalsIgnoreCase(loginCode))
							{
								selfActivityData = createActivityData(userId+"_"+activityDate, fileContents);
								selfActivityData = checkUserForMinMaxTime(selfActivityData, minMaxTimeList,userId+"_"+activityDate) ;
								selfActivityData = checkUserForBatteryStatus(selfActivityData, minMaxBatteryStatus,userId+"_"+activityDate) ;					
							}
							else
							{
								JSONObject teamMemberActivityData = new JSONObject();
								teamMemberActivityData = createActivityData(userId+"_"+activityDate, fileContents);
								teamMemberActivityData = checkUserForMinMaxTime(teamMemberActivityData,minMaxTimeList,userId+"_"+activityDate) ;
								teamMemberActivityData = checkUserForBatteryStatus(teamMemberActivityData, minMaxBatteryStatus,userId+"_"+activityDate) ;					
								teamActivityData.put(teamMemberActivityData);
							}
						System.out.println("fileUsersListNew in else::::::::: ["+fileUsersListNew+"]");
					
						
					}
					userListNew.removeAll(fileUsersListNew);
					System.out.println("userListNew after:::"+userListNew);
					for(String usersId  : userListNew) // For users which is in userDataList if some user didn't perform user Activity
					{
						String[] fileArr = usersId.split("_");
						String userCode = fileArr[0];
						if( userCode.equalsIgnoreCase(loginCode))
						{
							selfActivityData=fileNotFoundUsers(selfActivityData,minMaxTimeList,minMaxBatteryStatus,usersId);
							System.out.println("selfActivityData after:::"+selfActivityData);
						}
						else 
						{
							JSONObject teamMemberActivityData = new JSONObject();

							teamMemberActivityData=fileNotFoundUsers(selfActivityData,minMaxTimeList,minMaxBatteryStatus,usersId);
							teamActivityData.put(teamMemberActivityData);
							System.out.println("teamActivityData after:::"+teamActivityData);
						}
					}
					if(teamActivityData.length()>0)
					{
						selfActivityData.put("TEAM", teamActivityData);				
					}
					activityDataFinalArray.put(selfActivityData);
					
				}
				
			}
		}

		activityDataFinal.put("ACTIVITY_DATA", activityDataFinalArray);
	
		return activityDataFinal;
	}

	
	/**
	 * @param  minMaxTimeObj - Minimum and maximum login and logout time is store in this.(with reffernce to userid and date)
	 * @return the method return if minimum login and maximum logout time for particular userid + date is present 
	 * 		   IF not then login logout time will be 'NA'
	 */
	private JSONObject updateMinMaxTime(JSONObject activityData, JSONObject minMaxTimeObj) throws JSONException
	{
		if(minMaxTimeObj !=null) 
		{
	    	activityData.put("LOGIN_TIME", genUtil.checkNull(minMaxTimeObj.opt("loginTime")));
	    	activityData.put("LOGOUT_TIME", genUtil.checkNull(minMaxTimeObj.opt("logoutTime")));
			System.out.println("minMaxTimeList query result:::::::"+minMaxTimeObj);
			return activityData;
		}
		{
	    	activityData.put("LOGIN_TIME", "NA");
	    	activityData.put("LOGOUT_TIME", "NA");
			System.out.println("minMaxTimeList query result:::::::"+minMaxTimeObj);
			return activityData;
		}
	}
	
	/**
	 * @param  minMaxTimeObj - Minimum and maximum login and logout time is store in this for all users.(with reffernce to userid and date)
	 * @return the method call updateMinMaxTime method by for perticular user id.
	 */
	private JSONObject checkUserForMinMaxTime(JSONObject activityData,HashMap<String, JSONObject> minMaxTimeObj,String userId) throws JSONException 
	{
		System.out.println("checkUserForMinMaxTime activity data::::"+activityData);
		System.out.println("checkUser checkUserForMinMaxTime:::::::userId ["+userId+"] minMaxTimeObj"+minMaxTimeObj);
		if(minMaxTimeObj.get(userId) != null)
		{
			activityData = updateMinMaxTime(activityData, minMaxTimeObj.get(userId)) ;	
			return activityData;
		}
		else // If perticular userId data not present.
		{
			activityData = updateMinMaxTime(activityData, null) ;	
			return activityData;
		}
		
	}
	
	/**
	 * @param  minMaxBatteryStatus - Minimum and maximum login and logout battery status is store in this.(with reffernce to userid and date)
	 * @return the method return if minimum login and maximum logout battery status for particular userid + date is present 
	 * 		   IF not then login logout battery status will be 'NA'
	 */
	private JSONObject updateMinMaxBatteryStatus(JSONObject activityData, JSONObject minMaxBatteryStatus) throws JSONException
	{
		if(minMaxBatteryStatus !=null)
		{
	    	activityData.put("LOGIN_BATTERY_STATUS", genUtil.checkNull(minMaxBatteryStatus.opt("loginBatteryStatus")));
	    	activityData.put("LOGOUT_BATTERY_STATUS",genUtil.checkNull(minMaxBatteryStatus.opt("logoutBatteryStatus")));
			System.out.println("minMaxBatteryStatus query result:::::::"+minMaxBatteryStatus);
			return activityData;
		}
		else
		{
	    	activityData.put("LOGIN_BATTERY_STATUS", "NA");
	    	activityData.put("LOGOUT_BATTERY_STATUS","NA");
			System.out.println("minMaxBatteryStatus else query result:::::::"+minMaxBatteryStatus);
			return activityData;
		}
	}
	
	/**
	 * @param  minMaxBatteryStatus - Minimum and maximum login and logout battery status is store in this for all users.(with reffernce to userid and date)
	 * @return the method call updateMinMaxBatteryStatus method by for particular user id.
	 */
	private JSONObject checkUserForBatteryStatus(JSONObject activityData,HashMap<String, JSONObject> minMaxBatteryStatus,String userId) throws JSONException 
	{
		System.out.println("checkUser:::::::userId ["+userId+"] minMaxBatteryStatus"+minMaxBatteryStatus);
		if(minMaxBatteryStatus.get(userId) != null)
		{
			activityData = updateMinMaxBatteryStatus(activityData, minMaxBatteryStatus.get(userId)) ;	
			return activityData;
		}
		else
		{
			activityData = updateMinMaxBatteryStatus(activityData, null) ;	 //If perticular userId data not present.
			return activityData;
		}
		
	}
	
	/**
	 * @param  userCode - userCode with date.
	 * @return call getEmployeeDetail method with user code
	 * 		   the method return Name, designation and userid which is coming from employee table
	 */
	private JSONObject getUserDetail(JSONObject activityData, String userCode) throws JSONException
	{
		String[] fileArr = userCode.split("_");
		String userId =  fileArr[0] ;
		System.out.println("getUserDetail>>>> file name ["+userCode+"] userId ["+userId+"]");
		Employee employee= getEmployeeDetail(userId);
		if( employee != null )
		{
			activityData.put("NAME", employee.getEmpFname());
			activityData.put("DESIGNATION", employee.getDesignation());
			activityData.put("USER_ID", userId);
		}
		return activityData;
	}
	
	/**
	 * @param  userCode - userCode with date.
	 * @param  activityLogXml - activity log file will is store in this.
	 * @return the method return read activity xml on the basis of node.
	 */
	private JSONObject createActivityData(String userCode, String activityLogXml)
	{
		String[] fileArr = userCode.split("_");
		String userId =  fileArr[0] ;
	
		E12GenericUtility e12GenericUtility = new E12GenericUtility();
		ArrayList<String> objNameList = new ArrayList<String>();
		JSONObject activityData = new JSONObject();
		try 
		{
			System.out.println("Inside create activity data");
			Document activityDoc = e12GenericUtility.parseString(activityLogXml);
			
			NodeList activitySessIdNL = activityDoc.getElementsByTagName("ACTIVITY_SESSION_ID");
			
			activityData = processSessionIds( userId, activitySessIdNL );
			
			JSONArray sessionArray = activityData.optJSONArray("ALL_SESSIONS");
			System.out.println("sessionArrayList"+sessionArray);
			
			activityData.remove("ALL_SESSIONS");
			
			NodeList activityNL = activityDoc.getElementsByTagName("ACTIVITY");

			//System.out.println("Inside getUserActivityData" + activityNL +" >> "+ activityNL.getLength() );
			if( activityNL != null && activityNL.getLength() > 0 )
			{
				int len = activityNL.getLength();
				for( int j = 0; j < len; j++)
				{
					String activityObj = "";
					String activityTitle = "";
					String activitySeesionId = "";
					String activityIcon="";
					NodeList activityChildNL = activityNL.item(j).getChildNodes();
					//System.out.println("processActivityAction i" + i);
					System.out.println("==");
					int actChLen = activityChildNL.getLength();
					//System.out.println("processActivityAction actChLen" + actChLen);
					for( int actCh = 0; actCh < actChLen; actCh++)
					{
						Node activityChildNode = activityChildNL.item(actCh);
						if( activityChildNode.getNodeType() == Node.ELEMENT_NODE)
						{
							String activityChName = activityChildNode.getNodeName();
							String activityChValue = activityChildNode.getFirstChild() != null ?  activityChildNode.getFirstChild().getNodeValue() : activityChildNode.getNodeValue();
							
							System.out.println("Inside getUserActivityData >> ["+ activityChName + "] activityChValue >>" + activityChValue + "]" );
							activityChValue = activityChValue == null ? "NA" : activityChValue;
							System.out.println("After activityChValue >>" + activityChValue + "]" );
							if( "ACTIVITY_OBJECT".equalsIgnoreCase( activityChName ) )
							{
								activityObj = activityChValue;
								//activityObj = activityChildNode.getFirstChild().getNodeValue();
								System.out.println( "activityObj[" + activityObj + "]");
								
								if(activityObj != null && objNameList.indexOf(activityObj) == -1 )
								{
									objNameList.add(activityObj);
								}
							}
							else if("ACTIVITY_ICON".equalsIgnoreCase( activityChName ))
							{
								System.out.println("inside activity icon");
								activityIcon = activityChValue.equalsIgnoreCase("NA") ?  "e12Menu.png" : activityChValue;
								System.out.println( "activityIcon [" + activityIcon +"]");
							}

							else if("ACTIVITY_TITLE".equalsIgnoreCase( activityChName ))
							{
								activityTitle = activityChValue;
								//activityTitle = activityChildNode.getFirstChild().getNodeValue();
								System.out.println( "activityTitle [" + activityTitle +"]");
							}
							else if( "ACTIVITY_SESSION_ID".equalsIgnoreCase( activityChName ) )
							{
								activitySeesionId = activityChValue;
								
								//activitySeesionId = activityChildNode.getFirstChild().getNodeValue();
     							//System.out.println(activityChName + "[" + activitySeesionId + "]");
							}
							else if( "ACTIVITY_ACTION".equalsIgnoreCase( activityChName ) )
							{
								System.out.println( "ACTIVITY_OBJECT[" + activityObj + "]");
								System.out.println( "activityTitle[" + activityTitle + "]");
								System.out.println( "ACTIVITY_SESSION_ID[" + activitySeesionId + "]");
								//System.out.println("[" + activityChildNode.getChildNodes() + "]");
								//System.out.println( processActivityAction(activityChildNode) );
								
								JSONObject activityObjData = activityData.optJSONObject(activitySeesionId);
								if( activityObjData == null )
								{
									activityObjData = new JSONObject();
								}
								
								JSONObject prevActivityObj = activityObjData.optJSONObject(activityObj);
								if( prevActivityObj == null )
								{
									prevActivityObj = new JSONObject();
								}
								
								JSONArray prevArray = prevActivityObj.optJSONArray("DATA");
								if( prevArray == null )
								{
									prevArray = new JSONArray();
								}
								//System.out.println(prevArray);
								
								prevActivityObj.put("DESCR", activityTitle);
								prevActivityObj.put("ICON", activityIcon);
								prevActivityObj.put("DATA", processActivityAction(activityChildNode, prevArray) );
								
								activityObjData.put(activityObj, prevActivityObj);
								
								activityData.put(activitySeesionId, activityObjData);
								
							}
						}
					}
				}
			}

			//System.out.println( activityData );
			JSONArray allSeesionArray = new JSONArray();
			int arrayLen = sessionArray.length();
			System.out.println("Object data "+arrayLen);
			for( int sessIdx = 0; sessIdx < arrayLen; sessIdx ++ )
			{
				String sessionId = sessionArray.optString(sessIdx);
				System.out.println("inside sessionid>>"+sessionId);
				JSONObject activityObjData = activityData.optJSONObject(sessionId);
				
				if( activityObjData == null )
				{
					activityObjData = new JSONObject();
				}
				
				JSONArray allObjectArray = new JSONArray();
				
				ArrayList<ActivityTime> objTimeArray = new ArrayList<ActivityTime>();
				for( String objName : objNameList )
				{
					JSONObject prevActivityObj = activityObjData.optJSONObject(objName);
					if( prevActivityObj != null )
					{
						JSONArray prevArray = prevActivityObj.optJSONArray("DATA");
						if( prevArray.length() > 0 )
						{
							ActivityTime totalTime = calcTotalTime(prevArray);
							
							prevActivityObj.remove("DATA");
							prevActivityObj.put("ACCESS_TIME", totalTime.toJSON());
							
							objTimeArray.add(totalTime);
						}
						prevActivityObj.put("OBJ_NAME", objName);
						
						activityObjData.remove(objName);
						allObjectArray.put(prevActivityObj);
					}
				}
				
				int len = objTimeArray.size();
		        if( len > 0 )
		        {
		        	ActivityTime objTotalTime = objTimeArray.get(0);
		        	System.out.println(" objTotalTime >>" + objTotalTime);
		        	for(int idx = 1; idx < len; idx++)
		        	{
		        		ActivityTime actTime = objTimeArray.get(idx);
		        		objTotalTime.addTime(actTime);
		        		System.out.println(" totalTime >" + idx + ">" + objTotalTime);
		        	}
		        	activityObjData.put("ACCESS_TIME", objTotalTime.toJSON());
		        }
		        
		        activityObjData.put("OBJECTS", allObjectArray);
				
				activityData.remove(sessionId);
				
				allSeesionArray.put( activityObjData );
			}
			activityData.put("SESSIONS", allSeesionArray);
			activityData.put("TEAM", new JSONArray());
			
			activityData = getUserDetail(activityData, userCode);
			
			System.out.println("activity data " + activityData.toString());
		}
		catch (Exception e) 
		{
			e.printStackTrace();
		}
		
		return activityData;
	}
	
	
	/**
	 * @param  prevArray - Array which contain object data.
	 * @return the method return differcen between ACCESS_START_TIME and ACCESS_END_TIME.
	 */
	private ActivityTime calcTotalTime(JSONArray prevArray) throws JSONException 
	{
		String startTime, endTime="";
		ActivityTime actTime = new ActivityTime();
		System.out.println("Inside calcTotalTime");
		int len = prevArray.length();
	       if( len > 0 )
	       {
		       	JSONObject jsonObjectStart = prevArray.getJSONObject(0);
		       	startTime = jsonObjectStart.getString("ACCESS_START_TIME");
	
		       	JSONObject jsonObjectEnd = prevArray.getJSONObject( len - 1 );
		       	endTime = jsonObjectEnd.optString("ACCESS_END_TIME");
	
		       	System.out.println("ACCESS_START_TIME>>"+startTime);
		       	System.out.println("ACCESS_END_TIME>>"+endTime);
		       	actTime = new ActivityTime(startTime, endTime);
	       }
	       System.out.println( "ActivityTime calcTotalTime >> " + actTime );
	return actTime;
	}
	
	/**
	 * @param  userCode - 
	 * @param  activitySessIdNL - Store the session id
	 * @return the method return session id data which is coming from logintrace table.
	 */
	public JSONObject processSessionIds(String userCode, NodeList activitySessIdNL) throws JSONException
	{
		JSONObject activityData = new JSONObject();
		StringBuffer  sessionIds = new StringBuffer();
		JSONArray sessionArray = new JSONArray ();
		if( activitySessIdNL != null && activitySessIdNL.getLength() > 0 )
		{
			int len = activitySessIdNL.getLength();
			for( int i = 0; i < len; i++)
			{
				String activitySeesionId = null;
				
				Node activityChildNode = activitySessIdNL.item(i);
				if( activityChildNode.getNodeType() == Node.ELEMENT_NODE)
				{
					String activityChName = activityChildNode.getNodeName();
					activitySeesionId = activityChildNode.getFirstChild().getNodeValue();
					System.out.println("Inside processSessionIds >> "+ activityChName );
				}

				if(activitySeesionId != null && sessionIds.indexOf(activitySeesionId) == -1 )
				{
					sessionIds.append("'").append(activitySeesionId).append("',");
					sessionArray.put(activitySeesionId);
				}
			}
			sessionIds.append(" '' ");
			System.out.println("SessionIds::::"+sessionIds);
		}
		
		//Get Data from Logintrace
		List<LoginTrace> loginTraceList = getLogDetails(userCode, sessionIds.toString() );
		System.out.println("loginTraceList::::"+loginTraceList);
		
		for( LoginTrace loginTrace : loginTraceList )
		{
			 JSONObject activityObjData = new JSONObject();
			 System.out.println("loginTrace.getClass()>>>>"+loginTrace.getClass());
			 String activitySeesionId = loginTrace.getSessionId();

			 activityObjData.put("SESSION_ID", activitySeesionId);
			 activityObjData.put("DEVICE_TYPE", genUtil.checkNull(loginTrace.getDeviceType()));
			 activityObjData.put("OS_NAME", genUtil.checkNull(loginTrace.getOsName()));
			 activityObjData.put("HOST_IP", genUtil.checkNull(loginTrace.getHostIp()));
			 activityObjData.put("CURRENT_GEO_POS", genUtil.checkNull(loginTrace.getCurrentGeoPos()));
			 activityObjData.put("OS_VERSION", genUtil.checkNull(loginTrace.getOsVersion()));
			 activityObjData.put("CLIENT_APP", genUtil.checkNull(loginTrace.getClientApp()));
			 activityObjData.put("CLIENT_APP_VER",genUtil.checkNull(loginTrace.getClientAppVer()));
			 activityObjData.put("LOGIN_TIME", genUtil.checkNullDate(loginTrace.getLoginTime()));
			 activityObjData.put("LOGOUT_TIME", genUtil.checkNullDate(loginTrace.getLogoutTime()));
			 activityObjData.put("LOGIN_BATTERY_STAT", genUtil.checkNull(loginTrace.getLoginBatteryStat()));
			 activityObjData.put("LOGOUT_BATTERY_STAT",genUtil.checkNull(loginTrace.getLogoutBatteryStat()));
			 
			 ActivityTime loginTime = new ActivityTime(loginTrace.getLoginTime(), loginTrace.getLogoutTime());
			 
			// int batteryStatus =loginTrace.getLoginBatteryStat()- loginTrace.getLogoutBatteryStat();
			 activityObjData.put("TOTAL_TIME", loginTime.toJSON());
			 System.out.println("TOTAL_TIME loginTime ["+ loginTime + "]");
			 System.out.println("activityData processSessionIds"+activityData);
			 activityData.put(activitySeesionId, activityObjData);
		}
		
		activityData.put("ALL_SESSIONS", sessionArray);
		System.out.println("activityData processSessionIds"+activityData);
		
		return activityData;
	}

    
	/**
	 * @param  userCode - userCode from user activity file
	 * @param  sessionIds - session id from user activity file
	 * @return the method return logintrace data on the basis of session id and user code.
	 */
	public List<LoginTrace> getLogDetails(String userCode, String sessionIds) 
	{
		List<LoginTrace> loginTraceList = null;
		try 
		{
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
			// 2. Create Query
			System.out.println("Inside getLogDetails sessionId: [" + sessionIds + "] USER CODE ["+userCode+"]");
			
			Query query = session.createQuery("FROM LoginTrace where userId='" + userCode + "' AND sessionId IN ( " + sessionIds + " ) ");
			
			System.out.println("Inside getLogDetails query: [" + query + "]");
			loginTraceList = query.getResultList();
			System.out.println("getLogDetails: loginTraceList [" + loginTraceList + "]");

			session.close();
		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		return loginTraceList;
	}
	
	/**
	 * @param  userCode - 
	 * @return the method return Employee table data on the basis of user code.
	 */
	private Employee getEmployeeDetail(String userCode) 
	{
		System.out.println("Inside getUserDesignation");
		Employee employee = null;
		Employee result = new Employee();
		try {
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
			// 2. Create Query
			Query query = session.createQuery("FROM Employee e WHERE e.empCode IN ( "
					+ " SELECT u.empCode "
					+ " FROM UserProfile u "
					+ " WHERE u.userCode ='"+userCode+"'"
					+ " )");
			
			System.out.println("Inside getLogDetails query: [" + query + "]");
			List<Employee> employeeDataList = query.getResultList();
			System.out.println("getLogDetails: loginTraceList [" + employeeDataList + "]");
			if( employeeDataList != null && employeeDataList.size() > 0 )
			{
				employee = employeeDataList.get(0);
			}
			
			session.close();
		} catch (HibernateException e) {
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}

		return employee;
	}
	
	/**
	 * @param  userCode - login id
	 * @param  profileId - getting from userInfoBean.
	 * @return the method return code from users table which reported to login id.
	 */
	public List<String> getUserDetails(String userId, String profileId) 
	{
		List<String> userDetailList = null;
		try 
		{
			// 1. Get Session object

			System.out.println("Inside getUserDetails userId: [" + userId + "]");
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
			// 2. Create Query
			Query query = session.createSQLQuery("select trim(CODE) from users where EMP_CODE in (SELECT emp_code FROM employee START WITH emp_code = (SELECT emp_code FROM users WHERE code = '"+userId+"') CONNECT BY prior emp_code = report_to)");
			
			System.out.println("query result>>>>>"+query);
			userDetailList = query.getResultList();
			System.out.println("query result:::::::"+userDetailList);
			System.out.println("query result:::::::"+userDetailList.size());

			session.close();

		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		System.out.println("userDetailList >>>>>>>>>"+userDetailList);
		return userDetailList;
	}
	
	/**
	 * @param  fromDate - from date user data shown(which can not be greater than to date)
	 * @param  toDate - till date user Data shown (which can not greater than todays date)
	 * @param  userDataList - code from users table which reported to login id(getUserDetails method result).
	 * @return the method return device_type name and it's count on the basis of fromDate , toDate and 
	 * 		   userDataList if not null from logintrace table.
	 */
	public JSONArray  getDeviceType(String fromDate, String toDate,List<String> userDataList) throws JSONException 
	{
		HashMap<String, JSONObject>  deviceTypeList = new HashMap<String, JSONObject> ();
		JSONArray device=new JSONArray();
		try 
		{
			// 1. Get Session object
			String whereClausePart = "";
			if(userDataList != null)
			{
				String userList = genUtil.getEnclosedString(userDataList);
				whereClausePart = " and userid in("+ userList +")";
			}

			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
			// 2. Create Query
			Query query = session.createSQLQuery("select count(1), DEVICE_TYPE"
					+ " from logintrace"
					+ " where to_date(LOGINTIME, 'dd-MM-yy') between '"+fromDate+"' and '"+toDate+"'"
					+ " and LOGIN_STATUS = 'T' "
					+   whereClausePart
					+ " and device_type is not null group by DEVICE_TYPE "
					+ "");
			
			System.out.println("query result>>>>>"+query);
			List<Object[]>  deviceList= (List<Object[]>)query.list();
		     for(Object[] minMaxTime: deviceList){
		    	BigDecimal count = (BigDecimal)minMaxTime[0];
		    	String deviceType = (String) minMaxTime[1];
		    	JSONObject jsonObject = new JSONObject();
		    	jsonObject.put("DEVICE_TYPE", deviceType);
		    	jsonObject.put("DEVICE_COUNT", count);
		    	device.put(jsonObject);
		    //	deviceTypeList.put(userId, jsonObject);
				System.out.println("minMaxTimeList query id::::::: jsonObject ["+jsonObject+"]");
		     }
			System.out.println("deviceTypeList result:::::::"+device);

			session.close();

		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		System.out.println("deviceTypeList >>>>>>>>>"+deviceTypeList);
		return device;
	}
	
	/**
	 * @param  fromDate - from date user data shown(which can not be greater than to date)
	 * @param  toDate - till date user Data shown (which can not greater than todays date)
	 * @param  userDataList - code from users table which reported to login id(getUserDetails method result).
	 * @return the method return client_app name and it's count on the basis of fromDate , toDate and 
	 * 		   userDataList if not null from logintrace table.
	 */
	public JSONObject  getClientApp(JSONObject activityData,String fromDate,String toDate,List<String> userDataList) throws JSONException 
	{
		try 
		{
			String whereClausePart = "";
			if(userDataList != null)
			{
				String userList = genUtil.getEnclosedString(userDataList);
				whereClausePart = " and userid in("+ userList +")";
			}
			// 1. Get Session object
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
			// 2. Create Query
			Query query = session.createSQLQuery("select count(1), CLIENT_APP"
					+ " from logintrace"
					+ " where to_date(LOGINTIME, 'dd-MM-yy') between '"+fromDate+"' and '"+toDate+"'"
					+ " and LOGIN_STATUS = 'T'"
					+   whereClausePart
					+ " and DEVICE_TYPE = 'Browser'"
					+ " group by (CLIENT_APP)"
					+ " ");
			
			System.out.println("getClientApp query >>>>>"+query);
	    	JSONObject jsonObject = new JSONObject();
	    	jsonObject.put( "CHROME", 0 );
	    	jsonObject.put( "INTEXP", 0 );
	    	jsonObject.put( "FIREFOX", 0 );
	    	jsonObject.put( "OTHER", 0 );
	    	
	    	BigDecimal total =  new BigDecimal(0);
			List<Object[]>  clientAppList= (List<Object[]>)query.list();
		     for(Object[] clientapplist: clientAppList){
		    	BigDecimal clientAppCount = (BigDecimal)clientapplist[0];
		    	if(clientapplist[1] != null)
		    	{
			    	String clientAppName = (String) clientapplist[1];
			    	if("CHROME".equalsIgnoreCase(clientAppName))
			    	{
			    		jsonObject.put( "CHROME",clientAppCount);
			    	}
			    	else if("INTEXP".equalsIgnoreCase(clientAppName))
			    	{
			    		jsonObject.put( "INTEXP",clientAppCount);
			    	}
				    else if("FIREFOX".equalsIgnoreCase(clientAppName))
			    	{
			    		jsonObject.put( "FIREFOX",clientAppCount);
			    	}
			    	else
			    	{
			    		jsonObject.put( "OTHER",clientAppCount);
			    	}
			       	total=total.add(clientAppCount);
					System.out.println("getClientApp query id::::::: jsonObject ["+jsonObject+"]");
		    	}
		     }
			    jsonObject.put("TOTAL", total);
			    activityData.put("BROWSER", jsonObject);

			session.close();
		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		return activityData;
	}
	
	/**
	 * @param  fromDate - from date user data shown(which can not be greater than to date)
	 * @param  toDate - till date user Data shown (which can not greater than todays date)
	 * @param  userDataList - code from users table which reported to login id(getUserDetails method result).
	 * @return the method return os name and it's count on the basis of fromDate , toDate and 
	 * 		   userDataList if not null from logintrace table.
	 */
	public JSONObject  getOsName(JSONObject activityData,String fromDate,String toDate,List<String> userDataList) throws JSONException 
	{
		try 
		{
			// 1. Get Session object

			String whereClausePart = "";
			if(userDataList != null)
			{
				String userList = genUtil.getEnclosedString(userDataList);
				whereClausePart = " and userid in("+ userList +")";
			}
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
			// 2. Create Query
			Query query = session.createSQLQuery("select count(1), OS_NAME"
					+ " from logintrace"
					+ " where to_date(LOGINTIME, 'dd-MM-yy') between '"+fromDate+"' and '"+toDate+"'"
					+ " and LOGIN_STATUS = 'T'"
					+   whereClausePart
					+ " and DEVICE_TYPE in ( 'Android Mobile' ,'Android Tablet','iOS Mobile' , 'iOS Tablet' )"
					+ " group by (OS_NAME)");
			
			System.out.println("getOsName query >>>>>"+query);
			JSONObject jsonObject = new JSONObject();
			jsonObject.put( "ANDROID",0);
			jsonObject.put( "IOS",0);
			jsonObject.put( "OTHER",0);
			
			BigDecimal total =  new BigDecimal(0);
			List<Object[]>  osNameList= (List<Object[]>)query.list();
		    for(Object[] osnamelist: osNameList){
		    	BigDecimal osNameCount = (BigDecimal)osnamelist[0];
		    	if(osnamelist[1] != null){

			    	String osname = (String) osnamelist[1];
			    	//String deviceType = (String) osnamelist[2];
			    	if("ANDROID".equalsIgnoreCase(osname)){
			    		jsonObject.put( "ANDROID",osNameCount);
			    	}
			    	else if("IOS".equalsIgnoreCase(osname) || osname.startsWith("Mac"))
			    	{
			    		jsonObject.put( "IOS",osNameCount);
			    	}
			    	else {
			    		jsonObject.put( "OTHER",osNameCount);
			    	}
			    	total=total.add(osNameCount);
					System.out.println("getOsName query id::::::: TOTAL"+total+"jsonObject ["+jsonObject+"]");
		    	}
		     }
		    jsonObject.put("TOTAL", total);
		    activityData.put("MOBILE", jsonObject);

			session.close();
		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		return activityData;
	}

	
	/**
	 * @param  fromDate - from date user data shown(which can not be greater than to date)
	 * @param  toDate - till date user Data shown (which can not greater than todays date)
	 * @return the method return os user id ,logintime and logout time on the basis of fromDate , toDate 
	 * 		   from logintrace table.
	 */
	public List<JSONObject> getLoginUsers(String fromDate,String toDate) throws JSONException 
	{
		List<JSONObject> allLoginUsers = new ArrayList<JSONObject>();
		try 
		{
			// 1. Get Session object
			System.out.println("Inside getLoginUsers userId: [" + fromDate + "] toDate ["+toDate+"]");
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
			// 2. Create Query
			Query query = session.createSQLQuery("select userid ,to_date(LOGINTIME, 'dd-MM-yy') logintime"
					+ " from logintrace"
					+ " where to_date(LOGINTIME, 'dd-MM-yy') between '"+fromDate+"' and '"+toDate+"'"
					+ " and LOGIN_STATUS = 'T'"
					+ " group by userid, to_date(LOGINTIME, 'dd-MM-yy') "
					+ " order by userid");
			
			System.out.println("getLoginUsers query >>>>>"+query);

			List<Object[]>  loginUser= (List<Object[]>)query.list();
		     for(Object[] userData: loginUser){
		    	String userId = (String)userData[0];
		    	Timestamp loginTime = (Timestamp) userData[1];
		    	JSONObject jsonObject = new JSONObject();
		    	jsonObject.put("USERID", userId);
		    	jsonObject.put("LOGINDATE", loginTime);
		    	allLoginUsers.add(jsonObject);
                
		     }
			session.close();

		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		System.out.println("getLoginUsers >>>>>>>>>"+allLoginUsers);
		return allLoginUsers;
	}
	
	/**
	 * @param  fromDate - from date user data shown(which can not be greater than to date)
	 * @param  toDate - till date user Data shown (which can not greater than todays date)
	 * @param  userDataList - code from users table which reported to login id(getUserDetails method result).
	 * @return the method return userid,minimum login and maximum logout time on the basis of fromDate , toDate and 
	 * 		   userDataList if not null from logintrace table.
	 */
	public HashMap<String,JSONObject>  getMinMaxTime(String fromDate,String toDate,List<String> userDataList) 
	{
		HashMap<String, JSONObject> minMaxTimeMap = new HashMap<String, JSONObject>();
		try 
		{
			// 1. Get Session object
			String whereClausePart = "";
			if(userDataList != null)
			{
				String userList = genUtil.getEnclosedString(userDataList);
				whereClausePart = " and userid in("+ userList +")";
			}
			System.out.println("Inside getMinMaxTime fromDate: [" + fromDate + "] toDate"+toDate+"]");
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
			// 2. Create Query
			Query query = session.createSQLQuery("select userid, min(LOGINTIME) as LOGINTIME , max(LOGOUTTIME)as LOGOUTTIME"
					+ " from logintrace "
					+ " where to_date(LOGINTIME, 'dd-MM-yy') between '"+fromDate+"' and '"+toDate+"'"
					+ " and LOGIN_STATUS = 'T' "
					+  whereClausePart
					+ "group by userid, to_date(LOGINTIME, 'dd-MM-yy') "
					+ "order by userid");
			System.out.println("query result>>>>>"+query);
	    	SimpleDateFormat newFormat = new SimpleDateFormat("YYYYMMdd");

			List<Object[]>  minMaxTimeList= (List<Object[]>)query.list();
		     for(Object[] minMaxTime: minMaxTimeList){
		    	String userId = (String)minMaxTime[0];
		    	Date loginTime = (Date) minMaxTime[1];
		    	Date logoutTime = (Date) minMaxTime[2];
				String loginDateFormat =newFormat.format(loginTime);
		    	JSONObject jsonObject = new JSONObject();
		    	jsonObject.put("loginTime", loginTime);
		    	jsonObject.put("logoutTime", logoutTime);
		    	minMaxTimeMap.put(userId+"_"+loginDateFormat, jsonObject);
		    	
				System.out.println("minMaxTimeList query id::::::: ["+userId+"_"+loginDateFormat+"] jsonObject ["+jsonObject+"]");
		     }
			session.close();
		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		} catch (JSONException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		System.out.println("minMaxTimeMap >>>>>>>>>"+minMaxTimeMap);
		return minMaxTimeMap;
	}
	
	/**
	 * @param  fromDate - from date user data shown(which can not be greater than to date)
	 * @param  toDate - till date user Data shown (which can not greater than todays date)
	 * @return the method return userid,minimum login and maximum logout battery status on the basis of fromDate , toDate and 
	 * 		   userDataList if not null from logintrace table.
	 */
	public HashMap<String, JSONObject> getBatteryStatus(String fromDate,String toDate,List<String> userDataList) throws JSONException 
	{
		HashMap<String, JSONObject> minMaxBatteryStatus = new HashMap<String, JSONObject>();
		try 
		{
			// 1. Get Session object
			
			String whereClausePart = "";
			if(userDataList != null)
			{
				String userList = genUtil.getEnclosedString(userDataList);
				whereClausePart = " and userid in("+ userList +")";
			}

			System.out.println("Inside getBatteryStatus fromDate: [" + fromDate + "] toDate ["+toDate+"]");
			Session session = HibernateUtil.getSessionFactory(siteTranDB).openSession();
			// 2. Create Query
			Query query = session.createSQLQuery("select A.userid, to_date(A.LOGINTIME,'dd-MM-yy hh24:mi:ss') IN_TIME, "
					+ " to_date(A.LOGOUTTIME,'dd-MM-yy hh24:mi:ss') OUT_TIME, "
					+ " A.LOGIN_BATTERY_STAT, "
					+ " A.LOGOUT_BATTERY_STAT"
					+ " from logintrace A,"
					+ "("
					+ "	select userid, min(LOGINTIME) as LOGINTIME , max(LOGOUTTIME)as LOGOUTTIME"
					+ " from logintrace"
					+ " where to_date(LOGINTIME, 'dd-MM-yy') between '"+fromDate+"' and '"+toDate+"'"
					+ " and LOGIN_STATUS = 'T'"
					+ " and LOGIN_BATTERY_STAT is not null "
					+ " and LOGOUT_BATTERY_STAT is not null"
					+   whereClausePart
					+ " group by userid, to_date(LOGINTIME, 'dd-MM-yy') "
					+ " )B"
					+ " where A.userid= B.userid"
					+ " and ( A.LOGINTIME = B.LOGINTIME"
					+ " or A.LOGOUTTIME = B.LOGOUTTIME )"
					+ " order by A.userid, A.LOGINTIME"
					+ "");
			
			List<Object[]> batteryStatusList= (List<Object[]>)query.list();
			SimpleDateFormat newFormat = new SimpleDateFormat("YYYYMMdd");
			JSONObject jsonObject = new JSONObject();
			List userList = new ArrayList<>();
		    for(Object[] batteryStatus: batteryStatusList){
		    	String userId = (String)batteryStatus[0];
		    	if(!userList.contains(userId)){
		    		jsonObject=new JSONObject();
		    		userList.add(userId);
	  		    	 Date loginTime = (Date) batteryStatus[1];
	    			 BigDecimal loginBatteryStatus = (BigDecimal) batteryStatus[3];
	    			 jsonObject.put("loginTime", loginTime);
	    			 jsonObject.put("loginBatteryStatus", loginBatteryStatus);
		    	}
		    	 Date logoutTime = (Date) batteryStatus[2];
	   			 BigDecimal logoutBatteryStatus = (BigDecimal) batteryStatus[4];
	   			 jsonObject.put("logoutTime", logoutTime);
	   			 String logoutDateFormat =newFormat.format(logoutTime);
	   			 jsonObject.put("logoutBatteryStatus", logoutBatteryStatus);
		    	 minMaxBatteryStatus.put(userId+"_"+logoutDateFormat, jsonObject);
		    	 System.out.println("minMaxBatteryStatus query result userId ["+userId+"_"+logoutDateFormat+"] jsonObject ["+jsonObject+"]");
		     }
			session.close();
		} 
		catch (HibernateException e) 
		{
			System.out.println("HibernateException :");
			System.out.println(e.getMessage());
		}
		System.out.println("minMaxBatteryStatus >>>>>>>>>"+minMaxBatteryStatus.toString());
		return minMaxBatteryStatus;
	}
	
	

	public JSONArray processActivityAction(Node activityChildNode, JSONArray eventArray) throws JSONException
	{
		if( activityChildNode != null )
		{
			NodeList activityActionNL = activityChildNode.getChildNodes();
			
			int actActionLen = activityActionNL.getLength();
			for( int actActionCh = 0; actActionCh < actActionLen; actActionCh++)
			{
				Node activityActionNode = activityActionNL.item(actActionCh);
				if( activityActionNode.getNodeType() == Node.ELEMENT_NODE)
				{
					String activityActionName = activityActionNode.getNodeName();
					//System.out.println("Inside processActivityAction >> "+ activityActionName );
					if( "EVENT_ID".equalsIgnoreCase( activityActionName ) )
					{
						eventArray.put( processEvent(activityActionNode) );
					}
				}
			}
		}
		return eventArray;
	}
	
	/**
	 * @param  activityActionNode - contain data which is in "EVENT_ID" node
	 * @return the method return userid,minimum login and maximum logout battery status on the basis of fromDate , toDate and 
	 * 		   userDataList if not null from logintrace table.
	 */
	public  JSONObject processEvent(Node activityActionNode) throws JSONException
	{
		JSONObject eventObj = new JSONObject();
		if( activityActionNode != null )
		{
			NodeList eventNL = activityActionNode.getChildNodes();
			
			int eventLen = eventNL.getLength();
			for( int eventId = 0; eventId < eventLen; eventId++)
			{
				Node eventChNode = eventNL.item(eventId);
				if( eventChNode.getNodeType() == Node.ELEMENT_NODE)
				{
					String eventChName = eventChNode.getNodeName();
					String eventChValue = eventChNode.getFirstChild() != null ?  eventChNode.getFirstChild().getNodeValue() : eventChNode.getNodeValue();
					//System.out.println("Inside getUserActivityData >1212> "+ eventChNode.getNodeName() );
					if( "ACCESS_START_TIME".equalsIgnoreCase( eventChName ) )
					{
						//System.out.println( new Date (eventChValue));
						//System.out.println( eventChName + "[" + eventChValue + "]");
						eventObj.put(eventChName, eventChValue);
					}
					else if( "ACCESS_END_TIME".equalsIgnoreCase( eventChName ) )
					{
						//System.out.println(eventChName + "[" + eventChValue + "]");
						eventObj.put(eventChName, eventChValue);
					}
				}
			}
		}
		return eventObj;
	}
	
	/**
	 * @param  loginFilelist - Users list (it can be login user list from date to toDate)
	 * @return the method return file name which is present in user activity folder.
	 */
	public List<JSONObject> getUserActivityFileData(List<String>  loginFilelist) throws IOException, JSONException
	{		
		List<JSONObject> filesArrayList = new ArrayList<JSONObject>();
		String jbossPath=CommonConstants.JBOSSHOME;
		System.out.println("CommonConstants.JBOSSHOME ["+CommonConstants.JBOSSHOME+"]");
		File userActivityFolder = new File(jbossPath+"/server/default/UserActivity");
		System.out.println("userActivityFolder ["+userActivityFolder+"] ");
		if( userActivityFolder.isDirectory() )
		{
			File[] userActivityFiles = userActivityFolder.listFiles(new FileFilter() {
				@Override
				public boolean accept(File pathname) {
					
					return pathname.getName().endsWith(".txt");
				}
			});
			
			for(File userActivityFile: userActivityFiles )
			{
				String fileName = userActivityFile.getName();
				//System.out.println("userActivityFile[" + fileName + "]");
				fileName = fileName.replace(".txt", "");
				
				
				if( loginFilelist.indexOf(fileName) == -1 )
				{
					continue;
				}
				System.out.println("userActivityFile[" + fileName + "]");
				
				String[] fileArr = fileName.split("_");
				String userId = ( fileArr.length > 0 ) ? fileArr[0] : "SYSTEM";
				String activityDate =fileName.substring(fileName.lastIndexOf("_") + 1);
				
			//	activityDate = ( fileArr.length > 1 ) ? fileArr[1] : date;
				
				System.out.println("userActivityFile READ[" + userId + "]["+activityDate+"]");
				
				JSONObject fileData = new JSONObject();
				fileData.put("userId", userId);
				fileData.put("activityDate", activityDate);

				String fileContents =  FileUtils.readFileToString(userActivityFile);
				StringBuffer fileContentsBuff = new StringBuffer();
				fileContentsBuff.append("<ROOT>");
				fileContentsBuff.append(fileContents);
				fileContentsBuff.append("</ROOT>");
				fileData.put("fileContents", fileContentsBuff.toString());
				
				filesArrayList.add(fileData);

				
				System.out.println(fileData.toString().length() + "\n");
			}
		}
		return filesArrayList;
	}

}

//http://192.168.0.220:9090/ibase/plugin/api/accountActivity?fromDate=10-02-18
