package ibase.dashboard.common.hibernate.bean;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlRootElement;

import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.json.JSONObject;

import oracle.sql.DATE;


@Indexed
@Entity
@Table(name = "USER_DEVICE")
@XmlRootElement(name = "UserDevice")

public class UserDevice implements java.io.Serializable 
{
	private static final long serialVersionUID = 1L;

	   @Id
	   @Field(store = Store.YES, analyze = Analyze.NO)
	   @Column(name="USER_ID")
	   private String userId;
	   
	   @Column(name="DEVICE_ID__PUSH")
	   private String deviceIdPush;

	   @Column(name="DEVICE_OS")
	   private String deviceOs;

	   @Column(name="DEVICE_TYPE")
	   private String deviceType;
	 
	   @Column(name="EFF_FROM")
	   private Date effFrom;
	 
	   @Column(name="VALID_UPTO")
	   private Date validUpto;

	   @Column(name="ACTIVE")
	   private String active;
	   
	   @Column(name="DEVICE_MAKE")
	   private String deviceMake;

	   @Column(name="DEVICE_MAC_ADDR")
	   private String deviceMacAddr;
	   
	   
	   public UserDevice() {
			
	   }
	   
		public UserDevice(String userId,String deviceIdPush,String deviceOs,String deviceType,
				Date effFrom, Date validUpto,  String active, String deviceMake, String deviceMacAddr
				) {
			this.userId = userId;
			this.deviceIdPush = deviceIdPush;
			this.deviceOs = deviceOs;
			this.deviceType = deviceType;
			this.effFrom = effFrom;
			this.validUpto = validUpto;
			this.active = active;
			this.deviceMake = deviceMake;
			this.deviceMacAddr = deviceMacAddr;
		}

		public String getUserId() {
			return userId;
		}

		public void setUserId(String userId) {
			this.userId = userId;
		}

		public String getDeviceIdPush() {
			return deviceIdPush;
		}

		public void setDeviceIdPush(String deviceIdPush) {
			this.deviceIdPush = deviceIdPush;
		}

		public String getDeviceOs() {
			return deviceOs;
		}

		public void setDeviceOs(String deviceOs) {
			this.deviceOs = deviceOs;
		}

		public String getDeviceType() {
			return deviceType;
		}

		public void setDeviceType(String deviceType) {
			this.deviceType = deviceType;
		}

		public Date getEffFrom() {
			return effFrom;
		}

		public void setEffFrom(Date effFrom) {
			this.effFrom = effFrom;
		}

		public Date getValidUpto() {
			return validUpto;
		}

		public void setValidUpto(Date validUpto) {
			this.validUpto = validUpto;
		}

		public String getActive() {
			return active;
		}

		public void setActive(String active) {
			this.active = active;
		}

		public String getDeviceMake() {
			return deviceMake;
		}

		public void setDeviceMake(String deviceMake) {
			this.deviceMake = deviceMake;
		}

		public String getDeviceMacAddr() {
			return deviceMacAddr;
		}

		public void setDeviceMacAddr(String deviceMacAddr) {
			this.deviceMacAddr = deviceMacAddr;
		}

		@Override
		public String toString(){
			return "\n UserDevice.toString >> [" + new JSONObject(this).toString() + "]";
		}
	
}
