package ibase.dashboard.metadata.ejb;
import ibase.dashboard.Report.Utility.DashboardUtility;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.io.File;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.LinkedHashMap;
import java.util.Map.Entry;
import javax.ejb.Stateless;
import org.json.simple.JSONObject;


@Stateless

public class DashboardParentEJB extends ValidatorEJB  implements DashboardParentEJBLocal, DashboardParentEJBRemote 
{
	public DashboardParentEJB() {
        // TODO Auto-generated constructor stub
    }
	
	DashboardUtility dashboardUtility = new DashboardUtility();
    @Override
	 public String getKeyString(String modName, String fieldName, String transDB) throws RemoteException, ITMException
	 {
   		
   	      Statement statement      = null;
          ResultSet resultSet      = null;
          String keyString         = "";         
   		  Connection conn          = null;
   		  ConnDriver connDriver    = new ConnDriver();    		 
   		try
   		{
   			
   			if (transDB != null && transDB.trim().length() > 0)
            {
                conn = connDriver.getConnectDB(transDB);
            }
           else
            {
                conn = connDriver.getConnectDB("DriverITM");
            }
   			connDriver   = null;   			
   			statement    = conn.createStatement();
            String query = "SELECT SQL_INPUT FROM POPHELP WHERE MOD_NAME ='" + modName + "' AND FIELD_NAME = '" + fieldName.toUpperCase() + "'";
            System.out.println("modName is ="+modName+ "  fieldName is= "+fieldName + " and query " +query);
            resultSet = statement.executeQuery(query);
            if (resultSet.next())
            {
                keyString = dashboardUtility.checkNull(resultSet.getString("SQL_INPUT"));
            }
        } catch (Exception e)
        {
            e.printStackTrace();
        } finally
        {
            try
            {
                resultSet.close();
                resultSet = null;
                statement.close();
                statement = null;
                conn.close();
                conn = null;
            } catch (Exception ex)
            {
                System.out.println("Finally Exception : DashboardParentEJB: getKeyString()" + ex.getMessage());
                ex.printStackTrace();
            }
        }
        return keyString;
       }
 
	   	
 @SuppressWarnings("unchecked")
 @Override
 public JSONObject  getDefaultFilterValue(String transDB ) throws RemoteException, ITMException
	 {
   		
		    ConnDriver connDriver     = new ConnDriver();
	        Statement statement       = null;
	        ResultSet rs              = null;
	        JSONObject parentDataJson = new JSONObject();	        
	        Connection connection     = null;	        
	        try
	        {
	           
	           if (transDB != null && !"null".equalsIgnoreCase(transDB.trim()) && transDB.trim().length() > 0)
	            {
	                connection = connDriver.getConnectDB(transDB);
	            }
	           else
	            {
	                connection = connDriver.getConnectDB("DriverITM");
	            }
	            statement    = connection.createStatement();
	            String query = " Select Acct_Prd,Code,Descr From Period Where To_Date(Sysdate) Between Fr_Date and To_Date ";
	            rs           = statement.executeQuery(query);
	            if (rs.next())
	            {
	            	parentDataJson.put("CURRENT_ACCTCODE",dashboardUtility.checkNull(rs.getString("Acct_Prd")));
	            	parentDataJson.put("CURRENT_PRDCODE", dashboardUtility.checkNull(rs.getString("Code")));
	            	
	            }
	        } catch (Exception e)
	        {
	            e.printStackTrace();
	        } finally
	        {
	            try
	            {
	            	rs.close();
	            	rs = null;
	                statement.close();
	                statement = null;
	                connection.close();
	                connection = null;
	            } catch (Exception ex)
	            {
	                System.out.println("Finally Exception : DashboardFilterServlet: getDefaultFilterValue()" + ex.getMessage());
	                ex.printStackTrace();
	            }
	        }
	        return parentDataJson;
  		
	}
	
}
