package ibase.webitm.webService;

import ibase.bean.EventLogInfoBean;
import ibase.bean.ExtAuthApplicationBean;
import ibase.bean.ExtAuthRespBean;
import ibase.ejb.CommonDBAccessRemote;
import ibase.system.config.AppConnectParm;
import ibase.utility.BaseException;
import ibase.utility.CryptographyUtil;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;

import java.util.MissingResourceException;
import java.util.ResourceBundle;

import javax.naming.InitialContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import org.json.JSONObject;
import org.w3c.dom.Document;

/**
 * 
 * This web service is for authenticate user andcreateExtServiceLog sending JWT token in response. 
 * 
 * @author Sandesh
 *
 */

@Path("/ExtAuthAppService")
public class ExtAuthAppService 
{
	private E12GenericUtility genericUtility = new E12GenericUtility();	
	
	/**
	 * Used for authenticate user and send JWT token
	 * 
	 * @param userCode
	 * @param password
	 * @param isPwdEncrypt
	 * @param appId
	 * @param request
	 * @return Response
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/extauthapi")
	@Produces(MediaType.APPLICATION_JSON)
	public Response authAPIService(@QueryParam("USER_CODE") String userCode, @QueryParam("PASSWORD") String password,
			@QueryParam("IS_PWD_ENCRYPT") String isPwdEncrypt, @QueryParam("APP_ID") String appId, 
			@Context HttpServletRequest request) throws BaseException, Exception
	{
		String result = "";
		JSONObject resultJson = new JSONObject();
		try 
		{
			result = validateRequest(request);
			if (result.equals("valid"))
			{
				userCode = E12GenericUtility.checkNull( userCode );
				password = E12GenericUtility.checkNull( password );
				appId = E12GenericUtility.checkNull( appId );
				isPwdEncrypt = E12GenericUtility.checkNull(isPwdEncrypt).length() > 0
						? E12GenericUtility.checkNull(isPwdEncrypt) : "true";
				if ( userCode.length() > 0 && appId.length() > 0)
				{
					String chgIP = request.getRemoteAddr();
					
					String remoteHostName = request.getParameter("MACHINENAME");
					if( remoteHostName != null && remoteHostName.length() > 60 )
					{
						remoteHostName = remoteHostName.substring( 0, 60 ); 
					}
					else if ( remoteHostName == null || remoteHostName.length() == 0 )
					{
						remoteHostName = "";
					}
					
					ExtAuthApplicationBean applicationBean = getCommonDBAccess().getExtAuthApplicationInfo(appId);
					boolean isAllowLoginAttempts  = isAllowLoginAttempts(userCode);
					System.out.println("ExtAuthAppService >> isAllowLoginAttempts =["+isAllowLoginAttempts+"]");
					// If user exceeds the Max failed login attempt then will return error message.
					if (!isAllowLoginAttempts
							&& E12GenericUtility.checkNull(applicationBean.getEnableSecurity()).equalsIgnoreCase("T")
							&& E12GenericUtility.checkNull(applicationBean.getActive()).equalsIgnoreCase("T"))
					{
						result = getMessage("ExtAuthAppService_maxAllowedLoginAttempts");
						resultJson.put( "status", "error" );
					}
					else if (!E12GenericUtility.checkNull(applicationBean.getActive()).equalsIgnoreCase("T"))
					{
						result = getMessage("ExtAuthAppService_appNotActive");
						resultJson.put( "status", "error" );
					}
					else
					{
						String authStatus = getAuthStatus( request, userCode, password, "", "I", isPwdEncrypt );
						if ( "VALID".equalsIgnoreCase( authStatus ) )
						{
							// Insert into logintrace
							getCommonDBAccess().insertSessionTrace( userCode, request.getSession().getId(), true, chgIP, remoteHostName);
							
							result = getMessage("ExtAuthAppService_authenticationSuccessful");
							// Create JWT token
							String jwt = getJWTToken(userCode, applicationBean);
							
							if (E12GenericUtility.checkNull(jwt).length() > 0)
							{
								resultJson.put("jwtToken", jwt);
							}
						}
						else if (authStatus.equalsIgnoreCase("RESIGNED"))
						{	
							result = getMessage("ExtAuthAppService_employeeHasResigned");
							resultJson.put( "status", authStatus );
						}
						else if (authStatus.equalsIgnoreCase("LOCKED"))
						{
							result = getMessage("ExtAuthAppService_accountIsLockedContactAdmin");
							resultJson.put( "status", authStatus );
						}
						else if(authStatus.indexOf("PASS_EXP") != -1)
						{
							if (authStatus.equalsIgnoreCase("PASS_EXP_GRACE"))
							{
								result = getMessage("ExtAuthAppService_passwordExpiredWouldYouLikeToChange");
								resultJson.put( "status", authStatus );
							}
							else if (authStatus.equalsIgnoreCase("PASS_EXP_NOGRACE"))
							{
								result = getMessage("ExtAuthAppService_passwordExpiredChangeIt");
								resultJson.put( "status", authStatus );
							}
						}
						else if (authStatus.equalsIgnoreCase("FIRST_LOGIN"))
						{
							result = getMessage("ExtAuthAppService_compulsoryChangePasswordPleaseDoSo");
							resultJson.put( "status", authStatus );
						}
						else if (authStatus.equalsIgnoreCase("INVALID_USR") || authStatus.equalsIgnoreCase("INVALID_PWD"))
						{
							// Insert into logintrace
							getCommonDBAccess().insertSessionTrace( userCode, request.getSession().getId(), false, chgIP, remoteHostName);

							result = getMessage("ExtAuthAppService_pleaseEnterValidUserNameAndPassword");
							resultJson.put( "status", "error" );
						}
						else
						{
							result = getMessage("ExtAuthAppService_pleaseLoginSunpharmaMetis");
							resultJson.put( "status", "error" );
						}
					}
					
				}
				else
				{
					resultJson.put( "status", getMessage("ExtAuthAppService_authFail") );
					result = getMessage("ExtAuthAppService_notAuthorized");
				}
				
			}
			
			resultJson.put( "results", result );
		}
		catch(Exception e)
		{
			System.out.println( "Exception in ExtAuthAppService :: authAPIService : "+ e.getMessage() );
			e.printStackTrace();
			throw new ITMException(e);
		}
		return Response.status(200).entity( resultJson.toString() ).build();
	}
	
	/**
	 * Get message from properties file based on key
	 * @param key
	 * @return
	 */
	public String getMessage(String key)
	{
		ResourceBundle RESOURCE_BUNDLE =  ResourceBundle.getBundle("ibase.webitm.webService.messages");
		try 
		{
			return RESOURCE_BUNDLE.getString(key);
		}
		catch (MissingResourceException e) {
			return '!' + key + '!';
		}
	}
	
	/**
	 * 
	 * This service for logout the user based on JWT token and applicationId
	 * 
	 * @param jwt
	 * @param appId
	 * @param request
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	@GET
	@Path("/extlogout")
	@Produces(MediaType.APPLICATION_JSON)
	public Response logoutAPIService(@QueryParam("JWT") String jwt, @QueryParam("APP_ID") String appId, 
			@Context HttpServletRequest request) throws BaseException, Exception
	{
		String result = "";
		JSONObject resultJson = new JSONObject();
		try 
		{
			result = validateRequest(request);
			if (result.equals("valid"))
			{
				ExtAuthApplicationBean applicationBean = getCommonDBAccess().getExtAuthApplicationInfo(appId);
				String jwtResult = CryptographyUtil.parseBase64EncodedJWT(jwt, applicationBean.getSecretKey());
				if (jwtResult.equalsIgnoreCase("expired"))
				{   
					result = "Token has been expired";
					resultJson.put( "results", result );
				}	
				else if (jwtResult.equalsIgnoreCase("invalid"))
				{
					result = "Invalid Token";
					resultJson.put( "results", result );
				} 
				else
				{
					if (E12GenericUtility.checkNull(jwtResult).length() > 0 && jwtResult.contains("~"))
					{
						String tokenData[] = jwtResult.split("~");
						
						if (E12GenericUtility.checkNull(tokenData[0]).length() > 0 &&  E12GenericUtility.checkNull(tokenData[1]).length() > 0)
						{
							// Usercode => tokenData[0], sessionId ==> tokenData[1]
							result= logout( tokenData[0], tokenData[1] );
							if (result.equalsIgnoreCase("User has been logged out."))
							{
								request.getSession().invalidate();
							}
						}
						else
						{
							result = "Invalid Token";
						}
						resultJson.put( "results", result );
					}
					else
					{
						result = "Invalid Token";
					}
				}
			}
			resultJson.put( "results", result );
		}
		catch(Exception e)
		{
			System.out.println( "Exception in ExtAuthAppService :: logoutAPIService : "+ e.getMessage() );
			e.printStackTrace();
			throw new ITMException(e);
		}
		return Response.status(200).entity( resultJson.toString() ).build();
	}
	
	
    /**
	 * Validate Request
	 * 
	 * @param request
	 * @return
	 */
	private String validateRequest( HttpServletRequest request )
	{
		String validStr = "valid";
		try 
		{
			if ( ! request.isSecure() )
			{
				validStr = getMessage("ExtAuthAppService_httpsOnly");
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception in ExtAuthAppService : validateRequest : "+ e.getMessage() );
			validStr = getStackTrace(e);
		}
		return validStr;
	}
	
	/**
     * get a print stack trace
     * 
     * @param e
     * @return
     */
    private String getStackTrace( Exception e )
    {
    	String exception = "";
    	if ( genericUtility == null )
    	{
    		genericUtility = new E12GenericUtility();
    	}
    	exception = genericUtility.createErrorString(e);
		return exception;
    }
    

	/**
	 * To get CommonDBAccessRemote object
	 * 
	 * @return
	 * @throws BaseException
	 */
	private CommonDBAccessRemote getCommonDBAccess() throws BaseException
	{
		CommonDBAccessRemote ejbObj = null;
		try
		{
			ejbObj = (CommonDBAccessRemote) getInitialContext().lookup("ibase/CommonDBAccessEJB/remote");
		}
		catch( BaseException be )
		{
			System.out.println("Exception in ExtAuthAppService: getCommonDBAccess:==>"+be);
			throw be;
		}
		catch( Exception e )
		{
			System.out.println("Exception in ExtAuthAppService: getCommonDBAccess:==>"+e);
			throw new BaseException( e );
		}
		return ejbObj;
	}
	
	/**
	 * It creates a object of InitialContext & returns the same.
	 * 
	 * @return
	 * @throws ITMException
	 */
	private InitialContext getInitialContext() throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext( appConnect.getProperty() );
		}
		catch( ITMException itme )
		{
			System.out.println( "Exception in ExtAuthAppService : ITMException : getInitialContext : "+ itme.getMessage() );
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println( "Exception in ExtAuthAppService : getInitialContext : "+ e.getMessage() );
			throw new ITMException(e);
		}
		return ctx;
	}
	
	/**
	 * Check allowed login attempts for user.
	 * 
	 * @param userCode
	 * @return
	 */
	protected boolean isAllowLoginAttempts( String userCode )
	{
		boolean isAllowed = true;
		try
		{
			isAllowed = getCommonDBAccess().checkLoginAttempts(userCode);
		}
		catch(Exception e)
		{
			System.out.println("Exception in ExtAuthAppService :: isAllowLoginAttempts() : "+ e.getMessage());
			
		}
		return isAllowed;
	}
	
	/**
	 * 
	 * Create and get base64 encoded JWT token based on user and application information.
	 * 
	 * @param userCode
	 * @param applicationBean
	 * @return
	 * @throws BaseException
	 * @throws Exception
	 */
	protected String getJWTToken(String userCode, ExtAuthApplicationBean applicationBean) throws BaseException, Exception
	{
		System.out.println("ExtAuthAppService :: getJWTToken");
		// Get user details
		ExtAuthRespBean userBean = getCommonDBAccess().getExtAuthRespBean(userCode);

		//Create Base64 Encoded JWT token
		String jwtToken = CryptographyUtil.createBase64EncodedJWT(applicationBean, userBean, "");
		
		System.out.println("ExtAuthAppService :: getJWTToken: jwtToken : ["+ jwtToken +"]");
		
		return jwtToken;
	}
	
	/**
	 * Get User Valid or not
	 * 
	 * @param request
	 * @param userCode
	 * @param password
	 * @param siteCode
	 * @param authMode
	 * @param isSHA256Appld
	 * @return
	 * @throws Exception
	 * @throws BaseException
	 */
	private String getAuthStatus(HttpServletRequest request, String userCode, String password, String siteCode,
			String authMode, String isSHA256Appld) throws Exception, BaseException 
	{
	    String authStatus = "false";
		try 
		{
			String xmlInfo = "";
			if ( getCommonDBAccess() != null )
			{
				xmlInfo = getCommonDBAccess().authenticate(userCode, password, siteCode, authMode, isSHA256Appld);
				System.out.println( "xmlInfo - ["+ xmlInfo +"]" );
				authStatus = generateResponse(xmlInfo);
			}
		}
		catch (Exception e) 
		{
			System.out.println("Exception in ExtAuthAppService : getAuthStatus: "+ e.getMessage());
			throw new BaseException(e);
		}
		System.out.println("isValidLogin - ["+ authStatus +"]");
	    return authStatus;
	}
	
	/**
	 * Generating server response after login
	 * 
	 * @param xmlInfo
	 * @return
	 * @throws BaseException
	 */
	private String generateResponse( String xmlInfo )throws BaseException
	{
		System.out.println( "Generating Response...." );
		String responseString = "";
		try
		{
			if ( E12GenericUtility.checkNull( xmlInfo ).length() > 0 )
			{
				Document document = genericUtility.parseString( xmlInfo );
				if (document.getElementsByTagName("STATUS_CODE").item(0) != null
						&& document.getElementsByTagName("STATUS_CODE").item(0).getFirstChild() != null)
				{
					String statusCode = document.getElementsByTagName("STATUS_CODE").item(0).getFirstChild().getNodeValue();
					responseString = statusCode;
					
					if( statusCode.equalsIgnoreCase("VALID") )
					{
						if(document.getElementsByTagName( "SITE_CODE" ).item(0) != null)
						{
							String siteCodeValue = document.getElementsByTagName("SITE_CODE").item(0).getFirstChild().getNodeValue(); 
							if ( siteCodeValue.equalsIgnoreCase("INVALID_SITE") )
							{
								responseString = "INVALID_SITE";
							}
							else if ( siteCodeValue.equalsIgnoreCase("INACCESSIBLE_SITE")  )
							{
								responseString = "INACCESSIBLE_SITE";
							}
						}
					}
				}
			}
		}
		catch( BaseException be )
		{
			System.out.println("Exception in ExtAuthAppService: generateResponse:==>"+be);
			throw be;
		}
		catch( Exception e )
		{
			System.out.println("Exception in ExtAuthAppService: generateResponse:==>"+e);
			throw new BaseException( e );
		}
		System.out.println( "responseString - ["+ responseString +"]" );
		return responseString;
	}
	
	/**
	 * User Logout
	 * 
	 * @param userCode
	 * @param sessionId
	 * @throws BaseException
	 */
	private String logout( String userCode, String sessionId ) throws BaseException
	{
		String result = "";
		
		try 
		{
			String islogout = isLogout(userCode, sessionId);
			if(E12GenericUtility.checkNull(islogout).length() > 0)
			{
				result = "User has been already logged out.";
			}
			else
			{
				EventLogInfoBean eventInfoBean = new EventLogInfoBean( userCode );
				eventInfoBean.removeSessionActivity( sessionId );
				getCommonDBAccess().updateSessionTrace( userCode, sessionId );
				result = "User has been logged out.";
			}
		}
		catch (Exception e) 
		{
			System.out.println( "Exception in ExtAuthAppService :: logout : "+ e.getMessage() );
			e.printStackTrace();
		}
		return result;

	}
	
	/**
	 * 
	 * To check user is already logged out.
	 * 
	 * @param userCode
	 * @param sessionId
	 * @return
	 * @throws BaseException
	 */
	private String isLogout( String userCode, String sessionId ) throws BaseException
	{
		String isLogout = "";
		try 
		{
			isLogout = getCommonDBAccess().getLoginStatus(userCode, sessionId );
		}
		catch (Exception e) 
		{
			System.out.println( "Exception in ExtAuthAppService :: logout : "+ e.getMessage() );
			e.printStackTrace();
		}
		return isLogout;
	}
}
