package proteus.ecm.hibernate.bean;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlRootElement;

import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.json.JSONException;
import org.json.JSONObject;


@Indexed
@Entity
@Table(name = "ENTITY_PAY_MTHD")
@XmlRootElement(name = "entityPayMthd")
public class EntityPayMethod implements java.io.Serializable 
{
	private static final long serialVersionUID = 1L;
	
	@Id
	@Column(name="ENTITY_CODE")
	@Field(store = Store.YES, analyze = Analyze.NO)
	private String entityCode;
	
	@Id
	@Column(name="LINE_NO")
	@Field(store = Store.YES, analyze = Analyze.NO)
	private String lineNo;
	
	@Column(name="ENTITY_TYPE")
	private String entityType;
	
	@Column(name="PAY_MTHD_TYPE")
	private String payMthdType;
	
	@Column(name="PAY_SERVICE_PROVIDER")
	private String payServiceProvider;
	
	@Column(name="ACCT_NAME")
	private String acctName;
	
	@Column(name="ACCT_NUMBER")	
	private String acctNumber;
	
	@Column(name="EXPIRY_MONTH")
	private String expiryMonth;
	
	@Column(name="EXPIRY_YEAR")
	private String expiryYear;
	
	public EntityPayMethod() {
		
	}

	public EntityPayMethod(String entityCode, String lineNo, String entityType, String payMthdType,
			String payServiceProvider, String acctName, String acctNumber, String expiryMonth, String expiryYear) {
		this.entityCode = entityCode;
		this.lineNo = lineNo;
		this.entityType = entityType;
		this.payMthdType = payMthdType;
		this.payServiceProvider = payServiceProvider;
		this.acctName = acctName;
		this.acctNumber = acctNumber;
		this.expiryMonth = expiryMonth;
		this.expiryYear = expiryYear;
	}

	public String getEntityCode() {
		return entityCode;
	}

	public void setEntityCode(String entityCode) {
		this.entityCode = entityCode;
	}

	public String getLineNo() {
		return lineNo;
	}

	public void setLineNo(String lineNo) {
		this.lineNo = lineNo;
	}

	public String getEntityType() {
		return entityType;
	}

	public void setEntityType(String entityType) {
		this.entityType = entityType;
	}

	public String getPayMthdType() {
		return payMthdType;
	}

	public void setPayMthdType(String payMthdType) {
		this.payMthdType = payMthdType;
	}

	public String getPayServiceProvider() {
		return payServiceProvider;
	}

	public void setPayServiceProvider(String payServiceProvider) {
		this.payServiceProvider = payServiceProvider;
	}

	public String getAcctName() {
		return acctName;
	}

	public void setAcctName(String acctName) {
		this.acctName = acctName;
	}

	public String getAcctNumber() {
		return acctNumber;
	}

	public void setAcctNumber(String acctNumber) {
		this.acctNumber = acctNumber;
	}

	public String getExpiryMonth() {
		return expiryMonth;
	}

	public void setExpiryMonth(String expiryMonth) {
		this.expiryMonth = expiryMonth;
	}

	public String getExpiryYear() {
		return expiryYear;
	}

	public void setExpiryYear(String expiryYear) {
		this.expiryYear = expiryYear;
	}
	
	
	public void toSaveCard(String userId, JSONObject cardData) throws JSONException {
		
		this.setEntityCode(userId);
		this.setLineNo(cardData.getString("lineNo"));
		this.setAcctNumber(cardData.getString("acctNumber").trim());
		this.setAcctName(cardData.getString("acctName"));
		this.setExpiryMonth(cardData.getString("expiryMonth"));
		this.setExpiryYear(cardData.getString("expiryYear"));
		this.setPayMthdType(cardData.getString("payMthdType"));
		this.setPayServiceProvider(cardData.getString("payServiceProvider"));
		this.setEntityType("U");
	}	

}
