import { Directive, Input } from '@angular/core';
import { NG_VALIDATORS } from '@angular/forms';
export class PhoneValidator {
    constructor() {
        this.validation = false;
    }
    validate(c) {
        console.log('-------', c.value);
        if (!this.validation) {
            return null;
        }
        const isValidNumber = this.expression.test(c.value);
        const message = {
            'phone': {
                'message': this.invalidMessage
            }
        };
        return isValidNumber ? null : message;
    }
}
PhoneValidator.decorators = [
    { type: Directive, args: [{
                selector: '[phone-validator]',
                providers: [
                    { provide: NG_VALIDATORS, useExisting: PhoneValidator, multi: true }
                ]
            },] },
];
/** @nocollapse */
PhoneValidator.ctorParameters = () => [];
PhoneValidator.propDecorators = {
    'expression': [{ type: Input, args: ['expression',] },],
    'invalidMessage': [{ type: Input, args: ['invalidMessage',] },],
    'validation': [{ type: Input, args: ['validation',] },],
};
//# sourceMappingURL=phone-validator.js.map