import {Injectable} from '@angular/core';
import {Action} from '@ngrx/store';

@Injectable()
export class CategoryActions {
    static LOAD_CATEGORY = '[CATEGORY] Load CATEGORY';
    loadCategories(): Action {
        return {
            type: CategoryActions.LOAD_CATEGORY
        };
    }
    
    static LOAD_CATEGORY_SUCCESS = '[CATEGORY] Load CATEGORY Success';
    loadCategoriesSuccess(categories): Action {
        console.log('[CATEGORY] Load CATEGORY Success',categories.length);
        
        if(!categories.length)
        {
            categories = [];
        }
        return {
            type: CategoryActions.LOAD_CATEGORY_SUCCESS,
            payload: categories
        };
        
    }
    
    static RESET_CATEGORY_LIST = '[CATEGORY LIST] Reset CATEGORY_LIST';
    resetCategoryList(): Action {
        return {
            type: CategoryActions.RESET_CATEGORY_LIST
        };
    }
    
    static GET_CATEGORY = '[CATEGORY] Get CATEGORY';
    getCategory(catCode): Action {
        return {
            type: CategoryActions.GET_CATEGORY,
            payload: catCode
        };
    }

    static GET_CATEGORY_SUCCESS = '[CATEGORY] Get CATEGORY Success';
    getCategorySuccess(category): Action {
        return {
            type: CategoryActions.GET_CATEGORY_SUCCESS,
            payload: category
        };
    }
    
    static RESET_BLANK_CATEGORY = '[CATEGORY] Reset Blank CATEGORY';
    resetBlankCategory(): Action {
        return {
            type: CategoryActions.RESET_BLANK_CATEGORY
        };
    }
}