package proteus.ecm.hibernate.bean;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.Store;
import org.json.JSONObject;


@Indexed
@Entity
@Table(name = "ECM_ORDER_DET")
@XmlRootElement(name = "OrderDet")
public class ECMOrderDet implements java.io.Serializable 
{
	private static final long serialVersionUID = 1L;
	
	@Id
	@Column(name="EORDER_NO")
	@Field(store = Store.YES, analyze = Analyze.NO)
	private String eorderNo;
	
	@Id
	@Column(name="LINE_NO")
	private int lineNo;
	
	@Column(name="ITEM_CODE")
	private String itemCode;
	
	@Column(name="PROMO_CODE")
	private String promoCode;
	
	@Column(name="QUANTITY")
	private int quantity;
			 
	@Column(name="RATE")	
	private int rate;
	 
	@Column(name="DISC_PERC")	
	private double discPerc;
	
	@Column(name="TAX_AMT")
	private int taxAmt;
			 
	@Column(name="TAX_CHAP")	
	private String taxChap;
	 
	@Column(name="TAX_CLASS")	
	private String taxClass;
	
	@Column(name="TAX_ENV")	
	private String taxEnv;
	
	@Column(name="NET_AMT")
	private int netAmt;	
	
	@Column(name="ORD_STAT")
	private String ordStat;
			  
	@Column(name="STAT_DATE")
	private Date statDate;
	
	@Column(name="STAT_REMARKS")	
	private String statRemarks;
	
	@Column(name="SHIP_DATE")
	private Date shipDate;
	
	@Column(name="DLV_DATE")
	private Date dlvDate;


	public ECMOrderDet() {
	}
	
	public ECMOrderDet(String eorderNo, int lineNo, String itemCode, String promoCode, int quantity, int rate,
			           double discPerc,int taxAmt, int netAmt,String taxChap, String taxClass, String taxEnv, String ordStat,
			           Date statDate,String statRemarks, Date shipDate, Date dlvDate ) {
		this.eorderNo = eorderNo;
		this.lineNo = lineNo;
		this.itemCode = itemCode;
		this.promoCode = promoCode;
		this.quantity = quantity;
		this.rate = rate;
		this.discPerc = discPerc;
		this.taxAmt = taxAmt;
		this.taxChap = taxChap;
		this.taxClass = taxClass;
		this.taxEnv = taxEnv;
		this.ordStat = ordStat;
		this.statDate = statDate;
		this.statRemarks = statRemarks;
		this.shipDate = shipDate;
		this.dlvDate = dlvDate;
		this.netAmt= netAmt;
	}


	public String getEorderNo() {
		return eorderNo;
	}

	public void setEorderNo(String eorderNo) {
		this.eorderNo = eorderNo;
	}

	public int getLineNo() {
		return lineNo;
	}

	public void setLineNo(int lineNo) {
		this.lineNo = lineNo;
	}

	public String getItemCode() {
		return itemCode;
	}

	public void setItemCode(String itemCode) {
		this.itemCode = itemCode;
	}

	public String getPromoCode() {
		return promoCode;
	}

	public void setPromoCode(String promoCode) {
		this.promoCode = promoCode;
	}

	public int getQuantity() {
		return quantity;
	}

	public void setQuantity(int quantity) {
		this.quantity = quantity;
	}

	public int getRate() {
		return rate;
	}

	public void setRate(int rate) {
		this.rate = rate;
	}

	public double getDiscPerc() {
		return discPerc;
	}

	public void setDiscPerc(double discPerc) {
		this.discPerc = discPerc;
	}

	public int getTaxAmt() {
		return taxAmt;
	}

	public void setTaxAmt(int taxAmt) {
		this.taxAmt = taxAmt;
	}

	public String getTaxChap() {
		return taxChap;
	}

	public void setTaxChap(String taxChap) {
		this.taxChap = taxChap;
	}

	public String getTaxClass() {
		return taxClass;
	}

	public void setTaxClass(String taxClass) {
		this.taxClass = taxClass;
	}

	public String getTaxEnv() {
		return taxEnv;
	}

	public void setTaxEnv(String taxEnv) {
		this.taxEnv = taxEnv;
	}
	
	public int getNetAmt() {
		return netAmt;
	}

	public void setNetAmt(int netAmt) {
		this.netAmt = netAmt;
	}

	public String getOrdStat() {
		return ordStat;
	}

	public void setOrdStat(String ordStat) {
		this.ordStat = ordStat;
	}

	public Date getStatDate() {
		return statDate;
	}

	public void setStatDate(Date statDate) {
		this.statDate = statDate;
	}

	public String getStatRemarks() {
		return statRemarks;
	}

	public void setStatRemarks(String statRemarks) {
		this.statRemarks = statRemarks;
	}
	
	 
		 
	public Date getShipDate() {
	return shipDate;
	}
	
	public void setShipDate(Date shipDate) {
	this.shipDate = shipDate;
	}
	
	public Date getDlvDate() {
	return dlvDate;
	}
	
	public void setDlvDate(Date dlvDate) {
	this.dlvDate = dlvDate;
	}

	@Override
	public String toString(){
		return "\n ECMOrderDet.toString >> [" + new JSONObject(this).toString() + "]";
	}
}
