import { Component, OnInit,ViewChild, ElementRef, Input, Output, trigger, state, animate, transition, style, Injectable  } from '@angular/core';
import { EventEmitter } from '@angular/core';
import { EcmLocation } from './ecm-location';
import { EcmLocationService } from './ecm-location.service';
import { SearchService } from './ecm-search-result/search.service';
import { Router } from '@angular/router';
import { Observable } from 'rxjs/Observable';
import { Store } from '@ngrx/store';
import { AppState } from '../ecm-store/reducers';
import { FormControl } from '@angular/forms';
import { RESIZE_EVENT } from '../ecm-store/ecm-resize';
@Component({
  selector: 'ecm-search',
  templateUrl: './ecm-search.component.html',
  styleUrls: ['./ecm-search.component.css'],
  animations: [
    trigger('searchInputTrans', [
       state('false' , style({ opacity: 1, transform : 'scale(1.0) translateY(0) ' })),
       state('true', style({ transform : ' translateY(0) ' })),
       state('fade150', style({ transform : ' translateY(-5px) scale(0.95)' })),
       state('fade200', style({ transform : ' translateY(-10px) scale(0.95)' })),
       state('fade250', style({ transform : ' translateY(-20px) scale(0.85)' })),
       state('fade300', style({ transform : ' translateY(-30px) scale(0.85)' })),
       state('fade350', style({ transform : ' translateY(-40px) scale(0.75)' })),
       state('fade400', style({ transform : ' translateY(-50px) scale(0.75)' })),
       state('fade450', style({ transform : ' translateY(-100px) scale(0.60)' })),
       state('fade500', style({ transform : ' translateY(-150px) scale(0.55)' })),
       state('fade550', style({ transform : ' translateY(-200px) scale(0.40)' })),
       state('fade600', style({ transform : ' translateY(-250px) scale(0.35)' })),
       transition('* <=> *', animate('.3s'))
    ])
   ]
})
export class ECMSearchComponent implements OnInit {

  @Input('compFadeState') compFadeState: string = 'false';
  @Input('headerState') headerState: string = 'relative';
  @ViewChild('myInput') searchBar;
  @Output() closePanel = new EventEmitter();
  
  stateCtrl = new FormControl();
  options = ['Food', 'Handicrafts', 'Crafts'];
  filteredOptions;
  clientWidth: any; //chitranga
  public storeUserLocation :  Observable<EcmLocation>;
  public userLocation : EcmLocation;

  search_key;
 
  selectedPlace = 'Mumbai';
  constructor(private locationService: EcmLocationService, private search_service: SearchService, private router: Router, private store: Store<AppState>) 
  {
      this.stateCtrl.valueChanges.debounceTime(100).subscribe((val: any) => {
          console.log("Selected Value[" +val+ "]");
          let trimmedVal = val.trim().replace(/<\/?[^>]+(>|$)/g, "");
          
          if(trimmedVal.length > 2)
          {    
              this.search_service.getSuggestions(trimmedVal).subscribe(data => {
                  this.filteredOptions = data;
              });
          }
       });
  }
  ngOnInit() {
      //this.selectedCity = localStorage.getItem('city');
      this.search_key = this.search_service.getSearch(); 
      this.clientWidth = document.documentElement.clientWidth;
        console.log("this.clientWidth in Search component",this.clientWidth);
        RESIZE_EVENT.subscribe(data => {
            this.clientWidth = data;
        });
      
      this.storeUserLocation = this.store.select('location');
      this.storeUserLocation.subscribe( userLocation => {
            //console.log( 'ngOnInit >' + userLocation );
            this.userLocation = userLocation;
      });
      
  }
  
  ngAfterViewInit() {
  	  console.log( 'ECMSearchComponent ngAfterViewInit .....');
      if(this.search_key && this.searchBar)
         this.searchBar.nativeElement.value=this.search_key;     
      this.storeUserLocation = this.store.select('location');
      this.storeUserLocation.subscribe( userLocation => {
            this.userLocation = userLocation;
      });
  }
  
  loacteMe() {
       this.locationService.getGeoLocation();
  }
  
  search(value) { 
     let trimmedVal = value.trim().replace(/<\/?[^>]+(>|$)/g, ""); 
     console.log('Search Funtion Called ['+trimmedVal+']');
  	 if(value)
     {
        this.search_service.setSearch(trimmedVal);
        this.router.navigate(['/search',trimmedVal]);
  	 } 
  	 this.closePanel.emit();
  }
  
  clearInput() {
   this.search_service.setSearch(null);
  }

}
 