/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record;

import java.util.List;
import org.eclipse.persistence.internal.core.sessions.CoreAbstractSession;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.oxm.mappings.Mapping;
import org.eclipse.persistence.internal.oxm.record.MarshalContext;
import org.eclipse.persistence.internal.oxm.record.MarshalRecord;
import org.eclipse.persistence.oxm.sequenced.Setting;

public class SequencedMarshalContext
implements MarshalContext {
    private List<Setting> settings;
    private XPathFragment indexFragment = new XPathFragment();
    private Object value;

    public SequencedMarshalContext(List<Setting> settings) {
        this.settings = settings;
    }

    public SequencedMarshalContext(Object value) {
        this.value = value;
    }

    @Override
    public MarshalContext getMarshalContext(int index) {
        Setting setting = this.settings.get(index);
        List<Setting> children = setting.getChildren();
        if (children == null) {
            return new SequencedMarshalContext(setting.getValue());
        }
        return new SequencedMarshalContext(children);
    }

    @Override
    public int getNonAttributeChildrenSize(XPathNode xPathNode) {
        if (this.settings == null) {
            return 0;
        }
        return this.settings.size();
    }

    @Override
    public Object getNonAttributeChild(int index, XPathNode xPathNode) {
        Setting setting = this.settings.get(index);
        if (setting.getName() == null) {
            return xPathNode.getAnyNode();
        }
        if (setting.getName().equals("text()")) {
            return xPathNode.getTextNode();
        }
        this.indexFragment.setLocalName(null);
        this.indexFragment.setXPath(setting.getName());
        this.indexFragment.setNamespaceURI(setting.getNamespaceURI());
        return xPathNode.getNonAttributeChildrenMap().get(this.indexFragment);
    }

    @Override
    public Object getAttributeValue(Object object, Mapping mapping) {
        return this.value;
    }

    @Override
    public boolean marshal(NodeValue nodeValue, XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, CoreAbstractSession session, NamespaceResolver namespaceResolver) {
        if (nodeValue.isContainerValue()) {
            ((ContainerValue)((Object)nodeValue)).marshalSingleValue(xPathFragment, marshalRecord, object, this.value, session, namespaceResolver, this);
            return true;
        }
        return nodeValue.marshal(xPathFragment, marshalRecord, object, session, namespaceResolver, this);
    }

    @Override
    public boolean marshal(NodeValue nodeValue, XPathFragment xPathFragment, MarshalRecord marshalRecord, Object object, CoreAbstractSession session, NamespaceResolver namespaceResolver, XPathFragment rootFragment) {
        if (nodeValue.isContainerValue()) {
            ((ContainerValue)((Object)nodeValue)).marshalSingleValue(xPathFragment, marshalRecord, object, this.value, session, namespaceResolver, this);
            return true;
        }
        return nodeValue.marshal(xPathFragment, marshalRecord, object, session, namespaceResolver, this, rootFragment);
    }
}

