package ibase.e12ria.dcdet.client;

import ibase.e12ria.client.CommonPhoneGapUtil;
import ibase.e12ria.client.E12CommonUtils;
import ibase.e12ria.client.E12Constants;
import ibase.e12ria.client.E12DownloadInfo;
import ibase.e12ria.client.E12Global;
import ibase.e12ria.client.E12Global.E12Storage;

import java.util.ArrayList;
import java.util.Map.Entry;
import java.util.TreeMap;

import com.google.gwt.core.client.Callback;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.http.client.Request;
import com.google.gwt.http.client.RequestBuilder;
import com.google.gwt.http.client.RequestCallback;
import com.google.gwt.http.client.RequestException;
import com.google.gwt.http.client.Response;
import com.google.gwt.http.client.URL;
import com.google.gwt.user.client.Window;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.Node;
import com.google.gwt.xml.client.NodeList;
import com.google.gwt.xml.client.XMLParser;
import com.googlecode.gwtphonegap.client.PhoneGap;
import com.googlecode.gwtphonegap.client.event.HasResumeHandlers;
import com.googlecode.gwtphonegap.client.event.ResumeEvent;
import com.googlecode.gwtphonegap.client.event.ResumeHandler;
import com.googlecode.gwtphonegap.client.file.DirectoryEntry;
import com.googlecode.gwtphonegap.client.file.FileCallback;
import com.googlecode.gwtphonegap.client.file.FileError;
import com.googlecode.gwtphonegap.client.file.FileSystem;
import com.googlecode.gwtphonegap.client.file.Flags;

public class CollabContents 
{
	private static ArrayList<String> collabFilesAL = null;
	private static DirectoryEntry rootDirectoryEntry = null;
	private static ArrayList<String> filePathArryList = null;
	//private static ArrayList<String> fileNameList = null;
	private static int noOfFilesInZip = 0;
	private static String curDocIdAndType = null;
	
	private static long totalFiles = 0;
	private static long zipFileCounter = 0;
	private static long allFileCounter = 0;
	
	private static boolean callToServer = true;
	
	private static boolean createDirFlag = true;
	
	public CollabContents()
	{
		try
		{
			final String StorageLocation = "Base";
			final PhoneGap phoneGap = GWT.create(PhoneGap.class);
			phoneGap.getFile().requestFileSystem(FileSystem.LocalFileSystem_PERSISTENT, 0, new FileCallback<FileSystem, FileError>()
			{
				@Override
				public void onSuccess(FileSystem entry) 
				{
					 DirectoryEntry directoryEntry = entry.getRoot();
	                directoryEntry.getDirectory( StorageLocation, new Flags( true, false), new FileCallback<DirectoryEntry, FileError>()
	                {
						@Override
						public void onSuccess(DirectoryEntry directoryEntry)
						{
							rootDirectoryEntry = directoryEntry;
						}
						public void onFailure(FileError error) 
						{
						}
	                });
				}
				@Override
				public void onFailure(FileError error) 
				{
				}
			}); 
			
			phoneGap.initializePhoneGap();
			
		}catch(Throwable e)
		{
			Window.alert("Exception while getting existing file list "+e.getMessage());
		}
	}
	public void buildData()
	{
		try
		{	
			createDirFlag = true;
			
			if( E12Global.getInstance().isOffline() )
			{
				E12DownloadInfo.getInstance().setVisibleDownloadButton( false );
				E12DownloadInfo.getInstance().setDownloadInfo( "" );
			}
			else
			{
				filePathArryList = null;
				collabFilesAL = null;
				zipFileCounter = 0;
				allFileCounter = 0;
				String downloadFile = E12Storage.getItem( "DownloadFiles" );
				getCollabContentList( downloadFile, new Callback<String, Boolean>() 
				{
					@Override
					public void onSuccess(String result) 
					{
						if( !"".equalsIgnoreCase(result) )
						{
							E12DownloadInfo.getInstance().setDownloadInfo( "New contents available" );
							E12DownloadInfo.getInstance().setStyleNameDownloadBtn( "downloadImg" );
							E12DownloadInfo.getInstance().setVisibleDownloadButton( true );
							E12DownloadInfo.getInstance().setDownloadFail( false );
							E12DownloadInfo.getInstance().setDownloadButtonRegister( new ClickHandler() 
							{
								@Override
								public void onClick(ClickEvent event) 
								{
									if( CommonPhoneGapUtil.checkNetwork() )
									{
										E12DownloadInfo.getInstance().setVisibleDownloadButton( false );
										E12DownloadInfo.getInstance().setDownloadInfo( "Gathering download information" );
										if( E12DownloadInfo.getInstance().getDownloadFail() )
										{
											filePathArryList = null;
											collabFilesAL = null;
											zipFileCounter = 0;
											allFileCounter = 0;
											String downloadFile = E12Storage.getItem( "DownloadFiles" );
											getCollabContentList(downloadFile, new Callback<String, Boolean>()
											{
												@Override
												public void onFailure(Boolean reason) 
												{
												}
												@Override
												public void onSuccess(String result) 
												{
													if( !"".equalsIgnoreCase(result) )
													{
														downloadCollabFiles();
													}
												}
											});
										}
										else
										{
											downloadCollabFiles();
										}
									}
								}
							});
							
							CommonPhoneGapUtil.getInstance().getResumeHandler().addResumeHandler( new ResumeHandler() {
								
								@Override
								public void onResumeEvent(ResumeEvent event) 
								{
									if( E12DownloadInfo.getInstance().getDownloadFail() )
									{
										CommonPhoneGapUtil.getInstance().destroyFileTransferObject();
										E12DownloadInfo.getInstance().setVisibleDownloadButton( false );
										E12DownloadInfo.getInstance().setDownloadInfo( "Gathering download information" );
										
										filePathArryList = null;
										collabFilesAL = null;
										zipFileCounter = 0;
										allFileCounter = 0;
										String downloadFile = E12Storage.getItem( "DownloadFiles" );
										getCollabContentList(downloadFile, new Callback<String, Boolean>()
										{
											@Override
											public void onFailure(Boolean reason) 
											{
											}
											@Override
											public void onSuccess(String result) 
											{
												if( !"".equalsIgnoreCase(result) )
												{
													downloadCollabFiles();
												}
											}
										});
									}
								}
							});
						}
						else
						{
							E12DownloadInfo.getInstance().setDownloadInfo( "" );
							E12DownloadInfo.getInstance().setVisibleDownloadButton( false );
						}
					}
					@Override
					public void onFailure(Boolean reason) 
					{
					}
				});
			}
		}catch (Throwable e) 
		{
			Window.alert("Exception while getting client side file list "+e.getMessage());
		}
	}
	public static void getExistCollabFilesList( final Callback<String, FileError> callback )
	{
		try
		{
			final String StorageLocation = "Base";
			final PhoneGap phoneGap = GWT.create(PhoneGap.class);
			phoneGap.getFile().requestFileSystem(FileSystem.LocalFileSystem_PERSISTENT, 0, new FileCallback<FileSystem, FileError>()
			{
				@Override
				public void onSuccess(FileSystem entry) 
				{
					 DirectoryEntry directoryEntry = entry.getRoot();
		                directoryEntry.getDirectory( StorageLocation, new Flags( true, false), new FileCallback<DirectoryEntry, FileError>()
		                {
							@Override
							public void onSuccess(DirectoryEntry directoryEntry)
							{
								rootDirectoryEntry = directoryEntry;
								CommonPhoneGapUtil.getInstance().readDirectory(directoryEntry, new Callback<String,FileError>()
								{
									@Override
									public void onFailure(FileError reason) 
									{
										callback.onFailure(reason);
									}
									@Override
									public void onSuccess(String result) 
									{
										callback.onSuccess(result);
									}
								});
							}
							public void onFailure(FileError error) {
							}
		                });
				}

				@Override
				public void onFailure(FileError error) 
				{
					// TODO Auto-generated method stub
					
				}
			}); 
			
			phoneGap.initializePhoneGap();
			
		}catch(Throwable e)
		{
			Window.alert("Exception while getting existing file list "+e.getMessage());
		}
	}
	public void getCollabContentList( String existFileAndDirList, final Callback< String, Boolean> callback )
	{
		try
		{
			E12CommonUtils.printOnConsole( "Calling to CollabGetGroupPostsServlet... ["+existFileAndDirList+"]" );
			String url= E12Global.getHostUrl() + "/ibase/CollabGetGroupPostsServlet?action=GET_COLLAB_CONTENTS_LIST&COLLAB_EXISTS=" + existFileAndDirList ;
			RequestBuilder requestBuilder = new RequestBuilder( RequestBuilder.GET, url );
			requestBuilder.sendRequest( null, new RequestCallback() {
				
				@Override
				public void onResponseReceived(Request request, Response response) 
				{
					collabFileAL( response.getText() );
					callback.onSuccess( response.getText() );
					/*if( ! collabFilesAL.isEmpty() )
					{
						E12DownloadInfo.getInstance().setDownloadInfo( "Downloading......." );
					}
					downloadCollabFiles();*/
				}
				@Override
				public void onError(Request request, Throwable exception) 
				{
					callback.onSuccess( "" );
					Window.alert("OnError getCollabContentList "+exception.getMessage());
				}
			});
		} catch (Throwable e) {
			Window.alert("Exception while getting collab servlet response "+e.getMessage());
		}
		
	}
	private void collabFileAL( String collabFilesStr ) 
	{
		try 
		{
			collabFilesAL = new ArrayList<String>();
			if( collabFilesStr != null && collabFilesStr.length() > 0 )
			{
				if( collabFilesStr.indexOf("~~") > 0 )
				{
					String [] collabAttachmentArr = collabFilesStr.split("~~");
					for( String collabAttachment : collabAttachmentArr )
					{
						collabFilesAL.add(collabAttachment);
					}
				}
				else
				{
					collabFilesAL.add(collabFilesStr);
				}
			}
			totalFiles = collabFilesAL.size();
		} catch (Exception e) {
			Window.alert( " Exception while getting collabFileAL "+e.getMessage() );
		}
	}
	
	public static void downloadCollabFiles() 
	{
		try 
		{
			if( collabFilesAL != null )
			{
				int collabFiles = collabFilesAL.size();
				if( collabFiles > 0 )
				{
					if( createDirFlag )
					{
						for( int cnt = 0; cnt < collabFiles; cnt++ )
						{
							String result = collabFilesAL.get( cnt );
							E12CommonUtils.printOnConsole(" Prajyot Creating Folder using result [" + result + "]");
							String[] strArray = result.split( ":" );
							final String docId = ( String ) strArray [ 0 ];
							final String docType = ( String ) strArray [ 1 ];
							if( "zip".equalsIgnoreCase( docType ) )
							{
								E12CommonUtils.printOnConsole(" Prajyot Here first time call to make Dir for parent folder ["+docId + "]" );
								CommonPhoneGapUtil.getInstance().makeDir( rootDirectoryEntry, docId );
							}
						}
						createDirFlag = false;
					}
					
					if( callToServer )
					{
						callToServer = false;
						allFileCounter = allFileCounter + 1;
						
						String result = collabFilesAL.get( 0 );
						E12CommonUtils.printOnConsole(" Processing [" + result + "]");
						String[] strArray = result.split( ":" );
						final String docId = ( String ) strArray [ 0 ];
						final String docType = ( String ) strArray [ 1 ];
						curDocIdAndType = docId + "." + docType;
						collabFilesAL.remove( 0 );
						E12CommonUtils.printOnConsole(" Processing [" + curDocIdAndType + "]" + collabFilesAL.toString() );
						if( docType.equalsIgnoreCase( "zip" ) )
						{
							downloadZipCollab( docId, docType );
						}
						else
						{
							final String downloadFilePath = rootDirectoryEntry.getFullPath()+ "/" + docId + "." + docType;
							String serverURL =  
									E12Global.getHostUrl() + "/ibase/WebITMDocumentHandlerServlet?ACTION=GET_DOCUMENT&DOC_ID=" + docId + "&DOC_TYPE=" + docType;
							serverURL = URL.encode(serverURL);
							String noOfFileInfo = allFileCounter + " / " + totalFiles;
							CommonPhoneGapUtil.getInstance().downloadFile( noOfFileInfo, "1 / 1", downloadFilePath, serverURL, 0, new Callback<Boolean, String>()
							{
								@Override
								public void onFailure(String reason) 
								{
									E12DownloadInfo.getInstance().setDownloadFail( true );
									E12DownloadInfo.getInstance().setDownloadInfo( "! Error in download "+reason );
									collabFilesAL = null;
									E12DownloadInfo.getInstance().setVisibleProgressBar( false );
								}
								@Override
								public void onSuccess(Boolean result) 
								{ 
									callToServer = true;
									E12Storage.setItem( E12Storage.getItem("curConnection")+docId, downloadFilePath );
									String downloadFiles = E12Global.checkNull( E12Storage.getItem( "DownloadFiles" ) );
									if( !downloadFiles.contains( curDocIdAndType ) )
									{
										E12Storage.setItem( "DownloadFiles", downloadFiles + docId + ":" );
									}
									E12DownloadInfo.getInstance().setVisibleProgressBar( false );
									downloadCollabFiles() ;
								}
							});
						}
					}
					
				}
				else
				{
					E12DownloadInfo.getInstance().setDownloadInfo( "Contents download completed." );
					E12DownloadInfo.getInstance().setVisibleDownloadButton( false );
					E12DownloadInfo.getInstance().setVisibleProgressBar( false );
					allFileCounter = 0;
					totalFiles = 0;
				}
			}
		} 
		catch (Throwable e) {
			Window.alert( " Exception while downloadCollabFiles "+e.getMessage() );

		}
		
	}

	private static void downloadZipCollab( final String docId, final String docType )
	{
		try
		{
			
			String serverURL =  
					E12Global.getHostUrl() + "/ibase/WebITMDocumentHandlerServlet?ACTION=GET_DOCUMENT&DOC_ID=" + docId + "&DOC_TYPE=" + docType;
			serverURL = URL.encode(serverURL);
			E12CommonUtils.printOnConsole(" Call to WebITMDocumentHandlerServlet.... " + serverURL );
			RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, serverURL);
			try {
				requestBuilder.sendRequest(null, new RequestCallback() {
					@Override
					public void onResponseReceived(Request request, Response response) 
					{
						String responseStr = response.getText();
						callToServer = true;
						E12CommonUtils.printOnConsole(" After got response from WebITMDocumentHandlerServlet "+responseStr );
						if( responseStr.length() > 0 && responseStr !=null )
						{
							extractAndDownload( docId, docType );
						}
						else
						{
							downloadingError( docId, CommonPhoneGapUtil.getInstance().getErrorMessage( 3 ) );
						}
						
					}
					@Override
					public void onError(Request request, Throwable exception) 
					{
						Window.alert("Exception while downloading zip contents on server side for "+docId+docType +" exception"+exception.getMessage() );
					}
				});
			} 
			catch (Throwable e) 
			{
				Window.alert("Exception while downloading zip contents on server side for "+docId+docType);
			}
		}
		catch (Throwable e) 
		{
			Window.alert("Exception while downloading zip contents for "+docId+docType);
		}
		
	}
	private static void extractAndDownload(final String docId, String docType) 
	{
		try
		{
			final String clientPath = rootDirectoryEntry.getFullPath() + "/" + docId;
			
			//CommonPhoneGapUtil.getInstance().makeDir( rootDirectoryEntry, docId );
			E12CommonUtils.printOnConsole("Here Commented call to make Dir for parent folder ["+docId + "]" );
			
			String url = E12Global.getHostUrl() + "/ibase/E12ExtractFileServlet?docId=" + docId;
			E12CommonUtils.printOnConsole(" Call to E12ExtractFileServlet.... "+url );
			E12DownloadInfo.getInstance().setDownloadInfo( " Calling download to extract... " );
			RequestBuilder requestBuilder = new RequestBuilder(RequestBuilder.GET, url);
			try {
				requestBuilder.sendRequest(null, new RequestCallback() {
					
					@Override
					public void onResponseReceived(Request request, Response response) 
					{
						try
						{
							E12CommonUtils.printOnConsole(" After got response from E12ExtractFileServlet ");
							E12DownloadInfo.getInstance().setDownloadInfo( "Download content information received." );
							E12Storage.setItem( E12Storage.getItem("curConnection")+docId, clientPath );
							final String xmlString = response.getText();
							
							E12CommonUtils.printOnConsole( "DocId ["+docId+"] \n Folder Structure xml [" + xmlString + "]" );
							
							if( xmlString !=null && !"null".equalsIgnoreCase( xmlString ) && !"".equalsIgnoreCase( xmlString ) )
							{
								E12DownloadInfo.getInstance().setDownloadInfo( "Creating content structure at local..." );
								TreeMap<String, String> map = makeFolderTreeMap( xmlString );
								final String lastFolderName = map.isEmpty() ? "" : map.lastKey();
								for (Entry<String, String> entry : map.entrySet() )
								{
									String folderPathAndName = entry.getKey();
									CommonPhoneGapUtil.getInstance().makeDir( rootDirectoryEntry, folderPathAndName, new Callback<DirectoryEntry, FileError>(){
										
										@Override
										public void onSuccess(DirectoryEntry entry) 
										{
											try 
											{
												if( lastFolderName.contains( entry.getName() ) )
												{
													E12DownloadInfo.getInstance().setDownloadInfo( "Content structure created." );
													dowloadZipFileContent( xmlString );
												}
											} catch (Throwable e) 
											{
												Window.alert(" extractAndDownload :: onSuccess["+e.getMessage()+"]");
											}
										}
										
										@Override
										public void onFailure(FileError error) 
										{
											Window.alert("Exception in Make Dir ["+error.getErrorCode()+"]");
											
										}
									} );
								}
							}
							else
							{
								downloadingError( docId, CommonPhoneGapUtil.getInstance().getErrorMessage( 3 ) );
							}
						}
						catch( Throwable e)
						{
							E12CommonUtils.printOnConsole( "While recived response from E12ExtractFileServlet "+e.getMessage() );
						}
					} 
					@Override
					public void onError(Request request, Throwable exception) {
					}
				});
			} catch (RequestException e) {
				e.printStackTrace();
			}
		}
		catch(Throwable e)
		{
			Window.alert("Exception while extractAndDownload  "+docId+docType);
		}
	}
	
	public static void dowloadFilesFromServer(final String destPath, final String serverUrl, long fileSize )
	{
		try 
		{
			final String totalFileInfo =  allFileCounter + " / " + totalFiles ;
			final String zipFileInfo = zipFileCounter + " / " + noOfFilesInZip ;
			CommonPhoneGapUtil.getInstance().downloadFile( totalFileInfo, zipFileInfo, destPath, serverUrl, fileSize, new Callback<Boolean, String>() 
			{
				String downloadFiles = E12Global.checkNull( E12Storage.getItem( "DownloadFiles" ) );
				String curDocID = curDocIdAndType.substring( 0, curDocIdAndType.indexOf(".") );
				@Override
				public void onSuccess(Boolean result)
				{
					try 
					{
						E12CommonUtils.printOnConsole(" result ["+result+"}");
						E12CommonUtils.printOnConsole(" dowloadFilesFromServer totalFileInfo ["+totalFileInfo+"] zipFileInfo["+zipFileInfo+"]");
						E12CommonUtils.printOnConsole(" dowloadFilesFromServer zipFileCounter ["+zipFileCounter+"] noOfFilesInZip["+noOfFilesInZip+"]");
						E12CommonUtils.printOnConsole(" dowloadFilesFromServer downloadFiles ["+downloadFiles+"] curDocID["+curDocID+"]");
						if( !downloadFiles.contains( curDocID ) )
						{
							E12Storage.setItem( "DownloadFiles", downloadFiles + curDocID + ":" );
						}
						downloadFiles();
					} catch (Throwable e) {
						Window.alert("dowloadFilesFromServer :: onSuccess ["+e.getMessage()+"]");
					}
				}
				@Override
				public void onFailure(String reason) 
				{
					try 
					{
						
						downloadingError( curDocID, reason );
						
						/*E12DownloadInfo.getInstance().setDownloadFail( true );
						E12DownloadInfo.getInstance().setDownloadInfo( " ! Error in download ("+curDocID+") "+reason );
						E12DownloadInfo.getInstance().setStyleNameDownloadBtn( "refreshIcon" );
						E12DownloadInfo.getInstance().setVisibleDownloadButton( true );
						noOfFilesInZip = 0; 
						zipFileCounter = 0;
						allFileCounter = 0;*/
						
						E12CommonUtils.printOnConsole( "! Error in download ..........curDocID ["+curDocID+"]downloadFiles ["+downloadFiles+"]" );
						if( downloadFiles.contains( curDocID ) )
						{
							downloadFiles = downloadFiles.replace( curDocID + ":", " " ); 	
							E12Storage.setItem( "DownloadFiles", downloadFiles );
						}
						E12CommonUtils.printOnConsole( "! Error in download ..........curDocID ["+curDocID+"]downloadFiles ["+downloadFiles+"]" );
					} catch (Throwable e) {
						Window.alert("dowloadFilesFromServer :: onFailure ["+e.getMessage()+"]");
					}
					
				}
			});
		} 
		catch (Throwable e) 
		{
			Window.alert("While featching file from server "+e.getMessage());
		}
	}
	
	//Zip case
	public static void downloadFiles()
	{
		try 
		{
			E12CommonUtils.printOnConsole( "DCfilePathArryList ["+filePathArryList+"]" );
			
			if(  filePathArryList.size() > 0 )
			{
				E12CommonUtils.printOnConsole( "filePathArryList ["+filePathArryList.size()+"]" );
//				for(String filePathValue : filePathArryList )
//				{
//					E12CommonUtils.printOnConsole( filePathValue );
//				}
				zipFileCounter = zipFileCounter + 1;
				String filePathAndSize = filePathArryList.get( 0 );
				String[] splitValues = filePathAndSize.split( "~~" );
				String filePath = splitValues[0];
				long fileSize = Long.parseLong( splitValues[1] );
				E12CommonUtils.printOnConsole( filePath );
				filePathArryList.remove( 0 );
				String serverUrl = E12Global.getHostUrl() + "/ibase/extractedFiles/" + filePath;
				String destPath =  rootDirectoryEntry.getFullPath()+"/"+filePath;
				dowloadFilesFromServer( destPath,  serverUrl, fileSize );
			}
			else
			{
					noOfFilesInZip = 0;
					zipFileCounter = 0;
					filePathArryList = null;
					E12DownloadInfo.getInstance().setVisibleProgressBar( false );
					E12DownloadInfo.getInstance().setDownloadInfo( "Gathering information for next file download" );
					E12CommonUtils.printOnConsole( "Gathering information for next file download" );
					downloadCollabFiles();
				
			}
		} 
		catch (Throwable e) 
		{
			E12CommonUtils.printOnConsole( " Exception :: in downloadFiles ["+e.getMessage()+"]");
			//Window.alert(" Exception :: in downloadFiles ["+e.getMessage()+"]");
		}
	}
	
	private static void dowloadZipFileContent( String xmlString )
	{
		E12DownloadInfo.getInstance().setDownloadInfo( "Starting download..." );
		makeFileTreeMap( xmlString, new Callback<TreeMap< String, String>, Boolean>() 
		{
			@Override
			public void onFailure(Boolean reason) 
			{}
			@Override
			public void onSuccess(TreeMap< String, String> fileMap) 
			{
				try {
					filePathArryList = new ArrayList<String>();
					//fileNameList = new ArrayList<String>();
					for ( Entry<String, String> entry : fileMap.entrySet() )
					{
						String filePath = entry.getKey();
						String fileName = entry.getValue();
						
						filePathArryList.add( filePath );
						//fileNameList.add( fileName );
					}
					zipFileCounter = 0;
					noOfFilesInZip = filePathArryList.size();
					downloadFiles();
				} catch (Throwable e) {
					Window.alert("dowloadZipFileContent :: onSuccess ["+e.getMessage()+"]");
				}
			}
		}); 
	}
	
	public static TreeMap<String, String> makeFolderTreeMap( String xmlOutput )
	{
		try 
		{
			TreeMap< String, String > folderStructureTreeMap = new TreeMap< String, String >();
			Document document = XMLParser.parse( xmlOutput );
			XMLParser.removeWhitespace( document );
			NodeList foldersList = document.getElementsByTagName( "FOLDER" );
			//NodeList filesList = document.getElementsByTagName("FILE");
			int folderLength  = foldersList.getLength();
			for ( int i = 0; i < folderLength; i++ ) 
			{
				NodeList childList = foldersList.item(i).getChildNodes();
				String folderName="";
				String folderPath="";
				int childListLength  = childList.getLength();
				for ( int j = 0; j < childListLength; j++ ) 
				{
					Node node = childList.item(j);
					String nodeName = node.getNodeName();
					String nodeValue = node.getFirstChild().getNodeValue();
					
					if ( "NAME".equalsIgnoreCase( nodeName ) )
					{
						folderName = nodeValue;
					}
					else if ( "PATH".equals( nodeName ) )
					{
						folderPath = nodeValue;
					}
				}
				folderStructureTreeMap.put( folderPath, folderName );
			}
			return folderStructureTreeMap;
			
		} catch (Exception e) 
		{
			Window.alert( "Exception :: In makeFolderTreeMap mehtod :: Exception " + e.toString() );
		}
		return null;
	}
	public static void  makeFileTreeMap( String xmlOutput, Callback<TreeMap< String, String >, Boolean> callback )
	{
		try
		{
			TreeMap< String, String > fileStructureTreeMap = new TreeMap< String, String >();
			Document document = XMLParser.parse( xmlOutput );
			XMLParser.removeWhitespace( document );
			NodeList filesList = document.getElementsByTagName( "FILE" );
			int fileLstLength = filesList.getLength();
			for ( int i = 0; i < fileLstLength; i++ ) 
			{
				NodeList childList = filesList.item( i ).getChildNodes();
				String fileName="";
				String filePath="";
				String fileSize="";
				int childLstLength = childList.getLength();
				for ( int j = 0; j < childLstLength; j++ ) 
				{
					Node node = childList.item( j );
					String nodeName = node.getNodeName();
					String nodeValue = node.getFirstChild().getNodeValue();
					if( "NAME".equalsIgnoreCase( nodeName ) )
					{
						fileName = nodeValue;
					}
					else if( "PATH".equals( nodeName ) )
					{
						filePath = nodeValue;
					}
					else if( "SIZE".equals( nodeName ) )
					{
						fileSize = nodeValue;
					}
				}
				filePath = filePath +"~~"+ fileSize;
				fileStructureTreeMap.put( filePath, fileName  );
			}
			callback.onSuccess( fileStructureTreeMap );
			
		}catch (Exception e)
		{
			Window.alert("Exception :: In makeFileTreeMap mehtod :: Exception["+e.getMessage()+"]");
		}
	}
	
	public static void downloadClientLogo( final Callback< String, String > callback )
    {
        try 
        {
			getExistCollabFilesList( new Callback<String, FileError>()
			{
			    @Override
			    public void onFailure(FileError reason)
			    {
			    	callback.onSuccess( "" );
			    }
			    @Override
			    public void onSuccess(String result)
			    {
			        String fileName = "ClientLogo.png";
			        final String fileFullPath = rootDirectoryEntry.getFullPath()+ "/ClientLogo.png";
			        CommonPhoneGapUtil.getInstance().isFileExits(rootDirectoryEntry, fileName, new Callback<Boolean, Boolean>()
			        {
			            @Override
			            public void onFailure(Boolean reason)
			            {
			                callback.onSuccess( "" );
			            }
			            @Override
			            public void onSuccess(Boolean result)
			            {
			                if( result )
			                {
			                    callback.onSuccess( fileFullPath );
			                }
			                else
			                {
			                	if( "".equalsIgnoreCase( E12Global.getHostUrl() ) || E12Global.getHostUrl() == null )
			                	{
			                		callback.onSuccess( "" );
			                	}
			                	else
			                	{
			                		final String downloadClientLogoPath = rootDirectoryEntry.getFullPath()+ "/ClientLogo.png";
			                		String serverURL = E12Global.getHostUrl() + "/ibase/images/ClientLogo.png";
			                		serverURL = URL.encode(serverURL);
			                		CommonPhoneGapUtil.getInstance().downloadFile(downloadClientLogoPath, serverURL, new Callback<Boolean, Boolean>()
			                		{
			                			@Override
			                			public void onSuccess(Boolean result)
			                			{
			                				callback.onSuccess( fileFullPath );
			                			}
			                			@Override
			                			public void onFailure(Boolean reason)
			                			{
			                				callback.onSuccess( "" );
			                			}
			                		});
			                	}
			                }
			            }
			        });
			    }
			});
		}
        catch (Throwable e) 
		{
        	Window.alert("While downloading client images @ device  " + e );
			
		}
    }
    public static void downloadUserImg( final Callback< String, String> callback )
    {
    	
    	try 
    	{
    		getExistCollabFilesList( new Callback<String, FileError>()
    		{
				@Override
				public void onFailure(FileError reason) 
				{
					callback.onSuccess("");
				}
				@Override
				public void onSuccess(String result) 
				{
			        //String userConnection = (String) ( E12Global.getConnectionId() == null || "".equalsIgnoreCase( E12Global.getConnectionId() ) ? "" : E12Global.getConnectionId().subSequence(0, E12Global.getConnectionId().length() - 2 ) ) ;
			        String fileName = E12Constants.userID.trim() + ".png";
			        final String fileFullPath = rootDirectoryEntry.getFullPath() + "/" + fileName;
			        CommonPhoneGapUtil.getInstance().isFileExits(rootDirectoryEntry, fileName, new Callback<Boolean, Boolean>()
			        {
			            @Override
			            public void onSuccess(Boolean result)
			            {
			                if( result )
			                {
			                    callback.onSuccess( fileFullPath );
			                }
			                else
			                {
			                    String serverURL = E12Global.getHostUrl() + "/ibase/images/" + E12Constants.userID.trim() + ".png";
			                    serverURL = URL.encode(serverURL);
			                    CommonPhoneGapUtil.getInstance().downloadFile(fileFullPath, serverURL, new Callback<Boolean, Boolean>()
			                    {
			                        @Override
			                        public void onSuccess(Boolean result)
			                        {
			                            callback.onSuccess( fileFullPath );

			                        }
			                        @Override
			                        public void onFailure(Boolean reason)
			                        {
			                            callback.onSuccess( "" );
			                        }
			                    });
			                }
			            }
			            @Override
			            public void onFailure(Boolean reason)
			            {
			            	callback.onSuccess( "" );
			            }
			        });
				}
    		});
    					
		} catch (Throwable e) 
		{
		   Window.alert( "While downloading user img "+e.getMessage() );	
		}
    }
    
    public static void downloadingError( String curDocID, String reason )
    {
    	E12DownloadInfo.getInstance().setDownloadFail( true );
		E12DownloadInfo.getInstance().setDownloadInfo( " ! Error in download ("+curDocID+") "+reason );
		E12DownloadInfo.getInstance().setStyleNameDownloadBtn( "refreshIcon" );
		E12DownloadInfo.getInstance().setVisibleDownloadButton( true );
		E12DownloadInfo.getInstance().setVisibleProgressBar( false );
		noOfFilesInZip = 0; 
		zipFileCounter = 0;
		allFileCounter = 0;
    }
}
