/* Following are the major points of Firm plan process
1. If campgn_no is not empty use the following sql and get all the workorder in the campaign in a list (woList)
    select a.work_order
    from worder_campaign a,workorder b
    where a.work_order = b.work_order and
    a.campgn_no = ? and (case when b.status is null then 'P' else b.status end) in ('P','M','U')    ;
2. If campgn_no is empty add the work_order in the list (woList)
3. There should be a rpovision to write a log in a specific location for all success/failure with details
4. explode BOM of each order
5. Sort item match_potency = 'Y'  as 1, match_potency = 'N' and adj_potency is not null as 2 and rest as 3
6. Stock allocation order (soft allocation during process)
    6.1. Check reserved stock
    6.2. Allocate fresh stock
    6.3. allocate alternate item stock
    6.4. check stock from other site for main item
    6.5. check stock from other site for alternate item
    6.6. potency calculation (if applicable), also consider potency formula
    6.7. controlled substance to be taken care off, the active material expiry date should not be less than any of the raw material
    6.8. same manufacturer code (supp_code__mfg) to be considered in case of multiple lot (if applicable mfg_ref)
    6.9. iss_criteria W (whole lot stock.quantity) and F (packet quantity stock.qty_per_art) to be considered

7. All the details of stock requirement and availability to be displayed to the user
    7.1. Alternate item stock to be displayed in different colour
    7.2. if shortage of stock show in red colour

8. If any shortage for critical item, not to allow firmplan
9. If stock is sufficient for all critical item following activities to be done:
    9.1. Same site do allocation (inv_allocate/inv_alloc_det), hard allocate stock
    9.2. Other site (trans_tran = 'D') stock, create distorder and confirm
    9.3. allocate stock against distorder
    9.4. Other site (trans_tran = 'P') stock, create sale order and confirm
    9.5. allocate stock against sale order

x. release contract if applicable


Point # 1  -  Some cases it is configured that stock should be allocated from single item, in such case  stock from main item and multiple item cannot be mixed, there are flags in bomdet to specify the same.

 CONSIDER_PARTIAL_ALT and ALLOCATE_TYPE



Point # 2 - item.controlled_yn = "Y" for the workorder.item_code and bomdet.item_category of the stock to be
allocated = "A" then get the expiry date of the workorder item and compare the same with expiry date of the stock,
if stock expiry date is less than the workorder.exp_date the stock cannot be allocated, but if the variable
least_expdt_active_rm is specified as "Y" in process filter  then the min(exp_date) stock available to be updated
as exp_date of workorder.

Point # 3 - if bomdet.supp_code__mfg is specified (multiple supplier code separated by comma) and bomdet.mfg_ref also specified, stock should be allocated from single manufactuer (stock.supp_code__mfg)

Point # 4  - iss_criteria = "W"  the full stock record to be allocated even if requirement is less
                          = "F"  stock should be allocated in multiples of stock.qty_per_art based on the actual requirement

New Points:

1. Stock should be allocated only for item for which bomdet.usage_type = "R"

2. This may be already there - For item for which bomdet.CONSIDER_LOT_NO__ISSUE  = "Y"  stock to be allocated for lot_no specified in workorder.lot_no__issue (multiple coma separated)

3. for item having bomdet.ALLOCATE_TYPE  = "N"  stock not to be allocated, if = "A" allocate any stock,  "O" allocate original item stock
*/


package ibase.webitm.ejb.mfg;

import ibase.system.config.AppConnectParm;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.utility.UserInfoBean;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.ProcessEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.dis.InvAllocTraceBean;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;

import java.io.File;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

import javax.naming.InitialContext;
import javax.xml.rpc.ParameterMode;

import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
//import org.apache.commons.net.ntp.TimeStamp;
//import ibase.utility.GenericUtility;



@javax.ejb.Stateless
public class WoFirmplanPrc extends ProcessEJB implements WoFirmplanPrcLocal,WoFirmplanPrcRemote //SessionBean
{
	//ArrayList<String> testSite = new ArrayList<String>();

	ArrayList<WorderStkBean> worderStkBeanListTemp = new ArrayList<WorderStkBean>();
	//GenericUtility genericUtility = GenericUtility.getInstance();
	E12GenericUtility genericUtility= new  E12GenericUtility();
	ArrayList<WorkOrderDetailBean> workOrderBeanList = new ArrayList<WorkOrderDetailBean>();
	ArrayList<WorderStkBean> worderStkBeanList = new ArrayList<WorderStkBean>();
	ArrayList<WorderStkBean> tempWorderExpStkBeanList = new ArrayList<WorderStkBean>();
	//ArrayList<WorderStkBean> tempWorderStkBeanList = new ArrayList<WorderStkBean>();
	ArrayList<SiteItemSummaryBean> siteItemReqQtyList = new ArrayList<SiteItemSummaryBean>();
	ArrayList<SiteItemSummaryBeanNC> siteItemReqQtyListNC = new ArrayList<SiteItemSummaryBeanNC>();
	Map<String,String>firmplanDetailMap = new HashMap<String,String>();
	Map<String,String>doneStockDetailsMap = new HashMap<String,String>();
	Map<String,String> transTranMap = new HashMap<String,String>();
	Map<String,String> saleDistOrderMap = new HashMap<String,String>();
	HashMap<String,Double> nonCriticalMap = new HashMap<String, Double>();
	HashMap<String,Integer>zeroStockCheckMap = new HashMap<String,Integer>();
	Map<String,Boolean> worderExpLevSufficient = new HashMap<String,Boolean>();
	CommonConstants commonConstantsObj  = new CommonConstants();
	ArrayList<String> workOrderList = new ArrayList<String>();
	ArrayList addlnStck = new ArrayList();
	@SuppressWarnings("static-access")
	String database = commonConstantsObj.DB_NAME;
	String campgnNoGlb = "",chgUser,termId = "",xtraParamsG = "";
	DistCommon disCommon = new DistCommon();
	DecimalFormat df = new DecimalFormat("########0.000");
	boolean isError = false,isReallocation = false;
	
	
	Map<String,Double>potencyAdjMapY = null;
	Map<String,Double>potencyAdjMapN = null;
	Map<String,Double> AdjPotencyExplevQtyMap = null;
	String leastExpdtActivRm = "";
	HashMap<String, String> sqlMap=new HashMap<String, String>();
	
	

	public String process() throws RemoteException,ITMException
	{
		return "";
	}

	public String getData(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		String rtrStr = "";
		Document headerDom = null;
		Document detailDom = null;

		
		System.out.println("getData(xmlString,xmlString2,windowName,xtraParams CALLED..."+ xmlString);
		try
		{
			
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				System.out.println("XML String :"+xmlString);
				headerDom = genericUtility.parseString(xmlString);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				System.out.println("XML String :"+xmlString2);
				detailDom = genericUtility.parseString(xmlString2);
			}
			rtrStr = getData(headerDom, detailDom, windowName, xtraParams);

		}
		catch (Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception :WoFirmplanPrc:getData method : " + e.getMessage() + ":");
			rtrStr = e.getMessage();
		}
		return rtrStr;
	}

	public String getData(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		return "";
	}

	public String process(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		String retStr = "";
		Document detailDom = null;
		Document headerDom = null;

		//GenericUtility genericUtility = GenericUtility.getInstance();
		E12GenericUtility genericUtility= new  E12GenericUtility();
		try
		{

			if(xmlString != null && xmlString.trim().length()!=0)
			{
				headerDom = genericUtility.parseString(xmlString);
				System.out.println("headerDom" + headerDom);
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				detailDom = genericUtility.parseString(xmlString2);
				System.out.println("detailDom" + detailDom);
			}
			retStr  = processWorkOrder(headerDom, detailDom, windowName, xtraParams) ;

		}
		catch (Exception e)
		{
			System.out.println("Exception :WoFirmplanPrc:process:" + e.getMessage() + ":");
			e.printStackTrace();
			retStr = e.getMessage();
			throw new ITMException(e);
		}
		return retStr;

	}
	@SuppressWarnings({ "unused", "rawtypes", "unchecked" })
	public String processWorkOrder(Document headerDom, Document detailDom, String windowName, String xtraParams) throws Exception
	{
		//GenericUtility genericUtility =GenericUtility.getInstance();
		E12GenericUtility genericUtility= new  E12GenericUtility();
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		String sql ="", workOrder = "",campgnNo = "",errString = "", potencyRetStr="",
				errorCodeRet = "";
		Connection conn = null;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		int count = 0;

		ArrayList<String> workOrderErrorList = new ArrayList();
		Map<String,String>stockDetailMap = new HashMap<String,String>();
		/**/
		try
		{
			isReallocation = false;
			isError = false;
			xtraParamsG = xtraParams;
			System.out.println("xtraParams----->>["+xtraParams+"]");
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode");
			termId = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
			ConnDriver connDriver = new ConnDriver();
			//Changes and Commented By Poonam on 08-06-2016 :START
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//Changes and Commented By Poonam on 08-06-2016 :END

			conn.setAutoCommit(false);
			connDriver = null;
			workOrder = checkNull(genericUtility.getColumnValue("work_order",headerDom));
			campgnNo = checkNull(genericUtility.getColumnValue("campgn_no",headerDom));
			MfgCommon mfgCommon = new MfgCommon();
			this.leastExpdtActivRm = mfgCommon.getEnvMfg("999999", "LEAST_EXPDT_ACTIVE_R", conn);
			if ("NULLFOUND".equals(leastExpdtActivRm))
			{
				leastExpdtActivRm = "N";
			}
			
			//this.leastExpdtActivRm = checkNull(genericUtility.getColumnValue("least_expdt_active_rm",headerDom));
			System.out.println("workOrder----->>["+workOrder+"] campgnNo---->>["+campgnNo+"]");
			System.out.println("leastExpdtActivRm----->>["+this.leastExpdtActivRm+"]");

			if(workOrder.length() > 0 || campgnNo.length() > 0)
			{
				if(workOrder.length() > 0) {
					int countCampaign = 0;
					sql = "select count(*) as count from workorder where work_order =  ? and campgn_no is not null and status ! = 'F' ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, workOrder);
					rs = pstmt.executeQuery();
					if(rs.next()){
						countCampaign = rs.getInt("count");
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					
					if(countCampaign > 0) {
						System.out.println("Workorder already done through Campaign Number.");
						errString="VTFPCRCMNO";
						errString = itmDBAccessEJB.getErrorString("",errString,"","",conn);
						return errString;
					}
					
				}
				workOrderList = getWorkOrderList(workOrder,campgnNo,conn);
				System.out.println("workOrderList----->>["+workOrderList+"]");
			}
			else
			{
				errString="VTPOST0";
				errString = itmDBAccessEJB.getErrorString("",errString,"","",conn);
				return errString;
			}

			// check for inactive route
			if (campgnNo != null && campgnNo.trim().length() > 0)
			{
				sql = "select count(1) from worder_campaign a,workorder b, route c where a.work_order = b.work_order and "
					+ " a.campgn_no = ? and (case when b.status is null then 'P' else b.status end) in ('P','M','U') "
					+ " and c.route_code = b.route_code "
					+ " and c.active = 'N' ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, campgnNo);
			}
			else
			{
				sql = "select count(1) from workorder b, route c where b.work_order = ? "
					+ " and (case when b.status is null then 'P' else b.status end) in ('P','M','U') "
					+ " and c.route_code = b.route_code "
					+ " and c.active = 'N' ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, workOrder);
				
			}
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				count = rs.getInt(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			if(count > 0)
			{
				errString="VTROUTACT";
				errString = itmDBAccessEJB.getErrorString("",errString,"","",conn);
				return errString;
			}
			
			//VTWOAPRC
			for(String worder : workOrderList)
			{
				sql = "select count(*) from workorder_bill where work_order = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, worder);
				rs = pstmt.executeQuery();

				if(rs.next())
				{
					count = rs.getInt(1);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				if(count > 0)
				{
					errString="VTWOAPRC";
					errString = itmDBAccessEJB.getErrorString("",errString,"","",conn);
					return errString;
				}
			}

			if(workOrderList.size() > 0)
			{
				errString  = explodBomAndPopulateBean(workOrderList,conn,campgnNo);
			}
			else
			{
				errString="VTAPLAN";
				errString = itmDBAccessEJB.getErrorString("",errString,"","",conn);
				return errString;
			}
			System.out.println("errString After exp bom----->>["+errString+"]");
			//Check allocate Stock (Soft allocation)
			System.out.println("worderStkBeanList size 1="+worderStkBeanList.size());
			System.out.println("worderExpLevSufficient before stock allocation ["+worderExpLevSufficient+"]");
			stockDetailMap = stockAllocation(conn,campgnNo);
			System.out.println("worderExpLevSufficient after stock allocation ["+worderExpLevSufficient+"]");
			System.out.println("worderStkBeanList size 2="+worderStkBeanList.size());
			System.out.println("After stockAllocation stockDetailMap----->>["+stockDetailMap+"]");
			System.out.println("worderExpLevSufficient----->>["+worderExpLevSufficient+"]");
			//displayStkBean("After Stock allocation..............");
			if(stockDetailMap.size() > 0)
			{
				errorCodeRet = stockDetailMap.get("ERROR_CODE");
				if(errorCodeRet.length() > 0)
				{
					errString = itmDBAccessEJB.getErrorString("",errorCodeRet,"","",conn);
					return errString;
				}

				/*if(isSufficient)
				{*/
				//stock sufficient
				System.out.println("worderStkBeanList size 3="+worderStkBeanList.size());
				// 31-may-16 manoharan sort on work_order,exp_lev,exp_date
				//Collections.sort(worderStkBeanList, WorderStkBean.WoStkBeanComparator);
				// end 31-may-16 manoharan sort on work_order,exp_lev,exp_date
				
				
				
				
				System.out.println("worderExpLevSufficient before check potency ["+worderExpLevSufficient+"]");
				if(!worderExpLevSufficient.containsValue(false))
				{
					System.out.println("Stock is sufficient first time proceed for potency check::");
				potencyRetStr = checkStockPotencyNew(conn,campgnNo);
				// 31-may-16 manoharan sort on work_order,exp_lev,exp_date
				//Collections.sort(worderStkBeanList, WorderStkBean.WoStkBeanComparator);
				System.out.println("worderExpLevSufficient after check potency ["+worderExpLevSufficient+"]");
				// end 31-may-16 manoharan sort on work_order,exp_lev,exp_date
				System.out.println("After checkStockPotency :["+potencyRetStr+"]");
				System.out.println("worderStkBeanList size 4="+worderStkBeanList.size());
				}
				//displayStkBean(workOrderBeanList, "H");
				//displayStkBean(worderStkBeanList, "D");
				//potencyRetStr = checkStockPotency(conn);
				System.out.println("worderExpLevSufficient after stock and potency allocation ["+worderExpLevSufficient+"]");
				if(worderExpLevSufficient.containsValue(false))
				{
					System.out.println("Stock not sufficient...................");
					errString = generateXml(conn,"E",campgnNo);//TODO
				}
				else
				{
					System.out.println("Stock sufficient...................");
					errString = populateWorkOrderBill(conn,campgnNo);
					System.out.println("After populateWorkOrderBill :["+errString+"]");
					//displayStkBean(workOrderBeanList, "H");
					//displayStkBean(worderStkBeanList, "D");
					System.out.println("worderStkBeanList size 5="+worderStkBeanList.size());
					errString = insertInInvAllocate(conn,campgnNo);
					System.out.println("worderStkBeanList size 6="+worderStkBeanList.size());

					errString = createDistSaleOrder(conn,campgnNo,workOrder,xtraParams,"C");
					
					errString = createDistSaleOrder(conn,campgnNo,workOrder,xtraParams,"NC");
					//CreateDistSorderAllocation
					//according to transType create dist. or sale order
					errString = generateXml(conn,"S",campgnNo);//TODO
				}
				/*if(errString !=null && errString.indexOf("Error") > -1)
					{
						return errString;
					}*/
				/*}
				else
				{
					errString = generateXml(conn);
				}*/
			}


		}
		catch(Exception e)
		{
			isError = true;
			System.out.println("Exception in processWorkOrder method------- ");
			errString = e.getMessage();
			e.printStackTrace();
			conn.rollback();
			writeWorkOrderLog(e.toString(),campgnNo);//TODO
			throw new Exception(e);
		}
		finally
		{
			//System.out.println("Transaction rollbaking............@@");
			//conn.rollback();
			System.out.println("In @@finally processWorkOrder isError : ["+isError+"]");
			if(isError)
			{
				errString="VTPRCNC";
				errString = itmDBAccessEJB.getErrorString("",errString,"","",conn);
			}

			if(genericUtility != null)
			{
				genericUtility = null;
			}
			System.out.println("2 In @@finally worderExpLevSufficient ["+worderExpLevSufficient+"]");
			if(!(worderExpLevSufficient.containsValue(false)) && errString.indexOf("workorders") > -1)
			{
				System.out.println("Transaction commiting....................");
				conn.commit();
			}
			else
			{
				System.out.println("Transaction rollbaking....................");
				conn.rollback();
			}
			workOrderBeanList.clear();
			worderStkBeanList.clear();
			siteItemReqQtyList.clear();
			siteItemReqQtyListNC.clear();
			firmplanDetailMap.clear();
			worderExpLevSufficient.clear();
			transTranMap.clear();
			doneStockDetailsMap.clear();
			saleDistOrderMap.clear();
			System.out.println("Non critical map before clearing:::" + nonCriticalMap);
			nonCriticalMap.clear();
			System.out.println("zero check map before clearing:::" + zeroStockCheckMap);
			zeroStockCheckMap.clear();
			commonConstantsObj = null;

			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(conn != null)
			{
				conn.close();
				conn = null;
			}
		}
		return errString;

	}
	
	/*public String InsertDistIssue(String distOrderNo, Connection conn, String campaignNo, String workOrder, String xtraParams)
	{
	String sql = "";
	PreparedStatement pstmt = null, pstmt1 = null, pstmt2 = null;
	 Statement stmt1 = null; 
	ResultSet rs = null,rs1 = null,rs2 = null;
	HashMap hashMap1 = null;
	ArrayList DistStkList = null;
	String tranType = "", siteCode = "",itemCode = "",lotNo = "",lotSl = "",unit  = "",unitAlt  = "",
			itemSer  = "",packCode  = "",packInstr = "",batchNo = "",grade  = "", 
			dimension  = "",rate  = "",taxClass  = "",taxChap  = "",taxEnv  = "", locCode  = "",rateClg  = "", suppSour = "",itemDescr = "",
			 siteCodeMfg = "", suppCodeMfg = "",sundryCode ="",priceList = "", priceListClg = "",siteCodeShip = "", checkIntegralQty = "",
			 tranTypeParent = "", rate1 = "", sql2 = "",tabValue = "", tranDate = "", xmlString = "", retString = "",userId = "", chgTerm = "", locCodeTo = "";
	double allocQty  = 0.0d;
	double qtyConfirm = 0.0D; double qtyShipped = 0.0D; double lcQtyOrderAlt = 0.0D; double lcFact = 0.0D;
	double quantity  = 0.0d;
	int count = 0;
	java.util.Date expDate = null, mfgDate = null;
	double potencyPerc = 0.0d;
	double mod = 0.0D; double minputQty = 0.0D; double remQuantity = 0.0D; double stockQty = 0.0D; double integralQty = 0.0D;
	double grossPer = 0.0D; double netPer = 0.0D; double tarePer = 0.0D; double grossWt = 0.0D; double netWt = 0.0D; double tareWt = 0.0D; double rateClgVal = 0.0D; double rate2 = 0.0D;
	double disAmount = 0.0D; double amount = 0.0D; double shipperQty = 0.0D; double discount = 0.0D;
	PreparedStatement distIssDetPstmt = null,pstmtHdr = null;
	 ResultSet rs3 = null;
	
	String active = "",errCode = "",errString = "", trackShelfLife = "", descr = "",retestDate = "", returnString = ""; 
	int MAXLINESALLOWED = 0,countDtl = 0, lineNoIssDet = 0,distCount = 0,totalNoArt = 0,minShelfLife = 0; int noArt1 = 0, noArt = 0,linenoCtr = 0; 
	int cnt = 0,mLineNoDist = 0;
	String lineNo = "1";//took string cz parsing problem in incalloctrace bean
	boolean isDetFound = false;
	StringBuffer xmlBuff = new StringBuffer();

	DistStkUpdLocal distStkUpd = null;
	String xmldetail1 = "", detail2stock = "";
	StringBuffer detail2xml = new StringBuffer();
	StringBuffer xmldetail2ftr = new StringBuffer();
	xmldetail2ftr.append("</Detail2>");
	StringBuffer xmldetail2stock = null;
	PalletOutPos pos = new PalletOutPos();
	

	
	try {
		System.out.println("Inside Create Distribution issue");

		SimpleDateFormat sdf = new SimpleDateFormat(this.genericUtility.getApplDateFormat());
		SimpleDateFormat dbf = new SimpleDateFormat(this.genericUtility.getDBDateFormat());

		
		userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
		chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
		
		tranDate = getCurrdateAppFormat(campaignNo);

		

		sql = "SELECT D.QTY_ALLOC,D.SITE_CODE__MFG,D.QUANTITY AS DIST_QTY,DT.LINE_NO AS LINE_NO_DIST,H.SITE_CODE__SHIP AS SITE_CODE,H.TRAN_TYPE," +
		" DT.TAX_CLASS,DT.TAX_CHAP,DT.TAX_ENV,S.ITEM_CODE,S.LOT_NO,S.LOT_SL,S.QUANTITY,S.ALLOC_QTY,S.EXP_DATE,S.UNIT,S.UNIT__ALT,S.ITEM_SER,S.MFG_DATE," +
		"S.NO_ART,S.POTENCY_PERC,S.PACK_CODE,S.LOC_CODE,S.BATCH_NO,S.GRADE ,S.GROSS_WEIGHT,S.TARE_WEIGHT,S.NET_WEIGHT,S.DIMENSION,S.RETEST_DATE," +
		"S.SUPP_CODE__MFG,S.PACK_INSTR,S.RATE,S.ACCT_CODE__INV,S.CCTR_CODE__INV,DT.RATE__CLG,DT.QTY_CONFIRM,DT.QTY_SHIPPED " +
		"FROM DISTORDER_ALLOC D,DISTORDER H,DISTORDER_DET DT,STOCK S " +
		"WHERE D.DIST_ORDER = ? AND D.DIST_ORDER = H.DIST_ORDER AND H.DIST_ORDER = DT.DIST_ORDER AND" +
		" D.LINE_NO = DT.LINE_NO AND D.LOT_NO = S.LOT_NO AND D.LOT_SL = S.LOT_SL AND D.ITEM_CODE = S.ITEM_CODE" +
		" AND D.LOC_CODE = S.LOC_CODE AND S.SITE_CODE = H.SITE_CODE__SHIP";
		pstmt = conn.prepareStatement(sql);
		pstmt.setString(1,distOrderNo);
		rs = pstmt.executeQuery();
		DistStkList = new ArrayList();
		while(rs.next()){
			
			hashMap1 = new HashMap();
			itemCode = rs.getString("item_code");
			siteCode = rs.getString("site_code");
			locCodeTo = rs.getString("loc_code");
			lotNo = rs.getString("LOT_NO");
			lotSl = rs.getString("LOT_SL");
			quantity = rs.getDouble("QUANTITY");
			allocQty = rs.getDouble("ALLOC_QTY");
			
			
			hashMap1.put("tran_date", new java.sql.Date(System.currentTimeMillis()));
			hashMap1.put("ref_ser","D-SO");
			hashMap1.put("ref_id", distOrderNo);
			hashMap1.put("ref_line", lineNo);
			hashMap1.put("item_code", itemCode);
			hashMap1.put("site_code", siteCode);
			hashMap1.put("loc_code",rs.getString("loc_code"));//TODO
			hashMap1.put("lot_no",lotNo);
			hashMap1.put("lot_sl",lotSl);
			hashMap1.put("alloc_qty", (quantity-allocQty));
			hashMap1.put("chg_win","W_STOCK_TRANSFER_MULTI");
			hashMap1.put("chg_user", userId);
			hashMap1.put("chg_term", chgTerm);
			hashMap1.put("tran_type", rs.getString("TRAN_TYPE"));
			hashMap1.put("line_no_dist", rs.getString("LINE_NO_DIST"));
			hashMap1.put("exp_date", rs.getTimestamp("EXP_DATE"));
			hashMap1.put("unit", rs.getString("UNIT"));
			hashMap1.put("unit__alt", rs.getString("UNIT__ALT"));
			hashMap1.put("item_ser", rs.getString("ITEM_SER"));
			hashMap1.put("site_code__mfg", rs.getString("SITE_CODE__MFG"));
			hashMap1.put("mfg_date", rs.getTimestamp("MFG_DATE"));
			hashMap1.put("potency_perc", rs.getDouble("POTENCY_PERC"));
			hashMap1.put("quantity", rs.getDouble("DIST_QTY"));
			hashMap1.put("qty_alloc", rs.getDouble("ALLOC_QTY"));
			hashMap1.put("pack_code", rs.getString("PACK_CODE"));
			hashMap1.put("pack_instr", rs.getString("PACK_INSTR"));
			hashMap1.put("batch_no", rs.getString("BATCH_NO"));
			hashMap1.put("grade", rs.getString("GRADE"));
			hashMap1.put("gross_weight", rs.getDouble("GROSS_WEIGHT"));
			hashMap1.put("tare_weight", rs.getDouble("TARE_WEIGHT"));
			hashMap1.put("net_weight", rs.getDouble("NET_WEIGHT"));
			hashMap1.put("dimension", rs.getString("DIMENSION"));
			hashMap1.put("retest_date", rs.getTimestamp("RETEST_DATE"));
			hashMap1.put("supp_code__mfg", rs.getString("SUPP_CODE__MFG"));
			hashMap1.put("rate", rs.getString("RATE"));
			hashMap1.put("tax_class", rs.getString("TAX_CLASS"));
			hashMap1.put("tax_chap", rs.getString("TAX_CHAP"));
			hashMap1.put("tax_env", rs.getString("TAX_ENV"));
			hashMap1.put("loc_code__to", locCodeTo);
			hashMap1.put("rate__clg", rs.getDouble("RATE__CLG" ));
			hashMap1.put("qty_shipped", rs.getDouble("QTY_SHIPPED" ));
			hashMap1.put("qty_confirm", rs.getDouble("QTY_CONFIRM"));
			DistStkList.add(hashMap1);
			
			if((quantity-allocQty) > 0)
			{	 
				System.out.println("quantity is greater than alloc qty:::");
				System.out.println("hashmap:::::" + hashMap1.toString());
				distStkUpd = getComponent("DistStkUpd");
				if (distStkUpd.updAllocTrace(hashMap1, conn) > 0)
				{
					System.out.println("distStkUpd.UpdAllocTrace(HashMap, Connection) : Sucessuful!");
				}
			}
			
		
		}

		System.out.println("list passed for DI::: " + DistStkList.toString());
		returnString = pos.createDistIssue(siteCode, distOrderNo, DistStkList, xtraParams, conn);
		
		System.out.println("return string in wofirmplacprc:::" + returnString);
	
	} catch (Exception e) {
		System.out.println("::::" + this.getClass().getSimpleName() + ":::" + e.getMessage());
		e.printStackTrace();
	}
	return returnString;
}*/
	
	/*private DistStkUpdLocal getComponent(String componentName)throws Exception
	{
		DistStkUpdLocal comp = null;
		try
		{
			System.out.println("Looking For Component.... :: " + componentName);
			AppConnectParm appConnect = new AppConnectParm();
			java.util.Properties p = appConnect.getProperty();
			InitialContext ctx = new InitialContext(p);
			comp = (DistStkUpdLocal)ctx.lookup("ibase/DistStkUpd/local"); // for ejb3
			//comp = distStkUpdHome.create();
			System.out.println(componentName+" Found.....");			
		}
		catch(Exception e)
		{
			throw e;
		}
		return comp;
	}*/


	//In this method, soft allocation is done.
		// first check in reserve stock if not sufficient then check for alternate item
		// if not suffcient then  check in stock if not sufficient then check for alternate item.
		//if not sufficient then check for other site i.e supplier site for current site code in site_repl_pref table.
	@SuppressWarnings("unused")
	public Map<String,String> stockAllocation (Connection conn,String campgnNo) throws Exception
	{
		Map<String,String> detailMap = new HashMap<String,String>();
		Map<String,String> stockReturnMap = new HashMap<String,String>();
		Map<String,String> stockReturnNonCriticalMap = new HashMap<String,String>();
		int count = -1;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		HashSet<String>otherSiteCodeSet = new HashSet<String>();
		double balanceQty = 0;
		boolean isSufficient = false,isAllowed= false;
		String errorCodeRet = "",sql = "",issCriteria = "",controlledYn = "",locGroup = "",lotNoIssue = "", woLotNo = "";
		System.out.println(" -------------- Inside stockAllocation --------------------- ");
		System.out.println("workOrderBeanList size : "+workOrderBeanList.size());

		Map<String,String> detailMapClone = new HashMap<String,String>();

		try
		{
			//check stock
			if(workOrderBeanList.size() > 0)
			{
				System.out.println("outer if loop::" + workOrderBeanList.toString());
				
				for(WorkOrderDetailBean tempWorderObj : workOrderBeanList)
				{

					//Changed by wasim on 09-03-2016 to initialize map other wise it is throwing null pointer exception [START]
					stockReturnMap.put("BALANCE_QTY","0");
					stockReturnMap.put("ERROR_CODE","");
					stockReturnMap.put("IS_SUFFICIENT","false");
					//Changed by wasim on 09-03-2016 to initialize map other wise it is throwing null pointer exception [END]

					count++;
					System.out.println("["+tempWorderObj.getItemCode()+"] item main workorder xml -------------->>"+count + "  Exp lev..."+tempWorderObj.getExpLev() + "::workorder::" +tempWorderObj.getWorkOrder());
					sql = "select iss_criteria from item where item_code = ?  ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, tempWorderObj.getItemCode());
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						issCriteria = checkNull(rs.getString("iss_criteria"));
						
					}
					rs.close();
					rs = null;
					pstmt.close();

					sql = "select w.loc_group, w.lot_no__issue, i.controlled_yn, w.lot_no from workorder w, item i where w.item_code = i.item_code" +
							" and w.work_order = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, tempWorderObj.getWorkOrder());
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						locGroup = checkNull(rs.getString(1));
						lotNoIssue = checkNull(rs.getString(2));
						controlledYn = checkNull(rs.getString("controlled_yn"));
						woLotNo = checkNull(rs.getString("lot_no"));
					}
					rs.close();
					rs = null;
					pstmt.close();

					detailMap.put("CONSIDER_PARTIAL_ALT", tempWorderObj.getConsiderPartialAlt());
					detailMap.put("USE_INV_STATUS", tempWorderObj.getUseInvStatus());
					detailMap.put("SUPP_CODE_MFG", tempWorderObj.getSuppCodeMfg());
					detailMap.put("DIMENSION", tempWorderObj.getDimension());
					detailMap.put("MIN_POTENCY_PERC", String.valueOf(tempWorderObj.getMinPotencyPerc()) );
					detailMap.put("EXP_LEV", tempWorderObj.getExpLev());
					detailMap.put("OPERATION", ""+tempWorderObj.getOperation());
					detailMap.put("CRIT_ITEM", tempWorderObj.getCritItem());
					detailMap.put("ITEM_REF", tempWorderObj.getItemRef());
					detailMap.put("ISS_CRITERIA", issCriteria);
					detailMap.put("CONTROLLED_YN", controlledYn);
					detailMap.put("LOT_NO", woLotNo);
					detailMap.put("PACK_LOT_NO", lotNoIssue);
					detailMap.put("LOC_GROUP", locGroup);
					detailMap.put("BOM_CODE", tempWorderObj.getBomCode());
					detailMap.put("ITEM_CODE", tempWorderObj.getItemCode());
					detailMap.put("QUANTITY", String.valueOf(tempWorderObj.getQuantity()));
					detailMap.put("BALANCE_QTY", String.valueOf(tempWorderObj.getQuantity()));//Changed by wasim on 09-03-2016
					detailMap.put("SITE_CODE", tempWorderObj.getSiteCode());
					detailMap.put("UNIT", tempWorderObj.getUnit());
					detailMap.put("MATCH_POTENCY", tempWorderObj.getMatchPotency());
					detailMap.put("ADJ_POTENCY", tempWorderObj.getAdjPotency());
					detailMap.put("USAGE_TYPE", tempWorderObj.getUsageType());
					detailMap.put("CONSIDER_LOTNO_ISSUE", tempWorderObj.getConsiderLotNoIssue());
					detailMap.put("LOC_USAGE_TYPE", tempWorderObj.getLocUsageType());
					detailMap.put("WORK_ORDER", tempWorderObj.getWorkOrder());
					detailMap.put("ITEM_ACTIVE", tempWorderObj.getItemActive());
					detailMap.put("ALLOCATE_TYPE", tempWorderObj.getAllocateType());
					detailMap.put("ITEM_CATEGORY", tempWorderObj.getItemCategory());
					detailMap.put("IS_ALTERNATE", "N");
					detailMap.put("OTHER_SITE", "N");
					detailMap.put("STOCK_DETAIL", "N");
					
					System.out.println("WORK_ORDER : "+detailMap.get("WORK_ORDER"));
					System.out.println("USAGE_TYPE : "+detailMap.get("USAGE_TYPE"));
					System.out.println("ALLOCATE_TYPE : "+detailMap.get("ALLOCATE_TYPE"));
					System.out.println("FG Lot NO : "+detailMap.get("LOT_NO"));

					detailMap.put("MIN_QTY_REQ", String.valueOf(tempWorderObj.getMinReqQty()));//Changed by wasim on 29-02-2016 to put min_req_qty in map
					detailMap.put("ORDER_TYPE", String.valueOf(tempWorderObj.getWorderType()));//Changed by wasim on 29-02-2016 to put min_req_qty in map

					//IS_ALTERNATE
					
					//if("R".equalsIgnoreCase(detailMap.get("USAGE_TYPE")) && (! "N".equalsIgnoreCase(detailMap.get("ALLOCATE_TYPE")) ) ){  //// commented by azhar[02/FEB/2017]
					
					/*if("R".equalsIgnoreCase(detailMap.get("USAGE_TYPE")) && (! "N".equalsIgnoreCase(detailMap.get("ALLOCATE_TYPE")) ) ){
						isAllowed = true; 
					}*/
						
					
					// First Check stock in reserve location (inv_alloc_det)
						//if ALLOCATE_TYPE is 'O' then allocated original stock only not for alternate
						
						//Changed by wasim on 17-05-2016 to comment allocate type condition as per manohar sir 
						//if(!"O".equalsIgnoreCase(detailMap.get("ALLOCATE_TYPE")) )
						//{
							System.out.println("worderExpLevSufficient before checkReserveStock ["+worderExpLevSufficient+"]");
							stockReturnMap = checkReserveStock(detailMap, conn,campgnNo);
							System.out.println("worderExpLevSufficient after checkReserveStock ["+worderExpLevSufficient+"]");
							System.out.println("checkReserveStock1 return map : "+stockReturnMap);

							
							if("N".equalsIgnoreCase(detailMap.get("CONSIDER_PARTIAL_ALT")))
							{
								System.out.println("CONSIDER_PARTIAL_ALT in checkReserveStock.................");
								balanceQty = Double.parseDouble(stockReturnMap.get("BALANCE_QTY"));
								errorCodeRet = stockReturnMap.get("ERROR_CODE");
								//if ("Y".equalsIgnoreCase(tempWorderObj.getCritItem()))
								//{
									isSufficient = Boolean.parseBoolean(stockReturnMap.get("IS_SUFFICIENT"));
								//}
								//else
								//{
								//	isSufficient = true;
								//}
								System.out.println("6@@@IS_SUFFICIENT"+isSufficient);
								if(balanceQty > 0)
								{
									stockReturnMap.put("BALANCE_QTY", "0");
									stockReturnMap.put("ERROR_CODE", "");
									stockReturnMap.put("IS_SUFFICIENT", "false");
									System.out.println("worderStkBeanList clear.......................");
									removeDataConsiderPartialAlt(tempWorderObj.getWorkOrder(),tempWorderObj.getExpLev());
								}

							}
							
							
							System.out.println("CONSIDER_PARTIAL_ALT Reserve return map : "+stockReturnMap);
							balanceQty = Double.parseDouble(stockReturnMap.get("BALANCE_QTY"));
							errorCodeRet = stockReturnMap.get("ERROR_CODE");
							
								//if ("Y".equalsIgnoreCase(tempWorderObj.getCritItem()))
								//{
									isSufficient = Boolean.parseBoolean(stockReturnMap.get("IS_SUFFICIENT"));
								//}
								//else
								//{
								//	isSufficient = true;
								//}
							
							System.out.println("5@@@IS_SUFFICIENT"+isSufficient);
							if(isSufficient)
							{
								System.out.println("Sufficient in 1 reserve stock.......................");
								tempWorderObj.setSufficient("Y");
								workOrderBeanList.set(count, tempWorderObj);
								worderExpLevSufficient.put(tempWorderObj.getWorkOrder()+":"+tempWorderObj.getExpLev(), isSufficient);
								updateWoBeanSufficient(tempWorderObj.getWorkOrder(), tempWorderObj.getExpLev(), "Y");
								continue;
							}
							detailMap.put("BALANCE_QTY", String.valueOf(balanceQty) );
							//stockReturnMap = checkForAlternateItem(detailMap, conn);
							//System.out.println("checkForAlternateItem Reserve return map : "+stockReturnMap);
					  //}

						//--------------------Second Check stock in current site---------------------------
						System.out.println("Second Check stock in current site : "+stockReturnMap);
						System.out.println("0@@@IS_SUFFICIENT"+isSufficient);

						if(stockReturnMap.size() > 0)
						{
							balanceQty = Double.parseDouble(stockReturnMap.get("BALANCE_QTY"));
							errorCodeRet = stockReturnMap.get("ERROR_CODE");
							
							//if ("Y".equalsIgnoreCase(tempWorderObj.getCritItem()))
							//{
								isSufficient = Boolean.parseBoolean(stockReturnMap.get("IS_SUFFICIENT"));
							//}
							//else
							//{
							//	isSufficient = true;
							//}
							
							stockReturnMap.clear();
							System.out.println("4@@@IS_SUFFICIENT"+isSufficient);
							if(!isSufficient )
							{
								detailMap.put("STOCK_DETAIL", "Y");
								stockReturnMap = checkCurrentSiteStock(detailMap ,conn,campgnNo);//getSuppStockQty
							}
							else
							{
								tempWorderObj.setSufficient("Y");
								workOrderBeanList.set(count, tempWorderObj);
								worderExpLevSufficient.put(tempWorderObj.getWorkOrder()+":"+tempWorderObj.getExpLev(), isSufficient);
								updateWoBeanSufficient(tempWorderObj.getWorkOrder(), tempWorderObj.getExpLev(), "Y");
								continue;
							}
						}
						else
						{
							System.out.println("Not check reserve.................");
							System.out.println("worderExpLevSufficient before checkCurrentSiteStock ["+worderExpLevSufficient+"]");
							stockReturnMap = checkCurrentSiteStock(detailMap ,conn,campgnNo);//getSuppStockQty
							System.out.println("worderExpLevSufficient after checkCurrentSiteStock ["+worderExpLevSufficient+"]");

						}
						System.out.println("@checkCurrentSiteStock return map@ : "+stockReturnMap);
						/*if("N".equalsIgnoreCase(detailMap.get("CONSIDER_PARTIAL_ALT")))
						{
							System.out.println("CONSIDER_PARTIAL_ALT in CurrentSiteStock.................");
							balanceQty = Double.parseDouble(stockReturnMap.get("BALANCE_QTY"));
							errorCodeRet = stockReturnMap.get("ERROR_CODE");
							isSufficient = Boolean.parseBoolean(stockReturnMap.get("IS_SUFFICIENT"));
							if(balanceQty > 0)
							{
								stockReturnMap.put("BALANCE_QTY", "0");
								stockReturnMap.put("ERROR_CODE", "");
								stockReturnMap.put("IS_SUFFICIENT", "false");
								System.out.println("worderStkBeanList clear.......................");
								worderStkBeanList.clear();
								conn.rollback();
							}

						}*/
						//@#
						/*String output = checkOutput(conn);
						System.out.println("check 1:::: " + output);*/
						
						balanceQty = Double.parseDouble(stockReturnMap.get("BALANCE_QTY"));
						errorCodeRet = stockReturnMap.get("ERROR_CODE");
						
						//if ("Y".equalsIgnoreCase(tempWorderObj.getCritItem()))
						//{
							isSufficient = Boolean.parseBoolean(stockReturnMap.get("IS_SUFFICIENT"));
						//}
						//else
						//{
						//	isSufficient = true;
						//}
						System.out.println("@errorCodeRet @ : "+errorCodeRet);
						System.out.println("@isSufficient @ : "+isSufficient);
						System.out.println("@ ALLOCATE_TYPE@ : "+detailMap.get("ALLOCATE_TYPE"));
						System.out.println("1@@@IS_SUFFICIENT"+isSufficient);
						if( isSufficient )
						{
							tempWorderObj.setSufficient("Y");
							workOrderBeanList.set(count, tempWorderObj);
							worderExpLevSufficient.put(tempWorderObj.getWorkOrder()+":"+tempWorderObj.getExpLev(), isSufficient);
							updateWoBeanSufficient(tempWorderObj.getWorkOrder(), tempWorderObj.getExpLev(), "Y");
							continue;
						}

						/*if(errorCodeRet.length() > 0)
						{
							//return error message
						}
						else if(isSufficient)
						{
							continue;
						}*/

						if(!"O".equalsIgnoreCase(detailMap.get("ALLOCATE_TYPE")) && !isSufficient)
						{
							System.out.println("----------------start alternate item-----------------------------for"+detailMap.get("ITEM_CODE"));
							System.out.println("@@checkForAlternateItem before Current site @@ : "+stockReturnMap);
							detailMap.put("BALANCE_QTY", String.valueOf(balanceQty) );
							System.out.println("@@checkForAlternateItem after Current site @@ : "+detailMap);

							System.out.println("worderExpLevSufficient before checkForAlternateItem ["+worderExpLevSufficient+"]");
							stockReturnMap = checkForAlternateItem(detailMap, conn,campgnNo);
							System.out.println("worderExpLevSufficient after checkForAlternateItem ["+worderExpLevSufficient+"]");
							System.out.println("@@checkForAlternateItem Current site @@ : "+stockReturnMap);

							System.out.println("After checkForAlternateItem item_code is="+detailMap.get("ITEM_CODE"));

							
							//if ("Y".equalsIgnoreCase(tempWorderObj.getCritItem()))
							//{
								isSufficient = Boolean.parseBoolean(stockReturnMap.get("IS_SUFFICIENT"));
							//}
							//else
							//{
							//	isSufficient = true;
							//}

							System.out.println("2@@@IS_SUFFICIENT"+isSufficient);
							if( isSufficient )
							{
								tempWorderObj.setSufficient("Y");
								workOrderBeanList.set(count, tempWorderObj);
								continue;
							}
							System.out.println("checkForAlternateItem Current site return map : "+stockReturnMap);
						}

						/*String output1 = checkOutput(conn);
						System.out.println("check 2:::: " + output1);*/
						
						balanceQty = Double.parseDouble(stockReturnMap.get("BALANCE_QTY"));
						errorCodeRet = stockReturnMap.get("ERROR_CODE");
						
						//if ("Y".equalsIgnoreCase(tempWorderObj.getCritItem()))
						//{
							isSufficient = Boolean.parseBoolean(stockReturnMap.get("IS_SUFFICIENT"));
						//}
						//else
						//{
						//	isSufficient = true;
						//}
						System.out.println("isSufficient---["+isSufficient+"] balanceQty--->>["+balanceQty+"]");
						//--------------------Third check stock in other site--------------------------------
						if(! isSufficient)
						{
							if(otherSiteCodeSet.size() > 0)
							{
								otherSiteCodeSet.clear();
							}

							//Changed by wasim as quantity,item_code was updated in map becuase of alternate item so reverting original [START]
							detailMap.put("ITEM_CODE",tempWorderObj.getItemCode());
							//detailMap.put("QUANTITY",String.valueOf(tempWorderObj.getQuantity()));
							detailMap.put("QUANTITY",String.valueOf(balanceQty));
							//detailMap.put("IS_ALTERNATE", "N");
							//Changed by wasim as quantity,item_code was updated in map becuase of alternate item so reverting original [END]

							ArrayList<String> testSite = new ArrayList<String>();//Changed by wasim on 02-03-2016 to take array list instead of HashSet

							//Get all site_code from site_repl_pref for current Work order site.
							sql = "select site_code__supp,trans_tran from site_repl_pref where site_code = ? order by pref_order ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, detailMap.get("SITE_CODE"));
							rs = pstmt.executeQuery();
							while(rs.next())
							{
								otherSiteCodeSet.add(checkNull(rs.getString("site_code__supp")));
								transTranMap.put(detailMap.get("SITE_CODE")+":"+checkNull(rs.getString("site_code__supp")), checkNull(rs.getString("trans_tran"))) ;

								testSite.add(rs.getString("site_code__supp"));//Changed by wasim on 02-03-2016 to take array list instead of HashSet
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							System.out.println("otherSiteCodeList :"+otherSiteCodeSet);
							System.out.println("Site ArrayList :"+testSite);
							detailMap.put("SITE_CODE__SHIP", detailMap.get("SITE_CODE"));

							//Changed by wasim on 02-03-2016 to take array list instead of HashSet
							//for(String suppSiteCode : otherSiteCodeSet)
							/*String output3 = checkOutput(conn);
							System.out.println("check 3:::: " + output3);*/
							
							for(String suppSiteCode : testSite)
							{
								System.out.println("--------For site Code------------"+suppSiteCode);
								detailMap.put("OTHER_SITE", "Y");
								detailMap.put("SITE_CODE", suppSiteCode); //update new site code

								System.out.println("Checking for item_code="+detailMap.get("ITEM_CODE")+"in site="+suppSiteCode+"for quantity"+detailMap.get("QUANTITY"));
								System.out.println("worderExpLevSufficient before checkCurrentSiteStock ["+worderExpLevSufficient+"]");
								System.out.println("@@checkForother before Current site detailMap@@ : "+detailMap);
								detailMap.put("IS_ALTERNATE", "N");
								stockReturnMap = checkCurrentSiteStock(detailMap, conn,campgnNo);//Check for Other site
								System.out.println("@@checkForother after Current site stockReturnMap@@ : "+stockReturnMap);
								System.out.println("worderExpLevSufficient after checkCurrentSiteStock ["+worderExpLevSufficient+"]");

								System.out.println("Current Stock return map : "+stockReturnMap);
								balanceQty = Double.parseDouble(stockReturnMap.get("BALANCE_QTY"));
								balanceQty = Double.parseDouble(df.format(balanceQty));
								errorCodeRet = stockReturnMap.get("ERROR_CODE");
								detailMap.put("BALANCE_QTY",String.valueOf(balanceQty)); /// 19-Jul-16 manoharan update the balance for alternate
								
								//if ("Y".equalsIgnoreCase(tempWorderObj.getCritItem()))
								//{
									isSufficient = Boolean.parseBoolean(stockReturnMap.get("IS_SUFFICIENT"));
								//}
								//else
								//{
								//	isSufficient = true;
								//}
								if(errorCodeRet.length() > 0)
								{
									return stockReturnMap;
								}
								if(isSufficient)
								{
									tempWorderObj.setSufficient("Y");//Changed by wasim on 07-03-2016
									break;
								}
								//Changed by wasim on 07-03-2016 to check alternate item in other site if main item not found [START]
								//else
								//{
									System.out.println("@@Checking for alternate item in other site becuase Main item not found");

									if(!"O".equalsIgnoreCase(detailMap.get("ALLOCATE_TYPE")) && !isSufficient)
									{
										System.out.println("worderExpLevSufficient before checkForAlternateItem ["+worderExpLevSufficient+"]");
										System.out.println("before checkForAlternateItem detailMap ["+detailMap+"]");
										stockReturnMap = checkForAlternateItem(detailMap, conn,campgnNo);
										System.out.println("worderExpLevSufficient after checkForAlternateItem ["+worderExpLevSufficient+"]");
										System.out.println("Other site alternate Map return=="+stockReturnMap);
										balanceQty = Double.parseDouble(stockReturnMap.get("BALANCE_QTY"));
										errorCodeRet = stockReturnMap.get("ERROR_CODE");
										//Uncommented by Azhar dtd 06/jan/17[START]
										if ("Y".equalsIgnoreCase(tempWorderObj.getCritItem()))
										{
											isSufficient = Boolean.parseBoolean(stockReturnMap.get("IS_SUFFICIENT"));
										}
										else
										{
											isSufficient = true;
										}
										//Uncommented by Azhar dtd 06/jan/17[END]
										if(errorCodeRet.length() > 0)
										{
											return stockReturnMap;
										}
										if(isSufficient)
										{
											tempWorderObj.setSufficient("Y");//Changed by wasim on 07-03-2016
											break;
										}
										else
										{
											detailMap.put("ITEM_CODE",tempWorderObj.getItemCode());
											detailMap.put("QUANTITY",String.valueOf(tempWorderObj.getQuantity()));
											detailMap.put("BALANCE_QTY",String.valueOf(balanceQty)); /// 19-Jul-16 manoharan update the balance for alternate
										}
									}
								//}
								//Changed by wasim on 07-03-2016 to check alternate item in other site if main item not found [END]
							}
						}

					//} //end usage_type, allocate_type // commented by azhar[02/FEB/2017]
					else
					{
						continue;
					}

					System.out.println("worderExpLevSufficient@@--------------"+isSufficient);
					if ((!"Y".equalsIgnoreCase(tempWorderObj.getCritItem())) ||  (!"R".equalsIgnoreCase(tempWorderObj.getUsageType()) ))
					{
						isSufficient = true;
					}


					worderExpLevSufficient.put(tempWorderObj.getWorkOrder()+":"+tempWorderObj.getExpLev(), isSufficient);
					if (isSufficient)
					{
						updateWoBeanSufficient(tempWorderObj.getWorkOrder(), tempWorderObj.getExpLev(), "Y");
					}
					else
					{
						updateWoBeanSufficient(tempWorderObj.getWorkOrder(), tempWorderObj.getExpLev(), "N");
					}
					
					System.out.println("123worderExpLevSufficient@@--------------"+worderExpLevSufficient);
					//set is Sufficient
				} //end for loop
				
				//checkStockPotencyNew(conn,campgnNo,detailMap.get("WORK_ORDER"));
			}


		}
		catch(Exception e)
		{
			System.out.println("in stock allocation method--------------");
			e.printStackTrace();
			writeWorkOrderLog(e.toString(),campgnNo);//TODO
			throw new Exception(e);
		}
		System.out.println("Before return worderExpLevSufficient@@--------------"+worderExpLevSufficient);
		return stockReturnMap;
	}

	//Return workOrder list from campgn_no
	//if campgn_no is blank then put work ordrer return list
	/*public String checkOutput(Connection conn){
		String sql = "",allocBD = "",allocN0 = "",result = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		
		try {
			
			sql = "SELECT ALLOC_QTY FROM STOCK WHERE ITEM_CODE = 'BD0267U0DA' AND SITE_CODE = 'SP117' AND LOC_CODE = 'R7J5B' AND " +
					"LOT_NO = '212RIH0344' AND LOT_SL = '5'";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if(rs.next()){
				allocBD = rs.getString("ALLOC_QTY");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			sql = "SELECT ALLOC_QTY FROM STOCK WHERE ITEM_CODE = 'E00141N0DB' AND SITE_CODE = 'SP117' AND LOC_CODE = 'R2X2C' AND " +
					"LOT_NO = '212RIH0463' AND LOT_SL = '82'";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if(rs.next()){
				allocN0 = rs.getString("ALLOC_QTY");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			
			result = "Alloc qty for item BD0267U0DA::["+allocBD+"]:::alloc qty for item E00141N0DB::["+allocN0+"]";
		} catch (Exception e) {
			e.printStackTrace();
		}
		return result;
	}*/
	private ArrayList<String> getWorkOrderList(String workOrder,String campgnNo,Connection conn) throws ITMException,Exception
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		ArrayList<String> workOrderList = new ArrayList<String>();
		String sql = "";
		try
		{
			if(campgnNo.length() > 0)
			{
				campgnNoGlb = campgnNo;
				sql = "select a.work_order from worder_campaign a,workorder b where a.work_order = b.work_order and "
						+ "a.campgn_no = ? and (case when b.status is null then 'P' else b.status end) in ('P','M','U')";

				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, campgnNo);
				rs = pstmt.executeQuery();

				while(rs.next())
				{
					workOrderList.add(checkNull(rs.getString(1)));
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
			}
			else if(workOrder.length() > 0)
			{
				int count = 0;
				sql = "select count(*) from workorder where work_order = ? "
						+ "and (case when status is null then 'P' else status end) in ('P','M','U')";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, workOrder);
				rs = pstmt.executeQuery();

				if(rs.next())
				{
					count = rs.getInt(1);
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				if(count > 0)
				{
					workOrderList.add(workOrder);
				}

			}

		}
		catch(Exception e)
		{
			e.printStackTrace();
			writeWorkOrderLog(e.toString(),campgnNo);//TODO
			throw new ITMException(e);
		}
		finally
		{
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		return workOrderList;
	}

	//Explod BOM details and populated work order detail bean, work order and exp_level wise
	private String explodBomAndPopulateBean(ArrayList<String> workOrderList,Connection conn,String campgnNo) throws ITMException,Exception
	{
		System.out.println("iNSIDE EXPLODE bomMMMMMM");
		ExplodeBom explodeBomObj = null;
		WorkOrderDetailBean worderDetailBeanObj = null;

		SimpleDateFormat simpleDateFormat = new SimpleDateFormat(genericUtility.getDBDateFormat());
		String xmlDataString = "",sql = "",itemCode = "",siteCode = "",bomCode = "",lineType = "B",considerPartialAlt = "",lineTypeBomDet = "";
		 double quantity = 0;
		 boolean isSufficient = false;
		 String expLev = "",operation = "",critItem = "",dueDateStr = "",quantityRef = "",useInvStatus = "",dimension = "",
				itemRef = "",unit= "",reqType= "",matchPotency= "",suppCodeMfg = "",mfgRef = "",minReqQtyStr = "",
				usageType= "",allocateType= "",adjPotency= "",considerLotNoIssue= "",locUsageType= "",itemActive= "", round= "",quantityStr = "",qtyPerStr = "",minPotencyPercStr = "",minQtyStr = "",roundToStr = "",
				itemCategory= "",active= "",worderType = "", woLotNo = "";
		Timestamp dueDate = null;
		int qcLeadTime = 0,operationInt = 0;
		int mfgLeadTime = 0;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		//ArrayList<WorkorderBillBean> workOrderBomList = new ArrayList<WorkorderBillBean>();
		NodeList parentNodeList = null;
		Node childNode = null;
		int childNodeListLength = 0;
		Document dom = null;
		StringBuffer xmlString = null;
		//String retXMLStr = null;

		try
		{
			System.out.println("Inside explodBomAndPopulateBean="+workOrderList.size());

			if(workOrderList.size() > 0)
			{
				for(String tempWorkorder : workOrderList)
				{
					itemCode = "";
					siteCode = "";
					quantity = 0;
					dueDate =null;
					bomCode = "";
					worderType = "";
					woLotNo = "";
					
					sql = "select item_code,site_code,quantity,bom_code,due_date,order_type, lot_no from workorder where work_order = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,tempWorkorder);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						itemCode = checkNull(rs.getString("item_code"));
						siteCode = checkNull(rs.getString("site_code"));
						quantity = rs.getDouble("quantity");
						dueDate =rs.getTimestamp("due_date");
						bomCode = checkNull(rs.getString("bom_code"));
						worderType = checkNull(rs.getString("order_type"));
						woLotNo = checkNull(rs.getString("lot_no"));
						simpleDateFormat = new SimpleDateFormat(genericUtility.getDBDateFormat());
						dueDateStr = simpleDateFormat.format(dueDate);
						System.out.println("dueDateStr---->>["+dueDateStr+"]");
						xmlString = null;
						xmlString = new StringBuffer("<Root>");
						//retXMLStr = null;
						xmlDataString = "";
						xmlString.append("<Detail>");
						xmlString.append("<work_order>").append("<![CDATA[").append(tempWorkorder).append("]]>").append("</work_order>");
						xmlString.append("<site_code>").append("<![CDATA[").append(siteCode).append("]]>").append("</site_code>");
						xmlString.append("<item_code>").append("<![CDATA[").append(itemCode).append("]]>").append("</item_code>");
						xmlString.append("<line_type>").append("<![CDATA[").append(lineType).append("]]>").append("</line_type>");
						xmlString.append("<quantity>").append("<![CDATA[").append(quantity).append("]]>").append("</quantity>");
						xmlString.append("<bom_code>").append("<![CDATA[").append(bomCode).append("]]>").append("</bom_code>");
						xmlString.append("<due_date>").append("<![CDATA[").append(dueDateStr).append("]]>").append("</due_date>");
						xmlString.append("<mfg_lead_time>").append("<![CDATA[").append(mfgLeadTime).append("]]>").append("</mfg_lead_time>");
						xmlString.append("<qc_lead_time>").append("<![CDATA[").append(qcLeadTime).append("]]>").append("</qc_lead_time>");
						xmlString.append("<lot_no>").append("<![CDATA[").append(woLotNo).append("]]>").append("</lot_no>");
						xmlString.append("</Detail>");
						xmlString.append("</Root>");
						//make xml from workorder.
						//Explod BOM. Use existing component
						System.out.println("Before explodebom  xmlString [" + xmlString.toString()+"]");
						explodeBomObj = new ExplodeBom();
						xmlDataString = checkNull(explodeBomObj.explodeBom(xmlString.toString()).toString());
						explodeBomObj = null;

						System.out.println("xmlDataString in getExplodBomDetails----->>["+xmlDataString+"]");

						if(xmlDataString.length() > 0)
						{
							//read xmlDataString and set WorkorderBillBean bean variables.
							dom = genericUtility.parseString(xmlDataString);
							if(dom != null)
							{
								parentNodeList = dom.getElementsByTagName("Detail");
								childNodeListLength = parentNodeList.getLength();

								for (int ctr = 0; ctr < childNodeListLength; ctr++)
								{
									worderDetailBeanObj = new WorkOrderDetailBean();

									childNode = parentNodeList.item(ctr);
									if (childNode.getNodeType() == Node.ELEMENT_NODE)
									{
										Element eElement = (Element) childNode;
										siteCode =  checkNull(eElement.getElementsByTagName("site_code").item(0).getTextContent());
										bomCode =  checkNull(eElement.getElementsByTagName("bom_code").item(0).getTextContent());
										itemCode =  checkNull(eElement.getElementsByTagName("item_code").item(0).getTextContent());
										active = getColumnDescr(conn, "active", "item", "item_code", itemCode,campgnNo);
										dueDateStr =  checkNull(eElement.getElementsByTagName("due_date").item(0).getTextContent());
										itemRef =  checkNull(eElement.getElementsByTagName("item_Ref").item(0).getTextContent());
										quantityRef =  checkNull(eElement.getElementsByTagName("quantity_Ref").item(0).getTextContent());
										quantityStr =  checkNull(eElement.getElementsByTagName("quantity").item(0).getTextContent());

										expLev =  checkNull(eElement.getElementsByTagName("exp_lev").item(0).getTextContent());
										operation =  checkNull(eElement.getElementsByTagName("operation").item(0).getTextContent());
										operationInt = Integer.parseInt(operation.length() == 0 ? "0" : operation);
										critItem =  checkNull(eElement.getElementsByTagName("crit_Item").item(0).getTextContent());
										lineTypeBomDet =  checkNull(eElement.getElementsByTagName("line_type").item(0).getTextContent());

										considerPartialAlt = checkNull(eElement.getElementsByTagName("consider_partial_alt").item(0).getTextContent());
										unit =  checkNull(eElement.getElementsByTagName("unit").item(0).getTextContent());
										//batchQtyStr =  checkNull(eElement.getElementsByTagName("batch_qty").item(0).getTextContent());
										qtyPerStr =  checkNull(eElement.getElementsByTagName("qty_per").item(0).getTextContent());
										reqType =  checkNull(eElement.getElementsByTagName("req_type").item(0).getTextContent());
										matchPotency =  checkNull(eElement.getElementsByTagName("match_potency").item(0).getTextContent());
										minPotencyPercStr =  checkNull(eElement.getElementsByTagName("min_potency_perc").item(0).getTextContent());

										adjPotency =  checkNull(eElement.getElementsByTagName("adj_potency").item(0).getTextContent());
										usageType =  checkNull(eElement.getElementsByTagName("usage_type").item(0).getTextContent());

										allocateType =  checkNull(eElement.getElementsByTagName("allocate_type").item(0).getTextContent());
										locUsageType =  checkNull(eElement.getElementsByTagName("loc_usage_type").item(0).getTextContent());
										considerLotNoIssue =  checkNull(eElement.getElementsByTagName("consider_lot_no__issue").item(0).getTextContent());
										itemActive =  checkNull(eElement.getElementsByTagName("active").item(0).getTextContent());
										minQtyStr =  checkNull(eElement.getElementsByTagName("min_qty").item(0).getTextContent());
										round =  checkNull(eElement.getElementsByTagName("round").item(0).getTextContent());
										roundToStr =  checkNull(eElement.getElementsByTagName("round_to").item(0).getTextContent());

										suppCodeMfg =  checkNull(eElement.getElementsByTagName("supp_code__mfg").item(0).getTextContent());
										useInvStatus =  checkNull(eElement.getElementsByTagName("use_invstatus").item(0).getTextContent());
										dimension =  checkNull(eElement.getElementsByTagName("dimension").item(0).getTextContent());
										mfgRef =  checkNull(eElement.getElementsByTagName("mfg_ref").item(0).getTextContent());
										minReqQtyStr =  checkNull(eElement.getElementsByTagName("min_req_qty").item(0).getTextContent());
										itemCategory =  checkNull(eElement.getElementsByTagName("item_category").item(0).getTextContent());


										/*int index = indexOfWorkorderBeanList(tempWorkorder,expLev);
										System.out.println("index : "+index);
										if(index > -1)
										{
											worderDetailBeanObj = workOrderBeanList.get(index);
											worderDetailBeanObj.setQuantity(worderDetailBeanObj.getQuantity() + Double.valueOf(quantityStr.length() == 0 ? "0" : quantityStr));
											workOrderBeanList.set(index, worderDetailBeanObj);
										}
										else
										{*/
										worderDetailBeanObj.setWorkOrder(tempWorkorder);
										worderDetailBeanObj.setLotNo(woLotNo);
										worderDetailBeanObj.setSiteCode(siteCode);
										worderDetailBeanObj.setBomCode(bomCode);
										worderDetailBeanObj.setItemCode(itemCode);
										//worderDetailBeanObj.setItemDescr(itemDescr);
										worderDetailBeanObj.setActive(active);
										worderDetailBeanObj.setDueDate(dueDateStr);
										worderDetailBeanObj.setItemRef(itemRef);
										System.out.println("quantityStr----->>["+quantityStr+"]");
										worderDetailBeanObj.setQuantityRef(quantityRef);
										worderDetailBeanObj.setQuantity(Double.valueOf(quantityStr.length() == 0 ? "0" : quantityStr));
										worderDetailBeanObj.setExpLev(expLev);
										worderDetailBeanObj.setOperation(operationInt);
										worderDetailBeanObj.setCritItem(critItem);
										// 06-jun-16 manoharan add sufficient flag in list
										//commented by azhar[06/JAN/2017][START] as told by manoharan sir
										/*if ("Y".equals(critItem))
										{
											isSufficient =  false;
										}
										else
										{
											isSufficient = true;
										}*/
										//commented by azhar[06/JAN/2017][END] as told by manoharan sir
										worderExpLevSufficient.put(worderDetailBeanObj.getWorkOrder()+":"+worderDetailBeanObj.getExpLev(), isSufficient);
										// end 06-jun-16 manoharan add sufficient flag in list

										worderDetailBeanObj.setSuppCodeMfg(suppCodeMfg);
										worderDetailBeanObj.setUseInvStatus(useInvStatus);
										worderDetailBeanObj.setDimension(dimension);
										worderDetailBeanObj.setMfgRef(mfgRef);
										worderDetailBeanObj.setMinReqQty(Double.valueOf(minReqQtyStr.length() == 0 ? "0" : minReqQtyStr));

										worderDetailBeanObj.setLineType(lineTypeBomDet);
										worderDetailBeanObj.setUnit(unit);
										//Changed by wasim to set batch quantity as work order quantity
										System.out.println("Batch Quantity="+quantity);
										//worderDetailBeanObj.setBatchQty(Double.valueOf(batchQtyStr.length() == 0 ? "0" : batchQtyStr));
										worderDetailBeanObj.setBatchQty(Double.valueOf(quantity));
										worderDetailBeanObj.setQtyPer(Double.valueOf(qtyPerStr.length() == 0 ? "0" : qtyPerStr));
										worderDetailBeanObj.setReqType(reqType);

										worderDetailBeanObj.setMatchPotency(matchPotency);
										worderDetailBeanObj.setMinPotencyPerc(Double.valueOf(minPotencyPercStr.length() == 0 ? "0" : minPotencyPercStr));
										worderDetailBeanObj.setAdjPotency(adjPotency);
										worderDetailBeanObj.setUsageType(usageType);
										worderDetailBeanObj.setAllocateType(allocateType);

										worderDetailBeanObj.setLocUsageType(locUsageType);
										worderDetailBeanObj.setConsiderLotNoIssue(considerLotNoIssue);
										worderDetailBeanObj.setItemActive(itemActive);
										worderDetailBeanObj.setMinQty(Double.valueOf(minQtyStr.length() == 0 ? "0" : minQtyStr));
										worderDetailBeanObj.setRound(round);
										worderDetailBeanObj.setRoundTo(Double.valueOf(roundToStr.length() == 0 ? "0" : roundToStr));

										worderDetailBeanObj.setItemCategory(itemCategory);
										worderDetailBeanObj.setPotencyAdjQty(0); //later set on potency calculation.

										worderDetailBeanObj.setConsiderPartialAlt(considerPartialAlt);
										worderDetailBeanObj.setWorderType(worderType);//Changed by wasim to set workOrderType on 29-03-2016

										workOrderBeanList.add(worderDetailBeanObj); // All details

										System.out.println("worderDetailBeanObj : " + worderDetailBeanObj.toString());


									}
								} //End dom for loop




							}
							else
							{
								System.out.println("dom is null please check................");
							}


						}
						else
						{
							//return error messages.
						}
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;

				}//end workOrderList for



			}//end workOrderList condition

			//Requirement done

		}
		catch(Exception e)
		{
			e.printStackTrace();
			writeWorkOrderLog(e.toString(),campgnNo);//TODO
			throw new Exception(e);
		}
		return "";
	}

	//This method used for checking stock for current site or other site
	//for checking other site we change site code and add IS_OTHER_SITE key (Y) in detailMap
	//if IS_OTHER_SITE is Y then populate SiteItem bean (Site code and item code wise)
	//In that bean set otherSite Quantity. That quantity used for distribution issue
	@SuppressWarnings({ "rawtypes", "unchecked" })
	private Map<String,String> checkCurrentSiteStock(Map<String,String> detailMap,Connection conn,String campgnNo) throws Exception
	{
		System.out.println("iN checkCurrentSiteStock : "+detailMap);
		ResultSet rs= null;
		PreparedStatement pstmt = null;
		String sql = "",qcReqd = "",dimension ="",allocRetStr = "",workOrder = "",expLevel = "",
				trackShelfLife = "",locGroup = "",sqlString = "",itemDescr = "",considerPartialAlt = "",itemCategory = "";

		int count = 0;
		boolean isSufficient = false;
		double requiredQty = 0,softAllocQty = 0,balanceQty = 0,shortageQty = 0, currntEqualQty = 0;
		String locCode = "",lotNo = "",lotSl = "",unit = "",siteCodeMfg = "",alternateItem = "",
				stkKey = "",otherSite = "",errorCode = "",issCriteria = "",matchPotency = "",adjPotency = "";
		double stkQuantity = 0,stkPotencyPerc = 0,minPotencyPerc = 0, qtyPotencyUnit = 0, potencyAdj = 0, updQty = 0, qtyTemp = 0;
		double minQtyReq = 0; //Changed by wasim on 29-02-2016
		java.sql.Timestamp expDateT = null,mfgDateT= null;
		Map<String,String> returnMapDetails = new HashMap<String,String>();
		Map<String,String> stockAllocMap = new HashMap<String,String>();
		SiteItemSummaryBean  siteItemSumBeanObj = null;
		SiteItemSummaryBeanNC  siteItemSumBeanObjNC = null;
		WorderStkBean worderStkBeanObj = null;
		int count1 = 0, cnt = 0, stkindex = -1;
		double finalAllocatedQty = 0, ItemStdPotency = 100, qtyPerArt = 0;
		Timestamp expDateWorkOrder = null;
		String trackShelfLifeFG = "",controlledYnFG = "",queryString = "", balQtyStr = "0";
		String sqlUpd = "",key = "",checkOtherKey = "",checkCurrentKey = "";
		PreparedStatement pstmtUpd = null;
		ResultSet rsExpDate = null;

		try
		{
			
			System.out.println("isReallocationFlag="+isReallocation);
			otherSite = detailMap.get("OTHER_SITE");
			if("Y".equals(otherSite))
			{
				System.out.println("Checking for other site......................");
			}
			//Changed by wasim on 29-02-2016 to get min qty required [START]
			itemCategory = detailMap.get("ITEM_CATEGORY");
			minQtyReq = Double.valueOf(detailMap.get("MIN_QTY_REQ"));
			System.out.println("Minimum qty Req in checkCurrentSiteStock="+minQtyReq);
			//Changed by wasim on 29-02-2016 to get min qty required [END]

			considerPartialAlt = detailMap.get("CONSIDER_PARTIAL_ALT");
			workOrder = detailMap.get("WORK_ORDER");
			expLevel = detailMap.get("EXP_LEV");
			issCriteria = detailMap.get("ISS_CRITERIA");
			minPotencyPerc = Double.parseDouble(detailMap.get("MIN_POTENCY_PERC"));
			matchPotency = detailMap.get("MATCH_POTENCY");
			adjPotency = detailMap.get("ADJ_POTENCY");
			locGroup = detailMap.get("LOC_GROUP"); //  15-jun-16 manoharan
			
			alternateItem = detailMap.get("IS_ALTERNATE");
			System.out.println("IS_ALTERNATE : "+alternateItem);
			System.out.println("CONSIDER_PARTIAL_ALT : "+considerPartialAlt);
			System.out.println("workOrder : "+workOrder);
			System.out.println("expLevel : "+expLevel);
			sql = "select case when qc_reqd is null then 'N' else qc_reqd end,"
					+ "case when track_shelf_life is null then 'N' else track_shelf_life end  "
					+ "from   item where  item_code = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, detailMap.get("ITEM_CODE"));
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				qcReqd = checkNull(rs.getString(1));
				trackShelfLife = checkNull(rs.getString(2));
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			// 31-may-16 manoharan
			ItemStdPotency = getItemStandardPotency(detailMap.get("ITEM_CODE"), conn,campgnNo);

			dimension = checkNull(detailMap.get("DIMENSION"));
			detailMap.put("QC_REQD", qcReqd);
			detailMap.put("TRACK_SHELF_LIFE", trackShelfLife);
			detailMap.put("CONSIDER_LOT_ISSUE", detailMap.get("CONSIDER_LOTNO_ISSUE"));

			if("P".equalsIgnoreCase(detailMap.get("LOC_USAGE_TYPE")) || "A".equalsIgnoreCase(detailMap.get("LOC_USAGE_TYPE")))
			{
				//detailMap.put("LOC_GROUP", locGroup); // 15-jun-16 manoharan commented
				//locGroup = detailMap.get("LOC_GROUP"); // 15-jun-16 manoharan commented
				if(locGroup.length() == 0)
				{
					errorCode = "WOGRPLOC";
				}

				if(errorCode.length() > 0)
				{
					returnMapDetails.put("ERROR_CODE",errorCode);
					returnMapDetails.put("BALANCE_QTY",String.valueOf(balanceQty));
					returnMapDetails.put("IS_SUFFICIENT","false");
					return returnMapDetails;
				}
			}
			if(dimension.length() > 0)
			{
			}
			sql = "select case when a.trim_width is null then 0 else a.trim_width end "
					+ "from  item_type a, item b "
					+ "where  a.item_type = b.item_type and b.item_code = ?";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, detailMap.get("WORK_ORDER"));
			rs = pstmt.executeQuery();
			if(rs.next())
			{

			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			System.out.println("in checkCurrentSiteStock detailMap["+detailMap +"]");
			balQtyStr = detailMap.get("BALANCE_QTY");
			if(balQtyStr == null || "null".equals(balQtyStr) || balQtyStr.trim().length() == 0)
			{
				balQtyStr = "0";
			}
			
			shortageQty = Double.parseDouble(balQtyStr);
			System.out.println("shortageQty......................"+shortageQty);
			if(shortageQty> 0)
			{
				requiredQty = shortageQty;
			}
			else
			{
				requiredQty = Double.parseDouble(detailMap.get("QUANTITY"));
			}
			//if(isReallocation)
			//{
				balanceQty = requiredQty;
			//}
			//Excecute stock sql and set in WorderStkBean object
			//for detailsum S =  check sum of stock, I - used for check same manufactured,D -
				
			/*String output5 = checkOutput(conn);
			System.out.println("check 5:::: " + output5);*/
				
			sqlString = getBuildedWoIssueSql(detailMap, conn);

			pstmt = conn.prepareStatement(sqlString);
			System.out.println("in checkCurrentSiteStock getBuildedWoIssueSql balanceQty [" + balanceQty + "] For item code ["+detailMap.get("ITEM_CODE") + "] sqlString ["+sqlString+"]");
			int countCurrent = 0, countOther = 0;
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				/*if("N".equalsIgnoreCase(detailMap.get("CRIT_ITEM")) && "N".equalsIgnoreCase(otherSite)){
					System.out.println("Adding for current");
					countCurrent++;
					key = "CURRENT" + detailMap.get("WORK_ORDER") + detailMap.get("EXP_LEV") + detailMap.get("ITEM_CODE");
					zeroStockCheckMap.put(key, countCurrent);
					
				}else if("N".equalsIgnoreCase(detailMap.get("CRIT_ITEM")) && "Y".equalsIgnoreCase(otherSite)){
					System.out.println("Adding for other");
					countOther++;
					key = "OTHER" + detailMap.get("WORK_ORDER") + detailMap.get("EXP_LEV") + detailMap.get("ITEM_CODE");
					zeroStockCheckMap.put(key, countOther);
				}*/
				locCode = checkNull(rs.getString("LOC_CODE"));
				lotNo = checkNull(rs.getString("LOT_NO"));
				lotSl = checkNull(rs.getString("LOT_SL"));
				stkQuantity = rs.getDouble("QUANTITY");
				expDateT = rs.getTimestamp("EXP_DATE");
				

				stkKey = locCode+":"+lotNo+":"+lotSl+":"+detailMap.get("SITE_CODE")+":"+detailMap.get("ITEM_CODE");
				//added on 24/FEB/2017 for separate DO of non critical items[START]
				if("N".equalsIgnoreCase(detailMap.get("CRIT_ITEM"))){
					
				System.out.println("noncritical map:::" + nonCriticalMap);
				
				if(nonCriticalMap.containsKey(stkKey)){
					System.out.println("keyfound " + stkKey);
					
					stkQuantity = nonCriticalMap.get(stkKey);
					
					System.out.println("new stock quantity::" + stkQuantity);
					
					if(nonCriticalMap.get(stkKey) == 0){
						System.out.println("stock exhausted::");
					continue;
					}
				}
				if(stkQuantity > balanceQty){
					System.out.println("stock qty greater than balance::["+stkQuantity+"] balanceqty:["+balanceQty+"]");
					qtyTemp =  stkQuantity - balanceQty;	
				}else {
					System.out.println("stock zero::");
				qtyTemp = 0.0;
				
				}
				if(qtyTemp > 0){//TODO
					System.out.println("qty temp:::" + qtyTemp);
				nonCriticalMap.put(stkKey, qtyTemp);
				}else{
				nonCriticalMap.put(stkKey, 0.0);
				}
				
				}
				//added on 24/FEB/2017 for separate DO of non critical items[END]
				
				//added by azhar 15/MAR/2017 [START] for DO creation of non critical items even if stock is absent
				if(stkQuantity > 0){
				if("N".equalsIgnoreCase(detailMap.get("CRIT_ITEM")) && "N".equalsIgnoreCase(otherSite)){
					System.out.println("Adding for current");
					countCurrent++;
					key = "CURRENT" + detailMap.get("WORK_ORDER") + detailMap.get("EXP_LEV") + detailMap.get("ITEM_CODE");
					zeroStockCheckMap.put(key, countCurrent);
					
				}else if("N".equalsIgnoreCase(detailMap.get("CRIT_ITEM")) && "Y".equalsIgnoreCase(otherSite)){
					System.out.println("Adding for other");
					countOther++;
					key = "OTHER" + detailMap.get("WORK_ORDER") + detailMap.get("EXP_LEV") + detailMap.get("ITEM_CODE");
					zeroStockCheckMap.put(key, countOther);
				}
				}
				//added by azhar 15/MAR/2017 [END] for DO creation of non critical items even if stock is absent
				updQty	= 0;
				count1++;
				System.out.println("in checkCurrentSiteStock inside while loop  count1 ["+count1+"] balanceQty [" + balanceQty + "] For item code ["+detailMap.get("ITEM_CODE") + "]");
				
				//if(isReallocation && balanceQty <= 0)
				if(balanceQty <= 0)
				{
					break;
				}
				
				System.out.println("in checkCurrentSiteStock ["+count1+"] balanceQty [" + balanceQty + "] stkQuantity [" + stkQuantity+ "] For item code ["+detailMap.get("ITEM_CODE") + "]");
				//Changed by wasim on 29-01-2016 to continue if min_req_qty greater than stock qty [START]
				if(stkQuantity < minQtyReq  || stkQuantity <= 0)
				{
					System.out.println("in checkCurrentSiteStock Stock quantity is less than min quantity required so continue loop");
					continue;
				}
				//Changed by wasim on 29-01-2016 to continue if min_req_qty greater than stock qty [END]


				
				
				if(expDateT != null)
				{
				}

				//Changed by wasim to check expDate of FG and RM for controlled item functionality [START]
				//////////////////////////////////////////////////////////////////////////////////////////////
				expDateWorkOrder = null;
				trackShelfLifeFG = "";
				controlledYnFG = "";

				queryString = "SELECT i.TRACK_SHELF_LIFE,i.CONTROLLED_YN,w.EXP_DATE "
					+ " FROM ITEM i, WORKORDER w WHERE i.item_code = w.item_code and  w.WORK_ORDER = ?";
				PreparedStatement pstmtExpDate = conn.prepareStatement(queryString);
				pstmtExpDate.setString(1,workOrder);
				rsExpDate = pstmtExpDate.executeQuery();
				if(rsExpDate.next())
				{
					trackShelfLifeFG = checkNull(rsExpDate.getString("TRACK_SHELF_LIFE"));
					controlledYnFG = checkNull(rsExpDate.getString("CONTROLLED_YN"));
					expDateWorkOrder = rsExpDate.getTimestamp("EXP_DATE");
				}
				pstmtExpDate.close();
				pstmtExpDate = null;
				rsExpDate.close();
				rsExpDate = null;

				System.out.println("Controlled YN for FG item ["+detailMap.get("ITEM_CODE")+"] is["+controlledYnFG+"] AND itemCategory ["+itemCategory+"]");
				System.out.println("Track Shelf Life FG["+trackShelfLife+"] Track Shelf Life RM ["+trackShelfLifeFG+"] RM expiry data [" + expDateT + "] workorder expiry date [" + expDateWorkOrder + "]");
					
				if("Y".equalsIgnoreCase(controlledYnFG) && "A".equalsIgnoreCase(itemCategory) && "Y".equalsIgnoreCase(trackShelfLife) &&  "Y".equalsIgnoreCase(trackShelfLifeFG) )
				{
					if(expDateWorkOrder.before(expDateT))
					{
						System.out.println("Controlled Work order exp date is less than Raw material DateRM expiry data [" + expDateT + "] workorder expiry date [" + expDateWorkOrder + "]");
						//continue;
					}
					else
					{
						System.out.println("Controlled Raw material is less than Work order exp DateRM expiry data [" + expDateT + "] workorder expiry date [" + expDateWorkOrder + "]");
						if ( "Y".equalsIgnoreCase(this.leastExpdtActivRm))
						{
							sqlUpd = "UPDATE WORKORDER SET EXP_DATE = ? WHERE WORK_ORDER = ?";
							pstmtUpd = conn.prepareStatement(sqlUpd);
							pstmtUpd.setTimestamp(1,expDateT);
							pstmtUpd.setString(2,workOrder);
							cnt = pstmtUpd.executeUpdate();
							System.out.println("Controlled Raw material is less than Work order exp Date [" + cnt + "]");

							pstmtUpd.close();
							pstmtUpd = null;
						}
						else
						{
							System.out.println("Controlled Skiping the RM stock as expiry date is less than workorder expiry date");
							continue;
						}
					}
				}
				//////////////////////////////////////////////////////////////////////////////////////////////
				//Changed by wasim to check expDate of FG and RM for controlled item functionality [END]

				unit = checkNull(rs.getString("UNIT"));
				siteCodeMfg = checkNull(rs.getString("SITE_CODE__MFG"));
				mfgDateT = rs.getTimestamp("MFG_DATE");
				if(mfgDateT != null)
				{
				}

				stkPotencyPerc = rs.getDouble("POTENCY_PERC");
				System.out.println("stkPotencyPerc------>>["+stkPotencyPerc+"]");
				System.out.println("minPotencyPerc------>>["+minPotencyPerc+"]");
				stkindex = -1;
				if(!isReallocation)
				{
					stkindex = indexOfWorkorderStkList(detailMap.get("WORK_ORDER"),detailMap.get("EXP_LEV"),detailMap.get("ITEM_CODE"),
						locCode,detailMap.get("SITE_CODE"),lotNo,lotSl);
				}
				else
				{
					stkindex = -1;
				}
				if(stkindex != -1)
				{
					System.out.println("Adding itemCode in existing worderStkBeanList"+detailMap.get("ITEM_CODE"));
					worderStkBeanObj = (WorderStkBean) worderStkBeanList.get(stkindex);
				}
				else
				{
					worderStkBeanObj = new WorderStkBean();
					siteItemSumBeanObj = new SiteItemSummaryBean();
					worderStkBeanObj.setItemCode(detailMap.get("ITEM_CODE"));
					itemDescr = getColumnDescr(conn, "descr", "item", "item_code", detailMap.get("ITEM_CODE"),campgnNo);
					worderStkBeanObj.setItemDescr(itemDescr);
					worderStkBeanObj.setLocCode(locCode);
					worderStkBeanObj.setLotNo(lotNo);
					siteItemSumBeanObj.setLotNo(lotNo);
					worderStkBeanObj.setLotSl(lotSl);
					worderStkBeanObj.setStkQuantity(stkQuantity);
					worderStkBeanObj.setUnit(unit);
					worderStkBeanObj.setStkPotencyPerc(stkPotencyPerc);
					worderStkBeanObj.setSiteCode(detailMap.get("SITE_CODE"));
					worderStkBeanObj.setMfgDate(mfgDateT);
					worderStkBeanObj.setExpDate(expDateT);
					worderStkBeanObj.setSiteCodeMfg(siteCodeMfg);
					worderStkBeanObj.setWorkOrder(detailMap.get("WORK_ORDER"));
					worderStkBeanObj.setExpLevel(detailMap.get("EXP_LEV"));
					worderStkBeanObj.setItemRef(detailMap.get("ITEM_REF"));
					worderStkBeanObj.setCritItem(detailMap.get("CRIT_ITEM"));
					worderStkBeanObj.setDimension(dimension);
					worderStkBeanObj.setAlternate(alternateItem);
					worderStkBeanObj.setReserveStk("N");
					worderStkBeanObj.setOtherSiteYN(otherSite);
					worderStkBeanObj.setIsStockDetail("Y");
					worderStkBeanObj.setMinQtyReq(minQtyReq);
					System.out.println(worderStkBeanObj.toString());
					System.out.println(siteItemSumBeanObj.toString());
				}
				if(isReallocation)
				{
					if(("Y".equals(matchPotency) && stkPotencyPerc >= minPotencyPerc) || "N".equals(matchPotency))
					{
						// 31-may-16 manoharan if matchpotency = Y calculate the same
						/////////////////////////////////////////////////////////////////////////////////////
						if("Y".equals(matchPotency))
						{
							 if(stkQuantity < balanceQty)
							 {
								System.out.println("@@Not Sufficient-->currentLotQty ["+stkQuantity+"] stkPotencyPerc ["+stkPotencyPerc+"] ItemStdPotency ["+ItemStdPotency+"]");
								 
								potencyAdj = stkQuantity - (stkQuantity * stkPotencyPerc /  ItemStdPotency);
								potencyAdj = Double.parseDouble(df.format(potencyAdj));//0.200
								System.out.println("In recalculation After calculating potencyAdj NOT SUFFICIENT----->>["+potencyAdj+"]");

								currntEqualQty = Double.parseDouble(df.format(stkQuantity - potencyAdj)) ; //4-0.2 = 3.8
								
								balanceQty = Double.parseDouble(df.format(balanceQty - currntEqualQty)); //6-3.8 = 2.2
								
								balanceQty = Double.parseDouble(df.format(balanceQty));
								updQty = stkQuantity;
								System.out.println("manohar@@NotSufficient--> before .getExpLevel [" + worderStkBeanObj.getExpLevel() +"] .setQuantity ["+worderStkBeanObj.getQuantity()+"] .setAllocQty [" + worderStkBeanObj.getAllocQty() + "] .setUpdQty [" + worderStkBeanObj.getUpdQty() + "] .setPotencyAdj( [" +worderStkBeanObj.getPotencyAdj() + "] .setQtyAdj(" + worderStkBeanObj.getQtyAdj() + "]" );
								worderStkBeanObj.setPotencyAdj(Double.parseDouble(df.format(potencyAdj)));
								worderStkBeanObj.setQtyAdj(Double.parseDouble(df.format(potencyAdj)));
								worderStkBeanObj.setQuantity(currntEqualQty); 
								worderStkBeanObj.setAllocQty(stkQuantity);  // 09-mar-16 manoharan added if stock not sufficient full stock of the lot is allocated
								worderStkBeanObj.setUpdQty(stkQuantity);
								System.out.println("manohar@@NotSufficient--> after  .getExpLevel [" + worderStkBeanObj.getExpLevel() +"] .setQuantity ["+worderStkBeanObj.getQuantity()+"] .setAllocQty [" + worderStkBeanObj.getAllocQty() + "] .setUpdQty [" + worderStkBeanObj.getUpdQty() + "] .setPotencyAdj( [" +worderStkBeanObj.getPotencyAdj() + "] .setQtyAdj(" + worderStkBeanObj.getQtyAdj() + "]" );
								 
								if(potencyAdjMapY.containsKey(adjPotency) )
								{
									potencyAdjMapY.put(adjPotency, (potencyAdjMapY.get(adjPotency) + potencyAdj ));
								}
								else
								{
									potencyAdjMapY.put(adjPotency,  potencyAdj );
								}
								isSufficient = false;
							 }
							 else  // if stock sufficient
							 {
								System.out.println("@@Sufficient--> balanceQty["+balanceQty+"] stkQuantity [" + stkQuantity + "] stkPotencyPerc ["+stkPotencyPerc+"] ItemStdPotency ["+ItemStdPotency+"]");
								 
								potencyAdj =  ( balanceQty /stkPotencyPerc * ItemStdPotency) - balanceQty;
								potencyAdj = Double.parseDouble(df.format(potencyAdj));
								System.out.println("After re-calculating potencyAdj SUFFICIENT----->>["+potencyAdj+"]");//0.244

								System.out.println("manohar before .setQuantity 110["+worderStkBeanObj.getQuantity()+"] .getPotencyAdj[" +  worderStkBeanObj.getPotencyAdj() + "] .getAllocQty[" + worderStkBeanObj.getAllocQty() + "] .getUpdQty[" + worderStkBeanObj.getUpdQty() +"]");								
								worderStkBeanObj.setQtyAdj(Double.parseDouble(df.format(potencyAdj)));
								worderStkBeanObj.setAllocQty(Double.parseDouble(df.format(balanceQty + potencyAdj)));
								updQty = Double.parseDouble(df.format(balanceQty + potencyAdj ));
								System.out.println("manohar@@Sufficient--> before  .getExpLevel [" + worderStkBeanObj.getExpLevel() +"] .setQuantity ["+worderStkBeanObj.getQuantity()+"] .setAllocQty [" + worderStkBeanObj.getAllocQty() + "] .setUpdQty [" + worderStkBeanObj.getUpdQty() + "] .setPotencyAdj( [" +worderStkBeanObj.getPotencyAdj() + "] .setQtyAdj(" + worderStkBeanObj.getQtyAdj() + "]" );
								worderStkBeanObj.setQuantity(Double.parseDouble(df.format(balanceQty)) );
								System.out.println("manohar after .setQuantity 7["+worderStkBeanObj.getQuantity()+"]");
								worderStkBeanObj.setAllocQty(updQty);
								worderStkBeanObj.setUpdQty(updQty);
								worderStkBeanObj.setStockSufficient("Y");
								worderStkBeanObj.setQtyAdj(potencyAdj);
								worderStkBeanObj.setPotencyAdj(potencyAdj);
								System.out.println("manohar after .setQuantity 110["+worderStkBeanObj.getQuantity()+"] .getPotencyAdj[" +  worderStkBeanObj.getPotencyAdj() + "] .getAllocQty[" + worderStkBeanObj.getAllocQty() + "] .getUpdQty[" + worderStkBeanObj.getUpdQty() +"]");								
								System.out.println("manohar@@Sufficient--> after  .getExpLevel [" + worderStkBeanObj.getExpLevel() +"] .setQuantity ["+worderStkBeanObj.getQuantity()+"] .setAllocQty [" + worderStkBeanObj.getAllocQty() + "] .setUpdQty [" + worderStkBeanObj.getUpdQty() + "] .setPotencyAdj( [" +worderStkBeanObj.getPotencyAdj() + "] .setQtyAdj(" + worderStkBeanObj.getQtyAdj() + "]" );

								if(potencyAdjMapY.containsKey(adjPotency) )
								{
									potencyAdjMapY.put(adjPotency, Double.parseDouble(df.format((potencyAdjMapY.get(adjPotency) + potencyAdj ))) );
								}
								else
								{
									potencyAdjMapY.put(adjPotency,  potencyAdj );
								}
								balanceQty = 0;
								isSufficient = true;
								// 02-jun-16 manoharan
								worderExpLevSufficient.put(worderStkBeanObj.getWorkOrder()+":"+worderStkBeanObj.getExpLevel(), isSufficient);
								updateWoBeanSufficient(worderStkBeanObj.getWorkOrder(), worderStkBeanObj.getExpLevel(), "Y");
							}
						}
						else if(adjPotency != null && adjPotency.trim().length() > 0)
						{
							System.out.println("Potency to be adjusted x [" + adjPotency + "]");
							//unitPotency = getColumnDescr(conn, "unit__potency", "bom", "bom_code", worderDetailBeanObj.getBomCode());
							qtyPotencyUnit = 0;
							if(stkQuantity < balanceQty)
							{
								updQty = stkQuantity;
								balanceQty = Double.parseDouble(df.format( balanceQty - stkQuantity)) ;
								isSufficient = false;
							}
							else
							{
								updQty = balanceQty;
								balanceQty = 0;
								isSufficient = true;
								// 02-jun-16 manoharan
								worderExpLevSufficient.put(worderStkBeanObj.getWorkOrder()+":"+worderStkBeanObj.getExpLevel(), isSufficient);
								updateWoBeanSufficient(worderStkBeanObj.getWorkOrder(), worderStkBeanObj.getExpLevel(), "Y");
							}
							System.out.println("manohar before .setQuantity 111["+worderStkBeanObj.getQuantity()+"] .getPotencyAdj[" +  worderStkBeanObj.getPotencyAdj() + "] .getAllocQty[" + worderStkBeanObj.getAllocQty() + "] .getUpdQty[" + worderStkBeanObj.getUpdQty() +"]");
							worderStkBeanObj.setQuantity(updQty);
							worderStkBeanObj.setAllocQty(updQty);
							worderStkBeanObj.setUpdQty(updQty);
							System.out.println("manohar after .setQuantity 111["+worderStkBeanObj.getQuantity()+"] .getPotencyAdj[" +  worderStkBeanObj.getPotencyAdj() + "] .getAllocQty[" + worderStkBeanObj.getAllocQty() + "] .getUpdQty[" + worderStkBeanObj.getUpdQty() +"]");


							//if (!worderStkBeanObj.getUnit().trim().equals(unitPotency.trim())) // 09-mar-16 manoharan check unit are same, if so no conversion required
							//{
							//   qtyPotencyUnit = disCommon.convQtyFactor(worderStkBeanObj.getUnit(), unitPotency, worderStkBeanObj.getItemCode(), requiredStock, conn);
							//}
							//else
							//{
								qtyPotencyUnit = balanceQty;
							//}

							qtyPotencyUnit = Double.parseDouble(df.format(qtyPotencyUnit));
							System.out.println("manohar qtyPotencyUnit before[" + qtyPotencyUnit + "] .getAllocQty() [" + worderStkBeanObj.getAllocQty() + "]");
							System.out.println("Stk qty After--->>["+worderStkBeanObj.getStkQuantity()+"]");
							// 19-May-16 manoharan if there are multiple for same exp_lev then add
							//AdjPotencyExplevQtyMap.put(adjPotency+":"+expLevel, requiredStock);
							System.out.println("AdjPotencyExplevQtyMap before ["+AdjPotencyExplevQtyMap + "]");
							System.out.println("manohar qtyPotencyUnit after[" + qtyPotencyUnit + "] potencyAdjMapN before [" + potencyAdjMapN + "]");
							if(!AdjPotencyExplevQtyMap.containsKey(adjPotency+":"+expLevel))
							{
								AdjPotencyExplevQtyMap.put(adjPotency+":"+expLevel,  qtyPotencyUnit );
								if(potencyAdjMapN.containsKey(adjPotency))
								{

									potencyAdjMapN.put(adjPotency, Double.parseDouble(df.format((potencyAdjMapN.get(adjPotency) + qtyPotencyUnit ))));
								}
								else
								{
									potencyAdjMapN.put(adjPotency,  qtyPotencyUnit );
								}

							}
							System.out.println("AdjPotencyExplevQtyMap after [ "+AdjPotencyExplevQtyMap + "]");
							System.out.println("manohar qtyPotencyUnit after[" + qtyPotencyUnit + "] potencyAdjMapN after [" + potencyAdjMapN + "]");
							// end 19-May-16 manoharan if there are multiple for same exp_lev then add
							//qtyPotencyUnit = qtyPotencyUnit + worderStkBeanObj.getAllocQty();
						}
						else
						{
							if(stkQuantity < balanceQty)
							{
								updQty = stkQuantity;
								balanceQty = Double.parseDouble(df.format( balanceQty - stkQuantity));
								isSufficient = false;
							}
							else
							{
								updQty = balanceQty;
								balanceQty =  0;
								isSufficient = true;
								// 02-jun-16 manoharan
								worderExpLevSufficient.put(worderStkBeanObj.getWorkOrder()+":"+worderStkBeanObj.getExpLevel(), isSufficient);
								updateWoBeanSufficient(worderStkBeanObj.getWorkOrder(), worderStkBeanObj.getExpLevel(), "Y");
								
							}
							System.out.println("manohar before .setQuantity 114["+worderStkBeanObj.getQuantity()+"] .getPotencyAdj[" +  worderStkBeanObj.getPotencyAdj() + "] .getAllocQty[" + worderStkBeanObj.getAllocQty() + "] .getUpdQty[" + worderStkBeanObj.getUpdQty() +"]");
							worderStkBeanObj.setQuantity(updQty);
							worderStkBeanObj.setAllocQty(updQty);
							worderStkBeanObj.setUpdQty(updQty);
							System.out.println("manohar after .setQuantity 114["+worderStkBeanObj.getQuantity()+"] .getPotencyAdj[" +  worderStkBeanObj.getPotencyAdj() + "] .getAllocQty[" + worderStkBeanObj.getAllocQty() + "] .getUpdQty[" + worderStkBeanObj.getUpdQty() +"]");
						}
						/////////////////////////////////////////////////////////////////////////////////////
					}
					else
					{
						System.out.println("stkPotencyPerc is less than minimum potency please check........");
					}
				}
				else
				{
					if(stkQuantity < balanceQty)
					{
						updQty = stkQuantity;
						balanceQty = Double.parseDouble(df.format(balanceQty - stkQuantity));
						isSufficient = false;
					}
					else
					{
						updQty = balanceQty;
						balanceQty = 0;
						isSufficient = true;
						worderExpLevSufficient.put(worderStkBeanObj.getWorkOrder()+":"+worderStkBeanObj.getExpLevel(), isSufficient);
						updateWoBeanSufficient(worderStkBeanObj.getWorkOrder(), worderStkBeanObj.getExpLevel(), "Y");
						
					}
					// 06-jun-16 manoharan do round off as per iss_criteria of item
					if (!"Y".equals(matchPotency) || (adjPotency == null || adjPotency.trim().length() == 0 ))
					{
						if("F".equalsIgnoreCase(issCriteria))
						{
							qtyPerArt = getQtyPerArt(stkKey,conn,campgnNo);
							 if(qtyPerArt > updQty)
							 {
								 updQty = qtyPerArt;
							 }
							 else
							 {
									System.out.println("allocated quantity will be 2 shippersize");
									double noArtQuot = 0,noArtRem = 0,noArt = 0;
									noArtQuot= updQty / qtyPerArt ;
									noArtRem = updQty % qtyPerArt ;
									if(noArtRem > 0)
									{
										noArtRem = 1;
									}
									noArtQuot = (int) noArtQuot;
									noArt = noArtQuot + noArtRem;

									System.out.println("NO Art in current site="+noArt);

									updQty = qtyPerArt * noArt;
							 }
							
						}
						else if("W".equalsIgnoreCase(issCriteria))
						{
							updQty = stkQuantity;
						}
					}
					
					if(stkindex != -1)
					{
						System.out.println("manohar before .setQuantity 112["+worderStkBeanObj.getQuantity()+"] .getPotencyAdj[" +  worderStkBeanObj.getPotencyAdj() + "] .getAllocQty[" + worderStkBeanObj.getAllocQty() + "] .getUpdQty[" + worderStkBeanObj.getUpdQty() +"]");
						worderStkBeanObj.setAllocQty(worderStkBeanObj.getAllocQty() + updQty);
						worderStkBeanObj.setQuantity(worderStkBeanObj.getQuantity() + updQty);
						worderStkBeanObj.setUpdQty(worderStkBeanObj.getAllocQty());
						System.out.println("manohar after .setQuantity 112["+worderStkBeanObj.getQuantity()+"] .getPotencyAdj[" +  worderStkBeanObj.getPotencyAdj() + "] .getAllocQty[" + worderStkBeanObj.getAllocQty() + "] .getUpdQty[" + worderStkBeanObj.getUpdQty() +"]");
					}
					else
					{
						System.out.println("manohar before .setQuantity 113["+worderStkBeanObj.getQuantity()+"] .getPotencyAdj[" +  worderStkBeanObj.getPotencyAdj() + "] .getAllocQty[" + worderStkBeanObj.getAllocQty() + "] .getUpdQty[" + worderStkBeanObj.getUpdQty() +"]");
						worderStkBeanObj.setAllocQty(updQty);
						worderStkBeanObj.setQuantity(updQty);
						worderStkBeanObj.setUpdQty(updQty);
						System.out.println("manohar after .setQuantity 113["+worderStkBeanObj.getQuantity()+"] .getPotencyAdj[" +  worderStkBeanObj.getPotencyAdj() + "] .getAllocQty[" + worderStkBeanObj.getAllocQty() + "] .getUpdQty[" + worderStkBeanObj.getUpdQty() +"]");
					}
					
				}

				
				/* 31-may-16 manoharan not the right place
				qtyPerArt = getQtyPerArt(stkKey,conn);
				 //Changed by wasim on 08-03-2016 to consider issue criteria [START]
				 if(!"Y".equalsIgnoreCase(otherSite))
				 {	 
					 
					 System.out.println("Issue Criteria found="+issCriteria);

						if("F".equalsIgnoreCase(issCriteria))
						{
							 if(qtyPerArt > requiredQty)
							 {
								 requiredQty = qtyPerArt;
							 }
							 else
							 {
									System.out.println("allocated quantity will be 2 shippersize");
									double noArtQuot = 0,noArtRem = 0,noArt = 0;
									noArtQuot= requiredQty / qtyPerArt ;
									noArtRem = requiredQty % qtyPerArt ;
									if(noArtRem > 0)
									{
										noArtRem = 1;
									}
									noArtQuot = (int) noArtQuot;
									noArt = noArtQuot + noArtRem;

									System.out.println("NO Art in current site="+noArt);

									requiredQty = qtyPerArt * noArt;
							 }
						}
						else if("W".equalsIgnoreCase(issCriteria))
						{
							requiredQty = stkQuantity;
						}
						else
						{
							System.out.println("Integral quantity is"+requiredQty);
						}

						System.out.println("Final Allocated quantity in current site="+requiredQty);
				 }	    
				  //Changed by wasim on 08-03-2016 to consider issue criteria [END]
				*/
				//If other site Y then set quantity according to site code and
				//item code wise in siteItemReqQtyList. (For creating distribution issue / sale order )
				//if("Y".equalsIgnoreCase(otherSite)) //commented by azhar[01/FEB/2017] to create DO for only critical item
			if("Y".equalsIgnoreCase(otherSite) && detailMap.get("CRIT_ITEM").equalsIgnoreCase("Y")) // added by azhar[01/FEB/2017] to create DO for only critical item
				{
					int index = indexOfSiteItemReqQtyList(detailMap.get("SITE_CODE"),detailMap.get("ITEM_CODE"));
					System.out.println("index : "+index);
					
					HashMap siteItemMap = new HashMap();
					siteItemMap.put("ITEM_CODE", detailMap.get("ITEM_CODE"));
					siteItemMap.put("LOC_CODE", locCode);
					siteItemMap.put("LOT_NO", lotNo);
					siteItemMap.put("LOT_SL", lotSl);
					siteItemMap.put("SITE_CODE", detailMap.get("SITE_CODE"));
					siteItemMap.put("QUANTITY", updQty);
					siteItemMap.put("UNIT", unit);
					siteItemMap.put("SITE_CODE__MFG", siteCodeMfg);
					siteItemMap.put("MFG_DATE", mfgDateT);
					siteItemMap.put("EXP_DATE", expDateT);
					
					if(index > -1)
					{
						siteItemSumBeanObj = siteItemReqQtyList.get(index);
						System.out.println("Printing siteItemBeanObj.getOtherSiteQty() before "+siteItemSumBeanObj.getOtherSiteQty());
						siteItemSumBeanObj.setOtherSiteQty(Double.valueOf(updQty));
						System.out.println("Printing siteItemBeanObj.getOtherSiteQty() after "+siteItemSumBeanObj.getOtherSiteQty());
						siteItemSumBeanObj.setCritItem(detailMap.get("CRIT_ITEM"));
						siteItemSumBeanObj.setStockValues(siteItemMap);
						siteItemReqQtyList.set(index, siteItemSumBeanObj);
						
					}
					else
					{
						System.out.println("Site code ship["+detailMap.get("SITE_CODE__SHIP")+"]Site code Dlv["+detailMap.get("SITE_CODE")+"]");

						siteItemSumBeanObj = new SiteItemSummaryBean();
						//Changed by wasim on 01-04-2016 to allocate quantity as per qty per art for other site
						siteItemSumBeanObj.setOtherSiteQty(Double.valueOf(updQty));
						siteItemSumBeanObj.setStockValues(siteItemMap);
						//System.out.println("Allocating quantity for other site="+qtyPerArt);
						//siteItemSumBeanObj.setOtherSiteQty(Double.valueOf(qtyPerArt));
						siteItemSumBeanObj.setItemCode(detailMap.get("ITEM_CODE"));

						//Changed by wasim on 26-02-2016 as site code ship and dlv will be vice versa in case of other side Y [START]
						//siteItemSumBeanObj.setSiteCode(detailMap.get("SITE_CODE"));
						//siteItemSumBeanObj.setSiteCodeShip(detailMap.get("SITE_CODE__SHIP"));
						siteItemSumBeanObj.setSiteCode(detailMap.get("SITE_CODE__SHIP"));
						siteItemSumBeanObj.setSiteCodeShip(detailMap.get("SITE_CODE"));
						siteItemSumBeanObj.setItemCode(detailMap.get("ITEM_CODE"));
						siteItemSumBeanObj.setCritItem(detailMap.get("CRIT_ITEM"));
						//Changed by wasim on 26-02-2016 as site code ship and dlv will be vice versa in case of other side Y [END]

						siteItemSumBeanObj.setWorkOrder(detailMap.get("WORK_ORDER"));
						siteItemSumBeanObj.setTransTran(transTranMap.get(detailMap.get("SITE_CODE__SHIP")+":"+detailMap.get("SITE_CODE")));
						siteItemReqQtyList.add(siteItemSumBeanObj);
					}
				}else if("Y".equalsIgnoreCase(otherSite) && detailMap.get("CRIT_ITEM").equalsIgnoreCase("N")){
					System.out.println("Non critical items::");
					
					int indexNC = indexOfSiteItemReqQtyListNC(detailMap.get("SITE_CODE"),detailMap.get("ITEM_CODE"));
					System.out.println("index : "+indexNC);
					
					HashMap siteItemMapNC = new HashMap();
					siteItemMapNC.put("ITEM_CODE", detailMap.get("ITEM_CODE"));
					siteItemMapNC.put("LOC_CODE", locCode);
					siteItemMapNC.put("LOT_NO", lotNo);
					siteItemMapNC.put("LOT_SL", lotSl);
					siteItemMapNC.put("SITE_CODE", detailMap.get("SITE_CODE"));
					siteItemMapNC.put("QUANTITY", updQty);
					siteItemMapNC.put("UNIT", unit);
					siteItemMapNC.put("SITE_CODE__MFG", siteCodeMfg);
					siteItemMapNC.put("MFG_DATE", mfgDateT);
					siteItemMapNC.put("EXP_DATE", expDateT);
					
					if(indexNC > -1)
					{
						siteItemSumBeanObjNC = siteItemReqQtyListNC.get(indexNC);
						System.out.println("Printing siteItemBeanObj.getOtherSiteQty() before "+siteItemSumBeanObjNC.getOtherSiteQty());
						siteItemSumBeanObjNC.setOtherSiteQty(Double.valueOf(updQty));
						System.out.println("Printing siteItemBeanObj.getOtherSiteQty() after "+siteItemSumBeanObjNC.getOtherSiteQty());
						siteItemSumBeanObjNC.setCritItem(detailMap.get("CRIT_ITEM"));
						siteItemSumBeanObjNC.setStockValues(siteItemMapNC);
						siteItemReqQtyListNC.set(indexNC, siteItemSumBeanObjNC);
						
					}
					else
					{
						System.out.println("Site code ship["+detailMap.get("SITE_CODE__SHIP")+"]Site code Dlv["+detailMap.get("SITE_CODE")+"]");

						siteItemSumBeanObjNC = new SiteItemSummaryBeanNC();
						siteItemSumBeanObjNC.setOtherSiteQty(Double.valueOf(updQty));
						siteItemSumBeanObjNC.setStockValues(siteItemMapNC);
						siteItemSumBeanObjNC.setItemCode(detailMap.get("ITEM_CODE"));

						siteItemSumBeanObjNC.setSiteCode(detailMap.get("SITE_CODE__SHIP"));
						siteItemSumBeanObjNC.setSiteCodeShip(detailMap.get("SITE_CODE"));
						siteItemSumBeanObjNC.setItemCode(detailMap.get("ITEM_CODE"));
						siteItemSumBeanObjNC.setCritItem(detailMap.get("CRIT_ITEM"));
						siteItemSumBeanObjNC.setWorkOrder(detailMap.get("WORK_ORDER"));
						siteItemSumBeanObjNC.setTransTran(transTranMap.get(detailMap.get("SITE_CODE__SHIP")+":"+detailMap.get("SITE_CODE")));
						siteItemReqQtyListNC.add(siteItemSumBeanObjNC);
					}
				}


				//worderStkBeanList.add(worderStkBeanObj);
				//System.out.println("doneStockDetailsMap : "+doneStockDetailsMap);

				//in doneStockDetailsMap put key as stock primary key. If in both work order contains same item code
				//then item1 already stock allocate then for item2 same stock allocated .
				//so we check in map,if stock key already allocated or not.
				System.out.println("updQty@@ : ["+updQty+"] ");
				System.out.println("stkQuantity@@ : ["+stkQuantity+"] ");
				System.out.println("softAllocQty@@ : ["+softAllocQty+"] ");
				System.out.println("Min quantity required="+minQtyReq);

				requiredQty = Double.parseDouble(df.format(updQty));

				//Changed by wasim on 16-03-2016 to consider and allocate minimum qty req [START]
				 /*double minReqQty = worderStkBeanObj.getMinQtyReq();
				 System.out.println("Min req Quantity in current site="+minReqQty);
				 if(requiredQty <= (stkQuantity + softAllocQty))
				 {
					 System.out.println("Stock is sufficent");
				 }
				 else
				 {
					 if(minQtyReq <= (stkQuantity + softAllocQty))
					 {
						 requiredQty = minReqQty;
					 }
				 }*/
				 System.out.println("Finally required quantity ="+requiredQty);
				//Changed by wasim on 16-03-2016 to consider and allocate minimum qty req [END]

				 if("R".equalsIgnoreCase(detailMap.get("USAGE_TYPE")) && (! "N".equalsIgnoreCase(detailMap.get("ALLOCATE_TYPE")) ) ){
				stockAllocMap.put("ALLOC_QTY",""+updQty);
				stockAllocMap.put("LOC_CODE", locCode);
				stockAllocMap.put("ITEM_CODE",detailMap.get("ITEM_CODE"));
				stockAllocMap.put("SITE_CODE",detailMap.get("SITE_CODE"));
				stockAllocMap.put("LOT_NO",lotNo);
				stockAllocMap.put("LOT_SL",lotSl);
				allocRetStr = updateStockAllocQty(stockAllocMap,conn,campgnNo);
				System.out.println("allocRetStr :"+allocRetStr);
				 }
				 /*String output4 = checkOutput(conn);
				 System.out.println("check 4:::: " + output4);*/
					
				finalAllocatedQty = updQty;
				System.out.println("Adding stk..........."+worderStkBeanObj.getStockSufficient());
				System.out.println("isReallocation Flag in check site["+isReallocation+"] [" + stkindex + "]");
				/*if (!isReallocation)
				{
					if(stkindex != -1)
					{
						worderStkBeanObj.setAllocQty(worderStkBeanObj.getAllocQty() + finalAllocatedQty);
						System.out.println("manohar before .setQuantity 1["+worderStkBeanObj.getQuantity()+"] isReallocation[" + isReallocation + "]");
						worderStkBeanObj.setQuantity(worderStkBeanObj.getQuantity() + finalAllocatedQty);
						System.out.println("manohar after .setQuantity 1["+worderStkBeanObj.getQuantity()+"]");
					}
					else
					{
						worderStkBeanObj.setAllocQty(finalAllocatedQty);
						System.out.println("manohar before .setQuantity 2["+worderStkBeanObj.getQuantity()+"]");
						//worderStkBeanObj.setQuantity(finalAllocatedQty);
						System.out.println("manohar after .setQuantity 2["+worderStkBeanObj.getQuantity()+"]");
					}
				}*/
				if(isSufficient)
				{
					worderStkBeanObj.setStockSufficient("Y");
				}
				if(isReallocation)
				{
					// 31-may-16 manoharan potency to be calculated if necessary
					tempWorderExpStkBeanList.add(worderStkBeanObj);
				}
				else
				{
					System.out.println("Allocated quantity adding="+finalAllocatedQty);
					if(stkindex != -1)
					{
						System.out.println("For existing item allocated quantity final alloc qty="+worderStkBeanObj.getAllocQty());
						System.out.println("Setting on index["+worderStkBeanObj.getItemCode()+"]["+stkindex+"]");
						System.out.println("worderStkBeanObj["+worderStkBeanObj+"]");
						worderStkBeanList.set(stkindex,worderStkBeanObj);
					}
					else
					{
						System.out.println("Adding itemCode in worderStkBeanList"+detailMap.get("ITEM_CODE"));
						//worderStkBeanObj.setStkQuantity(stkQuantity - finalAllocatedQty);
						System.out.println("worderStkBeanObj["+worderStkBeanObj+"]");
						worderStkBeanList.add(worderStkBeanObj);
					}
				}

				System.out.println("Added stk..........."+isSufficient);
				if(isSufficient)
				{
					break;
				}

			} //end while
			
			/*String output6 = checkOutput(conn);
			System.out.println("check 6:::: " + output6);*/
			
			//added by azhar 15/MAR/2017 [START] for DO creation of non critical items even if stock is absent
			 checkOtherKey = "OTHER" + detailMap.get("WORK_ORDER") + detailMap.get("EXP_LEV") + detailMap.get("ITEM_CODE");
			 checkCurrentKey = "CURRENT" + detailMap.get("WORK_ORDER") + detailMap.get("EXP_LEV") + detailMap.get("ITEM_CODE");
			
			if(zeroStockCheckMap.size() > 0 && zeroStockCheckMap.containsKey(checkCurrentKey)){
				
				System.out.println("inside zeroStockCheck map:::");
				if("Y".equalsIgnoreCase(otherSite) && !zeroStockCheckMap.containsKey(checkOtherKey) && "N".equalsIgnoreCase(detailMap.get("CRIT_ITEM"))){
					System.out.println("Checking for other site");
					//TODO when stock is  there in current and not in other
					int indexNC = indexOfSiteItemReqQtyListNC(detailMap.get("SITE_CODE"),detailMap.get("ITEM_CODE"));
					System.out.println("index for zero stock : "+indexNC);
					
					HashMap siteItemMapNC = new HashMap();
					siteItemMapNC.put("ITEM_CODE", detailMap.get("ITEM_CODE"));
					siteItemMapNC.put("LOC_CODE", locCode);
					siteItemMapNC.put("LOT_NO", lotNo);
					siteItemMapNC.put("LOT_SL", lotSl);
					siteItemMapNC.put("SITE_CODE", detailMap.get("SITE_CODE"));
					siteItemMapNC.put("QUANTITY", balanceQty);
					siteItemMapNC.put("UNIT", unit);
					siteItemMapNC.put("SITE_CODE__MFG", siteCodeMfg);
					siteItemMapNC.put("MFG_DATE", mfgDateT);
					siteItemMapNC.put("EXP_DATE", expDateT);
					
					if(indexNC > -1)
					{
						siteItemSumBeanObjNC = siteItemReqQtyListNC.get(indexNC);
						System.out.println("Printing siteItemBeanObj.getOtherSiteQty() in zero stock check : before  "+siteItemSumBeanObjNC.getOtherSiteQty());
						siteItemSumBeanObjNC.setOtherSiteQty(Double.valueOf(balanceQty));
						System.out.println("Printing siteItemBeanObj.getOtherSiteQty() in zero stock check : after "+siteItemSumBeanObjNC.getOtherSiteQty());
						siteItemSumBeanObjNC.setCritItem(detailMap.get("CRIT_ITEM"));
						siteItemSumBeanObjNC.setStockValues(siteItemMapNC);
						siteItemReqQtyListNC.set(indexNC, siteItemSumBeanObjNC);
						
					}
					else
					{
						System.out.println("in else when stock not in other site");
						
						siteItemSumBeanObjNC = new SiteItemSummaryBeanNC();
						siteItemSumBeanObjNC.setOtherSiteQty(Double.valueOf(balanceQty));
						siteItemSumBeanObjNC.setStockValues(siteItemMapNC);
						siteItemSumBeanObjNC.setItemCode(detailMap.get("ITEM_CODE"));

						siteItemSumBeanObjNC.setSiteCode(detailMap.get("SITE_CODE__SHIP"));
						siteItemSumBeanObjNC.setSiteCodeShip(detailMap.get("SITE_CODE"));
						siteItemSumBeanObjNC.setItemCode(detailMap.get("ITEM_CODE"));
						siteItemSumBeanObjNC.setCritItem(detailMap.get("CRIT_ITEM"));
						siteItemSumBeanObjNC.setWorkOrder(detailMap.get("WORK_ORDER"));
						siteItemSumBeanObjNC.setTransTran(transTranMap.get(detailMap.get("SITE_CODE__SHIP")+":"+detailMap.get("SITE_CODE")));
						siteItemReqQtyListNC.add(siteItemSumBeanObjNC);
					}
				}
			}else{
				if("N".equalsIgnoreCase(detailMap.get("CRIT_ITEM"))  && "Y".equalsIgnoreCase(otherSite)){
				//TODO when stock is not in both sites
				System.out.println("In loop when stock is not in both sites::");
				int indexNC = indexOfSiteItemReqQtyListNC(detailMap.get("SITE_CODE"),detailMap.get("ITEM_CODE"));
				System.out.println("index  when stock is not in any sites: "+indexNC);
				
				HashMap siteItemMapNC = new HashMap();
				siteItemMapNC.put("ITEM_CODE", detailMap.get("ITEM_CODE"));
				siteItemMapNC.put("LOC_CODE", locCode);
				siteItemMapNC.put("LOT_NO", lotNo);
				siteItemMapNC.put("LOT_SL", lotSl);
				siteItemMapNC.put("SITE_CODE", detailMap.get("SITE_CODE"));
				siteItemMapNC.put("QUANTITY", balanceQty);
				siteItemMapNC.put("UNIT", unit);
				siteItemMapNC.put("SITE_CODE__MFG", siteCodeMfg);
				siteItemMapNC.put("MFG_DATE", mfgDateT);
				siteItemMapNC.put("EXP_DATE", expDateT);
				
				if(indexNC > -1)
				{
					siteItemSumBeanObjNC = siteItemReqQtyListNC.get(indexNC);
					System.out.println("Printing siteItemBeanObj.getOtherSiteQty() before "+siteItemSumBeanObjNC.getOtherSiteQty());
					siteItemSumBeanObjNC.setOtherSiteQty(Double.valueOf(balanceQty));
					System.out.println("Printing siteItemBeanObj.getOtherSiteQty() after "+siteItemSumBeanObjNC.getOtherSiteQty());
					siteItemSumBeanObjNC.setCritItem(detailMap.get("CRIT_ITEM"));
					siteItemSumBeanObjNC.setStockValues(siteItemMapNC);
					siteItemReqQtyListNC.set(indexNC, siteItemSumBeanObjNC);
					
				}
				else
				{
					System.out.println("in else when stock not in both sites");
					siteItemSumBeanObjNC = new SiteItemSummaryBeanNC();
					siteItemSumBeanObjNC.setOtherSiteQty(Double.valueOf(balanceQty));
					siteItemSumBeanObjNC.setStockValues(siteItemMapNC);
					siteItemSumBeanObjNC.setItemCode(detailMap.get("ITEM_CODE"));

					siteItemSumBeanObjNC.setSiteCode(detailMap.get("SITE_CODE__SHIP"));
					siteItemSumBeanObjNC.setSiteCodeShip(detailMap.get("SITE_CODE"));
					siteItemSumBeanObjNC.setItemCode(detailMap.get("ITEM_CODE"));
					siteItemSumBeanObjNC.setCritItem(detailMap.get("CRIT_ITEM"));
					siteItemSumBeanObjNC.setWorkOrder(detailMap.get("WORK_ORDER"));
					siteItemSumBeanObjNC.setTransTran(transTranMap.get(detailMap.get("SITE_CODE__SHIP")+":"+detailMap.get("SITE_CODE")));
					siteItemReqQtyListNC.add(siteItemSumBeanObjNC);
				}
			}
			}
			
			//added by azhar 15/MAR/2017 [END] for DO creation of non critical items even if stock is absent
			
			//added by azhar[22-dec-16][START]when balance qty is 0 it doesn't enter's into while loop even if stock is sufficient
			if(balanceQty <= 0){
				isSufficient = true;
				System.out.println("is sufficient::" +isSufficient);
			}
			//added by azhar[22-dec-16][END]
			
			rs.close();
			rs= null;
			pstmt.close();
			pstmt = null;
			System.out.println("manohar in checkCurrentSiteStock  after allocation balanceQty ["+balanceQty+"] isSufficient[" +  isSufficient + "]");
			
			returnMapDetails.put("ERROR_CODE","");
			returnMapDetails.put("BALANCE_QTY",String.valueOf(balanceQty));
			returnMapDetails.put("BALANCE_QTY",String.valueOf(balanceQty));
			if(isSufficient)
			{
				returnMapDetails.put("IS_SUFFICIENT","true");
			}
			else if(!isSufficient && count == 0)
			{
				//returnMapDetails.put("ERROR_CODE","");
				//returnMapDetails.put("BALANCE_QTY",String.valueOf(requiredQty));
				returnMapDetails.put("IS_SUFFICIENT","false");
			}
			else
			{
				//stock not sufficient check for alternate item.
				//checkForAlternateItem(detailMap, conn);
				//returnMapDetails.put("ERROR_CODE","");
				//returnMapDetails.put("BALANCE_QTY",String.valueOf(balanceQty));
				returnMapDetails.put("IS_SUFFICIENT","false");
			}
			System.out.println("manohar in checkCurrentSiteStock  after allocation balanceQty ["+balanceQty+"] isSufficient[" +  isSufficient + "] returnMapDetails [" + returnMapDetails + "]");
	}
	catch(Exception e)
	{
		e.printStackTrace();
		writeWorkOrderLog(e.toString(),campgnNo);//TODO
		throw new Exception(e);
	}
	finally
	{
		if(rs!=null)
		{
			rs.close();
			rs = null;

		}
		if(pstmt!=null)
		{
			pstmt.close();
			pstmt = null;
		}
	
		System.out.println("Consider Partial Alternative in last current site["+considerPartialAlt+"]");
		System.out.println("critical item:::: " + detailMap.get("CRIT_ITEM"));
		
		/*String output7 = checkOutput(conn);
		System.out.println("check 7:::: " + output7);*/
		
		if("N".equalsIgnoreCase(considerPartialAlt) && "Y".equalsIgnoreCase(detailMap.get("CRIT_ITEM")) && "Y".equalsIgnoreCase(otherSite))
		{
			System.out.println("CONSIDER_PARTIAL_ALT in CurrentSiteStock................."+returnMapDetails);
			balanceQty = Double.parseDouble(returnMapDetails.get("BALANCE_QTY"));
			//errorCodeRet = returnMapDetails.get("ERROR_CODE");
			isSufficient = Boolean.parseBoolean(returnMapDetails.get("IS_SUFFICIENT"));
			if(balanceQty > 0)
			{
				returnMapDetails.put("BALANCE_QTY", "0");
				returnMapDetails.put("ERROR_CODE", "");
				returnMapDetails.put("IS_SUFFICIENT", "false");
				System.out.println("worderStkBeanList clear.......................");
				removeDataConsiderPartialAlt(workOrder,expLevel);
				conn.rollback();
			}
		}
		/*String output8 = checkOutput(conn);
		System.out.println("check 8:::: " + output8);*/
	}
		return returnMapDetails;
}
	//Get item standard potency
	//if in item master POTENCY_PERC is null or 0 then return 100.
	private double getItemStandardPotency(String itemCode,Connection conn,String campgnNo) throws ITMException, Exception
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String sql ="";
		double stdPotency = 0;

		try
		{
			sql ="SELECT POTENCY_PERC FROM ITEM WHERE ITEM_CODE = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, itemCode);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				stdPotency = rs.getDouble("POTENCY_PERC");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			if(stdPotency == 0)
			{
				stdPotency = 100;
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			writeWorkOrderLog(e.toString(),campgnNo);//TODO
			throw new SQLException(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;

			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		return stdPotency;

	}
	/*if not  sufficient
	 potency adjustment = ( stock quantity - (stock quantity * stock potency / standard potency) )
	if sufficient
	potency adjustment = ( required quantity /stock potency * standard potency) - required quantity
	*/

	private String checkStockPotencyNew(Connection conn,String campgnNo) throws Exception
	{
		System.out.println("@@in checkStockPotency..........");
		String expLevel = "",matchPotency = "",adjPotency = "",itemCode = "",unitPotency = "",lotNoIssue = "";
		String adjPotencyChkY = "",expLevelNew = "",allocRetStr = "" , adjPotencyChkN = "",locGroup = "",workOrder = "";
		//String splitKey [];
		//int index = -1; // 09-mar-16 manoharan
		double qtyPotencyUnit = 0,ItemStdPotency = 0,potencyAdjNew = 0, potencyAdjExpLev = 0,quantityReqExpLev = 0;
		double requiredStock = 0,availableStock = 0,potencyAdj = 0,stkPotencyPerc = 0,updQty = 0,balance = 0,currentLotQty = 0,currntEqualQty = 0;
		//Map<String,Double>potencyAdjMapY = null;
		//Map<String,Double>potencyAdjMapYTemp = null; // 09-mar-16 manoharan not used
		//Map<String,Double>potencyAdjMapN = null;
		//Map<String,Double>requiredQtyAddMap = new HashMap<String,Double>(); // 09-mar-16 manoharan not used
		//Map<String,Double>stockAllocAddNMap = new HashMap<String,Double>(); // 09-mar-16 manoharan not used

		//Map<String,Double> AdjPotencyExplevQtyMap = null;
		//Map<String,Double>deAllocQtyMap = null; // 09-mar-16 manoharan
		//ArrayList<WorkOrderDetailBean> tempWorderBeanList = new ArrayList<WorkOrderDetailBean>(); // 09-mar-16 manoharan not used

		WorkOrderDetailBean worderDetailBeanObj = null;
		WorderStkBean worderStkBeanObj = null;
		//tempWorderBeanList = workOrderBeanList;
		//tempWorderStkBeanList = worderStkBeanList;
		//int count = -1,indexAdjust = -1;
		int foundIndex = -1;
		boolean isSufficient = false;
		double deallocQty = 0,allocatedQty = 0, extraQty = 0, potencyAdjLot = 0, quantityReqLot = 0;
		Map<String,String> stockAllocMap = new HashMap<String,String>();
		boolean removeElement = false;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		SiteItemSummaryBean  siteItemSumBeanObj = null;
		SiteItemSummaryBeanNC  siteItemSumBeanObjNC = null;
		String sql ="";
		
		try
		{

			for(String workOrderPotency : workOrderList)
			{
				sql = "select loc_group, lot_no__issue from workorder where work_order = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, workOrderPotency);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					locGroup = checkNull(rs.getString(1));
					lotNoIssue = checkNull(rs.getString(2));
				}
				rs.close();
				rs = null;
				pstmt.close();

				potencyAdjMapY =  null;
				potencyAdjMapN = null;
				AdjPotencyExplevQtyMap = null;

				potencyAdjMapY =  new HashMap<String,Double>();
				potencyAdjMapN = new HashMap<String,Double>();
				//deAllocQtyMap = new HashMap<String,Double>();// 09-mar-16 manoharan
				AdjPotencyExplevQtyMap = new HashMap<String,Double>();
				//count = -1; // 09-mar-16 manoharan
				//for(WorkOrderDetailBean worderDetailBeanObj : workOrderBeanList)
				for(int outerCtr=0 ; outerCtr < workOrderBeanList.size(); outerCtr++)
				{
					worderDetailBeanObj = (WorkOrderDetailBean) workOrderBeanList.get(outerCtr);
					
					//System.out.println("Printing WorkOrder Bean Details");
					//System.out.println("worderDetailBeanObj->WorkOrder["+worderDetailBeanObj.getWorkOrder()+"]  ExpLev["+worderDetailBeanObj.getExpLev()+"] ItemCode["+worderDetailBeanObj.getItemCode()+"]SiteCode["+worderDetailBeanObj.getSiteCode()+"] Quantity["+worderDetailBeanObj.getQuantity()+"] Sufficient["+worderDetailBeanObj.getSufficient()+"] Operation["+worderDetailBeanObj.getOperation()+"] AllocateType["+worderDetailBeanObj.getAllocateType()+"] getAdjPotency ["+worderDetailBeanObj.getAdjPotency()+"] MatchPotency["+worderDetailBeanObj.getMatchPotency()+"] Crit Item["+worderDetailBeanObj.getCritItem()+"] ConsiderPartialAlt["+worderDetailBeanObj.getConsiderPartialAlt()+"] ConsiderLotNoIssue["+worderDetailBeanObj.getConsiderLotNoIssue()+"] MinPotencyPerc["+worderDetailBeanObj.getMinPotencyPerc()+"] QtyPer["+worderDetailBeanObj.getQtyPer()+"]getSuppCodeMfg["+worderDetailBeanObj.getSuppCodeMfg()+"] GetSufficient["+worderDetailBeanObj.getSufficient()+"] ReqQuantity["+worderDetailBeanObj.getReqQty()+"] getPotencyAdjQty["+worderDetailBeanObj.getPotencyAdjQty()+"] getItemCategory["+worderDetailBeanObj.getItemCategory()+"] getMinReqQty["+worderDetailBeanObj.getMinReqQty()+"] BatchNo["+worderDetailBeanObj.getBatchQty()+"] getRoundTo["+worderDetailBeanObj.getRoundTo()+"] getRound["+worderDetailBeanObj.getRound()+"] LocationUsageType["+worderDetailBeanObj.getLocUsageType()+"] ItemActive["+worderDetailBeanObj.getItemActive()+" AdjustedQuantity["+worderDetailBeanObj.getAdjustedQty()+"] UpdQuantity["+worderDetailBeanObj.getUpdQty()+"] LineType["+worderDetailBeanObj.getLineType()+"] QuantityRef["+worderDetailBeanObj.getQuantityRef()+"] UsageType["+worderDetailBeanObj.getUsageType()+"]");
					
					//count++;// 09-mar-16 manoharan
					//deAllocQtyMap.clear();// 09-mar-16 manoharan
					//System.out.println("potency calculation-------------------->>"+count);// 09-mar-16 manoharan
					//index = -1; // 09-mar-16 manoharan
					workOrder = worderDetailBeanObj.getWorkOrder().trim();
					if(!workOrderPotency.trim().equalsIgnoreCase(workOrder.trim()))
					{
						continue;
					}
					expLevel = worderDetailBeanObj.getExpLev().trim();
					matchPotency = worderDetailBeanObj.getMatchPotency();
					adjPotency = worderDetailBeanObj.getAdjPotency();
					requiredStock = worderDetailBeanObj.getQuantity();
					balance = requiredStock;
					System.out.println("MatchPotency---------->>["+matchPotency+"]");
					// 09-mar-16 manoharan following code block may not be necessary
					 //ListIterator<WorderStkBean> iterator = worderStkBeanList.listIterator();
					//for(WorderStkBean worderStkBeanObj : worderStkBeanList)
					 //while(true)// 09-mar-16 manoharan removed unnecessary loop
					 //{
						// index = -1; // 09-mar-16 manoharan
						/* //09-mar-16 manoharan block commented
						if(isReallocation)
						{
							shortageQty = requiredStock;

							for(WorderStkBean tempStkObj : worderStkBeanListTemp)
							{
								worderStkBeanList.add(tempStkObj);
							}
							worderStkBeanListTemp.clear();
							iterator = worderStkBeanList.listIterator();
						}
						*/  //09-mar-16 manoharan end block comment
						 //Changed by wasim on 07-04-2016 to comment and change while loop
						 //while(iterator.hasNext())
						System.out.println("Same wo worderDetailBeanObj->WorkOrder["+worderDetailBeanObj.getWorkOrder()+"] " +
								"ExpLev["+worderDetailBeanObj.getExpLev()+"] ItemCode["+worderDetailBeanObj.getItemCode()+"]" +
								"SiteCode["+worderDetailBeanObj.getSiteCode()+"] Quantity["+worderDetailBeanObj.getQuantity()+"]" +
								"Sufficient["+worderDetailBeanObj.getSufficient()+"] Operation["+worderDetailBeanObj.getOperation()+"] " +
								"AllocateType["+worderDetailBeanObj.getAllocateType()+"]" +" getAdjPotency ["+worderDetailBeanObj.getAdjPotency()+"]" +
								"MatchPotency["+worderDetailBeanObj.getMatchPotency()+"] Crit Item["+worderDetailBeanObj.getCritItem()+"] " +
								"ConsiderPartialAlt["+worderDetailBeanObj.getConsiderPartialAlt()+"] ConsiderLotNoIssue["+worderDetailBeanObj.getConsiderLotNoIssue()+"]" +
								" MinPotencyPerc["+worderDetailBeanObj.getMinPotencyPerc()+"] QtyPer["+worderDetailBeanObj.getQtyPer()+"]getSuppCodeMfg["+worderDetailBeanObj.getSuppCodeMfg()+"] GetSufficient["+worderDetailBeanObj.getSufficient()+"] ReqQuantity["+worderDetailBeanObj.getReqQty()+"] getPotencyAdjQty["+worderDetailBeanObj.getPotencyAdjQty()+"] getItemCategory["+worderDetailBeanObj.getItemCategory()+"] getMinReqQty["+worderDetailBeanObj.getMinReqQty()+"] BatchNo["+worderDetailBeanObj.getBatchQty()+"] getRoundTo["+worderDetailBeanObj.getRoundTo()+"] getRound["+worderDetailBeanObj.getRound()+"] LocationUsageType["+worderDetailBeanObj.getLocUsageType()+"] ItemActive["+worderDetailBeanObj.getItemActive()+" AdjustedQuantity["+worderDetailBeanObj.getAdjustedQty()+"] UpdQuantity["+worderDetailBeanObj.getUpdQty()+"] LineType["+worderDetailBeanObj.getLineType()+"] QuantityRef["+worderDetailBeanObj.getQuantityRef()+"] UsageType["+worderDetailBeanObj.getUsageType()+"] lot_no ["+worderDetailBeanObj.getLotNo()+"]");
						for(int innerCtr=0 ; innerCtr < worderStkBeanList.size(); innerCtr++)
						{
							worderStkBeanObj = (WorderStkBean) worderStkBeanList.get(innerCtr);

							 updQty = 0;
							 // index++; // 09-mar-16 manoharan

							 //WorderStkBean worderStkBeanObj = iterator.next();//Commented by wasim as iterator loop commented
	
							 //System.out.println("workOrder----->>["+workOrder+"] ["+worderStkBeanObj.getWorkOrder()+"]");
							 //System.out.println("expLevel----->>["+expLevel+"] ["+worderStkBeanObj.getExpLevel()+"]");
							 
							 //System.out.println("***ItemCode["+worderStkBeanObj.getItemCode()+"]LotNo["+worderStkBeanObj.getLotNo()+"]LotSl["+worderStkBeanObj.getLotSl()+"]LocCode["+worderStkBeanObj.getLocCode()+"]SiteCode["+worderStkBeanObj.getSiteCode()+"]AllocQty["+worderStkBeanObj.getAllocQty()+"]Stock Quantity["+worderStkBeanObj.getStkQuantity()+"]getQuantity["+worderStkBeanObj.getQuantity()+"]PotencyAdj["+worderStkBeanObj.getPotencyAdj()+"]Stock Sufficient["+worderStkBeanObj.getStockSufficient()+"]getCritItem["+worderStkBeanObj.getCritItem()+"]MinReqQty["+worderStkBeanObj.getMinQtyReq()+"]StockPotencyPerc["+worderStkBeanObj.getStkPotencyPerc()+"]OtherSiteYN["+worderStkBeanObj.getOtherSiteYN()+"]getAlternate["+worderStkBeanObj.getAlternate()+"]Qty Adj["+worderStkBeanObj.getQtyAdj()+"]UpdQty["+worderStkBeanObj.getUpdQty()+"MfgDate["+worderStkBeanObj.getMfgDate()+"]ExpDate["+worderStkBeanObj.getExpDate()+"SiteCodeMfg["+worderStkBeanObj.getSiteCodeMfg()+"]ReserveLineNo["+worderStkBeanObj.getReserveLineNo()+"]ReserveStkTranId["+worderStkBeanObj.getReserveStkTranId()+"]Unit["+worderStkBeanObj.getUnit()+"]");
							System.out.println("workOrder["+workOrder+"] BEAN ["+worderStkBeanObj.getWorkOrder().trim() +
									" expLevel ["+ expLevel +"] BEAN  ["+worderStkBeanObj.getExpLevel().trim() +"]");
							 if(workOrder.equalsIgnoreCase(worderStkBeanObj.getWorkOrder().trim()) && expLevel.equalsIgnoreCase(worderStkBeanObj.getExpLevel().trim()))
							 {
							 
								 System.out.println("Same wo/expLev worderStkBeanObj->workOrder["+worderStkBeanObj.getWorkOrder()+"]" +
								 		" expLevel ["+worderStkBeanObj.getExpLevel()+"]" +
								 		"ItemCode["+worderStkBeanObj.getItemCode()+"]" + "LotNo["+worderStkBeanObj.getLotNo()+"]" +
								 		"LotSl["+worderStkBeanObj.getLotSl()+"]LocCode["+worderStkBeanObj.getLocCode()+"]" +
								 		"SiteCode["+worderStkBeanObj.getSiteCode()+"]" + "AllocQty["+worderStkBeanObj.getAllocQty()+"]Stock Quantity["+worderStkBeanObj.getStkQuantity()+"]" +
								 		"getQuantity["+worderStkBeanObj.getQuantity()+"]PotencyAdj["+worderStkBeanObj.getPotencyAdj()+"]" +
								 		" Qty Adj["+worderStkBeanObj.getQtyAdj()+"]UpdQty["+worderStkBeanObj.getUpdQty()+"]" +
								 		" Stock Sufficient["+worderStkBeanObj.getStockSufficient()+"]getCritItem["+worderStkBeanObj.getCritItem()+"]" +
								 		"MinReqQty["+worderStkBeanObj.getMinQtyReq()+"]StockPotencyPerc["+worderStkBeanObj.getStkPotencyPerc()+"]" +
								 		"OtherSiteYN["+worderStkBeanObj.getOtherSiteYN()+"]getAlternate["+worderStkBeanObj.getAlternate()+"]" +
								 		"MfgDate["+worderStkBeanObj.getMfgDate()+"]ExpDate["+worderStkBeanObj.getExpDate()+"]" +
								 		" SiteCodeMfg["+worderStkBeanObj.getSiteCodeMfg()+"]ReserveLineNo["+worderStkBeanObj.getReserveLineNo()+"]ReserveStkTranId["+worderStkBeanObj.getReserveStkTranId()+"]Unit["+worderStkBeanObj.getUnit()+"]");
								 
								 availableStock = worderStkBeanObj.getStkQuantity();//available 
								 stkPotencyPerc = worderStkBeanObj.getStkPotencyPerc();
								 itemCode = worderStkBeanObj.getItemCode();
								 currentLotQty = worderStkBeanObj.getAllocQty();//allocated
								 
								 System.out.println("***WorkOrder["+worderStkBeanObj.getWorkOrder()+"] and ExpLev["+worderStkBeanObj.getExpLevel()+"]");
								 System.out.println("***Main bomdet Quantity["+requiredStock+"] Available before ["+availableStock+"] Current Lot Qty ["+currentLotQty+"] Balance ["+balance+"] Site code ["+worderStkBeanObj.getSiteCode()+"]");
								 //uncommented by azhar[START]
								sql = "SELECT quantity - ALLOC_QTY FROM STOCK  where item_code = ? and site_code = ? and loc_code  = ? "
										+" and lot_no = ? and lot_sl = ?  ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, worderStkBeanObj.getItemCode());
								pstmt.setString(2, worderStkBeanObj.getSiteCode());
								pstmt.setString(3, worderStkBeanObj.getLocCode());
								pstmt.setString(4, worderStkBeanObj.getLotNo());
								pstmt.setString(5, worderStkBeanObj.getLotSl());
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									availableStock = rs.getDouble(1);
								}
								rs.close();
								rs = null;
								pstmt.close();
								//uncommented by azhar[END]
								System.out.println("***Main bomdet Quantity["+requiredStock+"] Available after ["+availableStock+"]");
								
								 if("Y".equalsIgnoreCase(matchPotency))
								 {
									 ItemStdPotency = getItemStandardPotency(itemCode, conn,campgnNo);
									 System.out.println("@@ItemCode["+itemCode+"] and @@ItemStdPotency="+ItemStdPotency);
									 
									 //if(currentLotQty < balance)  // if stock not sufficient
									//if (availableStock > 0)
									//{
										 if(availableStock <= balance)//Changed by wasim on 18-04-2016 as discussion with manohar sir
										 {
											
											 System.out.println("@@Not Sufficient-->currentLotQty ["+currentLotQty+"] stkPotencyPerc ["+stkPotencyPerc+"] ItemStdPotency ["+ItemStdPotency+"]");
											 
											 potencyAdj = currentLotQty - (currentLotQty * stkPotencyPerc /  ItemStdPotency);
											 potencyAdj = Double.parseDouble(df.format(potencyAdj));//0.200
											 System.out.println("After calculating potencyAdj NOT SUFFICIENT----->>["+potencyAdj+"]");

											 currntEqualQty = Double.parseDouble(df.format(currentLotQty - potencyAdj)) ; //4-0.2 = 3.8
											
											 balance = Double.parseDouble(df.format(balance - currntEqualQty)); //6-3.8 = 2.2
											
											 worderStkBeanObj.setPotencyAdj(Double.parseDouble(df.format(potencyAdj)));
											 ///////////////////////////////worderStkBeanObj.setQuantity(currntEqualQty);
											 worderStkBeanObj.setQtyAdj(Double.parseDouble(df.format(potencyAdj)));
											 balance = Double.parseDouble(df.format(balance));
											 //worderStkBeanObj.setAllocQty(Double.parseDouble(df.format(balance)));//Changed by wasim on 18-04-2014 
											 //updQty = worderStkBeanObj.getAllocQty() + potencyAdj;
											 //worderStkBeanObj.setAllocQty(updQty);
											 System.out.println("manohar before .setQuantity 3["+worderStkBeanObj.getQuantity()+"]");
											 worderStkBeanObj.setQuantity(currntEqualQty); 
											 System.out.println("manohar after .setQuantity 3["+worderStkBeanObj.getQuantity()+"]");
											 worderStkBeanObj.setAllocQty(currentLotQty);  // 09-mar-16 manoharan added if stock not sufficient full stock of the lot is allocated
											 worderStkBeanObj.setUpdQty(currentLotQty);
											 
											 if(potencyAdjMapY.containsKey(adjPotency) )
											 {
												 potencyAdjMapY.put(adjPotency, (potencyAdjMapY.get(adjPotency) + potencyAdj ));
											 }
											 else
											 {
												 potencyAdjMapY.put(adjPotency,  potencyAdj );
											 }
											 System.out.println("worderStkBeanObj"+worderStkBeanObj+"]");
											 worderStkBeanList.set(innerCtr, worderStkBeanObj);
											 
											 System.out.println("Final Balance="+balance);
											 if(balance > 0)
											 {
												System.out.print("Balance > 0 [" + balance + "] worderStkBeanList.size() [" + worderStkBeanList.size() + "] innerCtr [" + innerCtr +"]" );
												if (worderStkBeanList.size() > innerCtr +1)
												{
													 WorderStkBean worderStkBeanObjNext = (WorderStkBean) worderStkBeanList.get(innerCtr+1);
													 if(
														(worderStkBeanObj.getWorkOrder().equals(worderStkBeanObjNext.getWorkOrder())) &&
														(worderStkBeanObj.getExpLevel().equals(worderStkBeanObjNext.getExpLevel()))
													   )
													 {
														 System.out.print("Workorder and explev more stock bean exist in list continue with next for further calculation");
														 continue;
													 }
												}
											 }
										 }
										 else  // if stock sufficient
										 {
											 System.out.println("@@Sufficient--> balance["+balance+"] stkPotencyPerc ["+stkPotencyPerc+"] ItemStdPotency ["+ItemStdPotency+"]");
											 
											 potencyAdj =  ( balance /stkPotencyPerc * ItemStdPotency) - balance;
											 potencyAdj = Double.parseDouble(df.format(potencyAdj));
											 System.out.println("After calculating potencyAdj SUFFICIENT before ----->>["+potencyAdj+"]");
											 
											 worderStkBeanObj.setQtyAdj(Double.parseDouble(df.format(potencyAdj)));
											 System.out.println("After calculating potencyAdj SUFFICIENT after ----->>["+potencyAdj+"]");
											 //updQty = worderStkBeanObj.getAllocQty() + potencyAdj; // 03-jun-16 manoharan commented
											 updQty = balance + potencyAdj; // 03-jun-16 manoharan added
											 updQty = Double.parseDouble(df.format(updQty));
											 System.out.println("manohar before potencyAdj [" + potencyAdj + "] updQty [" + updQty + "] .setQuantity 4["+worderStkBeanObj.getQuantity()+"] .getAllocQty [" + worderStkBeanObj.getAllocQty()+ "].setPotencyAdj[" + worderStkBeanObj.getPotencyAdj() + "] .setQtyAdj[" + worderStkBeanObj.getQtyAdj() + "]" );
											 worderStkBeanObj.setQuantity(balance); 
											worderStkBeanObj.setQtyAdj(potencyAdj);
											worderStkBeanObj.setPotencyAdj(potencyAdj);
											 
											 if (availableStock >= updQty) // 03-jun-16 manoharan stock available in same lot
											 {
												System.out.println("updQty - getAllocQty [" + Double.parseDouble(df.format((updQty - worderStkBeanObj.getAllocQty()))) + "]");
												//stockAllocMap.put("ALLOC_QTY",""+potencyAdj); // 03-jun-16 manoharan commented
												stockAllocMap.put("ALLOC_QTY",""+ Double.parseDouble(df.format((updQty - worderStkBeanObj.getAllocQty())))); // 03-jun-16 manoharan added
												stockAllocMap.put("LOC_CODE", worderStkBeanObj.getLocCode());
												stockAllocMap.put("ITEM_CODE",worderStkBeanObj.getItemCode());
												stockAllocMap.put("SITE_CODE",worderStkBeanObj.getSiteCode());
												stockAllocMap.put("LOT_NO",worderStkBeanObj.getLotNo());
												stockAllocMap.put("LOT_SL",worderStkBeanObj.getLotSl());
												
												//added by azhar[START][24-APR-2017] potency qty was not updated in siteitemsummary bean
												 if(worderStkBeanObj.getCritItem().equalsIgnoreCase("Y")) 
													{
														int index = indexOfSiteItemReqQtyList(worderStkBeanObj.getSiteCode(),worderStkBeanObj.getItemCode());
														System.out.println("index : "+index);
														System.out.println("quantity check critical:: " + Double.parseDouble(df.format((updQty - worderStkBeanObj.getAllocQty()))));
														HashMap siteItemMap = new HashMap();
														siteItemMap.put("ITEM_CODE", worderStkBeanObj.getItemCode());
														siteItemMap.put("LOC_CODE", worderStkBeanObj.getLocCode());
														siteItemMap.put("LOT_NO", worderStkBeanObj.getLotNo());
														siteItemMap.put("LOT_SL", worderStkBeanObj.getLotSl());
														siteItemMap.put("SITE_CODE", worderStkBeanObj.getSiteCode());
														siteItemMap.put("QUANTITY", Double.parseDouble(df.format((updQty - worderStkBeanObj.getAllocQty()))));
														siteItemMap.put("UNIT", worderStkBeanObj.getUnit());
														siteItemMap.put("SITE_CODE__MFG", worderStkBeanObj.getSiteCodeMfg());
														siteItemMap.put("MFG_DATE", worderStkBeanObj.getMfgDate());
														siteItemMap.put("EXP_DATE", worderStkBeanObj.getExpDate());
														
														if(index > -1)
														{
															siteItemSumBeanObj = siteItemReqQtyList.get(index);
															System.out.println("Printing siteItemBeanObj.getOtherSiteQty() before "+siteItemSumBeanObj.getOtherSiteQty());
															siteItemSumBeanObj.setOtherSiteQty(Double.parseDouble(df.format((updQty - worderStkBeanObj.getAllocQty()))));
															System.out.println("Printing siteItemBeanObj.getOtherSiteQty() after "+siteItemSumBeanObj.getOtherSiteQty());
															siteItemSumBeanObj.setCritItem(worderStkBeanObj.getCritItem());
															siteItemSumBeanObj.setStockValues(siteItemMap);
															siteItemReqQtyList.set(index, siteItemSumBeanObj);
															
														}
														else
														{
															//System.out.println("Site code ship["+worderDetailBeanObj.getSiteCode()+"]Site code Dlv["+worderStkBeanObj.getSiteCode()+"]");

															siteItemSumBeanObj = new SiteItemSummaryBean();
															siteItemSumBeanObj.setOtherSiteQty(Double.parseDouble(df.format((updQty - worderStkBeanObj.getAllocQty()))));
															siteItemSumBeanObj.setStockValues(siteItemMap);
															siteItemSumBeanObj.setItemCode(worderStkBeanObj.getItemCode());
															siteItemSumBeanObj.setSiteCode(worderStkBeanObj.getSiteCode());
															//siteItemSumBeanObj.setSiteCodeShip(worderDetailBeanObj.getSiteCode());
															siteItemSumBeanObj.setItemCode(worderStkBeanObj.getItemCode());
															siteItemSumBeanObj.setCritItem(worderStkBeanObj.getCritItem());
															siteItemSumBeanObj.setWorkOrder(worderStkBeanObj.getWorkOrder());
															//siteItemSumBeanObj.setTransTran(transTranMap.get(worderDetailBeanObj.getSiteCode()+":"+worderDetailBeanObj.getSiteCode()));
															siteItemReqQtyList.add(siteItemSumBeanObj);
														}
													}else if(worderStkBeanObj.getCritItem().equalsIgnoreCase("N")){
														System.out.println("Non critical items::");
														
														int indexNC = indexOfSiteItemReqQtyListNC(worderStkBeanObj.getSiteCode(),worderStkBeanObj.getItemCode());
														System.out.println("index : "+indexNC);
														
														HashMap siteItemMapNC = new HashMap();
														siteItemMapNC.put("ITEM_CODE", worderStkBeanObj.getItemCode());
														siteItemMapNC.put("LOC_CODE", worderStkBeanObj.getLocCode());
														siteItemMapNC.put("LOT_NO", worderStkBeanObj.getLotNo());
														siteItemMapNC.put("LOT_SL", worderStkBeanObj.getLotSl());
														siteItemMapNC.put("SITE_CODE", worderStkBeanObj.getSiteCode());
														siteItemMapNC.put("QUANTITY", Double.parseDouble(df.format((updQty - worderStkBeanObj.getAllocQty()))));
														siteItemMapNC.put("UNIT", worderStkBeanObj.getUnit());
														siteItemMapNC.put("SITE_CODE__MFG", worderStkBeanObj.getSiteCodeMfg());
														siteItemMapNC.put("MFG_DATE", worderStkBeanObj.getMfgDate());
														siteItemMapNC.put("EXP_DATE", worderStkBeanObj.getExpDate());
														
														System.out.println("quantity check non critical:: " + Double.parseDouble(df.format((updQty - worderStkBeanObj.getAllocQty()))));
														
														if(indexNC > -1)
														{
															siteItemSumBeanObjNC = siteItemReqQtyListNC.get(indexNC);
															System.out.println("Printing siteItemBeanObj.getOtherSiteQty() before "+siteItemSumBeanObjNC.getOtherSiteQty());
															siteItemSumBeanObjNC.setOtherSiteQty(Double.parseDouble(df.format((updQty - worderStkBeanObj.getAllocQty()))));
															System.out.println("Printing siteItemBeanObj.getOtherSiteQty() after "+siteItemSumBeanObjNC.getOtherSiteQty());
															siteItemSumBeanObjNC.setCritItem(worderStkBeanObj.getCritItem());
															siteItemSumBeanObjNC.setStockValues(siteItemMapNC);
															siteItemReqQtyListNC.set(indexNC, siteItemSumBeanObjNC);
															
														}
														else
														{
															//System.out.println("Site code ship["+worderDetailBeanObj.getSiteCode()+"]Site code Dlv["+worderStkBeanObj.getSiteCode()+"]");

															siteItemSumBeanObjNC = new SiteItemSummaryBeanNC();
															siteItemSumBeanObjNC.setOtherSiteQty(Double.parseDouble(df.format((updQty - worderStkBeanObj.getAllocQty()))));
															siteItemSumBeanObjNC.setStockValues(siteItemMapNC);
															siteItemSumBeanObjNC.setItemCode(worderStkBeanObj.getItemCode());
															siteItemSumBeanObjNC.setSiteCode(worderStkBeanObj.getSiteCode());
															//siteItemSumBeanObjNC.setSiteCodeShip(worderDetailBeanObj.getSiteCode());
															siteItemSumBeanObjNC.setItemCode(worderStkBeanObj.getItemCode());
															siteItemSumBeanObjNC.setCritItem(worderStkBeanObj.getCritItem());
															siteItemSumBeanObjNC.setWorkOrder(worderStkBeanObj.getWorkOrder());
															//siteItemSumBeanObjNC.setTransTran(transTranMap.get(worderDetailBeanObj.getSiteCode()+":"+worderDetailBeanObj.getSiteCode()));
															siteItemReqQtyListNC.add(siteItemSumBeanObjNC);
														}
													}
												//added by azhar[END][24-APR-2017] potency qty was not updated in siteitemsummary bean
												
												if("Y".equalsIgnoreCase(worderStkBeanObj.getCritItem())){
													System.out.println("check potency allocation");
												
													allocRetStr = updateStockAllocQty(stockAllocMap,conn,campgnNo);
												}
												System.out.println("allocRetStr :"+allocRetStr);
												worderStkBeanObj.setAllocQty(updQty); // 2 + 0.244 = 2.244
												worderStkBeanObj.setUpdQty(updQty);
												worderStkBeanObj.setStockSufficient("Y");
												worderExpLevSufficient.put(worderStkBeanObj.getWorkOrder()+":"+worderStkBeanObj.getExpLevel(), true);
												updateWoBeanSufficient(worderStkBeanObj.getWorkOrder(), worderStkBeanObj.getExpLevel(), "Y");
												System.out.println("manohar after potencyAdj [" + potencyAdj + "] updQty [" + updQty + "] .setQuantity 4["+worderStkBeanObj.getQuantity()+"] .getAllocQty [" + worderStkBeanObj.getAllocQty()+ "].setPotencyAdj[" + worderStkBeanObj.getPotencyAdj() + "] .setQtyAdj[" + worderStkBeanObj.getQtyAdj() + "]" );
												System.out.println("worderStkBeanObj["+worderStkBeanObj+"]");
												worderStkBeanList.set(innerCtr, worderStkBeanObj);												

												if(potencyAdjMapY.containsKey(adjPotency) )
												{
													potencyAdjMapY.put(adjPotency, Double.parseDouble(df.format((potencyAdjMapY.get(adjPotency) + potencyAdj ))) );
												}
												else
												{
													potencyAdjMapY.put(adjPotency,  potencyAdj );
												}
												balance = 0;
												worderExpLevSufficient.put(worderStkBeanObj.getWorkOrder()+":"+worderStkBeanObj.getExpLevel(), true);
												updateWoBeanSufficient(worderStkBeanObj.getWorkOrder(), worderStkBeanObj.getExpLevel(), "Y");

											 }
											 else
											 {
											 
												potencyAdj = Double.parseDouble(df.format((potencyAdj - (updQty - availableStock)))) ;
												stockAllocMap.put("ALLOC_QTY",""+potencyAdj);
												stockAllocMap.put("LOC_CODE", worderStkBeanObj.getLocCode());
												stockAllocMap.put("ITEM_CODE",worderStkBeanObj.getItemCode());
												stockAllocMap.put("SITE_CODE",worderStkBeanObj.getSiteCode());
												stockAllocMap.put("LOT_NO",worderStkBeanObj.getLotNo());
												stockAllocMap.put("LOT_SL",worderStkBeanObj.getLotSl());
												
												//added by azhar[START][24-APR-2017] potency qty was not updated in siteitemsummary bean
												 if(worderStkBeanObj.getCritItem().equalsIgnoreCase("Y")) 
													{
														int index = indexOfSiteItemReqQtyList(worderStkBeanObj.getSiteCode(),worderStkBeanObj.getItemCode());
														System.out.println("index : "+index);
														
														HashMap siteItemMap = new HashMap();
														siteItemMap.put("ITEM_CODE", worderStkBeanObj.getItemCode());
														siteItemMap.put("LOC_CODE", worderStkBeanObj.getLocCode());
														siteItemMap.put("LOT_NO", worderStkBeanObj.getLotNo());
														siteItemMap.put("LOT_SL", worderStkBeanObj.getLotSl());
														siteItemMap.put("SITE_CODE", worderStkBeanObj.getSiteCode());
														siteItemMap.put("QUANTITY", Double.parseDouble(df.format((updQty - worderStkBeanObj.getAllocQty()))));
														siteItemMap.put("UNIT", worderStkBeanObj.getUnit());
														siteItemMap.put("SITE_CODE__MFG", worderStkBeanObj.getSiteCodeMfg());
														siteItemMap.put("MFG_DATE", worderStkBeanObj.getMfgDate());
														siteItemMap.put("EXP_DATE", worderStkBeanObj.getExpDate());
														
														if(index > -1)
														{
															siteItemSumBeanObj = siteItemReqQtyList.get(index);
															System.out.println("Printing siteItemBeanObj.getOtherSiteQty() before "+siteItemSumBeanObj.getOtherSiteQty());
															siteItemSumBeanObj.setOtherSiteQty(Double.parseDouble(df.format((updQty - worderStkBeanObj.getAllocQty()))));
															System.out.println("Printing siteItemBeanObj.getOtherSiteQty() after "+siteItemSumBeanObj.getOtherSiteQty());
															siteItemSumBeanObj.setCritItem(worderStkBeanObj.getCritItem());
															siteItemSumBeanObj.setStockValues(siteItemMap);
															siteItemReqQtyList.set(index, siteItemSumBeanObj);
															
														}
														else
														{
															//System.out.println("Site code ship["+worderDetailBeanObj.getSiteCode()+"]Site code Dlv["+worderStkBeanObj.getSiteCode()+"]");

															siteItemSumBeanObj = new SiteItemSummaryBean();
															siteItemSumBeanObj.setOtherSiteQty(Double.parseDouble(df.format((updQty - worderStkBeanObj.getAllocQty()))));
															siteItemSumBeanObj.setStockValues(siteItemMap);
															siteItemSumBeanObj.setItemCode(worderStkBeanObj.getItemCode());
															siteItemSumBeanObj.setSiteCode(worderStkBeanObj.getSiteCode());
															//siteItemSumBeanObj.setSiteCodeShip(worderDetailBeanObj.getSiteCode());
															siteItemSumBeanObj.setItemCode(worderStkBeanObj.getItemCode());
															siteItemSumBeanObj.setCritItem(worderStkBeanObj.getCritItem());
															//Changed by wasim on 26-02-2016 as site code ship and dlv will be vice versa in case of other side Y [END]

															siteItemSumBeanObj.setWorkOrder(worderStkBeanObj.getWorkOrder());
															//siteItemSumBeanObj.setTransTran(transTranMap.get(worderDetailBeanObj.getSiteCode()+":"+worderDetailBeanObj.getSiteCode()));
															siteItemReqQtyList.add(siteItemSumBeanObj);
														}
													}else if(worderStkBeanObj.getCritItem().equalsIgnoreCase("N")){
														System.out.println("Non critical items::");
														
														int indexNC = indexOfSiteItemReqQtyListNC(worderStkBeanObj.getSiteCode(),worderStkBeanObj.getItemCode());
														System.out.println("index : "+indexNC);
														
														HashMap siteItemMapNC = new HashMap();
														siteItemMapNC.put("ITEM_CODE", worderStkBeanObj.getItemCode());
														siteItemMapNC.put("LOC_CODE", worderStkBeanObj.getLocCode());
														siteItemMapNC.put("LOT_NO", worderStkBeanObj.getLotNo());
														siteItemMapNC.put("LOT_SL", worderStkBeanObj.getLotSl());
														siteItemMapNC.put("SITE_CODE", worderStkBeanObj.getSiteCode());
														siteItemMapNC.put("QUANTITY", Double.parseDouble(df.format((updQty - worderStkBeanObj.getAllocQty()))));
														siteItemMapNC.put("UNIT", worderStkBeanObj.getUnit());
														siteItemMapNC.put("SITE_CODE__MFG", worderStkBeanObj.getSiteCodeMfg());
														siteItemMapNC.put("MFG_DATE", worderStkBeanObj.getMfgDate());
														siteItemMapNC.put("EXP_DATE", worderStkBeanObj.getExpDate());
														
														if(indexNC > -1)
														{
															siteItemSumBeanObjNC = siteItemReqQtyListNC.get(indexNC);
															System.out.println("Printing siteItemBeanObj.getOtherSiteQty() before "+siteItemSumBeanObjNC.getOtherSiteQty());
															siteItemSumBeanObjNC.setOtherSiteQty(Double.parseDouble(df.format((updQty - worderStkBeanObj.getAllocQty()))));
															System.out.println("Printing siteItemBeanObj.getOtherSiteQty() after "+siteItemSumBeanObjNC.getOtherSiteQty());
															siteItemSumBeanObjNC.setCritItem(worderStkBeanObj.getCritItem());
															siteItemSumBeanObjNC.setStockValues(siteItemMapNC);
															siteItemReqQtyListNC.set(indexNC, siteItemSumBeanObjNC);
															
														}
														else
														{
															//System.out.println("Site code ship["+worderDetailBeanObj.getSiteCode()+"]Site code Dlv["+worderStkBeanObj.getSiteCode()+"]");

															siteItemSumBeanObjNC = new SiteItemSummaryBeanNC();
															siteItemSumBeanObjNC.setOtherSiteQty(Double.parseDouble(df.format((updQty - worderStkBeanObj.getAllocQty()))));
															siteItemSumBeanObjNC.setStockValues(siteItemMapNC);
															siteItemSumBeanObjNC.setItemCode(worderStkBeanObj.getItemCode());
															siteItemSumBeanObjNC.setSiteCode(worderStkBeanObj.getSiteCode());
															//siteItemSumBeanObj.setSiteCodeShip(worderDetailBeanObj.getSiteCode());
															siteItemSumBeanObjNC.setItemCode(worderStkBeanObj.getItemCode());
															siteItemSumBeanObjNC.setCritItem(worderStkBeanObj.getCritItem());
															siteItemSumBeanObjNC.setWorkOrder(worderStkBeanObj.getWorkOrder());
															//siteItemSumBeanObjNC.setTransTran(transTranMap.get(worderDetailBeanObj.getSiteCode()+":"+worderDetailBeanObj.getSiteCode()));
															siteItemReqQtyListNC.add(siteItemSumBeanObjNC);
														}
													}
												//added by azhar[END][24-APR-2017] potency qty was not updated in siteitemsummary bean
												 
												//allocRetStr = updateStockAllocQty(stockAllocMap,conn,campgnNo);
												if("Y".equalsIgnoreCase(worderStkBeanObj.getCritItem())){
													System.out.println("check potency allocation");
												allocRetStr = updateStockAllocQty(stockAllocMap,conn,campgnNo);
												}
												
												System.out.println("allocRetStr :"+allocRetStr);
												updQty = worderStkBeanObj.getAllocQty() + potencyAdj; 
												updQty = Double.parseDouble(df.format(updQty));
												worderStkBeanObj.setAllocQty(updQty); 
												worderStkBeanObj.setUpdQty(updQty);
												worderStkBeanObj.setStockSufficient("N");
												worderExpLevSufficient.put(worderStkBeanObj.getWorkOrder()+":"+worderStkBeanObj.getExpLevel(), false);
												updateWoBeanSufficient(worderStkBeanObj.getWorkOrder(), worderStkBeanObj.getExpLevel(), "N");
												worderStkBeanObj.setQtyAdj(potencyAdj);//wasim on 13-04-2016
												worderStkBeanObj.setPotencyAdj(potencyAdj);//wasim on 13-04-2016
												System.out.println("manohar after .setQuantity 4["+worderStkBeanObj.getQuantity()+"] .setPotencyAdj[" + worderStkBeanObj.getPotencyAdj() + "] .setQtyAdj[" + worderStkBeanObj.getQtyAdj() + "]" );
												System.out.println("worderStkBeanObj["+worderStkBeanObj+"]");
												worderStkBeanList.set(innerCtr, worderStkBeanObj);

												if(potencyAdjMapY.containsKey(adjPotency) )
												{
													potencyAdjMapY.put(adjPotency, Double.parseDouble(df.format((potencyAdjMapY.get(adjPotency) + potencyAdj ))) );
												}
												else
												{
													potencyAdjMapY.put(adjPotency,  potencyAdj );
												}
											 
											 
												balance =  Double.parseDouble(df.format(updQty - availableStock)) ;
											 }

										 }//End
									//}
									System.out.println("manohar after potency calculation balance 44["+balance+"]" );
									 if(balance > 0)
									 {
										isReallocation = true;
										HashMap<String,String> detailMap = new HashMap<String,String>();
										detailMap.put("USE_INV_STATUS", worderDetailBeanObj.getUseInvStatus());
										detailMap.put("SUPP_CODE_MFG", worderDetailBeanObj.getSuppCodeMfg());
										detailMap.put("DIMENSION", worderDetailBeanObj.getDimension());
										detailMap.put("MIN_POTENCY_PERC", String.valueOf(worderDetailBeanObj.getMinPotencyPerc()) );
										detailMap.put("EXP_LEV", worderDetailBeanObj.getExpLev());
										detailMap.put("OPERATION", ""+worderDetailBeanObj.getOperation());
										detailMap.put("CRIT_ITEM", worderDetailBeanObj.getCritItem());
										detailMap.put("ITEM_REF", worderDetailBeanObj.getItemRef());
										detailMap.put("BOM_CODE", worderDetailBeanObj.getBomCode());
										detailMap.put("ITEM_CODE", worderDetailBeanObj.getItemCode());
										detailMap.put("QUANTITY", String.valueOf(worderDetailBeanObj.getQuantity()));
										detailMap.put("SITE_CODE", worderStkBeanObj.getSiteCode());//wasim
										detailMap.put("UNIT", worderDetailBeanObj.getUnit());
										detailMap.put("MATCH_POTENCY", worderDetailBeanObj.getMatchPotency());
										detailMap.put("ADJ_POTENCY", worderDetailBeanObj.getAdjPotency());
										detailMap.put("USAGE_TYPE", worderDetailBeanObj.getUsageType());
										detailMap.put("CONSIDER_LOTNO_ISSUE", worderDetailBeanObj.getConsiderLotNoIssue());
										detailMap.put("LOC_USAGE_TYPE", worderDetailBeanObj.getLocUsageType());
										detailMap.put("WORK_ORDER", worderDetailBeanObj.getWorkOrder());
										detailMap.put("ITEM_ACTIVE", worderDetailBeanObj.getItemActive());
										detailMap.put("ALLOCATE_TYPE", worderDetailBeanObj.getAllocateType());
										detailMap.put("ITEM_CATEGORY", worderDetailBeanObj.getItemCategory());
										detailMap.put("IS_ALTERNATE", "N");
										if("Y".equalsIgnoreCase(worderStkBeanObj.getOtherSiteYN()))
										{
										 detailMap.put("OTHER_SITE", "Y");
										}
										else
										{
										 detailMap.put("OTHER_SITE", "N");
										}
										detailMap.put("STOCK_DETAIL", "Y");
										detailMap.put("MIN_QTY_REQ", String.valueOf(worderDetailBeanObj.getMinReqQty()));

										detailMap.put("BALANCE_QTY",balance+"");
										System.out.println("manohar after potency calculation balance 444["+balance+"] fresh allocation to be done" );
										detailMap.put("PACK_LOT_NO", lotNoIssue);
										detailMap.put("LOC_GROUP", locGroup);
										
										Map<String,String>detailStkMap =  checkCurrentSiteStock(detailMap, conn,campgnNo);
										System.out.println("detailStkMap C.Potency-------->>["+detailStkMap+"]");
										//added by azhar[START][24-APR-2017]for checking other site if initially allocation is only from current site
										isReallocation = false;
										ArrayList<String> testList = new ArrayList<String>();
										if("N".equalsIgnoreCase(detailMap.get("OTHER_SITE")) && !(isSufficient)){
											
											sql = "select site_code__supp,trans_tran from site_repl_pref where site_code = ? order by pref_order ";
											pstmt = conn.prepareStatement(sql);
											pstmt.setString(1, detailMap.get("SITE_CODE"));
											rs = pstmt.executeQuery();
											while(rs.next()){
												testList.add(rs.getString("site_code__supp"));
												transTranMap.put(detailMap.get("SITE_CODE")+":"+checkNull(rs.getString("site_code__supp")), checkNull(rs.getString("trans_tran"))) ;
											}
											rs.close();
											rs = null;
											pstmt.close();
											pstmt = null;
											for (String siteCodeOther : testList) {
												
											detailMap.put("USE_INV_STATUS", worderDetailBeanObj.getUseInvStatus());
											detailMap.put("SUPP_CODE_MFG", worderDetailBeanObj.getSuppCodeMfg());
											detailMap.put("DIMENSION", worderDetailBeanObj.getDimension());
											detailMap.put("MIN_POTENCY_PERC", String.valueOf(worderDetailBeanObj.getMinPotencyPerc()) );
											detailMap.put("EXP_LEV", worderDetailBeanObj.getExpLev());
											detailMap.put("OPERATION", ""+worderDetailBeanObj.getOperation());
											detailMap.put("CRIT_ITEM", worderDetailBeanObj.getCritItem());
											detailMap.put("ITEM_REF", worderDetailBeanObj.getItemRef());
											detailMap.put("BOM_CODE", worderDetailBeanObj.getBomCode());
											detailMap.put("ITEM_CODE", worderDetailBeanObj.getItemCode());
											detailMap.put("QUANTITY", String.valueOf(worderDetailBeanObj.getQuantity()));
											detailMap.put("SITE_CODE", siteCodeOther);
											detailMap.put("SITE_CODE__SHIP", worderDetailBeanObj.getSiteCode());
											detailMap.put("UNIT", worderDetailBeanObj.getUnit());
											detailMap.put("MATCH_POTENCY", worderDetailBeanObj.getMatchPotency());
											detailMap.put("ADJ_POTENCY", worderDetailBeanObj.getAdjPotency());
											detailMap.put("USAGE_TYPE", worderDetailBeanObj.getUsageType());
											detailMap.put("CONSIDER_LOTNO_ISSUE", worderDetailBeanObj.getConsiderLotNoIssue());
											detailMap.put("LOC_USAGE_TYPE", worderDetailBeanObj.getLocUsageType());
											detailMap.put("WORK_ORDER", worderDetailBeanObj.getWorkOrder());
											detailMap.put("ITEM_ACTIVE", worderDetailBeanObj.getItemActive());
											detailMap.put("ALLOCATE_TYPE", worderDetailBeanObj.getAllocateType());
											detailMap.put("ITEM_CATEGORY", worderDetailBeanObj.getItemCategory());
											detailMap.put("IS_ALTERNATE", "N");
											detailMap.put("OTHER_SITE", "Y");
											detailMap.put("STOCK_DETAIL", "Y");
											detailMap.put("MIN_QTY_REQ", String.valueOf(worderDetailBeanObj.getMinReqQty()));
											detailMap.put("BALANCE_QTY",balance+"");
											detailMap.put("PACK_LOT_NO", lotNoIssue);
											detailMap.put("LOC_GROUP", locGroup);
											detailStkMap =  checkCurrentSiteStock(detailMap, conn,campgnNo);
											System.out.println("detailStkMap after checking other site["+detailStkMap+"]");
											isSufficient = Boolean.parseBoolean(detailStkMap.get("IS_SUFFICIENT"));
											if(isSufficient){
												break;
											}
										}
										}
										//added by azhar[END][24-APR-2017]for checking other site if initially allocation is only from current site
											
											isSufficient = Boolean.parseBoolean(detailStkMap.get("IS_SUFFICIENT"));
											if (isSufficient)
											{
												worderStkBeanObj.setStockSufficient("Y");
												worderExpLevSufficient.put(worderStkBeanObj.getWorkOrder()+":"+worderStkBeanObj.getExpLevel(), true);
												updateWoBeanSufficient(worderStkBeanObj.getWorkOrder(), worderStkBeanObj.getExpLevel(), "Y");
											}
											else
											{
												worderStkBeanObj.setStockSufficient("N");
												worderExpLevSufficient.put(worderStkBeanObj.getWorkOrder()+":"+worderStkBeanObj.getExpLevel(), false);
												updateWoBeanSufficient(worderStkBeanObj.getWorkOrder(), worderStkBeanObj.getExpLevel(), "N");
											}

											for(WorderStkBean tempStkObj : tempWorderExpStkBeanList)
											{
												worderStkBeanListTemp.add(tempStkObj);
											}
											tempWorderExpStkBeanList.clear();
											isReallocation = false; // 09-mar-16 manoharan to reset the flag
										}
									 else
									 {
										 System.out.println("Calling deallocate stock");
									 }

								 }//End if match potency Y
								 else
								 {
									 System.out.println(" N adjPotency----->>["+adjPotency+"] ["+availableStock+"]");
									 System.out.println("Same wo/expLev(N) worderStkBeanObj->workOrder["+worderStkBeanObj.getWorkOrder()+"] expLevel ["+worderStkBeanObj.getExpLevel()+"]ItemCode["+worderStkBeanObj.getItemCode()+"]LotNo["+worderStkBeanObj.getLotNo()+"]LotSl["+worderStkBeanObj.getLotSl()+"]LocCode["+worderStkBeanObj.getLocCode()+"]SiteCode["+worderStkBeanObj.getSiteCode()+"]AllocQty["+worderStkBeanObj.getAllocQty()+"]Stock Quantity["+worderStkBeanObj.getStkQuantity()+"]getQuantity["+worderStkBeanObj.getQuantity()+"]PotencyAdj["+worderStkBeanObj.getPotencyAdj()+"] Qty Adj["+worderStkBeanObj.getQtyAdj()+"]UpdQty["+worderStkBeanObj.getUpdQty()+"] Stock Sufficient["+worderStkBeanObj.getStockSufficient()+"]getCritItem["+worderStkBeanObj.getCritItem()+"]MinReqQty["+worderStkBeanObj.getMinQtyReq()+"]StockPotencyPerc["+worderStkBeanObj.getStkPotencyPerc()+"]OtherSiteYN["+worderStkBeanObj.getOtherSiteYN()+"]getAlternate["+worderStkBeanObj.getAlternate()+"]  MfgDate["+worderStkBeanObj.getMfgDate()+"]ExpDate["+worderStkBeanObj.getExpDate()+"] SiteCodeMfg["+worderStkBeanObj.getSiteCodeMfg()+"]ReserveLineNo["+worderStkBeanObj.getReserveLineNo()+"]ReserveStkTranId["+worderStkBeanObj.getReserveStkTranId()+"]Unit["+worderStkBeanObj.getUnit()+"]");
									 if(adjPotency != null && adjPotency.trim().length() > 0)
									 {
										System.out.println("Potency to be adjusted [" + adjPotency + "]");
										unitPotency = getColumnDescr(conn, "unit__potency", "bom", "bom_code", worderDetailBeanObj.getBomCode(),campgnNo);
										//if (!worderStkBeanObj.getUnit().trim().equals(unitPotency.trim())) // 09-mar-16 manoharan check unit are same, if so no conversion required
										//{
										//	requiredStock = disCommon.convQtyFactor(worderStkBeanObj.getUnit(), unitPotency, worderStkBeanObj.getItemCode(), requiredStock, conn);
										//}
										//System.out.println("RequiredStock After--->>["+requiredStock+"]");
										qtyPotencyUnit = 0;
										if (!worderStkBeanObj.getUnit().trim().equals(unitPotency.trim())) // 09-mar-16 manoharan check unit are same, if so no conversion required
										{
										  //Changed by wasim on 18-05-2016 	
										 //qtyPotencyUnit = disCommon.convQtyFactor(worderStkBeanObj.getUnit(), unitPotency, worderStkBeanObj.getItemCode(), worderDetailBeanObj.getQuantity(), conn);
										   qtyPotencyUnit = disCommon.convQtyFactor(worderStkBeanObj.getUnit(), unitPotency, worderStkBeanObj.getItemCode(), requiredStock, conn);
										}
										else // 19-may-16 manoharan this else condition added
										{
											qtyPotencyUnit = requiredStock;
										}
										qtyPotencyUnit = Double.parseDouble(df.format(qtyPotencyUnit));
										System.out.println("manohar qtyPotencyUnit before[" + qtyPotencyUnit + "] worderStkBeanObj.getAllocQty() [" + worderStkBeanObj.getAllocQty() + "]");
										System.out.println("Stk qty After--->>["+worderStkBeanObj.getStkQuantity()+"]");
										System.out.println("Work Order Bean Quantity="+worderDetailBeanObj.getQuantity());
										// 19-May-16 manoharan if there are multiple for same exp_lev then add
										//AdjPotencyExplevQtyMap.put(adjPotency+":"+expLevel, requiredStock);
										System.out.println("AdjPotencyExplevQtyMap before ["+AdjPotencyExplevQtyMap + "]");
										System.out.println("manohar qtyPotencyUnit after[" + qtyPotencyUnit + "] potencyAdjMapN before [" + potencyAdjMapN + "]");
										if(!AdjPotencyExplevQtyMap.containsKey(adjPotency+":"+expLevel))
										{
											AdjPotencyExplevQtyMap.put(adjPotency+":"+expLevel,  qtyPotencyUnit );
											if(potencyAdjMapN.containsKey(adjPotency))
											{
											
												potencyAdjMapN.put(adjPotency, Double.parseDouble(df.format((potencyAdjMapN.get(adjPotency) + qtyPotencyUnit ))));
											}
											else
											{
												potencyAdjMapN.put(adjPotency,  qtyPotencyUnit );
											}
											
										}
										System.out.println("AdjPotencyExplevQtyMap after [ "+AdjPotencyExplevQtyMap + "]");
										System.out.println("manohar qtyPotencyUnit after[" + qtyPotencyUnit + "] potencyAdjMapN after [" + potencyAdjMapN + "]");
										 // end 19-May-16 manoharan if there are multiple for same exp_lev then add
										//qtyPotencyUnit = qtyPotencyUnit + worderStkBeanObj.getAllocQty();

									 }
									 else
									 {
										 System.out.println("In else of adj_potency null1.................."+requiredStock+"  and avalable stock "+availableStock);
										 //directly set upd qty as bill qty
										 
										 //worderStkBeanObj.setAllocQty(requiredStock);
										 //worderStkBeanObj.setUpdQty(requiredStock);
										 //worderStkBeanList.set(index, worderStkBeanObj); // 09-mar-16 manoharan commented
										 //worderStkBeanList.set(innerCtr, worderStkBeanObj); // 09-mar-16 manoharan added
									 }

								 }

							 }

						 }//end inner for loop
						 // 09-mar-16 manoharan not required
						 //if(!isReallocation)
						 //{
						 //	 break;
						 //}
					 //} //End while true 09-mar-16 manoharan not required

					/*worderDetailBeanObj.setUpdQty(potencyAdjMapY.get(worderDetailBeanObj.getAdjPotency()));
					workOrderBeanList.set(count, worderDetailBeanObj);*/
					System.out.println("AdjustedQty contion.......");
					if(potencyAdjMapY.containsKey(adjPotency) && potencyAdjMapN.containsKey(adjPotency))
					{
						System.out.println("AdjustedQty contion1.......");
					}

				}//end main for

				if(worderStkBeanListTemp.size() > 0)
				{
					for(WorderStkBean tempStkObj : worderStkBeanListTemp)
					{
						// 09-mar-16 manoharan check whether same key exists of so add to existing
						System.out.println("manohar before adding templist  getAllocQty [" + tempStkObj.getAllocQty()+ "] potencyadj [" + tempStkObj.getPotencyAdj() + "]" );
						foundIndex = -1;
						foundIndex = indexOfWorkorderStkList(tempStkObj.getWorkOrder(), tempStkObj.getExpLevel(),tempStkObj.getItemCode(),tempStkObj.getLocCode(),tempStkObj.getSiteCode(),tempStkObj.getLotNo(),tempStkObj.getLotSl());
						if (foundIndex > -1) // already exists add alloc_qty and petencyadj to existing
						{
							System.out.println("manohar before templist merge " );
							worderStkBeanObj = (WorderStkBean) worderStkBeanList.get(foundIndex);
							System.out.println("manohar before templist merge .getExpLevel [" + worderStkBeanObj.getExpLevel() +"] .setQuantity ["+worderStkBeanObj.getQuantity()+"] .setAllocQty [" + worderStkBeanObj.getAllocQty() + "] .setUpdQty [" + worderStkBeanObj.getUpdQty() + "] .setPotencyAdj( [" +worderStkBeanObj.getPotencyAdj() + "] .setQtyAdj(" + worderStkBeanObj.getQtyAdj() + "]" );
							worderStkBeanObj.setAllocQty(Double.parseDouble(df.format(worderStkBeanObj.getAllocQty() + tempStkObj.getAllocQty())));
							worderStkBeanObj.setPotencyAdj(Double.parseDouble(df.format(worderStkBeanObj.getPotencyAdj() + tempStkObj.getPotencyAdj())));
							worderStkBeanObj.setQtyAdj(Double.parseDouble(df.format(worderStkBeanObj.getQtyAdj() + tempStkObj.getQtyAdj())));
							worderStkBeanObj.setUpdQty(Double.parseDouble(df.format(worderStkBeanObj.getUpdQty() + tempStkObj.getUpdQty())));
							System.out.println("worderStkBeanObj["+worderStkBeanObj+"]");
							worderStkBeanList.set(foundIndex,worderStkBeanObj);
							System.out.println("manohar after  templist merge .getExpLevel [" + worderStkBeanObj.getExpLevel() +"] .setQuantity ["+worderStkBeanObj.getQuantity()+"] .setAllocQty [" + worderStkBeanObj.getAllocQty() + "] .setUpdQty [" + worderStkBeanObj.getUpdQty() + "] .setPotencyAdj( [" +worderStkBeanObj.getPotencyAdj() + "] .setQtyAdj(" + worderStkBeanObj.getQtyAdj() + "]" );

						}
						else
						{
							System.out.println("tempStkObj["+tempStkObj+"]");
							worderStkBeanList.add(tempStkObj);// not exists add
						}
					}
					worderStkBeanListTemp.clear();
				}

				System.out.println("potencyAdjMapY---------->>["+potencyAdjMapY+"]");
				System.out.println("AdjPotencyExplevQtyMap-->>["+AdjPotencyExplevQtyMap+"]");
				System.out.println("potencyAdjMapN---------->>["+potencyAdjMapN+"]");
				System.out.println("worderStkBeanList------->>["+worderStkBeanList.size()+"]");
				//int indexN = -1;// 09-mar-16 manoharan commented for index based
				//shortageQty = 0;
				for(Map.Entry<String,Double> entry : potencyAdjMapY.entrySet())
				{
					adjPotencyChkY = entry.getKey();
					potencyAdjNew = -1 * (entry.getValue());
					
					System.out.println("adjPotencyChkY ["+adjPotencyChkY+"] potencyAdjNew ["+potencyAdjNew + "]");
					
					if(potencyAdjMapN.containsKey(adjPotencyChkY))
					{
						//AdjPotencyExplevQtyMap
						adjPotencyChkN = "";
						for(Map.Entry<String,Double> adjPotencyExpLevel : AdjPotencyExplevQtyMap.entrySet())
						{
							String splitKey []  = adjPotencyExpLevel.getKey().split(":");
							// 19-may-16 manoharan there cn be many different adjPotency in AdjPotencyExplevQtyMap
							// if the current adjPotency not matching with adjPotencyChkY
							adjPotencyChkN = splitKey [0];
							if (!adjPotencyChkN.trim().equals(adjPotencyChkY.trim()))
							{
								continue;
							}
							expLevelNew = splitKey [1];
							System.out.println("expLevelNew---------->>["+expLevelNew+"]");
							
							System.out.println("potencyAdjNew--------->>["+potencyAdjNew+"]");//-93.733
							System.out.println("adjPotencyExpLevel.getValue()--------->>["+adjPotencyExpLevel.getValue()+"]");//
							System.out.println("potencyAdjMapN--------->>["+potencyAdjMapN.get(adjPotencyChkY)+"]");//
							potencyAdjExpLev = potencyAdjNew * adjPotencyExpLevel.getValue() / potencyAdjMapN.get(adjPotencyChkY) ;
							potencyAdjExpLev = Double.parseDouble(df.format(potencyAdjExpLev));
							System.out.println("potencyAdjExpLev---------->>["+potencyAdjExpLev+"]");//-93.733
							quantityReqExpLev = adjPotencyExpLevel.getValue() + potencyAdjExpLev;//56.366
							quantityReqExpLev = Double.parseDouble(df.format(quantityReqExpLev));//38.477
							
							System.out.println("quantityReqExpLev---before ["+quantityReqExpLev+"]");
							//AdjPotencyExplevQtyMap.put(adjPotencyChkN+":"+expLevelNew,  quantityReqExpLev ); // 06-jun-16 manoharan reassign value as per actual allocation
							//adjPotencyExpLevel.setValue(quantityReqExpLev); // 06-jun-16 manoharan reassign value as per actual allocation
							// 23-jun-16 manoharan if critical item and stock allocated is not sufficient not to deduct
							if (potencyAdjExpLev < 0)
							{
								isSufficient = worderExpLevSufficient.get(workOrder+":"+expLevelNew);
								System.out.println("23-jun-16 manoharan check sufficient to deallocate workOrderPotency ["+workOrder+"] expLevelNew [" + expLevelNew + "] isSufficient [" + isSufficient + "]");
								//int tempIndex = indexOfWorkorderBeanList(workOrderPotency, expLevelNew);
								//worderDetailBeanObj = (WorkOrderDetailBean) workOrderBeanList.get(tempIndex);
								if (isSufficient) 
								{
									extraQty = adjPotencyExpLevel.getValue() - quantityReqExpLev;
									extraQty = Double.parseDouble(df.format(extraQty));
								}
								else
								{
									allocatedQty = getAllocatedForExplev(workOrder, expLevelNew,campgnNo);
									if (quantityReqExpLev <=  allocatedQty)
									{
										extraQty = allocatedQty - quantityReqExpLev;
										extraQty = Double.parseDouble(df.format(extraQty));
									}
									
								}
								System.out.println("allocated stock check sufficient after potency adjustment [" + workOrder+ "] expLevelNew [" + expLevelNew+"] extraQty [" + extraQty+ "]");
								if (extraQty > 0)
								{
								
									// Extra allocation done to be deallocated
									// 1. deallocate the extra quantity then proportionally recalculate potencyAdj and update
									int stockListSize = worderStkBeanList.size() -1;
									
									
									System.out.println("Deallocate stockListSize [" + stockListSize + "] ExpLev [" + expLevelNew+"] quantity["+ adjPotencyExpLevel.getValue() + "] quantityReqExpLev ["+quantityReqExpLev+"] extraQty [" + extraQty + "]");
									for(int potencyCtr =  stockListSize; potencyCtr > 0 ; potencyCtr--)
									{
										worderStkBeanObj = (WorderStkBean) worderStkBeanList.get(potencyCtr);
										System.out.println("20-May-16 In deallocate stockListSize  ["+stockListSize + "] potencyCtr [" + potencyCtr + "]");
										
										if(workOrder.trim().equalsIgnoreCase(worderStkBeanObj.getWorkOrder().trim()) && expLevelNew.trim().equalsIgnoreCase(worderStkBeanObj.getExpLevel().trim()))
										{
											if (extraQty <= 0)
											{
												worderExpLevSufficient.put(worderStkBeanObj.getWorkOrder()+":"+worderStkBeanObj.getExpLevel(), true);
												updateWoBeanSufficient(worderStkBeanObj.getWorkOrder(), worderStkBeanObj.getExpLevel(), "Y");
												break;
											}
											removeElement = false;
											allocatedQty = worderStkBeanObj.getAllocQty();
											System.out.println("Same wo/expLev(N) deallocate worderStkBeanObj->workOrder["+worderStkBeanObj.getWorkOrder()+"] expLevel ["+worderStkBeanObj.getExpLevel()+"]ItemCode["+worderStkBeanObj.getItemCode()+"]LotNo["+worderStkBeanObj.getLotNo()+"]LotSl["+worderStkBeanObj.getLotSl()+"]LocCode["+worderStkBeanObj.getLocCode()+"]SiteCode["+worderStkBeanObj.getSiteCode()+"]AllocQty["+worderStkBeanObj.getAllocQty()+"]Stock Quantity["+worderStkBeanObj.getStkQuantity()+"]getQuantity["+worderStkBeanObj.getQuantity()+"]PotencyAdj["+worderStkBeanObj.getPotencyAdj()+"] Qty Adj["+worderStkBeanObj.getQtyAdj()+"]UpdQty["+worderStkBeanObj.getUpdQty()+"] Stock Sufficient["+worderStkBeanObj.getStockSufficient()+"]getCritItem["+worderStkBeanObj.getCritItem()+"]MinReqQty["+worderStkBeanObj.getMinQtyReq()+"]StockPotencyPerc["+worderStkBeanObj.getStkPotencyPerc()+"]OtherSiteYN["+worderStkBeanObj.getOtherSiteYN()+"]getAlternate["+worderStkBeanObj.getAlternate()+"]  MfgDate["+worderStkBeanObj.getMfgDate()+"]ExpDate["+worderStkBeanObj.getExpDate()+"] SiteCodeMfg["+worderStkBeanObj.getSiteCodeMfg()+"]ReserveLineNo["+worderStkBeanObj.getReserveLineNo()+"]ReserveStkTranId["+worderStkBeanObj.getReserveStkTranId()+"]Unit["+worderStkBeanObj.getUnit()+"]");
											// check allocated quantity >= extra quantity and deallocate accordingly
											if (allocatedQty <= extraQty )
											{
												deallocQty = allocatedQty;
												extraQty -= allocatedQty;
												removeElement = true;
											}
											else
											{
												deallocQty = extraQty;
												extraQty = 0;
											}
											
											stockAllocMap.put("ALLOC_QTY",""+ (deallocQty * -1));
											stockAllocMap.put("LOC_CODE", worderStkBeanObj.getLocCode());
											stockAllocMap.put("ITEM_CODE",worderStkBeanObj.getItemCode());
											stockAllocMap.put("SITE_CODE",worderStkBeanObj.getSiteCode());
											stockAllocMap.put("LOT_NO",worderStkBeanObj.getLotNo());
											stockAllocMap.put("LOT_SL",worderStkBeanObj.getLotSl());
											// 09-mar-16 manoharan - what will the string returned??????????
											//allocRetStr = updateStockAllocQty(stockAllocMap,conn,campgnNo);
											
											if("Y".equalsIgnoreCase(worderStkBeanObj.getCritItem())){
												System.out.println("check potency allocation");
											allocRetStr = updateStockAllocQty(stockAllocMap,conn,campgnNo);
											}
											
											System.out.println("After update stock ["+allocRetStr + "]") ;
											if (removeElement)
											{
												worderStkBeanList.remove(potencyCtr);
											}
											else
											{
												worderStkBeanObj.setUpdQty(Double.parseDouble(df.format(worderStkBeanObj.getAllocQty() - deallocQty)));
												worderStkBeanObj.setAllocQty(Double.parseDouble(df.format(worderStkBeanObj.getAllocQty() - deallocQty)));
												worderStkBeanList.set(potencyCtr, worderStkBeanObj);
												System.out.println("Same wo/expLev(N) after deallocate worderStkBeanObj->workOrder["+worderStkBeanObj.getWorkOrder()+"] expLevel ["+worderStkBeanObj.getExpLevel()+"]ItemCode["+worderStkBeanObj.getItemCode()+"]LotNo["+worderStkBeanObj.getLotNo()+"]LotSl["+worderStkBeanObj.getLotSl()+"]LocCode["+worderStkBeanObj.getLocCode()+"]SiteCode["+worderStkBeanObj.getSiteCode()+"]AllocQty["+worderStkBeanObj.getAllocQty()+"]Stock Quantity["+worderStkBeanObj.getStkQuantity()+"]getQuantity["+worderStkBeanObj.getQuantity()+"]PotencyAdj["+worderStkBeanObj.getPotencyAdj()+"] Qty Adj["+worderStkBeanObj.getQtyAdj()+"]UpdQty["+worderStkBeanObj.getUpdQty()+"] Stock Sufficient["+worderStkBeanObj.getStockSufficient()+"]getCritItem["+worderStkBeanObj.getCritItem()+"]MinReqQty["+worderStkBeanObj.getMinQtyReq()+"]StockPotencyPerc["+worderStkBeanObj.getStkPotencyPerc()+"]OtherSiteYN["+worderStkBeanObj.getOtherSiteYN()+"]getAlternate["+worderStkBeanObj.getAlternate()+"]  MfgDate["+worderStkBeanObj.getMfgDate()+"]ExpDate["+worderStkBeanObj.getExpDate()+"] SiteCodeMfg["+worderStkBeanObj.getSiteCodeMfg()+"]ReserveLineNo["+worderStkBeanObj.getReserveLineNo()+"]ReserveStkTranId["+worderStkBeanObj.getReserveStkTranId()+"]Unit["+worderStkBeanObj.getUnit()+"]");
											}
											// 02-jun-16 manoharan
											worderExpLevSufficient.put(worderStkBeanObj.getWorkOrder()+":"+worderStkBeanObj.getExpLevel(), true);
											updateWoBeanSufficient(worderStkBeanObj.getWorkOrder(), worderStkBeanObj.getExpLevel(), "Y");

										}
									}
									
									// 2. proportionally recalculate potencyAdj and update
									
									for(int potencyCtr = 0; potencyCtr < worderStkBeanList.size(); potencyCtr++)
									{
										worderStkBeanObj = (WorderStkBean) worderStkBeanList.get(potencyCtr);
										if(workOrder.trim().equalsIgnoreCase(worderStkBeanObj.getWorkOrder().trim()) && expLevelNew.trim().equalsIgnoreCase(worderStkBeanObj.getExpLevel().trim()))
										{
											allocatedQty = worderStkBeanObj.getAllocQty();
											//                  -13.015                   34.988                   34.988
											System.out.println("Adjustment  expLevel ["+worderStkBeanObj.getExpLevel()+"] AllocQty["+worderStkBeanObj.getAllocQty()+"] potencyAdjExpLev [" + potencyAdjExpLev+ "] .getValue() [" + adjPotencyExpLevel.getValue() + "] quantityReqExpLev[" + quantityReqExpLev + "]" );
											//potencyAdjLot = potencyAdjExpLev / adjPotencyExpLevel.getValue() * allocatedQty;
											potencyAdjLot = potencyAdjExpLev / quantityReqExpLev * allocatedQty;
											
											potencyAdjLot = Double.parseDouble(df.format(potencyAdjLot));
											quantityReqLot = allocatedQty - potencyAdjLot;
											quantityReqLot = Double.parseDouble(df.format(quantityReqLot));
											System.out.println("Same wo/expLev(N) before recalculate worderStkBeanObj->workOrder["+worderStkBeanObj.getWorkOrder()+"] expLevel ["+worderStkBeanObj.getExpLevel()+"]ItemCode["+worderStkBeanObj.getItemCode()+"]LotNo["+worderStkBeanObj.getLotNo()+"]LotSl["+worderStkBeanObj.getLotSl()+"]LocCode["+worderStkBeanObj.getLocCode()+"]SiteCode["+worderStkBeanObj.getSiteCode()+"]AllocQty["+worderStkBeanObj.getAllocQty()+"]Stock Quantity["+worderStkBeanObj.getStkQuantity()+"]getQuantity["+worderStkBeanObj.getQuantity()+"]PotencyAdj["+worderStkBeanObj.getPotencyAdj()+"] Qty Adj["+worderStkBeanObj.getQtyAdj()+"]UpdQty["+worderStkBeanObj.getUpdQty()+"] Stock Sufficient["+worderStkBeanObj.getStockSufficient()+"]getCritItem["+worderStkBeanObj.getCritItem()+"]MinReqQty["+worderStkBeanObj.getMinQtyReq()+"]StockPotencyPerc["+worderStkBeanObj.getStkPotencyPerc()+"]OtherSiteYN["+worderStkBeanObj.getOtherSiteYN()+"]getAlternate["+worderStkBeanObj.getAlternate()+"]  MfgDate["+worderStkBeanObj.getMfgDate()+"]ExpDate["+worderStkBeanObj.getExpDate()+"] SiteCodeMfg["+worderStkBeanObj.getSiteCodeMfg()+"]ReserveLineNo["+worderStkBeanObj.getReserveLineNo()+"]ReserveStkTranId["+worderStkBeanObj.getReserveStkTranId()+"]Unit["+worderStkBeanObj.getUnit()+"]");
											worderStkBeanObj.setQtyAdj(potencyAdjLot);
											worderStkBeanObj.setPotencyAdj(potencyAdjLot);
											worderStkBeanObj.setQuantity(quantityReqLot);
											//worderStkBeanObj.setUpdQty(quantityReqLot);
											//worderStkBeanObj.setAllocQty(quantityReqLot);
											System.out.println("Same wo/expLev(N) after recalculate worderStkBeanObj->workOrder["+worderStkBeanObj.getWorkOrder()+"] expLevel ["+worderStkBeanObj.getExpLevel()+"]ItemCode["+worderStkBeanObj.getItemCode()+"]LotNo["+worderStkBeanObj.getLotNo()+"]LotSl["+worderStkBeanObj.getLotSl()+"]LocCode["+worderStkBeanObj.getLocCode()+"]SiteCode["+worderStkBeanObj.getSiteCode()+"]AllocQty["+worderStkBeanObj.getAllocQty()+"]Stock Quantity["+worderStkBeanObj.getStkQuantity()+"]getQuantity["+worderStkBeanObj.getQuantity()+"]PotencyAdj["+worderStkBeanObj.getPotencyAdj()+"] Qty Adj["+worderStkBeanObj.getQtyAdj()+"]UpdQty["+worderStkBeanObj.getUpdQty()+"] Stock Sufficient["+worderStkBeanObj.getStockSufficient()+"]getCritItem["+worderStkBeanObj.getCritItem()+"]MinReqQty["+worderStkBeanObj.getMinQtyReq()+"]StockPotencyPerc["+worderStkBeanObj.getStkPotencyPerc()+"]OtherSiteYN["+worderStkBeanObj.getOtherSiteYN()+"]getAlternate["+worderStkBeanObj.getAlternate()+"]  MfgDate["+worderStkBeanObj.getMfgDate()+"]ExpDate["+worderStkBeanObj.getExpDate()+"] SiteCodeMfg["+worderStkBeanObj.getSiteCodeMfg()+"]ReserveLineNo["+worderStkBeanObj.getReserveLineNo()+"]ReserveStkTranId["+worderStkBeanObj.getReserveStkTranId()+"]Unit["+worderStkBeanObj.getUnit()+"]");
											worderStkBeanList.set(potencyCtr, worderStkBeanObj);// 09-mar-16 manoharan added for index based
										}
									}
								}
								//else
								//{
								//	System.out.println("allocated stock is sufficient after potency adjustment [" + workOrderPotency+ "] expLevelNew [" + expLevelNew+"]");
								//	worderExpLevSufficient.put(workOrderPotency+":"+expLevelNew, true);
								//	updateWoBeanSufficient(workOrderPotency, expLevelNew, "Y");
								//	
								//}
							}
							else
							{
								// additional stock to be allocated
								// 1. Allocate additional stock to the extend of potencyAdj
								foundIndex = indexOfWorkorderBeanList(worderStkBeanObj.getWorkOrder(),worderStkBeanObj.getExpLevel());
								worderDetailBeanObj = workOrderBeanList.get(foundIndex);

								HashMap<String,String> detailMap = new HashMap<String,String>();
								detailMap.put("USE_INV_STATUS", worderDetailBeanObj.getUseInvStatus());
								detailMap.put("SUPP_CODE_MFG", worderDetailBeanObj.getSuppCodeMfg());
								detailMap.put("DIMENSION", worderDetailBeanObj.getDimension());
								detailMap.put("MIN_POTENCY_PERC", String.valueOf(worderDetailBeanObj.getMinPotencyPerc()) );

								detailMap.put("EXP_LEV", worderDetailBeanObj.getExpLev());
								detailMap.put("OPERATION", ""+worderDetailBeanObj.getOperation());
								detailMap.put("CRIT_ITEM", worderDetailBeanObj.getCritItem());
								detailMap.put("ITEM_REF", worderDetailBeanObj.getItemRef());
								detailMap.put("BOM_CODE", worderDetailBeanObj.getBomCode());
								detailMap.put("ITEM_CODE", worderDetailBeanObj.getItemCode());
								detailMap.put("QUANTITY", String.valueOf(potencyAdjExpLev));
								detailMap.put("SITE_CODE", worderStkBeanObj.getSiteCode());//wasim
								detailMap.put("UNIT", worderDetailBeanObj.getUnit());
								detailMap.put("MATCH_POTENCY", worderDetailBeanObj.getMatchPotency());
								detailMap.put("ADJ_POTENCY", worderDetailBeanObj.getAdjPotency());
								detailMap.put("USAGE_TYPE", worderDetailBeanObj.getUsageType());
								detailMap.put("MIN_QTY_REQ", String.valueOf(worderDetailBeanObj.getMinReqQty()));
								detailMap.put("CONSIDER_LOTNO_ISSUE", worderDetailBeanObj.getConsiderLotNoIssue());
								detailMap.put("LOC_USAGE_TYPE", worderDetailBeanObj.getLocUsageType());
								detailMap.put("WORK_ORDER", worderDetailBeanObj.getWorkOrder());
								detailMap.put("ITEM_ACTIVE", worderDetailBeanObj.getItemActive());
								detailMap.put("ALLOCATE_TYPE", worderDetailBeanObj.getAllocateType());
								detailMap.put("ITEM_CATEGORY", worderDetailBeanObj.getItemCategory());
								detailMap.put("IS_ALTERNATE", "N");
								if("Y".equalsIgnoreCase(worderStkBeanObj.getOtherSiteYN()))
								{
									detailMap.put("OTHER_SITE", "Y");
								}
								else
								{
								 detailMap.put("OTHER_SITE", "N");
								}
								detailMap.put("STOCK_DETAIL", "Y");
								detailMap.put("MIN_QTY_REQ", String.valueOf(worderDetailBeanObj.getMinReqQty()));

								detailMap.put("BALANCE_QTY","0");
								isReallocation = true; // 09-mar-16 manoharan reallocation templist to be populated
								//checkCurrentSiteStock(detailMap,conn);  // 09-mar-16 manoharan commented return value to be captured and checked
								detailMap.put("PACK_LOT_NO", lotNoIssue);
								detailMap.put("LOC_GROUP", locGroup);
								
								Map<String,String>detailStkMap = checkCurrentSiteStock(detailMap,conn,campgnNo);  // 09-mar-16 manoharan return value to be captured and checked

								isSufficient = Boolean.parseBoolean(detailStkMap.get("IS_SUFFICIENT"));
								if(isSufficient)
								{
										//worderStkBeanObj.setStockSufficient("N");
										worderExpLevSufficient.put(worderDetailBeanObj.getWorkOrder()+":"+worderDetailBeanObj.getExpLev(), true);
										updateWoBeanSufficient(worderDetailBeanObj.getWorkOrder(), worderDetailBeanObj.getExpLev(), "Y");
								}
								else
								{
										//worderStkBeanObj.setStockSufficient("N");
										worderExpLevSufficient.put(worderDetailBeanObj.getWorkOrder()+":"+worderDetailBeanObj.getExpLev(), false);
										updateWoBeanSufficient(worderDetailBeanObj.getWorkOrder(), worderDetailBeanObj.getExpLev(), "N");
								}
								for(WorderStkBean tempStkObj : tempWorderExpStkBeanList)
								{
									worderStkBeanListTemp.add(tempStkObj);
								}
								tempWorderExpStkBeanList.clear();
								isReallocation = false; // 09-mar-16 manoharan to reset the flag

								
								// 2. adjust potencyAdj proportionately
								for(int potencyCtr=0 ; potencyCtr < worderStkBeanList.size(); potencyCtr++)
								{
									worderStkBeanObj = (WorderStkBean) worderStkBeanList.get(potencyCtr);
									if(workOrder.trim().equalsIgnoreCase(worderStkBeanObj.getWorkOrder().trim()) && expLevelNew.trim().equalsIgnoreCase(worderStkBeanObj.getExpLevel().trim()))
									{
										allocatedQty = worderStkBeanObj.getQuantity();
										potencyAdjLot = potencyAdjExpLev / adjPotencyExpLevel.getValue() * allocatedQty;
										potencyAdjLot = Double.parseDouble(df.format(potencyAdjLot));
										quantityReqLot = allocatedQty - potencyAdjLot;
										quantityReqLot = Double.parseDouble(df.format(quantityReqLot));
										System.out.println("Same wo/expLev(N) before recalculate worderStkBeanObj->workOrder["+worderStkBeanObj.getWorkOrder()+"] expLevel ["+worderStkBeanObj.getExpLevel()+"]ItemCode["+worderStkBeanObj.getItemCode()+"]LotNo["+worderStkBeanObj.getLotNo()+"]LotSl["+worderStkBeanObj.getLotSl()+"]LocCode["+worderStkBeanObj.getLocCode()+"]SiteCode["+worderStkBeanObj.getSiteCode()+"]AllocQty["+worderStkBeanObj.getAllocQty()+"]Stock Quantity["+worderStkBeanObj.getStkQuantity()+"]getQuantity["+worderStkBeanObj.getQuantity()+"]PotencyAdj["+worderStkBeanObj.getPotencyAdj()+"] Qty Adj["+worderStkBeanObj.getQtyAdj()+"]UpdQty["+worderStkBeanObj.getUpdQty()+"] Stock Sufficient["+worderStkBeanObj.getStockSufficient()+"]getCritItem["+worderStkBeanObj.getCritItem()+"]MinReqQty["+worderStkBeanObj.getMinQtyReq()+"]StockPotencyPerc["+worderStkBeanObj.getStkPotencyPerc()+"]OtherSiteYN["+worderStkBeanObj.getOtherSiteYN()+"]getAlternate["+worderStkBeanObj.getAlternate()+"]  MfgDate["+worderStkBeanObj.getMfgDate()+"]ExpDate["+worderStkBeanObj.getExpDate()+"] SiteCodeMfg["+worderStkBeanObj.getSiteCodeMfg()+"]ReserveLineNo["+worderStkBeanObj.getReserveLineNo()+"]ReserveStkTranId["+worderStkBeanObj.getReserveStkTranId()+"]Unit["+worderStkBeanObj.getUnit()+"]");
										worderStkBeanObj.setQtyAdj(potencyAdjLot);
										worderStkBeanObj.setPotencyAdj(potencyAdjLot);
										System.out.println("manohar before .setQuantity 5["+worderStkBeanObj.getQuantity()+"]");
										worderStkBeanObj.setQuantity(quantityReqLot);
										System.out.println("manohar after .setQuantity 5["+worderStkBeanObj.getQuantity()+"]");
										worderStkBeanObj.setUpdQty(allocatedQty);
										worderStkBeanObj.setAllocQty(allocatedQty);
										System.out.println("Same wo/expLev(N) after recalculate worderStkBeanObj->workOrder["+worderStkBeanObj.getWorkOrder()+"] expLevel ["+worderStkBeanObj.getExpLevel()+"]ItemCode["+worderStkBeanObj.getItemCode()+"]LotNo["+worderStkBeanObj.getLotNo()+"]LotSl["+worderStkBeanObj.getLotSl()+"]LocCode["+worderStkBeanObj.getLocCode()+"]SiteCode["+worderStkBeanObj.getSiteCode()+"]AllocQty["+worderStkBeanObj.getAllocQty()+"]Stock Quantity["+worderStkBeanObj.getStkQuantity()+"]getQuantity["+worderStkBeanObj.getQuantity()+"]PotencyAdj["+worderStkBeanObj.getPotencyAdj()+"] Qty Adj["+worderStkBeanObj.getQtyAdj()+"]UpdQty["+worderStkBeanObj.getUpdQty()+"] Stock Sufficient["+worderStkBeanObj.getStockSufficient()+"]getCritItem["+worderStkBeanObj.getCritItem()+"]MinReqQty["+worderStkBeanObj.getMinQtyReq()+"]StockPotencyPerc["+worderStkBeanObj.getStkPotencyPerc()+"]OtherSiteYN["+worderStkBeanObj.getOtherSiteYN()+"]getAlternate["+worderStkBeanObj.getAlternate()+"]  MfgDate["+worderStkBeanObj.getMfgDate()+"]ExpDate["+worderStkBeanObj.getExpDate()+"] SiteCodeMfg["+worderStkBeanObj.getSiteCodeMfg()+"]ReserveLineNo["+worderStkBeanObj.getReserveLineNo()+"]ReserveStkTranId["+worderStkBeanObj.getReserveStkTranId()+"]Unit["+worderStkBeanObj.getUnit()+"]");
										worderStkBeanList.set(potencyCtr, worderStkBeanObj);
									
									}
									
								}
								
							}
						} //end AdjPotencyExplevQtyMap

					} //end potencyAdjMapN contains

				} //end potencyAdjMapY map
				// 09-mar-16 manoharan to update main list with the temporary list
				if(worderStkBeanListTemp.size() > 0)
				{
					for(WorderStkBean tempStkObj : worderStkBeanListTemp)
					{
						// 09-mar-16 manoharan check whether same key exists of so add to existing
						foundIndex = -1;
						foundIndex = indexOfWorkorderStkList(tempStkObj.getWorkOrder(), tempStkObj.getExpLevel(),tempStkObj.getItemCode(),tempStkObj.getLocCode(),tempStkObj.getSiteCode(),tempStkObj.getLotNo(),tempStkObj.getLotSl());
						if (foundIndex > -1) // already exists add alloc_qty and petencyadj to existing
						{
							worderStkBeanObj = (WorderStkBean) worderStkBeanList.get(foundIndex);
							System.out.println("manohar before templist merge 1 .getExpLevel [" + worderStkBeanObj.getExpLevel() +"] .setQuantity ["+worderStkBeanObj.getQuantity()+"] .setAllocQty [" + worderStkBeanObj.getAllocQty() + "] .setUpdQty [" + worderStkBeanObj.getUpdQty() + "] .setPotencyAdj( [" +worderStkBeanObj.getPotencyAdj() + "] .setQtyAdj(" + worderStkBeanObj.getQtyAdj() + "]" );
							worderStkBeanObj.setAllocQty(Double.parseDouble(df.format(worderStkBeanObj.getAllocQty() + tempStkObj.getAllocQty())));
							worderStkBeanObj.setPotencyAdj(Double.parseDouble(df.format(worderStkBeanObj.getPotencyAdj() + tempStkObj.getPotencyAdj())));
							worderStkBeanObj.setQtyAdj(Double.parseDouble(df.format(worderStkBeanObj.getQtyAdj() + tempStkObj.getQtyAdj())));
							worderStkBeanObj.setUpdQty(Double.parseDouble(df.format(worderStkBeanObj.getUpdQty() + tempStkObj.getUpdQty())));
							System.out.println("manohar after  templist merge 1 .getExpLevel [" + worderStkBeanObj.getExpLevel() +"] .setQuantity ["+worderStkBeanObj.getQuantity()+"] .setAllocQty [" + worderStkBeanObj.getAllocQty() + "] .setUpdQty [" + worderStkBeanObj.getUpdQty() + "] .setPotencyAdj( [" +worderStkBeanObj.getPotencyAdj() + "] .setQtyAdj(" + worderStkBeanObj.getQtyAdj() + "]" );
							
							worderStkBeanList.set(foundIndex,worderStkBeanObj);//wasim
						}
						else
						{
							worderStkBeanList.add(tempStkObj);// not exists add
						}
					}
					worderStkBeanListTemp.clear();
				}
				// end 09-mar-16 manoharan to update main list with the temporary list
			} //end work order list commented by azhar[03/Jan/2017] as workorder is passed as parameter and potency allocation should be done for current workorder at that time 
			for(int potencyCtr = 0; potencyCtr < worderStkBeanList.size(); potencyCtr++)
			{
				worderStkBeanObj = (WorderStkBean) worderStkBeanList.get(potencyCtr);
				System.out.println("After potency calculation worderStkBeanObj->workOrder["+worderStkBeanObj.getWorkOrder()+"] expLevel ["+worderStkBeanObj.getExpLevel()+"]ItemCode["+worderStkBeanObj.getItemCode()+"]LotNo["+worderStkBeanObj.getLotNo()+"]LotSl["+worderStkBeanObj.getLotSl()+"]LocCode["+worderStkBeanObj.getLocCode()+"]SiteCode["+worderStkBeanObj.getSiteCode()+"]AllocQty["+worderStkBeanObj.getAllocQty()+"]Stock Quantity["+worderStkBeanObj.getStkQuantity()+"]getQuantity["+worderStkBeanObj.getQuantity()+"]PotencyAdj["+worderStkBeanObj.getPotencyAdj()+"] Qty Adj["+worderStkBeanObj.getQtyAdj()+"]UpdQty["+worderStkBeanObj.getUpdQty()+"] Stock Sufficient["+worderStkBeanObj.getStockSufficient()+"]getCritItem["+worderStkBeanObj.getCritItem()+"]MinReqQty["+worderStkBeanObj.getMinQtyReq()+"]StockPotencyPerc["+worderStkBeanObj.getStkPotencyPerc()+"]OtherSiteYN["+worderStkBeanObj.getOtherSiteYN()+"]getAlternate["+worderStkBeanObj.getAlternate()+"]  MfgDate["+worderStkBeanObj.getMfgDate()+"]ExpDate["+worderStkBeanObj.getExpDate()+"] SiteCodeMfg["+worderStkBeanObj.getSiteCodeMfg()+"]ReserveLineNo["+worderStkBeanObj.getReserveLineNo()+"]ReserveStkTranId["+worderStkBeanObj.getReserveStkTranId()+"]Unit["+worderStkBeanObj.getUnit()+"]");
			}
			System.out.println("After potency calculation worderExpLevSufficient["+worderExpLevSufficient+"]");
			

		}
		catch( Exception e)
		{
			e.printStackTrace();
			writeWorkOrderLog(e.toString(),campgnNo);//TODO
			throw new Exception(e);
		}
		return "";

	}
	private double getAllocatedForExplev(String workOrderPotency, String expLevelNew,String campgnNo) throws ITMException, Exception
	{
		WorderStkBean worderStkBeanObj = null;
		double allocatedQtyExpLev = 0,allocatedQty = 0;
		for(int counter=0 ; counter < worderStkBeanList.size(); counter++)
		{
		
			worderStkBeanObj = (WorderStkBean) worderStkBeanList.get(counter);
			if(workOrderPotency.trim().equalsIgnoreCase(worderStkBeanObj.getWorkOrder().trim()) && expLevelNew.trim().equalsIgnoreCase(worderStkBeanObj.getExpLevel().trim()))
			{
				allocatedQty = worderStkBeanObj.getAllocQty();
				allocatedQtyExpLev += allocatedQty;
			
			}
			
		}
		return allocatedQtyExpLev;
	}
	private String getSqlInString(String suppCodeMfg) throws ITMException, Exception
	{
		String inSql = "";
		String [] sqlSupp = suppCodeMfg.split(",");

		for (int i = 0;i<sqlSupp.length;i++)
		{
			inSql = inSql +"'"+sqlSupp[i]+"',";
		}
		if(inSql.lastIndexOf(",") > -1)
		{
			inSql = inSql.substring(0,inSql.length() - 1);
		}
		System.out.println("inSql : ["+inSql+"]");

		return inSql;
	}

	//Check reserve stock
	//Return map with balance quantity,isSufficient,error code
	@SuppressWarnings({ "rawtypes", "unused" })
	private Map<String,String> checkReserveStock(Map<String,String> worderDetailMap,Connection conn,String campgnNo) throws ITMException, Exception
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null,pstmtUpd = null;
		StringBuffer reserveStkSql = new StringBuffer();
		MfgCommon mfgCommon = new MfgCommon();
		Map<String,String> returnMapDetails = new HashMap<String,String>();
		int reserveLineNo = 0,count = 0;
		boolean isMatchDimension = false,isSufficient = false;
		String sql = "",qcReqd = "",effDate = "",invLocCode = "",invLotNo = "",invLotSl = "",siteCode = "",itemCode = "",
				locUsageType = "",considerLotNoIss ="",trackShelfLife = "",worder = "",locGrp = "",packLotNo = "",dimension = "",
				expLevel = "",itemRef = "",critItem = "",unit = "",errorCode = "",itemDescr = "";
		String mfgItemCode = "",alternate = "",considerPartialAlt = "";
		double reserveStkQty = 0,requiredQty = 0,balanceQty = 0,softAllocQty = 0, stkAvailQuantity = 0,
				stkPotencyPerc = 0,minPotencyPerc = 0 ;
		double minQtyReq = 0; //Changed by wasim on 29-02-2016
		ArrayList<String> invAllocateTranIDList = new ArrayList<String>();
		WorderStkBean worderStkBeanObj = null;
		SiteItemSummaryBean sitebean = null;
		java.sql.Timestamp expDate = null, mfgDate = null;
		try
		{
			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat simpleDateFormatObj = new SimpleDateFormat(genericUtility.getApplDateFormat());
			effDate = simpleDateFormatObj.format(currentDate.getTime());
			System.out.println("In checkReserveStock worderDetailMap : "+worderDetailMap);
			worder = worderDetailMap.get("WORK_ORDER");
			alternate = worderDetailMap.get("IS_ALTERNATE");
			mfgItemCode = getColumnDescr(conn, "item_code", "workorder", "work_order", worder,campgnNo);    //worderDetailMap.get("ITEM_CODE");
			System.out.println("mfgItemCode------------>>"+mfgItemCode);
			siteCode = worderDetailMap.get("SITE_CODE");
			minPotencyPerc = Double.parseDouble(worderDetailMap.get("MIN_POTENCY_PERC"));
			sql = "select tran_id from inv_allocate where site_code = ?  "
					+ "and CASE WHEN status IS NULL THEN 'O' ELSE status END <> 'C' and confirmed = ? " //nvl(status,'O') <> 'C'
					+ "and   (work_order = ? or (length(trim(nvl(?,' '))) = 0 and   item_code = ? )) and nvl(tran_type,'MAN') <> 'AUT' "
					+ "Order By conf_date";
			pstmt = conn.prepareStatement(sql) ;
			pstmt.setString(1, siteCode);
			pstmt.setString(2, "Y");
			pstmt.setString(3, worder);
			pstmt.setString(4, worder);
			pstmt.setString(5, mfgItemCode);
			rs = pstmt.executeQuery();

			while( rs.next() )
			{
				invAllocateTranIDList.add(checkNull(rs.getString("tran_id")));
			}
			System.out.println("invAllocateTranIDList : "+invAllocateTranIDList);
			rs.close();
			pstmt.close();
			rs = null;
			pstmt = null;
			worder =  worderDetailMap.get("WORK_ORDER");
			itemCode =  worderDetailMap.get("ITEM_CODE");
			locUsageType =  worderDetailMap.get("LOC_USAGE_TYPE");
			dimension = worderDetailMap.get("DIMENSION");
			expLevel =  worderDetailMap.get("EXP_LEV");
			itemRef =  worderDetailMap.get("ITEM_REF");
			requiredQty = Double.parseDouble( worderDetailMap.get("QUANTITY"));
			unit =  worderDetailMap.get("UNIT");
			critItem =  worderDetailMap.get("CRIT_ITEM");
			considerLotNoIss =  worderDetailMap.get("CONSIDER_LOTNO_ISSUE");
			considerPartialAlt =  worderDetailMap.get("CONSIDER_PARTIAL_ALT");
			System.out.println("ReserveStock considerPartialAlt------>>["+considerPartialAlt+"]");
			requiredQty = Double.parseDouble(df.format(requiredQty));

			//Changed by wasim on 29-02-2016 to get min quantity required [START]
			minQtyReq =  Double.valueOf(worderDetailMap.get("MIN_QTY_REQ"));
			System.out.println("Min Quantity Required="+minQtyReq);
			//Changed by wasim on 29-02-2016 to get min quantity required [END]

			// 03-jun-16 manoharan
			sql = "update inv_alloc_det set dealloc_qty = (case when dealloc_qty is null then 0 else dealloc_qty end) + ?, deallocated = case when quantity = ? then 'Y' else 'N' end where tran_id = ? and  line_no = ?";
			pstmtUpd = conn.prepareStatement(sql);
			// end 03-jun-16 manoharan
			
			
			System.out.println("isSufficient------>>["+isSufficient+"]");
			if(invAllocateTranIDList.size() > 0)
			{
				for(String tranID : invAllocateTranIDList)
				{
					//worderDetailMap.put("WORK_ORDER", worder);
					//worderDetailMap.put("SITE_CODE", siteCode);
					//worderDetailMap.put("ITEM_CODE", itemCode);
					//worderDetailMap.put("LOC_USAGE_TYPE", locUsageType);
					//worderDetailMap.put("DIMENSION", dimension);

					//worderDetailMap.put("EXP_LEVEL", expLevel);
					//worderDetailMap.put("ITEM_REF", itemRef);
					//worderDetailMap.put("BOM_CODE", bomCode);
					//worderDetailMap.put("REQ_QUANTITY", ""+reqQuantity);
					//worderDetailMap.put("UNIT", unit);

					//worderDetailMap.put("CRIT_ITEM", critItem);
					//worderDetailMap.put("CONSIDER_LOT_NO_ISS", considerLotNoIss);

					if(reserveStkSql.length() > 0)
					{
						reserveStkSql.delete(0, reserveStkSql.length());
					}
					Map<String,ArrayList> siteItemMap = new HashMap<String,ArrayList>();

					errorCode =checkNull(properDimension (dimension,campgnNo));
					if(errorCode.length() > 0 )
					{
						isMatchDimension = true;
					}
					sql ="SELECT LOC_GROUP,LOT_NO__ISSUE FROM WORKORDER WHERE WORK_ORDER =  ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, worder);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						locGrp = checkNull(rs.getString("LOC_GROUP"));
						packLotNo = checkNull(rs.getString("LOT_NO__ISSUE"));
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;

					sql ="SELECT TRACK_SHELF_LIFE,DESCR FROM ITEM WHERE ITEM_CODE = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, itemCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						trackShelfLife = checkNull(rs.getString("TRACK_SHELF_LIFE"));
						itemDescr = checkNull(rs.getString("DESCR"));
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					trackShelfLife = trackShelfLife.length() == 0 ? "N" : trackShelfLife;

					reserveStkSql.append("select inv_alloc_det.line_no,inv_alloc_det.loc_code,inv_alloc_det.lot_no,inv_alloc_det.lot_sl," );
					//reserveStkSql.append(" (CASE WHEN inv_alloc_det.quantity IS NULL THEN 0 ELSE inv_alloc_det.quantity END  -  CASE WHEN inv_alloc_det.dealloc_qty IS NULL THEN 0 ELSE inv_alloc_det.dealloc_qty END )as inv_qty  from inv_alloc_det,stock,location,invstat " );
                    reserveStkSql.append(" (CASE WHEN inv_alloc_det.quantity IS NULL THEN 0 ELSE inv_alloc_det.quantity END  -  CASE WHEN inv_alloc_det.dealloc_qty IS NULL THEN 0 ELSE inv_alloc_det.dealloc_qty END )as inv_qty, " );
                    reserveStkSql.append(" stock.potency_perc, inv_alloc_det.exp_lev,stock.quantity - case when stock.alloc_qty is null then 0 else stock.alloc_qty end  as stk_qty,stock.exp_date,stock.mfg_date from inv_alloc_det,stock,location,invstat " );
					reserveStkSql.append( "where inv_alloc_det.tran_id ='" + tranID + "' and inv_alloc_det.item_code ='"+ itemCode + "'" );

					reserveStkSql.append(" and (length(rtrim(ltrim(inv_alloc_det.exp_lev))) = 0 or inv_alloc_det.exp_lev is null) " );
					reserveStkSql.append( " and stock.loc_code = location.loc_code " );
					reserveStkSql.append(" and location.inv_stat = invstat.inv_stat " );
					reserveStkSql.append(" and stock.site_code ='"+ siteCode + "'  and stock.item_code ='"+ itemCode + "' " );
					reserveStkSql.append(" and stock.loc_code = inv_alloc_det.loc_code and stock.lot_no = inv_alloc_det.lot_no " );
					reserveStkSql.append(" and stock.lot_sl = inv_alloc_det.lot_sl and nvl(stock.alloc_qty,0) >= 0" );

					reserveStkSql.append(" and (CASE WHEN inv_alloc_det.quantity IS NULL THEN 0 ELSE inv_alloc_det.quantity END  -  CASE WHEN inv_alloc_det.dealloc_qty IS NULL THEN 0 ELSE inv_alloc_det.dealloc_qty END ) > 0 " );
					reserveStkSql.append(" and invstat.available = 'Y' ") ;
					if("Y".equalsIgnoreCase(considerLotNoIss) )
					{
						reserveStkSql.append(" and stock.lot_no IN ("  +getSqlInString(packLotNo) + ")");
					}
					if(isMatchDimension)
					{
						reserveStkSql.append(" and ddf_compare_dimension(stock.dimension, '" + dimension + "') = 'Y', " );
					}

					//if(locUsageType.length() > 0)
					if(!"N".equals(locUsageType.trim()))
					{
						//reserveStkSql.append(" and rtrim(location.loc_group) = decode('" + locUsageType + "','A',rtrim('" + locUsageType +  "'),rtrim(location.loc_group))" );
						reserveStkSql.append("and rtrim(nvl(location.loc_group,'NA')) = decode('" + locUsageType+ "','A',rtrim('" + locGrp +  "'), rtrim(nvl(location.loc_group,'NA'))) ");
					}
					qcReqd = mfgCommon.chkQcReqd(siteCode, itemCode, conn);
					System.out.println("mfgCommon.chkQcReqd qcReqd------>>"+qcReqd);
					//autoQcReqd = mfgCommon.chkAutoQcReqd(siteCode, itemCode, conn);
					if("Y".equalsIgnoreCase(qcReqd) && "Y".equalsIgnoreCase(trackShelfLife))
                    {
                        //reserveStkSql.append(" and ( stock.exp_date > "+Timestamp.valueOf(genericUtility.getValidDateString(effDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00")+" or stock.exp_date is null ) ");
                        //reserveStkSql.append( " and ( stock.retest_date > "+Timestamp.valueOf(genericUtility.getValidDateString(effDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00")+" or  stock.retest_date is null) ");

                        reserveStkSql.append(" and ( stock.exp_date > to_date('"+ genericUtility.getValidDateString(effDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + "', 'yyyy-mm-dd' ) or stock.exp_date is null ) ");
                        reserveStkSql.append( " and ( stock.retest_date > to_date( '"+ genericUtility.getValidDateString(effDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + "', 'yyyy-mm-dd' ) or  stock.retest_date is null) ");
                        reserveStkSql.append( " order by decode('" + locUsageType + "' ,'P',decode(rtrim(location.loc_group),rtrim('" + locGrp + "'),'A','B'),'0'), " );
                    }
                    else if("N".equalsIgnoreCase(qcReqd) && "Y".equalsIgnoreCase(trackShelfLife))
                    {
                        //reserveStkSql.append(" and ( stock.exp_date > "+Timestamp.valueOf(genericUtility.getValidDateString(effDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00")+" or stock.exp_date is null ) ");
                        reserveStkSql.append(" and ( stock.exp_date > to_date( '"+ genericUtility.getValidDateString(effDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + "', 'yyyy-mm-dd' ) or stock.exp_date is null ) ");
                        reserveStkSql.append( " order by decode('" + locUsageType + "' ,'P',decode(rtrim(location.loc_group),rtrim('" + locGrp + "'),'A','B'),'0'), " );
                    }
                    else if("Y".equalsIgnoreCase(qcReqd) && "N".equalsIgnoreCase(trackShelfLife))
                    {
                        //reserveStkSql.append( " and ( stock.retest_date > "+Timestamp.valueOf(genericUtility.getValidDateString(effDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00")+" or  stock.retest_date is null) ");
                        reserveStkSql.append( " and ( stock.retest_date > to_date("+ genericUtility.getValidDateString(effDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + ", 'yyyy-mm-dd' ) or  stock.retest_date is null) ");
                        reserveStkSql.append( " order by decode('" + locUsageType + "' ,'P',decode(rtrim(location.loc_group),rtrim('" + locGrp + "'),'A','B'),'0'), " );
                    }
					else if("N".equalsIgnoreCase(qcReqd) && "N".equalsIgnoreCase(trackShelfLife))
					{
						reserveStkSql.append( " order by decode('" + locUsageType + "' ,'P',decode(rtrim(location.loc_group),rtrim('" + locGrp + "'),'A','B'),'0'), " );
					}
					if(isMatchDimension)
					{
						reserveStkSql.append(" stock.dimension, " );
					}


					reserveStkSql.append(" nvl(stock.exp_date,stock.crea_date),stock.crea_date,stock.lot_no, ");
					reserveStkSql.append("decode(length(decode( substr(rtrim(stock.lot_sl), length(rtrim(stock.lot_sl))) , 'S',(substr(rtrim(stock.lot_sl),1,length(rtrim(stock.lot_sl)) - 1)) ,rtrim(stock.lot_sl)) ), ");

					reserveStkSql.append(" 1, '00' || decode( substr(rtrim(stock.lot_sl), length(rtrim(stock.lot_sl))) , 'S',(substr(rtrim(stock.lot_sl),1,length(rtrim(stock.lot_sl)) )) ,rtrim(stock.lot_sl)), ");
					reserveStkSql.append(" decode(length(decode( substr(rtrim(stock.lot_sl), length(rtrim(stock.lot_sl))) , 'S',(substr(rtrim(stock.lot_sl),1,length(rtrim(stock.lot_sl)) - 1)) ,rtrim(stock.lot_sl)) ),  ");

					reserveStkSql.append(" 2, '0' || decode( substr(rtrim(stock.lot_sl), length(rtrim(stock.lot_sl))) , 'S',(substr(rtrim(stock.lot_sl),1,length(rtrim(stock.lot_sl)) )) ,rtrim(stock.lot_sl)),  ");
					reserveStkSql.append(" decode( substr(rtrim(stock.lot_sl), length(rtrim(stock.lot_sl))) , 'S',(substr(rtrim(stock.lot_sl),1,length(rtrim(stock.lot_sl)) - 1)) ,rtrim(stock.lot_sl)) ))");

					pstmt = conn.prepareStatement(reserveStkSql.toString()) ;

					rs = pstmt.executeQuery();

					while( rs.next() )
					{
						count++;
						//isSufficient = false;
						reserveLineNo = rs.getInt("line_no");
						invLocCode = checkNull(rs.getString("loc_code"));
						invLotNo = rs.getString("lot_no");
						invLotSl = rs.getString("lot_sl");
						reserveStkQty = rs.getDouble("inv_qty");
						stkPotencyPerc = rs.getDouble("potency_perc");
						stkAvailQuantity = rs.getDouble("stk_qty");
						expDate = rs.getTimestamp("exp_date");
						mfgDate = rs.getTimestamp("mfg_date");

						//Changed by wasim on 29-01-2016 to continue if min_req_qty greater than stock qty [START]
						if(reserveStkQty < minQtyReq)
						{
							System.out.println("Stock quantity is less than min quantity required so continue loop");
							//continue;
						}
						//Changed by wasim on 29-01-2016 to continue if min_req_qty greater than stock qty [END]

						System.out.println("stkPotencyPerc-----Reserve------>>["+stkPotencyPerc+"]");
						System.out.println("minPotencyPerc----------->>["+minPotencyPerc+"]");
						// Now Check the reserved stock potency with Min. Potency required
						if(stkPotencyPerc >= minPotencyPerc)
						{
							worderStkBeanObj = new WorderStkBean();
							sitebean = new SiteItemSummaryBean();
							worderStkBeanObj.setReserveLineNo(reserveLineNo);
							worderStkBeanObj.setLocCode(invLocCode);
							worderStkBeanObj.setLotNo(invLotNo);
							sitebean.setLotNo(invLotNo);
							worderStkBeanObj.setLotSl(invLotSl);

							worderStkBeanObj.setSiteCode(siteCode);
							worderStkBeanObj.setItemCode(itemCode);
							worderStkBeanObj.setStkQuantity(stkAvailQuantity + reserveStkQty);
							worderStkBeanObj.setReserveStkQty(reserveStkQty);
							worderStkBeanObj.setItemDescr(itemDescr);
							worderStkBeanObj.setStkPotencyPerc(stkPotencyPerc);

							worderStkBeanObj.setWorkOrder(worder);
							worderStkBeanObj.setExpLevel(expLevel);
							worderStkBeanObj.setMfgDate(mfgDate);
							worderStkBeanObj.setExpDate(expDate);
							worderStkBeanObj.setItemRef(itemRef);
							worderStkBeanObj.setCritItem(critItem);
							worderStkBeanObj.setUnit(unit);
							worderStkBeanObj.setDimension(dimension);
							worderStkBeanObj.setReserveStkTranId(tranID);
							worderStkBeanObj.setReserveStk("Y");
							worderStkBeanObj.setAlternate(alternate);

							worderStkBeanObj.setPotencyAdj(0); //update at the time of calculation of check potency.
							worderStkBeanObj.setIsStockDetail("N");
							 //20-may-16 manoharan allocation quantity to be set whenever there is a change
							 // it cannot be set in some other place
							//worderStkBeanObj.setAllocQty(0); //update at the time of calculation of check potency.
							worderStkBeanObj.setAllocQty(reserveStkQty);
							System.out.println("manohar before .setQuantity 6["+worderStkBeanObj.getQuantity()+"]");
							worderStkBeanObj.setQuantity(reserveStkQty);
							System.out.println("manohar after .setQuantity 6["+worderStkBeanObj.getQuantity()+"]");
							System.out.println(worderStkBeanObj.toString());
							System.out.println(sitebean.toString());

							pstmtUpd.setDouble(1, worderStkBeanObj.getReserveStkQty());
							pstmtUpd.setDouble(2, worderStkBeanObj.getReserveStkQty());
							pstmtUpd.setString(3,worderStkBeanObj.getReserveStkTranId());
							pstmtUpd.setInt(4,worderStkBeanObj.getReserveLineNo());
							pstmtUpd.addBatch();
							pstmtUpd.clearParameters();

							//System.out.println("requiredQty------>>["+requiredQty+"]");
							//System.out.println("stkQuantity------>>["+stkQuantity+"]");
							//System.out.println("isSufficient------>>["+isSufficient+"]");
							if(! isSufficient)
							{
								if(requiredQty <= (reserveStkQty + softAllocQty) )
								{
									balanceQty = 0;
									isSufficient = true;
								}
								else
								{
									System.out.println("else...........");
									isSufficient = false;
									balanceQty = requiredQty - (reserveStkQty + softAllocQty);
									//softAllocQty = stkQuantity + softAllocQty;
									balanceQty = Double.parseDouble(df.format(balanceQty));
									System.out.println("balanceQty@@ : ["+balanceQty+"] ");
									System.out.println("softAllocQty@@ : ["+softAllocQty+"] ");
									requiredQty = balanceQty;
								}
							}

							/*
							if(! doneStockDetailsMap.containsKey(stkKey))
							{
								if(requiredQty <= (stkQuantity + softAllocQty) ) //stkQuantity + softAllocQty
								{
									isSufficient = true;
									break;
								}
								else
								{
									isSufficient = false;
									softAllocQty = stkQuantity + softAllocQty;
									balanceQty = requiredQty - (stkQuantity + softAllocQty);
								}
								doneStockDetailsMap.put(stkKey, String.valueOf(stkQuantity));
							}
							else
							{
								continue;
							}*/
							worderStkBeanList.add(worderStkBeanObj);
							System.out.println("worderStkBeanList obj added@@");
							/*if(isSufficient)
							{
								break;
							}*/

						}

					}//end while
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					System.out.println("balanceQty1 : "+balanceQty);
					System.out.println("requiredQty1 : "+requiredQty);
					if(count == 0)
					{
						returnMapDetails.put("ERROR_CODE","");
						returnMapDetails.put("BALANCE_QTY",String.valueOf(requiredQty));
						returnMapDetails.put("IS_SUFFICIENT",String.valueOf(isSufficient));
					}
					else
					{
						returnMapDetails.put("ERROR_CODE","");
						returnMapDetails.put("BALANCE_QTY",String.valueOf(balanceQty));
						returnMapDetails.put("IS_SUFFICIENT",String.valueOf(isSufficient));
					}


				}
				
				
			}
			else
			{
				//if stock not found in inv_alloc_det (Reserve stock) then set
				//balanceQty as reqQuantity
				System.out.println("if stock not found in inv_alloc_det (Reserve stock) then set balanceQty as reqQuantity");
				returnMapDetails.put("BALANCE_QTY", String.valueOf(requiredQty));
				returnMapDetails.put("ERROR_CODE", "");
				returnMapDetails.put("IS_SUFFICIENT", "false");
			}
			// 20-may-16 manoharan update dealloc_qty in inv_alloc_det
			pstmtUpd.executeBatch();
			if(pstmtUpd !=null)
			{
				pstmtUpd.close();pstmtUpd = null;
			}
			/*
			if (worderStkBeanList.size() > 0)
			{
				sql = "update inv_alloc_det set dealloc_qty = (case when dealloc_qty is null then 0 else dealloc_qty end) + ?, deallocated = case when quantity = ? then 'Y' else 'N' end where tran_id = ? and  line_no = ?";
				pstmt = conn.prepareStatement(sql);
				
				for(int potencyCtr = 0; potencyCtr < worderStkBeanList.size(); potencyCtr++)
				{
					worderStkBeanObj = (WorderStkBean) worderStkBeanList.get(potencyCtr);
					
					pstmt.setDouble(1, worderStkBeanObj.getReserveStkQty());
					pstmt.setDouble(2, worderStkBeanObj.getReserveStkQty());
					pstmt.setString(3,worderStkBeanObj.getReserveStkTranId());
					pstmt.setInt(4,worderStkBeanObj.getReserveLineNo());
					pstmt.addBatch();
					pstmt.clearParameters();

				}
				pstmt.executeBatch();
				if(pstmt !=null)
				{
					pstmt.close();pstmt = null;
				}
			}*/


		}
		catch(Exception e)
		{
			e.printStackTrace();
			writeWorkOrderLog(e.toString(),campgnNo);//TODO
			throw new Exception(e);
		}
		return returnMapDetails;
	}

	//Check stock with alternate item
	//return map with balance quantity,isSufficient,error code
	private Map<String,String> checkForAlternateItem(Map<String,String> altItemDetailMap,Connection conn,String campgnNo)  throws ITMException, Exception
	{
		ResultSet rs= null,rs1= null;
		PreparedStatement pstmt = null,pstmt1 = null;
		String sql = "",altItemCode = "",considerPartialAlt = "",bomCode = "",itemCode = "",itemRef = "",workOrder = "",operation = "",
				locGroup = "",lotNoIssue = "" ;
		boolean isSufficient = false;
		int count = 0;
		double altQuantity = 0,balanceQty = 0,propotinateMQty = 0,qtyPerBom = 0,propotinateAltQty = 0;
		Map<String,String> checkStkReturnMap = new HashMap<String,String>();
		try
		{
			System.out.println("In checkForAlternateItem map@@new : "+altItemDetailMap);
			if(altItemDetailMap.size() > 0)
			{
				bomCode = altItemDetailMap.get("BOM_CODE");
				itemCode = altItemDetailMap.get("ITEM_CODE");
				itemRef = altItemDetailMap.get("ITEM_REF");
				workOrder = altItemDetailMap.get("WORK_ORDER");
				balanceQty = Double.parseDouble(altItemDetailMap.get("BALANCE_QTY"));
				operation = altItemDetailMap.get("OPERATION");
				sql = "select loc_group, lot_no__issue from workorder where work_order = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, workOrder);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					locGroup = checkNull(rs.getString(1));
					lotNoIssue = checkNull(rs.getString(2));
				}
				rs.close();
				rs = null;
				pstmt.close();

				sql = "Select item_code__alt,quantity,case when min_potency_perc in null then 0 else min_potency_perc end as min_potency_perc ,consider_partial_alt "
						+ "from bom_alt where bom_code = ? and item_code  = ? and item_ref   = ?  "
						+ "and	case when active_yn is null then 'Y' else active_yn end = 'Y'  "
						+ "and	case when confirmed is null then 'N' else confirmed end  = 'Y'  "
						+ "order by bom_code,item_code,item_ref,item_code_alt_seq ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, bomCode);
				pstmt.setString(2, itemCode);
				pstmt.setString(3, itemRef);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					count++;
					altItemCode = checkNull(rs.getString("item_code__alt"));
					altQuantity = rs.getDouble("quantity");
					considerPartialAlt = checkNull(rs.getString("consider_partial_alt"));

					if("N".equalsIgnoreCase(considerPartialAlt))
					{
						continue;
					}
					altItemDetailMap.put("ITEM_CODE_ALT", altItemCode);
					//check propotinate for each item



					sql = "select req_type,min_qty, qty_per from bomdet where bom_code = ? "
							+ " and operation = ? and item_code = ? and item_ref = ? ";
					pstmt1 = conn.prepareStatement(sql);
					pstmt1.setString(1, bomCode);
					pstmt1.setString(2, operation);
					pstmt1.setString(3, itemCode);
					pstmt1.setString(4, itemRef);
					rs1 = pstmt1.executeQuery();//req_type,min_qty, qty_per
					if(rs1.next())
					{
						qtyPerBom = rs1.getDouble("qty_per");
					}
					rs1.close();
					pstmt1.close();
					rs1 = null;
					pstmt1 = null;
					
					propotinateAltQty = (balanceQty * altQuantity) / qtyPerBom ;//(4 * 15)/10 = 6
					System.out.println("in checkForAlternateItem qtyPerBom A2M  ["+qtyPerBom + "] balanceQty [" + balanceQty + "] altQuantity [" + altQuantity+ "] propotinateAltQty [" + propotinateAltQty+ "]" );
					// System.out.println("propotinateAltQty A2M : "+propotinateAltQty);
					//propotinateQty = getProportionateQty(altItemDetailMap,"A2M",conn);

					//now check in stock alternate item sufficient or not (propotinateQty)
					altItemDetailMap.put("ITEM_CODE", altItemCode);
					altItemDetailMap.put("QUANTITY", String.valueOf(propotinateAltQty));
					altItemDetailMap.put("IS_ALTERNATE", "Y");
					altItemDetailMap.put("PACK_LOT_NO", lotNoIssue);
					altItemDetailMap.put("LOC_GROUP", locGroup);
					
					checkStkReturnMap = checkCurrentSiteStock(altItemDetailMap, conn,campgnNo);
					//balanceQty = balanceQty -
					System.out.println("checkStkReturnMap A2M : "+checkStkReturnMap);
					isSufficient = Boolean.parseBoolean(checkStkReturnMap.get("IS_SUFFICIENT"));
					// 13-jun-16 manoharan following uncommented as balance to convered back to main unit
					propotinateMQty = (balanceQty * qtyPerBom)/altQuantity; //(4 * 10)/15 = 2.667            //Commented by wasim
					balanceQty = balanceQty - propotinateMQty; // 4 - 2.667 = 1.333                          //Commented by wasim
					System.out.println("balanceQty A2M : "+balanceQty);                                      //Commented by wasim

					//balanceQty = altBalanceQty;
					System.out.println("balanceQty A2M : "+balanceQty);


					if(isSufficient)
					{
						isSufficient  = true;
						break;
					}
					else
					{
						isSufficient  = false;
						continue;
					}


				}
				rs.close();
				pstmt.close();
				rs = null;
				pstmt = null;

			}

			if(isSufficient)
			{
				checkStkReturnMap.put("BALANCE_QTY", ""+balanceQty);
				checkStkReturnMap.put("ERROR_CODE", "");
				checkStkReturnMap.put("IS_SUFFICIENT", ""+isSufficient);
			}
			else if(!isSufficient && count == 0)
			{
				checkStkReturnMap.put("BALANCE_QTY", ""+balanceQty);
				checkStkReturnMap.put("ERROR_CODE", "");
				checkStkReturnMap.put("IS_SUFFICIENT", ""+isSufficient);
			}
			else
			{
				checkStkReturnMap.put("BALANCE_QTY", ""+balanceQty);
				checkStkReturnMap.put("ERROR_CODE", "");
				checkStkReturnMap.put("IS_SUFFICIENT", ""+isSufficient);
			}
			System.out.println("after alternate  checkStkReturnMap ["+checkStkReturnMap + "]"); 
			

		}
		catch(Exception e)
		{
			e.printStackTrace();
			writeWorkOrderLog(e.toString(),campgnNo);//TODO
			throw new ITMException(e);
		}
		return checkStkReturnMap;
	}
	@SuppressWarnings("unused")
	private double getProportionateQty( Map<String,String> itemDetailMap,String flag, Connection conn,String campgnNo) throws ITMException, Exception
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String sql = "",reqType = "",bomCode = "",itemCode = "",itemRef = "",altItemCode = "",operation = "",workOrder = "";
		boolean isExecuteSql = false;
		double minQty = 0,qtyPerAlt = 0,proportionateQty = 0, woBatchQty = 0, bomBatchQty = 0,qtyPer = 0, actualQty = 0,
				qtyPerBom = 0,balanceQty = 0;
		try
		{
			flag = itemDetailMap.get("FLAG");
			bomCode = itemDetailMap.get("BOM_CODE");
			itemCode = itemDetailMap.get("ITEM_CODE");
			itemRef = itemDetailMap.get("ITEM_REF");
			workOrder = itemDetailMap.get("WORK_ORDER");
			operation = itemDetailMap.get("OPERATION");
			altItemCode = itemDetailMap.get("ITEM_CODE_ALT");
			balanceQty = Double.parseDouble(itemDetailMap.get("BALANCE_QTY"));

			if("M2A".equalsIgnoreCase(flag))
			{
				sql = "select batch_qty from bom where bom_code = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, bomCode);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					bomBatchQty = rs.getDouble("batch_qty");
				}
				rs.close();
				pstmt.close();
				rs = null;
				pstmt = null;


				sql = "select ref_qty from	workorder_bill where work_order = ? and operation  = ? ";
				if("db2".equalsIgnoreCase(database))
				{
					sql = sql + " Fetch First Row Only";
				}
				else
				{
					sql = sql + " and rownum = 1";
				}
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, workOrder);
				pstmt.setString(2, operation);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					woBatchQty = rs.getDouble("ref_qty");
					isExecuteSql = true;
				}
				rs.close();
				pstmt.close();
				rs = null;
				pstmt = null;
				if(! isExecuteSql)
				{
					sql = "select quantity from workorder where work_order = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, workOrder);
					pstmt.setString(2, operation);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						woBatchQty = rs.getDouble("ref_qty");
					}
					rs.close();
					pstmt.close();
					rs = null;
					pstmt = null;
				}
				//Repeat
				sql = "select req_type,min_qty, qty_per from bomdet where bom_code = ? "
						+ " and operation = ? and item_code = ? and item_ref = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, bomCode);
				pstmt.setString(2, operation);
				pstmt.setString(3, itemCode);
				pstmt.setString(4, itemRef);
				rs = pstmt.executeQuery();//req_type,min_qty, qty_per
				if(rs.next())
				{
					reqType = checkNull(rs.getString("req_type"));
					minQty = rs.getDouble("min_qty");
					qtyPerBom = rs.getDouble("qty_per");
				}
				rs.close();
				pstmt.close();
				rs = null;
				pstmt = null;

				sql = "select quantity from bom_alt where bom_code = ? and item_code = ? and item_ref = ? and item_code__alt = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, bomCode);
				pstmt.setString(2, itemCode);
				pstmt.setString(3, itemRef);
				pstmt.setString(4, altItemCode);
				rs = pstmt.executeQuery();//req_type,min_qty, qty_per
				if(rs.next())
				{
					qtyPerAlt = rs.getDouble("min_qty");

				}
				rs.close();
				pstmt.close();
				rs = null;
				pstmt = null;
				//Repeat end

				if("S".equalsIgnoreCase(reqType))
				{
					proportionateQty = (woBatchQty / bomBatchQty) * qtyPerAlt;
				}
				else if("P".equalsIgnoreCase(reqType))
				{
					proportionateQty = (qtyPerAlt / bomBatchQty) * woBatchQty;
				}
				else if("F".equalsIgnoreCase(reqType))
				{
					proportionateQty = qtyPerAlt;
				}
				if(proportionateQty < minQty)
				{
					proportionateQty = minQty;
				}
				actualQty = (qtyPerBom / bomBatchQty) * woBatchQty;
				qtyPer = proportionateQty / actualQty;

				proportionateQty = balanceQty * qtyPer;

			}
			else if("A2M".equalsIgnoreCase(flag))
			{
				sql = "select qty_per from bomdet where bom_code = ? "
						+ " and operation = ? and item_code = ? and item_ref = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, bomCode);
				pstmt.setString(2, operation);
				pstmt.setString(3, itemCode);
				pstmt.setString(4, itemRef);
				rs = pstmt.executeQuery();//req_type,min_qty, qty_per
				if(rs.next())
				{
					qtyPerBom = rs.getDouble("qty_per");
				}
				rs.close();
				pstmt.close();
				rs = null;
				pstmt = null;

				sql = "select quantity from bom_alt where bom_code = ? and item_code = ? and item_ref = ? and item_code__alt = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, bomCode);
				pstmt.setString(2, itemCode);
				pstmt.setString(3, itemRef);
				pstmt.setString(4, altItemCode);
				rs = pstmt.executeQuery();//req_type,min_qty, qty_per
				if(rs.next())
				{
					qtyPerAlt = rs.getDouble("quantity");

				}
				rs.close();
				pstmt.close();
				rs = null;
				pstmt = null;

				if(Math.abs(qtyPerAlt) > 0 && Math.abs(balanceQty) > 0)
				{
					proportionateQty = qtyPerBom / qtyPerAlt * balanceQty;
				}
				else
				{
					proportionateQty = balanceQty;
				}


			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			writeWorkOrderLog(e.toString(),campgnNo);//TODO
			throw new ITMException(e);
		}
		return proportionateQty;
	}
	//return existing index of siteItemReqQtyList siteCode, itemCode wise
	private int indexOfSiteItemReqQtyList(String siteCode, String itemCode) throws ITMException, Exception
	{
		int retVal = -1, ctr = 0;
		SiteItemSummaryBean tempObj = null;

		System.out.println("Inside indexOfSiteItemReqQtyList siteCode["+siteCode+"] and itemCode["+itemCode+"]");

		for (ctr = 0; ctr < siteItemReqQtyList.size(); ctr++)
		{
			tempObj = (SiteItemSummaryBean) siteItemReqQtyList.get(ctr);

			System.out.println("tempObj siteCode["+tempObj.getSiteCodeShip()+"] and tempObj itemCode["+tempObj.getItemCode()+"]");

			//if ((tempObj.getSiteCode().equals(siteCode.trim())) && (tempObj.getItemCode().equals(itemCode.trim())))
			if ((tempObj.getSiteCodeShip().equals(siteCode.trim())) && (tempObj.getItemCode().equals(itemCode.trim())))
			{
				retVal = ctr;
				break;
			}
		}
		return retVal;
	}
	private int indexOfSiteItemReqQtyListNC(String siteCode, String itemCode) throws ITMException, Exception
	{
		int retVal = -1, ctr = 0;
		SiteItemSummaryBeanNC tempObj = null;

		System.out.println("Inside indexOfSiteItemReqQtyList siteCode["+siteCode+"] and itemCode["+itemCode+"]");

		for (ctr = 0; ctr < siteItemReqQtyListNC.size(); ctr++)
		{
			tempObj = (SiteItemSummaryBeanNC) siteItemReqQtyListNC.get(ctr);

			System.out.println("tempObj siteCode["+tempObj.getSiteCodeShip()+"] and tempObj itemCode["+tempObj.getItemCode()+"]");

			//if ((tempObj.getSiteCode().equals(siteCode.trim())) && (tempObj.getItemCode().equals(itemCode.trim())))
			if ((tempObj.getSiteCodeShip().equals(siteCode.trim())) && (tempObj.getItemCode().equals(itemCode.trim())))
			{
				retVal = ctr;
				break;
			}
		}
		return retVal;
	}
	// 02-jun-16 manoharan to update the sufficient flag
	private void updateWoBeanSufficient(String worder, String expLvl, String isSufficient) throws ITMException, Exception
	{
		WorkOrderDetailBean tempObj = null;


		for (int ctr = 0; ctr < workOrderBeanList.size(); ctr++)
		{
			tempObj = (WorkOrderDetailBean) workOrderBeanList.get(ctr);
			if ((tempObj.getWorkOrder().trim().equals(worder.trim())) && (tempObj.getExpLev().trim().equals(expLvl.trim())))
			{
				tempObj.setSufficient(isSufficient);
				workOrderBeanList.set(ctr, tempObj);
				break;
			}
		}
		
	}
	private int indexOfWorkorderBeanList(String worder, String expLvl) throws ITMException, Exception
	{
		int retVal = -1;
		WorkOrderDetailBean tempObj = null;


		for (int ctr = 0; ctr < workOrderBeanList.size(); ctr++)
		{
			tempObj = (WorkOrderDetailBean) workOrderBeanList.get(ctr);
			if ((tempObj.getWorkOrder().trim().equals(worder.trim())) && (tempObj.getExpLev().trim().equals(expLvl.trim())))
			{
				retVal = ctr;
				break;
			}
		}
		return retVal;
	}

	//Changed by wasim to overload method on 07-04-2016 [START]
	private int indexOfWorkorderStkList(String worder, String expLvl,String itemCode,String locCode,String siteCode,String lotNo,String lotSl) throws ITMException, Exception
	{
		int retVal = -1;
		WorderStkBean tempObj = null;

		for (int ctr = 0; ctr < worderStkBeanList.size(); ctr++)
		{
			tempObj = (WorderStkBean) worderStkBeanList.get(ctr);
			if ((tempObj.getWorkOrder().trim().equals(worder.trim())) && (tempObj.getExpLevel().trim().equals(expLvl.trim()))
			&& (tempObj.getItemCode().trim().equals(itemCode.trim())) && (tempObj.getLocCode().trim().equals(locCode.trim()))
			&& (tempObj.getLotNo().trim().equals(lotNo.trim())) && (tempObj.getLotSl().trim().equals(lotSl.trim())) && (tempObj.getSiteCode().trim().equals(siteCode.trim())))
			{
				retVal = ctr;
				break;
			}
		}
		System.out.println("Match index returning="+retVal);
		return retVal;
	}
	@SuppressWarnings("unused")
	private int indexOfWorkorderStkList(String itemCode,String locCode,String siteCode,String lotNo,String lotSl) throws ITMException, Exception
	{
		int retVal = -1;
		WorderStkBean tempObj = null;

		for (int ctr = 0; ctr < worderStkBeanList.size(); ctr++)
		{
			tempObj = (WorderStkBean) worderStkBeanList.get(ctr);
			if ((tempObj.getItemCode().trim().equals(itemCode.trim())) && (tempObj.getLocCode().trim().equals(locCode.trim()))
			&& (tempObj.getLotNo().trim().equals(lotNo.trim())) && (tempObj.getLotSl().trim().equals(lotSl.trim())) && (tempObj.getSiteCode().trim().equals(siteCode.trim())))
			{
				retVal = ctr;
				break;
			}
		}
		System.out.println("Match index returning="+retVal);
		return retVal;
	}
	//Changed by wasim to overload method on 07-04-2016 [END]
	
	//Changed by wasim on 14-04-2016 to get other site detail [START]
	@SuppressWarnings("rawtypes")
	private int getOtherSiteItemIndex(String itemCode,String locCode,String siteCode,String lotNo,String lotSl,String critItem) throws ITMException, Exception
	{
		int retVal = -1;
		SiteItemSummaryBean tempObj = null;
		SiteItemSummaryBeanNC tempObjNC = null;
		
		ArrayList stkList = null;
		HashMap hm = null;
		if(critItem.equalsIgnoreCase("Y")){
		
			System.out.println("for index of critical item::");
			for (int ctr = 0; ctr < siteItemReqQtyList.size(); ctr++)
			{
				tempObj = (SiteItemSummaryBean) siteItemReqQtyList.get(ctr);
				
				stkList = tempObj.getStockList();
				
				for (int innerCtr = 0; innerCtr < stkList.size(); innerCtr++)
				{
					hm = (HashMap) stkList.get(innerCtr);
					
					if ((((String) hm.get("ITEM_CODE")).trim().equals(itemCode.trim())) && (((String) hm.get("LOC_CODE")).trim().equals(locCode.trim()))
						&& (((String) hm.get("LOT_NO")).trim().equals(lotNo.trim())) && (((String) hm.get("LOT_SL")).trim().equals(lotSl.trim())) && (((String) hm.get("SITE_CODE")).trim().equals(siteCode.trim())))
					{
						retVal = ctr;
						break;
					}
				}	
			}
			
		}else if(critItem.equalsIgnoreCase("N")){
			
			System.out.println("for index of non critical item::");
			
			for (int ctr = 0; ctr < siteItemReqQtyListNC.size(); ctr++)
			{
				tempObjNC = (SiteItemSummaryBeanNC) siteItemReqQtyListNC.get(ctr);
				
				stkList = tempObjNC.getStockList();
				
				for (int innerCtr = 0; innerCtr < stkList.size(); innerCtr++)
				{
					hm = (HashMap) stkList.get(innerCtr);
					
					if ((((String) hm.get("ITEM_CODE")).trim().equals(itemCode.trim())) && (((String) hm.get("LOC_CODE")).trim().equals(locCode.trim()))
						&& (((String) hm.get("LOT_NO")).trim().equals(lotNo.trim())) && (((String) hm.get("LOT_SL")).trim().equals(lotSl.trim())) && (((String) hm.get("SITE_CODE")).trim().equals(siteCode.trim())))
					{
						retVal = ctr;
						break;
					}
				}	
			}
		}
		
		System.out.println("Match found with stock="+retVal);
		return retVal;
	}
	//Changed by wasim on 14-04-2016 to get other site detail [END]

	//Write log in jboss log file.
	private void  writeWorkOrderLog(String error, String campgnNo) 
	{
		final Logger logger = Logger.getLogger(WoFirmplanPrc.class.getName());
		String attachPath = "",fileName1 = "";
		try
		{
			fileName1 = "firmPlanLog";
			attachPath = CommonConstants.JBOSSHOME + File.separator + "server" + File.separator + "default" + File.separator + "log" + File.separator;

			String separator = String.valueOf( attachPath.charAt(attachPath.length() - 1));
			if(!separator.equalsIgnoreCase(File.separator) )
			{
				attachPath = attachPath + File.separator;
			}
			File file=new File(attachPath);
			file.mkdirs();
			File file1 = new File(attachPath + fileName1 + campgnNo);
			if(file1.exists())
			{
				file1.delete();
			}
			file1.createNewFile();
			System.out.println("PATH123 :"+file1.getAbsolutePath());
			Handler fh = new FileHandler(file1.getAbsolutePath(), true);
			fh.setFormatter(new SimpleFormatter());  // Set the log format
			logger.addHandler(fh);
			logger.setLevel(Level.FINE);
			logger.log(Level.SEVERE, error, error);
			fh.flush();
			fh.close();
		}
		catch(Exception e)
		{
			e.printStackTrace();
			//throw new Exception(e);
		}

	}
	private String properDimension(String dimension,String campgnNo)
	{
		String errorCode = "",lenWidHei []= null ;
		dimension =  checkNull(dimension);
		dimension = dimension.toLowerCase();
		try
		{
			if(dimension.length() > 0)
			{
				if(dimension.indexOf("x") > -1 )
				{
					lenWidHei = dimension.split("x");
					int reg = lenWidHei.length;
					if(reg == 3)
					{
					}
					else if(reg == 2)
					{
					}
					else if(reg == 1)
					{
					}

				}
			}
			else
			{
				errorCode = "Error";
			}
		}
	catch(NumberFormatException e)
	{
		writeWorkOrderLog(e.toString(),campgnNo);//TODO
		return "Error";
		
	}
		return errorCode;

	}
	@SuppressWarnings({ "unused", "rawtypes", "unchecked" })
	private Map  getSiteItemSummaryBeanObj (String itemCode,String siteCode,String campgnNo) throws Exception
	{
		Map detailMap = new HashMap();
		int index = -1;
		System.out.println("In getBalanceQty list-------->>"+siteItemReqQtyList);
		if(siteItemReqQtyList.size() > 0)
		{
			for (SiteItemSummaryBean tempObj : siteItemReqQtyList)
			{
				index++;
				if(itemCode.trim().equalsIgnoreCase(tempObj.getItemCode().trim()) && siteCode.trim().equalsIgnoreCase(tempObj.getSiteCode().trim()))
				{
					detailMap.put("OBJECT", tempObj);
					detailMap.put("INDEX", index);
				}
			}
		}

		return detailMap;
	}
	//Build sql for checking current stock
	private String getBuildedWoIssueSql(Map<String,String>stockDetailMap,Connection conn) throws Exception
	{
		ResultSet rs= null;
		PreparedStatement pstmt = null;
		String sql = "",detailSum = "",suppCodeMfg = "",siteCode = "",itemCode = "",locUsageType = "",locGroup = "",
				qcReqd = "",trackShelfLife = "",considerLotIssue = "",packLotNo = "",dimension = "",effDate = "",autoQcReqd ="",
				useInvStatus = "",qtyPerStr = "",minQtyPerLotStr = "",trimWidthStr = "",compareDimensionStr = "",locType = "",
				tranDate = "",orderType = "", otherSite = "N",noOfDays = "";
		boolean isCompareDimension = false;

		StringBuffer stockSqlBuf = new StringBuffer();
		double minQtyPerLot = 0,trimWidth = 0,qtyPer = 0;
		MfgCommon mfgCommon = new MfgCommon();

		Calendar currentDate = Calendar.getInstance();
		SimpleDateFormat simpleDateFormatObj = new SimpleDateFormat(genericUtility.getApplDateFormat());
		tranDate = simpleDateFormatObj.format(currentDate.getTime());

		System.out.println("In getBuildedWoIssueSql : "+stockDetailMap);
		// 13-jun-16 manoharan in case of other site quantity available should be atleast  1 article i.e. availabe should be >= qty_per_art
		otherSite = checkNull(stockDetailMap.get("OTHER_SITE"));
		if (otherSite == null || otherSite.trim().length() == 0)
		{
			otherSite = "N";
		}
		// end 13-jun-16 manoharan in case of other site quantity available should be atleast  1 article i.e. availabe should be >= qty_per_art
		siteCode = checkNull(stockDetailMap.get("SITE_CODE"));
		itemCode = checkNull(stockDetailMap.get("ITEM_CODE"));
		qcReqd = checkNull(stockDetailMap.get("QC_REQD"));
		trackShelfLife = checkNull(stockDetailMap.get("TRACK_SHELF_LIFE"));
		considerLotIssue = checkNull(stockDetailMap.get("CONSIDER_LOT_ISSUE"));
		packLotNo = checkNull(stockDetailMap.get("PACK_LOT_NO"));
		compareDimensionStr = checkNull(stockDetailMap.get("COMPARE_DIMENSION"));
		compareDimensionStr = compareDimensionStr.length() == 0 ? "false" : compareDimensionStr;
		isCompareDimension = Boolean.valueOf(compareDimensionStr);
		dimension = checkNull(stockDetailMap.get("DIMENSION"));
		trimWidthStr = checkNull(stockDetailMap.get("TRIM_WIDTH"));
		trimWidthStr = trimWidthStr.length() == 0 ? "0" : trimWidthStr;
		trimWidth = Double.valueOf(trimWidthStr);
		qtyPerStr = checkNull(stockDetailMap.get("QTY_PER"));
		qtyPerStr = qtyPerStr.length() == 0 ? "0" : qtyPerStr;
		qtyPer = Double.valueOf(qtyPerStr);
		locUsageType = checkNull(stockDetailMap.get("LOC_USAGE_TYPE"));
		locGroup = checkNull(stockDetailMap.get("LOC_GROUP"));
		effDate = checkNull(stockDetailMap.get("EFF_DATE"));
		detailSum = checkNull(stockDetailMap.get("DETAIL_SUM"));
		suppCodeMfg = checkNull(stockDetailMap.get("SUPP_CODE_MFG"));

		minQtyPerLotStr = checkNull(stockDetailMap.get("MIN_QTY_PER_LOT"));

		minQtyPerLotStr = minQtyPerLotStr.length() == 0 ? "0" : minQtyPerLotStr;
		minQtyPerLot = Double.valueOf(minQtyPerLotStr);

		useInvStatus = checkNull(stockDetailMap.get("USE_INV_STATUS"));
		orderType = checkNull(stockDetailMap.get("ORDER_TYPE"));//Changed by wasim on 29-03-2016 to get the work order type.
		System.out.println("Order Type in Build SQL=["+orderType+"]");

		qcReqd = mfgCommon.chkQcReqd(siteCode, itemCode, conn);
		autoQcReqd = mfgCommon.chkAutoQcReqd(siteCode, itemCode, conn);
		 noOfDays = mfgCommon.getEnvMfg("999999", "AWMS_EXP_DATE_CHECK", conn);
		 
		 noOfDays = noOfDays == null ? "" : noOfDays.trim();
		 
		 if(!noOfDays.equalsIgnoreCase("NULLFOUND") && noOfDays.trim().length() == 0)
		 {
			 noOfDays = "0";
			 
		 }
		 System.out.println("no of days:::" + noOfDays);

		if(effDate.length() == 0)
		{
			effDate = tranDate;
		}

		if("S".equalsIgnoreCase(detailSum))
        {
            stockSqlBuf.append("select sum(nvl(stock.quantity,0) - nvl(stock.alloc_qty,0)) as QUANTITY ");
        }
        else if("I".equalsIgnoreCase(detailSum))
        {

            stockSqlBuf.append("select SITE_CODE__MFG, sum( (case when quantity is null then 0 else quantity end) - ");
            stockSqlBuf.append(" (case when alloc_qty is null then 0 else alloc_qty end) )  as QUANTITY ");
        }
        else
        {
            stockSqlBuf.append("select nvl(stock.quantity,0) - nvl(stock.alloc_qty,0)  as QUANTITY, stock.loc_code as LOC_CODE,");
            stockSqlBuf.append("stock.lot_no as LOT_NO, stock.lot_sl as LOT_SL, nvl(stock.potency_perc,0) as POTENCY_PERC, stock.crea_date, " );
            stockSqlBuf.append(" stock.dimension, stock.SITE_CODE__MFG, stock.EXP_DATE as EXP_DATE, stock.UNIT, stock.ITEM_SER, stock.MFG_DATE, stock.ALLOC_QTY, stock.PACK_CODE ");
            stockSqlBuf.append(",qty_per_art ");
        }

		/*if("S".equalsIgnoreCase(detailSum))
		{
			if("Y".equalsIgnoreCase(matchPotency))
			{
				stdPotency = getItemStandardPotency(itemCode,conn);
				stockSqlBuf.append("select sum(((case when stock.quantity is null then 0 else stock.quantity end) - (case when stock.alloc_qty is null then 0 else stock.alloc_qty end) - (case when stock.hold_qty is null then 0 else stock.hold_qty end)) ");
				stockSqlBuf.append(" * (case when stock.potency_perc is null then 0 else stock.potency_perc end) / ");
				stockSqlBuf.append(stdPotency);
			}
			else
			{
				stockSqlBuf.append("select sum((case when stock.quantity is null then 0 else stock.quantity end) - (case when stock.alloc_qty is null then 0 else stock.alloc_qty end) - (case when stock.hold_qty is null then 0 else stock.hold_qty end)) ");
			}

		}
		else if("I".equalsIgnoreCase(detailSum))
		{
			stockSqlBuf.append("select supp_code__mfg, sum( (case when quantity is null then 0 else quantity end) - ");
			stockSqlBuf.append("(case when alloc_qty is null then 0 else alloc_qty end) - (case when hold_qty is null then 0 else hold_qty end)) ");
		}
		else
		{
			stockSqlBuf.append("select (case when stock.quantity is null then 0 else stock.quantity end) - (case when stock.alloc_qty is null then 0 else stock.alloc_qty end) - ");
			stockSqlBuf.append("(case when stock.hold_qty is null then 0 else stock.hold_qty end) ,stock.loc_code,stock.lot_no,stock.lot_sl,nvl(stock.potency_perc,0),stock.crea_date,stock.dimension,stock.supp_code__mfg ");
		}*/



		sql = "SELECT LOC_TYPE FROM ITEM WHERE ITEM_CODE = ?";
		pstmt = conn.prepareStatement(sql);
		pstmt.setString(1, itemCode);
		rs = pstmt.executeQuery();
		if(rs.next())
		{
			locType = checkNull(rs.getString("LOC_TYPE"));
		}
		rs.close();
		rs = null;
		pstmt.close();
		pstmt = null;
		System.out.println("locType------>>["+locType+"]");
		
		stockSqlBuf.append(" from stock,location,invstat where stock.loc_code = location.loc_code and location.inv_stat = invstat.inv_stat ");
		stockSqlBuf.append(" and stock.site_code = '"+siteCode+"' ");
		stockSqlBuf.append(" and stock.item_code = '"+itemCode+"' ");
		stockSqlBuf.append(" and location.loc_type = '"+locType+"' ");
		//stockSqlBuf.append(" and case when stock.alloc_qty is null then 0 else stock.alloc_qty end >= 0 ");
		stockSqlBuf.append(" and (case when stock.quantity is null then 0 else stock.quantity end) - (case when stock.alloc_qty is null then 0 else stock.alloc_qty end) - (case when stock.hold_qty is null then 0 else stock.hold_qty end) > 0 ");
		stockSqlBuf.append(" and invstat.available = 'Y' ");
		//stockSqlBuf.append(" and (case when stock.consider_allocate is null then 'Y' else stock.consider_allocate end = 'Y' ");

		if(!"I".equalsIgnoreCase(detailSum))
		{
			stockSqlBuf.append(" and nvl(stock.quantity,0) - nvl(stock.alloc_qty,0) >= "+minQtyPerLot + " ");
			//stockSqlBuf.append(" and nvl(stock.quantity,0) - nvl(stock.alloc_qty,0) > "+minQtyPerLot + " ");//changed by azhar
		}
		// 13-jun-16 manoharan in case of other site quantity available should be atleast  1 article i.e. availabe should be >= qty_per_art
		if("Y".equalsIgnoreCase(otherSite))
		{
			//stockSqlBuf.append(" and nvl(stock.quantity,0) - nvl(stock.alloc_qty,0) >= stock.qty_per_art ");//Commented by Manoj dtd 29/DEC/16 to remove alloc_qty consideration as stock is allocated from multiple workorders
			stockSqlBuf.append(" and nvl(stock.quantity,0)  >= stock.qty_per_art ");
		}
		// end 13-jun-16 manoharan in case of other site quantity available should be atleast  1 article i.e. availabe should be >= qty_per_art
		if(suppCodeMfg.length() > 0 && ! "null".equalsIgnoreCase(suppCodeMfg))
		{
			stockSqlBuf.append(" and stock.supp_code__mfg in ("+getSqlInString(suppCodeMfg)+") ");
		}

		if("Y".equalsIgnoreCase(considerLotIssue) && packLotNo.length() > 0)
		{
			stockSqlBuf.append(" and stock.lot_no IN ("+getSqlInString(packLotNo)+")" );
		}

		/*if(locUsageType.length() > 0)
		{
			stockSqlBuf.append(" and rtrim(nvl(location.loc_group,'NA')) = decode('" + locUsageType+ "','A',rtrim('" + locGroup +  "'), " +
					"rtrim(nvl(location.loc_group,'NA'))) ");
		}*/

		 if(!"N".equals(locUsageType) && "N".equalsIgnoreCase(otherSite))
	        {
	            stockSqlBuf.append(" and rtrim(nvl(location.loc_group,'NA')) = decode('" + locUsageType+ "','A',rtrim('" + locGroup +  "'), rtrim(nvl(location.loc_group,'NA'))) ");
	        }
		if(isCompareDimension)
		{
			stockSqlBuf.append(" and ddf_compare_dimension(stock.dimension, '" + dimension + "'," + trimWidth + ") = 'Y' ");
			stockSqlBuf.append(" and stock.quantity - stock.alloc_qty - (case when stock.hold_qty is null then 0 else stock.hold_qty end) >= " + qtyPer+") ");
		}

		stockSqlBuf.append(" and invstat.stat_type <> 'S' ");

		if ("Y".equalsIgnoreCase(trackShelfLife))
        {
            //stockSqlBuf.append( " and ( stock.exp_date > "+genericUtility.getValidDateString(effDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) +" or stock.exp_date is null )"  );
            stockSqlBuf.append(" and ( stock.exp_date - " + noOfDays +" > to_date('"+ genericUtility.getValidDateString(effDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + "', 'yyyy-mm-dd' ) or stock.exp_date is null ) "  );
			//stockSqlBuf.append(" and ( stock.exp_date > to_date('"+ genericUtility.getValidDateString(effDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + "', 'yyyy-mm-dd' ) or stock.exp_date is null ) "  );
        }

        if("U".equalsIgnoreCase(useInvStatus))
        {
            if (qcReqd.equalsIgnoreCase("Y") && autoQcReqd.equalsIgnoreCase("Y"))
            {
                stockSqlBuf.append(" and ( stock.retest_date - " + noOfDays +" > to_date('"+ genericUtility.getValidDateString(effDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + "', 'yyyy-mm-dd' ) ) "  );
            	//stockSqlBuf.append(" and ( stock.retest_date > to_date('"+ genericUtility.getValidDateString(effDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + "', 'yyyy-mm-dd' ) ) "  );
            }
        }

		if("I".equalsIgnoreCase(detailSum))
		{
			stockSqlBuf.append(" group by supp_code__mfg ");
			stockSqlBuf.append(" order by sum( (case when quantity is null then 0 else quantity end) - (case when alloc_qty is null then 0 else alloc_qty end) ) ");
		}
		else if(! "S".equalsIgnoreCase(detailSum))
		{
			stockSqlBuf.append(" order by ");
			//stockSqlBuf.append(" order by (case when '" + locUsageType + "' = 'P' then (case when rtrim(location.loc_group) = rtrim('" + locGroup + "') Then 'A' else 'B' end) else '0' end), "); // commented by azhar[26-APR-2017]
			if("N".equalsIgnoreCase(otherSite)){
			stockSqlBuf.append(" (case when '" + locUsageType + "' = 'P' then (case when rtrim(location.loc_group) = rtrim('" + locGroup + "') Then 'A' else 'B' end) else '0' end), ");
			}
			if(isCompareDimension)
			{
				stockSqlBuf.append(" stock.dimension, ");
			}
			if("db2".equalsIgnoreCase(database))
			{
				stockSqlBuf.append(" nvl(stock.exp_date,stock.crea_date),stock.crea_date,stock.lot_no  ");
			}
			else
			{
				stockSqlBuf.append(" nvl(stock.exp_date,stock.crea_date),stock.crea_date,stock.lot_no, ");
				stockSqlBuf.append(" decode(length(decode( substr(rtrim(stock.lot_sl), length(rtrim(stock.lot_sl))) , 'S',(substr(rtrim(stock.lot_sl),1,length(rtrim(stock.lot_sl)) - 1)) ,rtrim(stock.lot_sl)) ),");
				stockSqlBuf.append(" 1, '00' || decode( substr(rtrim(stock.lot_sl), length(rtrim(stock.lot_sl))) , 'S',(substr(rtrim(stock.lot_sl),1,length(rtrim(stock.lot_sl)) )) ,rtrim(stock.lot_sl)), ");
				stockSqlBuf.append(" decode(length(decode( substr(rtrim(stock.lot_sl), length(rtrim(stock.lot_sl))) , 'S',(substr(rtrim(stock.lot_sl),1,length(rtrim(stock.lot_sl)) - 1)) ,rtrim(stock.lot_sl)) ), ");
				stockSqlBuf.append(" 2, '0' || decode( substr(rtrim(stock.lot_sl), length(rtrim(stock.lot_sl))) , 'S',(substr(rtrim(stock.lot_sl),1,length(rtrim(stock.lot_sl)) )) ,rtrim(stock.lot_sl)), ");
				stockSqlBuf.append(" decode( substr(rtrim(stock.lot_sl), length(rtrim(stock.lot_sl))) , 'S',(substr(rtrim(stock.lot_sl),1,length(rtrim(stock.lot_sl)) - 1)) ,rtrim(stock.lot_sl)) )) ");
			}
		}

		System.out.println("Final return build SQL["+stockSqlBuf.toString()+"]");
		if("Y".equalsIgnoreCase(otherSite) && (!"I".equalsIgnoreCase(detailSum)) && (!"S".equalsIgnoreCase(detailSum)))
		{
			System.out.println("to populate sql map::[" + siteCode.trim()+"@"+itemCode.trim()+"]");
			sqlMap.put(siteCode.trim()+"@"+itemCode.trim(), stockSqlBuf.toString());
			
			
		}
		return stockSqlBuf.toString();
	}
	private String checkNull(String str)
	{
		if(str == null)
		{
			str ="";
		}
		return str.trim();
	}


public String populateWorkOrderBill(Connection conn,String campgnNo) throws Exception
{
		System.out.println("@@in populateWorkOrderBill------->>"+workOrderBeanList.size());
		displayStkBean("");
		ResultSet rs = null;
		PreparedStatement pstmt = null,pstmt1 = null;
		String sql ="",workOrder = "",expLevel = "",mfgItemCode = "",unitRef = "",WoBillSql = "";
		ArrayList<String> worderList = new ArrayList<String>();
		HashMap<String,Double> worderExpMap= new HashMap<String,Double>();
		try
		{
			WoBillSql = "insert into workorder_bill (work_order,operation,exp_lev,item_code__ref,unit__ref,ref_qty,item_code,quantity,unit,"//9
					+ "alloc_qty,alloc_date,site_code,chg_date,chg_user,chg_term,line_type,crit_item,"//17
					+ "match_potency,min_potency_perc,adj_potency,potency_adj,usage_type,allocate_type,"//23
					+ "loc_usage_type,consider_lot_no__issue,unit__alt,conv__qty__alt,quantity__alt,lead_time,req_date,"//30
					+ "quantity__std ) values ( ?,?,?,?,?,?,?,?,?,?,   ?,?,?,?,?,?,?,?,?,?,"
					+ " ?,?,?,?,?,?,?,?,?,?,  ?)";
			int count = 0;
			if(workOrderBeanList.size() > 0)
			{
				for(WorkOrderDetailBean wOrderBillObj:workOrderBeanList)
				{
					//populate work order bill
					System.out.println("populateWorkOrderBill----------------->>"+(++count));
					System.out.println("WorkOrder12----------------->>"+wOrderBillObj.getWorkOrder());
					workOrder = wOrderBillObj.getWorkOrder();
					expLevel = wOrderBillObj.getExpLev();
					System.out.println("Bill creation wOrderBillObj->WorkOrder["+wOrderBillObj.getWorkOrder()+"]  ExpLev["+wOrderBillObj.getExpLev()+"] ItemCode["+wOrderBillObj.getItemCode()+"]SiteCode["+wOrderBillObj.getSiteCode()+"] Quantity["+wOrderBillObj.getQuantity()+"] Sufficient["+wOrderBillObj.getSufficient()+"] Operation["+wOrderBillObj.getOperation()+"] AllocateType["+wOrderBillObj.getAllocateType()+"] getAdjPotency ["+wOrderBillObj.getAdjPotency()+"] MatchPotency["+wOrderBillObj.getMatchPotency()+"] Crit Item["+wOrderBillObj.getCritItem()+"] ConsiderPartialAlt["+wOrderBillObj.getConsiderPartialAlt()+"] ConsiderLotNoIssue["+wOrderBillObj.getConsiderLotNoIssue()+"] MinPotencyPerc["+wOrderBillObj.getMinPotencyPerc()+"] QtyPer["+wOrderBillObj.getQtyPer()+"]getSuppCodeMfg["+wOrderBillObj.getSuppCodeMfg()+"] GetSufficient["+wOrderBillObj.getSufficient()+"] ReqQuantity["+wOrderBillObj.getReqQty()+"] getPotencyAdjQty["+wOrderBillObj.getPotencyAdjQty()+"] getItemCategory["+wOrderBillObj.getItemCategory()+"] getMinReqQty["+wOrderBillObj.getMinReqQty()+"] BatchNo["+wOrderBillObj.getBatchQty()+"] getRoundTo["+wOrderBillObj.getRoundTo()+"] getRound["+wOrderBillObj.getRound()+"] LocationUsageType["+wOrderBillObj.getLocUsageType()+"] ItemActive["+wOrderBillObj.getItemActive()+" AdjustedQuantity["+wOrderBillObj.getAdjustedQty()+"] UpdQuantity["+wOrderBillObj.getUpdQty()+"] LineType["+wOrderBillObj.getLineType()+"] QuantityRef["+wOrderBillObj.getQuantityRef()+"] UsageType["+wOrderBillObj.getUsageType()+"]");

					String sql1 = "select item_code,unit from workorder where work_order = ?";
					pstmt = conn.prepareStatement(sql1);
					pstmt.setString(1, workOrder);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						mfgItemCode = rs.getString(1);
						unitRef = rs.getString(2);
					}
					if(rs !=null)
					{
						rs.close();rs = null;
					}
					if(pstmt !=null)
					{
						pstmt.close();pstmt = null;
					}

					if(! worderList.contains(wOrderBillObj.getWorkOrder()))
					{
						updateWorkorderStatus(workOrder,conn);
						pstmt = conn.prepareStatement(WoBillSql);
						pstmt.setString(1, workOrder);
						pstmt.setInt(2, 0);
						pstmt.setString(3, "1.");
						pstmt.setString(4,mfgItemCode );
						pstmt.setString(5, unitRef);
						pstmt.setDouble(6, wOrderBillObj.getBatchQty()); //ref_qty

						pstmt.setString(7,mfgItemCode);
						pstmt.setDouble(8, wOrderBillObj.getBatchQty());//quantity
						pstmt.setString(9, unitRef);
						pstmt.setDouble(10, 0); // allocate quantity
						pstmt.setTimestamp(11, getCurrtDate(campgnNo)); //alloc_date
						pstmt.setString(12, wOrderBillObj.getSiteCode());//site_code
						pstmt.setTimestamp(13, getCurrtDate(campgnNo));//chg_date
						pstmt.setString(14, chgUser);//get from xtraParam chgUser
						pstmt.setString(15, termId);//get from xtraParam  termId
						pstmt.setString(16, wOrderBillObj.getLineType()); //line_type

						pstmt.setString(17,null); //crit_item
						pstmt.setString(18, null); //match_potency
						pstmt.setDouble(19, 0);//min_potency_perc
						pstmt.setString(20, null); //adj_potency
						pstmt.setDouble(21, 0);//potency_adj

						//pstmt.setDouble(22, wOrderBillObj.getPotencyAdjQty());//iss_qty
						//pstmt.setDouble(22, wOrderBillObj.getQuantity()); //iss_qty
						pstmt.setString(22, null);

						pstmt.setString(23, wOrderBillObj.getAllocateType());
						pstmt.setString(24, wOrderBillObj.getLocUsageType());
						pstmt.setString(25, wOrderBillObj.getConsiderLotNoIssue());
						pstmt.setString(26, null);//unit__alt
						pstmt.setDouble(27, 0);//conv__qty__alt
						pstmt.setDouble(28, 0); //quantity__alt
						pstmt.setInt(29, 0);//lead_time
						pstmt.setTimestamp(30, getCurrtDate(campgnNo));
						pstmt.setDouble(31, 0); //quantity__std

						pstmt.executeUpdate();

						if(pstmt !=null)
						{
							pstmt.close();pstmt = null;
						}

						worderList.add(wOrderBillObj.getWorkOrder());
						String str = new WorkOrderRoute().createWorderRoute(wOrderBillObj.getWorkOrder(), conn);
						System.out.println("return string from WorkOrderRoute------>>["+str+"]") ;
					}

					//Changed by wasim on 05-04-2016 to insert for usage type other than R [START]
					System.out.println("Usage type["+wOrderBillObj.getUsageType()+"]");
					// 09-jun-16 manoharan bill has to be created always for both usage_type O and R
					//if(!"R".equalsIgnoreCase(wOrderBillObj.getUsageType()))
					//{
						pstmt = conn.prepareStatement(WoBillSql);
						pstmt.setString(1, workOrder);
						pstmt.setInt(2, wOrderBillObj.getOperation());
						pstmt.setString(3, wOrderBillObj.getExpLev());
						pstmt.setString(4,wOrderBillObj.getItemRef());
						pstmt.setString(5, wOrderBillObj.getUnit());
						pstmt.setDouble(6, wOrderBillObj.getBatchQty()); //ref_qty

						pstmt.setString(7,wOrderBillObj.getItemCode());
						pstmt.setDouble(8, wOrderBillObj.getQuantity());//quantity
						pstmt.setString(9, unitRef);
						pstmt.setDouble(10, 0); // allocate quantity
						pstmt.setTimestamp(11, getCurrtDate(campgnNo)); //alloc_date
						pstmt.setString(12, wOrderBillObj.getSiteCode());//site_code
						pstmt.setTimestamp(13, getCurrtDate(campgnNo));//chg_date
						pstmt.setString(14, chgUser);//get from xtraParam chgUser
						pstmt.setString(15, termId);//get from xtraParam  termId
						pstmt.setString(16, wOrderBillObj.getLineType()); //line_type

						pstmt.setString(17,null); //crit_item
						pstmt.setString(18, null); //match_potency
						pstmt.setDouble(19, 0);//min_potency_perc
						pstmt.setString(20, null); //adj_potency
						pstmt.setDouble(21, 0);//potency_adj

						//pstmt.setDouble(22, wOrderBillObj.getPotencyAdjQty());//iss_qty
						//pstmt.setDouble(22, wOrderBillObj.getQuantity()); //iss_qty
						pstmt.setString(22, null);

						pstmt.setString(23, wOrderBillObj.getAllocateType());
						pstmt.setString(24, wOrderBillObj.getLocUsageType());
						pstmt.setString(25, wOrderBillObj.getConsiderLotNoIssue());
						pstmt.setString(26, null);//unit__alt
						pstmt.setDouble(27, 0);//conv__qty__alt
						pstmt.setDouble(28, 0); //quantity__alt
						pstmt.setInt(29, 0);//lead_time
						pstmt.setTimestamp(30, getCurrtDate(campgnNo));
						pstmt.setDouble(31, 0); //quantity__std

						pstmt.executeUpdate();

						if(pstmt !=null)
						{
							pstmt.close();pstmt = null;
						}
						System.out.println("worderExpMap------before >>["+worderExpMap+"]");
						worderExpMap.put(workOrder+":"+expLevel, wOrderBillObj.getQuantity());
						System.out.println("worderExpMap------after >>["+worderExpMap+"]");
						

					//}
					//Changed by wasim on 05-04-2016 to insert for usage type other than R [END]

					for(WorderStkBean tempObj : worderStkBeanList)
					{
						System.out.println("For item Code work Order bill"+tempObj.getItemCode());

						System.out.println("workOrder------>>["+workOrder+"] workOrderDetail : ["+tempObj.getWorkOrder()+"]") ;
						System.out.println("expLevel------>>["+expLevel+"] expLevelDetail : ["+tempObj.getExpLevel()+"]") ;
						System.out.println("UpdQty------>>["+tempObj.getUpdQty()+"]  AllocQty : ["+tempObj.getAllocQty()+"]") ;
						System.out.println("QtyAdj------>>["+tempObj.getQtyAdj()+"] PotencyAdj: ["+tempObj.getPotencyAdj()+"]") ;
						if(workOrder.equalsIgnoreCase(tempObj.getWorkOrder()) && expLevel.equalsIgnoreCase(tempObj.getExpLevel()))
						{
							System.out.println("worderExpMap------>>["+worderExpMap+"]");
							if(worderExpMap.containsKey(workOrder+":"+expLevel))
							{
								sql = " update workorder_bill set alloc_qty = (case when alloc_qty is null then 0 else alloc_qty end) + ?, "
									+ " potency_adj = (case when potency_adj is null then 0 else potency_adj end) + ? "
									+ " where work_order = ? and operation = ? and exp_lev = ?";
								pstmt1 = conn.prepareStatement(sql);
								pstmt1.setDouble(1, tempObj.getAllocQty());
								pstmt1.setDouble(2, tempObj.getPotencyAdj());
								pstmt1.setString(3, workOrder);
								pstmt1.setInt(4, wOrderBillObj.getOperation());
								pstmt1.setString(5, expLevel);
								int i = pstmt1.executeUpdate();
								System.out.println("pstmt1 is update....................."+i);
								if(pstmt1 !=null)
								{
									pstmt1.close();
									pstmt1 = null;
								}
							}
							else
							{
								pstmt1 = conn.prepareStatement(WoBillSql);
								pstmt1.setString(1, workOrder);
								pstmt1.setInt(2, wOrderBillObj.getOperation());
								pstmt1.setString(3, expLevel);
								pstmt1.setString(4,tempObj.getItemRef() );//item_code__ref
								pstmt1.setString(5, unitRef);//unit_ref
								pstmt1.setDouble(6, wOrderBillObj.getBatchQty()); //ref_qty

								pstmt1.setString(7, tempObj.getItemCode());
								pstmt1.setDouble(8, wOrderBillObj.getQuantity()); //quantity
								pstmt1.setString(9, tempObj.getUnit());
								if("Y".equalsIgnoreCase(tempObj.getOtherSiteYN()))
								{
									pstmt1.setDouble(10, 0); //alloc_qty
								}
								else
								{
									pstmt1.setDouble(10, tempObj.getAllocQty()); //alloc_qty
								}
								pstmt1.setTimestamp(11, getCurrtDate(campgnNo)); //alloc_date
								pstmt1.setString(12, wOrderBillObj.getSiteCode());//site_code
								pstmt1.setTimestamp(13, getCurrtDate(campgnNo));//chg_date
								pstmt1.setString(14, chgUser);//get from xtraParam chgUser
								pstmt1.setString(15, termId);//get from xtraParam  termId
								pstmt1.setString(16, wOrderBillObj.getLineType()); //line_type

								pstmt1.setString(17, wOrderBillObj.getCritItem()); //crit_item
								pstmt1.setString(18, wOrderBillObj.getMatchPotency()); //match_potency
								pstmt1.setDouble(19, wOrderBillObj.getMinPotencyPerc());//min_potency_perc
								pstmt1.setString(20, wOrderBillObj.getAdjPotency()); //adj_potency
								pstmt1.setDouble(21, tempObj.getQtyAdj());//potency_adj

								//pstmt.setDouble(22, wOrderBillObj.getPotencyAdjQty());//iss_qty
								//pstmt1.setDouble(22, 0); //iss_qty
								pstmt1.setString(22, wOrderBillObj.getUsageType());

								pstmt1.setString(23, wOrderBillObj.getAllocateType());
								
								pstmt1.setString(24, wOrderBillObj.getLocUsageType());
								pstmt1.setString(25, wOrderBillObj.getConsiderLotNoIssue());
								pstmt1.setString(26, wOrderBillObj.getUnit());//unit__alt
								pstmt1.setDouble(27, 1);//conv__qty__alt
								pstmt1.setDouble(28, wOrderBillObj.getQuantity()); //quantity__alt
								pstmt1.setInt(29, 0);//lead_time
								pstmt1.setTimestamp(30, getCurrtDate(campgnNo));
								pstmt1.setDouble(31, wOrderBillObj.getQuantity()); //quantity__std

								int i = pstmt1.executeUpdate();
								worderExpMap.put(workOrder+":"+expLevel, tempObj.getAllocQty());
								System.out.println("pstmt1 is null....................."+i);
								if(pstmt !=null)
								{
									pstmt.close();
									pstmt = null;
								}
							}

						}
					}
					/*if(pstmt1 != null)
					{
						int rows [] = pstmt1.executeBatch();
					    System.out.println("Rows---->>"+rows.length);
					}
					else
					{
						System.out.println("pstmt1 is null.....................");
					}*/


				}
				/*int rows [] = pstmt.executeBatch();
				if(rows.length > 0)
					return "Success";*/

			}


		}
		catch(Exception e)
		{
			e.printStackTrace();
			writeWorkOrderLog(e.toString(),campgnNo);//TODO
			throw new Exception(e);
		}
		finally
		{
			if(pstmt !=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(pstmt1 !=null)
			{
				pstmt1.close();
				pstmt1 = null;
			}
			if(rs !=null)
			{
				rs.close();
				rs = null;
			}
		}
		return "";
	}
	//Allocation Stock -- inv_allocate,inv_alloc_det

	@SuppressWarnings({ "rawtypes", "unchecked" })
	public String insertInInvAllocate(Connection conn,String campgnNo) throws Exception, ITMException
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null,pstmtSel = null ;
		String sql = "",tranIDInvAlloc = "",errorString = "";
		int lineNo = 0;
		double deAllocQty = 0;
		HashMap invAllocateMap = null;
		InvAllocTraceBean invAllocTrace = null;
		HashMap<String,String> tranIDWorderMap = new HashMap<String,String> ();

		try
		{
			System.out.println("in insertInInvAllocate.....................");
			displayStkBean("D");

			System.out.println("inside insertInInvAllocate size="+worderStkBeanList.size());

			for(WorderStkBean WorderStkBeanObj : worderStkBeanList)
			{
				
				System.out.println("Going for item code["+WorderStkBeanObj.getItemCode()+"] and alloc quantity ["+WorderStkBeanObj.getAllocQty()+"]");
				
				if(WorderStkBeanObj.getCritItem().equalsIgnoreCase("Y")){
				// 31-may-16 manoharan in case of partial reserve and additional allocation from same lot to be taken care off
				//if("Y".equalsIgnoreCase(WorderStkBeanObj.getReserveStk()))
				//{
					//line no set in checkReser..Stk method for unique update.
					/* 20-may-16 manoharan commented this has to be done at the time of taking reserve stock
					sql = "update inv_alloc_det set dealloc_qty = (case when dealloc_qty is null then 0 else dealloc_qty end) + ? where tran_id = ? and "
							//+ "lot_no = ?  and lot_sl = ? and site_code = ? and loc_code = ? and item_code = ?";
							+ "line_no = ?";
					pstmt = conn.prepareStatement(sql);
					System.out.println("stock qty : "+WorderStkBeanObj.getStkQuantity());
					System.out.println("stock qty new: "+WorderStkBeanObj.getStkQuantityNew());
					System.out.println("stock qty : "+WorderStkBeanObj.getUpdQty());
					pstmt.setDouble(1, WorderStkBeanObj.getStkQuantity());
					pstmt.setString(2,WorderStkBeanObj.getReserveStkTranId());
					pstmt.setInt(3,WorderStkBeanObj.getReserveLineNo());

					int i = pstmt.executeUpdate();
					System.out.println("inv_alloc_det rows updated....................."+i);
					if(pstmt !=null)
					{
						pstmt.close();pstmt = null;
					} */
				//}
				//else
				//{
					sql = "SELECT ALLOC_QTY FROM STOCK  where item_code = ? and site_code = ? and loc_code  = ? "
							+" and lot_no = ? and lot_sl = ?  ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,WorderStkBeanObj.getItemCode());
					pstmt.setString(2,WorderStkBeanObj.getSiteCode());
					pstmt.setString(3,WorderStkBeanObj.getLocCode());
					pstmt.setString(4,WorderStkBeanObj.getLotNo());
					pstmt.setString(5,WorderStkBeanObj.getLotSl());
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						System.out.println("AllocQty@@-------->>"+rs.getDouble(1));
					}
					if(pstmt !=null)
					{
						pstmt.close();pstmt = null;
					}
					if(rs !=null)
					{
						rs.close();rs = null;
					}

					sql = "select alloc_qty from stock where item_code = ? and site_code = ? and loc_code  = ? "
						  +" and lot_no = ? and lot_sl = ? for update nowait";
					pstmtSel = conn.prepareStatement(sql);
					pstmtSel.setString(1,WorderStkBeanObj.getItemCode());
					pstmtSel.setString(2,WorderStkBeanObj.getSiteCode());
					pstmtSel.setString(3,WorderStkBeanObj.getLocCode());
					pstmtSel.setString(4,WorderStkBeanObj.getLotNo());
					pstmtSel.setString(5,WorderStkBeanObj.getLotSl());
					rs = pstmtSel.executeQuery();
					if(rs.next())
					{
						System.out.println("Allocated quantity is ="+rs.getDouble(1));

						sql = "UPDATE STOCK SET ALLOC_QTY =(CASE WHEN ALLOC_QTY IS NULL THEN 0 ELSE ALLOC_QTY END) + ?"
								+" where item_code = ? and site_code = ? and loc_code  = ? "
								+" and lot_no = ? and lot_sl = ?  ";

						//deAllocQty = WorderStkBeanObj.getActualAllocQty() ;//wasim
						// 31-may-16 manoharan reserve is already allocated
						//deAllocQty = WorderStkBeanObj.getAllocQty();
						deAllocQty = Double.parseDouble(df.format(WorderStkBeanObj.getAllocQty() - WorderStkBeanObj.getReserveStkQty()));
						System.out.println("deAllocQty :["+deAllocQty+"]");
						// 03-jun-16 manoharan not to multiply with -1
						//deAllocQty = Double.parseDouble(df.format(deAllocQty)) * -1;
						deAllocQty = Double.parseDouble(df.format(deAllocQty));
						System.out.println("After deAllocQty :["+deAllocQty+"]");
						pstmt = conn.prepareStatement(sql);
						// 03-jun-16 manoharan during update multiply with -1 so that allocation will be proper
						//pstmt.setDouble(1,deAllocQty);
						pstmt.setDouble(1,(deAllocQty  * -1));

						pstmt.setString(2,WorderStkBeanObj.getItemCode());
						pstmt.setString(3,WorderStkBeanObj.getSiteCode());
						pstmt.setString(4,WorderStkBeanObj.getLocCode());
						pstmt.setString(5,WorderStkBeanObj.getLotNo());
						pstmt.setString(6,WorderStkBeanObj.getLotSl());
						int i = pstmt.executeUpdate();
						System.out.println("STOCK rows updated....................."+i);
						if(pstmt !=null)
						{
							pstmt.close();pstmt = null;
						}

						invAllocateMap = new HashMap();
						invAllocTrace = new InvAllocTraceBean();
						invAllocateMap.put("tran_date",getCurrtDate(campgnNo));
						invAllocateMap.put("ref_ser","W-ORD");// Discuss
						invAllocateMap.put("ref_id",WorderStkBeanObj.getWorkOrder());
						invAllocateMap.put("ref_line", "" + lineNo);
						invAllocateMap.put("site_code",WorderStkBeanObj.getSiteCode());
						invAllocateMap.put("item_code",WorderStkBeanObj.getItemCode());

						invAllocateMap.put("loc_code", WorderStkBeanObj.getLocCode());

						invAllocateMap.put("lot_no",WorderStkBeanObj.getLotNo());
						invAllocateMap.put("lot_sl",WorderStkBeanObj.getLotSl());
						//invAllocateMap.put("alloc_qty", WorderStkBeanObj.getActualAllocQty());//wasim
						// 31-may-16 manoharan reserve is already allocated
						//invAllocateMap.put("alloc_qty", WorderStkBeanObj.getAllocQty());
						invAllocateMap.put("alloc_qty", deAllocQty);
						invAllocateMap.put("chg_user",chgUser);
						invAllocateMap.put("chg_term",termId);
						invAllocateMap.put("chg_win","w_woFirmplan");
						if (deAllocQty != 0)
						{
							errorString = invAllocTrace.updateInvallocTrace(invAllocateMap, conn);
							System.out.println("After updateInvallocTrace errorString :["+errorString+"]");
						}
					}
					else
					{
						System.out.println("Erorr in select");
					}
					if(pstmtSel !=null)
					{
						pstmtSel.close();pstmtSel = null;
					}
					if(rs !=null)
					{
						rs.close();rs = null;
					}
				//}


				if(! tranIDWorderMap.containsKey(WorderStkBeanObj.getWorkOrder()))
				{
					tranIDInvAlloc = generateTranTd("w_inv_allocate","",WorderStkBeanObj.getSiteCode(),conn,campgnNo);	//put site
					tranIDWorderMap.put(WorderStkBeanObj.getWorkOrder(),tranIDInvAlloc);
					sql = "Insert into inv_allocate (tran_id,tran_date,tran_type,work_order,site_code,item_code,chg_date,chg_user,"
							+ "chg_term,remarks,confirmed,conf_date,status,status_date)"
							+ " values (?,?,?,?,?, ?,?,?,?,?, ?,?,?,?)";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,tranIDInvAlloc);
					pstmt.setTimestamp(2, getCurrtDate(campgnNo));
					pstmt.setString(3,"AUT");//TRAN_TYPE discuss with sir
					pstmt.setString(4,WorderStkBeanObj.getWorkOrder());
					pstmt.setString(5,WorderStkBeanObj.getSiteCode());

					pstmt.setString(6,getColumnDescr(conn, "ITEM_CODE", "WORKORDER", "WORK_ORDER", WorderStkBeanObj.getWorkOrder(),campgnNo));
					pstmt.setTimestamp(7, getCurrtDate(campgnNo));
					pstmt.setString(8,chgUser);
					pstmt.setString(9,termId);
					pstmt.setString(10,"Auto Reserve from firmplan");//remarks
					pstmt.setString(11,"Y");//confirmed

					pstmt.setTimestamp(12, getCurrtDate(campgnNo));
                    pstmt.setString(13,"O");//status
                    pstmt.setTimestamp(14, getCurrtDate(campgnNo));

					int updResult = pstmt.executeUpdate();
					System.out.println("After insert inv_allocate = "+updResult);
					if(pstmt !=null)
					{
						pstmt.close();pstmt = null;
					}

					// confirmed and status date not set.
				}
				sql = "select  CASE WHEN max(line_no) IS NULL THEN 0 ELSE max(line_no) END from inv_alloc_det where tran_id = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranIDWorderMap.get(WorderStkBeanObj.getWorkOrder() ));
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					lineNo = rs.getInt(1);
				}
				if(rs !=null)
				{
					rs.close();rs = null;
				}
				if(pstmt !=null)
				{
					pstmt.close();pstmt = null;
				}
				sql = "Insert into inv_alloc_det (TRAN_ID,LINE_NO,SITE_CODE,ITEM_CODE,LOT_NO,LOT_SL,QUANTITY,REMARKS,"
						+ "LOC_CODE,EXP_LEV,POTENCY_ADJ,ALLOC_QTY) "
						+ "values (?,?,?,?,?, ?,?,?,?,?, ?,? )";
				if (!"Y".equals(WorderStkBeanObj.getOtherSiteYN()))
				{
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,tranIDWorderMap.get(WorderStkBeanObj.getWorkOrder()));
					pstmt.setInt(2, ++lineNo);
					pstmt.setString(3,WorderStkBeanObj.getSiteCode());
					pstmt.setString(4,WorderStkBeanObj.getItemCode());//discuss with sir (Pending)
					pstmt.setString(5,WorderStkBeanObj.getLotNo());
					pstmt.setString(6,WorderStkBeanObj.getLotSl());
					pstmt.setDouble(7, WorderStkBeanObj.getQuantity());
					pstmt.setString(8,"Auto Reserve");//remarks
					pstmt.setString(9, WorderStkBeanObj.getLocCode());//loc_code
					pstmt.setString(10, WorderStkBeanObj.getExpLevel());//EXP_LEV
					pstmt.setDouble(11, WorderStkBeanObj.getQtyAdj());
					pstmt.setDouble(12, WorderStkBeanObj.getAllocQty());//ALLOC_QTY check actual quantity (Pending)

					System.out.println("Before Update of inv allocate det");
					pstmt.executeUpdate();
					if(pstmt !=null)
					{
						pstmt.close();pstmt = null;
					}
				}

				// invAlloc trace start


				//incAlloc trace End

				//inv_alloc_det




				//add batch and executeBatch

			}
		}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			writeWorkOrderLog(e.toString(),campgnNo);//TODO
			throw new Exception(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		return "";
	}
	//public String InsertCrossDockAlloc(Map<String,String> sorderDetailMap, Connection conn) throws Exception, ITMException
	//public String InsertCrossDockAlloc(String transTran,String siteCodeShip,String siteCodeDlv,Connection conn) throws Exception, ITMException
	@SuppressWarnings("rawtypes")
	public String InsertCrossDockAlloc(String transTran,String siteCodeShip,String siteCodeDlv,String orderNo,Connection conn,String campgnNo) throws Exception, ITMException
	{
		PreparedStatement pstmt = null;
		String sql = "",tranId = "";
		campgnNoGlb = checkNull(campgnNoGlb);
		int lineNo = 0;
		boolean headerFlag = true;
		SiteItemSummaryBean siteItemSummaryObj = null;
		ArrayList stkList = null;
		HashMap siteItemMap = null;
		String itemCode = "",lotNo = "",lotSl = "",locCode = "",siteCode = "",lineNoOrder = "";
		double allocQty = 0;
		try
		{
		
			System.out.println("Inside cross dock ::Trans Tran["+transTran+"] Site code Ship["+siteCodeShip+"] Site Code Dlv ["+siteCodeDlv+"] OrderNo["+orderNo+"]");
			tranId = generateTranTd("w_cross_dock_alloc","",siteCodeShip,conn,campgnNo);
			
			//for(SiteItemSummaryBean siteItemSummaryObj : siteItemReqQtyList)
			System.out.println("outer loop size::: " + siteItemReqQtyList.size());
			System.out.println("outer loop details::: " + siteItemReqQtyList.toString());
			
			for(int siteCtr =0 ; siteCtr < siteItemReqQtyList.size() ; siteCtr++)
			{
				siteItemSummaryObj = (SiteItemSummaryBean) siteItemReqQtyList.get(siteCtr);
				stkList = siteItemSummaryObj.getStockList();
				
				  if((siteItemSummaryObj.getTransTran().equalsIgnoreCase(transTran)) && 
						(siteItemSummaryObj.getSiteCodeShip().equalsIgnoreCase(siteCodeShip)) && 
						(siteItemSummaryObj.getSiteCode().equalsIgnoreCase(siteCodeDlv)))
				{
					System.out.println("Stock List size in cross Dock:::"+stkList.size());
					System.out.println("Stock List details in cross dock::"+stkList.toString());
					
					for(int innersiteCtr =0 ; innersiteCtr < stkList.size() ; innersiteCtr++)
					{
						 siteItemMap = (HashMap) stkList.get(innersiteCtr);
						 itemCode = (String) siteItemMap.get("ITEM_CODE");
						 locCode = (String) siteItemMap.get("LOC_CODE");
						 lotNo = (String) siteItemMap.get("LOT_NO");
						 lotSl = (String) siteItemMap.get("LOT_SL");
						 siteCode = (String) siteItemMap.get("SITE_CODE");
						 allocQty = Double.parseDouble((siteItemMap.get("QUANTITY").toString()));
						 lineNoOrder = siteItemSummaryObj.getLineNoOrder();
						 
						 System.out.println("Line Number order ["+lineNoOrder+"]");
						System.out.println("TransTran["+transTran+"]=["+siteItemSummaryObj.getTransTran()+"]");
						System.out.println("SiteCodeShip["+siteCodeShip+"]=["+siteItemSummaryObj.getSiteCodeShip()+"]");
						System.out.println("SiteCodeDlv["+siteCodeDlv+"]=["+siteItemSummaryObj.getSiteCode()+"]");
						
						System.out.println("SiteCodeDlv["+siteCodeDlv+"]=["+siteItemSummaryObj.getSiteCode()+"]");
							
							System.out.println("Header Flag="+headerFlag);
							if(headerFlag)
							{	
								sql = "Insert into cross_dock_alloc (tran_id,tran_date,ref_no,site_code,site_code__ship,transfer_type,asn_no, "
										+ "add_user,add_date,add_term,chg_user,chg_date,chg_term ) values ( ?,?,?,?,?, ?,?,?,?,?, ?,?,? ) ";
			
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, tranId); //generate tran id
								pstmt.setTimestamp(2, getCurrtDate(campgnNo));
								pstmt.setString(3, campgnNoGlb.length() == 0 ? siteItemSummaryObj.getWorkOrder() : campgnNoGlb); //check header value WorkOrder or complain number
								pstmt.setString(4, siteItemSummaryObj.getSiteCode()); 
								pstmt.setString(5, siteItemSummaryObj.getSiteCodeShip());
								pstmt.setString(6, siteItemSummaryObj.getTransTran());// transfer_type please confirmed with sir.
								pstmt.setString(7, "");//asn please confirmed with sir.
								pstmt.setString(8,chgUser);
								pstmt.setTimestamp(9, getCurrtDate(campgnNo));
								pstmt.setString(10,termId);
								pstmt.setString(11,chgUser);
								pstmt.setTimestamp(12, getCurrtDate(campgnNo));
								pstmt.setString(13,termId);
								pstmt.executeUpdate();
								pstmt.close();
								pstmt = null;
							}
							for(WorderStkBean WorderStkBeanObj : worderStkBeanList)
							{
								System.out.println("Required qty["+WorderStkBeanObj.getAllocQty()+"]");
								System.out.println("Quantity to be set in cross dock alloc:::" + allocQty);
								System.out.println("Workorder item code:::" + WorderStkBeanObj.getItemCode());
								
								if((itemCode.equalsIgnoreCase(WorderStkBeanObj.getItemCode())) && 
								   (siteCode.equalsIgnoreCase(WorderStkBeanObj.getSiteCode())) &&
								   (lotNo.equalsIgnoreCase(WorderStkBeanObj.getLotNo())) &&
								   (lotSl.equalsIgnoreCase(WorderStkBeanObj.getLotSl())) &&
								   (locCode.equalsIgnoreCase(WorderStkBeanObj.getLocCode())))
							    {
										lineNo++;
										//sql = "Insert into cross_dock_alloc_det ( TRAN_ID,LINE_NO,ORDER_NO,EXP_LEV,ITEM_CODE,"
										  sql = "Insert into cross_dock_alloc_det ( TRAN_ID,LINE_NO,ORDER_NO,EXP_LEV,ITEM_CODE,"
												+ "SITE_CODE,LOC_CODE,LOT_NO,LOT_SL,QUANTITY,REQ_QTY,POTENCY_ADJ,ORDER_REF,LINE_NO__ORD) "
												+ "values (?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
				
										pstmt = conn.prepareStatement(sql);
										pstmt.setString(1, tranId); //generate tran id
										pstmt.setInt(2, lineNo);
										pstmt.setString(3, orderNo);
										pstmt.setString(4, WorderStkBeanObj.getExpLevel());
										pstmt.setString(5, WorderStkBeanObj.getItemCode());
										pstmt.setString(6, WorderStkBeanObj.getSiteCode());
										pstmt.setString(7, WorderStkBeanObj.getLocCode());
										pstmt.setString(8, WorderStkBeanObj.getLotNo());
										pstmt.setString(9, WorderStkBeanObj.getLotSl());
										pstmt.setDouble(10,allocQty );
										pstmt.setDouble(11,WorderStkBeanObj.getAllocQty() );
										pstmt.setDouble(12,WorderStkBeanObj.getQtyAdj() );
										pstmt.setString(13, WorderStkBeanObj.getWorkOrder());
										pstmt.setString(14,lineNoOrder);
										pstmt.executeUpdate();
										pstmt.close();pstmt = null;
							    }	
							}
							headerFlag = false;
						}
						//headerFlag = false;
					}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			writeWorkOrderLog(e.toString(),campgnNo);//TODO
			throw new Exception(e);
		}
		return "";
	}
	//Create sale order
	//In map put all key as column and values
	public String createSalesOrder(Map<String,String> sorderDetailMap, Connection conn,String campgnNo,String xtraParams) throws Exception, ITMException
	{
		String returnString = "";
		try
		{
			System.out.println(" -------------- Inside createSalesOrder method --------------------- ");
			StringBuffer valueXmlString;
			String xmlString = "";

			String pageContext = "", objContext = "", editFlag = "", focusedColumn = "", action = "", elementName = "", keyValue = "",
			taxKeyValue = "", saveLevel = "", forcedSave = "", taxInFocus = "", saleOrder = "", orderDate = "", orderType = "", custCode = "", custCodeDlv = "", custCodeBil = "", custNameBil = "", taxOpt = "",
			itemSeries = "", custPorder = "", salesPerson = "", taxClass = "", taxChap = "", taxEnv = "", taxDate = "", plDate = "", priceList = "",
			crTerm = "", siteCode = "", confirmed = "", currCode = "", dueDate = "", remarks = "", dlvAddress1 = "", dlvAddress2 = "", dlvCity = "",
			countCodeDlv = "", dlvPin = "", stanCode = "", partQty = "", status = "", stautsDate = "", consumeFc = "", tranCode = "",
			chgDate = "", chgUser = "", chgTerm = "", totAmt = "", udfStr1 = "", udfStr2 = "", dlvTerm = "", currCodeFrt = "", frtTerm = "", allocFlag = "",
			custName = "", empCodeOrd = "", porderDate = "", exchRate = "", ordAmt = "", taxAmt = "", udfNum1 = "", udfNum2 = "",
			frtAmt = "", transMode = "", rcpMode = "", stateCodeDlv = "", dlvAddress3 = "", orderMode = "", remarks2 = "", remarks3 = "", currCodeIns = "",
			exchRateIns = "", dlvTo = "", tel1Dlv = "", tel2Dlv = "", faxDlv = "", emailAddr = "", totOrdValue = "", siteCodeShip = "", chequeNo = "",
			chequeDate = "", pordMode = "", chequeAmt = "", chequeName = "", licenceNo1 = "", orderStatus = "", notifyTo = "", buyerName = "",
			singleLot = "", pendingOrder = "", netTotAmt = "", shipStatus = "", vendorTxCode = "", vpsTxId = "", securityKey = "", trnAmount = "",
			userRemarks = "", lineNo = "", itemFlag = "", quantity = "", dspDate = "", rate = "", discount = "", netAmt = "", itemDescr = "", itemCodeOrd = "",
			holdFlag = "";

			/*objName = (String)sorderDetailMap.get("OBJNAME");
			pageContext = (String)sorderDetailMap.get("PAGECONTEXT");
			objContext = (String)sorderDetailMap.get("OBJCONTEXT");
			editFlag = (String)sorderDetailMap.get("EDITFLAG");
			focusedColumn = (String)sorderDetailMap.get("FOCUSEDCOLUMN");
			action = (String)sorderDetailMap.get("ACTION");
			elementName = (String)sorderDetailMap.get("ELEMENTNAME");
			keyValue = (String)sorderDetailMap.get("KEYVALUE");
			taxKeyValue = (String)sorderDetailMap.get("TAXKEYVALUE");
			saveLevel = (String)sorderDetailMap.get("SAVELEVEL");
			forcedSave = (String)sorderDetailMap.get("FORCEDSAVE");
			taxInFocus = (String)sorderDetailMap.get("TAXINFOCUS");*/
			saleOrder = (String)sorderDetailMap.get("SALE_ORDER");
			orderDate = (String)sorderDetailMap.get("ORDER_DATE");
			orderType = (String)sorderDetailMap.get("ORDER_TYPE");
			custCode = (String)sorderDetailMap.get("CUST_CODE");
			custCodeDlv = (String)sorderDetailMap.get("CUST_CODE__DLV");
			custCodeBil = (String)sorderDetailMap.get("CUST_CODE__BIL");
			custNameBil = (String)sorderDetailMap.get("CUST_NAME__BIL");
			taxOpt = (String)sorderDetailMap.get("TAX_OPT");
			itemSeries = (String)sorderDetailMap.get("ITEM_SER");
			custPorder = (String)sorderDetailMap.get("CUST_PORD");
			salesPerson = (String)sorderDetailMap.get("SALES_PERS");
			taxClass = (String)sorderDetailMap.get("TAX_CLASS");
			taxChap = (String)sorderDetailMap.get("TAX_CHAP");
			taxEnv = (String)sorderDetailMap.get("TAX_ENV");
			taxDate = (String)sorderDetailMap.get("TAX_DATE");
			plDate = (String)sorderDetailMap.get("PL_DATE");
			priceList = (String)sorderDetailMap.get("PRICE_LIST");
			priceList = priceList==null?"":priceList.trim();
			crTerm = (String)sorderDetailMap.get("CR_TERM");
			siteCode = (String)sorderDetailMap.get("SITE_CODE");
			confirmed = (String)sorderDetailMap.get("CONFIRMED");
			currCode = (String)sorderDetailMap.get("CURR_CODE");
			dueDate = (String)sorderDetailMap.get("DUE_DATE");
			remarks = (String)sorderDetailMap.get("REMARKS");
			dlvAddress1 = (String)sorderDetailMap.get("DLV_ADD1");
			dlvAddress2 = (String)sorderDetailMap.get("DLV_ADD2");
			dlvCity = (String)sorderDetailMap.get("DLV_CITY");
			countCodeDlv = (String)sorderDetailMap.get("COUNT_CODE__DLV");
			dlvPin = (String)sorderDetailMap.get("DLV_PIN");
			stanCode = (String)sorderDetailMap.get("STAN_CODE");
			partQty = (String)sorderDetailMap.get("PART_QTY");
			status = (String)sorderDetailMap.get("STATUS");
			stautsDate = (String)sorderDetailMap.get("STATUS_DATE");
			consumeFc = (String)sorderDetailMap.get("CONSUME_FC");
			tranCode = (String)sorderDetailMap.get("TRAN_CODE");
			chgDate = (String)sorderDetailMap.get("CHG_DATE");
			chgUser = (String)sorderDetailMap.get("CHG_USER");
			chgTerm = (String)sorderDetailMap.get("CHG_TERM");
			totAmt = (String)sorderDetailMap.get("TOT_AMT");
			udfStr1 = (String)sorderDetailMap.get("UDF__STR1");
			udfStr2 = (String)sorderDetailMap.get("UDF__STR2");
			dlvTerm = (String)sorderDetailMap.get("DLV_TERM");
			currCodeFrt = (String)sorderDetailMap.get("CURR_CODE__FRT");
			frtTerm = (String)sorderDetailMap.get("FRT_TERM");
			allocFlag = (String)sorderDetailMap.get("ALLOC_FLAG");
			custName = (String)sorderDetailMap.get("CUST_NAME");
			empCodeOrd = (String)sorderDetailMap.get("EMP_CODE__ORD");
			porderDate = (String)sorderDetailMap.get("PORD_DATE");
			exchRate = (String)sorderDetailMap.get("EXCH_RATE");
			ordAmt = (String)sorderDetailMap.get("ORD_AMT");
			taxAmt = (String)sorderDetailMap.get("TAX_AMT");
			udfNum1 = (String)sorderDetailMap.get("UDF__NUM1");
			udfNum2 = (String)sorderDetailMap.get("UDF__NUM2");
			frtAmt = (String)sorderDetailMap.get("FRT_AMT");
			transMode = (String)sorderDetailMap.get("TRANS_MODE");
			rcpMode = (String)sorderDetailMap.get("RCP_MODE");
			stateCodeDlv = (String)sorderDetailMap.get("STATE_CODE__DLV");
			dlvAddress3 = (String)sorderDetailMap.get("DLV_ADD3");
			orderMode = (String)sorderDetailMap.get("ORDER_MODE");
			remarks2 = (String)sorderDetailMap.get("REMARKS2");
			remarks3 = (String)sorderDetailMap.get("REMARKS3");
			currCodeIns = (String)sorderDetailMap.get("CURR_CODE__INS");
			exchRateIns = (String)sorderDetailMap.get("EXCH_RATE__INS");
			dlvTo = (String)sorderDetailMap.get("DLV_TO");
			tel1Dlv = (String)sorderDetailMap.get("TEL1__DLV");
			tel2Dlv = (String)sorderDetailMap.get("TEL2__DLV");
			faxDlv = (String)sorderDetailMap.get("FAX__DLV");
			emailAddr = (String)sorderDetailMap.get("EMAIL_ADDR");
			totOrdValue = (String)sorderDetailMap.get("TOT_ORD_VALUE");
			siteCodeShip = (String)sorderDetailMap.get("SITE_CODE__SHIP");
			chequeNo = (String)sorderDetailMap.get("CHEQUE_NO");
			chequeDate = (String)sorderDetailMap.get("CHEQUE_DATE");
			pordMode = (String)sorderDetailMap.get("PORD_MODE");
			chequeAmt = (String)sorderDetailMap.get("CHQ_AMOUNT");
			chequeName = (String)sorderDetailMap.get("CHQ_NAME");
			licenceNo1 = (String)sorderDetailMap.get("LICENCE_NO_1");
			orderStatus = (String)sorderDetailMap.get("ORDER_STATUS");
			notifyTo = (String)sorderDetailMap.get("NOTIFY_TO");
			buyerName = (String)sorderDetailMap.get("BUYER_NAME");
			singleLot = (String)sorderDetailMap.get("SINGLE_LOT");
			pendingOrder = (String)sorderDetailMap.get("PENDING_ORDER");
			netTotAmt = (String)sorderDetailMap.get("NET_TOT_AMT");
			shipStatus = (String)sorderDetailMap.get("SHIP_STATUS");
			vendorTxCode = (String)sorderDetailMap.get("VENDOR_TX_CODE");
			vpsTxId = (String)sorderDetailMap.get("VPS_TX_ID");
			securityKey = (String)sorderDetailMap.get("SECURITY_KEY");
			trnAmount = (String)sorderDetailMap.get("TRN_AMOUNT");
			userRemarks = (String)sorderDetailMap.get("USER_REMARKS");

			lineNo = (String)sorderDetailMap.get("LINE_NO");
			itemFlag = (String)sorderDetailMap.get("ITEM_FLG");
			quantity = (String)sorderDetailMap.get("QUANTITY");
			dspDate = (String)sorderDetailMap.get("DSP_DATE");
			rate = (String)sorderDetailMap.get("RATE");
			discount = (String)sorderDetailMap.get("DISCOUNT");
			netAmt = (String)sorderDetailMap.get("NET_AMT");
			itemDescr = (String)sorderDetailMap.get("ITEM_DESCR");
			itemCodeOrd = (String)sorderDetailMap.get("ITEM_CODE__ORD");
			holdFlag = (String)sorderDetailMap.get("HOLD_FLAG");

			valueXmlString = new StringBuffer( "<?xml version='1.0' encoding='ISO-8859-1'?>\r\n" );
			valueXmlString.append( "<DocumentRoot>\r\n" );
			valueXmlString.append( "<description>Datawindow Root</description>\r\n" );
			valueXmlString.append( "<group0>\r\n" );
			valueXmlString.append( "<description>Group0 description</description>\r\n" );
			valueXmlString.append( "<Header0>\r\n" );

			valueXmlString.append( "<objName><![CDATA[" ).append( "sorder" ).append( "]]></objName>\r\n" );
			valueXmlString.append( "<pageContext><![CDATA[" ).append( pageContext ).append( "]]></pageContext>\r\n" );
			valueXmlString.append( "<objContext><![CDATA[" ).append( objContext ).append( "]]></objContext>\r\n" );
			valueXmlString.append( "<editFlag><![CDATA[" ).append( editFlag ).append( "]]></editFlag>\r\n" );
			valueXmlString.append( "<focusedColumn><![CDATA[" ).append( focusedColumn ).append( "]]></focusedColumn>\r\n" );
			valueXmlString.append( "<action><![CDATA[" ).append( action ).append( "]]></action>\r\n" );
			valueXmlString.append( "<elementName><![CDATA[" ).append( elementName ).append( "]]></elementName>\r\n" );
			valueXmlString.append( "<keyValue><![CDATA[" ).append( keyValue ).append( "]]></keyValue>\r\n" );
			valueXmlString.append( "<taxKeyValue><![CDATA[" ).append( taxKeyValue ).append( "]]></taxKeyValue>\r\n" );
			valueXmlString.append( "<saveLevel><![CDATA[" ).append( saveLevel ).append( "]]></saveLevel>\r\n" );
			valueXmlString.append( "<forcedSave><![CDATA[" ).append( forcedSave ).append( "]]></forcedSave>\r\n" );
			valueXmlString.append( "<taxInFocus><![CDATA[" ).append( taxInFocus ).append( "]]></taxInFocus>\r\n" );
			valueXmlString.append( "<description>Header0 members</description>\r\n" );

			valueXmlString.append("<Detail1 objContext=\"1\" objName=\"sorder\" domID=\"1\" dbID=\"\" >\r\n");
			valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" />\r\n");

			valueXmlString.append( "<sale_order><![CDATA[" ).append( saleOrder ).append( "]]></sale_order>\r\n" );
			valueXmlString.append( "<order_date><![CDATA[" ).append( orderDate ).append( "]]></order_date>\r\n" );
			valueXmlString.append( "<order_type><![CDATA[" ).append( orderType ).append( "]]></order_type>\r\n" );
			valueXmlString.append( "<cust_code><![CDATA[" ).append( custCode ).append( "]]></cust_code>\r\n" );
			valueXmlString.append( "<cust_code__dlv><![CDATA[" ).append( custCodeDlv ).append( "]]></cust_code__dlv>\r\n" );
			valueXmlString.append( "<cust_code__bil><![CDATA[" ).append( custCodeBil ).append( "]]></cust_code__bil>\r\n" );
			valueXmlString.append( "<cust_name__bil><![CDATA[" ).append( custNameBil ).append( "]]></cust_name__bil>\r\n" );
			valueXmlString.append( "<tax_opt><![CDATA[" ).append( taxOpt ).append( "]]></tax_opt>\r\n" );
			valueXmlString.append( "<item_ser><![CDATA[" ).append( itemSeries ).append( "]]></item_ser>\r\n" );
			valueXmlString.append( "<cust_pord><![CDATA[" ).append( custPorder ).append( "]]></cust_pord>\r\n" );
			valueXmlString.append( "<sales_pers><![CDATA[" ).append( salesPerson ).append( "]]></sales_pers>\r\n" );
			valueXmlString.append( "<tax_class><![CDATA[" ).append( taxClass ).append( "]]></tax_class>\r\n" );
			valueXmlString.append( "<tax_chap><![CDATA[" ).append( taxChap ).append( "]]></tax_chap>\r\n" );
			valueXmlString.append( "<tax_env><![CDATA[" ).append( taxEnv ).append( "]]></tax_env>\r\n" );
			valueXmlString.append( "<tax_date><![CDATA[" ).append( taxDate ).append( "]]></tax_date>\r\n" );
			valueXmlString.append( "<pl_date><![CDATA[" ).append( plDate ).append( "]]></pl_date>\r\n" );
			valueXmlString.append( "<price_list><![CDATA[" ).append( priceList ).append( "]]></price_list>\r\n" );
			valueXmlString.append( "<cr_term><![CDATA[" ).append( crTerm ).append( "]]></cr_term>\r\n" );
			valueXmlString.append( "<site_code><![CDATA[" ).append( siteCode ).append( "]]></site_code>\r\n" );
			valueXmlString.append( "<confirmed><![CDATA[" ).append( confirmed ).append( "]]></confirmed>\r\n" );
			valueXmlString.append( "<curr_code><![CDATA[" ).append( currCode ).append( "]]></curr_code>\r\n" );
			valueXmlString.append( "<due_date><![CDATA[" ).append( dueDate ).append( "]]></due_date>\r\n" );
			valueXmlString.append( "<remarks><![CDATA[" ).append( remarks ).append( "]]></remarks>\r\n" );
			valueXmlString.append( "<dlv_add1><![CDATA[" ).append( dlvAddress1 ).append( "]]></dlv_add1>\r\n" );
			valueXmlString.append( "<dlv_add2><![CDATA[" ).append( dlvAddress2 ).append( "]]></dlv_add2>\r\n" );
			valueXmlString.append( "<dlv_city><![CDATA[" ).append( dlvCity ).append( "]]></dlv_city>\r\n" );
			valueXmlString.append( "<count_code__dlv><![CDATA[" ).append( countCodeDlv ).append( "]]></count_code__dlv>\r\n" );
			valueXmlString.append( "<dlv_pin><![CDATA[" ).append( dlvPin ).append( "]]></dlv_pin>\r\n" );
			valueXmlString.append( "<stan_code><![CDATA[" ).append( stanCode ).append( "]]></stan_code>\r\n" );
			valueXmlString.append( "<part_qty><![CDATA[" ).append( partQty ).append( "]]></part_qty>\r\n" );
			valueXmlString.append( "<status><![CDATA[" ).append( status ).append( "]]></status>\r\n" );
			valueXmlString.append( "<status_date><![CDATA[" ).append( stautsDate ).append( "]]></status_date>\r\n" );
			valueXmlString.append( "<consume_fc><![CDATA[" ).append( consumeFc ).append( "]]></consume_fc>\r\n" );
			valueXmlString.append( "<tran_code><![CDATA[" ).append( tranCode ).append( "]]></tran_code>\r\n" );
			valueXmlString.append( "<chg_date><![CDATA[" ).append( chgDate ).append( "]]></chg_date>\r\n" );
			valueXmlString.append( "<chg_user><![CDATA[" ).append( chgUser ).append( "]]></chg_user>\r\n" );
			valueXmlString.append( "<chg_term><![CDATA[" ).append( chgTerm ).append( "]]></chg_term>\r\n" );
			valueXmlString.append( "<tot_amt><![CDATA[" ).append( totAmt ).append( "]]></tot_amt>\r\n" );
			valueXmlString.append( "<udf__str1><![CDATA[" ).append( udfStr1 ).append( "]]></udf__str1>\r\n" );
			valueXmlString.append( "<udf__str2><![CDATA[" ).append( udfStr2 ).append( "]]></udf__str2>\r\n" );
			valueXmlString.append( "<dlv_term><![CDATA[" ).append( dlvTerm ).append( "]]></dlv_term>\r\n" );
			valueXmlString.append( "<curr_code__frt><![CDATA[" ).append( currCodeFrt ).append( "]]></curr_code__frt>\r\n" );
			valueXmlString.append( "<frt_term><![CDATA[" ).append( frtTerm ).append( "]]></frt_term>\r\n" );
			valueXmlString.append( "<alloc_flag><![CDATA[" ).append( allocFlag ).append( "]]></alloc_flag>\r\n" );
			valueXmlString.append( "<cust_name><![CDATA[" ).append( custName ).append( "]]></cust_name>\r\n" );
			valueXmlString.append( "<emp_code__ord><![CDATA[" ).append( empCodeOrd ).append( "]]></emp_code__ord>\r\n" );
			valueXmlString.append( "<pord_date><![CDATA[" ).append( porderDate ).append( "]]></pord_date>\r\n" );
			valueXmlString.append( "<exch_rate><![CDATA[" ).append( exchRate ).append( "]]></exch_rate>\r\n" );
			valueXmlString.append( "<ord_amt><![CDATA[" ).append( ordAmt ).append( "]]></ord_amt>\r\n" );
			valueXmlString.append( "<tax_amt><![CDATA[" ).append( taxAmt ).append( "]]></tax_amt>\r\n" );
			valueXmlString.append( "<udf__num1><![CDATA[" ).append( udfNum1 ).append( "]]></udf__num1>\r\n" );
			valueXmlString.append( "<udf__num2><![CDATA[" ).append( udfNum2 ).append( "]]></udf__num2>\r\n" );
			valueXmlString.append( "<frt_amt><![CDATA[" ).append( frtAmt ).append( "]]></frt_amt>\r\n" );
			valueXmlString.append( "<trans_mode><![CDATA[" ).append( transMode ).append( "]]></trans_mode>\r\n" );
			valueXmlString.append( "<rcp_mode><![CDATA[" ).append( rcpMode ).append( "]]></rcp_mode>\r\n" );
			valueXmlString.append( "<state_code__dlv><![CDATA[" ).append( stateCodeDlv ).append( "]]></state_code__dlv>\r\n" );
			valueXmlString.append( "<dlv_add3><![CDATA[" ).append( dlvAddress3 ).append( "]]></dlv_add3>\r\n" );
			valueXmlString.append( "<order_mode><![CDATA[" ).append( orderMode ).append( "]]></order_mode>\r\n" );
			valueXmlString.append( "<remarks2><![CDATA[" ).append( remarks2 ).append( "]]></remarks2>\r\n" );
			valueXmlString.append( "<remarks3><![CDATA[" ).append( remarks3 ).append( "]]></remarks3>\r\n" );
			valueXmlString.append( "<curr_code__ins><![CDATA[" ).append( currCodeIns ).append( "]]></curr_code__ins>\r\n" );
			valueXmlString.append( "<exch_rate__ins><![CDATA[" ).append( exchRateIns ).append( "]]></exch_rate__ins>\r\n" );
			valueXmlString.append( "<dlv_to><![CDATA[" ).append( dlvTo ).append( "]]></dlv_to>\r\n" );
			valueXmlString.append( "<tel1__dlv><![CDATA[" ).append( tel1Dlv ).append( "]]></tel1__dlv>\r\n" );
			valueXmlString.append( "<tel2__dlv><![CDATA[" ).append( tel2Dlv ).append( "]]></tel2__dlv>\r\n" );
			valueXmlString.append( "<fax__dlv><![CDATA[" ).append( faxDlv ).append( "]]></fax__dlv>\r\n" );
			valueXmlString.append( "<email_addr><![CDATA[" ).append( emailAddr ).append( "]]></email_addr>\r\n" );
			valueXmlString.append( "<tot_ord_value><![CDATA[" ).append( totOrdValue ).append( "]]></tot_ord_value>\r\n" );
			valueXmlString.append( "<site_code__ship><![CDATA[" ).append( siteCodeShip ).append( "]]></site_code__ship>\r\n" );
			valueXmlString.append( "<cheque_no><![CDATA[" ).append( chequeNo ).append( "]]></cheque_no>\r\n" );
			valueXmlString.append( "<cheque_date><![CDATA[" ).append( chequeDate ).append( "]]></cheque_date>\r\n" );
			valueXmlString.append( "<pord_mode><![CDATA[" ).append( pordMode ).append( "]]></pord_mode>\r\n" );
			valueXmlString.append( "<chq_amount><![CDATA[" ).append( chequeAmt ).append( "]]></chq_amount>\r\n" );
			valueXmlString.append( "<chq_name><![CDATA[" ).append( chequeName ).append( "]]></chq_name>\r\n" );
			valueXmlString.append( "<licence_no_1><![CDATA[" ).append( licenceNo1 ).append( "]]></licence_no_1>\r\n" );
			valueXmlString.append( "<order_status><![CDATA[" ).append( orderStatus ).append( "]]></order_status>\r\n" );
			valueXmlString.append( "<notify_to><![CDATA[" ).append( notifyTo ).append( "]]></notify_to>\r\n" );
			valueXmlString.append( "<buyer_name><![CDATA[" ).append( buyerName ).append( "]]></buyer_name>\r\n" );
			valueXmlString.append( "<single_lot><![CDATA[" ).append( singleLot ).append( "]]></single_lot>\r\n" );
			valueXmlString.append( "<pending_order><![CDATA[" ).append( pendingOrder ).append( "]]></pending_order>\r\n" );
			valueXmlString.append( "<net_tot_amt><![CDATA[" ).append( netTotAmt ).append( "]]></net_tot_amt>\r\n" );
			valueXmlString.append( "<ship_status><![CDATA[" ).append( shipStatus ).append( "]]></ship_status>\r\n" );
			valueXmlString.append( "<vendor_tx_code><![CDATA[" ).append( vendorTxCode ).append( "]]></vendor_tx_code>\r\n" );
			valueXmlString.append( "<vps_tx_id><![CDATA[" ).append( vpsTxId ).append( "]]></vps_tx_id>\r\n" );
			valueXmlString.append( "<security_key><![CDATA[" ).append( securityKey ).append( "]]></security_key>\r\n" );
			valueXmlString.append( "<trn_amount><![CDATA[" ).append( trnAmount ).append( "]]></trn_amount>\r\n" );
			valueXmlString.append( "<user_remarks><![CDATA[" ).append( userRemarks ).append( "]]></user_remarks>\r\n" );
			valueXmlString.append("</Detail1>\r\n");

			valueXmlString.append("<Detail2 objContext=\"2\" objName=\"upload_sorder\" domID=\"1\" dbID=\"\" >\r\n");
			valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\" />\r\n");

			valueXmlString.append( "<sale_order><![CDATA[" ).append( saleOrder ).append( "]]></sale_order>\r\n" );
			valueXmlString.append( "<line_no><![CDATA[" ).append( lineNo ).append( "]]></line_no>\r\n" );
			valueXmlString.append( "<site_code><![CDATA[" ).append( siteCode ).append( "]]></site_code>\r\n" );
			valueXmlString.append( "<item_flg><![CDATA[" ).append( itemFlag ).append( "]]></item_flg>\r\n" );
			valueXmlString.append( "<quantity><![CDATA[" ).append( quantity ).append( "]]></quantity>\r\n" );
			valueXmlString.append( "<dsp_date><![CDATA[" ).append( dspDate ).append( "]]></dsp_date>\r\n" );
			valueXmlString.append( "<rate><![CDATA[" ).append( rate ).append( "]]></rate>\r\n" );
			valueXmlString.append( "<discount><![CDATA[" ).append( discount ).append( "]]></discount>\r\n" );
			valueXmlString.append( "<tax_amt><![CDATA[" ).append( taxAmt ).append( "]]></tax_amt>\r\n" );
			valueXmlString.append( "<tax_env><![CDATA[" ).append( taxEnv ).append( "]]></tax_env>\r\n" );
			valueXmlString.append( "<net_amt><![CDATA[" ).append( netAmt ).append( "]]></net_amt>\r\n" );
			valueXmlString.append( "<item_descr><![CDATA[" ).append( itemDescr ).append( "]]></item_descr>\r\n" );
			valueXmlString.append( "<item_code__ord><![CDATA[" ).append( itemCodeOrd ).append( "]]></item_code__ord>\r\n" );
			valueXmlString.append( "<item_ser><![CDATA[" ).append( itemSeries ).append( "]]></item_ser>\r\n" );
			valueXmlString.append( "<hold_flag><![CDATA[" ).append( holdFlag ).append( "]]></hold_flag>\r\n" );
			valueXmlString.append("</Detail2>\r\n");

			valueXmlString.append( "</Header0>\r\n" );
			valueXmlString.append("</group0>\r\n");
			valueXmlString.append("</DocumentRoot>");

			xmlString = valueXmlString.toString();
			System.out.println("xmlString :::::::::::  " + xmlString);
			returnString = saveData(siteCode, xmlString, conn,campgnNo,xtraParams);
			System.out.println("Sale order saving :"+returnString);

		}
		catch(ITMException e)
		{
			e.printStackTrace();
			System.out.println("ITMException ::createSalesOrder :==>");
			writeWorkOrderLog(e.toString(),campgnNo);//TODO
			throw new ITMException(e);
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception ::createSalesOrder :==>");
			writeWorkOrderLog(e.toString(),campgnNo);//TODO
			throw new Exception(e);
		}
		return returnString;
	}

	@SuppressWarnings({ "rawtypes", "unchecked" })
	public String createDistSaleOrder( Connection conn,String campgnNo,String workOrder,String xtraParams,String itemFlag) throws Exception, ITMException
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String returnString = "";

		StringBuffer valueXmlString,HeaderXmlString;
		String xmlString = "",sql = "",avaliableYN = "",orderType = "",locCodeGit = "",locCodeGitbf = "",tranCode = "",
				autoReceipt = "",currCode = "",unit = "",itemDescr = "",priceList = "",custCode = "",
				crTerm = "",itemSeries = "";
		String deliveryTerm = "",add2 = "",add3 = "",tele1 = "",tele2 = "",tele3 = "",stanCode = "",
				add1 = "",city = "",countCode = "",pin = "",stateCode = "",dlvDescr = "",transMode = "",taxClass = "",taxEnv = "";
		double rate = 0;
		int count = 0;

		HashMap DOXml = new HashMap();
		HashMap siteXMLLineNo = new HashMap();
		String priceListType = "", priceListClg = "",dlvTerm = "",doRemarks = "",nonCrticalDoReqd = "";
		SiteItemSummaryBean sitebean = new SiteItemSummaryBean();
		MfgCommon mfgCommon = new MfgCommon();
		
		try
		{

			System.out.println(" -------------- Inside createDistSaleOrder method --------------------- ");

			valueXmlString = new StringBuffer();
			HeaderXmlString = new StringBuffer();
			
			//Added by azhar[15/MAR/2015][START] fro creation of non critical DO  when stock is absent
			//nonCrticalDoReqd = disCommon.getDisparams("999999", "NON_CRTIICAL_DO_REQD", conn);
			nonCrticalDoReqd = mfgCommon.getEnvMfg("999999", "NON_CRTIICAL_DO_REQD", conn);
			
			if( (nonCrticalDoReqd.length() > 0 && "NULLFOUND".equalsIgnoreCase(nonCrticalDoReqd) ) || nonCrticalDoReqd.trim().length() == 0){
				nonCrticalDoReqd = "N";
			}
			System.out.println("Non critical disparm::" + nonCrticalDoReqd);
			//Added by azhar[15/MAR/2015][END] fro creation of non critical DO  when stock is absent
			
			for(WorderStkBean workbean : tempWorderExpStkBeanList){
				System.out.println("lot no in work order bean:::" + workbean.getLotNo());
			}
			
			
			

			orderType = disCommon.getDisparams("999999", "AWMS_DO_ORDER_TYPE", conn);
			sql = "select loc_code__git,loc_code__gitbf,avaliable_yn ,auto_receipt, "
				 + " LOC_CODE__CONS, LOC_GROUP__CONS, TAX_CLASS, TAX_ENV, PRICE_LIST, PRICE_LIST__CLG, DLV_TERM,  GP_SER "
				+ " from distorder_type where tran_type = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, orderType);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
			
				locCodeGit = rs.getString("loc_code__git")==null?"":rs.getString("loc_code__git").trim();
				locCodeGitbf = rs.getString("loc_code__gitbf")==null?"":rs.getString("loc_code__gitbf").trim();
				avaliableYN = rs.getString("AVALIABLE_YN")==null?"N":rs.getString("AVALIABLE_YN").trim();
				autoReceipt = rs.getString("AUTO_RECEIPT")==null?"N":rs.getString("AUTO_RECEIPT").trim();
				priceList = rs.getString("PRICE_LIST")==null?"":rs.getString("PRICE_LIST").trim();
				taxClass = rs.getString("TAX_CLASS")==null?"":rs.getString("TAX_CLASS").trim();
				taxEnv = rs.getString("TAX_ENV")==null?"":rs.getString("TAX_ENV").trim();
				priceListClg = rs.getString("PRICE_LIST__CLG")==null?"":rs.getString("PRICE_LIST__CLG").trim();
				dlvTerm = rs.getString("DLV_TERM")==null?"":rs.getString("DLV_TERM").trim();
				

			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

				System.out.println("siteItemReqQtyList size="+siteItemReqQtyList.size());
				System.out.println("siteItemReqQtyList details:::" + siteItemReqQtyList);
				
				

				if("C".equalsIgnoreCase(itemFlag)){
					
					roundQuantity(conn,campgnNo,"C");
					
					System.out.println("creating DO for first time:::");
					
					for(SiteItemSummaryBean tempObj : siteItemReqQtyList)
					{
						System.out.println("SiteCode["+tempObj.getSiteCode()+"]  ItemCode["+tempObj.getItemCode()+"]");
						
						System.out.println("order qty in site bean::" + tempObj.getOtherSiteQty());
						
						System.out.println("lot no in site bean::" + tempObj.getLotNo());
						
						

						count++;
						System.out.println("siteItemReqQtyList--------------->>"+count);
						if(valueXmlString.length() > 0 || HeaderXmlString.length() > 0)
						{
							valueXmlString.delete(0, valueXmlString.length());
							HeaderXmlString.delete(0, HeaderXmlString.length());
						}
						System.out.println("TransTran@@ : "+tempObj.getTransTran());
						//if("D".equalsIgnoreCase(tempObj.getTransTran())) //commented by azhar[02/FEB/2017]
						if("D".equalsIgnoreCase(tempObj.getTransTran()) && "Y".equalsIgnoreCase(tempObj.getCritItem()))
						{
							//create distribution order
							System.out.println("Making distribution order with quantity="+tempObj.getOtherSiteQty()+" for item_code"+tempObj.getItemCode());
							
							System.out.println("orderType@@ : "+orderType);
							sql = "select a.curr_code from finent a, site b where a.fin_entity = b.fin_entity and b.site_code = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, tempObj.getSiteCode());
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								currCode = rs.getString(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							sql = "select unit,descr from item where item_code = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, tempObj.getItemCode());
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								unit = rs.getString(1);
								itemDescr = rs.getString(2);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							System.out.println("Current site="+tempObj.getSiteCode());
							System.out.println("Site code ship="+tempObj.getSiteCodeShip());

							HeaderXmlString.append("<?xml version='1.0' encoding='ISO-8859-1'?>\n");
							HeaderXmlString.append("<DocumentRoot>");
							HeaderXmlString.append("<description>").append("Datawindow Root").append("</description>");
							HeaderXmlString.append("<group0>");
							HeaderXmlString.append("<description>").append("Group0 description").append("</description>");
							HeaderXmlString.append("<Header0>");
							HeaderXmlString.append("<objName><![CDATA[").append("dist_order").append("]]></objName>");
							HeaderXmlString.append("<pageContext><![CDATA[").append("1").append("]]></pageContext>");
							HeaderXmlString.append("<objContext><![CDATA[").append("1").append("]]></objContext>");
							HeaderXmlString.append("<editFlag><![CDATA[").append("A").append("]]></editFlag>");
							HeaderXmlString.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>");
							HeaderXmlString.append("<action><![CDATA[").append("SAVE").append("]]></action>");
							HeaderXmlString.append("<elementName><![CDATA[").append("").append("]]></elementName>");
							HeaderXmlString.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
							HeaderXmlString.append("<taxKeyValue><![CDATA[").append("").append("]]></taxKeyValue>");
							HeaderXmlString.append("<saveLevel><![CDATA[").append("1").append("]]></saveLevel>");
							HeaderXmlString.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>");
							HeaderXmlString.append("<taxInFocus><![CDATA[").append(false).append("]]></taxInFocus>");
							HeaderXmlString.append("<description>").append("Header0 members").append("</description>");
							//price_list from distorder_type where tran_type
							//priceList = getColumnDescr(conn, "price_list", "distorder_type", "tran_type", orderType);
							priceListType = disCommon.getPriceListType(priceList,conn);
							//System.out.println("count :" + count);
							if (!"I".equalsIgnoreCase(priceListType))
							{
								rate = disCommon.pickRate(priceList, getCurrdateAppFormat(campgnNo), tempObj.getItemCode(), "", priceListType,conn); //lotSL not set
							}
							else
							{
								//tabValue = tempObj.getSiteCodeShip() + "~t" + tempObj.getLocCode() + "~t" + tempObj.getLotNo()  + "~t" + tempObj.getLotSl() ;
								//System.out.println("tabValue :" + tabValue);
								// rate can be picked in issue only as stock details are not available during order
								rate = 0;//disCommon.pickRate(priceList, getCurrdateAppFormat(), tempObj.getItemCode(), tabValue, "I",conn);
								//System.out.println("rate2 :" + rate2);
							}
							
							HeaderXmlString.append("<Detail1 dbID=\"\" domID=\"1\" objName=\"dist_order\" objContext=\"1\">");
							HeaderXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>");
							HeaderXmlString.append("<dist_order/>");
							HeaderXmlString.append("<order_date><![CDATA["+getCurrdateAppFormat(campgnNo)+"]]></order_date>");
							//Changed by wasim on 03-03-2016 as site code dlv and site code ship is reverse vise versa [START]
							HeaderXmlString.append("<site_code__ship><![CDATA[").append(tempObj.getSiteCodeShip()).append("]]></site_code__ship>");
							HeaderXmlString.append("<site_code__dlv><![CDATA[").append(tempObj.getSiteCode()).append("]]></site_code__dlv>");
							//Changed by wasim on 03-03-2016 as site code dlv and site code ship is reverse vise versa [END]
							HeaderXmlString.append("<ship_date><![CDATA["+getCurrdateAppFormat(campgnNo)+"]]></ship_date>");
							HeaderXmlString.append("<due_date><![CDATA["+getCurrdateAppFormat(campgnNo)+"]]></due_date>");
							
							//added by azhar 29-NOV-16[START]
							if(workOrder.isEmpty()){
								 doRemarks = "DO is created against campaign no[" + campgnNo + "] ";
							}else{
								doRemarks = "DO is created against workorder no[" + workOrder + "] ";
							}
							HeaderXmlString.append("<remarks><![CDATA[" + doRemarks + "]]></remarks>");
							// added by azhar 29-NOV-16[END]
							
							//HeaderXmlString.append("<remarks/>");
							//HeaderXmlString.append("<dist_route><![CDATA[").append((distDetailMap.containsKey("dist_route")?distDetailMap.get("dist_route"):distRoute)).append("]]></dist_route>");
							HeaderXmlString.append("<price_list><![CDATA[").append(priceList).append("]]></price_list>");
							HeaderXmlString.append("<confirmed><![CDATA[N]]></confirmed>");
							HeaderXmlString.append("<chg_user><![CDATA["+chgUser+"]]></chg_user>");
							HeaderXmlString.append("<chg_term><![CDATA["+termId+"]]></chg_term>");
							HeaderXmlString.append("<target_wgt><![CDATA[0]]></target_wgt>");
							HeaderXmlString.append("<target_vol><![CDATA[0]]></target_vol>");
							HeaderXmlString.append("<loc_code__git><![CDATA[").append(locCodeGit).append("]]></loc_code__git>");
							//HeaderXmlString.append("<loc_code__git/>");
							HeaderXmlString.append("<chg_date><![CDATA["+getCurrdateAppFormat(campgnNo)+"]]></chg_date>");
							HeaderXmlString.append("<site_from_descr/>");
							HeaderXmlString.append("<site_to_descr/>");
							HeaderXmlString.append("<location_descr/>");
							HeaderXmlString.append("<conf_date><![CDATA["+getCurrdateAppFormat(campgnNo)+"]]></conf_date>");
							HeaderXmlString.append("<site_code><![CDATA["+tempObj.getSiteCode()+"]]></site_code>");
							//HeaderXmlString.append("<status><![CDATA[").append((distDetailMap.containsKey("status")?distDetailMap.get("status"):priceList)).append("]]></status>");
							//HeaderXmlString.append("<sale_order><![CDATA[").append((distDetailMap.containsKey("sale_order")?distDetailMap.get("sale_order"):saleOrder)).append("]]></sale_order>");
							HeaderXmlString.append("<remarks1/>");
							HeaderXmlString.append("<remarks2/>");
							//HeaderXmlString.append("<order_type><![CDATA[").append(orderType).append("]]></order_type>");
							HeaderXmlString.append("<tran_type><![CDATA[").append(orderType).append("]]></tran_type>");
							HeaderXmlString.append("<a_site_add1/>");
							HeaderXmlString.append("<a_site_add2/>");
							HeaderXmlString.append("<a_site_city/>");
							HeaderXmlString.append("<a_site_pin/>");
							HeaderXmlString.append("<a_site_state_code/>");
							HeaderXmlString.append("<b_site_add1/>");
							HeaderXmlString.append("<b_site_add2/>");
							HeaderXmlString.append("<b_site_city/>");
							HeaderXmlString.append("<b_site_pin/>");
							HeaderXmlString.append("<b_site_state_code/>");
							HeaderXmlString.append("<loc_code__cons/>");
							//HeaderXmlString.append("<sundry_type><![CDATA[").append((distDetailMap.containsKey("sundry_type")?distDetailMap.get("sundry_type"):sundryType)).append("]]></sundry_type>");
							//HeaderXmlString.append("<sundry_code><![CDATA[").append((distDetailMap.containsKey("sundry_code")?distDetailMap.get("sundry_code"):sundryCode)).append("]]></sundry_code>");
							//HeaderXmlString.append("<auto_receipt><![CDATA[Y]]></auto_receipt>");
							HeaderXmlString.append("<auto_receipt><![CDATA[").append(autoReceipt).append("]]></auto_receipt>");
							//HeaderXmlString.append("<tran_type><![CDATA[IT]]></tran_type>"); //discuss with sir pending
							HeaderXmlString.append("<curr_code><![CDATA[" + currCode + "]]></curr_code>");
							HeaderXmlString.append("<exch_rate><![CDATA[1]]></exch_rate>");
							HeaderXmlString.append("<sales_pers><![CDATA[]]></sales_pers>");
							HeaderXmlString.append("<sales_pers_sp_name><![CDATA[]]></sales_pers_sp_name>");
							HeaderXmlString.append("<loc_code__gitbf><![CDATA[").append(locCodeGitbf).append("]]></loc_code__gitbf>");
							//HeaderXmlString.append("<loc_code__gitbf><![CDATA[]]></loc_code__gitbf>");
							HeaderXmlString.append("<cust_code__dlv><![CDATA[]]></cust_code__dlv>");
							HeaderXmlString.append("<dlv_to></dlv_to>");
							HeaderXmlString.append("<dlv_add1><![CDATA[]]></dlv_add1>");
							HeaderXmlString.append("<dlv_add2><![CDATA[]]></dlv_add2>");
							HeaderXmlString.append("<dlv_add3><![CDATA[]]></dlv_add3>");
							HeaderXmlString.append("<dlv_city><![CDATA[]]></dlv_city>");
							HeaderXmlString.append("<state_code__dlv><![CDATA[]]></state_code__dlv>");
							HeaderXmlString.append("<count_code__dlv><![CDATA[]]></count_code__dlv>");
							HeaderXmlString.append("<dlv_pin><![CDATA[]]></dlv_pin>");
							HeaderXmlString.append("<stan_code><![CDATA[]]></stan_code>");
							HeaderXmlString.append("<tel1__dlv><![CDATA[]]></tel1__dlv>");
							HeaderXmlString.append("<tel2__dlv><![CDATA[]]></tel2__dlv>");
							HeaderXmlString.append("<tel3__dlv><![CDATA[]]></tel3__dlv>");
							HeaderXmlString.append("<fax__dlv><![CDATA[]]></fax__dlv>");
							HeaderXmlString.append("<avaliable_yn><![CDATA[").append(avaliableYN).append("]]></avaliable_yn>");
							//HeaderXmlString.append("<avaliable_yn><![CDATA[Y]]></avaliable_yn>");
							HeaderXmlString.append("<purc_order><![CDATA[]]></purc_order>");
							HeaderXmlString.append("<tot_amt><![CDATA[0]]></tot_amt>");
							HeaderXmlString.append("<tax_amt><![CDATA[0]]></tax_amt>");
							HeaderXmlString.append("<net_amt><![CDATA[0]]></net_amt>");
							HeaderXmlString.append("<tran_ser><![CDATA[]]></tran_ser>");
							HeaderXmlString.append("<price_list__clg><![CDATA["+ priceListClg + "]]></price_list__clg>");
							HeaderXmlString.append("<dlv_term><![CDATA["+ dlvTerm + "]]></dlv_term>");
							HeaderXmlString.append("<loc><![CDATA[                         ]]></loc>");
							HeaderXmlString.append("<sundry_name><![CDATA[]]></sundry_name>");
							HeaderXmlString.append("<proj_code><![CDATA[]]></proj_code>");
							HeaderXmlString.append("<descr/>");
							HeaderXmlString.append("<policy_no><![CDATA[]]></policy_no>");
							HeaderXmlString.append("<loc_code__damaged><![CDATA[]]></loc_code__damaged>");
							HeaderXmlString.append("<site_code__bil><![CDATA[]]></site_code__bil>");
							HeaderXmlString.append("<d_site_descr><![CDATA[]]></d_site_descr>");
							HeaderXmlString.append("<d_site_add1><![CDATA[]]></d_site_add1>");
							HeaderXmlString.append("<d_site_add2><![CDATA[]]></d_site_add2>");
							HeaderXmlString.append("<d_site_city><![CDATA[]]></d_site_city>");
							HeaderXmlString.append("<d_site_pin><![CDATA[]]></d_site_pin>");
							HeaderXmlString.append("<d_site_state_code><![CDATA[]]></d_site_state_code>");
							//	HeaderXmlString.append("<trans_mode><![CDATA[").append((distDetailMap.containsKey("trans_mode")?distDetailMap.get("trans_mode"):transMode)).append("]]></trans_mode>");
							HeaderXmlString.append("</Detail1>\r\n");


							valueXmlString.append("<Detail2 dbID='' domID=\"1\" objName=\"dist_order\" objContext=\"2\">");
							valueXmlString.append("<attribute pkNames=\"\" selected=\"N\" updateFlag=\"A\" status=\"N\" />");
							valueXmlString.append("<dist_order/>");
							valueXmlString.append("<line_no><![CDATA["+count+"]]></line_no>");
							
							//Changed by wasim on 13-07-2016 to set line number order [START]
							tempObj.setLineNoOrder(String.valueOf(count));
							//Changed by wasim on 13-07-2016 to set line number order [END]
							
							valueXmlString.append("<tran_id__demand><![CDATA[]]></tran_id__demand>");
							valueXmlString.append("<item_code><![CDATA[").append(tempObj.getItemCode()).append("]]></item_code>");
							valueXmlString.append("<qty_order><![CDATA["+tempObj.getOtherSiteQty()+"]]></qty_order>");
							valueXmlString.append("<qty_confirm><![CDATA["+tempObj.getOtherSiteQty()+"]]></qty_confirm>");
							valueXmlString.append("<qty_received><![CDATA["+0+"]]></qty_received>");
							valueXmlString.append("<qty_shipped><![CDATA["+0+"]]></qty_shipped>");
							valueXmlString.append("<due_date><![CDATA["+getCurrdateAppFormat(campgnNo)+"]]></due_date>");
							valueXmlString.append("<tax_class><![CDATA[" + taxClass + "]]></tax_class>");
							//valueXmlString.append("<tax_chap><![CDATA[").append((distDetailMap.containsKey("tax_chap")?tagChkMapForDetail1.get("tax_chap"):taxChap)).append("]]></tax_chap>");
							valueXmlString.append("<tax_env><![CDATA[" +taxEnv +"]]></tax_env>");
							valueXmlString.append("<unit><![CDATA["+unit+"]]></unit>");
							valueXmlString.append("<item_descr><![CDATA["+itemDescr+"]]></item_descr>");
							//valueXmlString.append("<sale_order><![CDATA[").append((distDetailMap.containsKey("sale_order")?tagChkMapForDetail1.get("sale_order"):saleOrder)).append("]]></sale_order>");
							valueXmlString.append("<line_no__sord/>");
							valueXmlString.append("<rate><![CDATA["+rate+"]]></rate>");
							valueXmlString.append("<qty_return><![CDATA[0]]></qty_return>");
							valueXmlString.append("<discount><![CDATA[0]]></discount>");
							valueXmlString.append("<remarks><![CDATA[]]></remarks>");
							valueXmlString.append("<tot_amt><![CDATA[0]]></tot_amt>");
							valueXmlString.append("<tax_amt><![CDATA[0]]></tax_amt>");
							valueXmlString.append("<net_amt><![CDATA[0]]></net_amt>");
							rate = disCommon.pickRate(priceListClg, getCurrdateAppFormat(campgnNo), tempObj.getItemCode(), "", "B",conn); 
							valueXmlString.append("<rate__clg><![CDATA[" + rate + "]]></rate__clg>");
							valueXmlString.append("<qty_alloc><![CDATA[0]]></qty_alloc>");
							valueXmlString.append("<over_ship_perc><![CDATA[0]]></over_ship_perc>");
							//valueXmlString.append("<qty_details><![CDATA[]]></qty_details>");
							valueXmlString.append("<unit__alt><![CDATA["+unit+"]]></unit__alt>");
							valueXmlString.append("<conv__qty__alt><![CDATA[0]]></conv__qty__alt>");
							valueXmlString.append("<qty_order__alt><![CDATA[0]]></qty_order__alt>");
							valueXmlString.append("<ship_date><![CDATA["+getCurrdateAppFormat(campgnNo)+"]]></ship_date>");
							//valueXmlString.append("<work_order><![CDATA["+workorder+"]]></work_order>");//wasim work order in not showing in detail screen...it should show
							valueXmlString.append("<pack_instr><![CDATA[]]></pack_instr>");
							valueXmlString.append("</Detail2>\r\n");

							/*valueXmlString.append( "</Header0>\r\n" );
							valueXmlString.append("</group0>\r\n");
							valueXmlString.append("</DocumentRoot>");*/

							//String key = tempObj.getSiteCodeShip();
							String key = tempObj.getTransTran() +":"+ tempObj.getSiteCodeShip() +":"+ tempObj.getSiteCode();

							System.out.println("@@@Key="+key);

							if(DOXml.containsKey(key) && key!=null)
							{
								System.out.println("Key found");
								xmlString = String.valueOf(DOXml.get(key) + valueXmlString.toString());

								DOXml.put(key, xmlString);

							}
							else
							{
								System.out.println("Key not found");
								DOXml.put(key, HeaderXmlString.toString()+valueXmlString.toString());

							}
						}
						else if("P".equalsIgnoreCase(tempObj.getTransTran()))
						{
							//create sales order
							System.out.println("custCode from getSiteCode----->>["+tempObj.getSiteCode()+"]");
							System.out.println("custCode from getSiteCodeShip----->>["+tempObj.getSiteCodeShip()+"]");
							orderType = disCommon.getDisparams("999999", "AWMS_SO_ORDER_TYPE", conn);

							sql = "select unit from item where item_code = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, tempObj.getItemCode());
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								unit = checkNull(rs.getString("unit"));
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							System.out.println("Unit="+unit);

							sql = "select cust_code from site_customer where site_code__ch = ? "
									+ "and site_code = ? and channel_partner = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, tempObj.getSiteCode());
							pstmt.setString(2, tempObj.getSiteCodeShip());
							pstmt.setString(3, "Y");
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								custCode = checkNull(rs.getString(1));

							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							System.out.println("custCode from site_customer----->>["+custCode+"]");
							if(custCode.length() == 0)
							{
								sql = "select cust_code from customer where site_code = ? and channel_partner = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, tempObj.getSiteCode());
								pstmt.setString(2, "Y");
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									custCode = checkNull(rs.getString(1));
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								System.out.println("custCode from customer----->>["+custCode+"]");

							}

							sql = "select cr_term,tran_code,curr_code from customer where cust_code = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, custCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								crTerm = checkNull(rs.getString(1));
								tranCode = checkNull(rs.getString(2));
								currCode = checkNull(rs.getString(3));

							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							sql = "select cr_term,dlv_term, TRAN_CODE, addr1,addr2,addr3,tele1,tele2,tele3,trans_mode,stan_code,city,"
									+ "count_code,pin,state_code,CURR_CODE__FRT,CURR_CODE__INS ,cust_name "
									+ "from customer where cust_code = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,custCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								//priceList = rs2.getString("price_list");
								//deliveryTerm = deliveryTerm == " " ? rs2.getString("dlv_term") : deliveryTerm;
								crTerm = checkNull(rs.getString("cr_term"));
								deliveryTerm=rs.getString("dlv_term");
								tranCode =rs.getString("TRAN_CODE")==null?" ":rs.getString("TRAN_CODE");
								//currCodeFrt =rs.getString("CURR_CODE__FRT")==null?" ":rs.getString("CURR_CODE__FRT");
								//currCodeIns =rs.getString("CURR_CODE__INS")==null?" ":rs.getString("CURR_CODE__INS");

								add1 = rs.getString("addr1")== null ?" ":rs.getString("addr1");
								add2 = rs.getString("addr2")==null ?" ":rs.getString("addr2");
								add3 = rs.getString("addr3")== null ?" ":rs.getString("addr3");
								tele1 = rs.getString("tele1")== null ?" ":rs.getString("tele1");
								tele2 = rs.getString("tele2")== null ?" ":rs.getString("tele2");
								tele3 = rs.getString("tele3")== null ?" ":rs.getString("tele3");
								stanCode = rs.getString("stan_code")==null ?" ":rs.getString("stan_code");
								city = rs.getString("city")== null ?" ":rs.getString("city");
								countCode = rs.getString("count_code")== null ?" ":rs.getString("count_code");
								pin = rs.getString("pin")== null ?" ":rs.getString("pin");
								stateCode = rs.getString("state_code")== null ?" ":rs.getString("state_code");
								System.out.println("");
								//dlvTO = rs.getString("cust_name") == null ?" ":rs.getString("cust_name");
								dlvDescr = rs.getString("cust_name");
								transMode = rs.getString("trans_mode")== null ?" ":rs.getString("trans_mode");

							}

							rs.close();
							rs =null;
							pstmt.close();
							pstmt = null;
							System.out.println("dlvAdd1 :"+add1);
							System.out.println("dlvAdd2 :"+add2);
							System.out.println("dlvAdd3 :"+add3);
							System.out.println("transMode :"+transMode);
							System.out.println("tranCode :"+tranCode);
							System.out.println("tele1 :"+tele1+" @tele2 :"+tele2+" @tele3 :"+tele3);

							HeaderXmlString.append("<?xml version='1.0' encoding='ISO-8859-1'?>\n");
							HeaderXmlString.append("<DocumentRoot>");
							HeaderXmlString.append("<description>").append("Datawindow Root").append("</description>");
							HeaderXmlString.append("<group0>");
							HeaderXmlString.append("<description>").append("Group0 description").append("</description>");
							HeaderXmlString.append("<Header0>");
							HeaderXmlString.append("<objName><![CDATA[").append("sorder").append("]]></objName>");
							HeaderXmlString.append("<pageContext><![CDATA[").append("1").append("]]></pageContext>");
							HeaderXmlString.append("<objContext><![CDATA[").append("1").append("]]></objContext>");
							HeaderXmlString.append("<editFlag><![CDATA[").append("A").append("]]></editFlag>");
							HeaderXmlString.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>");
							HeaderXmlString.append("<action><![CDATA[").append("SAVE").append("]]></action>");
							HeaderXmlString.append("<elementName><![CDATA[").append("").append("]]></elementName>");
							HeaderXmlString.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
							HeaderXmlString.append("<taxKeyValue><![CDATA[").append("").append("]]></taxKeyValue>");
							HeaderXmlString.append("<saveLevel><![CDATA[").append("1").append("]]></saveLevel>");
							HeaderXmlString.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>");
							HeaderXmlString.append("<taxInFocus><![CDATA[").append(false).append("]]></taxInFocus>");
							HeaderXmlString.append("<description>").append("Header0 members").append("</description>");

							HeaderXmlString.append("<Detail1 dbID=\"\" domID=\"1\" objName=\"sorder\" objContext=\"1\">");
							HeaderXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>");
							HeaderXmlString.append("<sale_order/>");
							//HeaderXmlString.append("<order_type><![CDATA["+ orderType +"]]></order_type>");
							HeaderXmlString.append("<tran_type><![CDATA["+ orderType +"]]></tran_type>");
							HeaderXmlString.append("<order_date><![CDATA["+ getCurrdateAppFormat(campgnNo)  +"]]></order_date>");
							itemSeries = getColumnDescr(conn, "item_ser", "item", "item_code", tempObj.getItemCode(),campgnNo);
							HeaderXmlString.append("<item_ser><![CDATA["+ itemSeries +"]]></item_ser>");
							HeaderXmlString.append("<site_code><![CDATA["+ tempObj.getSiteCode() +"]]></site_code>");
							HeaderXmlString.append("<site_code__ship><![CDATA["+ tempObj.getSiteCodeShip() +"]]></site_code__ship>");
							HeaderXmlString.append("<cust_code><![CDATA["+ custCode +"]]></cust_code>");
							HeaderXmlString.append("<dlv_to><![CDATA["+ dlvDescr +"]]></dlv_to>");
							HeaderXmlString.append("<cust_code__bil><![CDATA["+ custCode +"]]></cust_code__bil>");
							HeaderXmlString.append("<cust_code__dlv><![CDATA["+ custCode +"]]></cust_code__dlv>");
							HeaderXmlString.append("<stan_code><![CDATA["+ stanCode.trim() +"]]></stan_code>");
							HeaderXmlString.append("<STAN_CODE__INIT><![CDATA["+ stanCode.trim() +"]]></STAN_CODE__INIT>");
							HeaderXmlString.append("<cr_term><![CDATA["+ crTerm +"]]></cr_term>");
							HeaderXmlString.append("<curr_code__frt><![CDATA["+ currCode +"]]></curr_code__frt>");
							HeaderXmlString.append("<trans_mode><![CDATA["+ transMode.trim() +"]]></trans_mode>");
							HeaderXmlString.append("<emp_code__ord><![CDATA["+ chgUser +"]]></emp_code__ord>");
							HeaderXmlString.append("<curr_code__frt><![CDATA["+currCode +"]]></curr_code__frt>");
							HeaderXmlString.append("<curr_code__ins><![CDATA["+ currCode +"]]></curr_code__ins>");
							HeaderXmlString.append("<curr_code><![CDATA["+currCode +"]]></curr_code>");
							HeaderXmlString.append("<exch_rate><![CDATA[" + "1" + "]]></exch_rate>");
							HeaderXmlString.append("<tax_opt><![CDATA[" + "2" + "]]></tax_opt>");

							HeaderXmlString.append("<dlv_city><![CDATA["+ city +"]]></dlv_city>");
							HeaderXmlString.append("<dlv_pin><![CDATA["+ pin +"]]></dlv_pin>");
							HeaderXmlString.append("<dlv_add1><![CDATA["+ add1 +"]]></dlv_add1>");
							HeaderXmlString.append("<dlv_add2><![CDATA["+ add2 +"]]></dlv_add2>");
							HeaderXmlString.append("<dlv_add3><![CDATA["+ add3 +"]]></dlv_add3>");
							HeaderXmlString.append("<tel1__dlv><![CDATA["+ tele1 +"]]></tel1__dlv>");
							HeaderXmlString.append("<tel2__dlv><![CDATA["+ tele2 +"]]></tel2__dlv>");
							HeaderXmlString.append("<tel3__dlv><![CDATA["+ tele3 +"]]></tel3__dlv>");
							HeaderXmlString.append("<state_code__dlv><![CDATA["+ stateCode +"]]></state_code__dlv>");
							HeaderXmlString.append("<count_code__dlv><![CDATA["+ countCode +"]]></count_code__dlv>");

							HeaderXmlString.append("<dlv_term><![CDATA["+ deliveryTerm +"]]></dlv_term>");
							HeaderXmlString.append("<chg_user><![CDATA["+ chgUser +"]]></chg_user>");
							HeaderXmlString.append("<chg_term><![CDATA["+ termId +"]]></chg_term>");
							HeaderXmlString.append("<chg_date><![CDATA["+ getCurrdateAppFormat(campgnNo) +"]]></chg_date>");

							HeaderXmlString.append("<tran_code><![CDATA["+ tranCode +"]]></tran_code>");
							HeaderXmlString.append("<price_list><![CDATA["+ priceList +"]]></price_list>");

							HeaderXmlString.append( "<rcp_mode><![CDATA[" ).append( "Q" ).append( "]]></rcp_mode>\r\n" );
							HeaderXmlString.append( "<user_remarks><![CDATA[" ).append( "Created from firm plan" ).append( "]]></user_remarks>\r\n" );
							/*HeaderXmlString.append("<tax_class><![CDATA["+taxClass +"]]></tax_class>");
							HeaderXmlString.append("<tax_chap><![CDATA["+taxChap +"]]></tax_chap>");
							HeaderXmlString.append("<tax_env><![CDATA["+ taxEnv+"]]></tax_env>");*/

							HeaderXmlString.append("</Detail1>\r\n");

							priceList = getColumnDescr(conn, "price_list", "distorder_type", "tran_type", orderType,campgnNo);
							rate = disCommon.pickRate(priceList, getCurrdateAppFormat(campgnNo), tempObj.getItemCode(), "", "I",conn); //lotSL not set
							System.out.println("Rate---------->>["+rate+"]");


							System.out.println("Line number sorddet="+count);
							System.out.println("Item code sorddet="+tempObj.getItemCode());

							String key = tempObj.getTransTran() +":"+ tempObj.getSiteCodeShip() +":"+ tempObj.getSiteCode();
							count = 0;
							if(siteXMLLineNo.containsKey(key) && tempObj.getSiteCodeShip()!=null)
							{
								count = (Integer) siteXMLLineNo.get(key);
							}
							System.out.println("New line number ="+count);
							count++;

							valueXmlString.append("<Detail2 objContext=\"2\" objName=\"sorder\" domID=\""+count+"\" dbID=\"\" >\r\n");
							valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"O\" pkNames=\"\" />\r\n");

							valueXmlString.append("<sale_order/>");
							valueXmlString.append( "<line_no><![CDATA[" ).append(count).append( "]]></line_no>\r\n" );
							
							//Changed by wasim on 13-07-2016 to set line number order [START]
							tempObj.setLineNoOrder(String.valueOf(count));
							//Changed by wasim on 13-07-2016 to set line number order [END]
							
							valueXmlString.append( "<site_code><![CDATA[" ).append( tempObj.getSiteCode() ).append( "]]></site_code>\r\n" );
							valueXmlString.append( "<item_flg><![CDATA[" ).append( "I" ).append( "]]></item_flg>\r\n" );
							valueXmlString.append( "<quantity><![CDATA[" ).append( tempObj.getOtherSiteQty() ).append( "]]></quantity>\r\n" );

							java.util.Date date = getCurrtDate(campgnNo);
							Calendar cal = Calendar.getInstance();
							cal.setTime(date);
							cal.add(Calendar.DATE, 1);
							date = cal.getTime();
							java.sql.Timestamp dateT1 = new java.sql.Timestamp(date.getTime());
							 String currDatePlus1 = (new SimpleDateFormat(genericUtility.getApplDateFormat())).format(dateT1).toString();

							 System.out.println("Sale order rate="+rate);

							valueXmlString.append( "<dsp_date><![CDATA[" ).append( currDatePlus1 ).append( "]]></dsp_date>\r\n" );
							valueXmlString.append( "<rate><![CDATA[" ).append(rate).append( "]]></rate>\r\n" );//
							valueXmlString.append( "<discount><![CDATA[" ).append( "0" ).append( "]]></discount>\r\n" );
							//valueXmlString.append( "<tax_amt><![CDATA[" ).append( taxAmt ).append( "]]></tax_amt>\r\n" );
							//valueXmlString.append( "<tax_env><![CDATA[" ).append( taxEnv ).append( "]]></tax_env>\r\n" );
							//valueXmlString.append( "<net_amt><![CDATA[" ).append( netAmt ).append( "]]></net_amt>\r\n" );
							itemDescr = getColumnDescr(conn, "descr", "item", "item_code", tempObj.getItemCode(),campgnNo);
							valueXmlString.append( "<item_descr><![CDATA[" ).append( itemDescr ).append( "]]></item_descr>\r\n" );
							valueXmlString.append( "<item_code><![CDATA[" ).append( tempObj.getItemCode() ).append( "]]></item_code>\r\n" );
							valueXmlString.append( "<item_code__ord><![CDATA[" ).append( tempObj.getItemCode() ).append( "]]></item_code__ord>\r\n" );
							valueXmlString.append( "<item_ser><![CDATA[" ).append( itemSeries ).append( "]]></item_ser>\r\n" );
							valueXmlString.append( "<hold_flag><![CDATA[" ).append( "N" ).append( "]]></hold_flag>\r\n" );
							/*valueXmlString.append("<tax_class><![CDATA["+taxClass +"]]></tax_class>");
							valueXmlString.append("<tax_chap><![CDATA["+taxChap +"]]></tax_chap>");
							valueXmlString.append("<tax_env><![CDATA["+ taxEnv +"]]></tax_env>");*/
							valueXmlString.append("<unit><![CDATA["+unit+"]]></unit>");

							valueXmlString.append("</Detail2>\r\n");

							//String key = tempObj.getSiteCodeShip();
							System.out.println("@@@Key="+key);

							if(DOXml.containsKey(key) && key!=null)
							{
								System.out.println("Key found");
								xmlString = String.valueOf(DOXml.get(key) + valueXmlString.toString());

								DOXml.put(key, xmlString);

								siteXMLLineNo.put(key, count);
							}
							else
							{
								System.out.println("Key not found");
								DOXml.put(key, HeaderXmlString.toString()+valueXmlString.toString());

								siteXMLLineNo.put(key, count);
							}
						}
					}
				}else if("NC".equalsIgnoreCase(itemFlag) && "Y".equalsIgnoreCase(nonCrticalDoReqd)){
					
					//TODO compare workorderdetail bean and sitesummary nc bean for missing item
					
					/*Iterator<WorkOrderDetailBean> itr = workOrderBeanList.iterator();
					while(itr.hasNext()){
						WorkOrderDetailBean nextValue = itr.next();
						Iterator<SiteItemSummaryBeanNC> siteItr = siteItemReqQtyListNC.iterator();
						 if("N".equalsIgnoreCase(nextValue.getCritItem())){
							if(siteItemReqQtyListNC.size() > 0){
								boolean isExist = false;
								while(siteItr.hasNext()){
									
									SiteItemSummaryBeanNC nextSummary = siteItr.next();
									if(nextValue.getItemCode().equals(nextSummary.getItemCode())){
										isExist = true;
							 		 }
								}
								if(!isExist){
									//TODO add in siteitem summary bean nc
								}
							 }else{
								 //TODO add in siteitem summary bean nc
							 }
						 }
					}*/
						//Added by azhar[15/MAR/2015][START] fro creation of non critical DO  when stock is absent
					if(zeroStockCheckMap.containsKey("CURRENT") && zeroStockCheckMap.containsKey("OTHER")){
						roundQuantity(conn,campgnNo,"NC");	
					}
					//Added by azhar[15/MAR/2015][END] fro creation of non critical DO  when stock is absent
					
					
					System.out.println("Creating DO for non critical items::");
					
					for(SiteItemSummaryBeanNC tempObj : siteItemReqQtyListNC)
					{
						System.out.println("Inside for loop  in DO for Non critical item::");
						
						System.out.println("SiteCode["+tempObj.getSiteCode()+"]  ItemCode["+tempObj.getItemCode()+"]");
						
						System.out.println("order qty in site bean::" + tempObj.getOtherSiteQty());
						
						System.out.println("lot no in site bean::" + tempObj.getLotNo());
						
						

						count++;
						System.out.println("siteItemReqQtyListNC--------------->>"+count);
						if(valueXmlString.length() > 0 || HeaderXmlString.length() > 0)
						{
							valueXmlString.delete(0, valueXmlString.length());
							HeaderXmlString.delete(0, HeaderXmlString.length());
						}
						System.out.println("TransTran@@ : "+tempObj.getTransTran());
						//if("D".equalsIgnoreCase(tempObj.getTransTran())) //commented by azhar[02/FEB/2017]
						if("D".equalsIgnoreCase(tempObj.getTransTran()))
						{
							//create distribution order
							System.out.println("Making distribution order with quantity="+tempObj.getOtherSiteQty()+" for item_code"+tempObj.getItemCode());
							
							System.out.println("orderType@@ : "+orderType);
							sql = "select a.curr_code from finent a, site b where a.fin_entity = b.fin_entity and b.site_code = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, tempObj.getSiteCode());
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								currCode = rs.getString(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							sql = "select unit,descr from item where item_code = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, tempObj.getItemCode());
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								unit = rs.getString(1);
								itemDescr = rs.getString(2);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							System.out.println("Current site="+tempObj.getSiteCode());
							System.out.println("Site code ship="+tempObj.getSiteCodeShip());

							HeaderXmlString.append("<?xml version='1.0' encoding='ISO-8859-1'?>\n");
							HeaderXmlString.append("<DocumentRoot>");
							HeaderXmlString.append("<description>").append("Datawindow Root").append("</description>");
							HeaderXmlString.append("<group0>");
							HeaderXmlString.append("<description>").append("Group0 description").append("</description>");
							HeaderXmlString.append("<Header0>");
							HeaderXmlString.append("<objName><![CDATA[").append("dist_order").append("]]></objName>");
							HeaderXmlString.append("<pageContext><![CDATA[").append("1").append("]]></pageContext>");
							HeaderXmlString.append("<objContext><![CDATA[").append("1").append("]]></objContext>");
							HeaderXmlString.append("<editFlag><![CDATA[").append("A").append("]]></editFlag>");
							HeaderXmlString.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>");
							HeaderXmlString.append("<action><![CDATA[").append("SAVE").append("]]></action>");
							HeaderXmlString.append("<elementName><![CDATA[").append("").append("]]></elementName>");
							HeaderXmlString.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
							HeaderXmlString.append("<taxKeyValue><![CDATA[").append("").append("]]></taxKeyValue>");
							HeaderXmlString.append("<saveLevel><![CDATA[").append("1").append("]]></saveLevel>");
							HeaderXmlString.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>");
							HeaderXmlString.append("<taxInFocus><![CDATA[").append(false).append("]]></taxInFocus>");
							HeaderXmlString.append("<description>").append("Header0 members").append("</description>");
							//price_list from distorder_type where tran_type
							//priceList = getColumnDescr(conn, "price_list", "distorder_type", "tran_type", orderType);
							priceListType = disCommon.getPriceListType(priceList,conn);
							//System.out.println("count :" + count);
							if (!"I".equalsIgnoreCase(priceListType))
							{
								rate = disCommon.pickRate(priceList, getCurrdateAppFormat(campgnNo), tempObj.getItemCode(), "", priceListType,conn); //lotSL not set
							}
							else
							{
								//tabValue = tempObj.getSiteCodeShip() + "~t" + tempObj.getLocCode() + "~t" + tempObj.getLotNo()  + "~t" + tempObj.getLotSl() ;
								//System.out.println("tabValue :" + tabValue);
								// rate can be picked in issue only as stock details are not available during order
								rate = 0;//disCommon.pickRate(priceList, getCurrdateAppFormat(), tempObj.getItemCode(), tabValue, "I",conn);
								//System.out.println("rate2 :" + rate2);
							}
							
							HeaderXmlString.append("<Detail1 dbID=\"\" domID=\"1\" objName=\"dist_order\" objContext=\"1\">");
							HeaderXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>");
							HeaderXmlString.append("<dist_order/>");
							HeaderXmlString.append("<order_date><![CDATA["+getCurrdateAppFormat(campgnNo)+"]]></order_date>");
							//Changed by wasim on 03-03-2016 as site code dlv and site code ship is reverse vise versa [START]
							HeaderXmlString.append("<site_code__ship><![CDATA[").append(tempObj.getSiteCodeShip()).append("]]></site_code__ship>");
							HeaderXmlString.append("<site_code__dlv><![CDATA[").append(tempObj.getSiteCode()).append("]]></site_code__dlv>");
							//Changed by wasim on 03-03-2016 as site code dlv and site code ship is reverse vise versa [END]
							HeaderXmlString.append("<ship_date><![CDATA["+getCurrdateAppFormat(campgnNo)+"]]></ship_date>");
							HeaderXmlString.append("<due_date><![CDATA["+getCurrdateAppFormat(campgnNo)+"]]></due_date>");
							
							//added by azhar 29-NOV-16[START]
							if(workOrder.isEmpty()){
								 doRemarks = "DO is created against campaign no[" + campgnNo + "] ";
							}else{
								doRemarks = "DO is created against workorder no[" + workOrder + "] ";
							}
							HeaderXmlString.append("<remarks><![CDATA[" + doRemarks + "]]></remarks>");
							// added by azhar 29-NOV-16[END]
							
							//HeaderXmlString.append("<remarks/>");
							//HeaderXmlString.append("<dist_route><![CDATA[").append((distDetailMap.containsKey("dist_route")?distDetailMap.get("dist_route"):distRoute)).append("]]></dist_route>");
							HeaderXmlString.append("<price_list><![CDATA[").append(priceList).append("]]></price_list>");
							HeaderXmlString.append("<confirmed><![CDATA[N]]></confirmed>");
							HeaderXmlString.append("<chg_user><![CDATA["+chgUser+"]]></chg_user>");
							HeaderXmlString.append("<chg_term><![CDATA["+termId+"]]></chg_term>");
							HeaderXmlString.append("<target_wgt><![CDATA[0]]></target_wgt>");
							HeaderXmlString.append("<target_vol><![CDATA[0]]></target_vol>");
							HeaderXmlString.append("<loc_code__git><![CDATA[").append(locCodeGit).append("]]></loc_code__git>");
							//HeaderXmlString.append("<loc_code__git/>");
							HeaderXmlString.append("<chg_date><![CDATA["+getCurrdateAppFormat(campgnNo)+"]]></chg_date>");
							HeaderXmlString.append("<site_from_descr/>");
							HeaderXmlString.append("<site_to_descr/>");
							HeaderXmlString.append("<location_descr/>");
							HeaderXmlString.append("<conf_date><![CDATA["+getCurrdateAppFormat(campgnNo)+"]]></conf_date>");
							HeaderXmlString.append("<site_code><![CDATA["+tempObj.getSiteCode()+"]]></site_code>");
							//HeaderXmlString.append("<status><![CDATA[").append((distDetailMap.containsKey("status")?distDetailMap.get("status"):priceList)).append("]]></status>");
							//HeaderXmlString.append("<sale_order><![CDATA[").append((distDetailMap.containsKey("sale_order")?distDetailMap.get("sale_order"):saleOrder)).append("]]></sale_order>");
							HeaderXmlString.append("<remarks1/>");
							HeaderXmlString.append("<remarks2/>");
							//HeaderXmlString.append("<order_type><![CDATA[").append(orderType).append("]]></order_type>");
							HeaderXmlString.append("<tran_type><![CDATA[").append(orderType).append("]]></tran_type>");
							HeaderXmlString.append("<a_site_add1/>");
							HeaderXmlString.append("<a_site_add2/>");
							HeaderXmlString.append("<a_site_city/>");
							HeaderXmlString.append("<a_site_pin/>");
							HeaderXmlString.append("<a_site_state_code/>");
							HeaderXmlString.append("<b_site_add1/>");
							HeaderXmlString.append("<b_site_add2/>");
							HeaderXmlString.append("<b_site_city/>");
							HeaderXmlString.append("<b_site_pin/>");
							HeaderXmlString.append("<b_site_state_code/>");
							HeaderXmlString.append("<loc_code__cons/>");
							//HeaderXmlString.append("<sundry_type><![CDATA[").append((distDetailMap.containsKey("sundry_type")?distDetailMap.get("sundry_type"):sundryType)).append("]]></sundry_type>");
							//HeaderXmlString.append("<sundry_code><![CDATA[").append((distDetailMap.containsKey("sundry_code")?distDetailMap.get("sundry_code"):sundryCode)).append("]]></sundry_code>");
							//HeaderXmlString.append("<auto_receipt><![CDATA[Y]]></auto_receipt>");
							HeaderXmlString.append("<auto_receipt><![CDATA[").append(autoReceipt).append("]]></auto_receipt>");
							//HeaderXmlString.append("<tran_type><![CDATA[IT]]></tran_type>"); //discuss with sir pending
							HeaderXmlString.append("<curr_code><![CDATA[" + currCode + "]]></curr_code>");
							HeaderXmlString.append("<exch_rate><![CDATA[1]]></exch_rate>");
							HeaderXmlString.append("<sales_pers><![CDATA[]]></sales_pers>");
							HeaderXmlString.append("<sales_pers_sp_name><![CDATA[]]></sales_pers_sp_name>");
							HeaderXmlString.append("<loc_code__gitbf><![CDATA[").append(locCodeGitbf).append("]]></loc_code__gitbf>");
							//HeaderXmlString.append("<loc_code__gitbf><![CDATA[]]></loc_code__gitbf>");
							HeaderXmlString.append("<cust_code__dlv><![CDATA[]]></cust_code__dlv>");
							HeaderXmlString.append("<dlv_to></dlv_to>");
							HeaderXmlString.append("<dlv_add1><![CDATA[]]></dlv_add1>");
							HeaderXmlString.append("<dlv_add2><![CDATA[]]></dlv_add2>");
							HeaderXmlString.append("<dlv_add3><![CDATA[]]></dlv_add3>");
							HeaderXmlString.append("<dlv_city><![CDATA[]]></dlv_city>");
							HeaderXmlString.append("<state_code__dlv><![CDATA[]]></state_code__dlv>");
							HeaderXmlString.append("<count_code__dlv><![CDATA[]]></count_code__dlv>");
							HeaderXmlString.append("<dlv_pin><![CDATA[]]></dlv_pin>");
							HeaderXmlString.append("<stan_code><![CDATA[]]></stan_code>");
							HeaderXmlString.append("<tel1__dlv><![CDATA[]]></tel1__dlv>");
							HeaderXmlString.append("<tel2__dlv><![CDATA[]]></tel2__dlv>");
							HeaderXmlString.append("<tel3__dlv><![CDATA[]]></tel3__dlv>");
							HeaderXmlString.append("<fax__dlv><![CDATA[]]></fax__dlv>");
							HeaderXmlString.append("<avaliable_yn><![CDATA[").append(avaliableYN).append("]]></avaliable_yn>");
							//HeaderXmlString.append("<avaliable_yn><![CDATA[Y]]></avaliable_yn>");
							HeaderXmlString.append("<purc_order><![CDATA[]]></purc_order>");
							HeaderXmlString.append("<tot_amt><![CDATA[0]]></tot_amt>");
							HeaderXmlString.append("<tax_amt><![CDATA[0]]></tax_amt>");
							HeaderXmlString.append("<net_amt><![CDATA[0]]></net_amt>");
							HeaderXmlString.append("<tran_ser><![CDATA[]]></tran_ser>");
							HeaderXmlString.append("<price_list__clg><![CDATA["+ priceListClg + "]]></price_list__clg>");
							HeaderXmlString.append("<dlv_term><![CDATA["+ dlvTerm + "]]></dlv_term>");
							HeaderXmlString.append("<loc><![CDATA[                         ]]></loc>");
							HeaderXmlString.append("<sundry_name><![CDATA[]]></sundry_name>");
							HeaderXmlString.append("<proj_code><![CDATA[]]></proj_code>");
							HeaderXmlString.append("<descr/>");
							HeaderXmlString.append("<policy_no><![CDATA[]]></policy_no>");
							HeaderXmlString.append("<loc_code__damaged><![CDATA[]]></loc_code__damaged>");
							HeaderXmlString.append("<site_code__bil><![CDATA[]]></site_code__bil>");
							HeaderXmlString.append("<d_site_descr><![CDATA[]]></d_site_descr>");
							HeaderXmlString.append("<d_site_add1><![CDATA[]]></d_site_add1>");
							HeaderXmlString.append("<d_site_add2><![CDATA[]]></d_site_add2>");
							HeaderXmlString.append("<d_site_city><![CDATA[]]></d_site_city>");
							HeaderXmlString.append("<d_site_pin><![CDATA[]]></d_site_pin>");
							HeaderXmlString.append("<d_site_state_code><![CDATA[]]></d_site_state_code>");
							//	HeaderXmlString.append("<trans_mode><![CDATA[").append((distDetailMap.containsKey("trans_mode")?distDetailMap.get("trans_mode"):transMode)).append("]]></trans_mode>");
							HeaderXmlString.append("</Detail1>\r\n");


							valueXmlString.append("<Detail2 dbID='' domID=\"1\" objName=\"dist_order\" objContext=\"2\">");
							valueXmlString.append("<attribute pkNames=\"\" selected=\"N\" updateFlag=\"A\" status=\"N\" />");
							valueXmlString.append("<dist_order/>");
							valueXmlString.append("<line_no><![CDATA["+count+"]]></line_no>");
							
							//Changed by wasim on 13-07-2016 to set line number order [START]
							tempObj.setLineNoOrder(String.valueOf(count));
							//Changed by wasim on 13-07-2016 to set line number order [END]
							
							valueXmlString.append("<tran_id__demand><![CDATA[]]></tran_id__demand>");
							valueXmlString.append("<item_code><![CDATA[").append(tempObj.getItemCode()).append("]]></item_code>");
							valueXmlString.append("<qty_order><![CDATA["+tempObj.getOtherSiteQty()+"]]></qty_order>");
							valueXmlString.append("<qty_confirm><![CDATA["+tempObj.getOtherSiteQty()+"]]></qty_confirm>");
							valueXmlString.append("<qty_received><![CDATA["+0+"]]></qty_received>");
							valueXmlString.append("<qty_shipped><![CDATA["+0+"]]></qty_shipped>");
							valueXmlString.append("<due_date><![CDATA["+getCurrdateAppFormat(campgnNo)+"]]></due_date>");
							valueXmlString.append("<tax_class><![CDATA[" + taxClass + "]]></tax_class>");
							//valueXmlString.append("<tax_chap><![CDATA[").append((distDetailMap.containsKey("tax_chap")?tagChkMapForDetail1.get("tax_chap"):taxChap)).append("]]></tax_chap>");
							valueXmlString.append("<tax_env><![CDATA[" +taxEnv +"]]></tax_env>");
							valueXmlString.append("<unit><![CDATA["+unit+"]]></unit>");
							valueXmlString.append("<item_descr><![CDATA["+itemDescr+"]]></item_descr>");
							//valueXmlString.append("<sale_order><![CDATA[").append((distDetailMap.containsKey("sale_order")?tagChkMapForDetail1.get("sale_order"):saleOrder)).append("]]></sale_order>");
							valueXmlString.append("<line_no__sord/>");
							valueXmlString.append("<rate><![CDATA["+rate+"]]></rate>");
							valueXmlString.append("<qty_return><![CDATA[0]]></qty_return>");
							valueXmlString.append("<discount><![CDATA[0]]></discount>");
							valueXmlString.append("<remarks><![CDATA[]]></remarks>");
							valueXmlString.append("<tot_amt><![CDATA[0]]></tot_amt>");
							valueXmlString.append("<tax_amt><![CDATA[0]]></tax_amt>");
							valueXmlString.append("<net_amt><![CDATA[0]]></net_amt>");
							rate = disCommon.pickRate(priceListClg, getCurrdateAppFormat(campgnNo), tempObj.getItemCode(), "", "B",conn); 
							valueXmlString.append("<rate__clg><![CDATA[" + rate + "]]></rate__clg>");
							valueXmlString.append("<qty_alloc><![CDATA[0]]></qty_alloc>");
							valueXmlString.append("<over_ship_perc><![CDATA[0]]></over_ship_perc>");
							//valueXmlString.append("<qty_details><![CDATA[]]></qty_details>");
							valueXmlString.append("<unit__alt><![CDATA["+unit+"]]></unit__alt>");
							valueXmlString.append("<conv__qty__alt><![CDATA[0]]></conv__qty__alt>");
							valueXmlString.append("<qty_order__alt><![CDATA[0]]></qty_order__alt>");
							valueXmlString.append("<ship_date><![CDATA["+getCurrdateAppFormat(campgnNo)+"]]></ship_date>");
							//valueXmlString.append("<work_order><![CDATA["+workorder+"]]></work_order>");//wasim work order in not showing in detail screen...it should show
							valueXmlString.append("<pack_instr><![CDATA[]]></pack_instr>");
							valueXmlString.append("</Detail2>\r\n");

							/*valueXmlString.append( "</Header0>\r\n" );
							valueXmlString.append("</group0>\r\n");
							valueXmlString.append("</DocumentRoot>");*/

							//String key = tempObj.getSiteCodeShip();
							String key = tempObj.getTransTran() +":"+ tempObj.getSiteCodeShip() +":"+ tempObj.getSiteCode();

							System.out.println("@@@Key="+key);

							if(DOXml.containsKey(key) && key!=null)
							{
								System.out.println("Key found");
								xmlString = String.valueOf(DOXml.get(key) + valueXmlString.toString());

								DOXml.put(key, xmlString);

							}
							else
							{
								System.out.println("Key not found");
								DOXml.put(key, HeaderXmlString.toString()+valueXmlString.toString());

							}
						}
						else if("P".equalsIgnoreCase(tempObj.getTransTran()))
						{
							//create sales order
							System.out.println("custCode from getSiteCode----->>["+tempObj.getSiteCode()+"]");
							System.out.println("custCode from getSiteCodeShip----->>["+tempObj.getSiteCodeShip()+"]");
							orderType = disCommon.getDisparams("999999", "AWMS_SO_ORDER_TYPE", conn);

							sql = "select unit from item where item_code = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, tempObj.getItemCode());
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								unit = checkNull(rs.getString("unit"));
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							System.out.println("Unit="+unit);

							sql = "select cust_code from site_customer where site_code__ch = ? "
									+ "and site_code = ? and channel_partner = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, tempObj.getSiteCode());
							pstmt.setString(2, tempObj.getSiteCodeShip());
							pstmt.setString(3, "Y");
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								custCode = checkNull(rs.getString(1));

							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							System.out.println("custCode from site_customer----->>["+custCode+"]");
							if(custCode.length() == 0)
							{
								sql = "select cust_code from customer where site_code = ? and channel_partner = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, tempObj.getSiteCode());
								pstmt.setString(2, "Y");
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									custCode = checkNull(rs.getString(1));
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								System.out.println("custCode from customer----->>["+custCode+"]");

							}

							sql = "select cr_term,tran_code,curr_code from customer where cust_code = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, custCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								crTerm = checkNull(rs.getString(1));
								tranCode = checkNull(rs.getString(2));
								currCode = checkNull(rs.getString(3));

							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							sql = "select cr_term,dlv_term, TRAN_CODE, addr1,addr2,addr3,tele1,tele2,tele3,trans_mode,stan_code,city,"
									+ "count_code,pin,state_code,CURR_CODE__FRT,CURR_CODE__INS ,cust_name "
									+ "from customer where cust_code = ? ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,custCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								//priceList = rs2.getString("price_list");
								//deliveryTerm = deliveryTerm == " " ? rs2.getString("dlv_term") : deliveryTerm;
								crTerm = checkNull(rs.getString("cr_term"));
								deliveryTerm=rs.getString("dlv_term");
								tranCode =rs.getString("TRAN_CODE")==null?" ":rs.getString("TRAN_CODE");
								//currCodeFrt =rs.getString("CURR_CODE__FRT")==null?" ":rs.getString("CURR_CODE__FRT");
								//currCodeIns =rs.getString("CURR_CODE__INS")==null?" ":rs.getString("CURR_CODE__INS");

								add1 = rs.getString("addr1")== null ?" ":rs.getString("addr1");
								add2 = rs.getString("addr2")==null ?" ":rs.getString("addr2");
								add3 = rs.getString("addr3")== null ?" ":rs.getString("addr3");
								tele1 = rs.getString("tele1")== null ?" ":rs.getString("tele1");
								tele2 = rs.getString("tele2")== null ?" ":rs.getString("tele2");
								tele3 = rs.getString("tele3")== null ?" ":rs.getString("tele3");
								stanCode = rs.getString("stan_code")==null ?" ":rs.getString("stan_code");
								city = rs.getString("city")== null ?" ":rs.getString("city");
								countCode = rs.getString("count_code")== null ?" ":rs.getString("count_code");
								pin = rs.getString("pin")== null ?" ":rs.getString("pin");
								stateCode = rs.getString("state_code")== null ?" ":rs.getString("state_code");
								System.out.println("");
								//dlvTO = rs.getString("cust_name") == null ?" ":rs.getString("cust_name");
								dlvDescr = rs.getString("cust_name");
								transMode = rs.getString("trans_mode")== null ?" ":rs.getString("trans_mode");

							}

							rs.close();
							rs =null;
							pstmt.close();
							pstmt = null;
							System.out.println("dlvAdd1 :"+add1);
							System.out.println("dlvAdd2 :"+add2);
							System.out.println("dlvAdd3 :"+add3);
							System.out.println("transMode :"+transMode);
							System.out.println("tranCode :"+tranCode);
							System.out.println("tele1 :"+tele1+" @tele2 :"+tele2+" @tele3 :"+tele3);

							HeaderXmlString.append("<?xml version='1.0' encoding='ISO-8859-1'?>\n");
							HeaderXmlString.append("<DocumentRoot>");
							HeaderXmlString.append("<description>").append("Datawindow Root").append("</description>");
							HeaderXmlString.append("<group0>");
							HeaderXmlString.append("<description>").append("Group0 description").append("</description>");
							HeaderXmlString.append("<Header0>");
							HeaderXmlString.append("<objName><![CDATA[").append("sorder").append("]]></objName>");
							HeaderXmlString.append("<pageContext><![CDATA[").append("1").append("]]></pageContext>");
							HeaderXmlString.append("<objContext><![CDATA[").append("1").append("]]></objContext>");
							HeaderXmlString.append("<editFlag><![CDATA[").append("A").append("]]></editFlag>");
							HeaderXmlString.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>");
							HeaderXmlString.append("<action><![CDATA[").append("SAVE").append("]]></action>");
							HeaderXmlString.append("<elementName><![CDATA[").append("").append("]]></elementName>");
							HeaderXmlString.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
							HeaderXmlString.append("<taxKeyValue><![CDATA[").append("").append("]]></taxKeyValue>");
							HeaderXmlString.append("<saveLevel><![CDATA[").append("1").append("]]></saveLevel>");
							HeaderXmlString.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>");
							HeaderXmlString.append("<taxInFocus><![CDATA[").append(false).append("]]></taxInFocus>");
							HeaderXmlString.append("<description>").append("Header0 members").append("</description>");

							HeaderXmlString.append("<Detail1 dbID=\"\" domID=\"1\" objName=\"sorder\" objContext=\"1\">");
							HeaderXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"N\" pkNames=\"\"/>");
							HeaderXmlString.append("<sale_order/>");
							//HeaderXmlString.append("<order_type><![CDATA["+ orderType +"]]></order_type>");
							HeaderXmlString.append("<tran_type><![CDATA["+ orderType +"]]></tran_type>");
							HeaderXmlString.append("<order_date><![CDATA["+ getCurrdateAppFormat(campgnNo)  +"]]></order_date>");
							itemSeries = getColumnDescr(conn, "item_ser", "item", "item_code", tempObj.getItemCode(),campgnNo);
							HeaderXmlString.append("<item_ser><![CDATA["+ itemSeries +"]]></item_ser>");
							HeaderXmlString.append("<site_code><![CDATA["+ tempObj.getSiteCode() +"]]></site_code>");
							HeaderXmlString.append("<site_code__ship><![CDATA["+ tempObj.getSiteCodeShip() +"]]></site_code__ship>");
							HeaderXmlString.append("<cust_code><![CDATA["+ custCode +"]]></cust_code>");
							HeaderXmlString.append("<dlv_to><![CDATA["+ dlvDescr +"]]></dlv_to>");
							HeaderXmlString.append("<cust_code__bil><![CDATA["+ custCode +"]]></cust_code__bil>");
							HeaderXmlString.append("<cust_code__dlv><![CDATA["+ custCode +"]]></cust_code__dlv>");
							HeaderXmlString.append("<stan_code><![CDATA["+ stanCode.trim() +"]]></stan_code>");
							HeaderXmlString.append("<STAN_CODE__INIT><![CDATA["+ stanCode.trim() +"]]></STAN_CODE__INIT>");
							HeaderXmlString.append("<cr_term><![CDATA["+ crTerm +"]]></cr_term>");
							HeaderXmlString.append("<curr_code__frt><![CDATA["+ currCode +"]]></curr_code__frt>");
							HeaderXmlString.append("<trans_mode><![CDATA["+ transMode.trim() +"]]></trans_mode>");
							HeaderXmlString.append("<emp_code__ord><![CDATA["+ chgUser +"]]></emp_code__ord>");
							HeaderXmlString.append("<curr_code__frt><![CDATA["+currCode +"]]></curr_code__frt>");
							HeaderXmlString.append("<curr_code__ins><![CDATA["+ currCode +"]]></curr_code__ins>");
							HeaderXmlString.append("<curr_code><![CDATA["+currCode +"]]></curr_code>");
							HeaderXmlString.append("<exch_rate><![CDATA[" + "1" + "]]></exch_rate>");
							HeaderXmlString.append("<tax_opt><![CDATA[" + "2" + "]]></tax_opt>");

							HeaderXmlString.append("<dlv_city><![CDATA["+ city +"]]></dlv_city>");
							HeaderXmlString.append("<dlv_pin><![CDATA["+ pin +"]]></dlv_pin>");
							HeaderXmlString.append("<dlv_add1><![CDATA["+ add1 +"]]></dlv_add1>");
							HeaderXmlString.append("<dlv_add2><![CDATA["+ add2 +"]]></dlv_add2>");
							HeaderXmlString.append("<dlv_add3><![CDATA["+ add3 +"]]></dlv_add3>");
							HeaderXmlString.append("<tel1__dlv><![CDATA["+ tele1 +"]]></tel1__dlv>");
							HeaderXmlString.append("<tel2__dlv><![CDATA["+ tele2 +"]]></tel2__dlv>");
							HeaderXmlString.append("<tel3__dlv><![CDATA["+ tele3 +"]]></tel3__dlv>");
							HeaderXmlString.append("<state_code__dlv><![CDATA["+ stateCode +"]]></state_code__dlv>");
							HeaderXmlString.append("<count_code__dlv><![CDATA["+ countCode +"]]></count_code__dlv>");

							HeaderXmlString.append("<dlv_term><![CDATA["+ deliveryTerm +"]]></dlv_term>");
							HeaderXmlString.append("<chg_user><![CDATA["+ chgUser +"]]></chg_user>");
							HeaderXmlString.append("<chg_term><![CDATA["+ termId +"]]></chg_term>");
							HeaderXmlString.append("<chg_date><![CDATA["+ getCurrdateAppFormat(campgnNo) +"]]></chg_date>");

							HeaderXmlString.append("<tran_code><![CDATA["+ tranCode +"]]></tran_code>");
							HeaderXmlString.append("<price_list><![CDATA["+ priceList +"]]></price_list>");

							HeaderXmlString.append( "<rcp_mode><![CDATA[" ).append( "Q" ).append( "]]></rcp_mode>\r\n" );
							HeaderXmlString.append( "<user_remarks><![CDATA[" ).append( "Created from firm plan" ).append( "]]></user_remarks>\r\n" );
							/*HeaderXmlString.append("<tax_class><![CDATA["+taxClass +"]]></tax_class>");
							HeaderXmlString.append("<tax_chap><![CDATA["+taxChap +"]]></tax_chap>");
							HeaderXmlString.append("<tax_env><![CDATA["+ taxEnv+"]]></tax_env>");*/

							HeaderXmlString.append("</Detail1>\r\n");

							priceList = getColumnDescr(conn, "price_list", "distorder_type", "tran_type", orderType,campgnNo);
							rate = disCommon.pickRate(priceList, getCurrdateAppFormat(campgnNo), tempObj.getItemCode(), "", "I",conn); //lotSL not set
							System.out.println("Rate---------->>["+rate+"]");


							System.out.println("Line number sorddet="+count);
							System.out.println("Item code sorddet="+tempObj.getItemCode());

							String key = tempObj.getTransTran() +":"+ tempObj.getSiteCodeShip() +":"+ tempObj.getSiteCode();
							count = 0;
							if(siteXMLLineNo.containsKey(key) && tempObj.getSiteCodeShip()!=null)
							{
								count = (Integer) siteXMLLineNo.get(key);
							}
							System.out.println("New line number ="+count);
							count++;

							valueXmlString.append("<Detail2 objContext=\"2\" objName=\"sorder\" domID=\""+count+"\" dbID=\"\" >\r\n");
							valueXmlString.append("<attribute selected=\"N\" updateFlag=\"A\" status=\"O\" pkNames=\"\" />\r\n");

							valueXmlString.append("<sale_order/>");
							valueXmlString.append( "<line_no><![CDATA[" ).append(count).append( "]]></line_no>\r\n" );
							
							//Changed by wasim on 13-07-2016 to set line number order [START]
							tempObj.setLineNoOrder(String.valueOf(count));
							//Changed by wasim on 13-07-2016 to set line number order [END]
							
							valueXmlString.append( "<site_code><![CDATA[" ).append( tempObj.getSiteCode() ).append( "]]></site_code>\r\n" );
							valueXmlString.append( "<item_flg><![CDATA[" ).append( "I" ).append( "]]></item_flg>\r\n" );
							valueXmlString.append( "<quantity><![CDATA[" ).append( tempObj.getOtherSiteQty() ).append( "]]></quantity>\r\n" );

							java.util.Date date = getCurrtDate(campgnNo);
							Calendar cal = Calendar.getInstance();
							cal.setTime(date);
							cal.add(Calendar.DATE, 1);
							date = cal.getTime();
							java.sql.Timestamp dateT1 = new java.sql.Timestamp(date.getTime());
							 String currDatePlus1 = (new SimpleDateFormat(genericUtility.getApplDateFormat())).format(dateT1).toString();

							 System.out.println("Sale order rate="+rate);

							valueXmlString.append( "<dsp_date><![CDATA[" ).append( currDatePlus1 ).append( "]]></dsp_date>\r\n" );
							valueXmlString.append( "<rate><![CDATA[" ).append(rate).append( "]]></rate>\r\n" );//
							valueXmlString.append( "<discount><![CDATA[" ).append( "0" ).append( "]]></discount>\r\n" );
							//valueXmlString.append( "<tax_amt><![CDATA[" ).append( taxAmt ).append( "]]></tax_amt>\r\n" );
							//valueXmlString.append( "<tax_env><![CDATA[" ).append( taxEnv ).append( "]]></tax_env>\r\n" );
							//valueXmlString.append( "<net_amt><![CDATA[" ).append( netAmt ).append( "]]></net_amt>\r\n" );
							itemDescr = getColumnDescr(conn, "descr", "item", "item_code", tempObj.getItemCode(),campgnNo);
							valueXmlString.append( "<item_descr><![CDATA[" ).append( itemDescr ).append( "]]></item_descr>\r\n" );
							valueXmlString.append( "<item_code><![CDATA[" ).append( tempObj.getItemCode() ).append( "]]></item_code>\r\n" );
							valueXmlString.append( "<item_code__ord><![CDATA[" ).append( tempObj.getItemCode() ).append( "]]></item_code__ord>\r\n" );
							valueXmlString.append( "<item_ser><![CDATA[" ).append( itemSeries ).append( "]]></item_ser>\r\n" );
							valueXmlString.append( "<hold_flag><![CDATA[" ).append( "N" ).append( "]]></hold_flag>\r\n" );
							/*valueXmlString.append("<tax_class><![CDATA["+taxClass +"]]></tax_class>");
							valueXmlString.append("<tax_chap><![CDATA["+taxChap +"]]></tax_chap>");
							valueXmlString.append("<tax_env><![CDATA["+ taxEnv +"]]></tax_env>");*/
							valueXmlString.append("<unit><![CDATA["+unit+"]]></unit>");

							valueXmlString.append("</Detail2>\r\n");

							//String key = tempObj.getSiteCodeShip();
							System.out.println("@@@Key="+key);

							if(DOXml.containsKey(key) && key!=null)
							{
								System.out.println("Key found");
								xmlString = String.valueOf(DOXml.get(key) + valueXmlString.toString());

								DOXml.put(key, xmlString);

								siteXMLLineNo.put(key, count);
							}
							else
							{
								System.out.println("Key not found");
								DOXml.put(key, HeaderXmlString.toString()+valueXmlString.toString());

								siteXMLLineNo.put(key, count);
							}
						}
					}
				}
				

				//Changed by wasim on 03-03-2016 to save and confirm the DO/SO [START]
				 System.out.println("Out from Main Loop");
				 String last = "</Header0></group0></DocumentRoot>";

				 String transKey = "",objName = "",orderNo = "";
				 Set set = DOXml.entrySet();
				 Iterator i = set.iterator();
			      while(i.hasNext())
			      {
			         Map.Entry me = (Map.Entry)i.next();
			         me.getKey();
			         me.getValue();

			         System.out.println("Key before save is="+ me.getKey());
			         String[] siteCodeSave = String.valueOf(me.getKey()).split(":");
			         System.out.println("SiteCode save="+siteCodeSave[1]);

			         System.out.println("KESET--->"+me);
			         
			         //InsertCrossDockAlloc(siteCodeSave[0],siteCodeSave[1],siteCodeSave[2],conn);

			         Document dom = genericUtility.parseString(me.getValue().toString()+last);
			         objName = genericUtility.getColumnValue("objName", dom).trim();

			         System.out.println("ObjName["+objName+"]");
			         if("sorder".equalsIgnoreCase(objName))
			         {
			        	 transKey = "P";
			         }
			         else
			         {
			        	 transKey = "D";
			         }
			         System.out.println("Trans key="+transKey);

			     	 //returnString = saveData(String.valueOf(me.getKey()),  String.valueOf(me.getValue())+last, conn);
			         returnString = saveData(siteCodeSave[1],  String.valueOf(me.getValue())+last, conn,campgnNo,xtraParams);
			         System.out.println("Return from save data DO/SO"+returnString);

			            if(returnString != null && returnString.indexOf("Success") > -1)
						{
							String[] arrayForTranId = returnString.split("<TranID>");
							int endIndex = arrayForTranId[1].indexOf("</TranID>");
							orderNo = arrayForTranId[1].substring(0,endIndex);
							System.out.println("distOrderNo/Sale Order No------>>>["+orderNo+"]");
							// 13-jun-16 manoharan sord/dist order reference required
							//InsertCrossDockAlloc(siteCodeSave[0],siteCodeSave[1],siteCodeSave[2],conn, orderNo);
							//Changed by wasim on 29-02-2016 to commit the transaction as NVO call for confirmation [START]
							System.out.println("Connection need to be committed for NVO call for DO/SO");
							conn.commit();
							//Changed by wasim on 29-02-2016 to commit the transaction as NVO call for confirmation [END]
							
							returnString = confirmSaleDistOrder(objName,orderNo,xtraParamsG,"",conn,campgnNo);
							System.out.println("@@After retString DO/SO------>>["+returnString+"]");
							if(returnString != null && ((returnString.indexOf("VTSUCC1") > -1) || (returnString.indexOf("PRCSTATUS") > -1)))
							{
								if("C".equalsIgnoreCase(itemFlag)){
									InsertCrossDockAlloc(siteCodeSave[0],siteCodeSave[1],siteCodeSave[2],orderNo,conn,campgnNo);
									
									returnString = CreateDistSorderAllocation(orderNo,transKey,conn,campgnNo);	
								}
								
								
								
								/*
								MfgCommon mfgc = new MfgCommon();
								String envMfg = mfgc.getEnvMfg("999999", "IS_CREATE_DI", conn);
								
								System.out.println("value in mfgparm in WOFirmPlanPrc::: " + envMfg);
								
								if(envMfg.equalsIgnoreCase("YES")){
								
									returnString = InsertDistIssue(orderNo,conn,campgnNo,workOrder,xtraParams);
								}*/
								
								
								//int lineNoCnt = 0;
								/*if("D".equalsIgnoreCase(transKey))
								{
									sql = "SELECT D.ITEM_CODE,H.SITE_CODE__SHIP FROM DISTORDER H,DISTORDER_DET D WHERE H.DIST_ORDER = D.DIST_ORDER "
											+ "AND H.DIST_ORDER = ?";
								}
								else
								{
									sql = "SELECT ITEM_CODE,SITE_CODE AS SITE_CODE__SHIP FROM SORDDET WHERE SALE_ORDER = ?";
								}
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,distOrderNo );
								rs = pstmt.executeQuery();

								while(rs.next())
								{
									System.out.println("Line number="+lineNoCnt);

									System.out.println("Loooooooooop");
									if("D".equalsIgnoreCase(transKey))
									{
										detailMap.put("TYPE", "D");
										detailMap.put("DIST_ORDER", distOrderNo);
									}
									else
									{
										detailMap.put("TYPE", "P");
										detailMap.put("SALE_ORDER", distOrderNo);
									}

									detailMap.put("ITEM_CODE", rs.getString("ITEM_CODE").trim());
									detailMap.put("SITE_CODE", rs.getString("SITE_CODE__SHIP").trim());
									//detailMap.put("TYPE", "D");
									//detailMap.put("DIST_ORDER", distOrderNo);
									detailMap.put("LINE_NO", String.valueOf(lineNoCnt));

									saleDistOrderMap.put(rs.getString("SITE_CODE__SHIP")+":"+rs.getString("ITEM_CODE"),  distOrderNo);*/

									//returnString = CreateDistSorderAllocation(orderNo,transKey,conn);
									//detailMap.clear();
									//System.out.println("After Type = D returnString CreateDistSorderAllocation: "+returnString);
									//lineNoCnt++;
								
								//pstmt.close();pstmt=null;
								//rs.close();rs=null;
							}
							else
							{
								System.out.println("DO/SO is not get confirmed");
								throw new Exception(returnString);
							}
						}
						else
						{
							System.out.println("Data not saved for DO/SO");
							throw new Exception(returnString);
						}
			      }
			    //Changed by wasim on 03-03-2016 to save and confirm the DO/SO [START]
		}
		catch(ITMException e)
		{
			e.printStackTrace();
			System.out.println("ITMException ::createDistOrder :==>");
			writeWorkOrderLog(e.toString(),campgnNo);//TODO
			throw new ITMException(e);
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception ::createDistOrder :==>");
			writeWorkOrderLog(e.toString(),campgnNo);//TODO
			throw new Exception(e);
		}
		System.out.println("returnString from dist_order------->>[" + returnString+"]");
		return returnString;

	}


	private String saveData(String siteCode, String valueXmlString, Connection conn,String campgnNo,String xtraParams) throws ITMException, Exception
	{

		System.out.println("saving data...........");
		InitialContext ctx = null;
		String retString = null;
		MasterStatefulLocal masterStateful = null; // for ejb3
		UserInfoBean userInfo = new UserInfoBean();
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
			userInfo.setEmpCode(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"));
			userInfo.setEntityCode(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode"));
			userInfo.setRemoteHost(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId"));
			userInfo.setLoginCode(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgUser"));
			userInfo.setSiteCode(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode"));
			userInfo.setProfileId(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "profileId"));
			userInfo.setUserType(genericUtility.getValueFromXTRA_PARAMS(xtraParams, "userType"));
			userInfo.setTransDB("DriverITM");
			masterStateful = (MasterStatefulLocal)ctx.lookup("ibase/MasterStatefulEJB/local");
			masterStateful.setUserInfo(userInfo);

			String [] authencate = new String[2];
			authencate[0] = "";
			authencate[1] = "";
			System.out.println("xmlString in masterStateful :::: " + valueXmlString);
			//retString = masterStateful.processRequest(authencate, siteCode, true, valueXmlString, true, conn); //commented by azhar
			retString = masterStateful.processRequest(userInfo,valueXmlString, true, conn);
			masterStateful = null;

		}
		catch(ITMException e)
		{
			e.printStackTrace();
			System.out.println("ITMException ::saveData :==>");
			writeWorkOrderLog(e.toString(),campgnNo);//TODO
			throw new ITMException(e);
		}
		catch(Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception ::saveData :==>");
			writeWorkOrderLog(e.toString(),campgnNo);//TODO
			throw new Exception(e);
		}
		return retString;
	}

	public String getColumnDescr(Connection conn, String columnName,String tableName, String columnName2, String value,String campgnNo) throws Exception
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String findValue = "";
		try
		{
			if(conn == null)
			{
				System.out.println("conn is null.............");
			}
			System.out.println("columnName............."+columnName);
			System.out.println("tableName............."+tableName);
			System.out.println("value............."+value);
			sql = "SELECT " + columnName + " from " + tableName + " where "
					+ columnName2 + "= ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, value);
			rs = pstmt.executeQuery();
			if (rs.next()) {
				findValue = rs.getString(1);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		} catch (Exception e) {
			System.out.println("Exception in getColumnDescr ");
			writeWorkOrderLog(e.toString(),campgnNo);//TODO
			e.printStackTrace();
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		System.out.println("returning String from getColumnDescr " + findValue);
		return findValue;
	}
	@SuppressWarnings("static-access")
	private String generateTranTd(String windowName,String tranDate,String siteCode, Connection  conn,String campgnNo)throws ITMException, SQLException
	{
		System.out.println("inside generateTranTd@@.........");//w_inv_allocate
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String sql = "";
		String tranId = "";
		String tranSer1 = "",keyString = "",keyCol = "";
		CommonConstants commonConstants = new CommonConstants();
		try
	 	{
			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat simpleDateFormatObj = new SimpleDateFormat(genericUtility.getApplDateFormat());
			tranDate = simpleDateFormatObj.format(currentDate.getTime());

			sql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, windowName);

			rs = pstmt.executeQuery();
			System.out.println("keyString :"+sql);

			if (rs.next())
			{
				keyString = rs.getString(1);
				keyCol = rs.getString(2);
				tranSer1 = rs.getString(3);
			}
			else
			{
				sql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, "GENERAL");
				rs = pstmt.executeQuery();
				System.out.println("keyString :"+sql);
				if (rs.next())
				{
					keyString = rs.getString(1);
					keyCol = rs.getString(2);
					tranSer1 = rs.getString(3);
				}
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			System.out.println("keyString :"+keyString);
			System.out.println("keyCol :"+keyCol);
			System.out.println("tranSer1 :"+tranSer1);
			String xmlValues = "";
			xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues +	"<tran_id></tran_id>";
			xmlValues = xmlValues + "<site_code>" + siteCode + "</site_code>";
			xmlValues = xmlValues + "<tran_date>"+ tranDate + "</tran_date>";
			xmlValues = xmlValues + "<tran_type>"+"U"+"</tran_type>";
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues  :["+xmlValues+"]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", commonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer1, keyCol, keyString, conn);

			System.out.println("tranId ::"+tranId);
		}
		catch (SQLException ex)
		{
			System.out.println("Exception ::" +sql+ ex.getMessage() + ":");
			ex.printStackTrace();
			writeWorkOrderLog(ex.toString(),campgnNo);//TODO
			throw new ITMException(ex);
		}
		catch (Exception e)
		{
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			writeWorkOrderLog(e.toString(),campgnNo);//TODO
			throw new ITMException(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}

		return tranId;
	}

	@SuppressWarnings("rawtypes")
	public ArrayList getWorkOrderStockObjList(Document headerDom, Document detailDom, String windowName, String xtraParams,String campgnNo) throws RemoteException,ITMException
	{
		try
		{
			System.out.println("--------------- Inside getWorkOrderStockObjList ----------------- ");
			//process(xmlString, xmlString2, windowName, xtraParams);
			processWorkOrder( headerDom,  detailDom,  windowName,  xtraParams);

		}
		catch (Exception e)
		{
			
			System.out.println("Exception :WoFirmplanPrc:getData method : " + e + ":");
			writeWorkOrderLog(e.toString(),campgnNo);//TODO
		}

		System.out.println("worderStkBeanList ::::::::::::::  " + worderStkBeanList);
		return worderStkBeanList;
	}
	private String updateStockAllocQty(Map<String,String> stockAllocMap,Connection conn,String campgnNo) throws Exception,ITMException
    {
		PreparedStatement pstmt = null,pstmtSel = null,pstmtCheck = null;
		ResultSet rs = null,rsCheck = null;
		String sql = "",sqlSel = "";
		int row = 0;
		try
		{
			if (CommonConstants.DB_NAME.equalsIgnoreCase("DB2") || CommonConstants.DB_NAME.equalsIgnoreCase("MYSQL") )
			{
				sqlSel = "SELECT ALLOC_QTY FROM STOCK" +
					  " WHERE ITEM_CODE = ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO = ? AND LOT_SL = ? FOR UPDATE";
			}
			else if (CommonConstants.DB_NAME.equalsIgnoreCase("MSSQL"))
			{
				sqlSel = "SELECT ALLOC_QTY FROM STOCK (UPDLOCK) " +
						  " WHERE ITEM_CODE = ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO = ? AND LOT_SL = ? FOR UPDATE ";
			}
			else
			{
				sqlSel = "SELECT ALLOC_QTY FROM STOCK" +
						  " WHERE ITEM_CODE = ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO = ? AND LOT_SL = ? FOR UPDATE NOWAIT";
			}
				pstmtSel = conn.prepareStatement(sqlSel);
				pstmtSel.setString(1, stockAllocMap.get("ITEM_CODE"));
				pstmtSel.setString(2, stockAllocMap.get("SITE_CODE"));
				pstmtSel.setString(3, stockAllocMap.get("LOC_CODE"));
				pstmtSel.setString(4, stockAllocMap.get("LOT_NO"));
				pstmtSel.setString(5, stockAllocMap.get("LOT_SL"));
				rs = pstmtSel.executeQuery();
				
				
				if(rs.next())
				{
					System.out.println("Alloc qty in update stock method["+rs.getString("ALLOC_QTY")+"]");
					
					sql = "UPDATE STOCK SET ALLOC_QTY = (CASE WHEN ALLOC_QTY IS NULL THEN 0 ELSE ALLOC_QTY END) + ? " +
							 " WHERE ITEM_CODE = ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO = ? AND LOT_SL = ?";
	
					pstmt = conn.prepareStatement(sql);
					pstmt.setDouble(1, Double.valueOf(stockAllocMap.get("ALLOC_QTY")));
					pstmt.setString(2, stockAllocMap.get("ITEM_CODE"));
					pstmt.setString(3, stockAllocMap.get("SITE_CODE"));
					pstmt.setString(4, stockAllocMap.get("LOC_CODE"));
					pstmt.setString(5, stockAllocMap.get("LOT_NO"));
					pstmt.setString(6, stockAllocMap.get("LOT_SL"));
	
					row = pstmt.executeUpdate();
					System.out.println("In updateStockAllocQty : "+row);
				}
				else
				{
					System.out.println("Error in select in updateStockAllocQty");
				}
				
				sql = "select alloc_qty from stock where item_code = ? and site_code = ? and loc_code = ? and lot_no = ? and lot_sl = ?";
				pstmtCheck = conn.prepareStatement(sqlSel);
				pstmtCheck.setString(1, stockAllocMap.get("ITEM_CODE"));
				pstmtCheck.setString(2, stockAllocMap.get("SITE_CODE"));
				pstmtCheck.setString(3, stockAllocMap.get("LOC_CODE"));
				pstmtCheck.setString(4, stockAllocMap.get("LOT_NO"));
				pstmtCheck.setString(5, stockAllocMap.get("LOT_SL"));
				rsCheck = pstmtCheck.executeQuery();
				
				if(rsCheck.next()){
					System.out.println("alloc qty after update::["+rsCheck.getString("alloc_qty")+"]");
				}
				
				if(pstmtSel!=null)
				{
					pstmtSel.close();pstmtSel = null;
				}
				if(rs!=null)
				{
					rs.close();rs = null;
				}
				if(pstmtCheck!=null)
				{
					pstmtCheck.close();pstmtCheck = null;
				}
				if(rsCheck!=null)
				{
					rsCheck.close();rsCheck = null;
				}
				
		}
        catch(Exception e)
        {
        	e.printStackTrace();
        	System.out.println("Exception in updateStockAllocQty : " + e.getMessage());
        	writeWorkOrderLog(e.toString(),campgnNo);//TODO
        	throw new Exception(e);
        }
		finally
		{
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(pstmtSel!=null)
			{
				pstmtSel.close();pstmtSel = null;
			}
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
		}

		if(row > 0)
		{
			return "Success";
		}

		return "Error";
    }
	/*private String updatePotencyStockAllocQty(Map<String,String> stockAllocMap,Connection conn,String campgnNo) throws Exception,ITMException
    {
		PreparedStatement pstmt = null,pstmtSel = null;
		ResultSet rs = null;
		String sql = "",sqlSel = "";
		int row = 0;
		try
		{
			if (CommonConstants.DB_NAME.equalsIgnoreCase("DB2") || CommonConstants.DB_NAME.equalsIgnoreCase("MYSQL") )
			{
				sqlSel = "SELECT ALLOC_QTY FROM STOCK" +
					  " WHERE ITEM_CODE = ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO = ? AND LOT_SL = ? ";
			}
			else if (CommonConstants.DB_NAME.equalsIgnoreCase("MSSQL"))
			{
				sqlSel = "SELECT ALLOC_QTY FROM STOCK (UPDLOCK) " +
						  " WHERE ITEM_CODE = ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO = ? AND LOT_SL = ?";
			}
			else
			{
				sqlSel = "SELECT ALLOC_QTY FROM STOCK" +
						  " WHERE ITEM_CODE = ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO = ? AND LOT_SL = ? ";
			}
				pstmtSel = conn.prepareStatement(sqlSel);
				pstmtSel.setString(1, stockAllocMap.get("ITEM_CODE"));
				pstmtSel.setString(2, stockAllocMap.get("SITE_CODE"));
				pstmtSel.setString(3, stockAllocMap.get("LOC_CODE"));
				pstmtSel.setString(4, stockAllocMap.get("LOT_NO"));
				pstmtSel.setString(5, stockAllocMap.get("LOT_SL"));
				rs = pstmtSel.executeQuery();
				
				
				if(rs.next())
				{
					System.out.println("Alloc qty in potency update stock method["+rs.getString("ALLOC_QTY")+"]");
					
					sql = "UPDATE STOCK SET ALLOC_QTY = (CASE WHEN ALLOC_QTY IS NULL THEN 0 ELSE ALLOC_QTY END) + ? " +
							 " WHERE ITEM_CODE = ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO = ? AND LOT_SL = ?";
	
					pstmt = conn.prepareStatement(sql);
					pstmt.setDouble(1, Double.valueOf(stockAllocMap.get("ALLOC_QTY")));
					pstmt.setString(2, stockAllocMap.get("ITEM_CODE"));
					pstmt.setString(3, stockAllocMap.get("SITE_CODE"));
					pstmt.setString(4, stockAllocMap.get("LOC_CODE"));
					pstmt.setString(5, stockAllocMap.get("LOT_NO"));
					pstmt.setString(6, stockAllocMap.get("LOT_SL"));
	
					row = pstmt.executeUpdate();
					System.out.println("In updateStockAllocQty : "+row);
				}
				else
				{
					System.out.println("Error in select in updateStockAllocQty");
				}
				if(pstmtSel!=null)
				{
					pstmtSel.close();pstmtSel = null;
				}
				if(rs!=null)
				{
					rs.close();rs = null;
				}
				
		}
        catch(Exception e)
        {
        	e.printStackTrace();
        	System.out.println("Exception in updateStockAllocQty : " + e.getMessage());
        	writeWorkOrderLog(e.toString(),campgnNo);//TODO
        	throw new Exception(e);
        }
		finally
		{
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
			if(pstmtSel!=null)
			{
				pstmtSel.close();pstmtSel = null;
			}
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
		}

		if(row > 0)
		{
			return "Success";
		}

		return "Error";
    }*/
	private String getCurrdateAppFormat(String campgnNo)
    {
        String currDate = "";
        //GenericUtility genericUtility = GenericUtility.getInstance();
        try
        {
            java.util.Date date = null;
            Timestamp timestamp = new Timestamp(System.currentTimeMillis());
            System.out.println(genericUtility.getDBDateFormat());

            SimpleDateFormat simpledateformat = new SimpleDateFormat(genericUtility.getDBDateFormat());
            date = simpledateformat.parse(timestamp.toString());
            timestamp = Timestamp.valueOf(simpledateformat.format(date).toString() + " 00:00:00.0");
            currDate = (new SimpleDateFormat(genericUtility.getApplDateFormat())).format(timestamp).toString();
        }
        catch(Exception e)
        {
        	System.out.println("Exception in getCurrdateAppFormat " + e.getMessage());
        	writeWorkOrderLog(e.toString(),campgnNo);//TODO
        	e.printStackTrace();
        }
        return currDate;
    }
	public String confirmSaleDistOrder(String businessObj, String tranIdFr,String xtraParams, String forcedFlag, Connection conn,String campgnNo) throws ITMException
	{

		String methodName = "";
		String compName = "";
		String retString = "";
		String serviceCode = "";
		String serviceURI = "";
		String actionURI = "";
		String sql = "";
		PreparedStatement psmt = null;
		ResultSet rs = null;
		try
		{
			//ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			System.out.println("-------in confirmSaleOrder mothod----------------");
			tranIdFr=tranIdFr==null ? "" :tranIdFr.trim();
			System.out.println("Tran id for sale order--->>"+tranIdFr+"]");
			methodName = "gbf_post";
			actionURI = "http://NvoServiceurl.org/" + methodName;

			sql = "SELECT SERVICE_CODE,COMP_NAME FROM SYSTEM_EVENTS WHERE OBJ_NAME = ? AND EVENT_CODE = 'pre_confirm' ";
			psmt = conn.prepareStatement(sql);
			psmt.setString(1,businessObj);
			rs = psmt.executeQuery();
			if ( rs.next() )
			{
				serviceCode = rs.getString("SERVICE_CODE");
				compName = rs.getString("COMP_NAME");
			}
			compName=compName==null ? "" :compName.trim();
			System.out.println("serviceCode = ["+serviceCode+"]   compName ["+compName+"]");
			sql = "SELECT SERVICE_URI FROM SYSTEM_EVENT_SERVICES WHERE SERVICE_CODE = ? ";
			psmt = conn.prepareStatement(sql);
			psmt.setString(1,serviceCode);
			rs = psmt.executeQuery();
			if ( rs.next() )
			{
				serviceURI = rs.getString("SERVICE_URI");
			}
			serviceURI=serviceURI==null ? "" :serviceURI.trim();
			System.out.println("serviceURI = ["+serviceURI+"]---> compName = ["+compName+"]");
			Service service = new Service();
			Call call = (Call)service.createCall();
			call.setTargetEndpointAddress(new java.net.URL(serviceURI));
			call.setOperationName( new javax.xml.namespace.QName("http://NvoServiceurl.org", methodName ) );
			call.setUseSOAPAction(true);
			call.setSOAPActionURI(actionURI);
			Object[] aobj = new Object[4];

			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "component_name"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "tran_id"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "xtra_params"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "forced_flag"), XMLType.XSD_STRING, ParameterMode.IN);

			aobj[0] = new String(compName);
			aobj[1] = new String(tranIdFr);
			aobj[2] = new String(xtraParams);
			aobj[3] = new String(forcedFlag);
			//System.out.println("@@@@@@@@@@loginEmpCode:" +genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode")+":");
			System.out.println("@@@@@@ call.setReturnType(XMLType.XSD_STRING) executed........");
			call.setReturnType(XMLType.XSD_STRING);

			retString = (String)call.invoke(aobj);

			System.out.println("Confirm Complete @@@@@@@@@@@ Return string from NVO is:==>["+retString+"]");

		}
		catch(Exception e)
		{
			e.printStackTrace();
			writeWorkOrderLog(e.toString(),campgnNo);//TODO
			throw new ITMException(e);
		}
		finally
		{
			try{
				if (psmt != null )
				{
					psmt.close();
					psmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception inCalling confirmed");
				e.printStackTrace();
				writeWorkOrderLog(e.toString(),campgnNo);//TODO
				try{
					conn.rollback();

				}catch (Exception s)
				{
					System.out.println("Unable to rollback");
					writeWorkOrderLog(s.toString(),campgnNo);//TODO
					s.printStackTrace();
				}
				throw new ITMException(e);
			}

		}
		return retString;

	}
	@SuppressWarnings({ "rawtypes", "unchecked" })
	private String CreateDistSorderAllocation(String orderNo,String transKey,Connection conn,String campgnNo) throws Exception
	{
		PreparedStatement pstmt = null,pstmtOrder = null,pstmtInsert = null, pstmtQty = null;
		String sql = "",itemCode = "",siteCode = "",errorString = "",locCode = "",lotNo = "",lotSl = "",expLev = "",
				siteCodeMfg = "",unit = "",sqlInsert = "",sqlOrder = "",OrderItemCode = "", orderSiteCode = "";
		String lineNo = "",key = "";
		HashMap strAllocate = null,allocStckHmap = null;
		Map deallocMap = null;
		SiteItemSummaryBean siteSumBeanObj = new SiteItemSummaryBean();
		InvAllocTraceBean invAllocTrace = new InvAllocTraceBean();
		ResultSet rs = null;
		ArrayList allocStockList = new ArrayList();
		double allocQty =0,balanceQty = 0,QPerArtStk = 0, allocQtyStk = 0;
		Timestamp expDate = null,mfgDate = null;
		ResultSet rsOrder = null,rsQty = null;
		HashMap<String, Double> sameStockMap = new HashMap<String,Double>();
		
		try
		{
			System.out.println("Order Number["+orderNo+"] and trans key["+transKey+"]");
			
			if("P".equalsIgnoreCase(transKey))
			{
			 sqlInsert = " INSERT INTO SORDALLOC (SALE_ORDER,LINE_NO,ITEM_CODE,SITE_CODE,LOT_NO,LOT_SL,LOC_CODE,QTY_ALLOC,"//8
						+" UNIT,EXP_DATE,SITE_CODE__MFG,MFG_DATE,QUANTITY,"//13
						+" DATE_ALLOC,STATUS,ALLOC_MODE,CONV__QTY_STDUOM,UNIT__STD,QUANTITY__STDUOM,EXP_LEV,ITEM_CODE__ORD)"//21
						+" VALUES ( ?, ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? ,"						
						+" ?, ?, ?, ?, ?, ?, ?, ?, ? ) " ;
				
				sqlOrder = "SELECT ITEM_CODE,SITE_CODE,LINE_NO,QUANTITY,EXP_LEV FROM SORDITEM WHERE SALE_ORDER = ? AND LINE_TYPE = 'I'";
			}
			else if("D".equalsIgnoreCase(transKey))
			{
				sqlInsert = "INSERT INTO DISTORDER_ALLOC (DIST_ORDER,LINE_NO,ITEM_CODE,SITE_CODE__SHIP,LOT_NO,LOT_SL,LOC_CODE,QTY_ALLOC,UNIT,"
						+ " EXP_DATE,SITE_CODE__MFG,MFG_DATE,QUANTITY) "
						+ "values (?, ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ?)";//13
					
				/*sqlOrder = "SELECT D.ITEM_CODE,H.SITE_CODE__SHIP AS SITE_CODE,D.LINE_NO,D.QTY_CONFIRM AS QUANTITY,' ' AS EXP_LEV  FROM DISTORDER H,DISTORDER_DET D WHERE H.DIST_ORDER = D.DIST_ORDER "
						+ "AND H.DIST_ORDER = ?";*/
				
			/*sqlOrder = 	"select d.line_no__ord ,d.item_code ,d.loc_code,d.site_code,d.lot_no,d.lot_sl " +
					//",d.exp_lev, dt.qty_order as quantity " +      //changed by azhar because of unique constraint in distorder alloc
					"from cross_dock_alloc_det d " +
					//", distorder_det dt " +            //changed by azhar because of unique constraint in distorder alloc
					"where " +
					//"d.order_no = dt.dist_order and" +
					" d.order_no = ? group by d.line_no__ord,d.item_code, d.loc_code, d.site_code, d.lot_no, d.lot_sl" ;
					//",dt.qty_order";         
			*/   //commented by azhar as told by manoharan sir[09/jan/17]
			
			
				/*sqlOrder = " SELECT S.ITEM_CODE,S.LOC_CODE,S.SITE_CODE,S.LOT_NO,S.LOT_SL,D.LINE_NO__ORD AS LINE_NO,D.QUANTITY,"
						  + " S.EXP_DATE,S.SITE_CODE__MFG,S.MFG_DATE,S.UNIT,D.EXP_LEV "
						  + " FROM CROSS_DOCK_ALLOC_DET D,STOCK S "
						  + " WHERE D.ITEM_CODE = S.ITEM_CODE AND D.LOC_CODE = S.LOC_CODE AND D.SITE_CODE = S.SITE_CODE "
						  + " AND D.LOT_NO = S.LOT_NO AND D.LOT_SL = S.LOT_SL "
						  + " AND D.ORDER_NO = ? ";*/ //commented by azhar as told by manoj sir

			}
			//added by azhar as told by manoharan sir[09/jan/17][start]
			
			pstmtInsert = conn.prepareStatement(sqlInsert);
			
			
			
			for(int siteCtr =0 ; siteCtr < siteItemReqQtyList.size() ; siteCtr++)
			{
				siteSumBeanObj = (SiteItemSummaryBean) siteItemReqQtyList.get(siteCtr);
				allocStockList = siteSumBeanObj.getStockList();
				
				System.out.println("alloc stock list for distorder alloc::" + allocStockList.toString());
				System.out.println("alloc stock list size::" + allocStockList.size());
				
			for(int i = 0; i < allocStockList.size();i++){
			
				
				allocStckHmap = (HashMap)allocStockList.get(i);
				
				
				OrderItemCode = (String) allocStckHmap.get("ITEM_CODE");
				locCode = (String) allocStckHmap.get("LOC_CODE");
				orderSiteCode = (String) allocStckHmap.get("SITE_CODE");
				lotNo = (String) allocStckHmap.get("LOT_NO");
				lotSl = (String) allocStckHmap.get("LOT_SL");
				balanceQty = Double.parseDouble(allocStckHmap.get("QUANTITY").toString());
				expDate = (Timestamp) allocStckHmap.get("EXP_DATE");
				siteCodeMfg = (String) allocStckHmap.get("SITE_CODE__MFG");
				mfgDate = (Timestamp) allocStckHmap.get("MFG_DATE");
				unit = (String) allocStckHmap.get("UNIT");
				lineNo = siteSumBeanObj.getLineNoOrder();
				
				
			
				deallocMap = new HashMap();
			    strAllocate = new HashMap();
			    //added by azhar as told by manoharan sir[09/jan/17][end]
			/*pstmtOrder = conn.prepareStatement(sqlOrder);
			
			pstmtOrder.setString(1, orderNo);
			rsOrder = pstmtOrder.executeQuery();
			while(rsOrder.next())
			{
				    deallocMap = new HashMap();
				    strAllocate = new HashMap();
				    
				    OrderItemCode = rsOrder.getString("ITEM_CODE");
					locCode = rsOrder.getString("LOC_CODE");
					orderSiteCode = rsOrder.getString("SITE_CODE");
					lotNo = rsOrder.getString("LOT_NO");
					lotSl = rsOrder.getString("LOT_SL");
					lineNo = rsOrder.getString("line_no__ord");
					//balanceQty = rsOrder.getDouble("quantity");
					//expLev = rsOrder.getString("EXP_LEV");
					
				    sql = "select exp_date,site_code__mfg,mfg_date,unit,quantity,alloc_qty,qty_per_art from stock where item_code = ? and loc_code = ?" +
				    		" and site_code = ? and lot_no = ? and lot_sl = ?";
				    
				    pstmt= conn.prepareStatement(sql);
				    pstmt.setString(1, OrderItemCode);
				    pstmt.setString(2, locCode);
				    pstmt.setString(3, orderSiteCode);
				    pstmt.setString(4, lotNo);
				    pstmt.setString(5, lotSl);
				    rs = pstmt.executeQuery();
				    while(rs.next()){
				    	
						expDate = rs.getTimestamp("EXP_DATE");
						siteCodeMfg = rs.getString("SITE_CODE__MFG");
						mfgDate = rs.getTimestamp("MFG_DATE");
						unit = rs.getString("UNIT");
						balanceQty = rs.getDouble("quantity");
						allocQtyStk = rs.getDouble("alloc_qty");
						QPerArtStk = rs.getDouble("qty_per_art");
				    }
				    
				    if(allocQtyStk < QPerArtStk){
				    	
				    	balanceQty = QPerArtStk;
				    	
				    }//if part of quantity is allocated*/
				    
				    
					/*OrderItemCode = rsOrder.getString("ITEM_CODE");
					locCode = rsOrder.getString("LOC_CODE");
					orderSiteCode = rsOrder.getString("SITE_CODE");
					lotNo = rsOrder.getString("LOT_NO");
					lotSl = rsOrder.getString("LOT_SL");
					lineNo = rsOrder.getString("LINE_NO");
					balanceQty = rsOrder.getDouble("QUANTITY");
					expLev = rsOrder.getString("EXP_LEV");
					expDate = rsOrder.getTimestamp("EXP_DATE");
					siteCodeMfg = rsOrder.getString("SITE_CODE__MFG");
					mfgDate = rsOrder.getTimestamp("MFG_DATE");
					unit = rsOrder.getString("UNIT");*/
					
					System.out.println("Main Order quantity="+balanceQty);
					
					 pstmtInsert.setString(1, orderNo);
					 pstmtInsert.setString(2, lineNo);
					 pstmtInsert.setString(3, OrderItemCode);
					 pstmtInsert.setString(4, orderSiteCode);
					 pstmtInsert.setString(5, lotNo);
					 pstmtInsert.setString(6, lotSl);
					 pstmtInsert.setString(7, locCode);
					 pstmtInsert.setDouble(8, balanceQty);
					 pstmtInsert.setString(9, unit);
					 pstmtInsert.setTimestamp(10, expDate);
					 pstmtInsert.setString(11, siteCodeMfg);
					 pstmtInsert.setTimestamp(12, mfgDate);
					 pstmtInsert.setDouble(13, balanceQty);
						
					if("P".equalsIgnoreCase(transKey))
					{
						pstmtInsert.setTimestamp(14, getCurrtDate(campgnNo));
						pstmtInsert.setString(15, "P");
						pstmtInsert.setString(16, "A");
						pstmtInsert.setDouble(17, 1);
						pstmtInsert.setString(18, unit);
						pstmtInsert.setString(19, expLev);
						pstmtInsert.setDouble(20, balanceQty);
						pstmtInsert.setString(21, OrderItemCode);
						strAllocate.put("ref_ser","S-ORD");
					}
					else if("D".equalsIgnoreCase(transKey))
					{
						strAllocate.put("ref_ser","D-ORD");
					}	
					//pstmtInsert.addBatch();
					pstmtInsert.executeUpdate();
					
					deallocMap.put("ALLOC_QTY",""+(-1 * balanceQty));
					deallocMap.put("LOC_CODE", locCode);
					deallocMap.put("ITEM_CODE",itemCode);
					deallocMap.put("SITE_CODE",siteCode);
					deallocMap.put("LOT_NO",lotNo);
					deallocMap.put("LOT_SL",lotSl);
					
					errorString = updateStockAllocQty(deallocMap, conn,campgnNo);
					System.out.println("errorString after deallocate Stock update["+errorString+"]");
					
					strAllocate.put("tran_date",getCurrdateAppFormat(campgnNo));
					strAllocate.put("ref_id",orderNo);
					strAllocate.put("ref_line", "" + lineNo);
					strAllocate.put("site_code",siteCode);
					strAllocate.put("item_code",itemCode);
					strAllocate.put("loc_code", locCode);
					strAllocate.put("lot_no",lotNo);
					strAllocate.put("lot_sl",lotSl);
					strAllocate.put("alloc_qty", balanceQty);
					strAllocate.put("chg_user",chgUser);
					strAllocate.put("chg_term",termId);
					strAllocate.put("chg_win","w_wo_firmplan");
					if (allocQty != 0)
					{
						errorString = invAllocTrace.updateInvallocTrace(strAllocate, conn);
						System.out.println("errorString after updateInvallocTrace allocate----->2["+errorString+"]");
					}
					strAllocate = null;
					deallocMap = null;
			
			
			//pstmtInsert.executeBatch();
			
			
			//rsOrder.close();rsOrder = null;
			//pstmtOrder.close();pstmtOrder = null;
			//pstmtQty.close();pstmtQty = null;
			//rsQty.close();rsQty = null;
			}
			}
		}
		catch(Exception e)
		{
			e.printStackTrace();
			writeWorkOrderLog(e.toString(),campgnNo);//TODO
			throw new Exception(e);
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();rs = null; 
				}
				if(pstmt!=null)
				{
					pstmt.close();pstmt = null;
				}
				
				if(pstmtInsert!=null)
				{
					pstmtInsert.close();pstmtInsert = null;
				}
			}
			catch(Exception ex)
			{
				writeWorkOrderLog(ex.toString(),campgnNo);//TODO
				throw new Exception(ex);
			}
		}
		return "";

	}
	//private String CreateDistSorderAllocation(Map<String,String>detailMap,Connection conn) throws Exception
	/*private String CreateDistSorderAllocation(String orderNo,String transKey,Connection conn) throws Exception
	{
		PreparedStatement pstmt = null,pstmtSiteitem = null,pstmtOrder = null,pstmtInsert = null;
		String sql = "",itemCode = "",siteCode = "",errorString = "",locCode = "",lotNo = "",lotSl = "",sqlSiteitem = "",expLev = "",
				siteCodeMfg = "",unit = "",sqlInsert = "",sqlOrder = "",OrderItemCode = "", orderSiteCode = "";
		String lineNo = "";
		HashMap strAllocate = null;
		Map deallocMap = null;
		
		InvAllocTraceBean invAllocTrace = new InvAllocTraceBean();
		ArrayList stkList = null;
		ResultSet rs = null;
		double allocQty =0,quantity = 0,balanceQty = 0;
		WorderStkBean worderStkBeanObj = null;
		SiteItemSummaryBean SiteItemSummaryBeanObj = null;
		HashMap siteItemMap = null;
		Timestamp expDate = null,mfgDate = null;
		ResultSet rsOrder = null;
		try
		{
			itemCode = detailMap.get("ITEM_CODE");
			siteCode = detailMap.get("SITE_CODE");
			lineNo = Integer.parseInt(detailMap.get("LINE_NO"));//Changed by wasim on 03-03-2016 to get the lineNO
			
			System.out.println("Order Number["+orderNo+"] and trans key["+transKey+"]");
			//for(WorderStkBean tempStkObj : )
			//for(SiteItemSummaryBean tempStkObj : siteItemReqQtyList)
			
			if("P".equalsIgnoreCase(transKey))
			{
				sqlInsert ="INSERT INTO SORDALLOC (SALE_ORDER,LINE_NO,EXP_LEV,ITEM_CODE__ORD,SITE_CODE ,"
						+"ITEM_CODE,QUANTITY ,LOT_NO, LOT_SL, LOC_CODE, UNIT, QTY_ALLOC,"
						+" DATE_ALLOC, STATUS, EXP_DATE, ALLOC_MODE, "
						+" CONV__QTY_STDUOM, UNIT__STD, QUANTITY__STDUOM, "						
						+"MFG_DATE, SITE_CODE__MFG ) "
						+"VALUES ( ?, ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? ,"						
						+" ?, ?, ?, ?, ?, ?, ?, ?, ? ) " ;
			 sqlInsert = " INSERT INTO SORDALLOC (SALE_ORDER,LINE_NO,ITEM_CODE,SITE_CODE,LOT_NO,LOT_SL,LOC_CODE,QTY_ALLOC,"//8
						+" UNIT,EXP_DATE,SITE_CODE__MFG,MFG_DATE,QUANTITY,"//13
						+" DATE_ALLOC,STATUS,ALLOC_MODE,CONV__QTY_STDUOM,UNIT__STD,QUANTITY__STDUOM,EXP_LEV,ITEM_CODE__ORD)"//21
						+" VALUES ( ?, ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? ,"						
						+" ?, ?, ?, ?, ?, ?, ?, ?, ? ) " ;
				
				sqlOrder = "SELECT ITEM_CODE,SITE_CODE,LINE_NO,QUANTITY,EXP_LEV FROM SORDITEM WHERE SALE_ORDER = ? AND LINE_TYPE = 'I'";
			}
			else if("D".equalsIgnoreCase(transKey))
			{
				sqlInsert = "INSERT INTO DISTORDER_ALLOC (DIST_ORDER,LINE_NO,ITEM_CODE,SITE_CODE__SHIP,LOT_NO,LOT_SL,LOC_CODE,QTY_ALLOC,UNIT,"
						+ " EXP_DATE,SITE_CODE__MFG,MFG_DATE,QUANTITY) "
						+ "values (?, ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ? , ?)";//13
					
				sqlOrder = "SELECT D.ITEM_CODE,H.SITE_CODE__SHIP AS SITE_CODE,D.LINE_NO,D.QTY_CONFIRM AS QUANTITY,' ' AS EXP_LEV  FROM DISTORDER H,DISTORDER_DET D WHERE H.DIST_ORDER = D.DIST_ORDER "
						+ "AND H.DIST_ORDER = ?";
			}	
			pstmtInsert = conn.prepareStatement(sqlInsert);
			pstmtOrder = conn.prepareStatement(sqlOrder);
			
			pstmtOrder.setString(1, orderNo);
			rsOrder = pstmtOrder.executeQuery();
			while(rsOrder.next())
			{
				OrderItemCode = rsOrder.getString("ITEM_CODE");
				orderSiteCode = rsOrder.getString("SITE_CODE");
				lineNo = rsOrder.getString("LINE_NO");
				balanceQty = rsOrder.getDouble("QUANTITY");
				expLev = rsOrder.getString("EXP_LEV");
				
				System.out.println("Main Order quantity="+balanceQty);
				
				for(int siteCtr =0 ; siteCtr < siteItemReqQtyList.size() ; siteCtr++)
				{
					SiteItemSummaryBeanObj = (SiteItemSummaryBean) siteItemReqQtyList.get(siteCtr);
					
					System.out.println("DO Site code Ship="+SiteItemSummaryBeanObj.getSiteCodeShip());
					System.out.println("DO Site code DLV="+SiteItemSummaryBeanObj.getSiteCode());
	
					stkList = SiteItemSummaryBeanObj.getStockList();
					
					System.out.println("Inner Stock List size="+stkList.size());
					
					for(int innersiteCtr =0 ; innersiteCtr < stkList.size() ; innersiteCtr++)
					{
						 strAllocate = new HashMap();
						 deallocMap = new HashMap();
						 
						 siteItemMap = (HashMap) stkList.get(innersiteCtr);
						 itemCode = (String) siteItemMap.get("ITEM_CODE");
						 locCode = (String) siteItemMap.get("LOC_CODE");
						 lotNo = (String) siteItemMap.get("LOT_NO");
						 lotSl = (String) siteItemMap.get("LOT_SL");
						 siteCode = (String) siteItemMap.get("SITE_CODE");
						 allocQty = Double.parseDouble((siteItemMap.get("QUANTITY").toString()));
						 expDate = (Timestamp) siteItemMap.get("EXP_DATE");
						 siteCodeMfg = (String) siteItemMap.get("SITE_CODE__MFG");
						 mfgDate = (Timestamp) siteItemMap.get("MFG_DATE");
						 unit = (String) siteItemMap.get("UNIT");
					
						 System.out.println("!Order itemCode["+OrderItemCode+"] = ["+itemCode+"] ["+allocQty+"]");
						 System.out.println("Order siteCode["+orderSiteCode+"] = ["+siteCode+"] ["+SiteItemSummaryBeanObj.getOtherSiteQty()+"]");
						 
						 if((OrderItemCode.equalsIgnoreCase(itemCode)) && (orderSiteCode.equalsIgnoreCase(siteCode)))
						 { 
							 pstmtInsert.setString(1, orderNo);
							 pstmtInsert.setString(2, lineNo);
							 pstmtInsert.setString(3, itemCode);
							 pstmtInsert.setString(4, siteCode);
							 pstmtInsert.setString(5, lotNo);
							 pstmtInsert.setString(6, lotSl);
							 pstmtInsert.setString(7, locCode);
							 pstmtInsert.setDouble(8, allocQty);
							 pstmtInsert.setString(9, unit);
							 pstmtInsert.setTimestamp(10, expDate);
							 pstmtInsert.setString(11, siteCodeMfg);
							 pstmtInsert.setTimestamp(12, mfgDate);
							 pstmtInsert.setDouble(13, balanceQty);
								
							if("P".equalsIgnoreCase(transKey))
							{
								pstmtInsert.setTimestamp(14, getCurrtDate());
								pstmtInsert.setString(15, "P");
								pstmtInsert.setString(16, "A");
								pstmtInsert.setDouble(17, 1);
								pstmtInsert.setString(18, unit);
								pstmtInsert.setString(19, expLev);
								pstmtInsert.setDouble(20, allocQty);
								pstmtInsert.setString(21, OrderItemCode);
								strAllocate.put("ref_ser","S-ORD");
							}
							else if("D".equalsIgnoreCase(transKey))
							{
								strAllocate.put("ref_ser","D-ORD");
							}	
								pstmtInsert.addBatch();
								
								deallocMap.put("ALLOC_QTY",""+(-1 * allocQty));
								deallocMap.put("LOC_CODE", locCode);
								deallocMap.put("ITEM_CODE",itemCode);
								deallocMap.put("SITE_CODE",siteCode);
								deallocMap.put("LOT_NO",lotNo);
								deallocMap.put("LOT_SL",lotSl);
								
								errorString = updateStockAllocQty(deallocMap, conn);
								System.out.println("errorString after deallocate Stock update["+errorString+"]");
								
								strAllocate.put("tran_date",getCurrdateAppFormat());
								strAllocate.put("ref_id",orderNo);
								strAllocate.put("ref_line", "" + lineNo);
								strAllocate.put("site_code",siteCode);
								strAllocate.put("item_code",itemCode);
								strAllocate.put("loc_code", locCode);
								strAllocate.put("lot_no",lotNo);
								strAllocate.put("lot_sl",lotSl);
								strAllocate.put("alloc_qty", allocQty);
								strAllocate.put("chg_user",chgUser);
								strAllocate.put("chg_term",termId);
								strAllocate.put("chg_win","w_wo_firmplan");
								if (allocQty != 0)
								{
									errorString = invAllocTrace.updateInvallocTrace(strAllocate, conn);
									System.out.println("errorString after updateInvallocTrace allocate----->2["+errorString+"]");
								}
								
							}	
							
						}
				  }
			}
			
			pstmtInsert.executeBatch();
			
			pstmtInsert.close();pstmtInsert = null;
			rsOrder.close();rsOrder = null;
			pstmtOrder.close();pstmtOrder = null;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();rs = null; 
				}
				if(pstmt!=null)
				{
					pstmt.close();pstmt = null;
				}
				if(rsOrder!=null)
				{
					rsOrder.close();rsOrder = null; 
				}
				if(pstmtOrder!=null)
				{
					pstmtOrder.close();pstmtOrder = null;
				}
				if(pstmtInsert!=null)
				{
					pstmtInsert.close();pstmtInsert = null;
				}
			}
			catch(Exception ex)
			{
				throw new Exception(ex);
			}
		}
		return "";

	}*/
	//get Current date in timestamp format
	private java.sql.Timestamp getCurrtDate(String campgnNo) throws RemoteException,ITMException
	{
		java.sql.Timestamp currDate = null;
		try
		{
			Object date = null;
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(genericUtility.getDBDateFormat());
			date = sdf.parse(currDate.toString());
			currDate = java.sql.Timestamp.valueOf(sdf.format(date).toString()+ " 00:00:00.0");

		}
		catch (Exception e)
		{
			e.printStackTrace();
			writeWorkOrderLog(e.toString(),campgnNo);//TODO
			throw new ITMException(e);
		}
		return (currDate);
	}
	private String generateXml(Connection conn,String flag,String campgnNo) throws Exception,ITMException
    {
		StringBuffer firmPlanXMl = new StringBuffer();
		StringBuffer reserveStockXMl = new StringBuffer();
		StringBuffer stockDetailXml = new StringBuffer();
		SiteItemSummaryBeanNC tempObjNC =null;
		SiteItemSummaryBean tempObj1 = null;

        boolean stockAllocated = false;
        String workOrder = "",expLev = "";

        firmPlanXMl.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        //firmPlanXMl.append("<workorders><work_order><exp_level>\r\n");
        firmPlanXMl.append("<workorders><work_order>\r\n"); // Sneha
        
        //added by azhar[START]
        if(flag.equalsIgnoreCase("E")){
        		
        	firmPlanXMl.append("<successful><![CDATA[").append("NO").append( "]]></successful>\r\n" );
        	
        }else{
        	 
        	firmPlanXMl.append( "<successful><![CDATA[").append("YES").append( "]]></successful>\r\n" );
        }

        //added by azhar[END]


        for(WorkOrderDetailBean tempDetailObj : workOrderBeanList)
        {
        	//if(reserveStockXMl.length() > 0)
        	//{
        	//	reserveStockXMl.delete(0, reserveStockXMl.length());
        	//}
        	//if(stockDetailXml.length() > 0)
        	//{
        	//	stockDetailXml.delete(0, stockDetailXml.length());
        	//}
			
			reserveStockXMl = null;
			stockDetailXml = null;
			reserveStockXMl = new StringBuffer();
			stockDetailXml = new StringBuffer();
        	workOrder = tempDetailObj.getWorkOrder();
        	expLev = tempDetailObj.getExpLev();
			stockAllocated = false;
			
            firmPlanXMl.append( "<exp_level>\r\n");
            firmPlanXMl.append( "<work_order><![CDATA[" ).append( tempDetailObj.getWorkOrder() ).append( "]]></work_order>\r\n" );
            firmPlanXMl.append( "<exp_lev><![CDATA[" ).append( tempDetailObj.getExpLev() ).append( "]]></exp_lev>\r\n" );
            firmPlanXMl.append( "<site_code><![CDATA[" ).append( tempDetailObj.getSiteCode()).append( "]]></site_code>\r\n" );
            firmPlanXMl.append( "<bom_code><![CDATA[" ).append( tempDetailObj.getBomCode() ).append( "]]></bom_code>\r\n" );

            firmPlanXMl.append( "<item_Ref><![CDATA[" ).append( tempDetailObj.getItemRef() ).append( "]]></item_Ref>\r\n" );
            firmPlanXMl.append( "<item_code><![CDATA[" ).append( tempDetailObj.getItemCode() ).append( "]]></item_code>\r\n" );
            firmPlanXMl.append( "<item_descr><![CDATA[" ).append( getColumnDescr(conn, "descr", "item", "item_code", tempDetailObj.getItemCode(),campgnNo) ).append( "]]></item_descr>\r\n" );
            firmPlanXMl.append( "<due_date><![CDATA[" ).append( tempDetailObj.getDueDate() ).append( "]]></due_date>\r\n" );
            firmPlanXMl.append( "<quantity_Ref><![CDATA[" ).append( tempDetailObj.getQuantityRef() ).append( "]]></quantity_Ref>\r\n" );

            firmPlanXMl.append( "<quantity><![CDATA[" ).append(  Double.parseDouble(df.format( tempDetailObj.getQuantity())) ).append( "]]></quantity>\r\n" );
            firmPlanXMl.append( "<operation><![CDATA[" ).append( tempDetailObj.getOperation() ).append( "]]></operation>\r\n" );
            firmPlanXMl.append( "<crit_Item><![CDATA[" ).append( tempDetailObj.getCritItem() ).append( "]]></crit_Item>\r\n" );
            firmPlanXMl.append( "<line_type><![CDATA[" ).append( tempDetailObj.getLineType() ).append( "]]></line_type>\r\n" );
            firmPlanXMl.append( "<unit><![CDATA[" ).append( tempDetailObj.getUnit() ).append( "]]></unit>\r\n" );
            firmPlanXMl.append( "<batch_qty><![CDATA[" ).append( tempDetailObj.getBatchQty() ).append( "]]></batch_qty>\r\n" );
            firmPlanXMl.append( "<qty_per><![CDATA[" ).append( tempDetailObj.getQtyPer() ).append( "]]></qty_per>\r\n" );
            firmPlanXMl.append( "<lot_no><![CDATA[" ).append( tempDetailObj.getLotNo() ).append( "]]></lot_no>\r\n" );
            firmPlanXMl.append( "<req_type><![CDATA[" ).append( tempDetailObj.getReqType() ).append( "]]></req_type>\r\n" );
            firmPlanXMl.append( "<match_potency><![CDATA[" ).append( tempDetailObj.getMatchPotency() ).append( "]]></match_potency>\r\n" );
            firmPlanXMl.append( "<min_potency_perc><![CDATA[" ).append( tempDetailObj.getMinPotencyPerc() ).append( "]]></min_potency_perc>\r\n" );
            firmPlanXMl.append( "<adj_potency><![CDATA[" ).append( tempDetailObj.getAdjPotency() ).append( "]]></adj_potency>\r\n" );
            firmPlanXMl.append( "<potency_adj><![CDATA[" ).append( tempDetailObj.getPotencyAdjQty() ).append( "]]></potency_adj>\r\n" );
            firmPlanXMl.append( "<potency_perc><![CDATA[" ).append( getItemStandardPotency(tempDetailObj.getItemCode(), conn,campgnNo) ).append( "]]></potency_perc>\r\n" );
            firmPlanXMl.append( "<item_potency><![CDATA[" ).append( getItemStandardPotency(tempDetailObj.getItemCode(), conn,campgnNo) ).append( "]]></item_potency>\r\n" );
            firmPlanXMl.append( "<usage_type><![CDATA[" ).append( tempDetailObj.getUsageType() ).append( "]]></usage_type>\r\n" );
            firmPlanXMl.append( "<allocate_type><![CDATA[" ).append( tempDetailObj.getAllocateType() ).append( "]]></allocate_type>\r\n" );
            firmPlanXMl.append( "<loc_usage_type><![CDATA[" ).append( tempDetailObj.getLocUsageType() ).append( "]]></loc_usage_type>\r\n" );
            firmPlanXMl.append( "<consider_lot_no__issue><![CDATA[" ).append( tempDetailObj.getConsiderLotNoIssue() ).append( "]]></consider_lot_no__issue>\r\n" );
            firmPlanXMl.append( "<active><![CDATA[" ).append( tempDetailObj.getActive() ).append( "]]></active>\r\n" );
            firmPlanXMl.append( "<min_qty><![CDATA[" ).append( tempDetailObj.getMinQty() ).append( "]]></min_qty>\r\n" );
            firmPlanXMl.append( "<round><![CDATA[" ).append( tempDetailObj.getRound() ).append( "]]></round>\r\n" );
            firmPlanXMl.append( "<round_to><![CDATA[" ).append( tempDetailObj.getRoundTo() ).append( "]]></round_to>\r\n" );
            firmPlanXMl.append( "<supp_code__mfg><![CDATA[" ).append( tempDetailObj.getSuppCodeMfg() ).append( "]]></supp_code__mfg>\r\n" );
            firmPlanXMl.append( "<use_invstatus><![CDATA[" ).append( tempDetailObj.getUseInvStatus() ).append( "]]></use_invstatus>\r\n" );
            firmPlanXMl.append( "<dimension><![CDATA[" ).append( tempDetailObj.getDimension() ).append( "]]></dimension>\r\n" );
            firmPlanXMl.append( "<mfg_ref><![CDATA[" ).append( tempDetailObj.getMfgRef() ).append( "]]></mfg_ref>\r\n" );
            firmPlanXMl.append( "<min_req_qty><![CDATA[" ).append( tempDetailObj.getMinReqQty() ).append( "]]></min_req_qty>\r\n" );
            firmPlanXMl.append( "<item_category><![CDATA[" ).append( tempDetailObj.getItemCategory() ).append( "]]></item_category>\r\n" );
            firmPlanXMl.append( "<upd_qty><![CDATA[" ).append(Double.parseDouble(df.format(tempDetailObj.getUpdQty()))  ).append( "]]></upd_qty>\r\n" );
            firmPlanXMl.append( "<adjusted_qty><![CDATA[" ).append(Double.parseDouble(df.format(tempDetailObj.getAdjustedQty())) ).append( "]]></adjusted_qty>\r\n" );
            firmPlanXMl.append( "<is_sufficient><![CDATA[" ).append( tempDetailObj.getSufficient() ).append( "]]></is_sufficient>\r\n" );
            //firmPlanXMl.append( "</exp_level>\r\n");
			stockAllocated = false;
            for(WorderStkBean tempObj : worderStkBeanList)
            {
            	System.out.println("checking for firmplan failed 1");
				if(workOrder.equalsIgnoreCase(tempObj.getWorkOrder()) &&   expLev.equalsIgnoreCase(tempObj.getExpLevel()) )
	            {
					stockAllocated = true;
	                if("Y".equalsIgnoreCase(tempObj.getReserveStk()))
	                {
	                    //cntReserve++;
	                    //if(cntReserve == 1)
	                    //{
	                        reserveStockXMl.append("<reserve_stock>");
	                        //isReserve = true;
	                    //}
	                    System.out.println("checking for firmplan failed 2");
	                        
	                    reserveStockXMl.append("<detail>");
	                    reserveStockXMl.append("<site_code><![CDATA[" ).append( tempObj.getSiteCode() ).append( "]]></site_code>\r\n" );
	                    reserveStockXMl.append("<item_code><![CDATA[" ).append(  tempObj.getItemCode()).append( "]]></item_code>\r\n" );
	                    reserveStockXMl.append("<item_descr><![CDATA[" ).append(  tempObj.getItemDescr()).append( "]]></item_descr>\r\n" );
	                    reserveStockXMl.append("<lot_no><![CDATA[" ).append( tempObj.getLotNo() ).append( "]]></lot_no>\r\n" );
	                    reserveStockXMl.append("<lot_sl><![CDATA[" ).append( tempObj.getLotSl() ).append( "]]></lot_sl>\r\n" );
	                    reserveStockXMl.append("<stock_potency><![CDATA[" ).append( tempObj.getStkPotencyPerc() ).append( "]]></stock_potency>\r\n" );
	                    reserveStockXMl.append("<quantity><![CDATA[" ).append(Double.parseDouble(df.format( tempObj.getReserveStkQty())) ).append( "]]></quantity>\r\n" );
	                    reserveStockXMl.append("<remarks><![CDATA[" ).append( "Firm plan process" ).append( "]]></remarks>\r\n" );
	                    reserveStockXMl.append("<reas_code><![CDATA[" ).append( "" ).append( "]]></reas_code>\r\n" );
	                    reserveStockXMl.append("<loc_code><![CDATA[" ).append( tempObj.getLocCode() ).append( "]]></loc_code>\r\n" );
	                    reserveStockXMl.append("<exp_lev><![CDATA[" ).append( tempObj.getExpLevel() ).append( "]]></exp_lev>\r\n" );
	                    //double d = Double.parseDouble( df.format( tempObj.getPotencyAdj() ));
	                    reserveStockXMl.append("<potency_adj><![CDATA[" ).append(Double.parseDouble( df.format( tempObj.getPotencyAdj() )) ).append( "]]></potency_adj>\r\n" );
	                    reserveStockXMl.append("<dealloc_qty><![CDATA[" ).append( 0 ).append( "]]></dealloc_qty>\r\n" );
	                    reserveStockXMl.append("<alloc_qty><![CDATA[" ).append( Double.parseDouble(df.format( tempObj.getAllocQty())) ).append( "]]></alloc_qty>\r\n" );
	                    reserveStockXMl.append("<deallocated><![CDATA[" ).append( "" ).append( "]]></deallocated>\r\n" );
	                    reserveStockXMl.append("<is_alternate><![CDATA[" ).append( tempObj.getAlternate() ).append( "]]></is_alternate>\r\n" );
	                    reserveStockXMl.append("<tran_id><![CDATA[" ).append( tempObj.getReserveStkTranId() ).append( "]]></tran_id>\r\n" );
	                    reserveStockXMl.append( "<upd_qty><![CDATA[" ).append(Double.parseDouble(df.format(tempObj.getAllocQty())) ).append( "]]></upd_qty>\r\n" );
	                    reserveStockXMl.append( "<qty_adj><![CDATA[" ).append( tempObj.getPotencyAdj() ).append( "]]></qty_adj>\r\n" );
	                    reserveStockXMl.append("<unit><![CDATA[" ).append( tempObj.getUnit() ).append( "]]></unit>\r\n" );
	                    reserveStockXMl.append("</detail>");
						reserveStockXMl.append("</reserve_stock> \r\n");
	                }
					else
					   {
						System.out.println("checking for firmplan failed 3");
						
						   reserveStockXMl.append("<reserve_stock> \r\n");
						   reserveStockXMl.append("<detail>");
						   reserveStockXMl.append("<site_code><![CDATA[]]></site_code>\r\n" );
						   reserveStockXMl.append("<item_code><![CDATA[]]></item_code>\r\n" );
						   reserveStockXMl.append("<item_descr><![CDATA[]]></item_descr>\r\n" );
						   reserveStockXMl.append("<lot_no><![CDATA[]]></lot_no>\r\n" );
						   reserveStockXMl.append("<lot_sl><![CDATA[]]></lot_sl>\r\n" );

						   reserveStockXMl.append("<quantity><![CDATA[]]></quantity>\r\n" );
						   reserveStockXMl.append("<remarks><![CDATA[]]></remarks>\r\n" );
						   reserveStockXMl.append("<reas_code><![CDATA[]]></reas_code>\r\n" );
						   reserveStockXMl.append("<loc_code><![CDATA[]]></loc_code>\r\n" );
						   reserveStockXMl.append("<exp_lev><![CDATA[]]></exp_lev>\r\n" );
						   reserveStockXMl.append("<stock_potency><![CDATA[]]></stock_potency>\r\n" );

						   reserveStockXMl.append("<potency_adj><![CDATA[]]></potency_adj>\r\n" );
						   reserveStockXMl.append("<dealloc_qty><![CDATA[]]></dealloc_qty>\r\n" );
						   reserveStockXMl.append("<alloc_qty><![CDATA[]]></alloc_qty>\r\n" );
						   reserveStockXMl.append("<deallocated><![CDATA[]]></deallocated>\r\n" );
						   reserveStockXMl.append("<is_alternate><![CDATA[]]></is_alternate>\r\n" );
						   reserveStockXMl.append("</detail>");
						   reserveStockXMl.append("</reserve_stock> \r\n");
					   }
					
	                //else
					if ( tempObj.getAllocQty() - tempObj.getReserveStkQty() > 0)
	                {
	                    //cntStk++;
	                    //if(cntStk == 1)
	                    //{

	                        stockDetailXml.append("<stock_detail>");
	                        //isStkDetail = true;
	                    //}

	                    System.out.println("Other site for display["+tempObj.getSiteCode()+"]");
	                    if("Y".equalsIgnoreCase(tempObj.getOtherSiteYN()))
	                    {	
	                    	int siteIndex = getOtherSiteItemIndex(tempObj.getItemCode(),tempObj.getLocCode(),tempObj.getSiteCode(),tempObj.getLotNo(),tempObj.getLotSl(),tempObj.getCritItem());
	                    	if(siteIndex != -1 )
	                    	{
	                    		if("Y".equalsIgnoreCase(tempObj.getCritItem())){
	                    		
	                    			 tempObj1 = (SiteItemSummaryBean) siteItemReqQtyList.get(siteIndex);
	                    		}
	                    		if("N".equalsIgnoreCase(tempObj.getCritItem())){
	                    			
	                    		tempObjNC = (SiteItemSummaryBeanNC) siteItemReqQtyListNC.get(siteIndex);
	                    		}
	                    		
	                    		stockDetailXml.append("<detail>");
	                    		if("Y".equalsIgnoreCase(tempObj.getCritItem())){
	                    			
	                    		stockDetailXml.append("<site_code><![CDATA[" ).append( tempObj1.getSiteCode() ).append( "]]></site_code>\r\n" );
	                    		stockDetailXml.append("<item_code><![CDATA[" ).append(  tempObj1.getItemCode()).append( "]]></item_code>\r\n" );
	                    		
	                    		}
	                    		else if("N".equalsIgnoreCase(tempObj.getCritItem())){
	                    			
	                    			System.out.println("stock detail non critical::");
	                    			stockDetailXml.append("<site_code><![CDATA[" ).append( tempObjNC.getSiteCode() ).append( "]]></site_code>\r\n" );
		                    		stockDetailXml.append("<item_code><![CDATA[" ).append(  tempObjNC.getItemCode()).append( "]]></item_code>\r\n" );
	                    		}
	                    		System.out.println("checking for firmplan failed 4");
	                    		
	                    		stockDetailXml.append("<item_descr><![CDATA[" ).append(  tempObj.getItemDescr()).append( "]]></item_descr>\r\n" );
	                    		stockDetailXml.append("<lot_no><![CDATA[" ).append( tempObj.getLotNo() ).append( "]]></lot_no>\r\n" );
	                    		stockDetailXml.append("<lot_sl><![CDATA[" ).append( tempObj.getLotSl() ).append( "]]></lot_sl>\r\n" );
	                    		stockDetailXml.append("<stock_potency><![CDATA[" ).append( tempObj.getStkPotencyPerc() ).append( "]]></stock_potency>\r\n" );
	    	                    stockDetailXml.append("<quantity><![CDATA[" ).append(Double.parseDouble(df.format( tempObj.getStkQuantity())) ).append( "]]></quantity>\r\n" );
	    	                    stockDetailXml.append("<remarks><![CDATA[" ).append( "Firm plan process" ).append( "]]></remarks>\r\n" );
	    	                    stockDetailXml.append("<reas_code><![CDATA[" ).append( "" ).append( "]]></reas_code>\r\n" );
	    	                    stockDetailXml.append("<loc_code><![CDATA[" ).append( tempObj.getLocCode() ).append( "]]></loc_code>\r\n" );
	    	                    stockDetailXml.append("<exp_lev><![CDATA[" ).append( tempObj.getExpLevel() ).append( "]]></exp_lev>\r\n" );
	    	                    //double d = Double.parseDouble( df.format( tempObj.getPotencyAdj() ));
	    	                    stockDetailXml.append("<potency_adj><![CDATA[" ).append(Double.parseDouble( df.format( tempObj.getPotencyAdj() )) ).append( "]]></potency_adj>\r\n" );
	    	                    stockDetailXml.append("<dealloc_qty><![CDATA[" ).append( 0 ).append( "]]></dealloc_qty>\r\n" );
	    	                    //stockDetailXml.append("<alloc_qty><![CDATA[" ).append( Double.parseDouble(df.format( tempObj1.getOtherSiteQty())) ).append( "]]></alloc_qty>\r\n" );//Commented by Manoj dtd 29/12/2016 to set AllocQty
	    	                    stockDetailXml.append("<alloc_qty><![CDATA[" ).append(Double.parseDouble(df.format((tempObj.getAllocQty()))) ).append( "]]></alloc_qty>\r\n" );
	    	                    
	    	                    stockDetailXml.append("<deallocated><![CDATA[" ).append( "" ).append( "]]></deallocated>\r\n" );
	    	                    stockDetailXml.append("<is_alternate><![CDATA[" ).append( tempObj.getAlternate() ).append( "]]></is_alternate>\r\n" );
	    	                    stockDetailXml.append("<tran_id><![CDATA[" ).append( tempObj.getReserveStkTranId() ).append( "]]></tran_id>\r\n" );
	    	                    
	    	                    stockDetailXml.append("<upd_qty><![CDATA[" ).append(Double.parseDouble(df.format((tempObj.getAllocQty()))) ).append( "]]></upd_qty>\r\n" );
	    	                    //stockDetailXml.append("<upd_qty><![CDATA[" ).append(Double.parseDouble(df.format((tempObj1.getOtherSiteQty()) + tempObj.getQtyAdj())) ).append( "]]></upd_qty>\r\n" );//Commented by Manoj dtd 29/12/2016 to set AllocQty
	    	                    stockDetailXml.append("<qty_adj><![CDATA[" ).append( tempObj.getPotencyAdj() ).append( "]]></qty_adj>\r\n" );
	    	                    stockDetailXml.append("<unit><![CDATA[" ).append( tempObj.getUnit() ).append( "]]></unit>\r\n" );
	    	                    stockDetailXml.append("<other_site><![CDATA[" ).append("Y").append( "]]></other_site>\r\n" );
	    	                    stockDetailXml.append("</detail>");
								stockDetailXml.append("</stock_detail> \r\n");
	                    	}
	                    }
	                    else
	                    {	
	                    	System.out.println("checking for firmplan failed 5");
	                    	
		                    stockDetailXml.append("<detail>");
		                    stockDetailXml.append("<site_code><![CDATA[" ).append( tempObj.getSiteCode() ).append( "]]></site_code>\r\n" );
		                    stockDetailXml.append("<item_code><![CDATA[" ).append(  tempObj.getItemCode()).append( "]]></item_code>\r\n" );
		                    stockDetailXml.append("<item_descr><![CDATA[" ).append(  tempObj.getItemDescr()).append( "]]></item_descr>\r\n" );
		                    stockDetailXml.append("<lot_no><![CDATA[" ).append( tempObj.getLotNo() ).append( "]]></lot_no>\r\n" );
		                    stockDetailXml.append("<lot_sl><![CDATA[" ).append( tempObj.getLotSl() ).append( "]]></lot_sl>\r\n" );
	
		                    stockDetailXml.append("<stock_potency><![CDATA[" ).append( tempObj.getStkPotencyPerc() ).append( "]]></stock_potency>\r\n" );
		                    stockDetailXml.append("<quantity><![CDATA[" ).append( Double.parseDouble(df.format( tempObj.getStkQuantity())) ).append( "]]></quantity>\r\n" );
		                    stockDetailXml.append("<remarks><![CDATA[" ).append( "Firm plan process" ).append( "]]></remarks>\r\n" );
		                    stockDetailXml.append("<reas_code><![CDATA[" ).append( "" ).append( "]]></reas_code>\r\n" );
		                    stockDetailXml.append("<loc_code><![CDATA[" ).append( tempObj.getLocCode() ).append( "]]></loc_code>\r\n" );
		                    stockDetailXml.append("<exp_lev><![CDATA[" ).append( tempObj.getExpLevel() ).append( "]]></exp_lev>\r\n" );
	
		                    stockDetailXml.append("<potency_adj><![CDATA[" ).append( df.format( tempObj.getPotencyAdj() ) ).append( "]]></potency_adj>\r\n" );
		                    stockDetailXml.append("<dealloc_qty><![CDATA[" ).append( 0 ).append( "]]></dealloc_qty>\r\n" );
		                    stockDetailXml.append("<alloc_qty><![CDATA[" ).append( Double.parseDouble(df.format( tempObj.getAllocQty())) ).append( "]]></alloc_qty>\r\n" );
		                    stockDetailXml.append("<deallocated><![CDATA[" ).append( "" ).append( "]]></deallocated>\r\n" );
		                    stockDetailXml.append("<is_alternate><![CDATA[" ).append( tempObj.getAlternate() ).append( "]]></is_alternate>\r\n" );
		                    stockDetailXml.append( "<upd_qty><![CDATA[" ).append( Double.parseDouble(df.format(tempObj.getAllocQty())) ).append( "]]></upd_qty>\r\n" );
		                    stockDetailXml.append( "<qty_adj><![CDATA[" ).append( tempObj.getPotencyAdj() ).append( "]]></qty_adj>\r\n" );
		                    stockDetailXml.append("<unit><![CDATA[" ).append( tempObj.getUnit() ).append( "]]></unit>\r\n" );
		                    stockDetailXml.append("<other_site><![CDATA[" ).append("N").append( "]]></other_site>\r\n" );
		                    stockDetailXml.append("</detail>");
							stockDetailXml.append("</stock_detail> \r\n");
	                    }
	                }
					else
				   {
						System.out.println("checking for firmplan failed 6");
						System.out.println("when firmplan failed:: yes critical" + tempObj.getCritItem() + "no critical::" + tempObjNC.getCritItem());
						System.out.println("when firmplan failed:: critical item " + tempObj.getItemCode() + "non critical item::" + tempObjNC.getItemCode());
						
					   stockDetailXml.append("<stock_detail> \r\n");
					   stockDetailXml.append("<detail>");
					   stockDetailXml.append("<site_code><![CDATA[]]></site_code>\r\n" );
					   if("N".equalsIgnoreCase(tempObj.getCritItem())){
					   stockDetailXml.append("<item_code><![CDATA[" ).append(  tempObjNC.getItemCode()).append( "]]></item_code>\r\n" );
					   }else{
						   stockDetailXml.append("<item_code><![CDATA[]]></item_code>\r\n" );
					   }
					   stockDetailXml.append("<item_descr><![CDATA[]]></item_descr>\r\n" );
					   stockDetailXml.append("<lot_no><![CDATA[]]></lot_no>\r\n" );
					   stockDetailXml.append("<lot_sl><![CDATA[]]></lot_sl>\r\n" );

					   stockDetailXml.append("<quantity><![CDATA[]]></quantity>\r\n" );
					   stockDetailXml.append("<remarks><![CDATA[]]></remarks>\r\n" );
					   stockDetailXml.append("<reas_code><![CDATA[]]></reas_code>\r\n" );
					   stockDetailXml.append("<loc_code><![CDATA[]]></loc_code>\r\n" );
					   stockDetailXml.append("<exp_lev><![CDATA[]]></exp_lev>\r\n" );

					   stockDetailXml.append("<potency_adj><![CDATA[]]></potency_adj>\r\n" );
					   stockDetailXml.append("<dealloc_qty><![CDATA[]]></dealloc_qty>\r\n" );
					   stockDetailXml.append("<alloc_qty><![CDATA[]]></alloc_qty>\r\n" );
					   stockDetailXml.append("<deallocated><![CDATA[]]></deallocated>\r\n" );
					   stockDetailXml.append("<is_alternate><![CDATA[]]></is_alternate>\r\n" );
					   stockDetailXml.append("</detail>");
					   stockDetailXml.append("</stock_detail> \r\n");
				   }
					
	           }
			   //if( isReserve)
			   //{
				//reserveStockXMl.append("</reserve_stock> \r\n");
			   //}
			   //if( isStkDetail)
			   //{
				//   stockDetailXml.append("</stock_detail> \r\n");
			   //}
			   //if(!isReserve)
			   //if(! isStkDetail)
            } /// for(WorderStkBean tempObj : worderStkBeanList)
		   if (!stockAllocated)
		   {
			   System.out.println("checking for firmplan failed 7");
			   
			   reserveStockXMl.append("<reserve_stock> \r\n");
			   reserveStockXMl.append("<detail>");
			   reserveStockXMl.append("<site_code><![CDATA[]]></site_code>\r\n" );
			   reserveStockXMl.append("<item_code><![CDATA[]]></item_code>\r\n" );
			   reserveStockXMl.append("<item_descr><![CDATA[]]></item_descr>\r\n" );
			   reserveStockXMl.append("<lot_no><![CDATA[]]></lot_no>\r\n" );
			   reserveStockXMl.append("<lot_sl><![CDATA[]]></lot_sl>\r\n" );

			   reserveStockXMl.append("<quantity><![CDATA[]]></quantity>\r\n" );
			   reserveStockXMl.append("<remarks><![CDATA[]]></remarks>\r\n" );
			   reserveStockXMl.append("<reas_code><![CDATA[]]></reas_code>\r\n" );
			   reserveStockXMl.append("<loc_code><![CDATA[]]></loc_code>\r\n" );
			   reserveStockXMl.append("<exp_lev><![CDATA[]]></exp_lev>\r\n" );
			   reserveStockXMl.append("<stock_potency><![CDATA[]]></stock_potency>\r\n" );

			   reserveStockXMl.append("<potency_adj><![CDATA[]]></potency_adj>\r\n" );
			   reserveStockXMl.append("<dealloc_qty><![CDATA[]]></dealloc_qty>\r\n" );
			   reserveStockXMl.append("<alloc_qty><![CDATA[]]></alloc_qty>\r\n" );
			   reserveStockXMl.append("<deallocated><![CDATA[]]></deallocated>\r\n" );
			   reserveStockXMl.append("<is_alternate><![CDATA[]]></is_alternate>\r\n" );
			   reserveStockXMl.append("</detail>");
			   reserveStockXMl.append("</reserve_stock> \r\n");
		   
			   stockDetailXml.append("<stock_detail> \r\n");
			   stockDetailXml.append("<detail>");
			   stockDetailXml.append("<site_code><![CDATA[]]></site_code>\r\n" );
			   stockDetailXml.append("<item_code><![CDATA[" ).append(  tempDetailObj.getItemCode()).append( "]]></item_code>\r\n" );
			   stockDetailXml.append("<item_descr><![CDATA[" ).append( getColumnDescr(conn, "descr", "item", "item_code", tempDetailObj.getItemCode(),campgnNo)).append( "]]></item_descr>\r\n" );
			   stockDetailXml.append("<lot_no><![CDATA[]]></lot_no>\r\n" );
			   stockDetailXml.append("<lot_sl><![CDATA[]]></lot_sl>\r\n" );
			   stockDetailXml.append("<unit><![CDATA[" ).append( tempDetailObj.getUnit() ).append( "]]></unit>\r\n" );
			   stockDetailXml.append("<quantity><![CDATA[]]></quantity>\r\n" );
			   stockDetailXml.append("<remarks><![CDATA[]]></remarks>\r\n" );
			   stockDetailXml.append("<reas_code><![CDATA[]]></reas_code>\r\n" );
			   stockDetailXml.append("<loc_code><![CDATA[]]></loc_code>\r\n" );
			   stockDetailXml.append("<exp_lev><![CDATA[]]></exp_lev>\r\n" );

			   stockDetailXml.append("<potency_adj><![CDATA[]]></potency_adj>\r\n" );
			   stockDetailXml.append("<dealloc_qty><![CDATA[]]></dealloc_qty>\r\n" );
			   stockDetailXml.append("<alloc_qty><![CDATA[]]></alloc_qty>\r\n" );
			   stockDetailXml.append("<deallocated><![CDATA[]]></deallocated>\r\n" );
			   stockDetailXml.append("<is_alternate><![CDATA[]]></is_alternate>\r\n" );
			   stockDetailXml.append("</detail>");
			   stockDetailXml.append("</stock_detail> \r\n");
		   }
	       firmPlanXMl.append(reserveStockXMl.append(stockDetailXml));
	       firmPlanXMl.append( "</exp_level>\r\n");
        }

        firmPlanXMl.append("</work_order></workorders>");

        System.out.println("Final Firm paln xmlString : ["+firmPlanXMl.toString()+"]");
        return firmPlanXMl.toString();
    }
	/*private String createDistSaleOrder(Connection conn) throws Exception
	{
		HashMap<String,String> detailMap = new HashMap<String,String>();
		String transTran = "";
		for(SiteItemSummaryBean tempObj : siteItemReqQtyList)
		{
			transTran = tempObj.getTransTran();
			detailMap.put("ITEM_CODE", tempObj.getItemCode());
			detailMap.put("SITE_CODE", tempObj.getSiteCode());
			detailMap.put("TRANS_TRAN", tempObj.getTransTran());

			detailMap.put("SITE_CODE__SHIP", tempObj.getSiteCodeShip());
			detailMap.put("WORK_ORDER", tempObj.getWorkOrder());
			detailMap.put("TRANS_TRAN", tempObj.getTransTran());
			detailMap.put("QUANTITY", ""+tempObj.getOtherSiteQty());

			detailMap.put("UNIT", getColumnDescr(conn, "UNIT", "ITEM", "ITEM_CODE", tempObj.getItemCode()));

		}
	}*/
	private void updateWorkorderStatus(String worder,Connection conn) throws Exception
	{
		PreparedStatement pstmt = null;
		String sql = "";
		sql = "update workorder set status = 'F' where work_order = ? ";
		pstmt = conn.prepareStatement(sql);
		pstmt.setString(1, worder);
		int i = pstmt.executeUpdate();
		System.out.println("updateWorkorderStatus------------>>"+i);
		pstmt.close();
		pstmt = null;

	}
	private void removeDataConsiderPartialAlt(String worder,String expLevel) throws Exception
	{
		System.out.println("In removeDataConsiderPartialAlt-------------------->>"+worder + " : "+expLevel);
		ListIterator<WorderStkBean> itr = worderStkBeanList.listIterator();
		while(itr.hasNext())
		{
			WorderStkBean stkObj = itr.next();
			if(worder.equals(stkObj.getWorkOrder()) && expLevel.equals(stkObj.getExpLevel()))
			{
				itr.remove();
			}
		}
	}
	@SuppressWarnings("rawtypes")
	private String displayStkBean( String hdr) throws Exception
	{
		System.out.println("In displayStkBean-------------------->>"+hdr);
		System.out.println("In size-------------------->>"+worderStkBeanList.size());
		 Iterator itr = worderStkBeanList.iterator();

		int count=0;
		 if("H".equalsIgnoreCase(hdr))
            {
                while(itr.hasNext())
                {
                    count++;
                    System.out.println("WorkOrder Detail Bean--------------------------->>"+count);
                    WorkOrderDetailBean worderStkBeanObj = (WorkOrderDetailBean)itr.next();
                    System.out.println("WorkOrder------------>>["+worderStkBeanObj.getWorkOrder()+"]");
                    System.out.println("getExpLevel------------>>["+worderStkBeanObj.getExpLev()+"]");
                    System.out.println("getSiteCode------------>>["+worderStkBeanObj.getSiteCode()+"]");
                    System.out.println("getItemCode------------>>["+worderStkBeanObj.getItemCode()+"]");

                }
            }
            else if("D".equalsIgnoreCase(hdr))
            {
                while(itr.hasNext())
                {
                    count++;
                    System.out.println("WorkOrder Stock Bean-------------------------->>"+count);
                    WorderStkBean worderStkBeanObj = (WorderStkBean)itr.next();
                    System.out.println("WorkOrder------------>>["+worderStkBeanObj.getWorkOrder()+"]");
                    System.out.println("getExpLevel------------>>["+worderStkBeanObj.getExpLevel()+"]");
                    System.out.println("getSiteCode------------>>["+worderStkBeanObj.getSiteCode()+"]");
                    System.out.println("getItemCode------------>>["+worderStkBeanObj.getItemCode()+"]");
                    System.out.println("getLocCode------------>>["+worderStkBeanObj.getLocCode()+"]");

                    System.out.println("getLotNo------------>>["+worderStkBeanObj.getLotNo()+"]");
                    System.out.println("getLotSl------------>>["+worderStkBeanObj.getLotSl()+"]");
                    System.out.println("getStkQuantity------------>>["+worderStkBeanObj.getStkQuantity()+"]");
                    System.out.println("getAllocQty------------>>["+worderStkBeanObj.getAllocQty()+"]");


                }
            }



		/* for(WorkOrderDetailBean worderbillBeanObj : workOrderBeanList)
            {
                count++;
                System.out.println("WorkOrder Detail Bean--------------------------->>"+count);

                System.out.println("WorkOrder------------>>["+worderbillBeanObj.getWorkOrder()+"]");
                System.out.println("getExpLevel------------>>["+worderbillBeanObj.getExpLev()+"]");
                System.out.println("getSiteCode------------>>["+worderbillBeanObj.getSiteCode()+"]");
                System.out.println("getItemCode------------>>["+worderbillBeanObj.getItemCode()+"]");

                for(WorderStkBean tempObj : worderStkBeanList)
                {
                    System.out.println("WorkOrder------------>>["+tempObj.getWorkOrder()+"]");
                    System.out.println("getExpLevel------------>>["+tempObj.getExpLevel()+"]");
                    System.out.println("getSiteCode------------>>["+tempObj.getSiteCode()+"]");
                    System.out.println("getItemCode------------>>["+tempObj.getItemCode()+"]");
                    System.out.println("getStkQuantity------------>>["+tempObj.getStkQuantity()+"]");
                    System.out.println("getAllocQty------------>>["+tempObj.getAllocQty()+"]");
                }
            }

		for(WorkOrderDetailBean worderDetailBeanObj : workOrderBeanList)
		{
			count++;
			count1 = 0;
			System.out.println("WorkOrder Detail Bean--------------------------->>"+count);

			System.out.println("WorkOrder------------>>["+worderDetailBeanObj.getWorkOrder()+"]");
			System.out.println("getExpLevel------------>>["+worderDetailBeanObj.getExpLev()+"]");
			System.out.println("getSiteCode------------>>["+worderDetailBeanObj.getSiteCode()+"]");
			System.out.println("getItemCode------------>>["+worderDetailBeanObj.getItemCode()+"]");

			for(WorderStkBean tempObj : worderStkBeanList)
			{
				count1++;
				System.out.println("WorkOrder Stock Bean--------------------------->>"+count1);
				System.out.println("WorkOrder------------>>["+tempObj.getWorkOrder()+"]");
				System.out.println("getExpLevel------------>>["+tempObj.getExpLevel()+"]");
				System.out.println("getSiteCode------------>>["+tempObj.getSiteCode()+"]");
				System.out.println("getItemCode------------>>["+tempObj.getItemCode()+"]");
				System.out.println("getStkQuantity------------>>["+tempObj.getStkQuantity()+"]");
				System.out.println("getAllocQty------------>>["+tempObj.getAllocQty()+"]");
			}
		}*/

		return "";
	}

	private int getNoOfArt(String stkKey,Connection conn,String campgnNo) throws Exception
	{
		String sql = "",itemCode = "",locCode="",lotNo = "",lotSl = "",siteCode = "";
		int noOfArt = 0;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			System.out.println("Stock Key is="+stkKey);
			String[] keyDetails = stkKey.split(":");

			locCode = keyDetails[0];
			lotNo = keyDetails[1];
			lotSl = keyDetails[2];
			siteCode = keyDetails[3];
			itemCode = keyDetails[4];

			sql = "SELECT NO_ART FROM STOCK WHERE ITEM_CODE = ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO = ? AND LOT_SL = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, itemCode);
			pstmt.setString(2, siteCode);
			pstmt.setString(3, locCode);
			pstmt.setString(4, lotNo);
			pstmt.setString(5, lotSl);
			rs = pstmt.executeQuery();

			if(rs.next())
			{
				noOfArt = rs.getInt("NO_ART");
			}
			if(pstmt!=null)
			{
				pstmt.close();pstmt = null;
			}
			if(rs!=null)
			{
				rs.close();rs = null;
			}
		}
		catch(Exception e)
		{
			writeWorkOrderLog(e.toString(),campgnNo);//TODO
			throw new Exception(e);
		}
		finally
		{
			if(pstmt!=null)
			{
				pstmt.close();pstmt = null;
			}
			if(rs!=null)
			{
				rs.close();rs = null;
			}
		}
		System.out.println("No of Art returning="+noOfArt);
		return noOfArt;
	}
	private double getQtyPerArt(String stkKey,Connection conn,String campgnNo) throws Exception
	{
		String sql = "",itemCode = "",locCode="",lotNo = "",lotSl = "",siteCode = "";
		double qtyPerArt = 0;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			System.out.println("Stock Key is="+stkKey);
			String[] keyDetails = stkKey.split(":");

			locCode = keyDetails[0];
			lotNo = keyDetails[1];
			lotSl = keyDetails[2];
			siteCode = keyDetails[3];
			itemCode = keyDetails[4];

			sql = "SELECT QTY_PER_ART FROM STOCK WHERE ITEM_CODE = ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO = ? AND LOT_SL = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, itemCode);
			pstmt.setString(2, siteCode);
			pstmt.setString(3, locCode);
			pstmt.setString(4, lotNo);
			pstmt.setString(5, lotSl);
			rs = pstmt.executeQuery();

			if(rs.next())
			{
				qtyPerArt = rs.getDouble("QTY_PER_ART");
			}
			if(pstmt!=null)
			{
				pstmt.close();pstmt = null;
			}
			if(rs!=null)
			{
				rs.close();rs = null;
			}
		}
		catch(Exception e)
		{
			writeWorkOrderLog(e.toString(),campgnNo);//TODO
			throw new Exception(e);
		}
		finally
		{
			if(pstmt!=null)
			{
				pstmt.close();pstmt = null;
			}
			if(rs!=null)
			{
				rs.close();rs = null;
			}
		}
		System.out.println("Qty Per Art returning="+qtyPerArt);
		return qtyPerArt;
	}
	
	public void roundQuantity(Connection conn,String campgnNo,String itemFlag) throws Exception
	{
		SiteItemSummaryBean siteItemBeanObj = null;
		SiteItemSummaryBeanNC siteItemBeanObjNC = null;
		ArrayList stockList = null;
		ArrayList stockListNC = null;
		HashMap StkHmap = null;
		double roundOffQty = 0,mainQuantity = 0,qtyPerArt = 0,itemQuantity = 0,originalAllocQty = 0,quantity = 0,roundOffQtyNew = 0;
		String issCriteria = "",allocRetStr = "",sql= "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		double reqQuantity=0,otherSiteQty=0;
		String sqlForAddStock="";
		double availQty=0;
		String siteCodestr="",itemCodestr="",lotNostr="",lotSlstr="",locCodestr="";
		String unit = "",siteCodeMfg = "";
		java.sql.Timestamp mfgDateT = null, expDateT = null;
		try
		{
			if("C".equalsIgnoreCase(itemFlag)){
				
				System.out.println("in round quanity for Critical::");
				
				for(int outerCtr=0 ; outerCtr < siteItemReqQtyList.size(); outerCtr++)
				{
					reqQuantity=0;
					otherSiteQty=0;
					siteItemBeanObj = (SiteItemSummaryBean) siteItemReqQtyList.get(outerCtr);
					System.out.println("Printing siteItemBeanObj.getOtherSiteQty() in roundQuantity method "+siteItemBeanObj.getOtherSiteQty());
					stockList = siteItemBeanObj.getStockList();
					// 06-jun-16 manoharan  moved below inside loop
					issCriteria = getColumnDescr(conn,"ISS_CRITERIA","ITEM","ITEM_CODE",(String) siteItemBeanObj.getItemCode(),campgnNo);
					//System.out.println("Issue Criteria found="+issCriteria);
					
				
					for (int ctr = 0; ctr < stockList.size(); ctr++)
					{
						StkHmap = (HashMap) stockList.get(ctr);
						originalAllocQty = (Double) StkHmap.get("QUANTITY");
						//originalAllocQty = siteItemBeanObj.getOtherSiteQty();
						//mainQuantity = siteItemBeanObj.getOtherSiteQty();
						mainQuantity=(Double) StkHmap.get("QUANTITY");
						siteItemBeanObj.setReqQuantity(mainQuantity);
						siteItemReqQtyList.set(outerCtr, siteItemBeanObj);
						
						// 06-jun-16 manoharan, not required for each stock record, it should be at item level so moved above out side
						//issCriteria = getColumnDescr(conn,"ISS_CRITERIA","ITEM","ITEM_CODE",String.valueOf(StkHmap.get("ITEM_CODE")));
						//System.out.println("Issue Criteria found="+issCriteria);
						System.out.println("stock map first time::" + StkHmap.toString());
						System.out.println("Other site quantity allocated="+mainQuantity);
						System.out.println("Original allocated="+originalAllocQty);
						
						 //String stkKey = tempObj.getLocCode()+":"+tempObj.getLotNo()+":"+tempObj.getLotSl()+":"+tempObj.getSiteCodeShip()+":"+tempObj.getItemCode();
						 String stkKey = StkHmap.get("LOC_CODE")+":"+StkHmap.get("LOT_NO")+":"+StkHmap.get("LOT_SL")+":"+StkHmap.get("SITE_CODE")+":"+StkHmap.get("ITEM_CODE");
						 
						 //qtyPerArt = getQtyPerArt(stkKey,conn);
							  
						 	if("W".equalsIgnoreCase(issCriteria))
						 	{
						 		sql = "SELECT (QUANTITY - ALLOC_QTY) AS QUANTITY  FROM STOCK WHERE ITEM_CODE = ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO = ? AND LOT_SL = ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, (String) StkHmap.get("ITEM_CODE"));
								pstmt.setString(2, (String) StkHmap.get("SITE_CODE"));
								pstmt.setString(3, (String) StkHmap.get("LOC_CODE"));
								pstmt.setString(4, (String) StkHmap.get("LOT_NO"));
								pstmt.setString(5, (String) StkHmap.get("LOT_SL"));
								rs = pstmt.executeQuery();

								if(rs.next())
								{
									quantity = rs.getDouble("QUANTITY");
								}
								if(pstmt!=null)
								{
									pstmt.close();pstmt = null;
								}
								if(rs!=null)
								{
									rs.close();rs = null;
								}
						 		
						 		roundOffQty = quantity;
						 	}
						 	else
						 	{
							
								qtyPerArt = getQtyPerArt(stkKey,conn,campgnNo);
						 		if(qtyPerArt > mainQuantity)
						 	
								 {
									 roundOffQty = qtyPerArt;
								 }
								 else
								 {
								    System.out.println("allocated quantity will be 2 shippersize");
								 	double noArtQuot = 0,noArtRem = 0,noArt = 0;
								 	noArtQuot= mainQuantity / qtyPerArt ;
									noArtRem = mainQuantity % qtyPerArt ;
									if(noArtRem > 0)
									{
										noArtRem = 1;
									}
									noArtQuot = (int) noArtQuot;
									noArt = noArtQuot + noArtRem;
			
									System.out.println("NO Art in current site="+noArt);
									roundOffQty = qtyPerArt * noArt;
		 						 }
						 	}	
						     
							 if(roundOffQty != originalAllocQty)
							 {	 
							 	System.out.println("Original["+originalAllocQty+"] and Round Off["+roundOffQty+"]");
							 	if(!"W".equalsIgnoreCase(issCriteria))
							 	{	
							 		roundOffQtyNew = roundOffQty - originalAllocQty;
							 	}
							    Map stockAllocMap = new HashMap();
								stockAllocMap.put("ALLOC_QTY",""+roundOffQtyNew);
								stockAllocMap.put("LOC_CODE", (String) StkHmap.get("LOC_CODE"));
								stockAllocMap.put("ITEM_CODE",(String) StkHmap.get("ITEM_CODE"));
								stockAllocMap.put("SITE_CODE",(String) StkHmap.get("SITE_CODE"));
								stockAllocMap.put("LOT_NO",(String) StkHmap.get("LOT_NO"));
								stockAllocMap.put("LOT_SL",(String) StkHmap.get("LOT_SL"));
								stockAllocMap.put("QUANTITY",""+roundOffQtyNew);
								stockAllocMap.put("UNIT", StkHmap.get("UNIT"));
								stockAllocMap.put("SITE_CODE__MFG", StkHmap.get("site_code__mfg"));
								stockAllocMap.put("MFG_DATE", StkHmap.get("mfg_date"));
								stockAllocMap.put("EXP_DATE", StkHmap.get("exp_date"));
								
								System.out.println("first time map::["+stockAllocMap+"]");
								if(siteItemBeanObj.getCritItem().equalsIgnoreCase("Y"))
								{
								allocRetStr = updateStockAllocQty(stockAllocMap,conn,campgnNo);
								System.out.println("After DO Stock updated"+allocRetStr);
								}
								
								siteItemBeanObj.setOtherSiteQty(roundOffQtyNew); 
								
								siteItemBeanObj.setStockValues((HashMap<String, String>) stockAllocMap);
								
								siteItemReqQtyList.set(outerCtr, siteItemBeanObj);
							 }	
					}
					
			
					//reqQuantity = siteItemBeanObj.getReqQuantity();
					otherSiteQty=siteItemBeanObj.getOtherSiteQty();
					//double addQtyReqd=0;
					reqQuantity=siteItemBeanObj.getReqQuantity();
					System.out.println("required qty:: roundquantity::::" + reqQuantity);
					System.out.println("othersite qty :roundquantity:::" + otherSiteQty);
					
					if(reqQuantity==otherSiteQty)
					{
						//addQtyReqd=reqQuantity*5/100;
						sqlForAddStock=sqlMap.get(siteItemBeanObj.getSiteCodeShip().trim()+"@"+siteItemBeanObj.getItemCode().trim());
						System.out.println("round quantity key::[" + siteItemBeanObj.getSiteCodeShip().trim()+"@"+siteItemBeanObj.getItemCode().trim()+"]");
						System.out.println("sqlForAddStock["+sqlForAddStock+"]");
						pstmt=conn.prepareStatement(sqlForAddStock);
						rs=pstmt.executeQuery();
						while(rs.next())
						{
							availQty=rs.getDouble("QUANTITY");
							double qtyPerArticle=0;
							
							qtyPerArticle=rs.getDouble("qty_per_art");
							//siteCodestr=rs.getString("SITE_CODE"); site code is not in resultset
							itemCodestr=siteItemBeanObj.getItemCode().trim();
							lotNostr=rs.getString("lot_no");
							lotSlstr=rs.getString("lot_sl");
							locCodestr=rs.getString("loc_code");
							unit = rs.getString("UNIT");
							siteCodeMfg = rs.getString("site_code__mfg");
							mfgDateT = rs.getTimestamp("mfg_date");
							expDateT = rs.getTimestamp("exp_date");
							if(availQty>=qtyPerArticle)
							{
								 	Map stockAllocMapAddnl = new HashMap();
								 	stockAllocMapAddnl.put("ALLOC_QTY",""+qtyPerArticle);
								 	stockAllocMapAddnl.put("LOC_CODE", locCodestr);
								 	stockAllocMapAddnl.put("ITEM_CODE",itemCodestr);
								 	stockAllocMapAddnl.put("SITE_CODE",StkHmap.get("SITE_CODE"));
								 	stockAllocMapAddnl.put("LOT_NO",lotNostr);
								 	stockAllocMapAddnl.put("LOT_SL",lotSlstr);
								 	stockAllocMapAddnl.put("QUANTITY",""+qtyPerArticle);
									stockAllocMapAddnl.put("UNIT", unit);
									stockAllocMapAddnl.put("SITE_CODE__MFG", siteCodeMfg);
									stockAllocMapAddnl.put("MFG_DATE", mfgDateT);
									stockAllocMapAddnl.put("EXP_DATE", expDateT);
								 	
								 	System.out.println("stockAllocMapAddnl["+stockAllocMapAddnl+"]");
								 	
									if(siteItemBeanObj.getCritItem().equalsIgnoreCase("Y"))
									{
								 	allocRetStr = updateStockAllocQty(stockAllocMapAddnl,conn,campgnNo);
								 	System.out.println("After DO Stock updated again:::"+allocRetStr);
									}
								 	
									if(stockAllocMapAddnl.get("ITEM_CODE").equals(siteItemBeanObj.getItemCode()) &&
									stockAllocMapAddnl.get("SITE_CODE").equals(siteItemBeanObj.getSiteCode()) &&
									stockAllocMapAddnl.get("LOC_CODE").equals(siteItemBeanObj.getLocCode()) &&
									stockAllocMapAddnl.get("LOT_NO").equals(siteItemBeanObj.getLotNo()) &&
									stockAllocMapAddnl.get("LOT_SL").equals(siteItemBeanObj.getLotSl()))
									{
										siteItemBeanObj.setOtherSiteQty(siteItemBeanObj.getOtherSiteQty() + qtyPerArticle);
								 	}else{
								 		
								 		siteItemBeanObj.setOtherSiteQty(qtyPerArticle);
									 	siteItemBeanObj.setStockValues((HashMap<String, String>) stockAllocMapAddnl);
								 	}
								 	siteItemReqQtyList.set(outerCtr, siteItemBeanObj);
								 	
								 	break;
							}
						}
						if(rs!=null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
						
					}
					
				}
			}else if("NC".equalsIgnoreCase(itemFlag)){
				System.out.println("in round quanity for Non Critical::");
			
				for(int outerCtr=0 ; outerCtr < siteItemReqQtyListNC.size(); outerCtr++)
				{
					reqQuantity=0;
					otherSiteQty=0;
					siteItemBeanObjNC = (SiteItemSummaryBeanNC) siteItemReqQtyListNC.get(outerCtr);
					System.out.println("Printing siteItemBeanObjNC.getOtherSiteQty() in roundQuantity method "+siteItemBeanObjNC.getOtherSiteQty());
					stockListNC = siteItemBeanObjNC.getStockList();
					// 06-jun-16 manoharan  moved below inside loop
					issCriteria = getColumnDescr(conn,"ISS_CRITERIA","ITEM","ITEM_CODE",(String) siteItemBeanObjNC.getItemCode(),campgnNo);
					//System.out.println("Issue Criteria found="+issCriteria);
					
				
					for (int ctr = 0; ctr < stockListNC.size(); ctr++)
					{
						StkHmap = (HashMap) stockListNC.get(ctr);
						originalAllocQty = (Double) StkHmap.get("QUANTITY");
						//originalAllocQty = siteItemBeanObjNC.getOtherSiteQty();
						//mainQuantity = siteItemBeanObjNC.getOtherSiteQty();
						mainQuantity=(Double) StkHmap.get("QUANTITY");
						siteItemBeanObjNC.setReqQuantity(mainQuantity);
						siteItemReqQtyListNC.set(outerCtr, siteItemBeanObjNC);
						
						// 06-jun-16 manoharan, not required for each stock record, it should be at item level so moved above out side
						//issCriteria = getColumnDescr(conn,"ISS_CRITERIA","ITEM","ITEM_CODE",String.valueOf(StkHmap.get("ITEM_CODE")));
						//System.out.println("Issue Criteria found="+issCriteria);
						System.out.println("stock map first time::" + StkHmap.toString());
						System.out.println("Other site quantity allocated="+mainQuantity);
						System.out.println("Original allocated="+originalAllocQty);
						
						 //String stkKey = tempObj.getLocCode()+":"+tempObj.getLotNo()+":"+tempObj.getLotSl()+":"+tempObj.getSiteCodeShip()+":"+tempObj.getItemCode();
						 String stkKey = StkHmap.get("LOC_CODE")+":"+StkHmap.get("LOT_NO")+":"+StkHmap.get("LOT_SL")+":"+StkHmap.get("SITE_CODE")+":"+StkHmap.get("ITEM_CODE");
						 
						 //qtyPerArt = getQtyPerArt(stkKey,conn);
							  
						 	if("W".equalsIgnoreCase(issCriteria))
						 	{
						 		sql = "SELECT (QUANTITY - ALLOC_QTY) AS QUANTITY  FROM STOCK WHERE ITEM_CODE = ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO = ? AND LOT_SL = ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, (String) StkHmap.get("ITEM_CODE"));
								pstmt.setString(2, (String) StkHmap.get("SITE_CODE"));
								pstmt.setString(3, (String) StkHmap.get("LOC_CODE"));
								pstmt.setString(4, (String) StkHmap.get("LOT_NO"));
								pstmt.setString(5, (String) StkHmap.get("LOT_SL"));
								rs = pstmt.executeQuery();

								if(rs.next())
								{
									quantity = rs.getDouble("QUANTITY");
								}
								if(pstmt!=null)
								{
									pstmt.close();pstmt = null;
								}
								if(rs!=null)
								{
									rs.close();rs = null;
								}
						 		
						 		roundOffQty = quantity;
						 	}
						 	else
						 	{
							
								qtyPerArt = getQtyPerArt(stkKey,conn,campgnNo);
						 		if(qtyPerArt > mainQuantity)
						 	
								 {
									 roundOffQty = qtyPerArt;
								 }
								 else
								 {
								    System.out.println("allocated quantity will be 2 shippersize");
								 	double noArtQuot = 0,noArtRem = 0,noArt = 0;
								 	noArtQuot= mainQuantity / qtyPerArt ;
									noArtRem = mainQuantity % qtyPerArt ;
									if(noArtRem > 0)
									{
										noArtRem = 1;
									}
									noArtQuot = (int) noArtQuot;
									noArt = noArtQuot + noArtRem;
			
									System.out.println("NO Art in current site="+noArt);
									roundOffQty = qtyPerArt * noArt;
		 						 }
						 	}	
						     
							 if(roundOffQty != originalAllocQty)
							 {	 
							 	System.out.println("Original["+originalAllocQty+"] and Round Off["+roundOffQty+"]");
							 	if(!"W".equalsIgnoreCase(issCriteria))
							 	{	
							 		roundOffQtyNew = roundOffQty - originalAllocQty;
							 	}
							    Map stockAllocMap = new HashMap();
								stockAllocMap.put("ALLOC_QTY",""+roundOffQtyNew);
								stockAllocMap.put("LOC_CODE", (String) StkHmap.get("LOC_CODE"));
								stockAllocMap.put("ITEM_CODE",(String) StkHmap.get("ITEM_CODE"));
								stockAllocMap.put("SITE_CODE",(String) StkHmap.get("SITE_CODE"));
								stockAllocMap.put("LOT_NO",(String) StkHmap.get("LOT_NO"));
								stockAllocMap.put("LOT_SL",(String) StkHmap.get("LOT_SL"));
								stockAllocMap.put("QUANTITY",""+roundOffQtyNew);
								stockAllocMap.put("UNIT", StkHmap.get("UNIT"));
								stockAllocMap.put("SITE_CODE__MFG", StkHmap.get("site_code__mfg"));
								stockAllocMap.put("MFG_DATE", StkHmap.get("mfg_date"));
								stockAllocMap.put("EXP_DATE", StkHmap.get("exp_date"));
								
								System.out.println("first time map::["+stockAllocMap+"]");
								if(siteItemBeanObjNC.getCritItem().equalsIgnoreCase("Y"))
								{
								allocRetStr = updateStockAllocQty(stockAllocMap,conn,campgnNo);
								System.out.println("After DO Stock updated"+allocRetStr);
								}
								
								siteItemBeanObjNC.setOtherSiteQty(roundOffQtyNew); 
								//
								
								
								siteItemBeanObjNC.setStockValues((HashMap<String, String>) stockAllocMap);
								
								siteItemReqQtyListNC.set(outerCtr, siteItemBeanObjNC);
							 }	
					}
					
			
					//reqQuantity = siteItemBeanObjNC.getReqQuantity();
					otherSiteQty=siteItemBeanObjNC.getOtherSiteQty();
					//double addQtyReqd=0;
					reqQuantity=siteItemBeanObjNC.getReqQuantity();
					System.out.println("required qty:: roundquantity::::" + reqQuantity);
					System.out.println("othersite qty :roundquantity:::" + otherSiteQty);
					
					/*if(reqQuantity==otherSiteQty)
					{
						//addQtyReqd=reqQuantity*5/100;
						sqlForAddStock=sqlMap.get(siteItemBeanObjNC.getSiteCodeShip().trim()+"@"+siteItemBeanObjNC.getItemCode().trim());
						System.out.println("round quantity key::[" + siteItemBeanObjNC.getSiteCodeShip().trim()+"@"+siteItemBeanObjNC.getItemCode().trim()+"]");
						System.out.println("sqlForAddStock["+sqlForAddStock+"]");
						pstmt=conn.prepareStatement(sqlForAddStock);
						rs=pstmt.executeQuery();
						while(rs.next())
						{
							availQty=rs.getDouble("QUANTITY");
							double qtyPerArticle=0;
							
							qtyPerArticle=rs.getDouble("qty_per_art");
							siteCodestr=rs.getString("SITE_CODE__MFG");
							itemCodestr=siteItemBeanObjNC.getItemCode().trim();
							lotNostr=rs.getString("lot_no");
							lotSlstr=rs.getString("lot_sl");
							locCodestr=rs.getString("loc_code");
							unit = rs.getString("UNIT");
							siteCodeMfg = rs.getString("site_code__mfg");
							mfgDateT = rs.getTimestamp("mfg_date");
							expDateT = rs.getTimestamp("exp_date");
							if(availQty>=qtyPerArticle)
							{
								 	Map stockAllocMapAddnl = new HashMap();
								 	stockAllocMapAddnl.put("ALLOC_QTY",""+qtyPerArticle);
								 	stockAllocMapAddnl.put("LOC_CODE", locCodestr);
								 	stockAllocMapAddnl.put("ITEM_CODE",itemCodestr);
								 	stockAllocMapAddnl.put("SITE_CODE",siteCodestr);
								 	stockAllocMapAddnl.put("LOT_NO",lotNostr);
								 	stockAllocMapAddnl.put("LOT_SL",lotSlstr);
								 	stockAllocMapAddnl.put("QUANTITY",""+qtyPerArticle);
									stockAllocMapAddnl.put("UNIT", unit);
									stockAllocMapAddnl.put("SITE_CODE__MFG", siteCodeMfg);
									stockAllocMapAddnl.put("MFG_DATE", mfgDateT);
									stockAllocMapAddnl.put("EXP_DATE", expDateT);
								 	
								 	System.out.println("stockAllocMapAddnl["+stockAllocMapAddnl+"]");
								 	
									if(siteItemBeanObjNC.getCritItem().equalsIgnoreCase("Y"))
									{
								 	allocRetStr = updateStockAllocQty(stockAllocMapAddnl,conn,campgnNo);
								 	System.out.println("After DO Stock updated again:::"+allocRetStr);
									}
								 	
								 	siteItemBeanObjNC.setOtherSiteQty(qtyPerArticle);
								 	
								 	siteItemBeanObjNC.setStockValues((HashMap<String, String>) stockAllocMapAddnl);
								 	siteItemReqQtyListNC.set(outerCtr, siteItemBeanObjNC);
								 	
								 	break;
							}
						}
						if(rs!=null)
						{
							rs.close();
							rs = null;
						}
						if(pstmt!=null)
						{
							pstmt.close();
							pstmt = null;
						}
						
					}*/
					
				}
				
			}

			
		}
		catch(Exception e)
		{
			writeWorkOrderLog(e.toString(),campgnNo);//TODO
			throw new Exception(e);
		}
		finally
		{
			if(pstmt!=null)
			{
				pstmt.close();pstmt = null;
			}
			if(rs!=null)
			{
				rs.close();rs = null;
			}
		}
	}
	
/*	@SuppressWarnings("rawtypes")
	public void roundQuantity(Connection conn,String campgnNo) throws Exception
	{
		SiteItemSummaryBean siteItemBeanObj = null;
		ArrayList stockList = null;
		HashMap StkHmap = null;
		HashMap PrevStockHmap = null;
		double roundOffQty = 0,mainQuantity = 0,qtyPerArt = 0,originalAllocQty = 0,quantity = 0,roundOffQtyNew = 0;
		String issCriteria = "",allocRetStr = "",sql= "";
		int noOfArtStock = 0;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		int stockSize=0;
		try
		{

			for(int outerCtr=0 ; outerCtr < siteItemReqQtyList.size(); outerCtr++)
			{
				siteItemBeanObj = (SiteItemSummaryBean) siteItemReqQtyList.get(outerCtr);
				
				stockList = siteItemBeanObj.getStockList();
				// 06-jun-16 manoharan  moved below inside loop
				issCriteria = getColumnDescr(conn,"ISS_CRITERIA","ITEM","ITEM_CODE",(String) siteItemBeanObj.getItemCode(),campgnNo);
				//System.out.println("Issue Criteria found="+issCriteria);
				int count = 1;
				stockSize=stockList.size();
				for (int ctr = 0; ctr < stockList.size(); ctr++)
				{
					System.out.println("stock list::" + stockList.size());
					System.out.println("stock list details:::" + stockList.toString());
					
					
					
					StkHmap = (HashMap) stockList.get(ctr);
					
					//added by azhar
					if(ctr>0){
						
					PrevStockHmap = (HashMap) stockList.get(ctr - 1);
					System.out.println("lot no previous::" + PrevStockHmap.get("LOT_NO"));
					System.out.println("lot sl previous::" + PrevStockHmap.get("LOT_SL"));
					System.out.println("loc code previous::" + PrevStockHmap.get("LOC_CODE"));
					}
					//added by azhar
					mainQuantity = (Double) StkHmap.get("QUANTITY");
					originalAllocQty = siteItemBeanObj.getOtherSiteQty();
					// 06-jun-16 manoharan, not required for each stock record, it should be at item level so moved above out side
					//issCriteria = getColumnDescr(conn,"ISS_CRITERIA","ITEM","ITEM_CODE",String.valueOf(StkHmap.get("ITEM_CODE")));
					//System.out.println("Issue Criteria found="+issCriteria);
					
					System.out.println("Other site quantity allocated="+mainQuantity);
					System.out.println("Original allocated="+originalAllocQty);
					
					 //String stkKey = tempObj.getLocCode()+":"+tempObj.getLotNo()+":"+tempObj.getLotSl()+":"+tempObj.getSiteCodeShip()+":"+tempObj.getItemCode();
					 String stkKey = StkHmap.get("LOC_CODE")+":"+StkHmap.get("LOT_NO")+":"+StkHmap.get("LOT_SL")+":"+StkHmap.get("SITE_CODE")+":"+StkHmap.get("ITEM_CODE");
					 
					 //qtyPerArt = getQtyPerArt(stkKey,conn);
						  
					 	if("W".equalsIgnoreCase(issCriteria))
					 	{
					 		sql = "SELECT (QUANTITY - ALLOC_QTY) AS QUANTITY  FROM STOCK WHERE ITEM_CODE = ? AND SITE_CODE = ? AND LOC_CODE = ? AND LOT_NO = ? AND LOT_SL = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, (String) StkHmap.get("ITEM_CODE"));
							pstmt.setString(2, (String) StkHmap.get("SITE_CODE"));
							pstmt.setString(3, (String) StkHmap.get("LOC_CODE"));
							pstmt.setString(4, (String) StkHmap.get("LOT_NO"));
							pstmt.setString(5, (String) StkHmap.get("LOT_SL"));
							rs = pstmt.executeQuery();

							if(rs.next())
							{
								quantity = rs.getDouble("QUANTITY");
							}
							if(pstmt!=null)
							{
								pstmt.close();pstmt = null;
							}
							if(rs!=null)
							{
								rs.close();rs = null;
							}
					 		
					 		roundOffQty = quantity;
					 	}
					 	else
					 	{
						
							qtyPerArt = getQtyPerArt(stkKey,conn,campgnNo);
							noOfArtStock = getNoOfArt(stkKey,conn,campgnNo);
					 		if(qtyPerArt > mainQuantity)
					 	
							 {
								 roundOffQty = qtyPerArt;
							 }
							 else
							 {
							    System.out.println("allocated quantity will be 2 shippersize");
							 	double noArtQuot = 0,noArtRem = 0,noArt = 0;
							 	noArtQuot= mainQuantity / qtyPerArt ;
								noArtRem = mainQuantity % qtyPerArt ;
								if(noArtRem > 0)
								{
									noArtRem = 1;
								}
								noArtQuot = (int) noArtQuot;
								noArt = noArtQuot + noArtRem;
		
								System.out.println("NO Art in current site="+noArt);
								roundOffQty = qtyPerArt * noArt;
							 }
					 	}	
					 	System.out.println("No of article stock::" + noOfArtStock);
					 	
					 	if(mainQuantity < qtyPerArt){
					 		roundOffQty = qtyPerArt;
					 	}else{
					 	
					 		roundOffQty = qtyPerArt * noOfArtStock;
					 	}
					 	
					 	
						 //if(roundOffQty != originalAllocQty)
					 	System.out.println("Original before checking["+originalAllocQty+"] and Round Off["+roundOffQty+"]");
					 	
					 	if(ctr > 0){
					 	if ((roundOffQty != originalAllocQty) || (StkHmap.get("LOC_CODE") != PrevStockHmap.get("LOC_CODE")) || 
					            (StkHmap.get("LOT_NO") != PrevStockHmap.get("LOT_NO")) || (StkHmap.get("LOT_SL") != PrevStockHmap.get("LOT_SL")))
					          {
					            System.out.println("Original[" + originalAllocQty + "] and Round Off[" + roundOffQty + "]");
					            if (!"W".equalsIgnoreCase(issCriteria))
					            {
					              roundOffQtyNew = roundOffQty - originalAllocQty;
					            }
					            Map stockAllocMap = new HashMap();
					            stockAllocMap.put("ALLOC_QTY", roundOffQtyNew);
					            stockAllocMap.put("LOC_CODE", (String)StkHmap.get("LOC_CODE"));
					            stockAllocMap.put("ITEM_CODE", (String)StkHmap.get("ITEM_CODE"));
					            stockAllocMap.put("SITE_CODE", (String)StkHmap.get("SITE_CODE"));
					            stockAllocMap.put("LOT_NO", (String)StkHmap.get("LOT_NO"));
					            stockAllocMap.put("LOT_SL", (String)StkHmap.get("LOT_SL"));

					            System.out.println("After DO Stock updated" + allocRetStr);

					            if (count > 1) {
					              roundOffQty = originalAllocQty + roundOffQty;
					              siteItemBeanObj.setOtherSiteQty(roundOffQty);
					              System.out.println("final round off quantity when multiple lots:: " + roundOffQty);
					            } else {
					              siteItemBeanObj.setOtherSiteQty(roundOffQty);
					            }
					            stockAllocMap.put("QUANTITY", roundOffQtyNew);
					            siteItemBeanObj.setStockValues((HashMap)stockAllocMap);

					            this.siteItemReqQtyList.set(outerCtr, siteItemBeanObj);
					          }
					 	}else
					 	{
					 		if ((roundOffQty != originalAllocQty))
						          {
						            System.out.println("Original[" + originalAllocQty + "] and Round Off[" + roundOffQty + "]");
						            if (!"W".equalsIgnoreCase(issCriteria))
						            {
						              roundOffQtyNew = roundOffQty - originalAllocQty;
						            }
						            Map stockAllocMap = new HashMap();
						            stockAllocMap.put("ALLOC_QTY", roundOffQtyNew);
						            stockAllocMap.put("LOC_CODE", (String)StkHmap.get("LOC_CODE"));
						            stockAllocMap.put("ITEM_CODE", (String)StkHmap.get("ITEM_CODE"));
						            stockAllocMap.put("SITE_CODE", (String)StkHmap.get("SITE_CODE"));
						            stockAllocMap.put("LOT_NO", (String)StkHmap.get("LOT_NO"));
						            stockAllocMap.put("LOT_SL", (String)StkHmap.get("LOT_SL"));

						            System.out.println("After DO Stock updated" + allocRetStr);

						            if (count > 1) {
						              roundOffQty = originalAllocQty + roundOffQty;
						              siteItemBeanObj.setOtherSiteQty(roundOffQty);
						              System.out.println("final round off quantity when multiple lots:: " + roundOffQty);
						            } else {
						              siteItemBeanObj.setOtherSiteQty(roundOffQty);
						            }
						            stockAllocMap.put("QUANTITY", roundOffQtyNew);
						            siteItemBeanObj.setStockValues((HashMap)stockAllocMap);

						            this.siteItemReqQtyList.set(outerCtr, siteItemBeanObj);
						          }
					 	}
					          if (stockList.size() > 1) {
					            count++;
					            System.out.println("count when multiple lots::" + count);
					          }
					 	//if(stockSize<2)
					 	//{
					 	//commented by azhar[start]
						 	if(roundOffQty != originalAllocQty)//changed by manoj dtd 28/12/2016
							 {	 
							 	System.out.println("Original["+originalAllocQty+"] and Round Off["+roundOffQty+"]");
							 	if(!"W".equalsIgnoreCase(issCriteria))
							 	{	
							 		roundOffQtyNew = roundOffQty - originalAllocQty;
							 	}
							    Map<String,String> stockAllocMap = new HashMap<String,String>();
								stockAllocMap.put("ALLOC_QTY",""+roundOffQtyNew);
								stockAllocMap.put("LOC_CODE", (String) StkHmap.get("LOC_CODE"));
								stockAllocMap.put("ITEM_CODE",(String) StkHmap.get("ITEM_CODE"));
								stockAllocMap.put("SITE_CODE",(String) StkHmap.get("SITE_CODE"));
								stockAllocMap.put("LOT_NO",(String) StkHmap.get("LOT_NO"));
								stockAllocMap.put("LOT_SL",(String) StkHmap.get("LOT_SL"));
								
								//allocRetStr = updateStockAllocQty(stockAllocMap,conn,campgnNo);
								System.out.println("After DO Stock updated"+allocRetStr);
								
								if(count > 1){
									//roundOffQty = originalAllocQty + roundOffQty;//Commented by Manoj dtd 30/12/2016
									siteItemBeanObj.setOtherSiteQty(siteItemBeanObj.getOtherSiteQty()+roundOffQty);
									System.out.println("final round off quantity when multiple lots:: " +roundOffQty);
								}else{
								siteItemBeanObj.setOtherSiteQty(roundOffQty);
								}
								stockAllocMap.put("QUANTITY",""+roundOffQtyNew);
								siteItemBeanObj.setStockValues((HashMap<String, String>) stockAllocMap);
								
								siteItemReqQtyList.set(outerCtr, siteItemBeanObj);
							 }	  //commented by azhar[end]
					 //	}
					 	else
					 	{
						 	if(PrevStockHmap!=null)//Condition added by manoj dtd 28/12/2016
						 	{
						 	if(roundOffQty != originalAllocQty || StkHmap.get("LOC_CODE") != PrevStockHmap.get("LOC_CODE")
						 			|| StkHmap.get("LOT_NO") != PrevStockHmap.get("LOT_NO") || StkHmap.get("LOT_SL") != PrevStockHmap.get("LOT_SL"))//changed by azhar
							 {	 
							 	System.out.println("Original["+originalAllocQty+"] and Round Off["+roundOffQty+"]");
							 	if(!"W".equalsIgnoreCase(issCriteria))
							 	{	
							 		roundOffQtyNew = roundOffQty - originalAllocQty;
							 	}
							    Map<String,String> stockAllocMap = new HashMap<String,String>();
								stockAllocMap.put("ALLOC_QTY",""+roundOffQtyNew);
								stockAllocMap.put("LOC_CODE", (String) StkHmap.get("LOC_CODE"));
								stockAllocMap.put("ITEM_CODE",(String) StkHmap.get("ITEM_CODE"));
								stockAllocMap.put("SITE_CODE",(String) StkHmap.get("SITE_CODE"));
								stockAllocMap.put("LOT_NO",(String) StkHmap.get("LOT_NO"));
								stockAllocMap.put("LOT_SL",(String) StkHmap.get("LOT_SL"));
								
								//allocRetStr = updateStockAllocQty(stockAllocMap,conn,campgnNo);
								System.out.println("After DO Stock updated"+allocRetStr);
								
								if(count > 1){
									roundOffQty = originalAllocQty + roundOffQty;
									siteItemBeanObj.setOtherSiteQty(roundOffQty);
									System.out.println("final round off quantity when multiple lots:: " +roundOffQty);
								}else{
								siteItemBeanObj.setOtherSiteQty(roundOffQty);
								}
								stockAllocMap.put("QUANTITY",""+roundOffQtyNew);
								siteItemBeanObj.setStockValues((HashMap<String, String>) stockAllocMap);
								
								siteItemReqQtyList.set(outerCtr, siteItemBeanObj);
							 }
						 	}
					 	}
				
						 if(stockList.size() > 1){
							 count++;
							 System.out.println("count when multiple lots::" + count);
						 }
						 PrevStockHmap = (HashMap) stockList.get(ctr);
				}
			}
		}
		catch(Exception e)
		{
			writeWorkOrderLog(e.toString(),campgnNo);//TODO
			throw new Exception(e);
		}
		finally
		{
			if(pstmt!=null)
			{
				pstmt.close();pstmt = null;
			}
			if(rs!=null)
			{
				rs.close();rs = null;
			}
		}
	}*/
}
