package ibase.webitm.ejb.fin;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
//import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.w3c.dom.Document;
@javax.ejb.Stateless

public class FixedAssetTransferPostSave extends ValidatorEJB implements FixedAssetTransferPostSaveLocal, FixedAssetTransferPostSaveRemote
{        

	FinCommon finCommon = new FinCommon();
	DistCommon distCommon = new DistCommon();

	public String postSave(String xmlString, String tranid, String editFlag,
			String xtraParams, Connection conn) throws RemoteException,
			ITMException
			{
		System.out.println("--------------PostSave called-------------");
		System.out.println("tranid------------- " + tranid);
		Document dom = null;
		String errString = "";
		try {
			if (xmlString != null && xmlString.trim().length() > 0) {
				dom = parseString(xmlString);
				errString = postSave(dom, tranid, xtraParams, conn);
			}
		} 
		catch (Exception e) 
		{
			System.out.println("Exception : FixedAssetTransferPostSave.java : postSave : ==>\n"+ e.getMessage());
			throw new ITMException(e);
		}
		return errString;
	}


	public String postSave(Document dom, String tranid, String xtraParams,Connection conn)throws RemoteException,ITMException
	{
		System.out.println("In FixedAssetTransferPostSave ... ");
		String  errorString = "";
		PreparedStatement pstmt = null;
		//Document dom = null;                
		ResultSet rs =null;
		boolean isError = false;
		int count =0;
		String tranIdRcp = "";
		String tranId = "",lineNo="";
		String errString ="";
		String xmlString =null;
		String sql = null;
		double taxAmtHdr =0.0,taxAmtDet = 0.0,taxrecoAmtHdr=0.0,taxrecoAmtDet=0.0,totAmtHdr =0.0,totAmtDet =0.0;
		try
		{
			E12GenericUtility genericUtility = new E12GenericUtility();
//			GenericUtility genericUtility = GenericUtility.getInstance();
			//dom = genericUtility.parseString(domString);

			tranId = genericUtility.getColumnValue("tran_id",dom);
		sql="select sum(case when tax_amt is null then 0 else tax_amt end),sum(total_value),sum(tax_reco_amt) from asset_transfer_det where tran_id = ? ";
		{
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId );
			rs = pstmt.executeQuery();
			while (rs.next()) 
			{
				taxAmtDet = rs.getDouble(1);
				taxrecoAmtDet = rs.getDouble(2);
				totAmtDet = rs.getDouble(3);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
		}
		sql= "update asset_transfer_hdr set tax_amt = ? ,total_value = ?,tax_reco_amt = ? where tran_id = ? ";
		pstmt = conn.prepareStatement(sql);
		pstmt.setDouble(1, taxAmtHdr);
		pstmt.setDouble(2, totAmtHdr);
		pstmt.setDouble(3,taxrecoAmtHdr);
		pstmt.setString(4,tranId);
		count = pstmt.executeUpdate();
		System.out.println("post count---->>[" + count + "]");
		if (pstmt != null) 
		{
			pstmt.close();
			pstmt = null;
		}
		if (count > 0) 
		{
			conn.commit();
		}
		}
		catch(Exception e)
		{
			System.out.println("Exception :FixedAssetTransferPostSaveEJB : :==>\n"+e.getMessage());
			try
			{
				System.out.println("Before rollback");
				conn.rollback();
			}

			catch(SQLException sqle)
			{
				System.out.println(sqle);
			}
			throw new ITMException(e);
		}
		
		
		return errorString;
		
	}
}