package ibase.dashboard.wms.ejb;
import ibase.dashboard.Report.Utility.DashboardUtility;
import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;

import java.io.File;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import javax.ejb.Stateless;

import org.json.simple.JSONObject;
/**
 * Session Bean implementation class SalesPersonSales
 */
@Stateless
public class FGWarehouse extends ValidatorEJB implements FGWarehouseLocal, FGWarehouseRemote
{
	public FGWarehouse() {
       
    }
	GenericUtility genericUtility = GenericUtility.getInstance();
	
	@SuppressWarnings("unchecked")
    //public JSONObject getReceivableDashboard(String dataSourceName,String siteCode) throws RemoteException, ITMException
	public JSONObject getReceivableDashboard(String dataSourceName,String siteCode, String facilityCode) throws RemoteException, ITMException
    {
		JSONObject rawDataReceivableJson = new JSONObject();
		JSONObject rowData = null;
		String sql = null;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		try
		{
			System.out.println(" Inside FGWarehouse for getReceivableDashboard siteCode ="+siteCode);
			
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			int count = 0;
			facilityCode=checkNull(facilityCode);
			if(facilityCode.equalsIgnoreCase(""))
			{
				facilityCode=getFacilityCode(siteCode, dataSourceName);
			}
			System.out.println("Facility Code: "+facilityCode);
			
			sql = " Select round(sum(OverDue_Over_3Days),0) as OverDue_Over_3Days  " +
					" ,round(sum(OverDue_Over_2Days),0) as OverDue_Over_2Days  " +
					" ,round(sum(OverDue_Yesterday),0) as OverDue_Yesterday  " +
					" ,round(sum(OverDue_Today),0) as OverDue_Today  " +
					" ,round(sum(OverDue_Tomorrow),0) as OverDue_Tomorrow  " +
					" ,round(sum(OverDue_Day_After),0) as OverDue_Day_After  " +
					" ,round(sum(OverDue_Rest_of_week),0) as OverDue_Rest_of_week  " +
					" ,round(sum(OverDue_Next_Week),0) as OverDue_Next_Week  " +
					" ,round(sum(OverDue_Next_Month),0) as OverDue_Next_Month  " +
					" ,a.site_code, a.fin_entity, a.item_ser, a.cust_code, a.cust_name ,a.itm_descr " +
					" from(  " +
					" select sum(r.tot_amt - r.adj_amt) as OverDue_Over_3Days, sum(0) as OverDue_Over_2Days, sum(0) as OverDue_Yesterday  " +
					" ,sum(0) as OverDue_Today, sum(0) as OverDue_Tomorrow, sum(0) as OverDue_Day_After  " +
					" ,sum(0) as OverDue_Rest_of_week, sum(0) as OverDue_Next_Week, sum(0) as OverDue_Next_Month  " +
					" ,r.site_code,r.fin_entity,r.item_ser,c.cust_code,c.cust_name,its.descr as itm_descr  " +
					" from receivables r,customer c,site s,itemser its  " +
					" where r.tot_amt - r.adj_amt <> 0  " +
					" and case when r.exp_rcp_date is null then r.due_date else r.exp_rcp_date end  " +
					" between to_date(sysdate) -3 and to_date(sysdate)  " +
					" and r.cust_code=c.cust_code and r.item_ser=its.item_ser and r.site_code=s.site_code and s.facility_code='"+facilityCode+"' " +
					" group by  r.site_code,r.fin_entity,r.item_ser,c.cust_code,c.cust_name ,its.descr " +
					" union all  " +
					" select sum(0) as OverDue_Over_3Days,  sum(r.tot_amt - r.adj_amt)  as OverDue_Over_2Days ,sum(0) as OverDue_Yesterday  " +
					" ,sum(0) as OverDue_Today ,sum(0) as OverDue_Tomorrow ,sum(0) as OverDue_Day_After  " +
					" ,sum(0) as OverDue_Rest_of_week ,sum(0) as OverDue_Next_Week ,sum(0) as OverDue_Next_Month  " +
					" ,r.site_code,r.fin_entity,r.item_ser,c.cust_code,c.cust_name,its.descr as itm_descr  " +
					" from receivables r,customer c,site s,itemser its  " +
					" where r.tot_amt - r.adj_amt <> 0  " +
					" and case when r.exp_rcp_date is null then r.due_date else r.exp_rcp_date end  " +
					" between to_date(sysdate) -2 and to_date(sysdate)  " +
					" and r.cust_code=c.cust_code  and r.item_ser=its.item_ser and r.site_code=s.site_code and s.facility_code= '"+facilityCode+"' " +
					" group by  r.site_code,r.fin_entity,r.item_ser,c.cust_code,c.cust_name,its.descr  " +
					" union all   " +
					" select sum(0) as OverDue_Over_3Days  " +
					" ,sum(0)  as OverDue_Over_2Days  " +
					" ,sum(r.tot_amt - r.adj_amt)  as OverDue_Yesterday  " +
					" ,sum(0) as OverDue_Today  " +
					" ,sum(0) as OverDue_Tomorrow  " +
					" ,sum(0) as OverDue_Day_After  " +
					" ,sum(0) as OverDue_Rest_of_week  " +
					" ,sum(0) as OverDue_Next_Week  " +
					" ,sum(0) as OverDue_Next_Month  " +
					" ,r.site_code,r.fin_entity,r.item_ser,c.cust_code,c.cust_name ,its.descr as itm_descr " +
					" from receivables r,customer c,site s,itemser its  " +
					" where r.tot_amt - r.adj_amt <> 0  " +
					" and case when r.exp_rcp_date is null then r.due_date else r.exp_rcp_date end  " +
					" between to_date(sysdate) -1 and to_date(sysdate)  " +
					" and r.cust_code=c.cust_code   " +
					" and r.item_ser=its.item_ser  " +
					" and r.site_code=s.site_code   " +
					" and s.facility_code='"+facilityCode+"' " +
					" group by  r.site_code,r.fin_entity,r.item_ser,c.cust_code,c.cust_name  ,its.descr " +
					" union all   " +
					" select sum(0) as OverDue_Over_3Days  " +
					" ,sum(0)  as OverDue_Over_2Days  " +
					" ,sum(0)  as OverDue_Yesterday  " +
					" ,sum(r.tot_amt - r.adj_amt)  as OverDue_Today  " +
					" ,sum(0) as OverDue_Tomorrow  " +
					" ,sum(0) as OverDue_Day_After  " +
					" ,sum(0) as OverDue_Rest_of_week  " +
					" ,sum(0) as OverDue_Next_Week  " +
					" ,sum(0) as OverDue_Next_Month  " +
					" ,r.site_code,r.fin_entity,r.item_ser,c.cust_code,c.cust_name,its.descr as itm_descr  " +
					" from receivables r,customer c,site s,itemser its  " +
					" where r.tot_amt - r.adj_amt <> 0  " +
					" and case when r.exp_rcp_date is null then r.due_date else r.exp_rcp_date end  " +
					" between to_date(sysdate)  and to_date(sysdate)  " +
					" and r.cust_code=c.cust_code   " +
					" and r.item_ser=its.item_ser  " +
					" and r.site_code=s.site_code   " +
					" and s.facility_code='"+facilityCode+"' " +
					" group by  r.site_code,r.fin_entity,r.item_ser,c.cust_code,c.cust_name  ,its.descr " +
					" union all   " +
					" select sum(0) as OverDue_Over_3Days  " +
					" ,sum(0)  as OverDue_Over_2Days  " +
					" ,sum(0)  as OverDue_Yesterday  " +
					" ,sum(0)  as OverDue_Today  " +
					" ,sum(r.tot_amt - r.adj_amt) as OverDue_Tomorrow  " +
					" ,sum(0) as OverDue_Day_After  " +
					" ,sum(0) as OverDue_Rest_of_week  " +
					" ,sum(0) as OverDue_Next_Week  " +
					" ,sum(0) as OverDue_Next_Month  " +
					" ,r.site_code,r.fin_entity,r.item_ser,c.cust_code,c.cust_name,its.descr as itm_descr  " +
					" from receivables r,customer c,site s,itemser its  " +
					" where r.tot_amt - r.adj_amt <> 0  " +
					" and case when r.exp_rcp_date is null then r.due_date else r.exp_rcp_date end  " +
					" between to_date(sysdate)  and to_date(sysdate)+1  " +
					" and r.cust_code=c.cust_code   " +
					" and r.item_ser=its.item_ser  " +
					" and r.site_code=s.site_code   " +
					" and s.facility_code='"+facilityCode+"' " +
					" group by  r.site_code,r.fin_entity,r.item_ser,c.cust_code,c.cust_name ,its.descr  " +
					" union all   " +
					" select sum(0) as OverDue_Over_3Days  " +
					" ,sum(0)  as OverDue_Over_2Days  " +
					" ,sum(0)  as OverDue_Yesterday  " +
					" ,sum(0)  as OverDue_Today  " +
					" ,sum(0) as OverDue_Tomorrow  " +
					" ,sum(r.tot_amt - r.adj_amt) as OverDue_Day_After  " +
					" ,sum(0) as OverDue_Rest_of_week  " +
					" ,sum(0) as OverDue_Next_Week  " +
					" ,sum(0) as OverDue_Next_Month  " +
					" ,r.site_code,r.fin_entity,r.item_ser,c.cust_code,c.cust_name ,its.descr as itm_descr " +
					" from receivables r,customer c,site s,itemser its  " +
					" where r.tot_amt - r.adj_amt <> 0  " +
					" and case when r.exp_rcp_date is null then r.due_date else r.exp_rcp_date end  " +
					" between to_date(sysdate)  and to_date(sysdate)+2  " +
					" and r.cust_code=c.cust_code   " +
					" and r.item_ser=its.item_ser  " +
					" and r.site_code=s.site_code   " +
					" and s.facility_code='"+facilityCode+"' " +
					" group by  r.site_code,r.fin_entity,r.item_ser,c.cust_code,c.cust_name  ,its.descr " +
					" union all   " +
					" select sum(0) as OverDue_Over_3Days  " +
					" ,sum(0)  as OverDue_Over_2Days  " +
					" ,sum(0)  as OverDue_Yesterday  " +
					" ,sum(0)  as OverDue_Today  " +
					" ,sum(0) as OverDue_Tomorrow  " +
					" ,sum(0) as OverDue_Day_After  " +
					" ,sum(r.tot_amt - r.adj_amt) as OverDue_Rest_of_week  " +
					" ,sum(0) as OverDue_Next_Week  " +
					" ,sum(0) as OverDue_Next_Month  " +
					" ,r.site_code,r.fin_entity,r.item_ser,c.cust_code,c.cust_name,its.descr as itm_descr  " +
					" from receivables r,customer c,site s,itemser its  " +
					" where r.tot_amt - r.adj_amt <> 0  " +
					" and case when r.exp_rcp_date is null then r.due_date else r.exp_rcp_date end  " +
					" between to_date(sysdate)  and  TRUNC(sysdate+6, 'DAY')  " +
					" and r.cust_code=c.cust_code   " +
					" and r.item_ser=its.item_ser  " +
					" and r.site_code=s.site_code   " +
					" and s.facility_code='"+facilityCode+"' " +
					" group by  r.site_code,r.fin_entity,r.item_ser,c.cust_code,c.cust_name  ,its.descr " +
					" union all   " +
					" select sum(0) as OverDue_Over_3Days  " +
					" ,sum(0)  as OverDue_Over_2Days  " +
					" ,sum(0)  as OverDue_Yesterday  " +
					" ,sum(0)  as OverDue_Today  " +
					" ,sum(0) as OverDue_Tomorrow  " +
					" ,sum(0) as OverDue_Day_After  " +
					" ,sum(0) as OverDue_Rest_of_week  " +
					" ,sum(r.tot_amt - r.adj_amt) as OverDue_Next_Week  " +
					" ,sum(0) as OverDue_Next_Month  " +
					" ,r.site_code,r.fin_entity,r.item_ser,c.cust_code,c.cust_name ,its.descr as itm_descr " +
					" from receivables r,customer c,site s,itemser its  " +
					" where r.tot_amt - r.adj_amt <> 0  " +
					" and case when r.exp_rcp_date is null then r.due_date else r.exp_rcp_date end  " +
					" between TRUNC(sysdate+6, 'DAY')  and  TRUNC(sysdate+12, 'DAY')  " +
					" and r.cust_code=c.cust_code   " +
					" and r.item_ser=its.item_ser  " +
					" and r.site_code=s.site_code   " +
					" and s.facility_code='"+facilityCode+"' " +
					" group by  r.site_code,r.fin_entity,r.item_ser,c.cust_code,c.cust_name  ,its.descr " +
					" union all  " +
					" select sum(0) as OverDue_Over_3Days  " +
					" ,sum(0)  as OverDue_Over_2Days  " +
					" ,sum(0)  as OverDue_Yesterday  " +
					" ,sum(0)  as OverDue_Today  " +
					" ,sum(0) as OverDue_Tomorrow  " +
					" ,sum(0) as OverDue_Day_After  " +
					" ,sum(0) as OverDue_Rest_of_week  " +
					" ,sum(0) as OverDue_Next_Week  " +
					" ,sum(r.tot_amt - r.adj_amt) as OverDue_Next_Month  " +
					" ,r.site_code,r.fin_entity,r.item_ser,c.cust_code,c.cust_name ,its.descr as itm_descr " +
					" from receivables r,customer c,site s,itemser its  " +
					" where r.tot_amt - r.adj_amt <> 0  " +
					" and case when r.exp_rcp_date is null then r.due_date else r.exp_rcp_date end  " +
					" between TO_DATE(0||1||TO_CHAR(ADD_MONTHS(SYSDATE,1),'mmyyyy'),'ddmmyyyy')  and  (LAST_DAY(ADD_MONTHS(SYSDATE,1)))  " +
					" and r.cust_code=c.cust_code   " +
					" and r.item_ser=its.item_ser  " +
					" and r.site_code=s.site_code   " +
					" and s.facility_code='"+facilityCode+"' " +
					" group by  r.site_code,r.fin_entity,r.item_ser,c.cust_code,c.cust_name  ,its.descr " +
					" ) a  " +
					" group by  a.site_code, a.fin_entity, a.item_ser, a.cust_code, a.cust_name ,a.itm_descr " +
					" Order by a.site_code, a.fin_entity, a.item_ser, a.cust_code, a.cust_name,a.itm_descr ";
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			double summaryVal = 0.0;
			while (rs.next())
			{
				rowData = new JSONObject();
				
				rowData.put("overdue_over_3days", checkZero(rs.getString("OverDue_Over_3Days")));
				rowData.put("overdue_over_2days", checkZero(rs.getString("OverDue_Over_2Days")));
				rowData.put("overdue_yesterday", checkZero(rs.getString("OverDue_Yesterday")));
				rowData.put("overdue_today", checkZero(rs.getString("OverDue_Today")));
				rowData.put("overdue_tomorrow", checkZero(rs.getString("OverDue_Tomorrow")));
				rowData.put("overdue_day_after", checkZero(rs.getString("OverDue_Day_After")));
				rowData.put("overdue_rest_of_week", checkZero(rs.getString("OverDue_Rest_of_week")));
				rowData.put("overdue_next_week", checkZero(rs.getString("OverDue_Next_Week")));
				rowData.put("overdue_next_month", checkZero(rs.getString("OverDue_Next_Month")));
				
				rowData.put("site_code", checkNull(rs.getString("site_code")).trim());
				rowData.put("fin_entity", checkNull(rs.getString("fin_entity")).trim());
				rowData.put("item_ser", checkNull(rs.getString("item_ser")).trim());
				rowData.put("cust_code", checkNull(rs.getString("cust_code")).trim());
				rowData.put("cust_name", checkNull(rs.getString("cust_name")).trim());
				rowData.put("itm_descr", checkNull(rs.getString("itm_descr")).trim());
				
				rawDataReceivableJson.put(count, rowData);
				count++;
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;	
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getReceivableDashboard:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataReceivableJson;
		
	}

	
	@SuppressWarnings("unchecked")
	@Override
	//public JSONObject getCreditCompliance(String dataSourceName, String siteCode) throws RemoteException, ITMException 
	public JSONObject getCreditCompliance(String dataSourceName, String siteCode, String facilityCode) throws RemoteException, ITMException 
	{
		JSONObject rawDataCreditComplianceJson = new JSONObject();
		JSONObject rowData = null;
		String sql = null;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		try
		{
			System.out.println(" Inside FGWarehouse for getCreditCompliance siteCode ="+siteCode);
			
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			int count = 0;
			
			
			facilityCode=checkNull(facilityCode);
			if(facilityCode.equalsIgnoreCase(""))
			{
				facilityCode=getFacilityCode(siteCode, dataSourceName);
			}
			System.out.println("Facility Code: "+facilityCode);
			
			String userImagePath    = CommonConstants.JBOSSHOME + File.separator +"server"+File.separator +"default"+File.separator +"deploy"+File.separator +"ibase.ear"+File.separator + "ibase.war" +File.separator +  "resource" + File.separator + "images"+ File.separator + "users"+File.separator;
			
			/*sql = "  Select cust_code,cust_name,site_code, fin_entity,item_ser, sum(No_of_order) No_of_order, sum(Total_Order_Value) as Total_Order_Value " +
					" from( " +
					" Select cust.cust_code,cust.cust_name,so.site_code,s.fin_entity,so.item_ser, count(so.sale_order) as No_of_order ,so.tot_amt as Total_Order_Value " +
					" from sorder so,sorddet sod ,customer cust,itemser its,site s " +
					" where so.DUE_DATE <= sysdate  " +
					" and so.sale_order =sod.sale_order  " +
					" and so.item_ser = its.item_ser  " +
					" and so.cust_code =cust.cust_code  " +
					" and s.site_code =so.site_code " +
					" and s.facility_code ='FC002'  " +
					" GROUP BY cust.cust_code, cust.cust_name, so.site_code, s.fin_entity, so.item_ser, so.sale_order, so.tot_amt " +
					" ) " +
					" group by cust_code,cust_name,site_code, fin_entity,item_ser " +
					" order by cust_code, cust_name, site_code, fin_entity, item_ser ";*/
			
			sql = "Select cust_code,cust_name,site_code, fin_entity,item_ser, itm_descr, sum(distinct No_of_order) No_of_order, " +
					"sum(Total_Order_Value) as Order_Value ,sum(over_ridden_amount) over_ridden_amount " +
					"from( Select cust.cust_code,cust.cust_name,so.site_code,s.fin_entity,so.item_ser, its.descr as itm_descr," +
					"count(bl.sale_order) as No_of_order ,so.tot_amt as Total_Order_Value ,bl.aprv_amt as over_ridden_amount " +
					"from sorder so,customer cust,itemser its,site s, business_logic_check bl where so.order_date   <= sysdate " +
					"and so.sale_order    =bl.sale_order and so.item_ser      =its.item_ser " +
					"and so.cust_code     =cust.cust_code and s.site_code      =so.site_code " +
					"and s.facility_code ='"+facilityCode+"' and so.cr_check_stat='F'  " +
					"GROUP BY cust.cust_code, cust.cust_name, so.site_code, s.fin_entity, " +
					"so.item_ser, so.tot_amt, bl.aprv_amt,its.descr ) GROUP BY cust_code, cust_name, site_code, " +
					"fin_entity, item_ser,itm_descr order by cust_code, cust_name, site_code, fin_entity, item_ser ";
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			
			while (rs.next())
			{
				rowData = new JSONObject();
				
				
				rowData.put("cust_code", checkNull(rs.getString("cust_code")).trim());
				String custCode = checkNull(rs.getString("cust_code")).trim();
				String custName = checkNull(rs.getString("cust_name")).trim();
				File file = new File(userImagePath+custCode+".png");
				if(file.exists())
				{
					rowData.put("custcode_image", "<img class='cardProdImg' src='"+CommonConstants.TOMCAT_HOME+"/ibase/resource/images/users/"+custCode+".png'/>");
				}else
				{
					custName = custName.trim();
					String[] splited = custName.split(" ");
					String defaultUserImg = ""+splited[0].charAt(0);
					
					if(splited.length>1)
					{
						/*Get lastWord of salesPersName and add first char to image for more than one space in salesPersName by Dhanendra on Date 07-07-2016 */
						String lastWord = custName.substring(custName.lastIndexOf(" ")+1);
						defaultUserImg = defaultUserImg + ""+lastWord.charAt(0);
					}
					rowData.put("custcode_image", "<div class='defaultUserImg'><div class='userImageChar'> "+defaultUserImg+"</div> </div>");
				}
				
				rowData.put("cust_name", checkNull(rs.getString("cust_name")).trim());
				rowData.put("site_code", checkNull(rs.getString("site_code")).trim());
				rowData.put("fin_entity", checkNull(rs.getString("fin_entity")).trim());
				rowData.put("item_ser", checkNull(rs.getString("item_ser")).trim());
				rowData.put("itm_descr", checkNull(rs.getString("itm_descr")).trim());
				rowData.put("no_of_order", checkNull(rs.getString("No_of_order")).trim());
				rowData.put("order_value", checkNull(rs.getString("Order_Value")).trim());
				rowData.put("over_ridden_amount", checkNull(rs.getString("over_ridden_amount")).trim());
				
				rawDataCreditComplianceJson.put(count, rowData);
				count++;
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;	
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getReceivableDashboard:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataCreditComplianceJson;
		
	}
	
	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getCreditComplianceDetail(String dataSourceName, String siteCode, String finEntity, String itemSer, String custCode ) throws RemoteException, ITMException
	{
		JSONObject rawDataCreditComplianceDtlJson = new JSONObject();
		JSONObject rowData = null;
		String sql = null;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		
		try
		{
			System.out.println(" ************* Inside FGWarehouse for getCreditComplianceDetail************ ");
			System.out.println(" siteCode : "+siteCode);
			System.out.println(" finEntity : "+finEntity);
			System.out.println(" itemSer : "+itemSer);
			System.out.println(" custCode : "+custCode);
			
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			int count = 0;
			
			
			
			/*sql = " Select cust.cust_code,cust.cust_name,so.site_code,s.fin_entity,so.item_ser, so.sale_order ,so.tot_amt as Total_Order_Value " +
					" from sorder so,sorddet sod ,customer cust,itemser its,site s " +
					" where so.DUE_DATE <= sysdate  " +
					" and so.sale_order =sod.sale_order  " +
					" and so.item_ser = its.item_ser  " +
					" and so.cust_code =cust.cust_code  " +
					" and s.site_code =so.site_code " +
					" and  so.cust_code ='"+custCode+"' " +
					" and s.fin_entity ='"+finEntity+"' " +
					" and so.item_ser ='"+itemSer+"' " +
					" and so.site_code ='"+siteCode+"' " +
					" GROUP BY cust.cust_code, cust.cust_name, so.site_code, s.fin_entity, so.item_ser, so.sale_order, so.tot_amt ";*/
			
			sql=" Select so.cust_code,cust.cust_name, blc.sale_order ,blc.cr_policy,blc.descr,so.tot_amt as order_value , " +
					" CASE when blc.cr_policy ='P06' then (select Max(busi_limit) from customer_series where cust_code=so.cust_code) " +
					" else (select Max(CREDIT_LMT) from customer where cust_code=so.cust_code ) end as limit, " +
					" fn_get_custos(so.cust_code,SO.SITE_CODE,'T') Exposure_due " +
					" from sorder so,customer cust,itemser its,site s ,business_logic_check blc " +
					" where so.order_date <= sysdate and so.sale_order  =blc.sale_order" +
					" and so.item_ser    = its.item_ser and so.cust_code   =cust.cust_code " +
					" and so.cr_check_stat='F'  " +
					"and s.site_code    =so.site_code and  so.cust_code  ='"+custCode+"' and s.fin_entity   ='"+finEntity+"' " +
					"and so.item_ser     ='"+itemSer+"' and so.site_code ='"+siteCode+"' order  by CUST.CUST_CODE, SO.SITE_CODE";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			
			while (rs.next())
			{
				rowData = new JSONObject();
				
				
				rowData.put("cust_code", checkNull(rs.getString("cust_code")).trim());
				rowData.put("cust_name", checkNull(rs.getString("cust_name")).trim());
				//rowData.put("site_code", checkNull(rs.getString("site_code")).trim());
				rowData.put("site_code", siteCode);
				//rowData.put("fin_entity", checkNull(rs.getString("fin_entity")).trim());
				//rowData.put("item_ser", checkNull(rs.getString("item_ser")).trim());
				rowData.put("sale_order", checkNull(rs.getString("sale_order")).trim());
				//rowData.put("total_order_value", checkNull(rs.getString("Total_Order_Value")).trim());
				rowData.put("cr_policy", checkNull(rs.getString("cr_policy")).trim());
				rowData.put("descr", checkNull(rs.getString("descr")).trim());
				rowData.put("order_value", checkNull(rs.getString("order_value")).trim());
				rowData.put("limit", checkNull(rs.getString("limit")).trim());
				rowData.put("Exposure_due", checkNull(rs.getString("Exposure_due")).trim());
				
				rawDataCreditComplianceDtlJson.put(count, rowData);
				count++;
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;	
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getReceivableDashboard:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataCreditComplianceDtlJson;
		
	}
	
	@SuppressWarnings("unchecked")
	@Override
	//	public JSONObject getPendingShipment(String dataSourceName, String siteCode) throws RemoteException, ITMException 
	public JSONObject getPendingShipment(String dataSourceName, String siteCode, String facilityCode) throws RemoteException, ITMException 
	{
		JSONObject rawDataPendingShipmentJson = new JSONObject();
		JSONObject rowData = null;
		String sql = null;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		try
		{
			System.out.println(" ************* Inside FGWarehouse for getPendingShipment************ ");
			System.out.println(" siteCode : "+siteCode);
			
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			int count = 0;
			
			
			facilityCode=checkNull(facilityCode);
			if(facilityCode.equalsIgnoreCase(""))
			{
				facilityCode=getFacilityCode(siteCode, dataSourceName);
			}
			System.out.println("Facility Code: "+facilityCode);
			
			/*sql = " select s.site_code, " +
					" C.City, C.State_code , " +
					" Count(Distinct C.cust_code) No_of_Customers, " +
					" Sum(Quantity__STDUOM* Nvl(I.Net_Weight,0)) as Weight, " +
					" Sum(SD.Ord_value) Order_Value, " +
					" Count(Distinct Inv.Invoice_id) No_of_Shipments " +
					" from sorder SO,Customer C,SOrddet SD,Item I,Invoice Inv, Site s " +
					" where SO.cust_code=C.cust_code " +
					" and SO.Sale_order=SD.Sale_order " +
					" and so.sale_order=Inv.Sale_order " +
					" and SD.Item_Code=I.Item_code " +
					" and so.site_code = s.site_code " +
					" and s.facility_code='FC002' " +
					" group by C.City, C.State_code,s.site_code " +
					" order by s.site_code,C.State_code,C.City ";*/
			
			sql="select C.City, C.State_code ,k.distance as distance , c.stan_code,st.descr, " +
				"Count(Distinct C.cust_code) No_of_Customers, " +
				"Sum(Quantity__STDUOM* Nvl(I.Net_Weight,0)) as Weight, " +
				"Sum(so.ord_amt) Order_Value, Count(Distinct d.desp_id) No_of_Shipments, " +
				"so.site_code, s.fin_entity, so.item_ser,it.descr as itm_descr,state.descr as state_descr,C.cust_code from sorder SO,SOrddet SD, " +
				"despatch d, Customer C,Item I,Invoice Inv,itemser it,site s,distance k,station st,state state " +
				"where SO.cust_code = C.cust_code " +
				"and  SO.Sale_order = SD.Sale_order " +
				"and  so.sale_order   =d.sord_no " +
				"and  so.sale_order =Inv.Sale_order " +
				"and  SD.Item_Code  =I.Item_code " +
				"and  so.site_code  =s.site_code " +
				"and  c.stan_code = st.stan_code " +
				"and  so.item_ser   =it.item_ser " +
				"and  k.stan_code__from =s.stan_code " +
				"and  k.stan_code__to  =c.stan_code " +
				"AND c.State_code = state.State_code " +
				"and  s.facility_code ='"+facilityCode+"' " +
				"group by C.City, C.State_code, k.distance, so.site_code, s.fin_entity, so.item_ser,c.stan_code,st.descr,it.descr,state.descr,C.cust_code " +
				"order by C.City, C.State_code, so.site_code, s.fin_entity, so.item_ser,c.stan_code,st.descr ";
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			
			while (rs.next())
			{
				rowData = new JSONObject();
				
				rowData.put("site_code", checkNull(rs.getString("site_code")).trim());
				rowData.put("city", checkNull(rs.getString("City")).trim());
				rowData.put("state_code", checkNull(rs.getString("State_code")).trim());
				rowData.put("distance", checkNull(rs.getString("distance")).trim());
				
				rowData.put("no_of_customers", checkNull(rs.getString("No_of_Customers")).trim());
				rowData.put("weight", checkNull(rs.getString("Weight")).trim());
				rowData.put("order_value", checkNull(rs.getString("Order_Value")).trim());
				if(count==0)
				{
					rowData.put("no_of_shipments", "10");
				}
				else if(count==1)
				{
					rowData.put("no_of_shipments", "20");
				}
				else{
					rowData.put("no_of_shipments", checkNull(rs.getString("No_of_Shipments")).trim());
				}
				
				rowData.put("fin_entity", checkNull(rs.getString("fin_entity")).trim());
				rowData.put("item_ser", checkNull(rs.getString("item_ser")).trim());
				rowData.put("itm_descr", checkNull(rs.getString("itm_descr")).trim());
				
				rowData.put("stan_code", checkNull(rs.getString("stan_code")).trim());
				rowData.put("descr", checkNull(rs.getString("descr")).trim());
				rowData.put("state_descr", checkNull(rs.getString("state_descr")).trim());
				rowData.put("cust_code", checkNull(rs.getString("cust_code")).trim());
				rawDataPendingShipmentJson.put(count, rowData);
				count++;
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;	
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getReceivableDashboard:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataPendingShipmentJson;
		
	}

	
	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getCreditComplianceExposureDtl(String dataSourceName, String siteCode, String custCode ) throws RemoteException, ITMException 
	{
		JSONObject rawDataCreditCompExpoDtlJson = new JSONObject();
		JSONObject rowData = null;
		String sql = null;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		
		try
		{
			System.out.println(" ************* Inside FGWarehouse for getCreditComplianceExposureDtl************ ");
			System.out.println(" siteCode : "+siteCode+"----- custCode :"+custCode);
			conn = connDriver.getConnectDB(dataSourceName);
			connDriver = null;	
			int count = 0;
						
			sql=" select cust_code,site_code, ref_no as invoice_no,to_char(ref_date,'dd-MON-yy') as invoice_date,to_char(due_date,'dd-MON-yy') as due_date, tot_amt-adj_amt as balance_amt " + 
				" from receivables " +
				" where cust_code = '"+custCode+"' " +
				" and site_code = '"+siteCode+"' Order by 4,6 ";
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			
			while (rs.next())
			{
				rowData = new JSONObject();
				
				rowData.put("cust_code", checkNull(rs.getString("cust_code")).trim());
				rowData.put("site_code", checkNull(rs.getString("site_code")).trim());
				rowData.put("invoice_no", checkNull(rs.getString("invoice_no")).trim());
				rowData.put("invoice_date", checkNull(rs.getString("invoice_date")).trim());
				rowData.put("due_date", checkNull(rs.getString("due_date")).trim());
				rowData.put("balance_amt", checkNull(rs.getString("balance_amt")).trim());
				
				rawDataCreditCompExpoDtlJson.put(count, rowData);
				count++;
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;	
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getReceivableDashboard:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataCreditCompExpoDtlJson;
		
	}
	
	private String getFacilityCode(String siteCode, String dataSourceName) throws  ITMException
	{
		String facilityCode = "";
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		
		try {
			conn= connDriver.getConnectDB(dataSourceName);
			connDriver = null;
			
			sql = "Select facility_code from site where site_code='"+siteCode+"'"; 
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			
			if(rs.next())
			{
				facilityCode = checkNull(rs.getString("facility_code")).trim();
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;	
			
		} catch (Exception e) {
			e.printStackTrace();
			throw new ITMException(e);
		}finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getFacilityCode:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return facilityCode;
	}

	
	private String checkNull(String str)
	{
		if (str == null)
		{
			return "";
		} else
		{
			return str.trim();
		}
	}
	private String checkZero(String str)
	{
		if (str == null)
		{
			return "0";
		} else
		{
			return str;
		}
	}


	@SuppressWarnings("unchecked")
	@Override
	public JSONObject getReceivableDashboardDtl(String dataSourceName, String siteCode, String sessionSiteCode, String finEntity, String itemSeries, String custCode,String status) throws RemoteException,ITMException 
	{
		JSONObject rawDataReceivableDtlJson = new JSONObject();
		JSONObject rowData = null;
		String sql = null;
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		Connection conn = null;
		ConnDriver connDriver = new ConnDriver();
		DashboardUtility dashboardUtility = null;
		String falilityCode = "";
		try
		{
			System.out.println(" Inside FGWarehouse for getReceivableDashboardDtl siteCode ="+siteCode);
			dashboardUtility = new DashboardUtility();
			conn = connDriver.getConnectDB(dataSourceName);
			
			siteCode = dashboardUtility.getCommaSeparated(siteCode);
			finEntity = dashboardUtility.getCommaSeparated(finEntity);
			itemSeries = dashboardUtility.getCommaSeparated(itemSeries);
			custCode = dashboardUtility.getCommaSeparated(custCode);
			
			System.out.println(" status : "+status);
					
			connDriver = null;	
			int count = 0;
			String appendSqlStr = "";
			if(siteCode.length()>0 && finEntity.length()>0 && itemSeries.length()>0 && custCode.length()>0)
			{
				appendSqlStr = " and r.cust_code in ("+custCode+")  " +
				" and r.site_code in ("+siteCode+") and r.item_ser in ("+itemSeries+") and r.fin_entity in ("+finEntity+") ";
			}else
			{
				falilityCode = getFacilityCode(sessionSiteCode, dataSourceName);
				appendSqlStr = "and s.facility_code='"+falilityCode+"' ";
			}
			
			if("Overdue over 3days".equalsIgnoreCase(status))
			{
				appendSqlStr = " and case when r.exp_rcp_date is null then r.due_date else r.exp_rcp_date end between to_date(sysdate) -3 and to_date(sysdate)";
			}else if("Overdue over 2days".equalsIgnoreCase(status))
			{
				appendSqlStr = " and case when r.exp_rcp_date is null then r.due_date else r.exp_rcp_date end between to_date(sysdate) -2 and to_date(sysdate)";
			}
			else if("Overdue yesterday".equalsIgnoreCase(status))
			{
				appendSqlStr = " and case when r.exp_rcp_date is null then r.due_date else r.exp_rcp_date end between to_date(sysdate) -1 and to_date(sysdate)";
			}
			else if("Overdue today".equalsIgnoreCase(status))
			{
				appendSqlStr = " and case when r.exp_rcp_date is null then r.due_date else r.exp_rcp_date end between to_date(sysdate) and to_date(sysdate)";
			}
			else if("Overdue tomorrow".equalsIgnoreCase(status))
			{
				appendSqlStr = " and case when r.exp_rcp_date is null then r.due_date else r.exp_rcp_date end between to_date(sysdate) and to_date(sysdate) +1";
			}
			else if("Overdue day after".equalsIgnoreCase(status))
			{
				appendSqlStr = " and case when r.exp_rcp_date is null then r.due_date else r.exp_rcp_date end between to_date(sysdate) and to_date(sysdate) +2";
			}
			else if("Overdue rest of week".equalsIgnoreCase(status))
			{
				appendSqlStr = " and case when r.exp_rcp_date is null then r.due_date else r.exp_rcp_date end between to_date(sysdate) and  TRUNC(sysdate+6, 'DAY')";
			}
			else if("Overdue next week".equalsIgnoreCase(status))
			{
				appendSqlStr = " and case when r.exp_rcp_date is null then r.due_date else r.exp_rcp_date end between TRUNC(sysdate+6, 'DAY')  and  TRUNC(sysdate+12, 'DAY')";
			}
			else if("Overdue next month".equalsIgnoreCase(status))
			{
				appendSqlStr = " and case when r.exp_rcp_date is null then r.due_date else r.exp_rcp_date end between TO_DATE(0||1||TO_CHAR(ADD_MONTHS(SYSDATE,1),'mmyyyy'),'ddmmyyyy')  and  (LAST_DAY(ADD_MONTHS(SYSDATE,1)))";
			}
			
			
			sql = " select c.cust_code,c.cust_name,r. site_code, r.ref_no as bill_no,to_char(r.ref_date,'dd-MON-yy') as bill_date, r.tot_amt as bill_amt, " +
				" r.tot_amt-r.adj_amt as balance_amt,r.adj_amt as receipt_amt, to_char(r.due_date,'dd-MON-yy') as due_date  " +
				" ,its.descr as item_descr " +
				" from receivables r ,customer c, itemser its,site s " +
				" where  " +
				" c.cust_code = r.cust_code and s.site_code = r.site_code" +
				" and its.item_ser = r.item_ser " +
				appendSqlStr + " Order by 4,6 ";
			
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			
			while (rs.next())
			{
				rowData = new JSONObject();
				
				rowData.put("cust_code", checkNull(rs.getString("cust_code")));
				rowData.put("cust_name", checkNull(rs.getString("cust_name")));
				rowData.put("site_code", checkNull(rs.getString("site_code")));
				rowData.put("bill_no", checkNull(rs.getString("bill_no")));
				rowData.put("bill_date", checkNull(rs.getString("bill_date")));
				rowData.put("bill_amt", checkNull(rs.getString("bill_amt")));
				rowData.put("balance_amt", checkNull(rs.getString("balance_amt")));
				rowData.put("receipt_amt", checkNull(rs.getString("receipt_amt")));
				rowData.put("due_date", checkNull(rs.getString("due_date")));
				rowData.put("item_descr", checkNull(rs.getString("item_descr")));
				rawDataReceivableDtlJson.put(count, rowData);
				count++;
			}
			rs.close();
			rs=null;
			pstmt.close();
			pstmt=null;	
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if (conn != null)
				{
					if (rs != null)
					rs.close();
					rs = null;
					if (pstmt != null)
					pstmt.close();
					pstmt = null;
					conn.close();
					conn = null;
				}
				conn = null;
			} catch (Exception d)
			{
				d.printStackTrace();
				System.out.println("Exception in :getReceivableDashboard:" + d.getMessage());
				throw new ITMException(d);
			}
		}
		return rawDataReceivableDtlJson;
		
	
	
	}
}
