 /* 
	Developed by : Niraja
	Company : Base Information Management Pvt. Ltd
	Version : 1.0
	Date :
	Window Name : w_pay_ibca
	Button Name : Emp , Batch , Default
	Action		: Get details for Emp,Batch,Default as per conditions.

*/

package ibase.webitm.ejb.fin.adv;

import java.rmi.RemoteException;
import java.sql.*;
import org.w3c.dom.*;
import javax.ejb.*;

import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.system.config.*;
import javax.ejb.Stateless; // added for ejb3

@Stateless // added for ejb3

public class PayIbcaAct extends ActionHandlerEJB implements PayIbcaActLocal,PayIbcaActRemote // SessionBean
{
	/*public void ejbCreate() throws RemoteException, CreateException 
	{
	}

	public void ejbRemove()
	{
	}

	public void ejbActivate() 
	{
	}

	public void ejbPassivate() 
	{
	}
	*/
    public String actionHandler() throws RemoteException,ITMException
	{
		return "";
	}

	public String actionHandler(String actionType, String xmlString, String objContext, String xtraParams) throws RemoteException,ITMException
	{
		System.out.println("PayIbcaEJB called");
		Document dom = null;
		String  resString = null;
		try
		{	
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				GenericUtility genericUtility = GenericUtility.getInstance(); 
				System.out.println("XML String :"+xmlString);
				dom = genericUtility.parseString(xmlString); 
			}
			System.out.println("actionType:"+actionType+":");
			if (actionType.equalsIgnoreCase("Emp"))
			{
			  resString = actionEmp(dom,objContext,xtraParams);
			}
			else if (actionType.equalsIgnoreCase("Batch"))
			{
				resString = actionBatch(dom,objContext,xtraParams);				
			}
			else if (actionType.equalsIgnoreCase("Default"))
			{
				resString = actionDefault(dom,objContext,xtraParams);
			}
		}
	   	catch(Exception e)
		{
			System.out.println("Exception :PayIbcaEJB :actionHandler(String xmlString):" + e.getMessage() + ":");
			throw new ITMException(e);
		}
		System.out.println("returning from actionVoucher actionHandler"+resString);
	    return resString;
	}

	private String actionEmp(Document dom, String objContext, String xtraParams) throws RemoteException , ITMException
	{
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		String sql = "";
		String siteCodeFr = "";
		String siteCodeTo = "";
		String tranSer = "";
		String refNo = "";
		String entryBatchNo = "";
		String errCode = "";
		String errString = "";
		String detCnt = "0";
		ConnDriver connDriver = new ConnDriver();
		GenericUtility genericUtility = GenericUtility.getInstance();
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		StringBuffer valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n");
		try
		{
			//detCnt = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"detCnt"); //Will be Uncommented later - Jiten
			if (detCnt.equals("0"))
			{

				conn = connDriver.getConnectDB("DriverITM");
				stmt = conn.createStatement();
				siteCodeFr = genericUtility.getColumnValue("site_code__from",dom);
				siteCodeTo = genericUtility.getColumnValue("site_code__to",dom);
				System.out.println("siteCodeFr:"+siteCodeFr+":\t siteCodeTo:" +siteCodeTo+":");
				sql = "	 SELECT TRAN_SER, REF_NO, ENTRY_BATCH_NO FROM MISC_PAYABLES, EMPLOYEE WHERE "+
					  "	 MISC_PAYABLES.SUNDRY_CODE = EMPLOYEE.EMP_CODE  "+
					  "	 AND TRAN_SER = 'P-VOUC' AND TOT_AMT - ADJ_AMT <> 0 "+
					  "	 AND SITE_CODE = '"+siteCodeFr+"'" +
					  "  AND PAY_SITE = '"+siteCodeTo+"'";
				System.out.println("PayIbcaEJB :actionEmp:sql:"+sql);
				rs = stmt.executeQuery(sql);
				while(rs.next())
				{
					tranSer =rs.getString("TRAN_SER");
					refNo =rs.getString("REF_NO");
					entryBatchNo =rs.getString("ENTRY_BATCH_NO");

					valueXmlString.append("<Detail>\r\n");
					//valueXmlString.append("<tran_ser>").append("<![CDATA[").append(tranSer.trim()).append("]]>").append("</tran_ser>\r\n");
					valueXmlString.append("<ref_ser>").append("<![CDATA[").append(tranSer.trim()).append("]]>").append("</ref_ser>\r\n");//Aviprash 
					valueXmlString.append("<ref_no>").append("<![CDATA[").append(refNo.trim()).append("]]>").append("</ref_no>\r\n");
					valueXmlString.append("<entry_batch_no>").append("<![CDATA[").append(entryBatchNo.trim()).append("]]>").append("</entry_batch_no>\r\n");
					valueXmlString.append("</Detail>\r\n");

				}
				valueXmlString.append("</Root>\r\n");			
			}
			else
			{
				errCode = "VTDETCNT";
			}
			if (!errCode.equals(""))
			{
				errString = itmDBAccessEJB.getErrorString("",errCode,"","",conn);
				conn.close();
				conn = null;
				return errString;
			}
	   	}
		catch(SQLException e)
		{
			System.out.println("Exception : PayIbcaEJB : actionEmp():" +e.getMessage());
			throw new ITMException(e);
		}
		catch(Exception e)
		{
			System.out.println("Exception :PayIbcaEJB :actionEmp():"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("Closing Connection.....");
				conn.close();
				conn = null;
			}catch(SQLException se){}
		}
		return valueXmlString.toString();
	}

	private String actionBatch(Document dom, String objContext, String xtraParams) throws RemoteException , ITMException
	{
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		String sql = "";
		String siteCodeFr = "";
		String entryBatchNo = "";
		String tranSer = "";
		String refNo = "",errCode = "",errString = "";
		String detCnt  = "0";
		GenericUtility genericUtility = GenericUtility.getInstance();
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		ConnDriver connDriver = new ConnDriver();
		StringBuffer valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n");
		try
		{
			//detCnt = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"detCnt"); //Will be Uncommented later - Jiten
			System.out.println("******* detCnt ******:"+detCnt+":");
			if (detCnt.equals("0") )
			{
				siteCodeFr = genericUtility.getColumnValue("site_code__from",dom);
				entryBatchNo = genericUtility.getColumnValue("entry_batch_no",dom);
				System.out.println("siteCodeFr:"+siteCodeFr+":\n entryBatchNo:"+entryBatchNo+":");
				if(entryBatchNo != null && entryBatchNo.trim().length() > 0)
				{
					entryBatchNo = entryBatchNo.trim()+"%";
					conn = connDriver.getConnectDB("DriverITM");	
					stmt = conn.createStatement();
					sql = " SELECT TRAN_SER, REF_NO FROM MISC_PAYABLES  "+
						  "	WHERE ENTRY_BATCH_NO LIKE '"+entryBatchNo+"' "+
						  "  AND TOT_AMT - ADJ_AMT <> 0 "+ 
						  "	 AND SITE_CODE ='"+siteCodeFr+"'";
					System.out.println("PayIbcaEJB :actionEmp:sql:"+sql);
					rs = stmt.executeQuery(sql);
					while(rs.next())
					{
						tranSer =rs.getString("TRAN_SER");
						refNo =rs.getString("REF_NO");
						valueXmlString.append("<Detail>\r\n");
						//valueXmlString.append("<tran_ser>").append("<![CDATA[").append(tranSer.trim()).append("]]>").append("</tran_ser>\r\n");
						valueXmlString.append("<ref_ser>").append("<![CDATA[").append(tranSer.trim()).append("]]>").append("</ref_ser>\r\n");
						valueXmlString.append("<ref_no>").append("<![CDATA[").append(refNo.trim()).append("]]>").append("</ref_no>\r\n");
						valueXmlString.append("</Detail>\r\n");
					}
					valueXmlString.append("</Root>\r\n");						
				}
				else
				{
					errCode = "VTNLBATCH";
				}
			}
			else
			{
				errCode = "VTDETCNT";
			}
			if (!errCode.equals("") || errCode.trim().length()>0)
			{
				System.out.println("errCode :"+errCode);
				errString = itmDBAccessEJB.getErrorString("",errCode,"","",conn);		
				conn.close();
				conn = null;
				return errString;
			}
		}
		catch(SQLException e)
		{
			System.out.println("Exception : PayIbcaEJB : actionBatch()" +e.getMessage());
			throw new ITMException(e);
		}
		catch(Exception e)
		{
			System.out.println("Exception :PayIbcaEJB :actionBatch():"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("Closing Connection.....");
				conn.close();
				conn = null;
			}catch(Exception se){}
		}
		System.out.println("PayIbcaEJB :actionBatch():valueXmlString.toString():"+valueXmlString.toString());
		return valueXmlString.toString();
	}

	private String actionDefault(Document dom, String objContext, String xtraParams) throws RemoteException , ITMException
	{
		Connection conn = null;
		Statement stmt = null;
		ResultSet rs = null;
		String sql = "";
		String siteCodeFr = "";
		String currCode = "";
		String sundryCode = "";
		String tranSer = "";
		String refNo = "";
		String errCode = "";
		String errString = "";
		String detCnt = "0";
		ConnDriver connDriver = new ConnDriver();
		GenericUtility genericUtility = GenericUtility.getInstance();
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		StringBuffer valueXmlString = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root>\r\n");
		try
		{
			//detCnt = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"detCnt"); //Will be Uncommented later - Jiten
			if (detCnt.equals("0"))
			{
				siteCodeFr = genericUtility.getColumnValue("site_code__from",dom);
				currCode = genericUtility.getColumnValue("curr_code",dom);
				sundryCode = genericUtility.getColumnValue("sundry_code",dom);
				System.out.println("PayIbcaEJB:actionDefault:siteCodeFr:"+siteCodeFr+":currCode:"+currCode+":sundryCode:"+sundryCode);
				if(sundryCode == null || sundryCode.trim().length()== 0)
				{
					 sql = "SELECT TRAN_SER, REF_NO FROM MISC_PAYABLES  "+
					   " WHERE SITE_CODE = '" + siteCodeFr +"'"+" AND CURR_CODE = '" + currCode+"'"+
					   " AND TOT_AMT - ADJ_AMT <> 0 AND TRAN_SER <> 'M-ADV' AND TRAN_SER <> 'P-ADV' "+
					   " AND TRAN_SER NOT LIKE 'P-IBC%' ORDER BY DUE_DATE " ;
				}
				else
				{	
					 sql = "SELECT TRAN_SER, REF_NO FROM MISC_PAYABLES   "+
						"  WHERE SITE_CODE = '" +siteCodeFr +"' AND CURR_CODE = '" +currCode+"'"+
						"  AND SUNDRY_CODE = '"+ sundryCode +"'"+
						"  AND TOT_AMT - ADJ_AMT <> 0 AND TRAN_SER <> 'M-ADV' AND TRAN_SER <> 'P-ADV' "+
						"  AND TRAN_SER NOT LIKE 'P-IBC%' ORDER BY DUE_DATE " ;
				}
				conn = connDriver.getConnectDB("DriverITM");
				stmt = conn.createStatement();
				System.out.println("PayIbcaEJB :actionDefault:sql:"+sql);
				rs = stmt.executeQuery(sql);
				while(rs.next()) //Change if to while Aviprash 25/10/05
				{
					tranSer =rs.getString("TRAN_SER");
					refNo =rs.getString("REF_NO");
					valueXmlString.append("<Detail>\r\n");
					//valueXmlString.append("<tran_ser>").append("<![CDATA[").append(tranSer.trim()).append("]]>").append("</tran_ser>\r\n");
					valueXmlString.append("<ref_ser>").append("<![CDATA[").append(tranSer.trim()).append("]]>").append("</ref_ser>\r\n");
					valueXmlString.append("<ref_no>").append("<![CDATA[").append(refNo.trim()).append("]]>").append("</ref_no>\r\n");
					valueXmlString.append("</Detail>\r\n");
				}
				valueXmlString.append("</Root>\r\n");		
			}
			else
			{
				errCode = "VTDETCNT";
			}
			if (!errCode.equals(""))
			{
				errString = itmDBAccessEJB.getErrorString("",errCode,"","",conn);
				conn.close();
				conn = null;
				return errString;
			}
		}
		catch(SQLException e)
		{
			System.out.println("Exception : PayIbcaEJB : actionDefault():SQLException:" +e.getMessage());
			throw new ITMException(e);
		}
		catch(Exception e)
		{
			System.out.println("Exception :PayIbcaEJB :actionDefault()"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("Closing Connection.....");
				conn.close();
				conn = null;
			}
			catch(SQLException se){}
		}
		System.out.println("PayIbcaEJB:actionDefault():valueXmlString.toString():"+valueXmlString.toString());
		return valueXmlString.toString();
	}
}