package ibase.webitm.ejb.mfg;

import ibase.utility.*;
import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.ejb.mfg.RequirementICRemote;
import ibase.webitm.utility.*;

import javax.servlet.http.*;
import java.io.*;
import javax.naming.InitialContext;
public class RunMrpBomPopHelpBean  
{
	private ibase.utility.UserInfoBean userInfo = null;
	private HttpSession sessionCtx = null;
	ITMWizardStatefulRemote itmWizardRemote = null;
	private String objName = "";
	private String user_lang ="en"; 
	private String user_country = "US";
	
	public RunMrpBomPopHelpBean ( String objName, HttpSession sessionCtx ) throws ITMException
	{
		try
		{
			this.objName = objName;
			this.sessionCtx = sessionCtx;
			this.userInfo = ( ibase.utility.UserInfoBean ) this.sessionCtx.getAttribute("USER_INFO");
			this.user_lang = this.userInfo.getUserLanguage();
			this.user_country = this.userInfo.getUserCountry();
			if( this.itmWizardRemote == null )
			{
				InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
				this.itmWizardRemote = (ibase.webitm.ejb.ITMWizardStatefulRemote)ctx.lookup("ibase/ITMWizardStatefulEJB/remote");
				
				this.itmWizardRemote.setUserInfo( this.userInfo );
				
				this.itmWizardRemote.loadFormsMetaData( this.objName, "1", this.objName+"21", this.userInfo.getEmpCode(), this.userInfo.getProfileId() );
			}
		}
		catch (ITMException itme)
		{
			itmWizardRemote.remove();
			itmWizardRemote = null;
			throw itme;
		}
		catch (Exception e)
		{
			itmWizardRemote.remove();
			itmWizardRemote = null;
			throw new ITMException(e);
		}		
	}

	public RunMrpBomPopHelpBean () throws ITMException
	{
	}
	//get item code pop help 
	public String getBomCodeList( String itemCode , String dbID ) throws ITMException
	{
		String bomCodeData = "";
		RunMRPWizRemote runMRPWizRemote = null;
		try
		{
			InitialContext ctx = new InitialContext( new AppConnectParm().getProperty() );
			runMRPWizRemote = (ibase.webitm.ejb.mfg.RunMRPWizRemote)ctx.lookup("ibase/RunMRPWiz/remote");
			bomCodeData = runMRPWizRemote.getBomCodeList( itemCode ,dbID );
			runMRPWizRemote = null;
			System.out.println("bomCodeData=="+bomCodeData);
			String xslFileName = getXSLFileName( "mrp_bom_code_wiz_" + this.user_lang + "_" + this.user_country + ".xsl" );
			//String xslFileName = getXSLFileName( "requirement_item_code_wiz_en_US.xsl" );
			bomCodeData = ( new ibase.webitm.utility.GenericUtility() ).transformToString( xslFileName, bomCodeData, CommonConstants.APPLICATION_CONTEXT + File.separator + "temp", "Output", ".html" );
			
			System.out.println("bomCodeData==="+bomCodeData);
		}
		catch ( Exception e  )
		{
			throw new ITMException(e);
		}
		finally
		{
			if ( runMRPWizRemote != null )
			{
				runMRPWizRemote = null;
			}						
		}
		return bomCodeData;
	}
	
	private String getXSLFileName( String xslFileName )throws ITMException
	{   
		String retFileName = null;
		try
		{
			String defaultPath = null;
			if( CommonConstants.APPLICATION_CONTEXT != null )
			{
				defaultPath = CommonConstants.APPLICATION_CONTEXT + CommonConstants.ITM_CONTEXT + File.separator;
			}
			else
			{
				defaultPath = ".." + File.separator + "webapps" + File.separator + "ibase" + File.separator + CommonConstants.ITM_CONTEXT + File.separator;
			}
			File xslPath = new File( defaultPath + File.separator  + "xsl" + File.separator + CommonConstants.THEME + File.separator + "WIZARD");
			if ( !xslPath.exists() )
			{
				xslPath.mkdir();
			}
			System.out.println( " xslPath [" + xslPath +"] xslFileName ["+xslFileName +"]");
			File xslFile = new File(xslPath , xslFileName);
			if( xslFile.exists() )
			{
				retFileName = xslFile.getAbsolutePath();
			}
			else
			{
				throw new ITMException( new Exception( retFileName + " Wizard XSL file Not Found") );	
			}
		}
		catch (Exception e)
		{
			throw new ITMException(e);
		}
		return retFileName;
	}

}

