/*
    Window Name : w_analyact
	Button Name : Process
	Action		: It insert the values into ACCOUNTS_ANALYSIS Table
*/
package ibase.webitm.ejb.fin.adv;

import java.rmi.RemoteException;
import java.sql.*;
import org.w3c.dom.*;
import javax.ejb.*;

import ibase.webitm.utility.ITMException;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.GenericUtility;
import ibase.system.config.*;
import javax.ejb.Stateless; // added for ejb3

@Stateless // added for ejb3

public class AnalAcctPrc extends ProcessEJB implements  AnalAcctPrcLocal ,AnalAcctPrcRemote //SessionBean
{
  	/*public void ejbCreate() throws RemoteException, CreateException
	{
		System.out.println("ProcessEJB ejbCreate called.........");		
	}
	public void ejbRemove()
	{
	}
	public void ejbActivate() 
	{
	}
	public void ejbPassivate() 
	{
	}*/
	public String process() throws RemoteException,ITMException
	{
		return "";
	}
	public String process(String xmlString, String xmlString2, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		Document detailDom = null;
		Document headerDom = null;
		String retStr = "";
		GenericUtility genericUtility = GenericUtility.getInstance();
		try
		{
			if(xmlString != null && xmlString.trim().length() > 0)
			{
				System.out.println("XML String :"+xmlString);
				headerDom = genericUtility.parseString(xmlString); 				
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				System.out.println("XML String :"+xmlString2);
				detailDom = genericUtility.parseString(xmlString2); 
			}
			retStr = process(headerDom, detailDom, windowName, xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception :AnalAcctCpyEJB :process() :: " + e.getMessage() + ":");
			throw new ITMException(e);
		}
		return retStr;
	}
	public String process(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		String analCodeSrc = "";
		String analCodeTgt = "";
		String acctCodeFrom = "";
		String acctCodeTo = "";
		String chgUser = "",chgTerm = "";
		String sql = "", sql1 = "";
		String acctCode = "";
		String errCode = "";
		String errString = "";
		Statement stmt = null,stmt1 = null;
		ResultSet rs = null, rs1 = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		java.sql.Date currDate = null;
		int insertCount = 0,rows = 0, count =0; 
		GenericUtility genericUtility = GenericUtility.getInstance();
		ConnDriver connDriver = new ConnDriver();
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		try
		{
			conn = connDriver.getConnectDB("DriverITM");
			currDate = new java.sql.Date(System.currentTimeMillis());
			analCodeSrc = genericUtility.getColumnValue("anal_code__src",headerDom);
			analCodeTgt = genericUtility.getColumnValue("anal_code__tgt",headerDom);
			acctCodeFrom = genericUtility.getColumnValue("acct_code__fr",headerDom);
			acctCodeTo = genericUtility.getColumnValue("acct_code__to",headerDom);
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginCode");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
			
			if (analCodeSrc != null)
			{
				sql = "SELECT ACCOUNTS_ANALYSIS.ACCT_CODE FROM ACCOUNTS_ANALYSIS WHERE ACCOUNTS_ANALYSIS.ANAL_CODE ='"+ analCodeSrc +"'";
			}
			else
			{
				sql = "SELECT ACCOUNTS.ACCT_CODE FROM ACCOUNTS WHERE ACCOUNTS.ACCT_CODE >= '"+ acctCodeFrom +"'"+" AND  ACCOUNTS.ACCT_CODE <= '"+ acctCodeTo +"'";
			}
			System.out.println("Exceuting SQL :: "+sql);
			stmt = conn.createStatement();
			stmt1 = conn.createStatement();
			rs = stmt.executeQuery(sql);
			if (analCodeTgt == null)
			{
				System.out.println("cctrCodeTgt not found ");
				errCode = "VMCCTR1";
			}
			else
			{
				sql = "INSERT INTO ACCOUNTS_ANALYSIS(ACCT_CODE, ANAL_CODE, CHG_DATE, CHG_USER, CHG_TERM) VALUES(?, ?, ?, ?, ?)";
				pstmt = conn.prepareStatement(sql);
				
				System.out.println("insertSql :"+sql);
				while(rs.next())
				{
					acctCode = rs.getString(1);
					sql1 = "SELECT COUNT(*) FROM ACCOUNTS_ANALYSIS WHERE ACCT_CODE = '"+acctCode+"' AND ANAL_CODE= '"+analCodeTgt+"' ";
					
					rs1 = stmt1.executeQuery(sql1);
					if (rs1.next())
					{
						count = rs1.getInt(1);
						if (count > 0)
						{
							continue;
						}
					}
					pstmt.setString(1, acctCode);
					pstmt.setString(2, analCodeTgt);
					pstmt.setDate(3, currDate);
					pstmt.setString(4, chgUser);
					pstmt.setString(5, chgTerm);
					rows = pstmt.executeUpdate();
					if (rows > 0)
					{
						insertCount++;
					}
					pstmt.clearParameters();
				}			
			}
			if (insertCount > 0)
			{
				errCode = "VMSUCC";
			}
			else if (insertCount == 0)
			{
				errCode = "VTNCOPY";  
			}
			System.out.println("Record Inserted :: "+insertCount);
			if (errCode != null || errCode.trim().length()>0)
			{
				errString = itmDBAccessEJB.getErrorString("", errCode, "", "", conn);
				System.out.println("errString: "+errString);
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception :AnalyAcctCpyEJB :process(dom) :: " + e.getMessage() + ":");
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("Closing Connection......");
				conn.close();				
				conn = null;
			}catch(SQLException se){}
		}
		return errString;
	} 
}