package ibase.dashboard.mfg.servlet;
import ibase.dashboard.mfg.bean.ProductionVsBudgetReportBean;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

@SuppressWarnings("serial")
public class ProductionVsBudgetReportServlet extends HttpServlet
{

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		 doPost( request, response );
	}
    public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		 ProductionVsBudgetReportBean bean=null;	
		 String exportPDFPath   ="";		 
		 String exportImagePath ="";
		 String preyearMonth    ="";
		 String rptTitle        ="";
		 String userID          ="";
		System.out.println(" ENTER - ProductionVsBudgetReportServlet  ***********************");
		try
		{
			  bean               = new ProductionVsBudgetReportBean();			 
			  HttpSession session= request.getSession();
			  HashMap <String, List<String>> gridDataMap  =  (HashMap<String, List<String>>) session.getAttribute("gridDataMap");
			  HashMap <String, List<String>> cntryWiseChrtNameMap  =  (HashMap<String, List<String>>) session.getAttribute("cntryWiseChrtNameMap");
			  
			  HashMap <String,String>  cntryIdNDescrMap=(HashMap<String,String>) session.getAttribute("cntryIdNDescrMap");
			  
			  userID           =(String)request.getParameter("userID");
			  exportPDFPath    =(String)request.getParameter("exportPDFPath");		 
			  exportImagePath  =(String)request.getParameter("exportImagePath");	
			  preyearMonth     =(String)request.getParameter("preyearMonth");	
			  rptTitle         =(String)request.getParameter("rptTitle");
			  System.out.println("userID inside servlet====="+userID); 		     
			 //call EJB method for PDF creation*******************
			 String resultString=  bean.generatePDF(gridDataMap, exportPDFPath, exportImagePath, preyearMonth, rptTitle,userID,cntryWiseChrtNameMap,cntryIdNDescrMap);
			 response.setContentType("text/html");
			 System.out.println("resultString is ="+resultString);			 
			 if(resultString.equals("false"))
			 {
				 response.getWriter().write("false");
			 }
			 else
			 {
				 response.getWriter().write("true");
			 }
		}
		
		catch (Exception e)
		{
			System.out.println("Exception :ProductionVsBudgetReportServlet : ProductionVsBudgetReportServlet) :"+e.getMessage()); //$NON-NLS-1$
			try 
			{
				throw new ITMException(e);
			}
			catch (ITMException e1) 
			{
				e1.printStackTrace();
			}
		}
		finally
		{
			bean=null;
			userID="";
		}
	}
}