<?xml version='1.0' encoding='UTF-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:template match="/">

<html>
<head>
<meta http-equiv="content-type" content="text/html; charset=UTF-8" />
</head>

<script type="text/javascript" src="/ibase/webitm/js/RequirementWizard.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/MilestonePayGen.js"></script>

<script language="JavaScript" type="text/javascript">
<![CDATA[
   var maxId = 0;
    
    function resetOrderOfVisit(obj)
    {
	for(cnt=1;cnt <=maxId;cnt++)
	{
		var selBoxID ="Detail2."+cnt+"."+ "selectbox";
		var visitOrderID ="Detail2."+cnt+"."+ "order_of_visit";
		if ( document.getElementById(selBoxID) != null && document.getElementById(selBoxID).value=='true' )
		{
			document.getElementById(selBoxID).value = false;
			document.getElementById(selBoxID).checked = false;
			
			if(document.getElementById(visitOrderID) != null)
			{
			      document.getElementById(visitOrderID).value = "";
			}
		}
		
	}
	orderVisit = 0;
    } 
  
    
]]>

</script>
<body>


<style type="text/css">

.tableClass
{margin-left:10px;margin-top:10px}

.tableClass_rep
<!--{margin-left:0px;width:900px;}-->
{margin-left:0px;width:1500px;}


.header_td
{border:inset 0;background:#FFCCCC;font-family:verdana;font-size:9pt}

.reset
{border:inset 1;font-family:verdana;font-size:9pt; font-weight:bold}

.input_editable
{border:inset 2;color:#102132;background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

.input_num_editable
{border:inset 2;color:#102132;background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt}

.td_leftAlign
{background:#D7E5F9;text-align:left;font-family:verdana;font-size:9pt}

.td_rightAlign
{background:#D7E5F9;text-align:right;font-family:verdana;font-size:9pt}
.style1
{border:inset 0;background:#FFCCCC;font-family:verdana;font-size:9pt ;width	: 120px;
}

</style>

<form name = "Wizard_Travel" METHOD="post" ACTION="/ibase/ITMWizardHandlerServlet" onSubmit="javascript:return validatePlace('2');">
	<table id="travelTable" width="100PX" class="tableClass" border="0" cellspacing="1" cellpadding="1">
		<xsl:for-each select="//Detail2">
			<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
			<SCRIPT>
				<![CDATA[ 
				var detCnt ;  
				detCnt ="]]><xsl:value-of select="$dbID"/><![CDATA[";
					maxId= detCnt; 												
				]]>
			</SCRIPT>
		</xsl:for-each>
		<tr>
			<td width="1PX" class="header_td" nowrap="true" valign="bottom">
			<!-- <input  type="checkbox"  name="Detail2.selectAllbox" id="Detail2.selectAllbox" onClick="selectAllbox()"/> -->
			</td>		
			<td width="5PX" class="header_td" nowrap="true" valign="bottom">
				<strong>Purchase Order</strong>
			</td>
			<td width="5PX" class="header_td" nowrap="true" valign="bottom" style="width:40px">
				<strong>Line No</strong>
			</td>
			<td  width="5px" class="header_td" nowrap="true" valign="bottom">
				<strong>Type</strong>
			</td>
			<td width="5PX" class="header_td" nowrap="true" valign="bottom" style="width:120px">
				<strong>Release against</strong>
			</td>
			<td width="10PX" class="header_td" nowrap="true" valign="bottom">
				<strong>Amount Type</strong>
			</td>	
			<td width="10PX" class="header_td" nowrap="true" valign="bottom">
				<strong>Release Amount</strong>
			</td>
			<td width="10PX" class="header_td" nowrap="true" valign="bottom">
				<strong>Release After</strong>
			</td>
<td width="10PX" class="header_td" nowrap="true" valign="bottom">
				<strong>Voucher Created</strong>
			</td>
<td width="10PX" class="header_td" nowrap="true" valign="bottom">
				<strong>Task Code</strong>
			</td>
<td width="10PX" class="header_td" nowrap="true" valign="bottom">
				<strong>Due Method</strong>
			</td>
<td width="10PX" class="header_td" nowrap="true" valign="bottom">
				<strong>Adj Method</strong>
			</td>
<td width="10PX" class="header_td" nowrap="true" valign="bottom">
				<strong>Acct Code</strong>
			</td>
<td width="10PX" class="header_td" nowrap="true" valign="bottom">
				<strong>Cctr Code</strong>
			</td>
<td width="10PX" class="header_td" nowrap="true" valign="bottom">
				<strong>tax Class</strong>
			</td>
<td width="10PX" class="header_td" nowrap="true" valign="bottom">
				<strong>Tax Chap</strong>
			</td>
<!-- <td width="10PX" class="header_td" nowrap="true" valign="bottom">
				<strong>Tax Chap</strong>
			</td> -->
<td width="10PX" class="header_td" nowrap="true" valign="bottom">
				<strong>Tax Env</strong>
			</td>
<td width="10PX" class="header_td" nowrap="true" valign="bottom">
				<strong>Retention Perc</strong>
			</td>
<td width="10PX" class="header_td" nowrap="true" valign="bottom" style="width:50px">
				<strong>Site Code ADV</strong>
			</td>
<td width="10PX" class="header_td" nowrap="true" valign="bottom">
				<strong>Adjusted Percentage</strong>
			</td>
	<td width="10PX" class="header_td" nowrap="true" valign="bottom">
				<strong>Process Date</strong>
	</td>
			<!-- <td width="10PX" class="header_td" nowrap="true" valign="bottom">
				<strong>Mps Order</strong>
			</td> -->
				
		</tr>
		
		<xsl:for-each select="//Detail2">				
		<xsl:variable name="site_code"><xsl:value-of select="site_code"/></xsl:variable>
		<xsl:variable name="purc_order"><xsl:value-of select="purc_order"/></xsl:variable>
<xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
		<xsl:variable name="line_no"><xsl:value-of select="line_no"/></xsl:variable>   
		<xsl:variable name="rel_agnst"><xsl:value-of select="rel_agnst"/></xsl:variable>
		<xsl:variable name="amt_type"><xsl:value-of select="amt_type"/></xsl:variable>
		<xsl:variable name="rel_amt"><xsl:value-of select="rel_amt"/></xsl:variable>  
		<xsl:variable name="rel_after"><xsl:value-of select="rel_after"/></xsl:variable>	
		<xsl:variable name="vouch_created"><xsl:value-of select="vouch_created"/></xsl:variable> 
		<xsl:variable name="task_code"><xsl:value-of select="task_code"/></xsl:variable>  
<xsl:variable name="due_date"><xsl:value-of select="due_date"/></xsl:variable>   
<xsl:variable name="adj_method"><xsl:value-of select="adj_method"/></xsl:variable>   
<xsl:variable name="acct_code"><xsl:value-of select="acct_code"/></xsl:variable>   
<xsl:variable name="cctr_code"><xsl:value-of select="cctr_code"/></xsl:variable>   
<xsl:variable name="tax_class"><xsl:value-of select="tax_class"/></xsl:variable>   
<xsl:variable name="tax_env"><xsl:value-of select="tax_env"/></xsl:variable>   
<xsl:variable name="retention_perc"><xsl:value-of select="retention_perc"/></xsl:variable> 
<xsl:variable name="site_code__adv"><xsl:value-of select="site_code__adv"/></xsl:variable> 
<xsl:variable name="adj_perc"><xsl:value-of select="adj_perc"/></xsl:variable>    
<xsl:variable name="tax_chap"><xsl:value-of select="tax_chap"/></xsl:variable>  
<xsl:variable name="process_date"><xsl:value-of select="process_date"/></xsl:variable> 
  
		<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
		<xsl:variable name="chkbox"><xsl:value-of select="@selected"/></xsl:variable>

<!-- <xsl:value-of select="process_date"/> -->

	    <tr>
				
			<td class="td_leftAlign">
			        <xsl:choose>
				<xsl:when test="$chkbox ='Y'">
					<script>
						<![CDATA[ orderVisit = parseInt("]]> <xsl:value-of select="order_of_visit"/><![CDATA[");]]>
					</script>
					<input  type="checkbox"  name="Detail2.{normalize-space($dbID)}.selectbox" id="Detail2.{normalize-space($dbID)}.selectbox"  value="true" checked="Y" onClick="setCheckedPlace(this, '{normalize-space($dbID)}' )"/>
				</xsl:when>	
				<xsl:otherwise>
					<input  type="checkbox"  name="Detail2.{normalize-space($dbID)}.selectbox" id="Detail2.{normalize-space($dbID)}.selectbox" value="false" onClick="setCheckedPlace(this, '{normalize-space($dbID)}' )"/>
				</xsl:otherwise>
				</xsl:choose>
			</td>
			
			
			<td class="td_leftAlign" align="left">
				<input  type="hidden" name="Detail2.{normalize-space($dbID)}.purc_order" id="Detail2.{normalize-space($dbID)}.purc_order" value="{$purc_order}" size="06"  ISCHANGED="true" readonly="readonly" tabindex="10" onFocus="blur();"/>
			<xsl:value-of select="purc_order"/>
			</td>
			
			<td class="td_rightAlign"  align="right" >
				<!-- <input  type="text"   name="Detail2.{normalize-space($dbID)}.item_code" id="Detail2.{normalize-space($dbID)}.item_code" value="{$item_code}" size="10" ISCHANGED="true"  onblur="return upperCase(this.id)"  /> -->
				<input  type="hidden"   name="Detail2.{normalize-space($dbID)}.line_no" id="Detail2.{normalize-space($dbID)}.line_no" value="{$line_no}" size="5" ISCHANGED="true" readonly="readonly"   />
				<xsl:value-of select="line_no"/>
				
			</td>

			<td class="td_rightAlign"  align="right" >
				<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.type" id="Detail2.{normalize-space($dbID)}.type" value="{$type}" size="3" ISCHANGED="true" readonly="readonly" tabindex="10" onFocus="blur();"/>
			<xsl:value-of select="type"/>
			</td>
			<td class="td_leftAlign"  align="left" >
				<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.rel_agnst" id="Detail2.{normalize-space($dbID)}.rel_agnst" value="{$rel_agnst}" size="15" ISCHANGED="true" readonly="readonly" tabindex="10" onFocus="blur();"/>
				
				 <xsl:choose>
						<xsl:when test="rel_agnst ='05'">
							<font size="2pt" face="Verdana">Project milestone</font>
						</xsl:when>
						<xsl:when test="rel_agnst ='06'">
							<font size="2pt" face="Verdana">User-defined Milestone</font>
						</xsl:when>
				</xsl:choose> 
				
			</td>
			<td class="td_rightAlign"  align="left" >
				<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.amt_type" id="Detail2.{normalize-space($dbID)}.amt_type" value="{$amt_type}" size="10" ISCHANGED="true" readonly="readonly" tabindex="10" onFocus="blur();"/>
				<xsl:value-of select="amt_type"/>
			</td>
			<td class="td_rightAlign" align="left" >
			
			<input  type="hidden"   style="text-align:right" name="Detail2.{normalize-space($dbID)}.rel_amt" id="Detail2.{normalize-space($dbID)}.rel_amt" value="{$rel_amt}" size="10" ISCHANGED="true" readonly="readonly"/>
			<xsl:value-of select="rel_amt"/>
			</td>
			<td class="td_rightAlign" align="left">
				
				<input  type="hidden" style="text-align:right" name="Detail2.{normalize-space($dbID)}.rel_after" id="Detail2.{normalize-space($dbID)}.rel_after" value="{$rel_after}" size="10" ISCHANGED="true" readonly="readonly" onFocus="blur();" onkeydown="isNumberKey(event)"/>
			<xsl:value-of select="rel_after"/>
			</td>
			<td class="td_leftAlign" align="left">
				<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.vouch_created" id="Detail2.{normalize-space($dbID)}.vouch_created" value="{$vouch_created}" size="10" ISCHANGED="true"  readonly="readonly"/>
			
			
			 <xsl:choose>
						<xsl:when test="vouch_created ='N'">
							<font size="2pt" face="Verdana">No</font>
						</xsl:when>
						<xsl:when test="vouch_created ='Y'">
							<font size="2pt" face="Verdana">Yes</font>
						</xsl:when>
				</xsl:choose>
			
			</td> 
			<td class="td_leftAlign" align="left">
				<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.task_code" id="Detail2.{normalize-space($dbID)}.task_code" value="{$task_code}" size="10" ISCHANGED="true"  readonly="readonly" />
				<xsl:value-of select="task_code"/>
				</td>

<td class="td_leftAlign" align="left">
				<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.due_date" id="Detail2.{normalize-space($dbID)}.due_date" value="{$due_date}" size="10" ISCHANGED="true" readonly="readonly" />
				<xsl:value-of select="due_date"/>
				</td>

<td class="td_leftAlign" align="left">
				<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.adj_method" id="Detail2.{normalize-space($dbID)}.adj_method" value="{$adj_method}" size="10" ISCHANGED="true" readonly="readonly"/>
				<xsl:value-of select="adj_method"/>
				</td>

<td class="td_leftAlign" align="left">
				<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.acct_code" id="Detail2.{normalize-space($dbID)}.acct_code" value="{$acct_code}" size="10" ISCHANGED="true" readonly="readonly"/>
				<xsl:value-of select="acct_code"/>
				</td>

<td class="td_leftAlign" align="left">
				<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.cctr_code" id="Detail2.{normalize-space($dbID)}.cctr_code" value="{$cctr_code}" size="10" ISCHANGED="true" readonly="readonly"/>
				<xsl:value-of select="cctr_code"/>
				</td>

<td class="td_leftAlign" align="left">
				<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.tax_class" id="Detail2.{normalize-space($dbID)}.tax_class" value="{$tax_class}" size="10" ISCHANGED="true" readonly="readonly"/>
				<xsl:value-of select="tax_class"/>
				</td>

<td class="td_leftAlign" align="left">
				<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.tax_chap" id="Detail2.{normalize-space($dbID)}.tax_chap" value="{$tax_chap}" size="10" ISCHANGED="true" readonly="readonly"/>
				<xsl:value-of select="tax_chap"/>
				</td>

<td class="td_leftAlign" align="left">
				<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.tax_env" id="Detail2.{normalize-space($dbID)}.tax_env" value="{$tax_env}" size="10" ISCHANGED="true" readonly="readonly"/>
				<xsl:value-of select="tax_env"/>
				</td>

<td class="td_rightAlign" align="left">
				<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.retention_perc" id="Detail2.{normalize-space($dbID)}.retention_perc" value="{$retention_perc}" size="10" ISCHANGED="true" readonly="readonly"/>
				<xsl:value-of select="retention_perc"/>
				</td>

<td class="td_leftAlign" align="left">
				<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.site_code__adv" id="Detail2.{normalize-space($dbID)}.site_code__adv" value="{$site_code__adv}" size="10" ISCHANGED="true" readonly="readonly"/>
				<xsl:value-of select="site_code__adv"/>
				</td>

<td class="td_rightAlign" align="left">
				<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.adj_perc" id="Detail2.{normalize-space($dbID)}.adj_perc" value="{$adj_perc}" size="10" ISCHANGED="true" readonly="readonly"/>
				<xsl:value-of select="adj_perc"/>
				</td>
				
				
				<td class="td_leftAlign" align="left">
				<input  type="hidden"  name="Detail2.{normalize-space($dbID)}.process_date" id="Detail2.{normalize-space($dbID)}.process_date" value="{$process_date}" size="10" ISCHANGED="true" readonly="readonly"/>
				<xsl:value-of select="process_date"/>
				</td>
				
			
		   </tr> 
		    
                  </xsl:for-each>
	</table>
	<div id="repeatPlacesDiv" style="margin-left:10px"></div>
	<table>
		<tr>
		    <td>
			<input  type="hidden"  value="2" name="FORM_NO" ID="FORM_NO" />
			<input  type="hidden"  value="milestone_pay_gen" name="OBJ_NAME" />
			<input  type="hidden"  value="" name="action" id="action" />
			

			<input type="submit" style="cursor:hand" value="Previous" id="Previous" name="Previous" title='' onclick="javascript:setActionVal('previous')"/>
			<!-- <input type="submit" style="cursor:hand" value="Next" id="Next" name="Next" title='' onclick="return setActionValPrc('next')"/>
			<input type="button" style="cursor:hand" class="tableClass" value="Add" id="add" onclick="addRow('travelTable')" />
			<input type="button" style="cursor:hand" class="tableClass" value="Delete" id="delete"  onclick="deleteRowRecord('travelTable')" />  -->
<input type="submit" style="cursor:hand"  value="Finish" name = "ActNext" id = "ActNext" title=''  onclick="return finishAction('finish')"/>  
			
			
		    </td>
                </tr>
	</table>
	<table id="errorTravelTable" width="85%" class="tableClass" border="0" cellspacing="1" cellpadding="1">
	<xsl:for-each select="//error">
			<xsl:variable name="message"><xsl:value-of select="message"/></xsl:variable>
			<xsl:variable name="description"><xsl:value-of select="description"/></xsl:variable>
			<xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
			<xsl:variable name="dbID"><xsl:value-of select="@domId"/></xsl:variable>  
			<xsl:variable name="column_name"><xsl:value-of select="@column_name"/></xsl:variable> 
			<xsl:if test="position() = 1">
					<tr>	
						<td class="td_leftAlign" nowrap="true" valign="bottom">
							Message :
						</td>
						<td class="td_leftAlign" nowrap="true" valign="bottom">
							Description :
						</td>
					</tr>
			</xsl:if>
			<tr>
				<td class="td_leftAlign" nowrap="true">
					<xsl:value-of select="message"/>
				</td>
				<td class="td_leftAlign" nowrap="true">
					<xsl:value-of select="description"/>
				</td>
			</tr>
	</xsl:for-each>
	<xsl:for-each select="//error">
			<xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
			<xsl:if test="position() = 1">
				<xsl:if test="$type = 'W'">
				<tr>
					<td class="td_leftAlign" nowrap="true" valign="bottom">
						Override Warnings :
					</td>
					<td class="td_leftAlign" nowrap="true" valign="bottom">
						<input  type="checkbox"  name="forceSave"  value="false" onClick="javascript:setChecked(this)"/>
					</td>
				</tr>
				</xsl:if>
			</xsl:if>	
	</xsl:for-each>
	</table>
						
</form>
</body>

</html>
</xsl:template>
</xsl:stylesheet>
