package ibase.webitm.util.gst;

import java.io.IOException;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;

import ibase.webitm.bean.gst.InterestLateFeeData;

public class InterestLateFeeDataSerailizer extends JsonSerializer<InterestLateFeeData>
{
	@Override
	public void serialize(InterestLateFeeData interstLateFeeData, JsonGenerator json, SerializerProvider serializerProvider) throws IOException, JsonProcessingException 
	{
		if(interstLateFeeData != null)
		{
			json.writeStartObject();
			
			json.writeFieldName("intr_details");
			json.writeStartObject();
			json.writeNumberField("iamt", interstLateFeeData.igstAmount);
			json.writeNumberField("camt", interstLateFeeData.cgstAmount);
			json.writeNumberField("samt", interstLateFeeData.sgstAmount);
			json.writeNumberField("csamt", interstLateFeeData.cessAmount);
			json.writeEndObject();
			
			json.writeEndObject();
		}
	}
}
