/*
 * Author: Wasim Ansari
 * Date: 02-MAY-2016
 * Request: F17BBAS001 (GST Wizard)
 */

package ibase.webitm.ejb.gst;

import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.util.gst.GSTCommonUtil;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;

import javax.ejb.Stateless;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;


@Stateless
public class GSTRecoWizEJB extends ValidatorEJB implements GSTRecoWizEJBLocal, GSTRecoWizEJBRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();

    public GSTRecoWizEJB() {
        // TODO Auto-generated constructor stub
    }
    
	@Override
	public String wfValData(String xmlString, String xmlString1, String xmlString2, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		String errString = "";
		Document dom = null;
		Document dom1 = null;
		Document dom2 = null;
		
		try
		{
			System.out.println("@@@ wfvalData \n xmlString : ["+ xmlString+ "] \n xmlString1 : ["+ xmlString1 +"] \n xmlString2 : ["+ xmlString2 +"] "
							+ "\n objContext["+objContext+"] \n editFlag["+editFlag+"] \n xtraParams["+xtraParams+"]");
			
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			
			errString = wfValData(dom,dom1,dom2,objContext,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			throw new ITMException(e);
		}
		
		return(errString);
	}
	
	
	@Override
	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams)throws RemoteException, ITMException 
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;	
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;
		String userId = "";
		String errCode = "";
		String errorType = "";
		String errString = "";
		int ctr=0;
		int childNodeListLength;
		int currentFormNo = 0;
		long cnt = 0;
		ArrayList<String> errList = new ArrayList<String>();
		ArrayList<String> errFields = new ArrayList<String>();
		Connection conn = null;
		PreparedStatement pstmt = null ;
		ResultSet rs = null;
		boolean flag = false;
		
		String sql = "",columnValue = "",prdCode = "",gstin = "";
		int count = 0;
		
		StringBuffer errStringXml = new StringBuffer("<?xml version = \"1.0\"?> \r\n <Root> <Errors>"); 
		try
		{
			conn = getConnection();
			
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			
			switch(currentFormNo)
			{
				case 1:
				{
					prdCode = checkNullAndTrim(genericUtility.getColumnValue("prd_code", dom));
					gstin = checkNullAndTrim(genericUtility.getColumnValue("gstin", dom));
					
					if(prdCode.length() == 0)
					{
						errString =  itmDBAccessEJB.getErrorString("","VTSIGNPCBL","","",conn);
						return errString;
					}
					else
					{	
						//sql = " SELECT COUNT(*) FROM PERIOD WHERE CODE = ? ";
						sql = " SELECT COUNT(*) AS CNT FROM PERIOD WHERE TO_CHAR(TO_DATE(code,'yyyymm'),'mmyyyy') = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, prdCode);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							count = rs.getInt(1);
						}
						if (rs != null) 
						{					
							rs.close();rs = null;
						}
						if (pstmt != null ) 
						{					
							pstmt.close();pstmt = null;
						}
						
						if(count == 0)
						{
							errString =  itmDBAccessEJB.getErrorString("","VMPRDNTDF","","",conn);
							return errString;
						}
					}
					
					if(gstin.length() == 0)
					{
						errString =  itmDBAccessEJB.getErrorString("","VTNLGSTIN","","",conn);
						return errString;
					}
					
					count = 0;
					//sql = " SELECT COUNT(*) FROM GST_DATA_HDR WHERE TAX_REG_NO = ? AND PRD_CODE = ? ";
					//sql = " SELECT COUNT(*) FROM GST_DATA_HDR WHERE TAX_REG_NO = ? AND PRD_CODE = ? AND SUBMISSION_TYPE = 'P' AND REC_TYPE = '2' AND RECO_STATUS ! = 'M' ";
					/*sql = " SELECT COUNT(*) FROM GST_DATA_HDR WHERE TAX_REG_NO = ? AND PRD_CODE = ? AND SUBMIT_STATUS = 'P' AND REC_TYPE = '2' "
						+ " AND (CASE WHEN RECO_STATUS IS NULL THEN 'A' ELSE RECO_STATUS END)  != 'M' ";*/
					
					String loginSiteCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" );
					
					sql = " SELECT COUNT(*) FROM GST_DATA_HDR WHERE SITE_CODE = ? AND PRD_CODE = ? AND REC_TYPE = '2' "
						+ " AND (CASE WHEN RECO_STATUS IS NULL THEN 'A' ELSE RECO_STATUS END)  != 'M' ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, loginSiteCode);
					pstmt.setString(2, prdCode);
					rs = pstmt.executeQuery();
					if (rs.next())
					{
						count = rs.getInt(1);
					}
					if (rs != null) 
					{					
						rs.close();rs = null;
					}
					if (pstmt != null ) 
					{					
						pstmt.close();pstmt = null;
					}
					
					if(count == 0)
					{
						errString =  itmDBAccessEJB.getErrorString("","VTNORECGST","","",conn);
						return errString;
					}
					
				}//End case1
				break;
			}
			
			int errListSize = errList.size();
			cnt = 0;
			String errFldName = null;
			if(errList != null && errListSize > 0)
			{
				for(cnt = 0; cnt < errListSize; cnt ++)
				{
					errCode = errList.get((int) cnt);
					errFldName = errFields.get((int) cnt);
					errString = getErrorString(errFldName, errCode, userId);
					errorType =  errorType(conn , errCode);
					if(errString.length() > 0)
					{
						String bifurErrString = errString.substring(errString.indexOf("<Errors>") + 8, errString.indexOf("<trace>"));
						bifurErrString = bifurErrString + errString.substring(errString.indexOf("</trace>") + 8, errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						errString = "";
					}
					if(errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				errStringXml.append("</Errors> </Root> \r\n");
			}
			
			else
			{
				errStringXml = new StringBuffer("");
			}
		}// End of try
		catch(Exception e)
		{
			System.out.println("Exception: wfValData GSTWizardEJB: ==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null) 
				{
					rs.close();rs = null;
				}
				if(pstmt != null) 
				{
					pstmt.close();pstmt = null;
				}
				if(conn != null) 
				{
					conn.close();conn = null;
				}
			} 
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		errString = errStringXml.toString();
		return errString;
	}
	
	/**
	 * select error description from MESSAGES
	 * @param conn
	 * @param errorCode
	 * @return
	 */
	private String errorType(Connection conn , String errorCode)
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String sql = "SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO = ?";
			pstmt = conn.prepareStatement(sql);			
			pstmt.setString(1,errorCode);			
			rs = pstmt.executeQuery();
			while(rs.next())
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch(Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}

	public  String getError(String message,String Code, Connection conn)  throws ITMException, Exception
	{
		String mainStr ="";

		try
		{
			String errString = "";
			errString =  new ITMDBAccessEJB().getErrorString("",Code,"","",conn);
			
			String begPart = errString.substring(0,errString.indexOf("</description>"));
			String endDesc = errString.substring(errString.indexOf("</description>"),errString.length());
		
			mainStr = begPart + message + endDesc;
			begPart = null;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return mainStr;
	}
	
	@Override
	public String itemChanged(String xmlString, String xmlString1, String xmlString2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		Document dom1 = null;
		Document dom = null;
		Document dom2 = null;
		String valueXmlString = "";
		
		try
		{
			System.out.println("@@@Item Change \n xmlString : ["+ xmlString+ "] \n xmlString1 : ["+ xmlString1 +"] \n xmlString2 : ["+ xmlString2 +"] "
					+ "\n objContext["+objContext+"] \n editFlag["+editFlag+"] \n xtraParams["+xtraParams+"]");
			
			if(xmlString != null && xmlString.trim().length()!=0)
			{
				dom = genericUtility.parseString(xmlString); 
			}
			if(xmlString1 != null && xmlString1.trim().length()!=0)
			{
				dom1 = genericUtility.parseString(xmlString1); 
			}
			if(xmlString2 != null && xmlString2.trim().length()!=0)
			{
				dom2 = genericUtility.parseString(xmlString2); 
			}
			
			valueXmlString = itemChanged(dom,dom1,dom2,objContext,currentColumn,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			valueXmlString = genericUtility.createErrorString(e);
		}
		
		return (valueXmlString);
	}
	
	
	
	@Override
	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException 
	{
		Connection conn = null;
		PreparedStatement pstmt = null,pstmtDet = null;
		ResultSet rs = null,rsDet = null;
		int currentFormNo = 0;
		StringBuffer valueXmlString = new StringBuffer();
		
		String currDate = "",userId = "",chgTerm = "",loginSiteCode = "",empCode = "";
		String prdCode = "",gstin = "",currDateStr = "";
		
		String sql = "";
		
		Calendar calendar = new GregorianCalendar(); 
		
		java.util.Map<String,ArrayList> suppMap = new java.util.HashMap<String,ArrayList>();
		ArrayList<String> invoiceIDList = new ArrayList<String>();
		java.util.Map<String,String> suppDetails = new java.util.HashMap<String,String>();
		
		String orderNo = "",tranID = "",suppCode = "",invoiceID = "",suppName = "",suppAddr = "",suppImgPath = "",submissionType = "";
		int id = 1,gstrDataCount = 0,gstrDataCountTemp = 0;
		int domIDDetail2 = 0;
		int domIDInvoice = 0;
		int domIDGstr = 0;
		Timestamp monthDate = null;
		try
		{
			conn = getConnection();
			//currDate = getCurrdateAppFormat();

			userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
			loginSiteCode = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginSiteCode" );
			empCode =  checkNullAndTrim(genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginEmpCode" ));
			
			if(objContext != null && objContext.trim().length() > 0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			
			valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?><Root><Header><editFlag>" );
			valueXmlString.append( editFlag ).append( "</editFlag></Header>" );
			
			System.out.println("currentColumn["+currentColumn+"] && currentFormNo["+currentFormNo+"]");
			
			switch ( currentFormNo )
			{
				case 1:
				{   
					valueXmlString.append("<Detail1 domID='1' selected = 'N'>\r");
					
					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ))
					{
						calendar.setTime(new Date());
						calendar.add(Calendar.MONTH, -1);
						SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
						currDateStr = sdf.format(calendar.getTime());
						
						monthDate = Timestamp.valueOf(genericUtility.getValidDateString(currDateStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
						
						System.out.println("Today's Date["+currDateStr+"] monthDate["+monthDate+"]");
						
						sql = "SELECT TO_CHAR(TO_DATE(CODE,'yyyymm'),'mmyyyy') AS CODE FROM PERIOD WHERE ? BETWEEN FR_DATE AND TO_DATE";
						pstmt = conn.prepareStatement(sql);
						pstmt.setTimestamp(1, monthDate);
						rs = pstmt.executeQuery();
						
						if(rs.next())
						{
							prdCode = rs.getString("CODE");
						}
						if(rs != null)
						{
							rs.close();rs = null;
						}
						if(pstmt != null)
						{
							pstmt.close();pstmt = null;
						}
						
						sql = " SELECT REG_NO FROM SITEREGNO WHERE SITE_CODE = ? AND REF_CODE = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, loginSiteCode);
						pstmt.setString(2, "GSTIN_NO");
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							gstin = checkNullAndTrim(rs.getString("REG_NO"));
						}
						if(rs!=null)
						{
							rs.close();rs=null;
						}
						if(pstmt!=null)
						{
							pstmt.close();pstmt=null;
						}
						
						System.out.println("GSTIN number in itm_default["+gstin+"]");
						
						valueXmlString.append("<prd_code>").append("<![CDATA["+prdCode+"]]>").append("</prd_code>");
						valueXmlString.append("<gstin>").append("<![CDATA["+gstin+"]]>").append("</gstin>");
					}
					else if( currentColumn.trim().equalsIgnoreCase( "prd_code" ))
					{
						sql = " SELECT REG_NO FROM SITEREGNO WHERE SITE_CODE = ? AND REF_CODE = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, loginSiteCode);
						pstmt.setString(2, "GSTIN_NO");
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							gstin = checkNullAndTrim(rs.getString("REG_NO"));
						}
						if(rs!=null)
						{
							rs.close();rs=null;
						}
						if(pstmt!=null)
						{
							pstmt.close();pstmt=null;
						}
						
						valueXmlString.append("<gstin>").append("<![CDATA["+gstin+"]]>").append("</gstin>");
					}
					
					valueXmlString.append("</Detail1>\r\n");
				}
				break;
				case 2 :
				{
					prdCode = genericUtility.getColumnValue("prd_code", dom1);
					gstin = genericUtility.getColumnValue("gstin", dom1);
							
					System.out.println("Period code ["+prdCode+"] gstin ["+gstin+"]");
					
					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ))
					{
						valueXmlString.append("<Detail2 domID='0'>");
						valueXmlString.append("<prd_code>").append("<![CDATA["+prdCode+"]]>").append("</prd_code>");
						valueXmlString.append("<gstin>").append("<![CDATA["+gstin+"]]>").append("</gstin>");
						valueXmlString.append("</Detail2>");
						 
						/* sql = " SELECT P.SUPP_CODE,I.INVOICE_ID FROM PORCP P, SUPPLIER S, INVOICE I, GST_DATA_HDR G WHERE "
							  +" P.SUPP_CODE = S.SUPP_CODE "
							  +" AND P.INVOICE_NO = I.INVOICE_ID "
							  +" AND G.ORDER_NO = P.INVOICE_NO"
							  +" AND G.TAX_REG_NO = ? AND G.PRD_CODE = ? AND G.REC_TYPE = '1' AND G.RECO_STATUS ! = 'M' ";*/
						 
						 /*sql = " SELECT P.SUPP_CODE,I.INVOICE_ID FROM PORCP P, SUPPLIER S, INVOICE I, GST_DATA_HDR G WHERE "
								  +" P.SUPP_CODE = S.SUPP_CODE "
								  +" AND P.INVOICE_NO = I.INVOICE_ID "
								  +" AND G.DOC_NO = P.INVOICE_NO"
								  +" AND G.TAX_REG_NO = ? AND G.PRD_CODE = ? AND G.SUBMISSION_TYPE = 'P' AND G.RECO_STATUS ! = 'M' ";*/
						
						//Last Change SQL
						/*sql = " SELECT CUST_CODE,DOC_NO FROM GST_DATA_HDR WHERE "
							+ " TAX_REG_NO = ? AND PRD_CODE = ? AND SUBMIT_STATUS = 'P' AND REC_TYPE = '2' AND "
							+ " (CASE WHEN RECO_STATUS IS NULL THEN 'A' ELSE RECO_STATUS END)  != 'M' ";*/
						
						sql = " SELECT DISTINCT TAX_REG_NO,DOC_NO FROM GST_DATA_HDR WHERE "
							+ " PRD_CODE = ? AND SITE_CODE = ? AND REC_TYPE = '2' AND "
							+ " (CASE WHEN RECO_STATUS IS NULL THEN 'A' ELSE RECO_STATUS END)  != 'M' ";
						
						pstmt = conn.prepareStatement(sql);
						//pstmt.setString(1, gstin);
						pstmt.setString(1, prdCode);
						pstmt.setString(2, loginSiteCode);
						rs = pstmt.executeQuery();
						while (rs.next())
						{
							//suppCode = checkNullAndTrim(rs.getString("CUST_CODE"));
							suppCode = checkNullAndTrim(rs.getString("TAX_REG_NO"));
							invoiceID = rs.getString("DOC_NO");
							
							if (suppMap.containsKey(suppCode))
							{
								invoiceIDList = (ArrayList) suppMap.get(suppCode);
								invoiceIDList.add(invoiceID);
								suppMap.put(suppCode, invoiceIDList);
							} 
			  				else
							{
			  					invoiceIDList = new ArrayList();
			  					invoiceIDList.add(invoiceID);
			  					suppMap.put(suppCode, invoiceIDList);
							}
						}
						if ( rs != null )
						{
							rs.close();rs = null;
						}
						if( pstmt != null )
						{
							pstmt.close();pstmt = null;
						}
						
						java.util.Iterator itr = suppMap.entrySet().iterator();
						while(itr.hasNext())
						{
							 Map.Entry pair = (Map.Entry)itr.next();
							 suppCode = (String) pair.getKey();
							 invoiceIDList = (ArrayList) pair.getValue();
							 
							 System.out.println("SuppCode["+suppCode+"]-->>Invoice ID List ["+invoiceIDList+"]");
							 
							 domIDDetail2++;
							 valueXmlString.append("<Detail2 domID='"+domIDDetail2+"' selected = 'N'>");//Start Multiple suppliers
							 
							 	//sql = " SELECT CUST_NAME,STATE_CODE FROM GST_DATA_HDR WHERE CUST_CODE = ? ";
							 	sql = " SELECT NAME AS CUST_NAME,STATE_CODE FROM GST_REGISTRATION WHERE GST_NO = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, suppCode);
								rs = pstmt.executeQuery();
								if (rs.next())
								{
									suppName = checkNullAndTrim(rs.getString("CUST_NAME"));
									suppAddr = checkNullAndTrim(rs.getString("STATE_CODE"));
								}
								if(rs!=null)
								{
									rs.close();rs=null;
								}
								if(pstmt!=null)
								{
									pstmt.close();pstmt=null;
								}
								
								try
								{
									GSTCommonUtil utility = new GSTCommonUtil();
									suppImgPath = utility.getImagePath("w_gstWiz", suppCode , suppName , "customer", conn);
								}
								catch(Exception e)
								{
									System.out.println("Excpetion while getting image for Customer"+e.getMessage());
								}
							 
							 	valueXmlString.append("<supp_code>").append("<![CDATA["+suppCode+"]]>").append("</supp_code>");
								valueXmlString.append("<supp_name>").append("<![CDATA["+suppName+"]]>").append("</supp_name>");
								valueXmlString.append("<supp_addr>").append("<![CDATA["+suppAddr+"]]>").append("</supp_addr>");
								valueXmlString.append("<supp_img_path>").append("<![CDATA["+suppImgPath+"]]>").append("</supp_img_path>");
							 
									 valueXmlString.append("<Invoices>");//Start Multiple invoice inside single supplier
									
									 String suppIDStr = "";
									 for(int i = 0; i< invoiceIDList.size(); i++)
									 {
										 //domIDInvoice = i + 1;
										 domIDInvoice++;
										 invoiceID = (String) invoiceIDList.get(i);
										 
										 suppIDStr = suppIDStr + domIDInvoice +",";
										 
										 	valueXmlString.append("<invoice domID='"+domIDInvoice+"'>");
										 	
										 	String orderDate = "",docDate = "";
										 	
										 	//sql = " SELECT ORDER_DATE, DOC_DATE, DOC_NO, AMOUNT, SITE_CODE, RECO_STATUS FROM GST_DATA_HDR WHERE DOC_NO = ? AND SUBMIT_STATUS = 'P' ";
										 	sql = " SELECT ORDER_DATE, DOC_DATE, DOC_NO, AMOUNT, SITE_CODE, RECO_STATUS FROM GST_DATA_HDR WHERE DOC_NO = ? AND REC_TYPE = '2' AND SUBMIT_STATUS IN ('P','D') ";
											pstmt = conn.prepareStatement(sql);
											pstmt.setString(1, invoiceID);
											rs = pstmt.executeQuery();
											if (rs.next())
											{
												orderDate = rs.getString("ORDER_DATE");
												docDate = rs.getString("DOC_DATE");
												
												valueXmlString.append("<invoice_id>").append("<![CDATA["+invoiceID+"]]>").append("</invoice_id>");
												valueXmlString.append("<doc_no>").append("<![CDATA["+rs.getString("DOC_NO")+"]]>").append("</doc_no>");
												valueXmlString.append("<inv_amt>").append("<![CDATA["+rs.getString("AMOUNT")+"]]>").append("</inv_amt>");
												valueXmlString.append("<site_code>").append("<![CDATA["+rs.getString("SITE_CODE")+"]]>").append("</site_code>");
												valueXmlString.append("<reco_status>").append("<![CDATA["+rs.getString("RECO_STATUS")+"]]>").append("</reco_status>");
												
												if(orderDate == null)
												{
													valueXmlString.append("<order_date>").append("<![CDATA[]]>").append("</order_date>");
												}
												else
												{
													valueXmlString.append("<order_date>").append("<![CDATA["+genericUtility.getValidDateString(orderDate, genericUtility.getDBDateTimeFormat(), genericUtility.getApplDateFormat())+"]]>").append("</order_date>");
												}
												if(docDate == null)
												{
													valueXmlString.append("<doc_date>").append("<![CDATA[]]>").append("</doc_date>");
												}
												else
												{
													valueXmlString.append("<doc_date>").append("<![CDATA["+genericUtility.getValidDateString(docDate, genericUtility.getDBDateTimeFormat(), genericUtility.getApplDateFormat())+"]]>").append("</doc_date>");
												}
											}
											if(rs!=null)
											{
												rs.close();rs=null;
											}
											if(pstmt!=null)
											{
												pstmt.close();pstmt=null;
											}
											
											ArrayList domIDList = new ArrayList();
											ArrayList domIDList2 = new ArrayList();
											int listSize = 0;
											int domIDTemp = 0;
											
											for(int j = 1 ;j<=2 ; j++)
											{
												gstrDataCount = 0;
												//domIDGstr = 0;
												
												if(j==1)
												{
													submissionType = "P";
												}
												if(j==2)
												{
													submissionType = "D";
												}
												
											    /*sql = " SELECT D.TRAN_ID,D.LINE_NO,D.STATUS,D.GS_CODE,D.TAXABLE_AMT,D.IGST_PERC,D.IGST_AMT,D.CGST_PERC,D.CGST_AMT, "
											    	+ " D.SGST_PERC,D.SGST_AMT,D.GS_DESCR,D.UNIT,D.QUANTITY,D.SUPPLY_TYPE,D.CESS_PERC,D.CESS_AMT,D.REMARKS "
											    	+ " FROM GST_DATA_HDR H, GST_DATA_DET D WHERE H.TRAN_ID = D.TRAN_ID "
											    	+ " AND H.ORDER_NO = ? AND H.REC_TYPE = ? ORDER BY D.GS_CODE ";*/
												
												sql = " SELECT D.TRAN_ID,D.LINE_NO,D.STATUS,D.GS_CODE,D.TAXABLE_AMT,D.IGST_PERC,D.IGST_AMT,D.CGST_PERC,D.CGST_AMT, "
												    	+ " D.SGST_PERC,D.SGST_AMT,D.GS_DESCR,D.UNIT,D.QUANTITY,D.SUPPLY_TYPE,D.CESS_PERC,D.CESS_AMT,D.REMARKS "
												    	+ " ,H.TAX_REG_NO,H.DOC_NO, H.DOC_DATE "
												    	+ " ,H.GST_CODE,D.ITC_TYPE,D.ITC_IGST,D.ITC_CGST,D.ITC_SGST,D.ITC_CESS "
												    	+ " FROM GST_DATA_HDR H, GST_DATA_DET D WHERE H.TRAN_ID = D.TRAN_ID "
												    	+ " AND H.DOC_NO = ? AND H.SUBMIT_STATUS = ? AND H.REC_TYPE = ? "
												    	+ " AND TAX_REG_NO = ? ORDER BY D.GS_CODE ";
												pstmtDet = conn.prepareStatement(sql);
												pstmtDet.setString(1, invoiceID);
												pstmtDet.setString(2, submissionType);
												pstmtDet.setString(3, "2");
												//pstmtDet.setString(4, gstin);
												pstmtDet.setString(4, suppCode);
												rsDet = pstmtDet.executeQuery();
												while (rsDet.next())
												{
													//gstrDataCount++;
													//domIDGstr++;
													
													System.out.println("J["+j+"]  domIDGstr["+domIDGstr+"]  ["+domIDList.size()+"]  gstrDataCount["+gstrDataCount+"]");
													
													if(j==1)
													{
														domIDGstr++;
														valueXmlString.append("<gstr"+j+" domID='"+domIDGstr+"'>");
														gstrDataCount++;
													}
													else
													{
														listSize = domIDList.size();
														System.out.println("@@listSize["+listSize+"] gstrDataCount["+gstrDataCount+"]");
														if(listSize <= gstrDataCount)
														{
															domIDGstr++;
															valueXmlString.append("<gstr"+j+" domID='"+domIDGstr+"'>");
															domIDList2.add(domIDGstr);
														}
														else
														{
															//domIDGstr = (Integer) domIDList.get(gstrDataCount);.
															//valueXmlString.append("<gstr"+j+" domID='"+domIDGstr+"'>");
															domIDTemp = (Integer) domIDList.get(gstrDataCount);
															valueXmlString.append("<gstr"+j+" domID='"+domIDTemp+"'>");
														}
														//domIDGstr = (Integer) domIDList.get(gstrDataCount);
														//valueXmlString.append("<gstr"+j+" domID='"+domIDGstr+"'>");
														gstrDataCount++;
													}
													
													//valueXmlString.append("<gstr"+j+" domID='"+domIDGstr+"'>");
													/*valueXmlString.append("<gstr"+j+" domID='"+domIDInvoice+"'>");*/
														valueXmlString.append("<tran_id>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("TRAN_ID"))+"]]>").append("</tran_id>");
														valueXmlString.append("<line_no>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("LINE_NO"))+"]]>").append("</line_no>");
														valueXmlString.append("<status>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("STATUS"))+"]]>").append("</status>");
														valueXmlString.append("<gs_code>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("GS_CODE"))+"]]>").append("</gs_code>");
														valueXmlString.append("<taxable_amt>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("TAXABLE_AMT"))+"]]>").append("</taxable_amt>");
														valueXmlString.append("<igst_perc>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("IGST_PERC"))+"]]>").append("</igst_perc>");
														valueXmlString.append("<igst_amt>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("IGST_AMT"))+"]]>").append("</igst_amt>");
														valueXmlString.append("<cgst_perc>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("CGST_PERC"))+"]]>").append("</cgst_perc>");
														valueXmlString.append("<cgst_amt>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("CGST_AMT"))+"]]>").append("</cgst_amt>");
														valueXmlString.append("<sgst_perc>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("SGST_PERC"))+"]]>").append("</sgst_perc>");
														valueXmlString.append("<sgst_amt>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("SGST_AMT"))+"]]>").append("</sgst_amt>");
														valueXmlString.append("<gs_descr>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("GS_DESCR"))+"]]>").append("</gs_descr>");
														valueXmlString.append("<unit>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("UNIT"))+"]]>").append("</unit>");
														valueXmlString.append("<quantity>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("QUANTITY"))+"]]>").append("</quantity>");
														valueXmlString.append("<supply_type>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("SUPPLY_TYPE"))+"]]>").append("</supply_type>");
														valueXmlString.append("<cess_perc>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("CESS_PERC"))+"]]>").append("</cess_perc>");
														valueXmlString.append("<cess_amt>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("CESS_AMT"))+"]]>").append("</cess_amt>");
														valueXmlString.append("<remarks>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("REMARKS"))+"]]>").append("</remarks>");
														
														docDate = rsDet.getString("DOC_DATE");
														if(docDate == null)
														{
															valueXmlString.append("<doc_date>").append("<![CDATA[]]>").append("</doc_date>");
														}
														else
														{
															valueXmlString.append("<doc_date>").append("<![CDATA["+genericUtility.getValidDateString(docDate, genericUtility.getDBDateTimeFormat(), genericUtility.getApplDateFormat())+"]]>").append("</doc_date>");
														}
														valueXmlString.append("<doc_no>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("DOC_NO"))+"]]>").append("</doc_no>");
														valueXmlString.append("<tax_reg_no>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("TAX_REG_NO"))+"]]>").append("</tax_reg_no>");
														valueXmlString.append("<rate>").append("<![CDATA[]]>").append("</rate>");
														
														valueXmlString.append("<gst_code>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("GST_CODE"))+"]]>").append("</gst_code>");
														valueXmlString.append("<itc_type>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("ITC_TYPE"))+"]]>").append("</itc_type>");
														valueXmlString.append("<itc_igst>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("ITC_IGST"))+"]]>").append("</itc_igst>");
														valueXmlString.append("<itc_cgst>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("ITC_CGST"))+"]]>").append("</itc_cgst>");
														valueXmlString.append("<itc_sgst>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("ITC_SGST"))+"]]>").append("</itc_sgst>");
														valueXmlString.append("<itc_cess>").append("<![CDATA["+checkNullAndTrim(rsDet.getString("ITC_CESS"))+"]]>").append("</itc_cess>");
														
													valueXmlString.append("</gstr"+j+">");
													
													if(j==1)
													{
														domIDList.add(domIDGstr);
													}
													
												}
												if ( rsDet != null )
												{
													rsDet.close();rsDet = null;
												}
												if( pstmtDet != null )
												{
													pstmtDet.close();pstmtDet = null;
												}
												
												System.out.println("J-->["+j+"] and gstrDataCount--["+gstrDataCount+"]");
												
												if(j == 2)
												{
													System.out.println("GSTR1 Count["+gstrDataCountTemp+"] GSTR2 Count["+gstrDataCount+"]");
													
													if(gstrDataCountTemp < gstrDataCount)
													{
														gstrDataCount = gstrDataCount - gstrDataCountTemp;
														
														System.out.println("@@domIDList2--["+domIDList2+"]");
														
														for(int x = 0 ;x<gstrDataCount ; x++)
														{
															valueXmlString.append("<gstr1 domID='"+domIDList2.get(x)+"'>");
																System.out.println("For making blank row as GSTR1 data not found for this row");
															valueXmlString.append("</gstr1>");
														}
													}
													else
													{	
														int tempCnt = gstrDataCount;
														gstrDataCount = gstrDataCountTemp - gstrDataCount;
														
														System.out.println("@@domIDList--["+domIDList+"] domIDTemp["+domIDTemp+"]");
														
														for(int x = 0 ;x<gstrDataCount ; x++)
														{
															/*valueXmlString.append("<gstr"+j+" domID='"+domIDList.get(domIDTemp+x)+"'>");*/
															valueXmlString.append("<gstr"+j+" domID='"+domIDList.get(tempCnt+x)+"'>");
																System.out.println("For making blank row as GSTR2 data not found for this row");
															valueXmlString.append("</gstr"+j+">");
														}
													}	
												}
												gstrDataCountTemp = gstrDataCount;
											}
											
											String dbIDStr = "";
											
											if(domIDList2.size() > 0)
											{
												domIDList.addAll(domIDList2);
											}
											
											for(int x =0; x< domIDList.size(); x++)
											{
												dbIDStr = dbIDStr + domIDList.get(x) +",";
											}
											
											valueXmlString.append("<domIDList>").append("<![CDATA["+dbIDStr+"]]>").append("</domIDList>");
											valueXmlString.append("</invoice>");
											
											System.out.println("Last DOMID="+domIDGstr);
									 }
									 
									 valueXmlString.append("</Invoices>"); //End Multiple invoice inside single supplier
									 
								valueXmlString.append("<suppIDList>").append("<![CDATA["+suppIDStr+"]]>").append("</suppIDList>");
							 valueXmlString.append("</Detail2>");//End Multiple suppliers	 
						 }		 
					}
				}
				break;
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception: itemChange GSTWizardEJB: ==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs != null)
				{
					rs.close();rs = null;
				}	
				if(pstmt != null)
				{	
					pstmt.close();pstmt = null;
				}
				if(conn != null)
				{	
					conn.close();conn = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
				throw new ITMException(d);
			}			
		}

		valueXmlString.append("</Root>");
		return valueXmlString.toString();
	}
	
	/**
	 * @param input String
	 * @return
	 */
	private static String checkNullAndTrim(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input.trim();
	}
	
	/**
	 * get current date in Timestap formate
	 */
	private java.sql.Timestamp getCurrtDate() throws RemoteException,ITMException 
	{
		String currAppdate = "";
		java.sql.Timestamp currDate = null;
		try 
		{
			Object date = null;
			currDate = new java.sql.Timestamp(System.currentTimeMillis());
			java.text.SimpleDateFormat sdf = new java.text.SimpleDateFormat(genericUtility.getDBDateFormat());
			date = sdf.parse(currDate.toString());
			currDate = java.sql.Timestamp.valueOf(sdf.format(date).toString()+ " 00:00:00.0");

		} 
		catch (Exception e) 
		{
			throw new ITMException(e);
		}
		return (currDate);
	}
	
	/**
	 * get current date in Application Time format
	 */
	private String getCurrdateAppFormat() 
	{
		String s = "";
		E12GenericUtility genericUtility = new E12GenericUtility();
		try
		{
			java.util.Date date = null;
			Timestamp timestamp = new Timestamp(System.currentTimeMillis());

			SimpleDateFormat simpledateformat = new SimpleDateFormat(genericUtility.getDBDateFormat());
			date = simpledateformat.parse(timestamp.toString());
			timestamp = Timestamp.valueOf(simpledateformat.format(date).toString() + " 00:00:00.0");
			s = new SimpleDateFormat(genericUtility.getApplDateFormat()).format(timestamp).toString();
		}
		catch (Exception localException)
		{
		}

		return s;
	}
	
}
