/**
* PURPOSE : Validation and Item Change implementation for packing component.
* AUTHOR : BALU
*/
package ibase.webitm.ejb.wms;

import java.io.*;
import java.rmi.RemoteException;
import java.sql.*;
import java.text.*;
import java.util.*;
import java.util.Date;

import javax.ejb.*;
import javax.naming.InitialContext;
import javax.xml.parsers.*;
import org.w3c.dom.*;

import ibase.ejb.*;
import ibase.system.config.*;
import ibase.utility.BaseLogger;
import ibase.webitm.ejb.*;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;

import javax.xml.transform.*;
import javax.xml.transform.dom.*;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.stream.StreamSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerConfigurationException;
import org.xml.sax.InputSource;
import java.net.InetAddress;

@javax.ejb.Stateless
public class PackingIC extends ValidatorEJB implements PackingICRemote, PackingICLocal  
{
	/**
	* The method is defined without any parameter and returns blank string
	*/
	public String wfValData() throws RemoteException,ITMException
	{
		return "";
	}
	
	/**
	* The public method is used for converting the current form data into a document(DOM)
	* The currDom is then given as argument to the overloaded function wfValData to perform validation
	* Returns validation string if exists else returns null in XML format
	* @param currFrmXmlStr contains the current form data in XML format
	* @param hdrFrmXmlStr contains all the header information in the XML format
	* @param allFrmXmlStr contains the data of all the forms in XML format
	* @param objContext represents the form number
	* @param editFlag represents the mode of transaction(A-Add or E-Edit)
	* @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	*/
	public String wfValData(String currFrmXmlStr, String hdrFrmXmlStr,String allFrmXmlStr, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		Document currDom = null;
		Document hdrDom = null;
		Document allDom = null;
		String errString = "";
		
		try
		{
			System.out.println("currFrmXmlStr :: "+ currFrmXmlStr);
			System.out.println("hdrFrmXmlStr :: "+ hdrFrmXmlStr);
			System.out.println("allFrmXmlStr :: "+ allFrmXmlStr);
			if(currFrmXmlStr != null && currFrmXmlStr.trim().length()!=0)
			{
				currDom = parseString(currFrmXmlStr); 
			}
			if(hdrFrmXmlStr != null && hdrFrmXmlStr.trim().length()!=0)
			{
				hdrDom = parseString(hdrFrmXmlStr); 
			}
			if(allFrmXmlStr != null && allFrmXmlStr.trim().length()!=0)
			{
				allDom = parseString(allFrmXmlStr);
			}
			System.out.println("Before call valdata");
			errString = wfValData(currDom,hdrDom,allDom,objContext,editFlag,xtraParams);
		}
		catch(Exception e)
		{
			System.out.println("Exception : [PackingIC][wfValData(String xmlCurrFrmString)] : ==>\n"+e.getMessage());
		}
		return (errString); 
	}

	/**
	 * The public overloaded method takes a document as input and is used for the validation of specified fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currDom contains the current form data as a document object model
	 * @param hdrDom contains all the header information
	 * @param allDom contains the field data of all the forms 
	 * @param objContext represents form number
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	 */	
	 public String wfValData(Document currDom, Document hdrDom, Document allDom, String objContext, String editFlag, String xtraParams) throws RemoteException, ITMException 	
	 {
		String errString = "";
		String siteCode = "";
						
		ResultSet rs = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
		
        E12GenericUtility genericUtility = new E12GenericUtility();

		StringBuffer errStringXml = new StringBuffer("<?xml version=\"1.0\"?>\r\n<Root><Errors>");
		String errorType = "", errCode = "";
		ArrayList errList = new ArrayList();
		ArrayList errFields = new ArrayList();
		//changed by sankara on 07/jun/14 for period stat
		java.util.Date tranDateDt = null;
		String prdCode = "";
		try
		{
			String columnValue = "";
			String sql = "";	
			String tranID = "";
			String tranDate = "";
			
			int currentFormNo = 0, cnt = 0;		
			
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//ConnDriver connDriver = null;
			//connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			
			NodeList parentList = null;
			NodeList childList = null;
			
			int noOfChilds = 0;
			//int noOfParents = 0;
			String childNodeName = "";
			
			Node childNode =null;
			//changed by sankara on 07/jun/14 for period stat
			SimpleDateFormat sdf1 = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			if ( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
			
			switch(currentFormNo)
			{
				case 1 :
				{
					parentList = currDom.getElementsByTagName( "Detail" + currentFormNo );
					childList = parentList.item( 0 ).getChildNodes();
					noOfChilds = childList.getLength();
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{	
						childNode = childList.item( ctr );
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();						
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");

						if ( "tran_id".equalsIgnoreCase( childNodeName ) )
						{							
							tranID = genericUtility.getColumnValue("tran_id", currDom );
							
							if( tranID == null || tranID.trim().length() == 0 )
							{
								// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
								//errString = getErrorString("tran_id","NULLTASKID",userId);
								//break;
								errList.add( "NULLTASKID" );
								errFields.add( childNodeName.toLowerCase() );
								// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
							}
							
							sql = "SELECT COUNT(*) AS COUNT FROM PACK_HDR WHERE TRAN_ID = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, tranID);
						 
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt("COUNT");
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							if(cnt == 0)
							{
								// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
								//errString = getErrorString( "tran_id" , "INVTASKID" , userId );
								//break;
								errList.add( "INVTASKID" );
								errFields.add( childNodeName.toLowerCase() );
								// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
							}
							//Changed by sunmit on 28/09/12 adding validation in case of wave canceled start.
							else
							{
								sql = " SELECT WAVE_TASK.CANCEL FROM WAVE_TASK, PACK_HDR " +
										" WHERE  PACK_HDR.WAVE_ID = WAVE_TASK.WAVE_ID " +
										" AND PACK_HDR.TRAN_ID =  ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, tranID);
								rs = pstmt.executeQuery();
								if( rs.next())
								{
									if( "Y".equalsIgnoreCase(rs.getString("CANCEL")))
									{
										errList.add( "PACKCANCEL" );
										errFields.add( childNodeName.toLowerCase() );
									}
								}
							}
							//Changed by sunmit on 28/09/12 adding validation in case of wave canceled end.
						}
					}// for loop end
				}//case 1 end
				break;
				case 2 : //for hdr win val....
				{
					parentList = currDom.getElementsByTagName( "Detail" + currentFormNo );
					childList = parentList.item( 0 ).getChildNodes();
					noOfChilds = childList.getLength();
					for (int ctr = 0; ctr < noOfChilds; ctr++)
					{	
						childNode = childList.item( ctr );
						if( childNode.getNodeType() != Node.ELEMENT_NODE )
						{
							continue;
						}
						childNodeName = childNode.getNodeName();						
						if ( childNode != null && childNode.getFirstChild() != null )
						{
							columnValue = childNode.getFirstChild().getNodeValue();
						}
						System.out.println(" columnName [" + childNodeName + "] columnValue [" + columnValue + "]");
												
						if ( "tran_date".equalsIgnoreCase( childNodeName ) )
						{							
							tranDate = genericUtility.getColumnValue("tran_date", currDom );
							
							if( tranDate == null || tranDate.trim().length() == 0 )
							{
								// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
								//errString = getErrorString("tran_date","NULLTRANDT",userId);
								//break;
								errList.add( "NULLTRANDT" );
								errFields.add( childNodeName.toLowerCase() );
								// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
							}
						}
						else if ( "site_code".equalsIgnoreCase( childNodeName ) )
						{							
							siteCode = genericUtility.getColumnValue("site_code", currDom );
							
							if( siteCode == null || siteCode.trim().length() == 0 )
							{
								// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
								//errString = getErrorString("site_code","NULLSITECD",userId);
								//break;
								errList.add( "NULLSITECD" );
								errFields.add( childNodeName.toLowerCase() );
								// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
							}
							
							sql = "SELECT COUNT(*) AS COUNT FROM SITE WHERE SITE_CODE = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, siteCode);
						 
							rs = pstmt.executeQuery();
							if (rs.next())
							{
								cnt = rs.getInt("COUNT");
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;

							if(cnt == 0)
							{
								// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
								//errString = getErrorString( "site_code" , "INVSITECD" , userId );
								//break;
								errList.add( "INVSITECD" );
								errFields.add( childNodeName.toLowerCase() );
								// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
							}
							//Changed by Pragyan.start
							else 
							{
															
								System.out.println("364 site code ="+siteCode);
								if (genericUtility.getColumnValue("tran_date", currDom) != null)
								{
									int count = 0;
									tranDateDt = sdf1.parse(genericUtility.getColumnValue("tran_date", currDom));
									sql = "select code from period where ?  between fr_date and to_date";
									pstmt = conn.prepareStatement(sql);
									pstmt.setDate(1, new java.sql.Date(tranDateDt.getTime()));
									rs = pstmt.executeQuery();
									if (rs.next())
									{
										prdCode = rs.getString(1);

									}
									rs.close();
									rs = null;
									pstmt.close();
									pstmt = null;

									sql = "select count(*) from period_stat where site_code = ? and prd_code = ? ";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, siteCode);
									pstmt.setString(2, prdCode);
									rs = pstmt.executeQuery();
									if (rs.next())
									{
										count = rs.getInt(1);

									}
									rs.close();
									rs = null;
									pstmt.close();
									pstmt = null;
									if (count == 0)
									{
										errList.add( "VTSITEPD" );
										errFields.add( childNodeName.toLowerCase() );
										break;
										
									}
									// nvo_functions_adv.nf_check_period('SAL',mdate1,msite_code)
									errCode = nfCheckPeriod("IC", tranDateDt, siteCode);
									System.out.println("425 Error Code = " + errCode);
									if (errCode != null && errCode.trim().length() > 0)
									{
										errList.add( errCode );
										errFields.add( childNodeName.toLowerCase() );
										break;
									}
								} 							 
							}//end 
							//Changed by Pragyan.End
						}//OUTER_CARTON_NO
						else if ( "outer_carton_no".equalsIgnoreCase( childNodeName ) )
						{							
							String outerCartonNo = genericUtility.getColumnValue("outer_carton_no", currDom );
							
							if( outerCartonNo == null || outerCartonNo.trim().length() == 0 )
							{
								// 26/10/11 manoharan all the errors should be returned so that warnings can be processed
								//errString = getErrorString("site_code","NULLCARTNO",userId);
								//break;
								errList.add( "NULLCARTNO" );
								errFields.add( childNodeName.toLowerCase() );
								// end 26/10/11 manoharan all the errors should be returned so that warnings can be processed
							}
							/*
							String colValue = "";
							String quantity = "";
							int noOfDetail = parentList.getLength();
							System.out.println(" noOfDetail = [" + noOfDetail + "] ");
							for( int prnt = 0; prnt < noOfParent; prnt++ )  
							{
								NodeList detChildList = parentList.item(prnt).getChildNodes();
								noOfDetChilds = detChildList.getLength();
								
								for ( int ctr = 0; ctr < noOfDetChilds; ctr++ )  //Loop for each node of current detail
								{
									Node detChildNode = detChildList.item( ctr );
									if( detChildNode.getNodeType() != Node.ELEMENT_NODE )
									{
										continue;
									}
									String childNodeName = childNode.getNodeName();
									if ( detChildNode != null && detChildNode.getFirstChild() != null )
									{
										colValue = detChildNode.getFirstChild().getNodeValue();
									}
									if( "item_code".equalsIgnoreCase( childNodeName ) )
									{
										itemCode = colValue;
									}
									else if( "outer_carton_no".equalsIgnoreCase( childNodeName ) )
									{
										outerCartonNo = colValue;
									}
									else if( "quantity".equalsIgnoreCase( childNodeName ) )
									{
										quantity = colValue;
									}

									sql = "SELECT GROSS_WEIGHT, SHIPPER_SIZE FROM ITEM_LOT_PACKSIZE WHERE ITEM_CODE = ?";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, itemCode);
								 
									rs = pstmt.executeQuery();
									if (rs.next())
									{
										grossWt = rs.getDouble("GROSS_WEIGHT");
									}
									rs.close();
									rs = null;
									pstmt.close();
									pstmt = null;
								}//inner loop
							}//outer loop
							*/
						}//
						
					}// for loop end
				}//case 2 end
				break;
			} //switch end
			int errListSize = errList.size();
			cnt =0;
			String errFldName = null;
			if ( errList != null && errListSize > 0 )
			{
				for (cnt = 0; cnt < errListSize; cnt++ )
				{
					errCode = (String)errList.get(cnt);
					errFldName = (String)errFields.get(cnt);
					System.out.println("errCode .........."+errCode);
					//String errMsg = hashMap.get(errCode)!=null ? hashMap.get(errCode).toString():"";
					//System.out.println("errMsg .........."+errMsg);
					errString = getErrorString( errFldName, errCode, userId );
					errorType =  errorType( conn , errCode );
					if ( errString.length() > 0)
					{
						String bifurErrString = errString.substring( errString.indexOf("<Errors>") + 8,errString.indexOf("<trace>"));
						bifurErrString =bifurErrString;//+"<trace>"+errMsg+"</trace>";
						bifurErrString =bifurErrString+errString.substring( errString.indexOf("</trace>") + 8,errString.indexOf("</Errors>"));
						errStringXml.append(bifurErrString);
						System.out.println("errStringXml .........."+errStringXml);
						errString = "";
					}
					if ( errorType.equalsIgnoreCase("E"))
					{
						break;
					}
				}
				errList.clear();
				errList = null;
				errFields.clear();
				errFields = null;
				
				errStringXml.append("</Errors></Root>\r\n");
			}
			else
			{
				errStringXml = new StringBuffer( "" );
			}
			errString = errStringXml.toString();
		}//try block end
		catch(Exception e)
		{
			System.out.println("Exception in PackingIC  == >");
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( conn != null && ! conn.isClosed() )
				{
					conn.close();
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :PackingIC:wfValData :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		return errString;
	}
	private String errorType( Connection conn , String errorCode )
	{
		String msgType = "";
		PreparedStatement pstmt = null ; 
		ResultSet rs = null;
		try
		{			
			String  sql = " SELECT MSG_TYPE FROM MESSAGES WHERE MSG_NO =   ? ";
			
			pstmt = conn.prepareStatement( sql );			
			pstmt.setString(1, errorCode);			
			rs = pstmt.executeQuery();
			while( rs.next() )
			{
				msgType = rs.getString("MSG_TYPE");
			}			
		}
		catch (Exception ex)
		{
			ex.printStackTrace();
		}		
		finally
		{
			try
			{
				if ( rs != null )
				{
					rs.close();
					rs = null;
				}
				if ( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch ( Exception e )
			{
				e.printStackTrace();
			}
		}		
		return msgType;
	}

	 // Item Change Functionality. Start.		
	/**
	* The public method is defined without any parameters and returns blank string
	*/
	public String itemChanged() throws RemoteException, ITMException
	{
		return "";
	}
	
	/**
	* The public method is used for converting the current form data into a document(dom)
	* The currDom is then given as argument to the overloaded function wfValData to perform validation
	* Returns validation string if exists else returns null in XML format
	* @param currFrmXmlStr contains the current form data in XML format
	* @param hdrFrmXmlStr contains all the header information in the XML format
	* @param allFrmXmlStr contains the data of all the forms in XML format
	* @param objContext represents the form number
	* @param currentColumn represents the value of current field.
	* @param editFlag represents the mode of transaction(A-Add or E-Edit)
	* @param xtraParams contains additional information such as loginEmpCode,loginCode,chgTerm etc
	*/
	public String itemChanged(String currFrmXmlStr, String hdrFrmXmlStr, String allFrmXmlStr, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		Document currDom = null;
		Document hdrDom = null;
		Document allDom = null;
		
		String errString = null;
		
		E12GenericUtility genericUtility = new E12GenericUtility();
		
		try
		{
			System.out.println("currFrmXmlStr :: "+ currFrmXmlStr);
			System.out.println("hdrFrmXmlStr :: "+ hdrFrmXmlStr);
			System.out.println("allFrmXmlStr :: "+ allFrmXmlStr);
			if (currFrmXmlStr != null && currFrmXmlStr.trim().length()!=0)
			{
				currDom = genericUtility.parseString(currFrmXmlStr); 
			}
			if (hdrFrmXmlStr != null && hdrFrmXmlStr.trim().length()!=0)
			{
				hdrDom = genericUtility.parseString(hdrFrmXmlStr); 
			}
			if (allFrmXmlStr != null && allFrmXmlStr.trim().length()!=0)
			{
				allDom = genericUtility.parseString(allFrmXmlStr); 
			}
			errString = itemChanged( currDom, hdrDom, allDom, objContext, currentColumn, editFlag, xtraParams );
			System.out.println ( "ErrString :" + errString);
		}
		catch (Exception e)
		{
			System.out.println ( "Exception : Pack:defaul_ItemChanged(String,String):" + e.getMessage() + ":" );
			errString = genericUtility.createErrorString(e);
		}
		System.out.println ( "returning from Pack default_Itemchanged" );
		return errString;
	}	
	
	/**
	 * The public overloaded method takes a document as input and is used for the validation of required fields 
	 * Returns validation string if exist otherwise returns null in XML format
	 * @param currDom contains the current form data as a document object model
	 * @param hdrDom contains all the header information
	 * @param allDom contains the field data of all the forms 
	 * @param objContext represents form number
	 * @param currentColumn represents the current field 
	 * @param editFlag represents the mode of transaction(A-Add or E-Edit)
	 * @param xtraParams contains additional information
	 * 
	 */
	
	
	public String itemChanged( Document currDom, Document hdrDom, Document allDom, String objContext, String currentColumn, String editFlag, String xtraParams ) throws RemoteException,ITMException
	{
		String retValue = "";
		try
		{
			retValue = default_ItemChanged( currDom, hdrDom, allDom,  objContext, currentColumn, editFlag, xtraParams );
		} 
		catch (Exception e) 
		{
			e.printStackTrace();
		}
		return retValue;
		
	}
	public String default_ItemChanged( Document currDom, Document hdrDom, Document allDom, String objContext, String currentColumn, String editFlag, String xtraParams ) throws RemoteException,ITMException
	{
		String sql = "";
		String waveId = "";
		String siteCode = "";
		String siteDescr = "";
		String tranID = "";	
		String saleOrder ="";
		String empCodeAprv = "";		
		String tranDate = "";
		String confDate = "";
		String pickOrder = "";
			
		int currentFormNo = 0;
		int domID = 0;

		double quantity = 0d;
		
		ResultSet rs = null;
		Connection conn = null;
		PreparedStatement pstmt = null;
				
		StringBuffer valueXmlString = new StringBuffer();		
		
		E12GenericUtility genericUtility = new E12GenericUtility();
		
		try
		{
			String userId = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "loginCode" );
			String chgTerm = genericUtility.getValueFromXTRA_PARAMS( xtraParams, "chgTerm" );
			
			DateFormat dateFormat = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String dbDateFormat = genericUtility.getDBDateFormat();
			String applDateFormat = genericUtility.getApplDateFormat();

			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//ConnDriver connDriver = null;
			//connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//connDriver = null;
			//Changed and Commented By Santosh on 14-06-2016 :[END]
			
			if( objContext != null && objContext.trim().length() > 0 )
			{
				currentFormNo = Integer.parseInt( objContext );
			}
            valueXmlString = new StringBuffer( "<?xml version=\"1.0\"?>\r\n<Root>\r\n<Header>\r\n<editFlag>" );
            valueXmlString.append( editFlag ).append( "</editFlag>\r\n</Header>\r\n" );

			switch ( currentFormNo )
			{
			  	case 2:
				{
					if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )							
					{
						tranID = genericUtility.getColumnValue( "tran_id", hdrDom );
						
						java.util.Date currDate = new java.util.Date();
						SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
						String currDateStr = sdf.format(currDate);

						java.sql.Date tranDateDb = null;
						java.sql.Date confDateDb = null;
						
						sql = "SELECT PHDR.TRAN_ID, PHDR.TRAN_DATE, PHDR.SITE_CODE, PHDR.SALE_ORDER, PHDR.WAVE_ID, "+
							  "PHDR.CONFIRMED, SITE.DESCR SITE_DESCR " +
							  "FROM PACK_HDR PHDR , SITE SITE WHERE TRAN_ID = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, tranID);							
						rs = pstmt.executeQuery();
						
						if(rs.next())
						{
							valueXmlString.append( "<Detail2 domID='1'>\r\n" );
							valueXmlString.append( "<tran_id><![CDATA[" ).append( checkNull(rs.getString("TRAN_ID"))  ).append( "]]></tran_id>\r\n" );

							tranDateDb = rs.getDate("TRAN_DATE");
							if ( tranDateDb != null )
							{
								tranDate = genericUtility.getValidDateString( tranDateDb.toString() , dbDateFormat, applDateFormat );
								valueXmlString.append( "<tran_date><![CDATA[" ).append(  tranDate ).append( "]]></tran_date>\r\n" );
							}
							siteCode = rs.getString("site_code");
							saleOrder = rs.getString("sale_order");
							waveId = rs.getString("wave_id");
							siteDescr = rs.getString("site_descr");
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
					
						valueXmlString.append( "<sale_order><![CDATA[" ).append( checkNull(saleOrder) ).append( "]]></sale_order>\r\n" );
						valueXmlString.append( "<site_code><![CDATA[" ).append( checkNull(siteCode) ).append( "]]></site_code>\r\n" );
						valueXmlString.append( "<site_descr><![CDATA[" ).append( checkNull(siteDescr) ).append( "]]></site_descr>\r\n" );
						valueXmlString.append( "<wave_id><![CDATA[" ).append( checkNull(waveId) ).append( "]]></wave_id>\r\n" );
						valueXmlString.append( "<confirmed><![CDATA[" ).append("N" ).append( "]]></confirmed>\r\n" );
						valueXmlString.append( "<chg_user><![CDATA[" ).append( userId ).append( "]]></chg_user>\r\n" );
						valueXmlString.append( "<chg_date><![CDATA[" ).append( currDateStr ).append( "]]></chg_date>\r\n" );
						valueXmlString.append( "<chg_term><![CDATA[" ).append( chgTerm ).append( "]]></chg_term>\r\n" );
						valueXmlString.append( "</Detail2>" );
					}				
				}//case 2 end here
				break;
			  	case 3:
			  	{	
			  		if( currentColumn.trim().equalsIgnoreCase( "itm_default" ) )							
					{
			  			saleOrder = genericUtility.getColumnValue("sale_order", allDom, "2");
						waveId = genericUtility.getColumnValue("wave_id", allDom, "2");
						tranID = genericUtility.getColumnValue("tran_id", allDom, "2");

						sql = "SELECT PICK_ORDER FROM PICK_ORD_HDR WHERE SALE_ORDER = ? AND WAVE_ID = ?";
						pstmt =  conn.prepareStatement(sql);
						pstmt.setString(1, saleOrder);
						pstmt.setString(2 , waveId);
						rs = pstmt.executeQuery();
						if(rs.next())
						{								
							pickOrder = rs.getString("PICK_ORDER");								
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;

						sql = "SELECT PDET.LINE_NO, PDET.SALE_ORDER, PDET.LINE_NO__SORD, PDET.ITEM_CODE, PDET.SITE_CODE, "+
							"PDET.LOC_CODE, PDET.LOT_NO, PDET.LOT_SL, PDET.QUANTITY, PDET.OUTER_CARTON_NO, PDET.NO_ART, "+
							"ITEM.DESCR ITEM_DESCR, ITEM.UNIT UNIT "+
							"FROM PACK_DET PDET, ITEM ITEM WHERE TRAN_ID = ? AND PDET.ITEM_CODE = ITEM.ITEM_CODE ORDER BY PDET.LINE_NO";
						pstmt =  conn.prepareStatement(sql);
						pstmt.setString(1, tranID);
						rs = pstmt.executeQuery();

						int lineNoPack = 0;
						int lineNoSord = 0;
						String ordLineNos = "";

						while ( rs.next() )
						{
							lineNoPack = rs.getInt("LINE_NO");
							lineNoSord = rs.getInt("LINE_NO__SORD");

							ordLineNos = ordLineNos + "'" + lineNoSord + "',";

							domID++;

							valueXmlString.append( "<Detail3 domID='"+ domID +"' objContext = '"+currentFormNo+"' objName=\"pack_wiz\" selected=\"Y\">\r\n" );
							valueXmlString.append( "<attribute selected=\"Y\"/>\r\n" );
							valueXmlString.append( "<tran_id><![CDATA[" ).append( tranID ).append( "]]></tran_id>\r\n" );
							valueXmlString.append( "<line_no><![CDATA[" ).append( lineNoPack ).append( "]]></line_no>\r\n" );
							valueXmlString.append( "<sale_order><![CDATA[" ).append( checkNull(rs.getString("sale_order")) ).append( "]]></sale_order>\r\n" );
							valueXmlString.append( "<line_no__sord><![CDATA[" ).append( lineNoSord ).append( "]]></line_no__sord>\r\n" );
							valueXmlString.append( "<item_code><![CDATA[" ).append( checkNullAndTrim(rs.getString("item_code")) ).append( "]]></item_code>\r\n" );
							valueXmlString.append( "<item_descr><![CDATA[" ).append( checkNull(rs.getString("ITEM_DESCR")) ).append( "]]></item_descr>\r\n" );
							valueXmlString.append( "<site_code><![CDATA[" ).append( checkNull(rs.getString("site_code")) ).append( "]]></site_code>\r\n" );
							valueXmlString.append( "<loc_code><![CDATA[" ).append( checkNull(rs.getString("loc_code")) ).append( "]]></loc_code>\r\n" );
							valueXmlString.append( "<lot_no><![CDATA[" ).append( checkNullAndTrim(rs.getString("lot_no")) ).append( "]]></lot_no>\r\n" );
							valueXmlString.append( "<lot_sl><![CDATA[" ).append( checkNullAndTrim(rs.getString("lot_sl")) ).append( "]]></lot_sl>\r\n" );
							valueXmlString.append( "<quantity><![CDATA[" ).append( rs.getDouble("quantity") ).append( "]]></quantity>\r\n" );
							valueXmlString.append( "<unit><![CDATA[" ).append( checkNull(rs.getString("UNIT")) ).append( "]]></unit>\r\n" );
							valueXmlString.append( "<no_art><![CDATA[" ).append( rs.getDouble("no_art") ).append( "]]></no_art>\r\n" );
							valueXmlString.append( "<outer_carton_no><![CDATA[" ).append( checkNull(rs.getString("OUTER_CARTON_NO")) ).append( "]]></outer_carton_no>\r\n" );
							valueXmlString.append("</Detail3>\r\n");
						}

						rs.close(); rs = null;
						pstmt.close(); pstmt = null;

						if ( ordLineNos.trim().length() > 1 )
						{
							ordLineNos = ordLineNos.substring( 0, ordLineNos.length()-1 );
						}

						if( pickOrder != null && pickOrder.trim().length() > 0 )
						{
							if ( domID == 0 )
							{
								sql = "SELECT PICKDET.SALE_ORDER, PICKDET.LINE_NO__SORD, "+
									"PICKDET.SITE_CODE,PICKDET.ITEM_CODE, PICKDET.LOC_CODE, PICKDET.LOT_NO, PICKDET.LOT_SL, "+ 
									"PICKDET.NO_ART, PICKDET.QUANTITY, ITEM.DESCR ITEM_DESCR, ITEM.UNIT UNIT " +
									"FROM PICK_ORD_DET PICKDET, ITEM ITEM "+
									"WHERE PICKDET.PICK_ORDER = ? AND SALE_ORDER = ? AND ITEM.ITEM_CODE = PICKDET.ITEM_CODE";
								pstmt =  conn.prepareStatement(sql);
							}
							else
							{
								sql = "SELECT PICKDET.SALE_ORDER, PICKDET.LINE_NO__SORD, "+
									"PICKDET.SITE_CODE,PICKDET.ITEM_CODE, PICKDET.LOC_CODE, PICKDET.LOT_NO, PICKDET.LOT_SL, "+ 
									"PICKDET.NO_ART, PICKDET.QUANTITY, ITEM.DESCR ITEM_DESCR, ITEM.UNIT UNIT " +
									"FROM PICK_ORD_DET PICKDET, ITEM ITEM "+
									"WHERE PICKDET.PICK_ORDER = ? AND SALE_ORDER = ? AND LINE_NO__SORD NOT IN( "+ordLineNos+" ) "+
									"AND ITEM.ITEM_CODE = PICKDET.ITEM_CODE ";
								pstmt =  conn.prepareStatement(sql);
							}
							pstmt.setString(1, pickOrder);
							pstmt.setString(2, saleOrder);
							rs = pstmt.executeQuery();

							while(rs.next())
							{
								domID++;
								
								valueXmlString.append( "<Detail3 domID='"+ domID +"'>\r\n" );
								valueXmlString.append( "<tran_id><![CDATA[" ).append( tranID ).append( "]]></tran_id>\r\n" );
								valueXmlString.append( "<line_no/>" );
								valueXmlString.append( "<sale_order><![CDATA[" ).append( checkNull(rs.getString("sale_order")) ).append( "]]></sale_order>\r\n" );
								valueXmlString.append( "<line_no__sord><![CDATA[" ).append( checkNull(rs.getString("line_no__sord")) ).append( "]]></line_no__sord>\r\n" );
								valueXmlString.append( "<site_code><![CDATA[" ).append( checkNull(rs.getString("site_code")) ).append( "]]></site_code>\r\n" );
								valueXmlString.append( "<item_code><![CDATA[" ).append( checkNullAndTrim(rs.getString("item_code")) ).append( "]]></item_code>\r\n" );
								valueXmlString.append( "<item_descr><![CDATA[" ).append( checkNull(rs.getString("ITEM_DESCR")) ).append( "]]></item_descr>\r\n" );
								valueXmlString.append( "<unit><![CDATA[" ).append( checkNull(rs.getString("UNIT")) ).append( "]]></unit>\r\n" );
								valueXmlString.append( "<loc_code><![CDATA[" ).append( checkNull(rs.getString("loc_code")) ).append( "]]></loc_code>\r\n" );
								valueXmlString.append( "<lot_no><![CDATA[" ).append( checkNullAndTrim(rs.getString("lot_no")) ).append( "]]></lot_no>\r\n" );
								valueXmlString.append( "<lot_sl><![CDATA[" ).append( checkNullAndTrim(rs.getString("lot_sl")) ).append( "]]></lot_sl>\r\n" );
								valueXmlString.append( "<no_art><![CDATA[" ).append( rs.getDouble("no_art") ).append( "]]></no_art>\r\n" );
								valueXmlString.append( "<quantity><![CDATA[" ).append( rs.getDouble("quantity") ).append( "]]></quantity>\r\n" );
								valueXmlString.append( "<outer_carton_no/>" );
								valueXmlString.append( "</Detail3>" );
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
						}
					}						
			  	}// case 3
			}//switch statement ends here
		}//try block ends here
		catch(Exception e)
		{
			System.out.println( "Exception :Pack :itemChanged(Document,String):" + e.getMessage() + ":" );
			valueXmlString = valueXmlString.append( genericUtility.createErrorString( e ) );
		}
		finally
		{
			try
			{
				if (rs != null)
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if( conn != null && ! conn.isClosed() )
				{
					conn.close();
				}
			}
			catch(Exception e)
			{
				System.out.println( "Exception :Pack:itemChanged :==>\n"+e.getMessage());
				throw new ITMException(e);
			}
		}
		valueXmlString.append( "</Root>\r\n" );	
		System.out.println( "\n****ValueXmlString :" + valueXmlString.toString() + ":********" );
		return valueXmlString.toString();
	}
	
	/**
	 * The function checks whether the input string is null. 
	 * If null, the function returns blank string.  
	 * @param input
	 */
	private String checkNull( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		return inputVal;
	}
	/**
	 * The function checks whether the input string is null. 
	 * If null, the function returns blank string otherwise trim the input string and return.  
	 * @param input
	 */
	private String checkNullAndTrim( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		else
		{
			inputVal = inputVal.trim();
		}
		return inputVal;
	}
}
