/**
* PURPOSE : Pre Save Logic implementation for Check Sheet component.
* AUTHOR : Kunal Mandhre 12/06/12
*/

package ibase.webitm.ejb.wms;

import ibase.webitm.ejb.*;
import ibase.webitm.utility.ITMException;
import ibase.utility.E12GenericUtility;
import java.rmi.RemoteException;
import java.sql.*;
import org.w3c.dom.*;


@javax.ejb.Stateless
public class CheckSheetPrs extends ValidatorEJB implements CheckSheetPrsLocal,CheckSheetPrsRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	public String preSave() throws RemoteException,ITMException
	{
		return "";
	}

	public String preSave(String xmlString, String editFlag, String xtraParams, Connection conn)throws RemoteException,ITMException
	{

		System.out.println("CheckSheetPrs EJB called");
		System.out.println("xml String.........."+xmlString);
		Document dom = null;
		try
		{
			if (xmlString != null && xmlString.trim().length() > 0)
			{
					dom = genericUtility.parseString(xmlString);
				executepreSave( dom, editFlag, xtraParams, conn );
			}			
		}
		catch(Exception e)
		{
			System.out.println("Exception :CheckSheetPrs :" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return "";
	}

	private String executepreSave( Document dom, String editFlag, String xtraParams, Connection conn ) throws RemoteException, ITMException
	{
		System.out.println("executepreSave method called");
		String sql = "";
		String cartonNo = "";
		String sscc18 = "";
		
		int deleteCount = 0;
		int detailListLength = 0;
		NodeList detailList = null;
		
		PreparedStatement pstmt = null;

		try
		{			
			conn.setAutoCommit(false); 
			E12GenericUtility genericUtility = new E12GenericUtility();
			
			//cartonNo = checkNull(new E12GenericUtility().getColumnValueFromNode("carton_no", dom.getElementsByTagName("Detail2").item(0)));
			detailList = dom.getElementsByTagName("Detail2");
			detailListLength = detailList.getLength();
			for ( int ctr = 0; ctr < detailListLength; ctr++ )
			{
				cartonNo = checkNull(genericUtility.getColumnValueFromNode("carton_no",detailList.item(ctr)));
				sscc18 = checkNull(genericUtility.getColumnValueFromNode("sscc_18",detailList.item(ctr)));
				if(cartonNo != null && cartonNo.trim().length() > 0)
				{
					//tranId = checkNull(genericUtility.getColumnValue( "tranId", dom, "2" ));
					
					//sql = "update carton_master set scan_flag = 'Y' where carton_no = ?";	
					sql = "update carton_master set scan_flag = 'Y',sscc_18 = ? where carton_no = ?";
					pstmt =  conn.prepareStatement(sql);
					//pstmt.setString(1, cartonNo);
					pstmt.setString(1, sscc18);
					pstmt.setString(2, cartonNo);
					deleteCount = pstmt.executeUpdate();						
					if( deleteCount > 0 )
					{
						System.out.println( "Carton with carton_no " + cartonNo + " scan_flag set Y  from carton master table" );
					}						
					pstmt.close();
					pstmt = null;
				}
			}
			
			
			//cartonNo = checkNull(new E12GenericUtility().getColumnValueFromNode("carton_no", dom.getElementsByTagName("Detail2").item(0)));
			/*
			if(cartonNo != null && cartonNo.trim().length() > 0)
			{
				//tranId = checkNull(genericUtility.getColumnValue( "tranId", dom, "2" ));
				
				sql = "update carton_master set scan_flag = 'Y' where carton_no = ?";	
				pstmt =  conn.prepareStatement(sql);
				pstmt.setString(1, cartonNo);
				deleteCount = pstmt.executeUpdate();						
				if( deleteCount > 0 )
				{
					System.out.println( "Carton with carton_no " + cartonNo + " scan_flag set Y  from carton master table" );
				}						
				pstmt.close();
				pstmt = null;
				
			}*/
			
		}
		catch (SQLException sqe)
		{
			System.out.println("The SQLException occurs in CheckSheetPrs :"+sqe);
			sqe.printStackTrace();
			throw new ITMException(sqe);
		}
		catch(Exception e)
		{
			System.out.println("The Exception occurs in CheckSheetPrs :"+e);
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if( pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.err.println("Exception :CheckSheetPrs :\n"+e.getMessage());
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return "";
	}
	private String checkNull( String input )	
	{
		if ( input == null )
		{
			input = "";
		}
		return input;
	}		
}
