/********************************************************
	Title : EcollectionConf[F14ISUN014]
	Date  : 17/02/15
	Developer: Chandrashekar
 ********************************************************/
package ibase.webitm.ejb.fin.adv;

import ibase.system.config.ConnDriver;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import javax.ejb.Stateless;

@Stateless
public class EcollectionConf extends ActionHandlerEJB implements
		EcollectionConfLocal, EcollectionConfRemote {

	public String confirm(String tranId, String xtraParams, String forcedFlag)
			throws RemoteException, ITMException {
		System.out.println("Calling from " + this.getClass().getSimpleName() + " : confirm");
		String confirmed = "", siteCode = "", bankCode = "";
		String sql = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		String errString = null;
		ResultSet rs = null;
		String loginEmpCode = "", status = "", refNo = "", tranIdRcp = "", custCode = "", stmtId = "";
		String finEntity = "", bankstmtTranId = "", bankGroup = "";
		int cnt = 0;
		int rcpformCnt = 0, rcpCnt = 0;
		double chqAmt = 0.0;
		Timestamp rfDate = null;
		ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
		Timestamp sysDate = null;
		E12GenericUtility genericUtility = new E12GenericUtility();

		try {

			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);

			if (tranId != null && tranId.trim().length() > 0) {
				System.out.println("@@@@@tranId" + tranId + "]");
				//Commented by Tajuddin Mahadi to include Statement Id while confirming.
				//sql = "	select confirmed,status,ref_no,site_code,bank_code,cust_code,ref_date,chq_amt from  receipt_form where tran_id = ? ";
				sql = "SELECT confirmed, status, ref_no, site_code, bank_code, cust_code, ref_date, chq_amt, stmt_id from receipt_form where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				rs = pstmt.executeQuery();
				if (rs.next()) {
					confirmed = rs.getString("confirmed");
					status = rs.getString("status");
					refNo = rs.getString("ref_no");
					siteCode = rs.getString("site_code");
					bankCode = rs.getString("bank_code");
					custCode = rs.getString("cust_code");
					rfDate = rs.getTimestamp("ref_date");
					chqAmt = rs.getDouble("chq_amt");
					stmtId = rs.getString("stmt_id");
					
				}
				System.out.println("refNo>>>>>>>>" + refNo);
				System.out.println("rfDate>>>>>>>>" + rfDate);
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				if ("S".equalsIgnoreCase(status)) {
						if (refNo == null || refNo.trim().length() == 0) {
							errString = itmDBAccessLocal.getErrorString("", "VTNULREFNO", "");
							return errString;
						} else if (rfDate == null) {
							errString = itmDBAccessLocal.getErrorString("", "VTNULREFDT", "");
							return errString;
						} else {
							sql = "	select count(*) as cnt from  receipt_form where site_code = ?  and bank_code=? and ref_no=? and status !='X' ";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, siteCode);
							pstmt.setString(2, bankCode);
							pstmt.setString(3, refNo);
							rs = pstmt.executeQuery();
							if (rs.next()) {
								rcpformCnt = rs.getInt("cnt");
							}
							rs.close();
							rs = null;
							pstmt.close();
							if (rcpformCnt > 1) {
								errString = itmDBAccessLocal.getErrorString("", "VTINVREF", "");
								return errString;
							}

							sql = "select tran_id from receipt where cust_code=? and ref_no=? and ref_date=? and tran_id <> ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1, custCode);
							pstmt.setString(2, refNo);
							pstmt.setTimestamp(3, rfDate);
							pstmt.setString(4, tranId);
							rs = pstmt.executeQuery();
							if (rs.next()) {
								tranIdRcp = checkNull(rs.getString("tran_id"));
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if (tranIdRcp != null && tranIdRcp.trim().length() > 0) {
								/**
								 * Existing receipt found for above combination
								 * check the record from table rcpdishnr where
								 * receipt_no=tranIdRcp
								 * */
								sql = "select count(*) as cnt from rcpdishnr where receipt_no=? and confirmed='N' ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, tranIdRcp);
								rs = pstmt.executeQuery();
								if (rs.next()) {
									cnt = rs.getInt("cnt");
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;

								System.out.println("@V@ Dishponer cnt :- [" + cnt
										+ "]");
								if (cnt == 0) {
									/**
									 * Unconfirmed record found ERROR (Duplicate
									 * utr_no found)
									 * */
									errString = itmDBAccessLocal.getErrorString("",
											"VTUTRDUPL", "");
									return errString;
								}

							}

							System.out.println("@V@ Tran id receipt :- ["
									+ tranIdRcp + "]");

							if ("Y".equalsIgnoreCase(confirmed)) {
								errString = itmDBAccessLocal.getErrorString("", "VTINVCONF2", "");
								return errString;
							} else {
								loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
								/*Calendar currentDate = Calendar.getInstance();
								SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
								String sysDateStr = sdf.format(currentDate.getTime());
								System.out.println("Now the date is :=>  " + sysDateStr);
								sysDate = Timestamp.valueOf(genericUtility.getValidDateString(sysDateStr, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00.0");
								// Start added by chandr shekar on 18-mar-2016
								sql = "	select fin_entity from site where site_code=? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, siteCode);
								rs = pstmt.executeQuery();
								if (rs.next()) {
									finEntity = checkNull(rs.getString("fin_entity"));
								}
								System.out.println("finEntity>>>>>>>>" + finEntity);
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;

								sql = "select group_code from bank where bank_code= ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, bankCode);
								rs = pstmt.executeQuery();
								if (rs.next()) {
									bankGroup = checkNull(rs.getString("group_code"));
								}
								System.out.println("bankGroup>>>>>>>>" + bankGroup);
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;

								sql = "select b.tran_id from bank_statement b,site s,bank bank where s.fin_entity=? "
										+ " and  s.site_code=b.site_code "
										+ " and bank.bank_code=b.bank_code and bank.group_code= ? "
										+ " and b.ref_no=? and b.ref_date=? and b.amount=?  and b.collection_form_ref is null";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1, finEntity);
								pstmt.setString(2, bankGroup);
								pstmt.setString(3, refNo);
								pstmt.setTimestamp(4, rfDate);
								pstmt.setDouble(5, chqAmt);
								rs = pstmt.executeQuery();
								if (rs.next()) {
									bankstmtTranId = checkNull(rs.getString("tran_id"));
								}
								System.out.println("bankstmtTranId>>>>>>>>" + bankstmtTranId);
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;*/

								/*if (bankstmtTranId.trim().length() == 0) {
									sql = "select stmt_id from receipt_form where tran_id = ?";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, tranId);
									rs = pstmt.executeQuery();
									if(rs.next()) {
										sql = "update receipt_form set confirmed = 'Y',conf_date = ?, emp_code__aprv = ?," +
												" status= 'C' where tran_id = ? ";
										pstmt = conn.prepareStatement(sql);
										pstmt.setTimestamp(1, sysDate);
										pstmt.setString(2, loginEmpCode);
										pstmt.setString(3, tranId);
										cnt = pstmt.executeUpdate();
										pstmt.close();
										pstmt = null;
										if (cnt > 0) {
											errString = itmDBAccessLocal.getErrorString("", "VCNFSUC1", "");
											conn.commit();
										} else {
											errString = itmDBAccessLocal.getErrorString("", "VTNCONFT", "");
										}

									} else {
										sql = " update receipt_form set remarks = remarks where tran_id = ? ";
										pstmt = conn.prepareStatement(sql);
										pstmt.setString(1, tranId);
										cnt = pstmt.executeUpdate();
										if (cnt > 0) {
											conn.commit();
											errString = itmDBAccessLocal.getErrorString("", "VTCONFREJ", "");
										}
										pstmt.close();
										pstmt = null;
									}
								}*/ 
								// else {
									// End added by chandrshekar on 18-mar-2016
									sql = " update receipt_form set confirmed = 'Y', conf_date = sysdate, emp_code__aprv = ?, status= 'C' where tran_id = ? ";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1, loginEmpCode);
									pstmt.setString(2, tranId);
									cnt = pstmt.executeUpdate();
									pstmt.close();
									pstmt = null;
									if (cnt > 0) {
										errString = itmDBAccessLocal.getErrorString("", "VCNFSUC1", "");
										conn.commit();
									} else {
										errString = itmDBAccessLocal.getErrorString("", "VTNCONFT", "");
									}

								//}

							}
						}
					
				} else {
					errString = itmDBAccessLocal.getErrorString("",
							"VTNSUBCON", "");
				}
			}

			// end if errstrng
		} catch (Exception e) {
			if (conn != null) {
				try {
					conn.rollback();
				} catch (SQLException ex) {

					e.printStackTrace();
					throw new ITMException(e);
				}
			}
			e.printStackTrace();
			throw new ITMException(e);
		} finally {
			try {
				if (conn != null && !conn.isClosed()) {
					conn.close();
					conn = null;
				}
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;

				}
			} catch (Exception e) {
				System.out.println("Exception : " + e);
				e.printStackTrace();
				throw new ITMException(e);
			}
		}

		return errString;

	}

	public String submit(String tranId, String xtraParams, String forcedFlag)
			throws RemoteException, ITMException {
		System.out
				.println(">>>>>>>>>>>>>>>>>>EcollectionConf submit called>>>>>>>>>>>>>>>>>>>");
		String sql = "", status = "", confirmed = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		String errString = null;
		ResultSet rs = null;
		int cnt = 0;
		ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
		try {

			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);

			if (tranId != null && tranId.trim().length() > 0) {
				System.out.println("tranId>>>[" + tranId + "]");

				sql = "	select status,confirmed from  receipt_form where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				rs = pstmt.executeQuery();
				if (rs.next()) {
					status = rs.getString("status");
					confirmed = rs.getString("confirmed");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;

				if ("S".equalsIgnoreCase(status)) {
					errString = itmDBAccessLocal.getErrorString("",
							"VTINVSUB2", "");
					return errString;
				} else if ("X".equalsIgnoreCase(status)) {
					errString = itmDBAccessLocal.getErrorString("",
							"VTINVSUB4", "");
					return errString;
				} else if ("C".equalsIgnoreCase(status)
						|| "Y".equalsIgnoreCase(confirmed)) {
					errString = itmDBAccessLocal.getErrorString("",
							"VTINVSUB3", "");
					return errString;
				} else if ("R".equalsIgnoreCase(status)) {
					errString = itmDBAccessLocal.getErrorString("",
							"VTINVSUB5", "");
					return errString;
				} else if ("P".equalsIgnoreCase(status)) {
					errString = itmDBAccessLocal.getErrorString("",
							"VTECLNPRC1", "");
					return errString;
				} else {
					sql = " update receipt_form set status = 'S' where tran_id = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, tranId);
					cnt = pstmt.executeUpdate();
					pstmt.close();
					pstmt = null;

					if (cnt > 0) {
						errString = itmDBAccessLocal.getErrorString("",
								"VTSTATSUBM", "");
						conn.commit();
					} else {
						errString = itmDBAccessLocal.getErrorString("",
								"VTNCONFT", "");
					}
				}
			}
		} catch (Exception e) {
			if (conn != null) {
				try {
					conn.rollback();
				} catch (SQLException ex) {
					e.printStackTrace();
					throw new ITMException(e);
				}
			}
			e.printStackTrace();
			throw new ITMException(e);
		} finally {
			try {
				if (conn != null && !conn.isClosed()) {
					conn.close();
					conn = null;
				}
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;
				}
			} catch (Exception e) {
				System.out.println("Exception : " + e);
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		return errString;
	}

	public String open(String tranId, String xtraParams, String forcedFlag)
			throws RemoteException, ITMException {
		System.out
				.println(">>>>>>>>>>>>>>>>>>EcollectionConf open called>>>>>>>>>>>>>>>>>>>");
		String sql = "", status = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		String errString = null;
		ResultSet rs = null;
		int cnt = 0;
		ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
		try {

			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);

			if (tranId != null && tranId.trim().length() > 0) {
				System.out.println("tranId>>>[" + tranId + "]");

				sql = "	select status from  receipt_form where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				rs = pstmt.executeQuery();
				if (rs.next()) {
					status = rs.getString("status");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				if ("R".equalsIgnoreCase(status) || "X".equalsIgnoreCase(status)) {
					sql = " update receipt_form set status = 'E',confirmed = 'N' where tran_id = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, tranId);
					cnt = pstmt.executeUpdate();
					pstmt.close();
					pstmt = null;
					if (cnt > 0) {
						conn.commit();
						errString = itmDBAccessLocal.getErrorString("",
								"VTECOLOPEN", "");

					}
				} else {
					errString = itmDBAccessLocal.getErrorString("",
							"VTECNOTREJ", "");
				}

			}

			// end if errstrng
		} catch (Exception e) {
			if (conn != null) {
				try {
					conn.rollback();
				} catch (SQLException ex) {

					e.printStackTrace();
					throw new ITMException(e);
				}
			}
			e.printStackTrace();
			throw new ITMException(e);
		} finally {
			try {
				if (conn != null && !conn.isClosed()) {
					conn.close();
					conn = null;
				}
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;

				}
			} catch (Exception e) {
				System.out.println("Exception : " + e);
				e.printStackTrace();
				throw new ITMException(e);
			}
		}

		return errString;

	}

	public String cancel(String tranId, String xtraParams, String forcedFlag)
			throws RemoteException, ITMException {
		System.out
				.println(">>>>>>>>>>>>>>>>>>EcollectionConf cancel called>>>>>>>>>>>>>>>>>>>");
		String sql = "", status = "", confirmed = "";
		Connection conn = null;
		PreparedStatement pstmt = null;
		String errString = null;
		ResultSet rs = null;
		int cnt = 0;
		ITMDBAccessEJB itmDBAccessLocal = new ITMDBAccessEJB();
		try {

			ConnDriver connDriver = null;
			connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverITM");
			conn.setAutoCommit(false);

			if (tranId != null && tranId.trim().length() > 0) {
				System.out.println("tranId>>>[" + tranId + "]");

				sql = "	select status,confirmed from  receipt_form where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, tranId);
				rs = pstmt.executeQuery();
				if (rs.next()) {
					status = rs.getString("status");
					confirmed = rs.getString("confirmed");
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;
				if (!"X".equalsIgnoreCase(status)
						&& !"C".equalsIgnoreCase(status)
						&& !"P".equalsIgnoreCase(status)) {
					sql = " update receipt_form set status = 'X' where tran_id = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, tranId);
					cnt = pstmt.executeUpdate();
					pstmt.close();
					pstmt = null;
					if (cnt > 0) {
						conn.commit();
						errString = itmDBAccessLocal.getErrorString("",
								"VTECLNCAN", "");

					}
				} else if ("X".equalsIgnoreCase(status)) {
					errString = itmDBAccessLocal.getErrorString("",
							"VTECLNCANX", "");
				} else if ("C".equalsIgnoreCase(status)) {
					errString = itmDBAccessLocal.getErrorString("",
							"VTECLNCANC", "");
				} else if ("P".equalsIgnoreCase(status)) {
					errString = itmDBAccessLocal.getErrorString("",
							"VTECLNPRC", "");
				}

			}

			// end if errstrng
		} catch (Exception e) {
			if (conn != null) {
				try {
					conn.rollback();
				} catch (SQLException ex) {

					e.printStackTrace();
					throw new ITMException(e);
				}
			}
			e.printStackTrace();
			throw new ITMException(e);
		} finally {
			try {
				if (conn != null && !conn.isClosed()) {
					conn.close();
					conn = null;
				}
				if (rs != null) {
					rs.close();
					rs = null;
				}
				if (pstmt != null) {
					pstmt.close();
					pstmt = null;

				}
			} catch (Exception e) {
				System.out.println("Exception : " + e);
				e.printStackTrace();
				throw new ITMException(e);
			}
		}

		return errString;

	}

	private String checkNull(String str) {
		if (str == null) {
			return "";
		} else {
			return str;
		}

	}

}