package ibase.dashboard.sfa.servlet;

import ibase.dashboard.sfa.ejb.ZonewiseCoachingDaysRemote;
import ibase.system.config.AppConnectParm;
import ibase.utility.UserInfoBean;
import ibase.webitm.utility.ITMException;
import java.io.IOException;
import java.io.OutputStream;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.json.simple.JSONObject;

public class ZonewiseCoachingDaysServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;

	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws IOException, ServletException
	{
		doPost(request, response);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws IOException, ServletException
	{
		ZonewiseCoachingDaysRemote zonewisecoachingdaysRemote = null;
		InitialContext context           = null;
		AppConnectParm appConnectParm    = new AppConnectParm();
		String dataSourceName            = "";
		String loginCode                 = "";
		String loginEmpCode              = "";
		HttpSession session              = null;
		JSONObject jsonObjData           = null;
		OutputStream outputStream        = null;
		UserInfoBean userInfo            = null;
		String toDate                    = "";
		String fromDate                  = "";
		
		try
		{
			response.setContentType("application/xml");
			session        = request.getSession(true);
			userInfo       = (UserInfoBean) session.getAttribute("USER_INFO");
			loginCode      = userInfo.getLoginCode();
			loginEmpCode   = userInfo.getEmpCode();
			dataSourceName = request.getParameter("dataSourceName");
			fromDate       = request.getParameter("fromDate");
			toDate         = request.getParameter("toDate");
			System.out.println("fromDate = "+fromDate+" toDate = "+toDate);
			context        = new InitialContext(appConnectParm.getProperty());
			zonewisecoachingdaysRemote = (ZonewiseCoachingDaysRemote) context.lookup("ibase/ZonewiseCoachingDays/remote");
			jsonObjData    = (JSONObject) zonewisecoachingdaysRemote.getZonewiseCoachingDay(loginCode,dataSourceName,fromDate,toDate,loginEmpCode);
			outputStream   = response.getOutputStream();
			outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println(" ZonewiseCoachingDaysServlet build the Graph==="+ jsonObjData);
		}
		catch (Exception e)
		{
			System.out.println("Exception : ZonewiseCoachingDaysServlet :doPost() :"+ e);
			try
			{
				throw new ITMException(e);
			}
			catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}
}
