/*
 * Copyright 2011 Daniel Kurka
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 * 
 * http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.googlecode.gwtphonegap.client.file;

public interface File {

	public static final int LocalFileSystem_TEMPORARY = 0;
	public static final int LocalFileSystem_PERSISTENT = 1;
	public static final int LocalFileSystem_RESOURCE = 2;
	public static final int LocalFileSystem_APPLICATION = 3;

	public void requestFileSystem(int fileSystemType, int size, FileCallback<FileSystem, FileError> callback);

	public void resolveLocalFileSystemURI(String url, FileCallback<EntryBase, FileError> callback);

	public FileTransfer createFileTransfer();

	public FileReader createReader();

	/**
	 * only used for mock implementations
	 * 
	 * @param path
	 */
	public void setBasePath(String path);
}
