package ibase.e12ria.e12widgets.client;

import com.google.gwt.dom.client.Element;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.RadioButton;

public class E12RadioButton extends RadioButton
{
	public E12RadioButton( String name, String label ) 
	{
		super( name, label );
		setStyleName( "option" );
		appendLabel();
	}
	
	public E12RadioButton( String name, String label, boolean asHTML )
	{
		super( name, label, asHTML );
		setStyleName( "option" );
		appendLabel();
	}
	
	private void appendLabel()
	{
		try
		{
			Element frstElement = getElement().getFirstChildElement();
			frstElement.setAttribute( "class", "focus" );
			
			Element  lstElement = frstElement.getNextSiblingElement();
			lstElement.setAttribute( "class", "radioLabel" );
			
			Element lbl = DOM.createLabel();
			lbl.setAttribute( "class", "radio" );
			
			getElement().insertAfter( lbl, frstElement );
		} 
		catch (Exception e) 
		{
			Window.alert( "Exception :: E12RadioButton : appendLabel() ["+e.getMessage()+"]" );
		}
	}
}
