/*
 * Decompiled with CFR 0.152.
 */
package ibase.e12ria.client;

import com.google.gwt.gen2.table.client.FixedWidthGrid;
import com.google.gwt.http.client.Response;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.FlexTable;
import com.google.gwt.user.client.ui.HorizontalPanel;
import com.google.gwt.user.client.ui.TabPanel;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.user.datepicker.client.DateBox;
import com.google.gwt.xml.client.Document;
import com.google.gwt.xml.client.Node;
import com.google.gwt.xml.client.NodeList;
import com.google.gwt.xml.client.XMLParser;
import ibase.e12ria.client.E12CommonUtils;
import ibase.e12ria.client.E12Constants;
import ibase.e12ria.client.E12Global;

public class E12MessageHandler {
    int rowNoClicked = -1;
    int colNoClicked = -1;

    public boolean getErrorInfo(NodeList errorsList, int formNo, boolean isFeedForm, TabPanel formTabPanel, TextBox e12txtBox) {
        return this.getErrorInfo(errorsList, formNo, isFeedForm, formTabPanel, e12txtBox, null);
    }

    public boolean getErrorInfo(NodeList errorsList, int formNo, boolean isFeedForm, TabPanel formTabPanel, TextBox e12txtBox, Widget widget) {
        boolean retErrorType = false;
        boolean isErrorNodeFound = false;
        if (e12txtBox != null) {
            e12txtBox.setVisible(true);
        }
        int errorsLen = errorsList.getLength();
        String errorColName = "";
        String errorDomId = "";
        int errorCtr = 0;
        while (errorCtr < errorsLen) {
            NodeList subErrorList = errorsList.item(errorCtr).getChildNodes();
            int subErrorLen = subErrorList.getLength();
            int subErrorCtr = 0;
            while (subErrorCtr < subErrorLen) {
                Node errorItem = subErrorList.item(subErrorCtr);
                NodeList errorChilds = errorItem.getChildNodes();
                String errorId = E12CommonUtils.getAttribValue(errorItem, "id");
                String errorType = E12CommonUtils.getAttribValue(errorItem, "type");
                errorColName = E12CommonUtils.getAttribValue(errorItem, "column_name");
                errorDomId = E12CommonUtils.getAttribValue(errorItem, "domId");
                if ("".equalsIgnoreCase(errorDomId)) {
                    errorDomId = "1";
                }
                String errorMsg = errorChilds.item(0).getFirstChild().getNodeValue();
                String errorDesc = errorChilds.item(1).getFirstChild().getNodeValue();
                if ("F".equalsIgnoreCase(errorType)) {
                    Window.alert((String)("Message : " + errorMsg + "\nDescription: " + errorDesc));
                    E12Global.getInstance().setForcedSave(false);
                    E12Global.getInstance().setFatalError(true);
                    retErrorType = false;
                    break;
                }
                if ("E".equalsIgnoreCase(errorType) || "X".equalsIgnoreCase(errorType)) {
                    Window.alert((String)("Message : " + errorMsg + "\nDescription: " + errorDesc));
                    E12Global.getInstance().setForcedSave(false);
                    isErrorNodeFound = true;
                    retErrorType = false;
                } else if ("P".equalsIgnoreCase(errorType)) {
                    Window.alert((String)("Message : " + errorMsg + "\nDescription: " + errorDesc));
                    if (!isFeedForm && formTabPanel != null) {
                        formTabPanel.selectTab(1);
                    }
                    E12Global.getInstance().setForcedSave(false);
                    retErrorType = true;
                    if (isErrorNodeFound) {
                        E12Global.getInstance().setForcedSave(false);
                        retErrorType = false;
                    }
                } else if ("W".equalsIgnoreCase(errorType)) {
                    retErrorType = Window.confirm((String)("Message : " + errorMsg + "\nDescription: " + errorDesc));
                    if (retErrorType && !isFeedForm && formTabPanel != null) {
                        formTabPanel.selectTab(1);
                    }
                    if (isErrorNodeFound) {
                        E12Global.getInstance().setForcedSave(false);
                        retErrorType = false;
                    } else {
                        E12Global.getInstance().setForcedSave(retErrorType);
                    }
                }
                ++subErrorCtr;
            }
            ++errorCtr;
        }
        if (widget == null) {
            return retErrorType;
        }
        if (widget instanceof FlexTable) {
            try {
                FlexTable flexTbl = (FlexTable)widget;
                int noOfRows = flexTbl.getRowCount();
                int noOfRowsCtr = 0;
                while (noOfRowsCtr < noOfRows) {
                    int noOfCols = flexTbl.getCellCount(noOfRowsCtr);
                    int noOfColsCtr = 0;
                    while (noOfColsCtr < noOfCols) {
                        HorizontalPanel hpPanel;
                        if (flexTbl.getWidget(noOfRowsCtr, noOfColsCtr) instanceof HorizontalPanel && (hpPanel = (HorizontalPanel)flexTbl.getWidget(noOfRowsCtr, noOfColsCtr)).getWidgetCount() >= 1) {
                            DateBox dateBox;
                            if (hpPanel.getWidget(0) instanceof TextBox) {
                                TextBox txtBox = (TextBox)hpPanel.getWidget(0);
                                if (txtBox.getTitle().equals("Detail" + formNo + "." + errorDomId + "." + errorColName)) {
                                    txtBox.setFocus(true);
                                    if (txtBox.getText().length() > 0) {
                                        txtBox.setSelectionRange(0, txtBox.getText().length());
                                    }
                                }
                            } else if (hpPanel.getWidget(0) instanceof DateBox && (dateBox = (DateBox)hpPanel.getWidget(0)).getTitle().equals("Detail" + formNo + "." + errorDomId + "." + errorColName)) {
                                dateBox.setFocus(true);
                                dateBox.showDatePicker();
                            }
                        }
                        ++noOfColsCtr;
                    }
                    ++noOfRowsCtr;
                }
            }
            catch (Exception exception) {}
        } else {
            boolean cfr_ignored_0 = widget instanceof FixedWidthGrid;
        }
        return retErrorType;
    }

    public static void handleExceptionIfPresent(Response response) {
        E12MessageHandler.handleExceptionIfPresent(response, null);
    }

    public static void handleExceptionIfPresent(Response response, Command exceptionCommand) {
        if (response.getStatusCode() != 200) {
            Window.alert((String)E12Constants.constants.setCheckServerUrl());
            exceptionCommand.execute();
            return;
        }
        if (response.getText().indexOf("<Errors><Error ") != -1 || response.getText().indexOf("<Errors><error ") != -1) {
            Window.alert((String)E12Constants.constants.setDataAppError());
            exceptionCommand.execute();
        }
    }

    public static void handleException(String responseStr) {
        try {
            Document document = XMLParser.parse((String)responseStr);
            XMLParser.removeWhitespace((Node)document);
            NodeList exceptionList = document.getElementsByTagName("Errors");
            int errorsLen = exceptionList.getLength();
            int errorCtr = 0;
            while (errorCtr < errorsLen) {
                NodeList subErrorList = exceptionList.item(errorCtr).getChildNodes();
                int subErrorLen = subErrorList.getLength();
                int subErrorCtr = 0;
                while (subErrorCtr < subErrorLen) {
                    NodeList errorChilds = subErrorList.item(subErrorCtr).getChildNodes();
                    String errorId = subErrorList.item(subErrorCtr).getAttributes().getNamedItem("id").getNodeValue();
                    String errorType = subErrorList.item(subErrorCtr).getAttributes().getNamedItem("type").getNodeValue();
                    String errorMsg = errorChilds.item(0).getFirstChild().getNodeValue();
                    String errorDesc = errorChilds.item(1).getFirstChild().getNodeValue();
                    if (errorType.equalsIgnoreCase("X")) {
                        Window.confirm((String)("Message : " + errorMsg + "\nDescription: " + errorDesc));
                    }
                    ++subErrorCtr;
                }
                ++errorCtr;
            }
        }
        catch (Exception e) {
            Window.alert((String)responseStr);
        }
    }
}

