<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:decimal-format NaN="0"/>

<xsl:template match="/">

<html>

<body onload="getTitlenImg('gstsalesdata_submit');returnPeriodDropdown();">
<script type="text/javascript" src="/ibase/webitm/js/GSTDataSubmitWiz.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery-1.10.2.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery-ui-1.10.4.custom.min.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/FixedTableHeader.js"></script>
<script language="Javascript" src="/ibase/webitm/js/jquery.datetimepicker.full.js"></script>
<script language="Javascript" src="/ibase/webitm/js/date.js"></script>

<link href="/ibase/webitm/css/jquery-ui-1.10.4.custom.min.css" rel="stylesheet"/>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.core.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.widget.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.position.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.menu.js"></script>
<script type="text/javascript" src="/ibase/webitm/js/jquery.ui.autocomplete.js"></script>
		
<link href="/ibase/webitm/css/htmlWizard.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/GSTDataSubmitWiz.css" rel="stylesheet"/>
<link href="/ibase/webitm/css/jquery.datetimepicker.css" rel="stylesheet"/>

<script>
<![CDATA[
	$(document).on("keydown", function (e) {
    if (e.which === 8 && !$(e.target).is("input, textarea, form")) {
        e.preventDefault();
    }
    else if(e.which ===13){
    	 e.preventDefault();
    }
});
]]>
</script>

<form name="gstdataSubmitForm1" id="gstdataSubmitForm1" METHOD="post" ACTION="/ibase/ITMWizardHandlerServlet">
	<div class="contentHeaderLbl" style="position:fixed;overflow:hidden;width:100%;padding:12px; background-color:white;top:0px;">
		&#160;&#160;<img onerror=" this.src= '/ibase/images/menuImages/errMenu.png' " style="position: absolute; margin-left: -20px; height: 20px; width: 20px;" id="titleImg" />
		&#160;<div id="titleText"></div>
		
	</div><br></br><br></br>
	<div id="innerDiv" style="overflow-y:hidden;overflow-x:auto;max-height:80%;width:98%;position:absolute;">
	    <table id="errorActivityTable" height="10%" class="tableClass"  style="margin: 12px 0px 0px 0px;position: relative;width: calc(literal('100% - 15px'));width: -moz-calc(literal('100% - 15px'));padding-right:0px; padding-left:5xp; width: -webkit-calc(literal('100% - 15px'));box-shadow: 3px 3px 3px gray;-moz-box-shadow:3px 3px 3px gray;-webkit-box-shadow: 3px 3px 3px gray;-o-box-shadow: 3px 3px 3px gray;background: rgba(255, 204, 0, 0.66);min-height: 50px;bottom:10px"  border="0" cellspacing="0" cellpadding="0"> 
            <xsl:for-each select="//error">
                <xsl:if test="position() = 1">
                    <tr>    
                        <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" valign="bottom">
                            Message :
                        </td> 
                        <td class="tdss_leftAlign"   style="background: rgba(255, 204, 0, 0.66);" valign="bottom">
                            Description :
                        </td>
                        <td class="tdss_rightAlign"  style="background: rgba(255, 204, 0, 0.66);" nowrap="true" valign="bottom" colspan="2">
                            <a href="#" style="text-decoration:none;" onclick="doHideMsg('errorActivityTable')"><font style="color:#000;text-decoration:none;padding-right:5px;" ><b>X</b></font></a>
                        </td>
                    </tr>
                </xsl:if>
                <xsl:variable name="message"><xsl:value-of select="message"/></xsl:variable>
                <xsl:variable name="description"><xsl:value-of select="description"/></xsl:variable>
                <xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
                <xsl:variable name="dbID"><xsl:value-of select="@domId"/></xsl:variable>  
                <xsl:variable name="column_name"><xsl:value-of select="@column_name"/></xsl:variable> 
                <tr style="background: rgba(255, 204, 0, 0.66);">
                     <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" >
                        <xsl:value-of select="message"/>
                    </td> 
                    
                    <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" >
                        <xsl:value-of select="description"/>
                    </td>
                    
                    <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);" >
                    </td>
                </tr>
            </xsl:for-each>
            
            <xsl:for-each select="//error">
                <xsl:variable name="type"><xsl:value-of select="type"/></xsl:variable>
                <xsl:if test="position() = 1">
                    <xsl:if test="$type = 'W'">
                        <tr style="background: rgba(255, 204, 0, 0.66);">
                            <td class="tdss_leftAlign"  style="background: rgba(255, 204, 0, 0.66);"  nowrap="true" valign="bottom">
                                <input  type="checkbox" name="forceSave" value="true" checked="checked" onClick="setChecked(this)"/>
                            </td>
                            <td class="tdss_leftAlign" style="background: rgba(255, 204, 0, 0.66);"  nowrap="true"></td>
                        </tr>
                    </xsl:if>
                </xsl:if>    
            </xsl:for-each>
	    </table>
	</div>
	
	<div id="popHelpContainer"></div>
	<div id="overlay"></div>
	<div id="mainPageHeaderContatiner">
		<div class="mainPage-input-Container">
			<xsl:for-each select="//Detail1">
				<xsl:variable name="dbID"><xsl:value-of select="@domID"/></xsl:variable>
				<xsl:variable name="period_code"><xsl:value-of select="period_code"/></xsl:variable>
				<xsl:variable name="site_code"><xsl:value-of select="site_code"/></xsl:variable>
				<xsl:variable name="site_descr"><xsl:value-of select="site_descr"/></xsl:variable>
				<xsl:variable name="gstin"><xsl:value-of select="gstin"/></xsl:variable>
				<xsl:variable name="username"><xsl:value-of select="username"/></xsl:variable>
				<xsl:variable name="state_code"><xsl:value-of select="state_code"/></xsl:variable>
				<xsl:variable name="state_descr"><xsl:value-of select="state_descr"/></xsl:variable>
				<xsl:variable name="otp"><xsl:value-of select="otp"/></xsl:variable>
				<xsl:variable name="app_key"><xsl:value-of select="app_key"/></xsl:variable>
				<xsl:variable name="gross_turnover"><xsl:value-of select="gross_turnover"/></xsl:variable>
				
				<div class="inputFormDiv">
					<div class="eachLineFields">
						<div class="eachField">
							<div class="labelDiv">GSTIN : </div>
							<div class="inputDiv"><input type="text" class="editDisplayClass" value="{$gstin}" name="Detail1.{normalize-space($dbID)}.gstin" id="Detail1.{normalize-space($dbID)}.gstin" tabIndex="-1"/></div>
						</div>
						<div class="eachField">
							<div class="labelDiv">User name : </div>
							<div class="inputDiv"><input type="text" class="editDisplayClass" value="{$username}" name="Detail1.{normalize-space($dbID)}.username" id="Detail1.{normalize-space($dbID)}.username" tabIndex="-1" readOnly="true" style="width:224px;"/></div>
						</div>
					</div>
					<div class="eachLineFields" style="width:675px;">
						<div class="eachField">
							<div class="labelDiv">State code : </div>
							<div class="inputDiv"><input type="text" class="editDisplayClass" value="{$state_code}" name="Detail1.{normalize-space($dbID)}.state_code" id="Detail1.{normalize-space($dbID)}.state_code" tabIndex="-1" readOnly="true" style="width:40px;text-align:right;padding-right:4px;"/></div>
						</div>
						<div class="eachField">
							<div class="inputDiv"><input type="text" class="editDisplayClass" value="{$state_descr}" name="Detail1.{normalize-space($dbID)}.state_descr" id="Detail1.{normalize-space($dbID)}.state_descr" tabIndex="-1" readOnly="true" style="width:150px;"/></div>
						</div>
						<div class="eachField" style="float:right;display:none;">
							<div class="labelDiv">Gross turnover<span style="color:red;">*</span>  : </div>
							<div class="inputDiv"><input type="text" class="input_editable" value="{$gross_turnover}" name="Detail1.{normalize-space($dbID)}.gross_turnover" id="Detail1.{normalize-space($dbID)}.gross_turnover" tabIndex="30" style="text-align:right;padding-right:4px;width:120px;" onblur="checkValidInput(this);" onkeypress="return isNumberKey(event);"/></div>
						</div>
					</div>
					<div class="eachLineFields">
						<!--<div class="eachField">
							<div class="labelDiv">Month<span style="color:red;">*</span> : </div>
							<div class="inputDiv"><input type="text" class="input_editable" value="{$period_code}" name="Detail1.{normalize-space($dbID)}.period_code" id="Detail1.{normalize-space($dbID)}.period_code" tabIndex="10" style="width:60px;" popupFldName="PERIOD_CODE" onkeyup="getAutoPopupData(this);" onfocus="displayPopUpIcon('popUpIcon1');"/></div>
							<div class="popHelpIconDiv"><a href="javascript:getListOfValues('PERIOD_CODE','Detail1.{normalize-space($dbID)}.period_code','{$site_code}');" id="popUpIcon1"  tabIndex="-1"><img src="/ibase/webitm/images/pophelp.png"/></a></div>
						</div>-->
						<div class="eachField">
							<div class="labelDiv">Month<span style="color:red;">*</span> : </div>
							<div class="inputDiv"><select class="input_editable" id="yearMonthInput" name="Detail1.{normalize-space($dbID)}.period_code"></select></div>
						</div>
						<div class="eachField" style="display:none;">
							<div class="labelDiv">Site code<span style="color:red;">*</span> : </div>
							<div class="inputDiv"><input type="text" class="input_editable" value="{$site_code}" name="Detail1.{normalize-space($dbID)}.site_code" id="Detail1.{normalize-space($dbID)}.site_code" tabIndex="20" style="width:60px;text-transform:uppercase;" popupFldName="SITE_CODE" onkeyup="getAutoPopupData(this);" onfocus="displayPopUpIcon('popUpIcon2');" onchange="callItemChange(this.id);" /></div>
							<div class="popHelpIconDiv"><a href="javascript:getListOfValues('SITE_CODE','Detail1.{normalize-space($dbID)}.site_code','{$site_code}');" id="popUpIcon2"  tabIndex="-1"><img src="/ibase/webitm/images/pophelp.png"/></a></div>
						</div>
						<div class="eachField" style="display:none;">
							<div class="inputDiv"><input type="text" class="editDisplayClass" value="{$site_descr}" name="Detail1.{normalize-space($dbID)}.site_descr" id="Detail1.{normalize-space($dbID)}.site_descr" tabIndex="-1" readOnly="true" style="width:268px;"/></div>
						</div>
					</div>
					<div class="eachLineFields" style="width:675px;display:none;">
						<div class="eachField">
							<div class="labelDiv">Returns type<span style="color:red;">*</span> : </div>
							<div class="inputDiv">
								<input type="text" id='Detail1.{normalize-space($dbID)}.returns_type' NAME="Detail1.{normalize-space($dbID)}.returns_type" value="GSTR1"/>
							</div>
						</div>
						<div class="eachField">
							<div class="labelDiv" style="width:70px;">Action<span style="color:red;">*</span> : </div>
							<div class="inputDiv">
								<input type="text" id='Detail1.{normalize-space($dbID)}.action' NAME="Detail1.{normalize-space($dbID)}.action" value="SUBMIT"/>
							</div>
						</div>
					</div>
					<div class="eachLineFields" style="text-align:center;margin-top:10px;">
						<div class="eachField">
							<div class="inputDiv"><input type="button" class="button" value="Generate OTP" title="Generate OTP" onClick="generateOTP();" tabIndex="-1" style="margin-right:0px;"/></div>
						</div>
					</div>
					<div class="eachLineFields" style="text-align:center;">
						<div class="eachField" style="margin-left:12px;display:none;" id="otpInputDiv">
							<div class="labelDiv" style="width:50px;float:none;">OTP<span style="color:red;">*</span> : </div>
							<div class="inputDiv" style="float:none;"><input type="text" class="input_editable"  name="Detail1.{normalize-space($dbID)}.otp" id="Detail1.{normalize-space($dbID)}.otp" tabIndex="60" style="width:80px;"/></div>
							<div id="timerDiv" style="display: none;margin-left: 20px;font-size:13px;float:none;"> OTP Expires in <span id="timerVal">10:00</span></div>
						</div>
					</div>
					<div class="eachLineFields" style="display:none;">
						<div class="eachField">
							<div class="labelDiv">App Key : </div>
							<div class="inputDiv"><input type="text" class="editDisplayClass" value="{$app_key}" name="Detail1.{normalize-space($dbID)}.app_key" id="Detail1.{normalize-space($dbID)}.app_key" tabIndex="-1" style="width:400px;"/></div>
						</div>
					</div>
				</div>
			</xsl:for-each>
		</div>
		<div id="btnDiv">
			<input type="hidden" value="1" name="FORM_NO" ID="FORM_NO" />
			<input type="hidden" value="gstsalesdata_submit" name="OBJ_NAME" />
			<input type="hidden" value="" name="action" id="action" />
			<input type="submit" style="cursor:hand;margin-left:20px;" value="Next" onclick="setActionVal('next');return validateHeaderForm();" class="button" title='Next' id="next"/>
		</div>
	</div>
	<div id="buttonreplacement">
		<img src="/ibase/images/preload.gif" alt="Please wait" ></img>
		<span>Please wait......</span>
	</div>
</form>
</body>
</html>
</xsl:template>
</xsl:stylesheet>
