/**
 * @author : Wasim Ansari
 * Date : 05-JUN-2015
 * Migration: W16IBAS005
 */

package ibase.webitm.ejb.fin.adv;

import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.E12CreateBatchLoadEjb;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.ejb.sys.CreateRCPXML;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.text.*;

import javax.ejb.Stateless;

import org.w3c.dom.Document;




@Stateless
public class RcvIbcaConf extends ActionHandlerEJB implements PayIbcaConfLocal, PayIbcaConfRemote 
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	FinCommon finCommon = new FinCommon();;
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();;
	String gs_run_mode = "";
	
	public String confirm(String tranID,String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{
		String retString = "";
		Connection conn = null;

		try
		{
			retString = confirm( tranID, xtraParams, forcedFlag , conn );

			if ( retString != null && retString.length() > 0 )
			{
				throw new Exception("Exception while calling RcvIbcaConf Confirm for tran  Id:["+tranID+"]");
			}
		}
		catch(Exception ex)
		{
			System.out.println("Exception in [RcvIbcaConf Main]" + ex.getMessage());
			throw new ITMException(ex);
		}
		return retString;
	}
	
	public String confirm(String tranId, String xtraParams,String forcedFlag, Connection conn) throws RemoteException,ITMException
	{
		System.out.println("RcvIbcaConf Confirm called........");
		String sql = "";
		String confirm = "";
		String siteCode = "";
		String errString = "" ;
		String loginEmpCode = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		boolean connStatus=false;
		String chgUser="";
		java.sql.Timestamp today = null;

		try
		{
			if (conn == null)
			{
				conn = getConnection();
				connStatus = true;
			}
			
			loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
			gs_run_mode  = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "runMode");
			
			sql = " select confirmed,site_code__from as site_code,chg_user from rcp_ibca where tran_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				confirm = rs.getString("confirmed") == null ?"N":rs.getString("confirmed");
				siteCode = rs.getString("site_code") == null ?" ":rs.getString("site_code");
				chgUser = rs.getString("chg_user") == null ?" ":rs.getString("chg_user");
			}
			if(rs != null)
			{
				rs.close();rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();pstmt = null;
			}
			
			if(chgUser==null || chgUser.trim().length()==0)
			{
				chgUser="SYSTEM";
			}
			if("null".equalsIgnoreCase(loginEmpCode) || loginEmpCode==null || loginEmpCode.trim().length()==0)
			{
				sql=" select emp_code from users where code=? ";
				pstmt=conn.prepareStatement(sql);
				pstmt.setString(1,chgUser);
				
				rs=pstmt.executeQuery();
				if(rs.next())
				{
					loginEmpCode=rs.getString(1);
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
			}
			
			if(confirm != null  && "N".equalsIgnoreCase(confirm))
			{
				errString = retreiveRibca (tranId,siteCode,xtraParams,conn);
				
				System.out.println("Return String from createRibca ["+errString+"]");
				
				if(errString != null && errString.trim().length() > 0)
				{
					return errString;
				}
				
				if(errString == null || errString.trim().length() == 0)
				{
					if("null".equalsIgnoreCase(loginEmpCode) || loginEmpCode==null || loginEmpCode.trim().length()==0)
					{
						loginEmpCode="E03952";
					}
					
					today = new java.sql.Timestamp(System.currentTimeMillis()) ;
					
					sql = " update rcp_ibca set confirmed = 'Y', conf_date = ?, emp_code__aprv = ? where tran_id = ? ";
					pstmt = conn.prepareStatement(sql);
					pstmt.setTimestamp(1, today);
					pstmt.setString(2, loginEmpCode);
					pstmt.setString(3, tranId);
					int updateCoount = pstmt.executeUpdate();
					System.out.println("Rows Updated= "+updateCoount);
					if(pstmt != null)
					{
						pstmt.close();pstmt = null;
					}
					if(updateCoount > 0)
					{
						errString = itmDBAccessEJB.getErrorString("","VTCICONF3","","",conn);
					}
				}
				else 
				{
					return errString;
				}
			}
			else
			{
				System.out.println("The Selected transaction is already confirmed and can not be edited");
				
				errString = itmDBAccessEJB.getErrorString("","VTMCONF1","","",conn);
				return errString;
			}
			
			System.out.println("Error String from confirm method.....[" + errString + "]");
		} 
		catch( Exception e)
		{
			System.out.println("Exception inside RcvIbcaConf Confirm==>"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("Inside finally connStatus ["+connStatus+"]");
				
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
				if( conn != null && !conn.isClosed() && connStatus ) 
				{
					if(errString.indexOf("VTCICONF3") > -1)
					{
						System.out.println("Inside comitting.....");
						conn.commit();
					}
					else
					{
						System.out.println("Inside rollbacking.....");
						conn.rollback();
					}
					if(conn!=null)
					{	
						conn.close();conn = null;
					}	
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception : "+e);
				e.printStackTrace();
			}
		}
		return errString;
	}

	/**
	 * gbf_retrieve_ribca --> retreiveRibca
	 */
	
	public String retreiveRibca(String ibcaID , String siteCode , String xtraParams, Connection conn) throws ITMException
	{
		String retString = "";
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		List<String> tranIDList = new ArrayList<String>();
		int cntHdr = 0;
		String tranIDRcpIBCA = "",winName = "",ledgPostConf = "";
		Timestamp tranDate = null,today = null;
		Map hdrMap = null;
		Map detMap = null;
		List detailList = new ArrayList();
		try
		{
			System.out.println("Inside gbf_retrieve_ribca...ibcaID["+ibcaID+"] siteCode["+siteCode+"]");
			
			today = new java.sql.Timestamp(System.currentTimeMillis()) ;
		
			sql = " select tran_id from rcp_ibca where tran_id >= ? and tran_id <= ? and site_code__from = ? "
				 +" and upper(confirmed) <> 'Y' " ;
	        pstmt = conn.prepareStatement(sql);
	        pstmt.setString(1, ibcaID);
			pstmt.setString(2, ibcaID);
			pstmt.setString(3, siteCode);
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				cntHdr++;
				tranIDList.add(rs.getString("tran_id"));
			}
			if(rs!=null)
			{
				rs.close();rs= null;
			}
			if(pstmt!=null)
			{
				pstmt.close();pstmt= null;
			}
			
			for(int i = 0; i<tranIDList.size(); i++)
			{
				tranIDRcpIBCA = tranIDList.get(i);
				
				System.out.println("tranIDRcpIBCA--->["+tranIDRcpIBCA+"]");
				
				if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
				{
					sql = " select tran_id from rcp_ibca where tran_id = ? for update ";
				}

				else if ( "mssql".equalsIgnoreCase(CommonConstants.DB_NAME ))
				{
					sql = " select tran_id from rcp_ibca (updlock) where tran_id = ? ";
				}
				else
				{
					sql = " select tran_id from rcp_ibca where tran_id = ? for update nowait ";
				}
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranIDRcpIBCA);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					tranIDRcpIBCA = rs.getString("tran_id") == null ? " ":rs.getString("tran_id");
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}

				sql =  " select tran_id,tran_date,eff_date,site_code__from,fin_entity__from,site_code__to,fin_entity__to, "
					  +" amount,curr_code,confirmed,exch_rate,conf_date,emp_code__aprv,acct_code__ifr,cctr_code__ifr,acct_code__ito,cctr_code__ito, "
					  +" chg_date,chg_user,chg_term,add_date,add_user,add_term,amount__bc,tran_type,tran_ser,tran_id__iss,link_type,remarks, "
					  +" parent__tran_id,rev__tran,sundry_type,sundry_code "
					  +" from rcp_ibca WHERE tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranIDRcpIBCA);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					hdrMap = new HashMap(); 
					
					hdrMap.put("tran_id", rs.getString("tran_id"));
					hdrMap.put("tran_date", rs.getTimestamp("tran_date"));
					hdrMap.put("eff_date", rs.getTimestamp("eff_date"));
					hdrMap.put("site_code__from", rs.getString("site_code__from"));
					hdrMap.put("fin_entity__from", rs.getString("fin_entity__from"));
					hdrMap.put("site_code__to", rs.getString("site_code__to"));
					hdrMap.put("fin_entity__to", rs.getString("fin_entity__to"));
					hdrMap.put("amount", rs.getDouble("amount"));
					hdrMap.put("curr_code", rs.getString("curr_code"));
					hdrMap.put("confirmed", rs.getString("confirmed"));
					hdrMap.put("exch_rate", rs.getString("exch_rate"));
					hdrMap.put("conf_date", rs.getTimestamp("conf_date"));
					hdrMap.put("emp_code__aprv", rs.getString("emp_code__aprv"));
					hdrMap.put("acct_code__ifr", rs.getString("acct_code__ifr"));
					hdrMap.put("cctr_code__ifr", rs.getString("cctr_code__ifr"));
					hdrMap.put("acct_code__ito", rs.getString("acct_code__ito"));
					hdrMap.put("cctr_code__ito", rs.getString("cctr_code__ito"));
					hdrMap.put("amount__bc", rs.getDouble("amount__bc"));
					hdrMap.put("tran_type", rs.getString("tran_type"));
					hdrMap.put("tran_ser", rs.getString("tran_ser"));
					hdrMap.put("tran_id__iss", rs.getString("tran_id__iss"));
					hdrMap.put("link_type", rs.getString("link_type"));
					hdrMap.put("remarks", rs.getString("remarks"));
					hdrMap.put("parent__tran_id", rs.getString("parent__tran_id"));
					hdrMap.put("rev__tran", rs.getString("rev__tran"));
					hdrMap.put("sundry_type", rs.getString("sundry_type"));
					hdrMap.put("sundry_code", rs.getString("sundry_code"));
					
					System.out.println("IBCA header tranSer----["+rs.getString("tran_ser")+"]");
				}
				if(rs!=null)
				{
					rs.close();rs= null;
				}
				if(pstmt!=null)
				{
					pstmt.close();pstmt= null;
				}
				
				sql =  " select tran_id,ref_ser,ref_no,ref_date,curr_code,exch_rate,cust_code,acct_code,cctr_code,due_date,tot_amt,discount,tax_amt,"
					 + " auto_rcp,bank_code,recd,ref_type,cr_term,sales_pers,item_ser,sales_pers__1,sales_pers__2,ref_ser__org,line_no__ref,gp_no,"
					 + " gp_date,cust_ref_no,cust_ref_date,cust_ref_amt,discount_dt "
					 + " from rcp_ibca_det where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,tranIDRcpIBCA);
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					detMap = new HashMap();
					detMap.put("tran_id", rs.getString("tran_id"));
					detMap.put("ref_ser", rs.getString("ref_ser"));
					detMap.put("ref_no", rs.getString("ref_no"));
					detMap.put("ref_date", rs.getTimestamp("ref_date"));
					detMap.put("curr_code", rs.getString("curr_code"));
					detMap.put("exch_rate", rs.getDouble("exch_rate"));
					detMap.put("cust_code", rs.getString("cust_code"));
					detMap.put("acct_code", rs.getString("acct_code"));
					detMap.put("cctr_code", rs.getString("cctr_code"));
					detMap.put("due_date", rs.getTimestamp("due_date"));
					detMap.put("tot_amt", rs.getDouble("tot_amt"));
					detMap.put("discount", rs.getDouble("discount"));
					detMap.put("tax_amt", rs.getDouble("tax_amt"));
					detMap.put("auto_rcp", rs.getString("auto_rcp"));
					detMap.put("bank_code", rs.getString("bank_code"));
					detMap.put("recd", rs.getString("recd"));
					detMap.put("cr_term", rs.getString("cr_term"));
					detMap.put("sales_pers", rs.getString("sales_pers"));
					detMap.put("item_ser", rs.getString("item_ser"));
					detMap.put("sales_pers__1", rs.getString("sales_pers__1"));
					detMap.put("sales_pers__2", rs.getString("sales_pers__2"));
					detMap.put("ref_ser__org", rs.getString("ref_ser__org"));
					detMap.put("line_no__ref", rs.getString("line_no__ref"));
					detMap.put("gp_no", rs.getString("gp_no"));
					detMap.put("gp_date", rs.getTimestamp("gp_date"));
					detMap.put("cust_ref_no", rs.getString("cust_ref_no"));
					detMap.put("cust_ref_date", rs.getString("cust_ref_date"));
					detMap.put("cust_ref_amt", rs.getString("cust_ref_amt"));
					detMap.put("discount_dt", rs.getString("discount_dt"));
					
					detailList.add(detMap);
				}
				if(rs!=null)
				{
					rs.close();rs= null;
				}
				if(pstmt!=null)
				{
					pstmt.close();pstmt= null;
				}
				
				//Need to verify the below code
				//if lds_hdr.retrieve(ls_tran_id[ll_cntr_hdr]) > 0 then
				if(hdrMap.size() > 0)//Need to change as per above code 
				{
					//lds_det.retrieve(ls_tran_id[ll_cntr_hdr])Need to change the code
					if("I".equals(gs_run_mode))
					{
						tranDate = (Timestamp) hdrMap.get("tran_date");
						winName = "W_RCP_IBCA";
						
						sql = " select ledg_post_conf from transetup where upper(tran_window) = ? ";
				        pstmt = conn.prepareStatement(sql);
				        pstmt.setString(1, winName);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							ledgPostConf = rs.getString("ledg_post_conf");
						}
						if(rs!=null)
						{
							rs.close();rs= null;
						}
						if(pstmt!=null)
						{
							pstmt.close();pstmt= null;
						}
						
						if("Y".equals(ledgPostConf))
						{
							if(tranDate != today)
							{	
								tranDate = today;
								
								sql = " update rcp_ibca set tran_date = ? where tran_id   = ? ";
								pstmt = conn.prepareStatement(sql);
								pstmt.setTimestamp(1, tranDate);
								pstmt.setString(2, tranIDRcpIBCA);
								pstmt.executeUpdate();
								if(pstmt!=null)
								{
									pstmt.close();pstmt = null;
								}
							}
							hdrMap.put("tran_date",tranDate);
						}
					}
					
					retString = gbf_post_ribca(hdrMap,detailList,xtraParams,conn);
					System.out.println("After gbf_post_ribca---->["+retString+"]");
					if(retString != null && retString.trim().length() > 0)
					{
						return retString;
					}
				}
				else
				{
					System.out.println("Unable to retreive header data");
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Expcetion inside gbf_retrieve_ribca ==>"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();rs= null;
				}
				if(pstmt!=null)
				{
					pstmt.close();pstmt= null;
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		return retString;
	}

	/**
	 * gbf_post_ribca --> postRibca
	 */
	public String gbf_post_ribca(Map hdrMap ,List detailList, String xtraParams , Connection conn) throws ITMException
	{
		String retString = "";
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		List<String> tranIDList = new ArrayList<String>();
		int cntHdr = 0,ediOption = 0;
		String tranIDRcpIBCA = "",winName = "",ledgPostConf = "";
		Timestamp tranDate = null,today = null;
		String tranId = "",tranSer = "",loginEmpCode = "",dataStr = "",confirmed = "",postOnline = "";
		Map expHdr = null;
		List expDetList = null;
		try
		{
			System.out.println("Inside gbf_post_ribca...");
			
			loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");

			sql = " select edi_option from transetup where tran_window = 'w_rcp_ibca' ";
	        pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				ediOption = rs.getInt("edi_option");
			}
			if(rs!=null)
			{
				rs.close();rs= null;
			}
			if(pstmt!=null)
			{
				pstmt.close();pstmt= null;
			}
			
			if(hdrMap.size() > 0)
			{
				if(detailList.size() > 0)
				{
					tranId = (String)hdrMap.get("tran_id");
					tranSer = checkNullAndTrim((String) hdrMap.get("tran_ser"));
					expHdr = hdrMap;
					expDetList = detailList;
					
					System.out.println("tranSer ["+tranSer.toUpperCase()+"]");
					
					//switch ( tranSer.toUpperCase() )
					{
						//case "I":
						if("I".equals(tranSer))
						{ 
							retString = postRibcaHdrIssue(expHdr, xtraParams ,conn);
							System.out.println("After postRibcaHdrIssue ["+retString+"]");
							if(retString.trim().length() == 0)
							{
								retString = postRibcaDetIssue(expHdr,expDetList,xtraParams, conn);
								System.out.println("After postRibcaDetIssue ["+retString+"]");
								if(retString.trim().length() == 0)
								{
									if("E".equals(hdrMap.get("link_type")) || "2".equals(ediOption))
									{
										if(ediOption > 0)
										{
											hdrMap.put("confirmed", "Y");
											hdrMap.put("conf_date", today);
											hdrMap.put("emp_code__aprv", loginEmpCode);
										}
										if(ediOption == 2)
										{
											CreateRCPXML createRCPXML = new CreateRCPXML("w_rcp_ibca", "tran_id");
							                dataStr = createRCPXML.getTranXML(tranId, conn);
							                System.out.println("dataStr =[ " + dataStr + "]");
							                Document ediDataDom = genericUtility.parseString(dataStr);

							                E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
							                retString = e12CreateBatchLoad.createBatchLoad(ediDataDom, "w_rcp_ibca" , "2", xtraParams, conn);
							                createRCPXML = null;
							                e12CreateBatchLoad = null;
							                
							                System.out.println("retString from edi 2 batchload gbf_post_ribca--->[" + retString + "]");
							                
							                if (retString != null && retString.indexOf("SUCCESS") != -1) 
											{
							                	retString = "";
											}
										}
										else
										{
											CreateRCPXML createRCPXML = new CreateRCPXML("w_rcp_ibca", "tran_id");
							                dataStr = createRCPXML.getTranXML(tranId, conn);
							                System.out.println("dataStr =[ " + dataStr + "]");
							                Document ediDataDom = genericUtility.parseString(dataStr);

							                E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
							                retString = e12CreateBatchLoad.createBatchLoad(ediDataDom, "w_rcp_ibca" , "0", xtraParams, conn);
							                createRCPXML = null;
							                e12CreateBatchLoad = null;
							                
							                System.out.println("retString from edi 2 batchload gbf_post_ribca--->[" + retString + "]");
							                
							                if (retString != null && retString.indexOf("SUCCESS") != -1) 
											{
							                	retString = "";
											}
										}
									}
								}
							}
						}
						//break;
						
						//case "R":
						else if("R".equals(tranSer))
						{ 
							retString = postRibcaHdrRcp(expHdr, conn);
							System.out.println("After postRibcaHdrRcp ["+retString+"]");		
							if(retString.trim().length() == 0)
							{
								if("E".equals(hdrMap.get("link_type")) || ediOption > 0)
								{
									if(ediOption > 0)
									{
										hdrMap.put("confirmed", "Y");
										hdrMap.put("conf_date", today);
										hdrMap.put("emp_code__aprv", loginEmpCode);
									}
									if(ediOption == 2)
									{
										CreateRCPXML createRCPXML = new CreateRCPXML("w_rcp_ibca", "tran_id");
						                dataStr = createRCPXML.getTranXML(tranId, conn);
						                System.out.println("dataStr =[ " + dataStr + "]");
						                Document ediDataDom = genericUtility.parseString(dataStr);

						                E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
						                retString = e12CreateBatchLoad.createBatchLoad(ediDataDom, "w_rcp_ibca" , "2", xtraParams, conn);
						                createRCPXML = null;
						                e12CreateBatchLoad = null;
						                
						                System.out.println("retString from edi 2 batchload gbf_post_ribca--->[" + retString + "]");
						                
						                if (retString != null && retString.indexOf("SUCCESS") != -1) 
										{
						                	retString = "";
										}
									}
									else
									{
										CreateRCPXML createRCPXML = new CreateRCPXML("w_rcp_ibca", "tran_id");
						                dataStr = createRCPXML.getTranXML(tranId, conn);
						                System.out.println("dataStr =[ " + dataStr + "]");
						                Document ediDataDom = genericUtility.parseString(dataStr);

						                E12CreateBatchLoadEjb e12CreateBatchLoad = new E12CreateBatchLoadEjb();
						                retString = e12CreateBatchLoad.createBatchLoad(ediDataDom, "w_rcp_ibca" , "2", xtraParams, conn);
						                createRCPXML = null;
						                e12CreateBatchLoad = null;
						                
						                System.out.println("retString from edi 2 batchload gbf_post_ribca--->[" + retString + "]");
						                
						                if (retString != null && retString.indexOf("SUCCESS") != -1) 
										{
						                	retString = "";
										}
									}
								}
							}
						}
						//break;
					}
					
					if (retString != null && retString.trim().length() > 0)
					{
						return retString;
					}
					
					System.out.println("Before POST_ON_LINE.....");
					
					postOnline = checkNullAndTrim(finCommon.getFinparams("999999", "POST_ON_LINE", conn));
					if("Y".equals(postOnline))
					{
						retString = finCommon.checkGlTranDrCr("R-IBCA", tranId, conn);
					}
					
					if(retString.trim().length() == 0)
					{
						confirmed = (String) hdrMap.get("confirmed");
						
						sql = " update rcp_ibca set confirmed = 'Y', conf_date = ?, emp_code__aprv = ? where tran_id = ? ";
						pstmt = conn.prepareStatement(sql);
						pstmt.setTimestamp(1, tranDate);
						pstmt.setString(2, loginEmpCode);
						pstmt.setString(3, tranId);
						pstmt.executeUpdate();
						if(pstmt!=null)
						{
							pstmt.close();pstmt= null;
						}
					}
				}
			}
		}
		catch(Exception e)
		{
			System.out.println("Expcetion inside gbf_post_ribca ==>"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();rs= null;
				}
				if(pstmt!=null)
				{
					pstmt.close();pstmt= null;
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		return retString;
	}
	
	/**
	 * gbf_post_ribca_hdr_iss --> postRibcaHdrIssue
	 */
	public String postRibcaHdrIssue(Map hdrMap, String xtraParams , Connection conn) throws ITMException
	{
		String retString = "";
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String linkType = "";
		Map glTraceMap = null;
		String tranId = "";
		try
		{
			linkType = (String) hdrMap.get("link_type");
			
			System.out.println("Inside gbf_post_ribca_hdr_iss-----LinkType["+linkType+"]");
			
			if(!"R".equals(linkType) && !"C".equals(linkType))
			{
				System.out.println("Inside if.....");
				
				glTraceMap = new HashMap();
				glTraceMap.put("ref_type", "F");
				glTraceMap.put("ref_ser", "R-IBCA");
				glTraceMap.put("ref_id", hdrMap.get("tran_id"));
				glTraceMap.put("tran_date", hdrMap.get("tran_date"));
				glTraceMap.put("eff_date", hdrMap.get("eff_date"));
				glTraceMap.put("fin_entity", hdrMap.get("fin_entity__from"));
				glTraceMap.put("site_code", hdrMap.get("site_code__from"));
				glTraceMap.put("sundry_type","O");
				glTraceMap.put("sundry_code"," ");
				glTraceMap.put("acct_code", hdrMap.get("acct_code__ifr"));
				glTraceMap.put("cctr_code", hdrMap.get("cctr_code__ifr"));
				glTraceMap.put("emp_code","");
				glTraceMap.put("anal_code","");
				glTraceMap.put("curr_code", hdrMap.get("curr_code"));
				glTraceMap.put("exch_rate", hdrMap.get("exch_rate"));
				
				if((Double)hdrMap.get("amount") > 0)
				{
					glTraceMap.put("dr_amt", hdrMap.get("amount"));
					glTraceMap.put("cr_amt", 0.0);
				}
				else
				{
					//glTraceMap.put("cr_amt", hdrMap.get("amount"));
					glTraceMap.put("cr_amt", 0 - (Double) hdrMap.get("amount"));
					glTraceMap.put("dr_amt", 0.0);
				}
				
				glTraceMap.put("remarks", hdrMap.get("remarks"));
				
				retString = finCommon.glTraceUpdate((HashMap) glTraceMap, conn);
				System.out.println("After glTraceUpdate gbf_post_ribca_hdr_iss---->["+retString+"]");
				
				if(retString != null && retString.trim().length() > 0)
				{
					return retString;
				}
			}
			
			linkType = linkType.trim();
			
			//switch(linkType)
			{
				//case "A":
				if("A".equals(linkType))
				{
					retString = postRibcaHdrRcp(hdrMap,conn);
				}
				//break;
				
				//case "P":
				else if("P".equals(linkType))
				{
					tranId = (String)glTraceMap.get("ref_id");
					retString = createRibca (tranId, tranId, xtraParams , conn);
				}
				//break;
				
				//case "R":
				else if("R".equals(linkType))
				{
					retString = postRibcaHdrRcp(hdrMap,conn);
				}
				//break;
				
				//case "C":
				else if("C".equals(linkType))
				{
					retString = postRibcaHdrRcp(hdrMap,conn);
				}
				//break;
			}
		
			if(retString != null && retString.trim().length() > 0)
			{
				return retString;
			}
		}
		catch(Exception e)
		{
			System.out.println("Expcetion inside gbf_post_ribca_hdr_iss ==>"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();rs= null;
				}
				if(pstmt!=null)
				{
					pstmt.close();pstmt= null;
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		return retString;
	}
	
	/**
	 * gbf_post_ribca_det_iss --> postRibcaDetIssue
	 */
	public String postRibcaDetIssue(Map hdrMap, List expDetList, String xtraParams, Connection conn) throws ITMException
	{
		String retString = "";
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Map glTraceMap = null;
		String linkType = "",tranId = "",tranType = "",siteCodeFrom = "",refNo = "",refSer = "",lineNoref = "",siteCode = "",remarks = "",status = "";
		String finEntity = ""; 
		Timestamp tranDate = null,effDate = null,today = null;
		double amount = 0,totAmount = 0, adjAmount = 0;
		Map sundryMap = null;
		try
		{
			System.out.println("Inside gbf_post_ribca_det_iss-----expDetList Size["+expDetList.size()+"]");
			
			today = new java.sql.Timestamp(System.currentTimeMillis()) ; 
			
			linkType = (String)hdrMap.get("link_type");
			tranId = (String) hdrMap.get("tran_id");
			tranType = (String) hdrMap.get("tran_type");
			tranDate = (Timestamp) hdrMap.get("tran_date");
			effDate =  (Timestamp) hdrMap.get("eff_date");
			finEntity = (String) hdrMap.get("fin_entity__from");
			siteCode = (String)hdrMap.get("site_code__from");
			
			for(int i =0; i< expDetList.size(); i++)
			{
				HashMap detMap = (HashMap) expDetList.get(i);
				
				amount = (Double)detMap.get("tot_amt");
				refNo = (String)detMap.get("ref_no");
				refSer = (String)detMap.get("ref_ser");
				lineNoref = (String)detMap.get("line_no__ref");
				
				System.out.println("@@postRibcaDetIssue Link Type["+linkType+"]");
				
				if(!"R".equals(linkType) && !"C".equals(linkType))
				{
					glTraceMap = new HashMap();
					glTraceMap.put("ref_id", tranId);
					glTraceMap.put("ref_type", "F");
					glTraceMap.put("ref_ser", "R-IBCA");
					glTraceMap.put("tran_date", tranDate);
					glTraceMap.put("eff_date", effDate);
					glTraceMap.put("fin_entity", finEntity);
					glTraceMap.put("site_code", siteCode);
					glTraceMap.put("sundry_type","C");
					glTraceMap.put("sundry_code",detMap.get("cust_code"));
					glTraceMap.put("acct_code", detMap.get("acct_code"));
					glTraceMap.put("cctr_code", detMap.get("cctr_code"));
					glTraceMap.put("emp_code", "");
					glTraceMap.put("anal_code", "");
					glTraceMap.put("curr_code", detMap.get("curr_code"));
					glTraceMap.put("exch_rate", (Double) detMap.get("exch_rate"));
					
					if(amount > 0)
					{
						glTraceMap.put("dr_amt", 0.0);
						glTraceMap.put("cr_amt", amount);
					}
					else
					{
						glTraceMap.put("dr_amt", 0- amount);
						glTraceMap.put("cr_amt", 0.0);
					}
					
					remarks = ((String)hdrMap.get("remarks")).trim();
					if(remarks.length() > 40)
					{
						remarks = remarks.substring(0,40);
					}
					
					remarks	   = remarks+' '+refSer.trim()+':'+refNo.trim();
					glTraceMap.put("remarks", detMap.get("remarks"));
					glTraceMap.put("party_doc_ref", finCommon.gfGetPartyDocRef(refSer, tranId, conn));
					
					sundryMap = new HashMap();
					sundryMap.put("tran_date", tranDate);
					sundryMap.put("eff_date", effDate);
					sundryMap.put("fin_entity", finEntity);
					sundryMap.put("site_code", siteCode);
					sundryMap.put("sundry_type", "C");
					sundryMap.put("sundry_code", glTraceMap.get("sundry_code"));
					sundryMap.put("acct_code", glTraceMap.get("acct_code"));
					sundryMap.put("cctr_code", glTraceMap.get("cctr_code"));
					sundryMap.put("curr_code", glTraceMap.get("curr_code"));
					sundryMap.put("exch_rate", (Double)glTraceMap.get("exch_rate"));
					sundryMap.put("dr_amt", (Double) glTraceMap.get("dr_amt"));
					sundryMap.put("cr_amt", (Double) glTraceMap.get("cr_amt"));
					sundryMap.put("adv_amt", 0.0);
					
					retString = finCommon.gbf_sundrybal_upd((HashMap) sundryMap, conn);
					System.out.println("After postRibcaDetIssue gbf_sundrybal_upd retString["+retString+"]");
					
					if(retString.trim().length() == 0)
					{
						retString = finCommon.glTraceUpdate((HashMap) glTraceMap, conn);
						System.out.println("After postRibcaDetIssue glTraceUpdate retString["+retString+"]");
					}
				}
				
				System.out.println("After postRibcaDetIssue linkType !R && !C");
				
				if ("db2".equalsIgnoreCase(CommonConstants.DB_NAME ))
				{
					sql = " SELECT tot_amt, adj_amt FROM receivables WHERE tran_ser = ? and ref_no = ? and line_no__ref = ? for update ";
				}

				else if ( "mssql".equalsIgnoreCase(CommonConstants.DB_NAME ))
				{
					sql = " SELECT tot_amt, adj_amt FROM receivables (updlock) WHERE tran_ser = ? and ref_no = ? and line_no__ref = ? for update ";
				}
				else
				{
					sql = " SELECT tot_amt, adj_amt FROM receivables WHERE tran_ser = ? and ref_no = ? and line_no__ref = ? for update nowait ";
				}
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,refSer);
				pstmt.setString(2,refNo);
				pstmt.setString(3,lineNoref);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					totAmount = rs.getDouble("tot_amt");
					adjAmount = rs.getDouble("adj_amt");
				}
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
				
				System.out.println("postRibcaDetIssue----totAmount["+totAmount+"] adjAmount["+adjAmount+"] amount["+amount+"]");
				if(Math.abs(totAmount - adjAmount) < Math.abs(amount) || (totAmount - adjAmount) == 0)
				{
					//retString = "VTBAL1";
					retString = itmDBAccessEJB.getErrorString("","VTBAL1","","",conn);
					return retString;
				}
				
				adjAmount = adjAmount + amount;
				if(totAmount == adjAmount)
				{
					status = "A";
				}
				else
				{
					status = "P";
				}

				sql = " update receivables set adj_amt = adj_amt + ?, status = ?, stat_date = ? "
					+ " where tran_ser = ? and ref_no = ? and line_no__ref = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setDouble(1, amount);
				pstmt.setString(2, status);
				pstmt.setTimestamp(3, today);
				pstmt.setString(4, refSer);
				pstmt.setString(5, refNo);
				pstmt.setString(6, lineNoref);
				pstmt.executeUpdate();
				if(pstmt!=null)
				{
					pstmt.close();pstmt= null;
				}
			}
			
			System.out.println("postRibcaDetIssue retString["+retString+"]");
			if(retString != null && retString.trim().length() > 0)
			{
				return retString;
			}
			
			//switch(linkType)
			{
				//case "A" :
				if("A".equals(linkType))
				{	
					retString = postRibcaDetRcp(hdrMap, expDetList, xtraParams, conn);
				}
				//break;
				//case "R" :
				else if("R".equals(linkType))
				{	
					retString = postRibcaDetRcp(hdrMap, expDetList, xtraParams, conn);
				}	
				//break;
				//case "C" :
				else if("C".equals(linkType))
				{	
					retString = postRibcaDetRcp(hdrMap, expDetList, xtraParams, conn);
				}
				//break;
			}
		}
		catch(Exception e)
		{
			System.out.println("Expcetion inside gbf_post_ribca_det_iss ==>"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();rs= null;
				}
				if(pstmt!=null)
				{
					pstmt.close();pstmt= null;
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		return retString;
	}
	
	/**
	 * gbf_create_ribca --> createRibca
	 */
	public String createRibca(String tranIdFr,String tranIdTo ,String xtraParams, Connection conn) throws ITMException
	{
		String retString = "";
		String sql = "";
		PreparedStatement pstmt = null,pstmtHdr = null,pstmtDet = null;
		ResultSet rs = null;
		Map detMap = null;
		String linkType = "",tranType = "",siteCodeFrom = "",refNo = "",refSer = "",lineNoref = "",chgUser = "",chgTerm = "",
			   siteCode = "",remarks = "",status = "",keyStr = "",tranID = "",tranIDIbca = "",newTranId = "",siteCodeTo = "",
			   finEntFrom = "",finEntTo = "",ibcaConf = "";
		int finEntity = 0,count = 0; 
		Timestamp tranDate = null,effDate = null,today = null;
		List tranIDList = new ArrayList();
		
		try
		{
			System.out.println("Inside gbf_create_ribca-----tranIdFrom["+tranIdTo+"] tranIdTo["+tranIdTo+"] ");
			
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"userId");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams,"termId");
			
			 sql = " insert into rcp_ibca (tran_id,tran_date,eff_date,site_code__from,fin_entity__from,site_code__to,fin_entity__to, "
				  +" amount,curr_code,confirmed,exch_rate,conf_date,acct_code__ifr,cctr_code__ifr,acct_code__ito,cctr_code__ito, "
				  +" chg_date,chg_user,chg_term,add_date,add_user,add_term,amount__bc,tran_type,tran_ser,tran_id__iss,link_type,remarks, "
				  +" rev__tran,sundry_type,sundry_code ) " //31
				  +" values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			pstmtHdr = conn.prepareStatement(sql);
			
			 sql = " insert into rcp_ibca_det ( tran_id,ref_ser,ref_no,ref_date,curr_code,acct_code,cctr_code,due_date,tot_amt,discount,tax_amt,"
				  +" auto_rcp,bank_code,ref_type,cr_term,sales_pers,exch_rate,ref_ser__org)" //18
				  +" values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
			pstmtDet = conn.prepareStatement(sql);
			
			sql = " select key_string from transetup where upper(tran_window) = 'W_RCP_IBCA' ";
			pstmt = conn.prepareStatement(sql);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				keyStr = rs.getString("key_string");
			}
			else
			{
				if(rs!=null)
				{	
					rs.close();rs = null;
				}
				if(pstmt!=null)
				{	
					pstmt.close();pstmt = null;
				}
				
				sql = " select key_string from transetup where upper(tran_window) = 'GENERAL' ";
				pstmt = conn.prepareStatement(sql);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					keyStr = rs.getString("key_string");
				}
				if(rs!=null)
				{	
					rs.close();rs = null;
				}
				if(pstmt!=null)
				{	
					pstmt.close();pstmt = null;
				}
			}
			if(rs!=null)
			{	
				rs.close();rs = null;
			}
			if(pstmt!=null)
			{	
				pstmt.close();pstmt = null;
			}
			
			sql = " select tran_id from rcp_ibca where tran_id >= ? and tran_id <= ? and upper(confirmed) <> 'Y' ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranIdFr);
			pstmt.setString(2, tranIdTo);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				tranIDIbca = rs.getString("tran_id");
				
				if(tranIDIbca != null)
				{	
					tranIDList.add(tranIDIbca);
				}	
			}
			if(rs!=null)
			{	
				rs.close();rs = null;
			}
			if(pstmt!=null)
			{	
				pstmt.close();pstmt = null;
			}
			
			for(int i=0;i < tranIDList.size() ; i++)	
			{
				sql =  " select tran_id,tran_date,eff_date,site_code__from,fin_entity__from,site_code__to,fin_entity__to, "
					  +" amount,curr_code,confirmed,exch_rate,conf_date,emp_code__aprv,acct_code__ifr,cctr_code__ifr,acct_code__ito,cctr_code__ito, "
					  +" chg_date,chg_user,chg_term,add_date,add_user,add_term,amount__bc,tran_type,tran_ser,tran_id__iss,link_type,remarks, "
					  +" parent__tran_id,rev__tran,sundry_type,sundry_code "
					  +" from rcp_ibca WHERE tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,(String)tranIDList.get(i));
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					today = new java.sql.Timestamp(System.currentTimeMillis()) ;
					SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getDBDateFormat());
					tranDate = java.sql.Timestamp.valueOf(sdf.format(today) + " 00:00:00.000");
					
					sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
					
					String xmlValues = "";
					xmlValues ="<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
					xmlValues = xmlValues + "<Header></Header>";
					xmlValues = xmlValues + "<Detail1>";
					xmlValues = xmlValues +	"<tran_id/>";
					xmlValues = xmlValues + "<site_code__from>" + rs.getString("site_code__from") + "</site_code__from>";
					xmlValues = xmlValues + "<site_code__to>" + rs.getString("site_code__to") + "</site_code__to>";
					xmlValues = xmlValues + "<tran_date>"+ sdf.format(tranDate) + "</tran_date>";
					xmlValues = xmlValues + "<tran_ser>R</tran_ser>";
					xmlValues = xmlValues + "<link_type>R</link_type>";
					xmlValues = xmlValues + "</Detail1></Root>";
					
					TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE", CommonConstants.DB_NAME);
					newTranId = tg.generateTranSeqID("R-IBCA", "tran_id", keyStr, conn);
					
					tranType = rs.getString("tran_ser");
					linkType = rs.getString("link_type");
					siteCodeFrom = rs.getString("site_code__from");
					siteCodeTo 	= rs.getString("site_code__to");
					finEntFrom	= rs.getString("fin_entity__from");
					finEntTo = rs.getString("fin_entity__to");
					
					pstmtHdr.clearParameters();
					
					pstmtHdr.setString(1,newTranId);
					pstmtHdr.setTimestamp(2,tranDate);
					pstmtHdr.setTimestamp(3,rs.getTimestamp("eff_date"));
					pstmtHdr.setString(4,rs.getString("site_code__from"));
					pstmtHdr.setString(5,rs.getString("fin_entity__from"));
					pstmtHdr.setString(6,rs.getString("site_code__to"));
					pstmtHdr.setString(7,rs.getString("fin_entity__to"));
					pstmtHdr.setDouble(8,rs.getDouble("amount"));
					pstmtHdr.setString(9,rs.getString("curr_code"));
					pstmtHdr.setString(10, "N");
					pstmtHdr.setString(11,rs.getString("exch_rate"));
					pstmtHdr.setString(12,rs.getString("conf_date"));
					pstmtHdr.setString(13,rs.getString("acct_code__ifr"));
					pstmtHdr.setString(14,rs.getString("cctr_code__ifr"));
					pstmtHdr.setString(15,rs.getString("acct_code__ito"));
					pstmtHdr.setString(16,rs.getString("cctr_code__ito"));
					pstmtHdr.setTimestamp(17,today);
					pstmtHdr.setString(18,chgUser);
					pstmtHdr.setString(19,chgTerm);
					pstmtHdr.setTimestamp(20,today);
					pstmtHdr.setString(21,chgUser);
					pstmtHdr.setString(22,chgTerm);
					pstmtHdr.setDouble(23,rs.getDouble("amount__bc"));
					pstmtHdr.setString(24,rs.getString("tran_type"));
					pstmtHdr.setString(25,"R");
					pstmtHdr.setString(26,(String) tranIDList.get(i));
					pstmtHdr.setString(27,rs.getString("link_type"));
					pstmtHdr.setString(28,rs.getString("remarks"));
					pstmtHdr.setString(30,rs.getString("sundry_type"));
					pstmtHdr.setString(31,rs.getString("sundry_code"));
					count = pstmtHdr.executeUpdate();
					
					if(pstmtHdr!=null)
					{
						pstmtHdr.close();pstmtHdr=null;
					}
				}
				if(rs!=null)
				{	
					rs.close();rs = null;
				}
				if(pstmt!=null)
				{	
					pstmt.close();pstmt = null;
				}
				
				sql = " select tran_id,ref_ser,ref_no,ref_date,curr_code,acct_code,cctr_code,due_date,tot_amt,discount,tax_amt,"
					 +" auto_rcp,bank_code,ref_type,cr_term,sales_pers,item_ser,sales_pers__1,sales_pers__2,ref_ser__org,line_no__ref,gp_no,"
					 +" gp_date,cust_ref_no,cust_ref_date,cust_ref_amt,discount_dt  " 
					 +" from rcp_ibca where tran_id = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,(String) tranIDList.get(i));
				rs = pstmt.executeQuery();
				while(rs.next())
				{
					pstmtDet.clearParameters();
					pstmtDet.setString(1,newTranId);
					pstmtDet.setString(2,rs.getString("ref_ser"));
					pstmtDet.setString(3,rs.getString("ref_no"));
					pstmtDet.setTimestamp(4,rs.getTimestamp("ref_date"));
					pstmtDet.setString(5,rs.getString("curr_code"));
					pstmtDet.setString(6,rs.getString("acct_code"));
					pstmtDet.setString(7,rs.getString("cctr_code"));
					pstmtDet.setTimestamp(8,rs.getTimestamp("due_date"));
					pstmtDet.setDouble(9,rs.getDouble("tot_amt"));
					pstmtDet.setDouble(10,rs.getDouble("discount"));
					pstmtDet.setDouble(11,rs.getDouble("tax_amt"));
					pstmtDet.setString(12,rs.getString("auto_rcp"));
					pstmtDet.setString(13,rs.getString("bank_code"));
					pstmtDet.setString(14,rs.getString("ref_type"));
					pstmtDet.setString(15,rs.getString("cr_term"));
					pstmtDet.setString(16,rs.getString("sales_pers"));
					pstmtDet.setDouble(17,rs.getDouble("exch_rate"));
					pstmtDet.setString(18,rs.getString("ref_ser__org"));
					pstmtDet.addBatch();
					pstmtDet.clearParameters();
				}
				pstmtDet.executeBatch();
				if(rs!=null)
				{
					rs.close();rs=null;
				}
				if(pstmtDet!=null)
				{
					pstmtDet.close();pstmtDet=null;
				}
				
				sql = " select 	case when auto_confirm is null then 'N' else auto_confirm end "
						+ " from ibca_rcp_ctrl "
						+ " where  site_code__from   = ? "
						+ " and    site_code__to     = ? "
						+ " and    fin_entity__from  = ? "
						+ "	and    fin_entity__to    = ? "
						+ " and    link_type         = 'P' " ;
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1,siteCodeFrom);
					pstmt.setString(2,siteCodeTo);
					pstmt.setString(3,finEntFrom);
					pstmt.setString(4,finEntTo);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						ibcaConf = rs.getString(1);
					}
					else
					{
						ibcaConf = "N";
					}
					if(rs!=null)
					{
						rs.close();rs=null;
					}
					if(pstmt!=null)
					{
						pstmt.close();pstmt=null;
					}
					if ("Y".equals(ibcaConf))
					{
						retString = retreiveRibca(newTranId , siteCode , xtraParams, conn);
						
						if(retString != null && retString.trim().length() > 0)
						{
							return retString;
						}
					}
			}
			if(pstmtDet!=null)
			{
				pstmtDet.close();pstmtDet=null;
			}
			if(pstmtHdr!=null)
			{
				pstmtHdr.close();pstmtHdr=null;
			}
		}
		catch(Exception e)
		{
			System.out.println("Expcetion inside gbf_create_ribca ==>"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();rs= null;
				}
				if(pstmt!=null)
				{
					pstmt.close();pstmt= null;
				}
				if(pstmtDet!=null)
				{
					pstmtDet.close();pstmtDet=null;
				}
				if(pstmtHdr!=null)
				{
					pstmtHdr.close();pstmtHdr=null;
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		return retString;
	}
	
	/**
	 * gbf_post_ribca_hdr_rcp --> postRibcaHdrRcp
	 */
	public String postRibcaHdrRcp(Map hdrMap, Connection conn) throws ITMException
	{
		String retString = "";
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Map glTraceMap = null;
		
		try
		{
			System.out.println("Inside gbf_post_ribca_hdr_rcp...");
			
			glTraceMap = new HashMap();
			glTraceMap.put("ref_type", "F");
			glTraceMap.put("ref_ser", "R-IBCA");
			glTraceMap.put("ref_id", hdrMap.get("tran_id"));
			glTraceMap.put("tran_date", hdrMap.get("tran_date"));
			glTraceMap.put("eff_date", hdrMap.get("eff_date"));
			glTraceMap.put("fin_entity", hdrMap.get("fin_entity__to"));
			glTraceMap.put("site_code", hdrMap.get("site_code__to"));
			glTraceMap.put("sundry_type","O");
			glTraceMap.put("sundry_code"," ");
			glTraceMap.put("acct_code", hdrMap.get("acct_code__ito"));
			glTraceMap.put("cctr_code", hdrMap.get("cctr_code__ito"));
			glTraceMap.put("anal_code", "");
			glTraceMap.put("emp_code", "");
			glTraceMap.put("curr_code", hdrMap.get("curr_code"));
			glTraceMap.put("exch_rate", hdrMap.get("exch_rate"));
			
			if((Double)hdrMap.get("amount") > 0)
			{
				glTraceMap.put("dr_amt", "0");
				glTraceMap.put("cr_amt", hdrMap.get("amount"));
			}
			else
			{
				glTraceMap.put("dr_amt", 0 - (Double) hdrMap.get("amount"));
				glTraceMap.put("cr_amt", "0");
			}
			
			glTraceMap.put("remarks", hdrMap.get("remarks"));
			
			retString = finCommon.glTraceUpdate((HashMap) glTraceMap, conn);
			System.out.println("After glTraceUpdate gbf_post_ribca_hdr_rcp---->["+retString+"]");
			
			if(retString != null && retString.trim().length() > 0)
			{
				return retString;
			}
		}
		catch(Exception e)
		{
			System.out.println("Expcetion inside gbf_post_ribca_hdr_rcp ==>"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();rs= null;
				}
				if(pstmt!=null)
				{
					pstmt.close();pstmt= null;
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		return retString;
	}
	
	/**
	 * gbf_post_ribca_det_rcp --> postRibcaDetRcp
	 */
	public String postRibcaDetRcp(Map hdrMap, List expDetList, String xtraParams, Connection conn) throws ITMException
	{
		String retString = "";
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		Map glTraceMap = null;
		String finEntityTo = "";
		String tranId = "",tranType = "",siteCodeTo = "",remarks = "",refSer = "",refNo = "";
		Timestamp tranDate = null,effDate = null;
		int count = 0;
		Map detMap = null,sundryBalMap = null,recvbleMap = null;
		double amount = 0;
		
		try
		{
			System.out.println("Inside gbf_post_ribca_det_rcp...");
			
			tranId = (String)hdrMap.get("tran_id");
			tranType = (String)hdrMap.get("tran_type");
			tranDate = (Timestamp)hdrMap.get("tran_date");
			effDate = (Timestamp)hdrMap.get("eff_date");
			finEntityTo = (String)hdrMap.get("fin_entity__to");
			siteCodeTo = (String)hdrMap.get("site_code__to");
			
			for(int i=0; i < expDetList.size(); i++)
			{
				detMap = (HashMap) expDetList.get(i);
				
				glTraceMap = new HashMap();
				glTraceMap.put("ref_id",tranId);
				glTraceMap.put("ref_type","F");
				glTraceMap.put("ref_ser", "R-IBCA");
				glTraceMap.put("tran_date", tranDate);
				glTraceMap.put("eff_date", effDate);
				glTraceMap.put("fin_entity", finEntityTo);
				glTraceMap.put("site_code", siteCodeTo);
				glTraceMap.put("sundry_type", "C");
				glTraceMap.put("sundry_code", (String)detMap.get("cust_code"));
				glTraceMap.put("acct_code", (String)detMap.get("acct_code"));
				glTraceMap.put("cctr_code", (String)detMap.get("cctr_code"));
				glTraceMap.put("emp_code", "");
				glTraceMap.put("anal_code", "");
				glTraceMap.put("curr_code", (String)detMap.get("curr_code"));
				glTraceMap.put("exch_rate", (Double) detMap.get("exch_rate"));
				
				amount = (Double)detMap.get("tot_amt");
				System.out.println("@@tot_amt ["+amount+"]");
				
				if(amount > 0)
				{
					glTraceMap.put("dr_amt",amount);
					glTraceMap.put("cr_amt",0.0);
				}
				else
				{
					glTraceMap.put("dr_amt",0.0);
					glTraceMap.put("cr_amt",0-amount);
				}
				
				refSer = (String) detMap.get("ref_no");
				refNo = (String) detMap.get("ref_ser");
				
				remarks = ((String)hdrMap.get("remarks")).trim();
				if(remarks.length() > 40)
				{
					remarks = remarks.substring(0,40);
				}
				
				remarks	   = remarks+' '+refSer.trim()+':'+refNo.trim();
				glTraceMap.put("remarks", detMap.get("remarks"));
				glTraceMap.put("party_doc_ref", finCommon.gfGetPartyDocRef(refSer, refNo, conn));
				
				sundryBalMap = new HashMap();
				sundryBalMap.put("tran_date",tranDate);
				sundryBalMap.put("eff_date",effDate);
				sundryBalMap.put("fin_entity", finEntityTo);
				sundryBalMap.put("site_code", siteCodeTo);
				sundryBalMap.put("sundry_type", "C");
				sundryBalMap.put("sundry_code",(String)glTraceMap.get("sundry_code"));
				sundryBalMap.put("acct_code", (String)glTraceMap.get("acct_code"));
				sundryBalMap.put("cctr_code", (String)glTraceMap.get("cctr_code"));
				sundryBalMap.put("curr_code", (String)glTraceMap.get("curr_code"));
				sundryBalMap.put("exch_rate", (Double)glTraceMap.get("exch_rate"));
				sundryBalMap.put("dr_amt", (Double)glTraceMap.get("dr_amt"));
				sundryBalMap.put("cr_amt", (Double)glTraceMap.get("cr_amt"));
				sundryBalMap.put("adv_amt", 0.0);
				
				refNo = (String)detMap.get("ref_no");
				
				sql = " select count(*) from receivables where tran_ser like 'R-IBC%' and ref_no = ? ";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, refNo);
				rs = pstmt.executeQuery();
				if(rs.next())
				{
					count = rs.getInt(1);
				}
				if(rs!=null)
				{
					rs.close();rs = null;
				}
				if(pstmt!=null)
				{
					pstmt.close();pstmt = null;
				}
				
				if(count == 0)
				{
					refSer = "R-IBCA";
				}
				else
				{
					refSer = "R-IBCA"+count;
				}
				
				recvbleMap = new HashMap();
				recvbleMap.put("tran_ser",refSer);
				recvbleMap.put("tran_date",tranDate);
				recvbleMap.put("eff_date",effDate);
				recvbleMap.put("fin_entity", finEntityTo);
				recvbleMap.put("site_code", siteCodeTo);
				recvbleMap.put("ref_no", detMap.get("ref_no"));
				recvbleMap.put("ref_date", detMap.get("ref_date"));
				recvbleMap.put("due_date", detMap.get("due_date"));
				recvbleMap.put("curr_code", (String)glTraceMap.get("curr_code"));
				recvbleMap.put("exch_rate", (Double)glTraceMap.get("exch_rate"));
				recvbleMap.put("cust_code", (String)detMap.get("cust_code"));
				recvbleMap.put("acct_code", (String)glTraceMap.get("acct_code"));
				recvbleMap.put("cctr_code", (String)glTraceMap.get("cctr_code"));
				recvbleMap.put("tax_amt", (Double)detMap.get("tax_amt"));
				recvbleMap.put("discount", (Double)detMap.get("discount"));
				recvbleMap.put("tot_amt", (Double)detMap.get("tot_amt"));
				recvbleMap.put("auto_rcp", (String)detMap.get("auto_rcp"));
				recvbleMap.put("bank_code", (String)detMap.get("bank_code"));
				recvbleMap.put("ref_type", (String)detMap.get("ref_type"));
				recvbleMap.put("cr_term", (String)detMap.get("cr_term"));
				recvbleMap.put("item_ser", (String)detMap.get("item_ser"));
				recvbleMap.put("sales_pers", (String)detMap.get("sales_pers"));
				recvbleMap.put("ref_ser__org", (String)detMap.get("ref_ser__org"));
				recvbleMap.put("gp_no", (String)detMap.get("gp_no"));
				recvbleMap.put("gp_date", (Timestamp)detMap.get("gp_date"));
				recvbleMap.put("cust_ref_no", (String)detMap.get("cust_ref_no"));
				recvbleMap.put("cust_ref_date", (String)detMap.get("cust_ref_date"));
				recvbleMap.put("cust_ref_amt", (String)detMap.get("cust_ref_amt"));
				recvbleMap.put("discount_date", (String)detMap.get("discount_dt"));
				recvbleMap.put("mrp_value", 0.0);
				
				
				retString = finCommon.gbf_sundrybal_upd((HashMap) sundryBalMap, conn);
				System.out.println("After postRibcaDetRcp gbf_sundrybal_upd retStrng["+retString+"]");
				
				if(retString.trim().length() == 0)
				{
					retString = finCommon.glTraceUpdate((HashMap) glTraceMap, conn);
					System.out.println("After postRibcaDetRcp glTraceUpdate retStrng["+retString+"]");
					
					if(retString.trim().length() == 0)
					{
						retString = finCommon.gbfReceivablesUpd((HashMap) recvbleMap, conn);
						System.out.println("After postRibcaDetRcp gbfReceivablesUpd retStrng["+retString+"]");
						
						if(retString != null && retString.trim().length() > 0)
						{
							return retString;
						}
					}
				}
			}	
		}
		catch(Exception e)
		{
			System.out.println("Expcetion inside gbf_post_ribca_det_rcp ==>"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(rs!=null)
				{
					rs.close();rs= null;
				}
				if(pstmt!=null)
				{
					pstmt.close();pstmt= null;
				}
			}
			catch(Exception ex)
			{
				ex.printStackTrace();
			}
		}
		return retString;
	}
	
	public String checkNullAndTrim( String inputVal )
	{
		if ( inputVal == null )
		{
			inputVal = "";
		}
		else
		{
			inputVal = inputVal.trim();
		}
		return inputVal;
	}
	
}
