package ibase.dashboard.sfa.servlet;

import ibase.dashboard.sfa.ejb.ComplianceDB2Remote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;

import java.io.IOException;
import java.io.OutputStream;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.json.simple.JSONObject;

public class ComplDayWiseSummaryServlet extends HttpServlet {
	private static final long serialVersionUID = 1L;

    public ComplDayWiseSummaryServlet() {
    }

	protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
		doPost(request, response);
	}

	protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {


		ComplianceDB2Remote complMtdDtlSummary = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		String dataSourceName = "";
		String loginUser ="";
		String salePerson = "";
		String toDate = "";
		String fromDate = "";
		try
		{
			response.setContentType("application/xml");

			ibase.utility.UserInfoBean userInfo = (ibase.utility.UserInfoBean) request.getSession().getAttribute("USER_INFO");
			
			if(userInfo != null)
			{
				loginUser = userInfo.getLoginCode();
			}
			
			dataSourceName = request.getParameter("dataSourceName");
			salePerson = (request.getParameter("empCode"));
			fromDate = (request.getParameter("fromDate"));
			toDate = (request.getParameter("toDate"));
			System.out.println("salePerson :"+salePerson+" toDate : "+toDate+" fromDate : "+fromDate);
			if(salePerson.length()== 0)
			{
				salePerson = loginUser;
			}
			context = new InitialContext(appConnectParm.getProperty());
			complMtdDtlSummary = (ComplianceDB2Remote) context.lookup("ibase/ComplianceDB2/remote");
			JSONObject jsonObjData = (JSONObject) complMtdDtlSummary.getComplDayWiseSummary(dataSourceName, fromDate, toDate, salePerson);
			OutputStream outputStream   = response.getOutputStream();
		    outputStream.write(jsonObjData.toString().getBytes());
			outputStream.flush();
			outputStream.close();
			System.out.println("Final data set for ComplDayWiseSummaryServlet build the Graph is===" + jsonObjData);

		} catch (Exception e)
		{
			System.out.println("Exception : ComplDayWiseSummaryServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}

}
