/********************************************************
	Title 	 : 	ConsumptionOdrIssuWizPos[D15BSUN017]
	Date  	 : 	22/JUN/15
	Developer:  VALLABH KADAM.

 ********************************************************/
package ibase.webitm.ejb.mfg;

import ibase.system.config.*;
import ibase.webitm.ejb.*;
import ibase.webitm.utility.ITMException;
import ibase.utility.E12GenericUtility;
//import ibase.webitm.ejb.dis.adv.GenericUtility;
import ibase.webitm.ejb.sys_UTL.CommonFunctions;
import ibase.webitm.ejb.sys_UTL.CreateXmlObject;

import java.rmi.RemoteException;
import java.sql.*;
import java.text.SimpleDateFormat;
import java.util.*;

import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.w3c.dom.*;

import javax.naming.InitialContext;
import javax.xml.rpc.ParameterMode;

@javax.ejb.Stateless
public class ConsumptionOdrIssuWizPos extends ValidatorEJB implements ConsumptionOdrIssuWizPosLocal, ConsumptionOdrIssuWizPosRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	ValidatorEJB validator = null;
	CommonFunctions commonFunctions = new CommonFunctions();

	@Override
	public String postSave() throws RemoteException, ITMException
	{
		// TODO Auto-generated method stub
		return "";
	}

	@Override
	public String postSave(String domString, String editFlag, String xtraParams, Connection conn) throws RemoteException, ITMException
	{
		String retString = "", sql = "";

		int cnt = 0;
		// TODO Auto-generated method stub
		System.out.println("@V@ IN POST SAVE @@@");

		PreparedStatement pstmt = null;
		ResultSet rst = null;
		Document headerDom = null;

		headerDom = genericUtility.parseString(domString);

		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;

		String termId = "", itemSer = "", varValue = "";
		String Aformat = "";
		String userId = "";
		String loginSite = "";
		String msgno = "";
		String tranIDOrder = "";
		String tranIDIssue = "";
		String orderDate = "";
		String empCode = "";
		String xmlString = null;
		boolean issueCreated = false;

		String returnValue = "";
		NodeList hdrDom = null;

		int parentNodeListLength = 0;

		Document resDom = null;
		Node arrNode = null;
		NamedNodeMap nodeMap = null;
		try
		{
			ConnDriver connDriver = new ConnDriver();
			conn = connDriver.getConnectDB("DriverValidator");
			Aformat = genericUtility.getApplDateFormat();
			java.text.SimpleDateFormat dtf = new java.text.SimpleDateFormat(Aformat);
			orderDate = dtf.format(new java.util.Date());

			hdrDom = headerDom.getElementsByTagName("Detail1");
			System.out.println("@V@ hdrDom-----=>" + hdrDom);

			userId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			loginSite = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			empCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
			termId = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "termId");
			validator = new ValidatorEJB();

			parentNodeList = headerDom.getElementsByTagName("Detail1");
			parentNodeListLength = parentNodeList.getLength();
			System.out.println("parentNodeListLength	--->" + parentNodeListLength);
			parentNode = parentNodeList.item(0);
			
			
//			itemSer = genericUtility.getColumnValueFromNode("item_ser", parentNode);

			System.out.println("@V@ Item Ser found at Beagining :- [" + itemSer + "]");

			/**
			 * Create Consumption Order
			 * */

			xmlString = createConsumeOrder(xtraParams, headerDom, conn, userId, loginSite, empCode, termId);
			System.out.println("@@@@@2: XML_String of Consumption Order:" + xmlString);
			System.out.println("Consumption Order just before savdata()");

			/**
			 * Call Save data
			 * */
			retString = saveData(loginSite, xmlString, xtraParams, conn);
			System.out.println("@V@ Consumption Order Generated retString :-[" + retString + "]");

			if (retString.indexOf("Success") > -1)
			{
				String[] arrayForTranId = retString.split("<TranID>");
				int endIndex = arrayForTranId[1].indexOf("</TranID>");
				tranIDOrder = arrayForTranId[1].substring(0, endIndex);
				System.out.println("@V@ Consumption Order Tran Id :- [" + tranIDOrder + "]");
				conn.commit();

				/**
				 * Confirm Consumption Order
				 * */
				retString = confirmTransaction(tranIDOrder, "consume_order", xtraParams, "true", conn);
				System.out.println("@V@ Confirm Consumption Order retString:-[" + retString + "");
				resDom = genericUtility.parseString(retString);
				arrNode = resDom.getElementsByTagName("error").item(0);
				nodeMap = arrNode.getAttributes();
				msgno = nodeMap.getNamedItem("id").getNodeValue().trim();
				System.out.println("msgno :: " + msgno);
				if (msgno.equals("VTSUCC1"))
				{
					/**
					 * Select and check Item Series Define for Auto Issue
					 * generate
					 * */
					sql = "select VAR_VALUE from DISPARM where var_name='AUTO_CISS_SER'";
					pstmt = conn.prepareStatement(sql);
					rst = pstmt.executeQuery();
					if (rst.next())
					{
						varValue = checkNull(rst.getString("VAR_VALUE"));
					}

					pstmt.close();
					pstmt = null;
					rst.close();
					rst = null;

					if (varValue.trim().length() > 0)
					{
						/**
						 * Check Header Item Ser
						 * Define in DISPARAM
						 * */
						String[] itmSerArr = varValue.split(",");

						for (String var : itmSerArr)
						{
							if (var.equalsIgnoreCase(itemSer))
							{
								issueCreated = true;
								break;
							}
						}
					}
					System.out.println("@V@ Issue created for item series :-[" + itemSer + "] is :-[" + issueCreated + "]");
					if (issueCreated)
					{
						System.out.println("@V@ Auto Issue Generation ........");
						/**
						 * Find Auto Generated 
						 * Issue Id
						 * */
						sql = "select cons_issue from consume_iss where cons_order =?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, tranIDOrder);
						rst = pstmt.executeQuery();
						if (rst.next())
						{
							tranIDIssue = rst.getString("cons_issue");
						}
						pstmt.close();
						pstmt = null;
						rst.close();
						rst = null;

						/**
						 * Directly Confirm Issue
						 * */
						
						System.out.println("@V@ Tran Id Isse found at Direct Confirm :- ["+tranIDIssue+"]");
						
						retString = confirmTransaction(tranIDIssue, "consume_issue", xtraParams, "", conn);
						System.out.println("@V@ Ret string after issue confirm :- [" + retString + "]");
						
						/**
						 * TranId add to success message 
						 * */
						
						resDom = genericUtility.parseString(retString);
						arrNode = resDom.getElementsByTagName("error").item(0);
						nodeMap = arrNode.getAttributes();
						msgno = nodeMap.getNamedItem("id").getNodeValue().trim();
						System.out.println("msgno :: " + msgno);
						if (msgno.equals("VTSUCC1"))
						{
							retString=setTranId(retString, tranIDOrder,tranIDIssue);
						}
					} else
					{
						System.out.println("@V@ Issue Generate Manualy.........");
						/**
						 * Create Consumption Issue for respective consumption
						 * order
						 * */

						xmlString = createConsumeOrderIssue(tranIDOrder, xtraParams, headerDom, conn, userId, loginSite, empCode, termId);
						System.out.println("@V@ Issue Generate retString :- [" + xmlString + "]");

						retString = saveData(loginSite, xmlString, xtraParams, conn);

						System.out.println("@V@ Ret String after Issue create :- [" + retString + "]");
						if (retString.indexOf("Success") > -1)
						{
							conn.commit();

							String[] arrayForTranIdIssue = retString.split("<TranID>");
							int endIndexIssue = arrayForTranIdIssue[1].indexOf("</TranID>");
							tranIDIssue = arrayForTranIdIssue[1].substring(0, endIndexIssue);
							System.out.println("@V@ Issue Tran Id :- [" + tranIDIssue + "]");

							/**
							 * Confirm Issue
							 * */
							retString = confirmTransaction(tranIDIssue, "consume_issue", xtraParams, "", conn);
							System.out.println("@V@ Ret string after issue confirm :- [" + retString + "]");
							
							/**
							 * TranId add to success message 
							 * */
							
							resDom = genericUtility.parseString(retString);
							arrNode = resDom.getElementsByTagName("error").item(0);
							nodeMap = arrNode.getAttributes();
							msgno = nodeMap.getNamedItem("id").getNodeValue().trim();
							System.out.println("msgno :: " + msgno);
							if (msgno.equals("VTSUCC1"))
							{
								retString=setTranId(retString, tranIDOrder,tranIDIssue);
							}
						} else
						{
							System.out.println("While Save Issue Found exception ..........");
							throw new Exception(retString);
						}
					}

				} else
				{
					throw new Exception(retString);
				}
			} else
			{
				throw new Exception(retString);
			}

		} catch (Exception e)
		{
			try
			{
				System.out.println("Connection roleback..........");
				conn.rollback();
				e.printStackTrace();
				throw new ITMException(e);
			} catch (SQLException seX)
			{
				// TODO Auto-generated catch block
				seX.printStackTrace();
				throw new ITMException(seX);
			}

		}
		return retString;
	}

	private String checkNull(String str)
	{
		if (str == null || str.trim().length() == 0)
		{
			str = "";
		}
		return str;
	}
	private String setTranId(String errString,String tranIDOrder,String tranIDIssue) throws ITMException
    {
            Document errorDom = null;
            NodeList parentNodeList = null;
            NodeList childNodeList = null;        
            Node parentNode = null;
            Node childNode = null;
            String errorType = "";
            String msgDescr="";
            String childNodeName = null;
            int currentFormNo = 0,ctr=0;
            int childNodeListLength;
            ibase.utility.E12GenericUtility genericUtility= new  ibase.utility.E12GenericUtility();
//            GenericUtility genericUtility = GenericUtility.getInstance();
            try
            {
            	StringBuffer valueXmlString = new StringBuffer();
               	errorDom = genericUtility.parseString(errString);
               	parentNodeList = errorDom.getElementsByTagName("Errors");
               	Node tempNode = errorDom.getElementsByTagName( "description" ).item(0);
               	String descr = checkNull(genericUtility.getColumnValue("description", errorDom));
                descr=descr+" Consumption Order Id:- "+tranIDOrder+" Issue Id:- "+tranIDIssue;
                setNodeValue(errorDom, "description", descr);
                errString=genericUtility.serializeDom(errorDom);
                valueXmlString = new StringBuffer("<?xml version = \"1.0\"?>");
                valueXmlString.append(errString);
                errString=valueXmlString.toString();
            }
            catch(Exception e)
            {
                    e.printStackTrace();
                    throw new ITMException(e);
            }
            return errString;
    }
	private static void setNodeValue( Document dom, String nodeName, String nodeVal ) throws Exception
	   {
	       Node tempNode = dom.getElementsByTagName( nodeName ).item(0);

	       if( tempNode != null )
	       {
	           if( tempNode.getFirstChild() == null )
	           {
	               CDATASection cDataSection = dom.createCDATASection( nodeVal );
	               tempNode.appendChild( cDataSection );
	           }
	           else
	           {
	               tempNode.getFirstChild().setNodeValue(nodeVal);
	           }
	       }
	       tempNode = null;
	   }

	private String createConsumeOrder(String xtraParams, Document headerDom, Connection conn, String userId, String loginSite, String empCode, String termId) throws Exception
	{
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		String retString = "", unit = "", itemSer = "", itemCode = "", siteCode = "", siteCodeReq = "", empCodeIss = "", acctCode = "", cctrCode = "", projectCode = "", reasonCode = "", remarks = "", deptCode = "", tranCode = "", currCode = "", exchRate = "", available = "", orderType = "", tranMode = "";
		String locCode = "", lotNo = "", lotSl = "", quantity = "";
		String returnValueTemp = "";
		String reqQty = "";
		int ctr = 0;
		int parentNodeListLength = 0, childNodeListLength = 0;
		int selectedRow = 0, lineNo = 0;

		StringBuffer xmlBuff = null;

		try
		{
			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String sysDate = sdf.format(currentDate.getTime());
			System.out.println("Now the date is :=>  " + sysDate);

			parentNodeList = headerDom.getElementsByTagName("Detail1");
			parentNodeListLength = parentNodeList.getLength();
			System.out.println("parentNodeListLength	--->" + parentNodeListLength);

			parentNode = parentNodeList.item(0);
			childNodeList = parentNode.getChildNodes();
			childNodeListLength = childNodeList.getLength();
			for (ctr = 0; ctr < childNodeListLength; ctr++)
			{
				siteCode = genericUtility.getColumnValue("site_code", headerDom);
				siteCodeReq = genericUtility.getColumnValue("site_code__reqd", headerDom);
				empCodeIss = genericUtility.getColumnValue("emp_code__iss", headerDom);
				
				/**
				 * The fields are removed from header screen
				 * 27/OCT/15 reported by Chezian Raja
				 * */
//				itemSer = genericUtility.getColumnValueFromNode("item_ser", parentNode);
//				System.out.println("@V@ Item Serise Found at Header :- [" + itemSer + "]");
//				acctCode = genericUtility.getColumnValue("acct_code", headerDom);
//				cctrCode = genericUtility.getColumnValue("cctr_code", headerDom);
				/**
				 * The fields are removed from header screen
				 * 27/OCT/15 reported by Chezian Raja END
				 * */
				
				
				projectCode = genericUtility.getColumnValue("proj_code", headerDom);
				reasonCode = genericUtility.getColumnValue("reas_code", headerDom);
				remarks = genericUtility.getColumnValue("remarks", headerDom);
				if(remarks==null || remarks.trim().length()==0)
				{
					remarks=" ";
				}
				available = genericUtility.getColumnValue("available", headerDom);

				deptCode = commonFunctions.getValueFromRefTable("employee", "emp_code", empCodeIss, "dept_code", conn);

				tranCode = getDisparams("999999", "DEFT_RDISS_TRAN_CODE", conn);

				returnValueTemp = commonFunctions.getValueFromRefTable("site", "site_code", siteCodeReq + "", "fin_entity", conn);
				currCode = commonFunctions.getValueFromRefTable("finent", "fin_entity", returnValueTemp, "curr_code", conn);
				currCode = currCode == null ? "" : currCode.trim();

				exchRate = getDailyExchRate(currCode, currCode, (String) sysDate, conn) + "";

				orderType = getDisparams("999999", "DEFT_RDISS_ORDER_TYPE", conn);

				tranMode = getDisparams("999999", "DEFT_CONSUME_ORDER_TRANS_MODE", conn);
			}

			// Generate Header XML
			xmlBuff = new StringBuffer();

			xmlBuff.append("<?xml version='1.0' encoding='ISO-8859-1'?><DocumentRoot>");
			xmlBuff.append("<description>Datawindow Root</description>");
			xmlBuff.append("<group0>");
			xmlBuff.append("<description>Group0 description</description>");
			xmlBuff.append("<Header0>");
			xmlBuff.append("<objName><![CDATA[").append("consume_order").append("]]></objName>");
			xmlBuff.append("<pageContext><![CDATA[").append("1").append("]]></pageContext>");
			xmlBuff.append("<objContext><![CDATA[").append("1").append("]]></objContext>");
			xmlBuff.append("<editFlag><![CDATA[").append("A").append("]]></editFlag>");
			xmlBuff.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>");
			xmlBuff.append("<action><![CDATA[").append("SAVE").append("]]></action>");
			xmlBuff.append("<elementName><![CDATA[").append("").append("]]></elementName>");
			xmlBuff.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
			xmlBuff.append("<taxKeyValue><![CDATA[").append("").append("]]></taxKeyValue>");
			xmlBuff.append("<saveLevel><![CDATA[").append("1").append("]]></saveLevel>");
			xmlBuff.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>");
			xmlBuff.append("<taxInFocus><![CDATA[").append(false).append("]]></taxInFocus>");
			xmlBuff.append("<description>Header0 members</description>");
			xmlBuff.append("<Detail1 dbID=\"\" domID=\"1\" objContext=\"1\" objName=\"consume_order\">");
			xmlBuff.append("<attribute pkNames=\"\" selected=\"N\" status=\"N\" updateFlag=\"A\"/>");
			xmlBuff.append("<cons_order/>");
			xmlBuff.append("<order_date><![CDATA[" + sysDate + "]]></order_date>");
			xmlBuff.append("<site_code__ord><![CDATA[" + loginSite + "]]></site_code__ord>");
			xmlBuff.append("<emp_code><![CDATA[" + empCode + "]]></emp_code>");
			xmlBuff.append("<dept_code><![CDATA[" + deptCode + "]]></dept_code>");
//			xmlBuff.append("<item_ser><![CDATA[" + itemSer + "]]></item_ser>");
			xmlBuff.append("<site_code__req><![CDATA[" + siteCodeReq + "]]></site_code__req>");
			xmlBuff.append("<tran_code><![CDATA[" + tranCode + "]]></tran_code>");
			xmlBuff.append("<remarks><![CDATA[" + remarks + "]]></remarks>");
			xmlBuff.append("<reas_code><![CDATA[" + reasonCode + "]]></reas_code>");
			xmlBuff.append("<curr_code><![CDATA[" + currCode + "]]></curr_code>");
			xmlBuff.append("<exch_rate><![CDATA[" + exchRate + "]]></exch_rate>");
			xmlBuff.append("<chg_date><![CDATA[" + sysDate + "]]></chg_date>");
			xmlBuff.append("<chg_user><![CDATA[" + userId + "]]></chg_user>");
			xmlBuff.append("<chg_term><![CDATA[" + termId + "]]></chg_term>");
			xmlBuff.append("<confirmed><![CDATA[N]]></confirmed>");
			xmlBuff.append("<emp_code__aprv><![CDATA[" + empCode + "]]></emp_code__aprv>");
			xmlBuff.append("<proj_code><![CDATA[" + projectCode + "]]></proj_code>");
			xmlBuff.append("<status><![CDATA[P]]></status>");
			xmlBuff.append("<status_date><![CDATA[" + sysDate + "]]></status_date>");
			xmlBuff.append("<available_yn><![CDATA[" + available + "]]></available_yn>");
			xmlBuff.append("<order_type><![CDATA[" + orderType + "]]></order_type>");
			xmlBuff.append("<trans_mode><![CDATA[" + tranMode + "]]></trans_mode>");
			xmlBuff.append("</Detail1>");

			parentNodeList = headerDom.getElementsByTagName("Detail2");
			parentNodeListLength = parentNodeList.getLength();

			for (selectedRow = 0; selectedRow < parentNodeListLength; selectedRow++)
			{
				parentNode = parentNodeList.item(selectedRow);
				System.out.println(">>>>>>>>>>parentNode:" + parentNode);
				itemCode = genericUtility.getColumnValueFromNode("item_code", parentNode);
				unit = genericUtility.getColumnValueFromNode("unit", parentNode);
				itemSer = genericUtility.getColumnValueFromNode("item_ser", parentNode);
				locCode = genericUtility.getColumnValueFromNode("loc_code", parentNode);
				lotNo = genericUtility.getColumnValueFromNode("lot_no", parentNode);
				lotSl = genericUtility.getColumnValueFromNode("lot_sl", parentNode);
				acctCode = genericUtility.getColumnValueFromNode("acct_code", parentNode);
				cctrCode = genericUtility.getColumnValueFromNode("cctr_code", parentNode);
				quantity = genericUtility.getColumnValueFromNode("quantity", parentNode);
				reqQty = genericUtility.getColumnValueFromNode("req_qty", parentNode);

				String rate = getRate(siteCodeReq, itemCode, locCode, lotNo, lotSl, conn);
				lineNo = selectedRow + 1;

				System.out.println("Lot No :- [" + lotNo + "]");
				System.out.println("Lot Sl :- [" + lotSl + "]");
				
				System.out.println("@V@ At order line no :- ["+lineNo+"]");

				// Generate Detail XML
				xmlBuff.append("<Detail2 dbID=\"\" domID=\"1\" objContext=\"2\" objName=\"consume_order\">");
				xmlBuff.append("<attribute pkNames=\"\" selected=\"N\" status=\"N\" updateFlag=\"A\"/>");
				xmlBuff.append("<cons_order/>");
				xmlBuff.append("<line_no><![CDATA[" + lineNo + "]]></line_no>");
				xmlBuff.append("<item_code><![CDATA[" + itemCode + "]]></item_code>");
				xmlBuff.append("<quantity><![CDATA[" + reqQty + "]]></quantity>");
				xmlBuff.append("<unit><![CDATA[" + unit + "]]></unit>");
				xmlBuff.append("<rate><![CDATA[" + rate + "]]></rate>");
				xmlBuff.append("<acct_code><![CDATA[" + acctCode + "]]></acct_code>");
				xmlBuff.append("<cctr_code><![CDATA[" + cctrCode + "]]></cctr_code>");
				xmlBuff.append("<loc_code><![CDATA[" + locCode + "]]></loc_code>");
				xmlBuff.append("<status><![CDATA[P]]></status>");
				xmlBuff.append("<status_date><![CDATA[" + sysDate + "]]></status_date>");
				xmlBuff.append("</Detail2>");
			}

			xmlBuff.append("</Header0>");
			xmlBuff.append("</group0>");
			xmlBuff.append("</DocumentRoot>");

			retString = xmlBuff.toString();

		} catch (Exception ex)
		{
			System.out.println("Exception createConsumeOrder - " + ex.getMessage());
			ex.printStackTrace();
		}
		return retString;
	}

	private String saveData(String siteCode, String xmlString, String xtraParams, Connection conn) throws ITMException
	{
		System.out.println("saving data...........");
		InitialContext ctx = null;
		String retString = null;
		MasterStatefulLocal masterStateful = null; // for ejb3
		ibase.utility.UserInfoBean userInfo;
		String chgUser = "", chgTerm = "";
		String loginCode = "", loginEmpCode = "", loginSiteCode = "";
		E12GenericUtility genericUtility = new E12GenericUtility();
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
			masterStateful = (MasterStatefulLocal) ctx.lookup("ibase/MasterStatefulEJB/local");
			System.out.println("-----------masterStateful------- " + masterStateful);
			String[] authencate = new String[2];
			authencate[0] = "";
			authencate[1] = "";
			System.out.println("xmlString to masterstateful [" + xmlString + "]");
			userInfo = new ibase.utility.UserInfoBean();
			System.out.println("xtraParams>>>>" + xtraParams);
			chgUser = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgUser");
			chgTerm = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "chgTerm");
			loginCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginCode");
			loginEmpCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
			loginSiteCode = genericUtility.getValueFromXTRA_PARAMS(xtraParams, "loginSiteCode");
			userInfo.setEmpCode(loginEmpCode);
			userInfo.setRemoteHost(chgTerm);
			userInfo.setSiteCode(loginSiteCode);
			userInfo.setLoginCode(loginCode);
			userInfo.setEntityCode(loginEmpCode);
			System.out.println("userInfo>>>>>" + userInfo);

			System.out.println("chgUser :" + chgUser);
			System.out.println("chgTerm :" + chgTerm);
			System.out.println("loginCode :" + loginCode);
			System.out.println("loginEmpCode :" + loginEmpCode);

			retString = masterStateful.processRequest(userInfo, xmlString, true, conn);
			System.out.println("--retString - -" + retString);
		} catch (ITMException itme)
		{
			System.out.println("ITMException :CreateDistOrder :saveData :==>");
			throw itme;
		} catch (Exception e)
		{
			e.printStackTrace();
			System.out.println("Exception :CreateDistOrder :saveData :==>");
			throw new ITMException(e);
		}
		return retString;
	}

	private String getRate(String siteCodeReq, String itemCode, String locCode, String lotNo, String lotSl, Connection conn)
	{
		String rate = "";
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rst = null;
		// TODO Auto-generated method stub

		try
		{
			sql = "SELECT NVL(RATE, 0) AS RATE FROM STOCK WHERE SITE_CODE =? AND ITEM_CODE =? AND LOC_CODE =? AND LOT_NO =? AND LOT_SL =?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, siteCodeReq);
			pstmt.setString(2, itemCode);
			pstmt.setString(3, locCode);
			pstmt.setString(4, lotNo);
			pstmt.setString(5, lotSl);
			rst = pstmt.executeQuery();
			if (rst.next())
			{
				rate = rst.getString("RATE");
			}
			pstmt.close();
			pstmt = null;
			rst.close();
			rst = null;
		} catch (SQLException e)
		{
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		return rate;
	}

	private String confirmTransaction(String tranID, String objName, String xtraParams, String forcedFlag, Connection conn) throws ITMException, Exception
	{
		String businessObj = "";
		String methodName = "";
		String retString = "";
		String serviceCode = "";
		String serviceURI = "";
		String actionURI = "";
		String selectSql = "";
		Statement stmt = null;
		ResultSet rs = null;

		System.out.println("@V@ Tran Id at Confirm :- [" + tranID + "]");
		System.out.println("@V@ OBj Name at Confirm :- [" + objName + "]");

		try
		{
			methodName = "gbf_post";
			actionURI = "http://NvoServiceurl.org/" + methodName;
			selectSql = "SELECT SERVICE_CODE,COMP_NAME FROM SYSTEM_EVENTS WHERE OBJ_NAME ='" + objName + "' AND EVENT_CODE = 'pre_confirm' ";
			System.out.println("\nselectSql :: " + selectSql);
			stmt = conn.createStatement();
			rs = stmt.executeQuery(selectSql);
			if (rs.next())
			{
				serviceCode = rs.getString("SERVICE_CODE");
				businessObj = rs.getString("COMP_NAME");
			}
			System.out.println("\nbusinessObj :: " + businessObj);
			System.out.println("\nserviceCode :: " + serviceCode);

			selectSql = "SELECT SERVICE_URI FROM SYSTEM_EVENT_SERVICES WHERE SERVICE_CODE = '" + serviceCode + "' ";
			System.out.println("\nselectSql :: " + selectSql);
			rs = stmt.executeQuery(selectSql);
			if (rs.next())
				serviceURI = rs.getString("SERVICE_URI");
			System.out.println("\nserviceURI :: " + serviceURI);

			Service service = new Service();
			Call call = (Call) service.createCall();
			call.setTargetEndpointAddress(new java.net.URL(serviceURI));
			call.setOperationName(new javax.xml.namespace.QName("http://NvoServiceurl.org", methodName));
			call.setUseSOAPAction(true);
			call.setSOAPActionURI(actionURI);

			Object[] aobj = new Object[4];

			call.addParameter(new javax.xml.namespace.QName("http://NvoServiceurl.org", "component_name"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter(new javax.xml.namespace.QName("http://NvoServiceurl.org", "tran_id"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter(new javax.xml.namespace.QName("http://NvoServiceurl.org", "xtra_params"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter(new javax.xml.namespace.QName("http://NvoServiceurl.org", "forced_flag"), XMLType.XSD_STRING, ParameterMode.IN);

			aobj[0] = new String(businessObj);
			aobj[1] = new String(tranID);
			aobj[2] = new String(xtraParams);
			aobj[3] = new String(forcedFlag);

			call.setReturnType(XMLType.XSD_STRING);
			retString = (String) call.invoke(aobj);
			System.out.println("Return value after confirm [" + retString + "]");
		} catch (Exception e)
		{
			throw new ITMException(e);
		}
		return retString;
	}

	private String createConsumeOrderIssue(String consOrder, String xtraParams, Document headerDom, Connection conn, String userId, String loginSite, String empCode, String termId) throws Exception
	{
		PreparedStatement pstmt = null;
		ResultSet rst = null;

		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		String sql = "";
		String retString = "";

		String unit = "", itemSer = "", itemCode = "", siteCode = "", siteCodeReq = "", empCodeIss = "", acctCode = "", cctrCode = "", projectCode = "", reasonCode = "", remarks = "", deptCode = "", tranCode = "", currCode = "", exchRate = "", available = "", orderType = "", tranMode = "", reqQty = "";
		String locCode = "", lotNo = "", lotSl = "", quantity = "", returnValueTemp = "", accCodeInv = "", cctrCodeInv = "", rate = "", qcReqd = "";

		StringBuffer xmlBuff = null;

		int parentNodeListLength = 0, childNodeListLength = 0;
		int selectedRow = 0, ctr = 0, lineNo = 0;

		try
		{
			Calendar currentDate = Calendar.getInstance();
			SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
			String sysDate = sdf.format(currentDate.getTime());
			System.out.println("Now the date is :=>  " + sysDate);

			parentNodeList = headerDom.getElementsByTagName("Detail1");
			parentNodeListLength = parentNodeList.getLength();
			System.out.println("parentNodeListLength	--->" + parentNodeListLength);

			parentNode = parentNodeList.item(0);
			childNodeList = parentNode.getChildNodes();
			childNodeListLength = childNodeList.getLength();
			for (ctr = 0; ctr < childNodeListLength; ctr++)
			{
				siteCode = genericUtility.getColumnValue("site_code", headerDom);
				siteCodeReq = genericUtility.getColumnValue("site_code__reqd", headerDom);
				empCodeIss = genericUtility.getColumnValue("emp_code__iss", headerDom);
				/**
				 * The fields are removed from header screen
				 * 27/OCT/15 reported by Chezian Raja
				 * */
//				itemSer = genericUtility.getColumnValueFromNode("item_ser", parentNode);
//				System.out.println("@V@ Item Series at Issue Header :- [" + itemSer + "]");
//				acctCode = genericUtility.getColumnValue("acct_code", headerDom);
//				cctrCode = genericUtility.getColumnValue("cctr_code", headerDom);
				/**
				 * The fields are removed from header screen
				 * 27/OCT/15 reported by Chezian Raja END
				 * */
				projectCode = genericUtility.getColumnValue("proj_code", headerDom);
				reasonCode = genericUtility.getColumnValue("reas_code", headerDom);
				remarks = genericUtility.getColumnValue("remarks", headerDom);
				if(remarks==null || remarks.trim().length()==0)
				{
					remarks=" ";
				}
				
				available = genericUtility.getColumnValue("available", headerDom);

				deptCode = commonFunctions.getValueFromRefTable("employee", "emp_code", empCodeIss, "dept_code", conn);

				tranCode = getDisparams("999999", "DEFT_RDISS_TRAN_CODE", conn);

				returnValueTemp = commonFunctions.getValueFromRefTable("site", "site_code", siteCodeReq + "", "fin_entity", conn);
				currCode = commonFunctions.getValueFromRefTable("finent", "fin_entity", returnValueTemp, "curr_code", conn);
				currCode = currCode == null ? "" : currCode.trim();

				exchRate = getDailyExchRate(currCode, currCode, (String) sysDate, conn) + "";

				orderType = getDisparams("999999", "DEFT_RDISS_ORDER_TYPE", conn);

				tranMode = getDisparams("999999", "DEFT_CONSUME_ISSUE_TRANS_MODE", conn);

			}

			// Generate Header XML
			xmlBuff = new StringBuffer();

			xmlBuff.append("<?xml version='1.0' encoding='ISO-8859-1'?><DocumentRoot>");
			xmlBuff.append("<description>Datawindow Root</description>");
			xmlBuff.append("<group0>");
			xmlBuff.append("<description>Group0 description</description>");
			xmlBuff.append("<Header0>");
			xmlBuff.append("<objName><![CDATA[").append("consume_issue").append("]]></objName>");
			xmlBuff.append("<pageContext><![CDATA[").append("1").append("]]></pageContext>");
			xmlBuff.append("<objContext><![CDATA[").append("1").append("]]></objContext>");
			xmlBuff.append("<editFlag><![CDATA[").append("A").append("]]></editFlag>");
			xmlBuff.append("<focusedColumn><![CDATA[").append("").append("]]></focusedColumn>");
			xmlBuff.append("<action><![CDATA[").append("SAVE").append("]]></action>");
			xmlBuff.append("<elementName><![CDATA[").append("").append("]]></elementName>");
			xmlBuff.append("<keyValue><![CDATA[").append("1").append("]]></keyValue>");
			xmlBuff.append("<taxKeyValue><![CDATA[").append("").append("]]></taxKeyValue>");
			xmlBuff.append("<saveLevel><![CDATA[").append("1").append("]]></saveLevel>");
			xmlBuff.append("<forcedSave><![CDATA[").append(true).append("]]></forcedSave>");
			xmlBuff.append("<taxInFocus><![CDATA[").append(false).append("]]></taxInFocus>");
			xmlBuff.append("<description>Header0 members</description>");
			xmlBuff.append("<Detail1 dbID=\'\' domID=\'1\' objContext=\'1\' objName=\'consume_issue\'>");
			xmlBuff.append("<attribute pkNames=\'\' selected=\'N\' status=\'N\' updateFlag=\'A\'/>");
			xmlBuff.append("<cons_issue/>");
			xmlBuff.append("<issue_date><![CDATA[" + sysDate + "]]></issue_date>");
			xmlBuff.append("<cons_order><![CDATA[" + consOrder + "]]></cons_order>");
			xmlBuff.append("<site_code__ord><![CDATA[" + loginSite + "]]></site_code__ord>");
			xmlBuff.append("<dept_code><![CDATA[" + deptCode + "]]></dept_code>");
			xmlBuff.append("<emp_code><![CDATA[" + empCode + "]]></emp_code>");
//			xmlBuff.append("<item_ser><![CDATA[" + itemSer + "]]></item_ser>");
			xmlBuff.append("<site_code__req><![CDATA[" + siteCodeReq + "]]></site_code__req>");
			xmlBuff.append("<tran_code><![CDATA[" + tranCode + "]]></tran_code>");
			xmlBuff.append("<reas_code><![CDATA[" + reasonCode + "]]></reas_code>");
			xmlBuff.append("<curr_code><![CDATA[" + currCode + "]]></curr_code>");
			xmlBuff.append("<exch_rate><![CDATA[" + exchRate + "]]></exch_rate>");
			xmlBuff.append("<remarks><![CDATA[" + remarks + "]]></remarks>");
			xmlBuff.append("<chg_date><![CDATA[" + sysDate + "]]></chg_date>");
			xmlBuff.append("<chg_user><![CDATA[" + userId + "]]></chg_user>");
			xmlBuff.append("<chg_term><![CDATA[" + termId + "]]></chg_term>");
			xmlBuff.append("<confirmed><![CDATA[N]]></confirmed>");
			xmlBuff.append("<emp_code__aprv><![CDATA[" + empCode + "]]></emp_code__aprv>");
			xmlBuff.append("<eff_date><![CDATA[" + sysDate + "]]></eff_date>");
			xmlBuff.append("<tran_type><![CDATA[I]]></tran_type>");
			xmlBuff.append("<available_yn><![CDATA[" + available + "]]></available_yn>");
			xmlBuff.append("<tran_mode><![CDATA[" + tranMode + "]]></tran_mode>");
			xmlBuff.append("<part_qty><![CDATA[A]]></part_qty>");
			xmlBuff.append("<gp_date><![CDATA[" + sysDate + "]]></gp_date>");
			xmlBuff.append("</Detail1>");

			parentNodeList = headerDom.getElementsByTagName("Detail2");
			parentNodeListLength = parentNodeList.getLength();
			System.out.println("@V@ parentNodeListLength	--->" + parentNodeListLength);
			for (selectedRow = 0; selectedRow < parentNodeListLength; selectedRow++)
			{
				parentNode = parentNodeList.item(selectedRow);
				System.out.println(">>>>>>>>>>parentNode:" + parentNode);
				itemCode = genericUtility.getColumnValueFromNode("item_code", parentNode);
				unit = genericUtility.getColumnValueFromNode("unit", parentNode);
				itemSer = genericUtility.getColumnValueFromNode("item_ser", parentNode);
				locCode = genericUtility.getColumnValueFromNode("loc_code", parentNode);
				lotNo = genericUtility.getColumnValueFromNode("lot_no", parentNode);
				lotSl = genericUtility.getColumnValueFromNode("lot_sl", parentNode);
				acctCode = genericUtility.getColumnValueFromNode("acct_code", parentNode);
				cctrCode = genericUtility.getColumnValueFromNode("cctr_code", parentNode);
				quantity = genericUtility.getColumnValueFromNode("quantity", parentNode);
				reqQty = genericUtility.getColumnValueFromNode("req_qty", parentNode);
				
//				int noArt=getNoArtical(itemCode,siteCode,locCode,lotNo,lotSl,conn);
				int noArt=1;		//No of Artical is always set to '1' requirement come on [09/SEP/15] 
				System.out.println("@V@ No or Art At issue :- ["+noArt+"]");

				System.out.println("Lot No Issue:- [" + lotNo + "]");
				System.out.println("Lot Sl Issue:- [" + lotSl + "]");

				qcReqd = commonFunctions.getValueFromRefTable("item", "item_code", itemCode + "", "qc_reqd", conn);

				sql = "SELECT ACCT_CODE__INV, CCTR_CODE__INV, NVL(RATE, 0) AS RATE FROM STOCK WHERE SITE_CODE =? AND ITEM_CODE =? AND LOC_CODE =? AND LOT_NO = ? AND LOT_SL = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, siteCodeReq);
				pstmt.setString(2, itemCode);
				pstmt.setString(3, locCode);
				pstmt.setString(4, lotNo);
				pstmt.setString(5, lotSl);
				rst = pstmt.executeQuery();
				if (rst.next())
				{
					accCodeInv = rst.getString("ACCT_CODE__INV");
					cctrCodeInv = rst.getString("CCTR_CODE__INV");
					rate = rst.getString("RATE");
				}
				pstmt.close();
				pstmt = null;
				rst.close();
				rst = null;

				lineNo = selectedRow + 1;
				
				System.out.println("@V@ At isse det line no :- ["+lineNo+"]");

				// Generate Detail XML.
				xmlBuff.append("<Detail2 dbID=\"\" domID=\"1\" objContext=\"2\" objName=\"consume_issue\">");
				xmlBuff.append("<attribute pkNames=\"\" selected=\"N\" status=\"N\" updateFlag=\"A\"/>");
				xmlBuff.append("<cons_issue/>");
				xmlBuff.append("<line_no><![CDATA[" + lineNo + "]]></line_no>");
				xmlBuff.append("<cons_order><![CDATA[" + consOrder + "]]></cons_order>");
				xmlBuff.append("<line_no__ord><![CDATA[" + lineNo + "]]></line_no__ord>");
				xmlBuff.append("<item_code><![CDATA[" + itemCode + "]]></item_code>");
				xmlBuff.append("<quantity><![CDATA[" + reqQty + "]]></quantity>");
				xmlBuff.append("<unit><![CDATA[" + unit + "]]></unit>");
				xmlBuff.append("<rate><![CDATA[" + rate + "]]></rate>");
				xmlBuff.append("<acct_code><![CDATA[" + acctCode + "]]></acct_code>");
				xmlBuff.append("<cctr_code><![CDATA[" + cctrCode + "]]></cctr_code>");
				xmlBuff.append("<loc_code><![CDATA[" + locCode + "]]></loc_code>");
				xmlBuff.append("<lot_no><![CDATA[" + lotNo + "]]></lot_no>");
				xmlBuff.append("<lot_sl><![CDATA[" + lotSl + "]]></lot_sl>");
				xmlBuff.append("<quantity__std><![CDATA[" + reqQty + "]]></quantity__std>");
				xmlBuff.append("<unit__std><![CDATA[" + unit + "]]></unit__std>");
				xmlBuff.append("<conv_qty_stduom><![CDATA[1]]></conv_qty_stduom>");
				xmlBuff.append("<qc_reqd><![CDATA[" + qcReqd + "]]></qc_reqd>");
				xmlBuff.append("<acct_code__inv><![CDATA[" + accCodeInv + "]]></acct_code__inv>");
				xmlBuff.append("<cctr_code__inv><![CDATA[" + cctrCodeInv + "]]></cctr_code__inv>");
				xmlBuff.append("<no_art><![CDATA[" + noArt + "]]></no_art>");
				xmlBuff.append("</Detail2>");
			}
			xmlBuff.append("</Header0>");
			xmlBuff.append("</group0>");
			xmlBuff.append("</DocumentRoot>");

			retString = xmlBuff.toString();
		} catch (Exception ex)
		{
			System.out.println("Exception createConsumeOrderIssue - " + ex.getMessage());
			ex.printStackTrace();
		}
		return retString;
	}

	private int getNoArtical(String itemCode, String siteCode, String locCode, String lotNo, String lotSl, Connection conn)throws ITMException
    {
		int noArt=0;
		String sql = "";
		ResultSet rs = null;
		PreparedStatement pstmt1 = null;
	    // TODO Auto-generated method stub
		
		System.out.println("@V@ item code at no art :- ["+itemCode+"]");
		System.out.println("@V@ site code at no art :- ["+siteCode+"]");
		System.out.println("@V@ loc code at no art :- ["+locCode+"]");
		System.out.println("@V@ lot no at no art :- ["+lotNo+"]");
		System.out.println("@V@ lot sl at no art :- ["+lotSl+"]");
		
		try
        {
	        sql="select CEIL((case when quantity is null then 0.00 else quantity end-"
	        		+ "case when alloc_qty is null then 0.00 else alloc_qty end-"
	        		+ "case when hold_qty is null then 0.00 else hold_qty end)/"
	        		+ "case when qty_per_art is null then 1 else qty_per_art end) AS NOART"
	        		+ " from stock where item_code =? and site_code =? and loc_code =? and lot_no =? and lot_sl =?";
	        pstmt1=conn.prepareStatement(sql);
	        pstmt1.setString(1, itemCode);
	        pstmt1.setString(2, siteCode);
	        pstmt1.setString(3, locCode);
	        pstmt1.setString(4, lotNo);
	        pstmt1.setString(5, lotSl);
	        rs=pstmt1.executeQuery();
	        if(rs.next())
	        {
	        	noArt=rs.getInt("NOART");
	        }
        } catch (SQLException e)
        {
	        // TODO Auto-generated catch block
        	throw new ITMException(e);
        }
		
	    return noArt;
    }

	private String getDisparams(String prdCode, String varName, Connection conn) throws ITMException
	{
		String retVal = "";
		String sql = "";
		ResultSet rs = null;
		Statement stmt = null;
		try
		{
			System.out.println("in DISPARAMS ");
			stmt = conn.createStatement();
			sql = "SELECT VAR_VALUE FROM DISPARM WHERE PRD_CODE ='" + prdCode + "' AND VAR_NAME ='" + varName + "'";
			System.out.println("sql is of disparm" + sql);
			rs = stmt.executeQuery(sql);
			if (rs.next() == false)
				retVal = "NULLFOUND";
			else
				retVal = rs.getString(1);
			stmt.close();
		} catch (Exception e)
		{
			throw new ITMException(e);
		}
		if (retVal == null)
			retVal = "";
		System.out.println("@V@ value of disparm" + retVal);
		return (retVal);
	}

	public double getDailyExchRate(String curr_code, String curr_code__to, String tranDate, Connection conn)
	{
		String sql = "";
		Statement stmt = null, stmt1 = null;
		ResultSet rs = null, rs1 = null;
		String ls_fin_entity = null, ls_curr_code__to = null, ls_var_value = null;
		System.out.println("Currency Code : '" + curr_code + "'");
		System.out.println("Currency Code To: '" + curr_code__to + "'");
		System.out.println("Tran Date : " + tranDate);

		double lc_exch_rate = 0.0;
		try
		{
			stmt = conn.createStatement();
			System.out.println("@V@ In getDailyExchRate method");
			if (curr_code.equals(curr_code__to))
			{
				System.out.println("@V@ both are equal so returning 1");
				return 1.0;
			}
			sql = "select exch_rate__sell from daily_exch_rate_sell_buy 	where	 curr_code = '" + curr_code + "' and curr_code__to = '" + curr_code__to + "' and to_date('" + tranDate + "','dd/MM/yy') between from_date and to_date";
			System.out.println("SQL 1:" + sql);
			rs1 = stmt1.executeQuery(sql);
			if (rs1.next())
				lc_exch_rate = rs1.getDouble(1);
			if (lc_exch_rate == 0)
			{
				sql = "select exch_rate from exch_rate where	 curr_code__from = '" + ls_curr_code__to + "' and curr_code__to = '" + curr_code + "' and to_date('" + tranDate + "','dd/MM/yy') between date__from and date__to";
				System.out.println("SQL 2:" + sql);
				rs1 = stmt1.executeQuery(sql);
				if (rs1.next())
					lc_exch_rate = rs1.getDouble(1);
			}
		} catch (Exception e)
		{
			System.out.println("@V@ Error in Exchange Rate :" + e);
		}
		System.out.println("Returning Exchange Rate [getDailyExchRate] : " + lc_exch_rate);
		return lc_exch_rate;
	}
}
