package ibase.webitm.ejb.gst;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

import org.w3c.dom.Document;

import ibase.system.config.ConnDriver;
import ibase.utility.CommonConstants;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ProcessEJB;
import ibase.webitm.ejb.dis.DistCommon;
import ibase.webitm.ejb.fin.FinCommon;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.TransIDGenerator;

@javax.ejb.Stateless
public class GenerateGSTR3BPrc extends ProcessEJB implements GenerateGSTR3BPrcLocal,GenerateGSTR3BPrcRemote 
{
	ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
	E12GenericUtility e12GenericUtility = new E12GenericUtility();
	FinCommon finCommon = new FinCommon();
	
	Connection connLocal = null,connGST = null;
	String taxClassAllStr = "", taxEnvAllStr = "",GST_EXPWP_TAXCLASS = "",GST_EXPWOP_TAXCLASS = "",GST_SEZWP_TAXCLASS = "",
			GST_SEZWOP_TAXCLASS = "",GST_DE_TAXCLASS = "",
			GST_NIL_TAXCLASS = "",GST_EXE_TAXCLASS = "",GST_EXPWP_TAXENV = "",GST_EXPWOP_TAXENV = "",GST_SEZWP_TAXENV = "",
			GST_SEZWOP_TAXENV = "",GST_DE_TAXENV = "",GST_NIL_TAXENV = "",GST_EXE_TAXENV = "",gstB2CLInvValStr = "";
	Timestamp fromDate = null, toDate = null;
	String chgUser = "",chgTerm = "",loginSiteCode = "",currDateStr = "";
	java.sql.Timestamp currDate = null,sysDate = null;
	Timestamp currMonthStartDate = null;
	double GST_B2CL_INV_VAL = 0.0;
	
	StringBuffer errorMessage = new StringBuffer();

	public String process() throws RemoteException, ITMException 
	{
		return "";
	}

	public String process(String xmlString, String xmlString2,String windowName, String xtraParams) throws RemoteException,ITMException 
	{
		String retStr = "";
		Document detailDom = null;
		Document headerDom = null;
		
		try 
		{
			System.out.println("xmlString   [" + xmlString + "]");
			System.out.println("xmlString2  [" + xmlString2 + "]");
			System.out.println("windowName   [" + windowName + "]");
			System.out.println("xtraParams   [" + xtraParams + "]");
			
			if (xmlString != null && xmlString.trim().length() != 0) 
			{
				headerDom = e12GenericUtility.parseString(xmlString);
			}
			if (xmlString2 != null && xmlString2.length() != 0) 
			{
				detailDom = e12GenericUtility.parseString(xmlString2);
			}
			
			retStr = process(headerDom, detailDom, windowName, xtraParams);
		} 
		catch (Exception e) 
		{
			System.out.println("Exception GstDataPrc :process()"+ e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		}
		return retStr;
	}

	public String process(Document headerDom, Document detailDom, String windowName, String xtraParams) throws RemoteException,ITMException
	{
		
	
		//Connection connGST = null,connLocal = null;	
		ConnDriver connDriverGST = null,connDriverLocal = null;
		
		PreparedStatement pstmt = null,pstmtInsHdr = null,pstmtInsDet = null, pstmtSelHdr = null,pstmtSelDet = null; 
		ResultSet rs = null, rsSelHdr= null, rsSelDet = null;
		
		String period = "", type = "", sql = "",retString = "",prdcode = "";
		//java.sql.Timestamp currDate = null;

		boolean isError = false;
		
		String hdrSql = "",dtlSql = "",gstDataSink = "";

		int cnt = 0;
		
		String monthStr = "",yearStr = "";
		int month = 0, year = 0;
		boolean isNumeric = false;
		
		try
		{
			
		} 
		catch (Exception e)
		{
			System.out.println("Exception inside GstDataPrc==>"+e.getMessage());
			isError = true;
			e.printStackTrace();
			//throw new ITMException(e);
			errorMessage.append("\n["+e.getMessage()+"]");
		}
		finally
		{
			System.out.println("Inside finally isError["+isError+"] connStatus[]");
			try
			{
				if(rs != null)
				{
					rs.close();rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();pstmt = null;
				}
				if(pstmtSelHdr != null)
				{
					pstmtSelHdr.close();pstmtSelHdr = null;
				}
				if(pstmtSelDet != null)
				{
					pstmtSelDet.close();pstmtSelDet = null;
				}
				if(pstmtInsHdr != null)
				{
					pstmtInsHdr.close();pstmtInsHdr = null;
				}
				if(pstmtInsDet != null)
				{
					pstmtInsDet.close();pstmtInsDet = null;
				}
				if(rsSelHdr != null)
				{
					rsSelHdr.close();rsSelHdr = null;
				}
				if(rsSelDet != null)
				{
					rsSelDet.close();rsSelDet = null;
				}
				if(isError)
				{
					System.out.println("GstDataPrc connection RollBack.....");
					//connLocal.rollback();
					connGST.rollback();
					//retString = itmDBAccessEJB.getErrorString("","VTPRCESERR","","",connLocal);
					//retString = itmDBAccessEJB.getErrorString("","VTPRCESERR","","",connGST);
					retString = getError(errorMessage.toString(),"PRCSUCCESS",connGST);
				}
				if(!isError)
				{
					System.out.println("GstDataPrc connection Commit.....");
					//connLocal.commit();//Temporary commented
					//connLocal.rollback();
					connGST.commit();
					//retString = itmDBAccessEJB.getErrorString("","PRCSUCCESS","","",connLocal);
					//retString = itmDBAccessEJB.getErrorString("","PRCSUCCESS","","",connGST);
					retString = getError(errorMessage.toString(),"PRCSUCCESS",connGST);
				}
				if( connLocal != null && !connLocal.isClosed() )
				{
					connLocal.close();connLocal = null;
				}
				if( connGST != null && !connGST.isClosed() )
				{
					connGST.close();connGST = null;
				}
				
				errorMessage.delete(0, errorMessage.length());
			}
			catch (Exception ex)
			{	
				ex.printStackTrace();
				throw new ITMException(ex);
			}		
		}
		System.out.println("Return String from Post Save ["+retString+"]");
		return retString;
	}
	
	public String getError(String message,String Code, Connection conn)  throws ITMException, Exception
	{
		String mainStr ="";

		try
		{
			String errString = "";
			errString =  itmDBAccessEJB.getErrorString("",Code,"","",conn);
			
			String begPart = errString.substring(0,errString.indexOf("</description>"));
			String endDesc = errString.substring(errString.indexOf("</description>"),errString.length());
			
			mainStr = begPart + message + endDesc;
			begPart = null;
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		return mainStr;
	}

	private String generateTranId(String windowName, String siteCode,String tranDateStr, Connection conn) throws ITMException, Exception
	{
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		String selSql = "";
		String tranId = "";
		String tranSer = "";
		String keyString = "";
		String keyCol = "";
		String xmlValues = "";

		try 
		{
			String monthStr = ""; 
			java.util.Date date= new Date();
			Calendar cal = Calendar.getInstance();
			cal.setTime(date);
			int month = cal.get(Calendar.MONTH);
			month = month - 1;
			if(month < 10)
			{
				monthStr = "0"+month;
			}
			else
			{
				monthStr = ""+month;
			}
			System.out.println("Current Month is=["+monthStr+"]");
			
			
			selSql = "SELECT KEY_STRING, TRAN_ID_COL, REF_SER FROM TRANSETUP WHERE TRAN_WINDOW = ? ";
			pstmt = conn.prepareStatement(selSql);
			pstmt.setString(1, windowName);
			rs = pstmt.executeQuery();
			if (rs.next()) 
			{
				keyString = rs.getString("KEY_STRING");
				keyCol = rs.getString("TRAN_ID_COL");
				tranSer = rs.getString("REF_SER");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;
			System.out.println("keyString :" + keyString);
			System.out.println("keyCol :" + keyCol);
			System.out.println("tranSer :" + tranSer);

			xmlValues = "<?xml version=\"1.0\" encoding=\"utf-8\"?><Root>";
			xmlValues = xmlValues + "<Header></Header>";
			xmlValues = xmlValues + "<Detail1>";
			xmlValues = xmlValues + "<tran_id></tran_id>";
			xmlValues = xmlValues + "<site_code>" + siteCode + "</site_code>";
			xmlValues = xmlValues + "<month>" + monthStr + "</month>";
			xmlValues = xmlValues + "<tran_date>" + tranDateStr +"</tran_date>";
			xmlValues = xmlValues + "</Detail1></Root>";
			System.out.println("xmlValues  :[" + xmlValues + "]");
			TransIDGenerator tg = new TransIDGenerator(xmlValues, "BASE",CommonConstants.DB_NAME);
			tranId = tg.generateTranSeqID(tranSer, keyCol, keyString, conn);
			System.out.println("tranId :" + tranId);

		} 
		catch (SQLException ex) 
		{
			System.out.println("Exception ::" + selSql + ex.getMessage() + ":");
			ex.printStackTrace();
			throw new ITMException(ex);
		} 
		catch (Exception e)
		{
			System.out.println("Exception ::" + e.getMessage() + ":");
			e.printStackTrace();
			throw new ITMException(e);
		} 
		finally 
		{
			if (rs != null) 
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null) 
			{
				pstmt.close();
				pstmt = null;
			}
		}
		return tranId;
	}

	private String checkNull(String input) 
	{
		if (input == null) 
		{
			input = "";
		}
		return input;
	}
}