package ibase.webitm.ejb.wms;



import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.HashMap;

import javax.ejb.Stateless;
import javax.xml.rpc.ParameterMode;

import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.w3c.dom.Document;

import ibase.system.config.ConnDriver;
import ibase.webitm.bean.wms.PaypalRefundParams;
import ibase.webitm.ejb.ActionHandlerEJB;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.utility.E12GenericUtility;
import ibase.webitm.utility.ITMException;
import ibase.webitm.utility.wms.CommonWmsUtil;
import ibase.webitm.utility.wms.SagePayParameters;
@Stateless
public class RefundGateWayPayment extends ActionHandlerEJB implements RefundGateWayPaymentLocal,RefundGateWayPaymentRemote
{
	E12GenericUtility genericUtility = new E12GenericUtility();
	public String actionHandler(String tranId, String xtraParams, String forcedFlag) throws RemoteException,ITMException
	{
		System.out.println("--------------actionHandler method of RefundSagePayment ------------- : ["+tranId+"]");
		String retString = "";	
		Connection conn = null;
		//Commented by Santosh on 14-06-2016
		//ConnDriver connDriver = new ConnDriver();
		
		try
		{		
			//Changed and Commented By Santosh on 14-06-2016 :[START]
			//conn = connDriver.getConnectDB("DriverITM");
			conn = getConnection();
			//connDriver = null;
			//Changed and Commented By Santosh on 14-06-2016 :[ENd]
			retString = segPay(tranId,xtraParams,forcedFlag,conn);			
		}
		catch(Exception e)
		{
			System.out.println("Exception :RefundSagePayment :actionHandler():" + e.getMessage() + ":");
			retString = genericUtility.createErrorString(e);
			e.printStackTrace();
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception e)
			{
				e.printStackTrace();
				throw new ITMException(e);
			}
		}
		
		return retString;
	}
	
	public String segPay(String tranId,String xtraParams,String forcedFlag,Connection conn) throws RemoteException,Exception
	{
		
		ResultSet rs = null;
		PreparedStatement pstmt = null;	
		ITMDBAccessEJB itmdbAccess=new ITMDBAccessEJB();
		String sql = "" ,retString = "",invoiceId = "",currCode = "",payMode = "",sagePayRetStr = "",
				udfStr1 = "",tranIdCrn = "",sreturnTranId = "";
		//Changed by samadhan on 04/08/2015 for paypal refund
		String rcpMode="",payPalRetStr="";
		double segPayNetAmt = 0;		
		try
		{
			System.out.println("-----------in sagPay--------------");
			
			//sql = "SELECT NET_AMT,REF_NO,CURR_CODE,PAY_MODE,UDF_STR1 FROM MISC_PAYMENT WHERE TRAN_ID = ?";
			sql = "SELECT H.NET_AMT,H.REF_NO,H.CURR_CODE,H.PAY_MODE,H.UDF_STR1,D.VOUCH_NO FROM MISC_PAYMENT H,MISC_PAYDET D "
					+ " WHERE H.TRAN_ID = D.TRAN_ID AND H.TRAN_ID = ?";

			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranId);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				segPayNetAmt = rs.getDouble("NET_AMT");
				tranIdCrn = rs.getString("VOUCH_NO") == null ? "" : rs.getString("VOUCH_NO").trim();
				currCode = rs.getString("CURR_CODE") == null ? "" : rs.getString("CURR_CODE").trim();
				payMode = rs.getString("PAY_MODE") == null ? "" : rs.getString("PAY_MODE").trim();
				udfStr1 = rs.getString("UDF_STR1") == null ? "" : rs.getString("UDF_STR1").trim();
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;	
			sql="SELECT INVOICE_ID,TRAN_ID FROM SRETURN WHERE TRAN_ID__CRN  = ?";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1, tranIdCrn);
			rs = pstmt.executeQuery();
			if(rs.next())
			{
				invoiceId =rs.getString("INVOICE_ID") == null ? "" :rs.getString("INVOICE_ID").trim();
				sreturnTranId =rs.getString("TRAN_ID") == null ? "" :rs.getString("TRAN_ID").trim();
			}
			pstmt.close();
			rs.close();
			DecimalFormat df = new DecimalFormat("#.##"); 
			segPayNetAmt = Double.parseDouble(df.format(segPayNetAmt));		
			System.out.println("segPayNetAmt for sage Pay-------->>"+segPayNetAmt);
			System.out.println("payMode for sage Pay-------->>"+payMode);
			System.out.println("udfStr1-------->>"+udfStr1);
			System.out.println("invoiceId-------->>"+invoiceId);
			
			if("R".equalsIgnoreCase(payMode) && udfStr1.length() == 0)				
			{
				//Changed by samadhan on 04/08/2015 for paypal refund Start
				//select rcp_mode from sorder s,invoice i where i.sale_order = s.sale_order and i.invoice_id ='0000000187' ;
				rcpMode = getColumnDescr(conn, "rcp_mode", "sorder s,invoice i", "i.sale_order = s.sale_order and i.invoice_id", invoiceId);
				if(rcpMode.equalsIgnoreCase("P"))
				{
					//Changed by Samadhan on 17/02/2016 for partial refund
					//payPalRetStr = refundPayPal ("Full",invoiceId,currCode,conn);
					payPalRetStr = refundPayPal (segPayNetAmt,invoiceId,currCode,conn);
					System.out.println("Return PayPalRetStr from refundPayPal-------->>["+payPalRetStr+"]");
					if(payPalRetStr != null && payPalRetStr.indexOf("Success") > 0)
					{
						retString = insertPayPalRefundDetail(tranId,payPalRetStr,conn);
						System.out.println("retString After update PayPal Refund details------->>["+retString+"]");					
						retString = confirmedMiscPayment("misc_pay",tranId,xtraParams,"",conn);
					}
					else
					{
						retString = itmdbAccess.getErrorString("", "VTSAGEPAYE", "", "", conn);
					}
				}
				//Changed by samadhan on 10/02/2016 for sagepay only 
				//else
				else if(rcpMode.equalsIgnoreCase("S"))
				{
				//Changed by samadhan on 04/08/2015 for paypal refund End
					sagePayRetStr = authoriseSagePay (segPayNetAmt,invoiceId,sreturnTranId,currCode,conn);
					System.out.println("Return sagePayRetStr from authoriseSagePay-------->>["+sagePayRetStr+"]");
					if(sagePayRetStr != null && sagePayRetStr.indexOf("OK") > 0)
					{
						retString = insertSagePayRefundDetail(tranId,sagePayRetStr,conn);
						System.out.println("retString After update sage Pay details------->>["+retString+"]");					
						retString = confirmedMiscPayment("misc_pay",tranId,xtraParams,"",conn);
					}
					else
					{
						retString = itmdbAccess.getErrorString("", "VTSAGEPAYE", "", "", conn);
					}
				}
				//Changed by samadhan on 10/02/2016 for other rcp_mode start
				else
				{
					retString = itmdbAccess.getErrorString("", "VTINVRCPM", "", "", conn);
				}
				//Changed by samadhan on 10/02/2016 for other rcp_mode end
			}
			else
			{
				retString = confirmedMiscPayment("misc_pay",tranId,xtraParams,"",conn);
			}			
			

		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			if (rs != null )
			{
				rs.close();
				rs = null;
			}	
			if (pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
		}
		return retString;
	}	 
	public String confirmedMiscPayment(String businessObj, String tranIdFr,String xtraParams, String forcedFlag, Connection conn) throws ITMException
	{

		String methodName = "";
		String compName = "";
		String retString = "";
		String serviceCode = "";
		String serviceURI = "";
		String actionURI = "";
		String sql = "";
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		try
		{
			//ConnDriver connDriver = new ConnDriver();
			//conn = connDriver.getConnectDB("DriverITM");
			System.out.println("-------in confirmSaleOrder mothod----------------");			
			tranIdFr=tranIdFr==null ? "" :tranIdFr.trim();
			System.out.println("Tran id for sale order--->>"+tranIdFr+"]");
			methodName = "gbf_post";
			actionURI = "http://NvoServiceurl.org/" + methodName;

			sql = "SELECT SERVICE_CODE,COMP_NAME FROM SYSTEM_EVENTS WHERE OBJ_NAME = ? AND EVENT_CODE = 'pre_confirm' ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,businessObj);
			rs = pstmt.executeQuery();
			if ( rs.next() )
			{
				serviceCode = rs.getString("SERVICE_CODE");
				compName = rs.getString("COMP_NAME");
			}
			if (rs != null )
			{
				rs.close();
				rs = null;
			}
			if (pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			compName=compName==null ? "" :compName.trim();
			System.out.println("serviceCode = ["+serviceCode+"]   compName ["+compName+"]");
			sql = "SELECT SERVICE_URI FROM SYSTEM_EVENT_SERVICES WHERE SERVICE_CODE = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,serviceCode);
			rs = pstmt.executeQuery();
			if ( rs.next() )
			{
				serviceURI = rs.getString("SERVICE_URI");
			}
			if (rs != null )
			{
				rs.close();
				rs = null;
			}	
			if (pstmt != null )
			{
				pstmt.close();
				pstmt = null;
			}
			serviceURI=serviceURI==null ? "" :serviceURI.trim();
			System.out.println("serviceURI = ["+serviceURI+"]---> compName = ["+compName+"]");
			Service service = new Service();
			Call call = (Call)service.createCall();
			call.setTargetEndpointAddress(new java.net.URL(serviceURI));
			call.setOperationName( new javax.xml.namespace.QName("http://NvoServiceurl.org", methodName ) );
			call.setUseSOAPAction(true);
			call.setSOAPActionURI(actionURI);
			Object[] aobj = new Object[4];

			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "component_name"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "tran_id"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "xtra_params"), XMLType.XSD_STRING, ParameterMode.IN);
			call.addParameter( new javax.xml.namespace.QName("http://NvoServiceurl.org", "forced_flag"), XMLType.XSD_STRING, ParameterMode.IN);

			aobj[0] = new String(compName);
			aobj[1] = new String(tranIdFr);
			aobj[2] = new String(xtraParams);
			aobj[3] = new String(forcedFlag);
			//System.out.println("@@@@@@@@@@loginEmpCode:" +genericUtility.getValueFromXTRA_PARAMS(xtraParams,"loginEmpCode")+":");
			System.out.println("@@@@@@ call.setReturnType(XMLType.XSD_STRING) executed........");
			call.setReturnType(XMLType.XSD_STRING);

			retString = (String)call.invoke(aobj);

			System.out.println("Confirm Complete @@@@@@@@@@@ Return string from NVO is:==>["+retString+"]");

		}
		catch(Exception e)
		{			
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{		
			try{
				if (rs != null )
				{
					rs.close();
					rs = null;
				}
				if (pstmt != null )
				{
					pstmt.close();
					pstmt = null;
				}				
			}
			catch(Exception e)
			{
				System.out.println("Exception inCalling confirmed");
				e.printStackTrace();
				try{
					conn.rollback();

				}catch (Exception s)
				{
					System.out.println("Unable to rollback");
					s.printStackTrace();
				}
				throw new ITMException(e);
			}

		}
		return retString;
	
	}
	private String insertSagePayRefundDetail(String tranId,String sagePayStr,Connection conn)throws Exception,ITMException
	{
		ResultSet rs = null;
		PreparedStatement pstmt = null;	
		String sql = "",cardType = "",retString = "";
		StringBuffer sagePayInfo = new StringBuffer();
		HashMap <String,String> sagePayDetailMap = new HashMap <String,String>();
		try
		{		
			if(tranId!= null && tranId.length() > 0)
			{			
				sagePayStr = sagePayStr.replaceFirst("VPSProtocol", ",VPSProtocol");
				sagePayStr = sagePayStr.replaceFirst("Status", ",Status");
				sagePayStr = sagePayStr.replaceFirst("StatusDetail", ",StatusDetail");
				sagePayStr = sagePayStr.replaceFirst("VPSTxId", ",VPSTxId");
				sagePayStr = sagePayStr.replaceFirst("SecurityKey", ",SecurityKey");
				sagePayStr = sagePayStr.replaceFirst("TxAuthNo", ",TxAuthNo");
				sagePayStr = sagePayStr.replaceFirst("AVSCV2", ",AVSCV2");
				sagePayStr = sagePayStr.replaceFirst("CV2Result", ",CV2Result");
				sagePayStr = sagePayStr.replaceFirst("AddressResult", ",AddressResult");
				sagePayStr = sagePayStr.replaceFirst("DeclineCode", ",DeclineCode");
				sagePayStr = sagePayStr.replaceFirst("BankAuthCode", ",BankAuthCode");
				
				sagePayStr = sagePayStr.substring(1,sagePayStr.length());
				System.out.println("after substr sagePayStr["+sagePayStr+"]");
				String[] dataStr = sagePayStr.split(",");
				System.out.println("dataStr["+dataStr.toString()+"]");
				
				for(String token:dataStr)
				{
					System.out.println("token["+token+"]");
					String [] data = token.split("=");
					sagePayDetailMap.put(data[0], data[1]);
				}
				System.out.println("sagePayDetailMap["+sagePayDetailMap.toString()+"]");
				sagePayInfo.append("<ROOT>");				
				sagePayInfo.append("<VPSPROTOCOL>"+sagePayDetailMap.get("VPSProtocol"));				
				sagePayInfo.append("</VPSPROTOCOL>");
				
				sagePayInfo.append("<STATUS>"+sagePayDetailMap.get("Status"));				
				sagePayInfo.append("</STATUS>");
				
				sagePayInfo.append("<STATUSDETAIL>"+sagePayDetailMap.get("StatusDetail"));
				sagePayInfo.append("</STATUSDETAIL>");
				
				sagePayInfo.append("<VPSTXID>"+sagePayDetailMap.get("VPSTxId"));
				sagePayInfo.append("</VPSTXID>");
				
				sagePayInfo.append("<SECURITYKEY>"+sagePayDetailMap.get("SecurityKey"));
				sagePayInfo.append("</SECURITYKEY>");
				
				sagePayInfo.append("<TXAUTHNO>"+sagePayDetailMap.get("TxAuthNo"));
				sagePayInfo.append("</TXAUTHNO>");
				
				sagePayInfo.append("<BANKAUTHCODE>"+sagePayDetailMap.get("BankAuthCode"));
				sagePayInfo.append("</BANKAUTHCODE>");
				
				sagePayInfo.append("<CARDTYPE>"+cardType);
				sagePayInfo.append("</CARDTYPE>");
				sagePayInfo.append("</ROOT>");
				System.out.println("sagePayInfo.toString()["+sagePayInfo.toString()+"]");
				sql = "UPDATE MISC_PAYMENT SET UDF_STR1 = ? WHERE TRAN_ID = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, sagePayInfo.toString());
				pstmt.setString(2, tranId);
				int count = pstmt.executeUpdate();
				if(count > 0)
				{
					conn.commit();
					retString = "Success";
				}
			}
			
			
			
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}
		return retString;
	}
	private String authoriseSagePay(double segPayNetAmt,String invoiceId,String sreturnTranid,String currCode,Connection conn) throws Exception,ITMException
	{
		String responseStr = "";
		CommonWmsUtil commonWmuUtil = new CommonWmsUtil();
		Document dom = null;
		ResultSet rs = null;
		PreparedStatement pstmt = null;	
		String sagpayUrl = "";
		String vendor = "";
		String sagePayVersion = "";
		String sagePayTransType = "";
		String sagePayApply = "";
		String sagePayProfile = "";
		SagePayParameters param = null;
		HashMap sordMap = null;
		String TxAuthNo = "",vpsTxId = "",securityKey ="",sql = "",despatchId = "",refundDetails = "",
				saleOrder = "",ptcn = "";
		double payAmt = 0.0;
		E12GenericUtility genericUtility = null;

		try
		{
			genericUtility  = new E12GenericUtility();			
			despatchId = getColumnDescr(conn,"DESP_ID","INVOICE","INVOICE_ID",invoiceId);
			saleOrder = getColumnDescr(conn,"SORD_NO","DESPATCH","DESP_ID",despatchId);
			ptcn = getColumnDescr(conn,"PTCN","WAVE_TASK_DET","SALE_ORDER",saleOrder);
			
			System.out.println("despatchId------>>["+despatchId+"]");	
			System.out.println("invoiceId------>>["+invoiceId+"]");	
			System.out.println("ptcn------>>["+ptcn+"]");	
			System.out.println("sreturnTranid@@@------>>["+sreturnTranid+"]");
			

			dom = commonWmuUtil.getDDDom("");
			param = new SagePayParameters();

			System.out.println("CONFIG xml["+genericUtility.serializeDom(dom)+"]");

			sagpayUrl = genericUtility.getColumnValue("SAGEPAY_URL_REFUND", dom);// (String)dom.getElementsByTagName("SAGEPAY_URL").item(0).getNodeValue();
			vendor = genericUtility.getColumnValue("VENDOR", dom);//(String)dom.getElementsByTagName("VENDOR").item(0).getNodeValue();
			sagePayVersion = genericUtility.getColumnValue("SAGEPAY_VERSION", dom);//(String)dom.getElementsByTagName("SAGEPAY_VERSION").item(0).getNodeValue();
			sagePayProfile = genericUtility.getColumnValue("SAGEPAY_PROFILE", dom);//(String)dom.getElementsByTagName("SAGEPAY_PROFILE").item(0).getNodeValue();
			sagePayTransType = genericUtility.getColumnValue("TX_TYPE", dom);//(String)dom.getElementsByTagName("SAGEPAY_TRANSTYPE").item(0).getNodeValue();
			sagePayApply = genericUtility.getColumnValue("SAGEPAY_APPLY", dom);//(String)dom.getElementsByTagName("SAGEPAY_APPLY").item(0).getNodeValue();

			System.out.println("sagpayUrl xml["+sagpayUrl+"]vendor["+vendor+"]");
			

			//sordMap = getDespatchDetails(despatchId,saleOrder,conn);
			refundDetails = getColumnDescr(conn,"token_info","despatch","desp_id",despatchId);
			System.out.println("refundDetails------>>["+refundDetails+"]");	
			dom = null;
			if(refundDetails != null && refundDetails.length() > 0)
			{
				 dom = genericUtility.parseString(refundDetails); 				 
				 vpsTxId = genericUtility.getColumnValue("VPSTXID", dom);
				 securityKey = genericUtility.getColumnValue("SECURITYKEY", dom);
				 TxAuthNo = genericUtility.getColumnValue("TXAUTHNO", dom);
			}		
			System.out.println("vpsTxId@@@------>>["+vpsTxId+"]");
			System.out.println("securityKey@@@------>>["+securityKey+"]");
			System.out.println("TxAuthNo@@@------>>["+TxAuthNo+"]");
			System.out.println("sagePayTransType@@@------>>["+sagePayTransType+"]");
			
			System.out.println("sagePayProfile@@@------>>["+sagePayProfile+"]");
			System.out.println("sagePayVersion@@@------>>["+sagePayVersion+"]");
			System.out.println("sagePayApply@@@------>>["+sagePayApply+"]");
			
			System.out.println("sagePayApply ["+sagePayApply+"]vendor["+vendor+"]currCode ["+currCode+"]");	
			System.out.println("ptcn@@@------>>["+ptcn+"]");
			
			
			param.setVPSProtocol(sagePayVersion);
			param.setTxType(sagePayTransType);
			param.setVendor(vendor);
			param.setAmount(segPayNetAmt+"");
			param.setCurrency(currCode);
			param.setDescription("Refund Test Description");
			param.setRelatedVPSTxId(vpsTxId);
			//param.setVendorTxCode("Base_" + Helpers.GetRandomNumber()); //This should be your own reference code to the transaction. 
			param.setVendorTxCode("BaseERP_" + sreturnTranid); //This should be your own reference code to the transaction.
			param.setRelatedVendorTxCode("BaseERP_" + ptcn);
			param.setRelatedSecurityKey(securityKey);
			param.setRelatedTxAuthNo(TxAuthNo);
			param.setApplyAVSCV2(sagePayApply);
			
			
			

			responseStr = commonWmuUtil.AuthorizePayment(param, sagpayUrl);
			System.out.println("responseStr from AuthorizePayment@@ : "+responseStr);			

		}
		catch(Exception e)
		{
			System.out.println("Exception in authoriseSagePay method.......");			
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}

		return responseStr;
	}
	
	
	protected String getColumnDescr(Connection conn, String columnName ,String tableName, String columnName2, String value) throws Exception
	{

			PreparedStatement pstmt = null ;
			ResultSet rs = null ; 
			String sql = "";
			String findValue = "";
			try
			{			
				sql = "SELECT " + columnName + " from " + tableName + " where " + columnName2 +"= ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1,value);
				rs = pstmt.executeQuery();
				if(rs.next())
				{					
					findValue = rs.getString(1) == null ? "" :rs.getString(1).trim();
				}
				rs.close();
				rs = null;
				pstmt.close();
				pstmt = null;	        
			}
			catch(Exception e)
			{
				System.out.println("Exception in getColumnDescr ");
				e.printStackTrace();
			}
			finally
			{
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			System.out.println("returning String from getColumnDescr " + findValue);
			return findValue;
		 
	}

	//Changed By Samadhan on 04/08/2015 for paypal refund start
	@SuppressWarnings("static-access")
	private String refundPayPal(Double refundAmount,String invoiceId,String currCode,Connection conn) throws Exception,ITMException
	{
		String responseStr = "";
		CommonWmsUtil commUtil = new CommonWmsUtil();
		Document dom = null;
		ResultSet rs = null;
		PreparedStatement pstmt = null;	
		String payPalUrl = "";
		//String refundType = "Partial";
	
		PaypalRefundParams paypalRetParam = null;
		String despatchId = "",refundDetails = "";
		String tranId="";
		E12GenericUtility genericUtility = null;

		try
		{
			genericUtility  = new E12GenericUtility();			
			despatchId = getColumnDescr(conn,"DESP_ID","INVOICE","INVOICE_ID",invoiceId);
						
			System.out.println("despatchId------>>["+despatchId+"]");	
			System.out.println("invoiceId------>>["+invoiceId+"]");	
			
			paypalRetParam = new PaypalRefundParams();

			refundDetails = getColumnDescr(conn,"token_info","despatch","desp_id",despatchId);
			System.out.println("AuthorizationDetails------>>["+refundDetails+"]");	
			dom = null;
			if(refundDetails != null && refundDetails.length() > 0)
			{
				dom = genericUtility.parseString(refundDetails); 	
				System.out.println("CONFIG xml["+genericUtility.serializeDom(dom)+"]");
				tranId = genericUtility.getColumnValue("TRANSACTIONID", dom);
			}		
			System.out.println("TransationId@@@------>>["+tranId+"]");
			payPalUrl = commUtil.getDDSalesConfig("PAYPAL_URL");
				
			paypalRetParam.setUser(commUtil.getDDSalesConfig("PAYPAL_APIUSERNAME"));
            paypalRetParam.setPwd(commUtil.getDDSalesConfig("PAYPAL_APIPASSWORD"));
            paypalRetParam.setSignature(commUtil.getDDSalesConfig("PAYPAL_APISIGNATURE"));
            paypalRetParam.setMethod(commUtil.getDDSalesConfig("PAYPAL_REFUND_METHOD"));
            paypalRetParam.setVersion(commUtil.getDDSalesConfig("PAYPAL_VERSION"));
            paypalRetParam.setTransactionId(tranId);
            paypalRetParam.setRefundType("Partial");
            //Changed by Samadhan on 17/02/2016 for partial refund Start
            paypalRetParam.setAmt(refundAmount+"");
            paypalRetParam.setCurrencyCode(currCode);
            //Changed by Samadhan on 17/02/2016 for partial refund End
            responseStr = commUtil.PaypalRefundPayment(payPalUrl,paypalRetParam);
			System.out.println("responseStr from PayPalRefund@@ : "+responseStr);			

		}
		catch(Exception e)
		{
			System.out.println("Exception in PayPal Refund.......");			
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt != null)
			{
				pstmt.close();
				pstmt = null;
			}
		}

		return responseStr;
	}
	
	private String insertPayPalRefundDetail(String tranId,String payPalStr, Connection conn) throws Exception ,ITMException
	{		
		PreparedStatement pstmt = null;
		String sql = "",retString = "";
		int rowCnt = 0;		
		System.out.println("insertPayPalRefundDetail Into MISC_PAYMENT---->>["+payPalStr+"");
		StringBuffer payPalInfo = new StringBuffer();
		
		try
		{
			payPalInfo.append("<ROOT>");
			if(payPalStr != null && payPalStr.length() > 0)
			{
				String params[] = payPalStr.split("&");
				for(int i=0;i<params.length;i++)
				{
					String param[] = params[i].split("=");
					if(param.length>1)
					{
						payPalInfo.append("<"+param[0]+">"+param[1]);				
						payPalInfo.append("</"+param[0]+">");
					}
				}
			}		
		
			payPalInfo.append("</ROOT>");
			System.out.println("PayPalRefundInfo : "+payPalInfo.toString());
			if(payPalInfo != null && payPalInfo.length() > 0)
			{
				
				sql = "UPDATE MISC_PAYMENT SET UDF_STR1 = ? WHERE TRAN_ID = ?";
				pstmt = conn.prepareStatement(sql);
				pstmt.setString(1, payPalInfo.toString());
				pstmt.setString(2, tranId);
				rowCnt = pstmt.executeUpdate();
				System.out.println("MISC_PAYMENT rowCnt: "+rowCnt);
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rowCnt > 0)	
				{
					conn.commit();
					retString = "Success";
					System.out.println("PayPal Refund details updated successfully.............");
				}
				else
				{
					retString = "Error";
				}
				
			}		
			
		}
		catch(Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		}
		
		return retString;
	}
	
	//Changed by Samadhan on 04/08/2015 for paypal refund End
	
	
}
