package ibase.webitm.ejb.fin;
import ibase.system.config.AppConnectParm;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.MasterStatefulLocal;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.ejb.dis.DistCommon;
//import ibase.webitm.utility.GenericUtility;
import ibase.webitm.utility.ITMException;
import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;

import javax.naming.InitialContext;
import javax.xml.rpc.ParameterMode;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.w3c.dom.Document;
@javax.ejb.Stateless

public class MiscPayPostSave extends ValidatorEJB implements MiscPayPostSaveLocal, MiscPayPostSaveRemote
{        

	FinCommon finCommon = new FinCommon();
	DistCommon distCommon = new DistCommon();

	public String postSave()throws RemoteException,ITMException
	{
		return "";
	}

	public String postSave( String domString, String editFlag, String xtraParams, Connection conn ) throws RemoteException,ITMException
	{

		System.out.println("In MiscPayPostSave ... ");

		PreparedStatement pstmt = null;
		Document dom = null;                
		ResultSet rs =null;
		boolean isError = false;

		String tranId = "";
		String errString ="";
		String xmlString =null;
		String sql = null;

		String currCode = "";
		double exchRate = 0, netAmt =0, diffAmtExch = 0,taxAmt=0,bankCharges=0,discAmt=0 ;
			 
		int cnt=0;
		try
		{

//			GenericUtility genericUtility = GenericUtility.getInstance();
			E12GenericUtility genericUtility = new E12GenericUtility();
			dom = genericUtility.parseString(domString);

			tranId = genericUtility.getColumnValue("tran_id",dom);
//Cross update corrected by Manoj dtd 11/04/2016 for discount amount, tax amount and bank chanrges 
			sql="select curr_code,exch_rate from misc_payment WHERE  tran_id = ? " ;
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId );
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				currCode = rs.getString("curr_code");
				exchRate = rs.getDouble("exch_rate");
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			sql="UPDATE misc_paydet set exch_rate =  ? "
			+" WHERE  tran_id = ? "
			+ " and (curr_code = ?  or exch_rate is null) ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setDouble(1,exchRate );
			pstmt.setString(2,tranId );
			pstmt.setString(3,currCode );
			cnt = pstmt.executeUpdate();
			pstmt.close();
			pstmt = null;
			
			sql="update misc_paydet set net_pay_amt=pay_amt+tax_amt-discount_amt where tran_id=?";
			pstmt=conn.prepareStatement(sql);
			pstmt.setString(1,tranId);
			pstmt.executeUpdate();
			pstmt.close();
			pstmt=null;
				
			sql="UPDATE misc_paydet set diff_amt__exch =  (pay_amt * exch_rate__vouch) - (pay_amt * exch_rate) "
			+" WHERE  tran_id = ? "
			+ " and (curr_code = ?  or exch_rate is null) ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setString(1,tranId );
			pstmt.setString(2,currCode );
			cnt = pstmt.executeUpdate();
			pstmt.close();
			pstmt = null;

			sql="select sum( (PAY_AMT + TAX_AMT - DISCOUNT_AMT )*(EXCH_RATE / ? ) ), sum(diff_amt__exch),sum(tax_amt),sum(bank_charges),sum(discount_amt)  from misc_paydet WHERE  tran_id = ? " ;
			pstmt = conn.prepareStatement(sql);
			pstmt.setDouble(1,exchRate );
			pstmt.setString(2,tranId );
			rs = pstmt.executeQuery();
			if (rs.next())
			{
				netAmt = rs.getDouble(1);
				diffAmtExch = rs.getDouble(2);
				taxAmt=rs.getDouble(3);
				bankCharges=rs.getDouble(4);
				discAmt=rs.getDouble(5);
			}
			rs.close();
			rs = null;
			pstmt.close();
			pstmt = null;

			sql="UPDATE misc_payment set net_amt = ?, diff_amt__exch = ?, net_amt__bc = ? * exch_rate,"
					+ "tax_amt=?,bank_charges=?,discount_amt=? "
			+" WHERE  tran_id = ? ";
			pstmt = conn.prepareStatement(sql);
			pstmt.setDouble(1,netAmt );
			pstmt.setDouble(2,diffAmtExch );
			pstmt.setDouble(3,netAmt );
			pstmt.setDouble(4,taxAmt );
			pstmt.setDouble(5,bankCharges );
			pstmt.setDouble(6,discAmt );
			pstmt.setString(7,tranId );
			cnt = pstmt.executeUpdate();
			pstmt.close();
			pstmt = null;

			if( cnt > 0)
			{
				System.out.println("update successfully ["+cnt+"]");
			}
				
			//}
		}
		catch(Exception e)
		{
			try {
				conn.rollback();
			} catch (SQLException e1) {
				// TODO Auto-generated catch block
				e1.printStackTrace();
			}
			isError = true;
			System.out.println("Exception :DcdetPostSaveEJB : :==>\n"+e.getMessage());
			e.printStackTrace();
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				System.out.println("isError ["+isError+"]");
				if( conn != null )
				{

					/*if( isError )
					{
						conn.rollback();
					}
					else
					{
						conn.commit();
					}*/
				}
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
			}
			catch(Exception e)
			{
				System.out.println("Exception :SavexPreSaveEJB : :==>\n"+e.getMessage());
				try
				{
					System.out.println("Before rollback");
					conn.rollback();
				}

				catch(SQLException sqle)
				{
					System.out.println(sqle);
				}
				throw new ITMException(e);
			}
		}
		System.out.println("Out DcdetPostSaveEJB ... ");
		return "";                
			}
	private java.math.BigDecimal round(int scale ,double round)
	{
		return new java.math.BigDecimal(round).setScale(scale, java.math.BigDecimal.ROUND_UP);
	}

	private double roundVal(double round,int scale)
	{
		return Math.round(round*Math.pow(10, scale))/Math.pow(10, scale);
	}
}