<?xml version='1.0' encoding='utf-8'?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html"/>
<xsl:template match="/">
<html>
	<head>
		<link type="text/css" rel="stylesheet" href="/ibase/css/workflowsign.css"/>
	</head>
	<body>
		<div> 					
			<table width="100%" class="tTableHeader">
				<tr>
					<td colspan="4" align="center" class="tTitle">Journal Voucher</td>
				</tr>
				<tr>
					<td>
						<span class="tLabel">Journal Voucher No. : </span>
						<span class="tLabelData"><xsl:value-of select="//Detail1/tran_id"/></span>
					</td>
					<td>
						<span class="tLabel">Transaction Type : </span>
						<span class="tLabelData"><xsl:value-of select="//Detail1/tran_type"/></span>
					</td>
					<td>
						<span class="tLabel">Transaction Date : </span>
						<span class="tLabelData"><xsl:value-of select="//Detail1/tran_date"/></span>
					</td>
					<td>
						<span class="tLabel">Effective Date : </span>
						<span class="tLabelData"><xsl:value-of select="//Detail1/eff_date"/></span>
					</td>				
				</tr>
				<tr>
					<td>
						<span class="tLabel">Reference Series : </span>
						<span class="tLabelData"><xsl:value-of select="//Detail1/ref_ser"/> </span>
					</td>
					<td colspan="2">
						<span class="tLabel">Reference No. : </span>
						<span class="tLabelData"><xsl:value-of select="//Detail1/ref_no"/> </span>
					</td>
					<td>						
						<span class="tLabelData">							
							<xsl:choose>
								<xsl:when test="//Detail1/reversible = 'Y'">Reversible</xsl:when>
								<xsl:when test="//Detail1/reversible = 'N'">Non-Reversible</xsl:when>
							</xsl:choose>
						</span>
					</td>
				</tr>
				<tr>
					<td colspan="4">
						<span class="tLabel">Site: </span>
						<span class="tLabelData"><xsl:value-of select="//Detail1/site_code"/> [<xsl:value-of select="//Detail1/site_descr"/>]</span>
					</td>				
				</tr>
				<tr>
					<td colspan="2">
						<span class="tLabel">Reverse Site : </span>
						<span class="tLabelData"><xsl:value-of select="//Detail1/site_code__rev"/>[<xsl:value-of select="//Detail1/site_b_descr"/>]</span>
					</td>
					<td colspan="2">
						<span class="tLabel">Site For : </span>
						<span class="tLabelData"><xsl:value-of select="//Detail1/site_code__for"/> [<xsl:value-of select="//Detail/site_descr_1"/>]</span>
					</td>				
				</tr>
				<tr>
					<td colspan="4">
						<span class="tLabel">Remarks : </span>
						<span class="tLabelData"><xsl:value-of select="//Detail1/remarks"/></span>
					</td>
				</tr>
			</table>
		</div>		
		<br /> <br />
		<div>
			<table width="100%" class="tTableDetail">
		   		<xsl:if test="//Detail2/line_no!=''">			
				<tr>
					<td colspan="6" align="center" class="tTitleD">Details</td>
				</tr>
				<tr>
					<td class="tLabelD">Journal Voucher No.</td>
					<td class="tLabelD">Line No.</td>
					<td class="tLabelD">Account</td>
					<td class="tLabelD">Cost Center</td>				
					<td class="tLabelD">Debit/Credit</td>
					<td class="tLabelD">Amount</td>				
				</tr>
				
				<xsl:for-each select="//Detail2">					
				<tr>
					<td class="tLabelDataD"><xsl:value-of select="tran_id"/></td>
					<td class="tLabelDataD"><xsl:value-of select="line_no"/></td>
					<td class="tLabelDataD"><xsl:value-of select="acct_code"/> [<xsl:value-of select="accounts_descr"/>]</td>
					<td class="tLabelDataD"><xsl:value-of select="cctr_code"/></td>
					<td class="tLabelDataD"><xsl:value-of select="drcr_flag"/></td>
					<td class="tLabelDataD"><xsl:value-of select="amount"/></td>
				</tr>
				</xsl:for-each>
				</xsl:if>
			</table>
		</div>
	</body>
</html>
</xsl:template>
</xsl:stylesheet>
