package ibase.dashboard.servlet;

import ibase.dashboard.ejb.SalesPerformanceRemote;
import ibase.system.config.AppConnectParm;
import ibase.webitm.utility.ITMException;

import java.io.IOException;
import java.io.OutputStream;

import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.json.simple.JSONObject;

public class SalesPrfrmncMetaDataServlet extends HttpServlet
{
	private static final long serialVersionUID = 1L;
	JSONObject jsonObjMetaData =null;

	public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		doPost(request, response);
	}

	@SuppressWarnings("unchecked")
	public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException
	{
		SalesPerformanceRemote salesPersonSales = null;
		InitialContext context = null;
		AppConnectParm appConnectParm = new AppConnectParm();
		try
		{
			response.setContentType("application/json");
			context = new InitialContext(appConnectParm.getProperty());
			String fileName= request.getParameter("fileName");
                       System.out.println(" get File Name for Each calling ===" + fileName);
			salesPersonSales = (SalesPerformanceRemote) context.lookup("ibase/SalesPerformance/remote");
			if(fileName!=null && fileName.trim().length()>0)
			{
			    jsonObjMetaData = (JSONObject) salesPersonSales.getMetaData(fileName);
			   }
			System.out.println(" getMetaData  in SalesPrfrmncMetaDataServlet===" + jsonObjMetaData);
			OutputStream outputStream = response.getOutputStream();
			outputStream.write(jsonObjMetaData.toString().getBytes());
			outputStream.flush();
			outputStream.close();

		} catch (Exception e)
		{
			System.out.println("Exception : SalesPerfrmncDataServlet :doPost(HttpServletRequest request, HttpServletResponse response) :" + e);
			try
			{
				throw new ITMException(e);
			} catch (ITMException e1)
			{
				e1.printStackTrace();
			}
		}
	}

}