package ibase.webitm.ejb.wms;

import ibase.system.config.AppConnectParm;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import javax.naming.InitialContext;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@javax.ejb.Stateless
public class WavegenWizPos extends ValidatorEJB implements WavegenWizPosLocal, WavegenWizPosRemote
{
	String waveID = "";
	
	public String postSave(String xmlStringAll, String dcrId, String editFlag, String xtraParams, Connection conn) throws RemoteException,ITMException
	{
		String retString="";
		try
		{
			System.out.println("xmlStringAll["+xmlStringAll+"]");
			System.out.println("dcrId["+dcrId+"]");
			System.out.println("editFlag["+editFlag+"]");
			retString = generateWaveTask(xmlStringAll,xtraParams,conn);	
			
			System.out.println("retString from generateWaveTask["+retString+"]");
		}
		catch(Exception e)
		{
			System.out.println("WavegenWizPos.postSave()");
			e.printStackTrace();
		}
		
		return retString;
	}
	
	public String generateWaveTask(String xmlStringAll, String xtraParmas, Connection conn)
	{
		String retString="", headerXMLStr = "", detailXMLStr = "", nodeName = "";
		Document allXMLDom = null;
		StringBuffer headerStrBuff = new StringBuffer();
		StringBuffer detailStrBuff = new StringBuffer();
		InitialContext ctx = null;
		WaveGenerationPrcRemote waveGenerationPrcRemote = null;
		
		try
		{
			System.out.println("*****************WavegenWizPos Post Save Started**************************");
			E12GenericUtility e12GeneticUitlity = new E12GenericUtility();
			allXMLDom = e12GeneticUitlity.parseString(xmlStringAll);
			
			System.out.println("headerXML creating started");
			
			headerStrBuff.append("<DocumentRoot><description>Datawindow Root</description><group0><description>Group0 description</description><Header0>");
			headerStrBuff.append("<description>Header0 members</description><Detail1 dbID='1' domID='1' objContext='1' objName='wavegen'><attribute pkNames='' selected='N' status='N' updateFlag='A' />");
			
			NodeList detail1NodeList = allXMLDom.getElementsByTagName("Detail1");
			int detail1NodeListLen = detail1NodeList.getLength();
			
			for(int i=0; i<detail1NodeListLen; i++)
			{
				NodeList eachDetail1NodeList = detail1NodeList.item(0).getChildNodes();

				for(int j=0; j<eachDetail1NodeList.getLength();j++)
				{
					Node eachDetail1Element = eachDetail1NodeList.item(j);
					nodeName = eachDetail1Element.getNodeName();
					
					if(!"#text".equalsIgnoreCase(nodeName) && !"attribute".equals(nodeName))
					{
						headerStrBuff.append("<"+nodeName+"><![CDATA["+eachDetail1Element.getTextContent()+"]]></"+nodeName+">");
					}
				}
			}
			
			headerStrBuff.append("</Detail1></Header0></group0></DocumentRoot>");
			
			System.out.println("headerXML creating completed");
			
			System.out.println("headerStrBuff.toString["+headerStrBuff.toString()+"]");
			
			System.out.println("detailXML creating started");
			
			detailStrBuff.append("<DocumentRoot><description>Datawindow Root</description><group0><description>Group0 description</description><Header0><description>Header0 members</description>");
			
			NodeList detail2NodeList = allXMLDom.getElementsByTagName("Detail2");
			int detail2NodeListLen = detail2NodeList.getLength();
			
			for(int i=0; i<detail2NodeListLen; i++)
			{
				Node eachDetail2 = detail2NodeList.item(i);
				String domID = eachDetail2.getAttributes().getNamedItem("domID").getFirstChild().getNodeValue();
				detailStrBuff.append("<Detail2 dbID='"+domID+"' domID='"+domID+"' objContext='2' objName='wavegen' >");
				detailStrBuff.append("<attribute pkNames='' selected='Y' status='' updateFlag='' />");
				NodeList eachDetail2NodeList = eachDetail2.getChildNodes();
				for(int j=0; j<eachDetail2NodeList.getLength();j++)
				{
					Node eachDetail2Element = eachDetail2NodeList.item(j);
					nodeName = eachDetail2Element.getNodeName();
					
					if(!"#text".equalsIgnoreCase(nodeName) && !"attribute".equals(nodeName))
					{
						detailStrBuff.append("<"+nodeName+"><![CDATA["+eachDetail2Element.getTextContent()+"]]></"+nodeName+">");
					}
				}
				
				detailStrBuff.append(" </Detail2>");
			}
			
			detailStrBuff.append("</Header0></group0></DocumentRoot>");
			
			System.out.println("detailXML creating completed");
			
			System.out.println("detailStrBuff.toString["+detailStrBuff.toString()+"]");
			
			headerXMLStr = headerStrBuff.toString();
			detailXMLStr = detailStrBuff.toString();
			
			ctx=getInitialContext();
			waveGenerationPrcRemote = (ibase.webitm.ejb.wms.WaveGenerationPrcRemote) ctx.lookup("ibase/WaveGenerationPrc/remote");
			retString = waveGenerationPrcRemote.process(headerXMLStr, detailXMLStr, "wavegen", xtraParmas);
			
			System.out.println("********retString["+retString+"]***********");
			
			if(retString != null && retString.trim().length()>0)
			{
				if(retString.indexOf("VTCOMPL")!=-1)
				{
					waveID = retString.substring(retString.indexOf("[")+1,retString.indexOf("]"));
					retString = "Wave Task Generated Successfully!";
					System.out.println("::::::Generated WaveID["+waveID+"]");
				}
			}
			
			System.out.println("*****************WavegenWizPos Post Save Ended**************************");
		}
		catch(Exception e)
		{
			System.out.println("WavegenWizPos.generateWaveTask()");
			e.printStackTrace();
		}
		return retString;
	}
	
	public String getSummaryData()
	{
		String retXMLStr = "",sql = "";
		Connection conn=null;
		PreparedStatement pstmt = null;
		ResultSet rs = null;
		StringBuffer summaryStrBuff = new StringBuffer();
		int domID = 0;
		boolean isError = false, isTaskGenerated = false;
		ITMDBAccessEJB itmDBAccessEJB = new ITMDBAccessEJB();
		
		try
		{
			if(waveID.trim().length()>0 && waveID!=null)
			{
				conn = getConnection();
				
				summaryStrBuff.append("<root>");
				 
				sql = " SELECT WAVE_TASK_DET.WAVE_ID,WAVE_TASK_DET.LINE_NO,WAVE_TASK_DET.REF_SER,WAVE_TASK_DET.REF_ID,WAVE_TASK_DET.STATUS,"
					+ " WAVE_TASK_DET.PTCN,WAVE_TASK_DET.SALE_ORDER,WAVE_SEQ.PRIORITY,FN_WAVE_DESCRIPTION(WAVE_TASK_DET.REF_SER,WAVE_TASK_DET.REF_ID,"
					+ " WAVE_TASK_DET.PTCN)  AS DESCR,CASE WHEN WAVE_STATUS = 'C' THEN 'CREATED' WHEN WAVE_STATUS = 'V' THEN 'VERIFIED'"
					+ " WHEN WAVE_STATUS = 'W' THEN 'HELD' WHEN WAVE_STATUS = 'D' THEN 'DEALLOCATED' ELSE ' ' END  WAVE_STATUS"
					+ " FROM WAVE_TASK_DET  WAVE_TASK_DET,WAVE_SEQ  WAVE_SEQ WHERE ( WAVE_TASK_DET.REF_SER=WAVE_SEQ.REF_SER(+)) AND"
					+ " WAVE_TASK_DET.WAVE_ID = ? ORDER BY WAVE_SEQ.PRIORITY ASC";
				pstmt=conn.prepareStatement(sql);
				pstmt.setString(1, waveID);
				rs=pstmt.executeQuery();
				
				
				while(rs.next())
				{
					isTaskGenerated = true;
					summaryStrBuff.append("<summaryData domID='"+(++domID)+"'>");
					summaryStrBuff.append("<wave_id><![CDATA["+checkNull(rs.getString("WAVE_ID"))+"]]></wave_id>");
					summaryStrBuff.append("<line_no><![CDATA["+checkNull(rs.getString("LINE_NO"))+"]]></line_no>");
					summaryStrBuff.append("<ref_ser><![CDATA["+checkNull(rs.getString("REF_SER"))+"]]></ref_ser>");
					summaryStrBuff.append("<ref_id><![CDATA["+checkNull(rs.getString("REF_ID"))+"]]></ref_id>");
					summaryStrBuff.append("<status><![CDATA["+checkNull(rs.getString("STATUS"))+"]]></status>");
					summaryStrBuff.append("<ptcn><![CDATA["+checkNull(rs.getString("PTCN"))+"]]></ptcn>");
					summaryStrBuff.append("<sale_order><![CDATA["+checkNull(rs.getString("SALE_ORDER"))+"]]></sale_order>");
					summaryStrBuff.append("<descr><![CDATA["+checkNull(rs.getString("DESCR"))+"]]></descr>");
					summaryStrBuff.append("<wave_status><![CDATA["+checkNull(rs.getString("WAVE_STATUS"))+"]]></wave_status>");
					summaryStrBuff.append("</summaryData>");
				}
				
				if(pstmt != null)
				{
					pstmt.close();
					pstmt = null;
				}
				if(rs != null)
				{
					rs.close();
					rs = null;
				}
				
				summaryStrBuff.append("</root>");
				
			}
						
			retXMLStr = summaryStrBuff.toString();
			
			if(!isTaskGenerated)
			{
				retXMLStr = itmDBAccessEJB.getErrorString("","VTWATSKE","","",conn);
			}
			
			System.out.println("SummaryData retXMLStr["+retXMLStr+"]");
			
		}
		catch(Exception e)
		{
			System.out.println("WavegenWizPos.getSummaryData()"+e.getMessage());
			e.printStackTrace();
			isError = true;
		}
		finally
		{
			try
			{
				if(isError)
				{
					if(pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}
					if(rs != null)
					{
						rs.close();
						rs = null;
					}
				}
				
				if(!conn.isClosed() && conn!=null)
				{
					conn.close();
					conn = null;
				}
				
			}
			catch(Exception e)
			{
				System.out.println("WavegenWizPos.getSummaryData():finally Block:"+e.getMessage());
				e.printStackTrace();
			}
		}
		return retXMLStr;
	}
	
	public InitialContext getInitialContext()throws ITMException
	{
		InitialContext ctx = null;
		try
		{
			AppConnectParm appConnect = new AppConnectParm();
			ctx = new InitialContext(appConnect.getProperty());
		}
		catch(ITMException itme)
		{
			System.out.println("WavegenWizPos.getInitialContext()");
			throw itme;
		}
		catch(Exception e)
		{
			System.out.println("WavegenWizPos.getInitialContext()"+e.getMessage());
			throw new ITMException(e);
		}
		return ctx;
	}
	
	private static String checkNull(String input)
	{
		if (input==null)
		{
			input="";
		}
		return input;
	}

}
